import { Injectable } from '@angular/core';
import { Effect, Actions } from '@ngrx/effects';

import { AppState } from '../reducers';
import { ItemActions } from '../actions';
import { EcmProductService } from '../../ecm-view/ecm-product/ecm-product.service';
import { EcmProductDetailService } from '../../ecm-product-details/ecm-product-detail.service';

@Injectable()
export class ItemEffects {
    constructor (
        private update$: Actions,
        private itemActions: ItemActions,
        private svc: EcmProductService,
        private svc1: EcmProductDetailService
    ) {}

    @Effect() loadItems$ = this.update$
        .ofType(ItemActions.LOAD_ITEMS)
        .switchMap(scatCode => this.svc.getItems(scatCode.payload))
        .map(items => this.itemActions.loadItemsSuccess(items));
    
    @Effect() getItem$ = this.update$
        .ofType(ItemActions.GET_ITEM)
        .switchMap(itemCode => this.svc1.getItemDetail(itemCode.payload))
        .map(item => this.itemActions.getItemSuccess(item));
}
