import { Component, Input } from '@angular/core';
export class BBLinkButtonComponent {
    constructor() {
        this.uxDesign = 'UX3';
        this.bbAutofocus = false;
        this.bbDisabled = false;
        this.appearance = '';
        this.role = '';
    }
}
BBLinkButtonComponent.decorators = [
    { type: Component, args: [{
                selector: 'bb-link-button',
                template: `

      <span [ngSwitch]="uxDesign">
      	<span *ngSwitchCase="'UX1'" [ngSwitch]="role">
      	      <span *ngSwitchCase="'link'"> 
         			<a [href]="!bbDisabled ? link : '#'" [class.roleDisabled]="bbDisabled" >
         			  <ng-container *ngTemplateOutlet="label"></ng-container>
         			</a>
      	      </span>	
	      
      	      <span *ngSwitchCase="'button'"> 
      	         <a  [href]="!bbDisabled ? link : '#'"  >
      	            <button [disabled]="bbDisabled"  [class.buttonDisabled]="bbDisabled">
      	         		<ng-container *ngTemplateOutlet="label"></ng-container>
      	         	</button>
      	         </a>
      	      </span>
      	</span> 
	
      	<span *ngSwitchCase="'UX3'" [ngSwitch]="role">
      	      <span *ngSwitchCase="'link'"> 
         			<a [href]="!bbDisabled ? link : '#'" [class.roleDisabled]="bbDisabled" >
         			  <ng-container *ngTemplateOutlet="label"></ng-container>
         			</a>
      	      </span>	
	      
      	      <span *ngSwitchCase="'button'"> 
      	         <a md-raised-button [href]="!bbDisabled ? link : '#'" [class.buttonDisabled]="bbDisabled" >
      	         	<ng-container *ngTemplateOutlet="label"></ng-container>
      	         </a>
      	      </span>
      	</span> 
	
      	<ng-template #label><ng-content></ng-content></ng-template>
      </span>
    `,
                styles: [`
      /*a.disabled {
         pointer-events: none;
         cursor: not-allowed; 
      }
      */
      a.roleDisabled{
       pointer-events: none;
       cursor: not-allowed; 
       color: rgba(0, 0, 0, 0.38);
  
      }

      a.buttonDisabled{
       pointer-events: none;
       cursor: not-allowed; 
       color: rgba(0, 0, 0, 0.38);
       background-color: rgba(0, 0, 0, 0.12); 
      }
    `]
            },] },
];
/** @nocollapse */
BBLinkButtonComponent.ctorParameters = () => [];
BBLinkButtonComponent.propDecorators = {
    'uxDesign': [{ type: Input, args: ['uxDesign',] },],
    'bbAutofocus': [{ type: Input, args: ['autofocus',] },],
    'bbDisabled': [{ type: Input, args: ['disabled',] },],
    'appearance': [{ type: Input, args: ['appearance',] },],
    'link': [{ type: Input, args: ['link',] },],
    'role': [{ type: Input, args: ['role',] },],
    'bbType': [{ type: Input, args: ['type',] },],
};
//# sourceMappingURL=bb-link-button.component.js.map