package ibase.e12ria.e12widgets.client;

import ibase.e12ria.e12widgets.client.Feed.FilterMode;

import java.util.ArrayList;
import java.util.List;

public class FeedsManager
{
    
    protected final List< Feed > feedList;
    protected List< Feed > filteredFeedList;
    protected FilterMode filterMode = FilterMode.MATCH_EXACT;
    
    public FeedsManager( List< Feed > feedList )
    {
        this.feedList = feedList;
        filteredFeedList = new ArrayList< Feed >( feedList );
    }
    
    public void setFilterMode( FilterMode filterMode )
    {
    	this.filterMode = filterMode;
    }
    
    public List< Feed > getFilteredFeeds()
    {
        return filteredFeedList;
    }

    /**
     * Filters the feeds according to specified criteria. Note that this does
     * not remove the feeds from the panel, just makes them invisible. They
     * will still be available in the panel.
     * 
     * @param fieldName Name of the field in the metadata on which filter
     *         has to be applied.
     * @param fieldValue Value of the data against which obtained field value
     *         should be matched.
     */
    public void filter( String fieldName, String fieldValue )
    {
    	if( "".equals( fieldValue ) )
    	{
    		removeFilter();
    		return;
    	}
    	
        hideAllFeeds();
        List< Feed > newFilteredFeedList = new ArrayList< Feed >();
        for( Feed feed : filteredFeedList )
        {
            if( feed.match( fieldName, fieldValue, filterMode ) )
            {
                feed.setVisible( true );
                newFilteredFeedList.add( feed );
            }
        }
        if( newFilteredFeedList.size() == 0 )
        {
            for( Feed feed : filteredFeedList )
            {
                feed.setVisible( true );
            }
            throw new IllegalStateException( "No match found." );
        }
        filteredFeedList = newFilteredFeedList;
    }

    /**
     * Removes any filter that has been applied, and shows the entire feed
     * list.
     */
    public void removeFilter()
    {
        for( Feed feed : feedList )
        {
            feed.setVisible( true );
        }
        filteredFeedList = feedList;
    }

    public void hideAllFeeds()
    {
        for( Feed feed : filteredFeedList )
        {
            feed.setVisible( false );
        }
    }
    
    public void showAllFeeds()
    {
        hideAllFeeds();
        for( Feed feed : filteredFeedList )
        {
            feed.setVisible( true );
        }
    }
    
    public void showSelectedFeeds()
    {
        hideAllFeeds();
        for( Feed feed : filteredFeedList )
        {
            if( feed.isSelected() )
            {
                feed.setVisible( true );
            }
        }
    }
    
    public void showUnselectedFeeds()
    {
        hideAllFeeds();
        for( Feed feed : filteredFeedList )
        {
            if( !feed.isSelected() )
            {
                feed.setVisible( true );
            }
        }
    }
    
    public void disableFeeds()
    {
    	for ( Feed feed : feedList )
    	{
    		feed.setEnabled( false );
    	}
    }

    //Added By Prajyot On 4/JAN/2012 [For filter depending upon mapFilterData set in Scan Metadata] ---------Start
    public void filter( String fieldName, String fieldValue, String mapFilterData )
    {
    	if( "".equals( fieldValue ) )
    	{
    		removeFilter();
    		return;
    	}
    	
        hideAllFeeds();
        List< Feed > newFilteredFeedList = new ArrayList< Feed >();
        
        List< Feed > selectedFeedList = new ArrayList< Feed >();
        List< Feed > notSelectedFeedList = new ArrayList< Feed >();
        
        for( Feed feed : filteredFeedList )
        {
            if( feed.isSelected() )
            {
            	selectedFeedList.add( feed );
            }
            else
            {
            	notSelectedFeedList.add( feed );
            }
        }
        
        if( "MAPPED".equalsIgnoreCase( mapFilterData ) )
        {
            for( Feed feed : selectedFeedList )
            {
                if( feed.match( fieldName, fieldValue, filterMode ) )
                {
                    feed.setVisible( true );
                    newFilteredFeedList.add( feed );
                }
            }
        }
        else if( "NOTMAPPED".equalsIgnoreCase( mapFilterData ) )
        {
            for( Feed feed : notSelectedFeedList )
            {
                if( feed.match( fieldName, fieldValue, filterMode ) )
                {
                    feed.setVisible( true );
                    newFilteredFeedList.add( feed );
                }
            }
        }
        else
        {
            for( Feed feed : notSelectedFeedList )
            {
                if( feed.match( fieldName, fieldValue, filterMode ) )
                {
                    feed.setVisible( true );
                    newFilteredFeedList.add( feed );
                }
            }
            for( Feed feed : selectedFeedList )
            {
                if( feed.match( fieldName, fieldValue, filterMode ) )
                {
                    feed.setVisible( true );
                    newFilteredFeedList.add( feed );
                }
            }
        }
        
        if( newFilteredFeedList.size() == 0 )
        {
            if( "MAPPED".equalsIgnoreCase( mapFilterData ) )
            {
                for( Feed feed : selectedFeedList )
                {
                    feed.setVisible( true );
                }
            }
            else if( "NOTMAPPED".equalsIgnoreCase( mapFilterData ) )
            {
                for( Feed feed : notSelectedFeedList )
                {
                    feed.setVisible( true );
                }
            }
            else
        	{
        		for( Feed feed : filteredFeedList )
        		{
        			feed.setVisible( true );
        		}
        	}
            throw new IllegalStateException( "No match found." );
        }
        filteredFeedList = newFilteredFeedList;
    }
    //Added By Prajyot On 4/JAN/2012 [For filter depending upon mapFilterData set in Scan Metadata] ---------End
}
