
package ibase.e12ria.e12widgets.client;

import java.util.HashMap;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;

public class E12CSSTabPanel extends Composite {

	private HashMap<Integer,String> tabTitles = new HashMap<Integer, String>();
	private HashMap<Integer,Widget> tabContents = new HashMap<Integer, Widget>();
	
	private SimplePanel panel;
	private Integer tabIdx = 1;
	private String uniqueID = "e12CSSTabPanel";
	
	private int activeTabIndex;
	
	public  E12CSSTabPanel() {
		uniqueID = uniqueID + Math.random() + "-";
		panel = new SimplePanel();
		initTabPanel();
		initWidget( panel );
		sinkEvents( Event.FOCUSEVENTS | Event.ONLOAD );
	}
	
	private void initTabPanel() 
	{
		panel.clear();
		HTML html = new HTML();
		String htmlContents = "<div id ='" + uniqueID + "' class='pcss3t pcss3t-effect-scale pcss3t-theme-1'></div>";
		html.setHTML(htmlContents);
		panel.add(html);
	}

	public void insert( String tabTitle, Widget tabWidget )
	{
		tabTitles.put(tabIdx, tabTitle);
		tabContents.put(tabIdx, tabWidget);
		tabIdx++;
	}
	
	@Override
	protected void onAttach() {
		super.onAttach();
		createTabs();
		printOnConsole( "uniqueID[" + uniqueID + "]");
	}

	private void createTabs()
	{
		initTabPanel();
		for( int idx = 1; idx < tabIdx; idx++ )
		{
			createTabTitle( idx, tabTitles.get(idx) );
			if( DOM.getElementById( uniqueID + "tabContainerUL" ) == null )
			{
				Element ulElem = Document.get().createULElement();
				ulElem.setId( uniqueID + "tabContainerUL");
				DOM.getElementById( uniqueID ).appendChild( ulElem );
			}
			SimplePanel simplePanel=new SimplePanel();
			simplePanel.getElement().setId( uniqueID + "tabContentPanel-" + idx);
			createTabContent( idx, simplePanel );
			addWidget(idx, tabContents.get(idx));
		}
		tabIdx = 1;
	}
	
	private void addWidget(int tabIdx, Widget tabWidget)
	{
		RootPanel.get( uniqueID + "tabContentPanel-" + tabIdx).add(tabWidget);
	}
	
	private void createTabTitle(int tabIdx, String tabTitle)
	{
		printOnConsole( "createTabTitle : tabTitle[" + tabTitle + "]");
		String className="tab-content-first";
		if( tabIdx > 1 )
		{
			className="tab-content-" + tabIdx ;
		}
		else if( tabIdx != 1 && tabIdx == tabTitles.size() )
		{
			className="tab-content-last";
		}
		
		Element inputElem = Document.get().createRadioInputElement("pcss3t");
		inputElem.setId( uniqueID + "tab" + tabIdx);
		inputElem.addClassName( className );
		if( tabIdx == 1 )
		{
			inputElem.setAttribute("checked", "checked");
			activeTabIndex = 1;
		}

		Element labelElm = Document.get().createLabelElement();
		labelElm.setAttribute("for", uniqueID + "tab" + tabIdx);
		labelElm.setInnerText(tabTitle);
		
		Element ulElement = DOM.getElementById( uniqueID + "tabContainerUL" );
		if( ulElement == null )
		{
			DOM.getElementById( uniqueID ).appendChild(inputElem);
			DOM.getElementById( uniqueID ).appendChild(labelElm);
		}
		else
		{
			DOM.getElementById( uniqueID ).insertBefore(inputElem, ulElement);
			DOM.getElementById( uniqueID ).insertBefore(labelElm, ulElement);
		}
	
	}
	
	private void createTabContent(int tabIdx, Widget tabWidget)
	{
		printOnConsole( "createTabContent : tabTitle[" + tabTitles.get(tabIdx) + "]");
		String className="tab-content tab-content-first typography";
		if( tabIdx > 1 )
		{
			className="tab-content tab-content-" + tabIdx + " typography";
		}
		else if( tabIdx != 1 && tabIdx == tabContents.size() )
		{
			className="tab-content tab-content-last typography";
		}
		
		Element liElem = Document.get().createLIElement();
		liElem.addClassName( className );
		liElem.appendChild( tabWidget.getElement() );
		
		DOM.getElementById( uniqueID + "tabContainerUL").appendChild( liElem );
	}
	
/*	@Override
	public void onBrowserEvent(Event event) {

		super.onBrowserEvent(event);
		EventTarget eventTarget = event.getEventTarget();
		printOnConsole( "uniqueID[" + uniqueID + "]");
		printOnConsole( "\n event.getType()[" + event.getType()+ "]");
		printOnConsole("\n eventTarget[" + eventTarget+ "]");
		if (!Element.is(eventTarget)) {
			return;
		}
		printOnConsole("\n eventTarget.getClass()[" + eventTarget.getClass()+ "]" );
		Element target = eventTarget.cast();
		printOnConsole("\n target[" + target+ "]" );
		switch (DOM.eventGetType(event)) {
		case Event.FOCUSEVENTS :
			printOnConsole("\n event[FOCUSEVENTS]" );
			break;
		case Event.ONLOAD :
			printOnConsole("\n event[ONLOAD]" );
			break;

		default:
			break;
		}
	}*/

	public native static void printOnConsole( String value )
	/*-{
		if( typeof window.console !== "undefined" )
		{
			console.log( value );
		}	
	}-*/;

	public void selectTab( int tabIndex ) 
	{
		if( DOM.getElementById( uniqueID + "tab" + tabIndex ) != null )
		{
			 DOM.getElementById( uniqueID + "tab" + tabIndex ).setAttribute("checked", "checked");
		}
	}

	public void selectActiveTab() 
	{
		if( DOM.getElementById( uniqueID + "tab" + activeTabIndex ) != null )
		{
			 DOM.getElementById( uniqueID + "tab" + activeTabIndex ).setAttribute("checked", "checked");
		}
	}

}	
	/*

 	<div class="pcss3t pcss3t-effect-scale pcss3t-theme-1">
	<input type="radio" name="pcss3t" checked="" id="tab1" class="tab-content-first">
	<label for="tab1"><i class="icon-bolt"></i>Tesla</label>
	
	<input type="radio" name="pcss3t" id="tab2" class="tab-content-2">
	<label for="tab2"><i class="icon-picture"></i>da Vinci</label>
	
	<input type="radio" name="pcss3t" id="tab3" class="tab-content-3">
	<label for="tab3"><i class="icon-cogs"></i>Einstein</label>
	
	<input type="radio" name="pcss3t" id="tab5" class="tab-content-last">
	<label for="tab5"><i class="icon-globe"></i>Newton</label>
	
	<ul>
		<li class="tab-content tab-content-first typography">
			<h1>Nikola Tesla</h1>
			<p>Serbian-American inventor, electrical engineer, mechanical engineer, physicist, and futurist best known for his contributions to the design of the modern alternating current (AC) electrical supply system.</p>
			<p>Tesla started working in the telephony and electrical fields before emigrating to the United States in 1884 to work for Thomas Edison. He soon struck out on his own with financial backers, setting up laboratories/companies to develop a range of electrical devices. His patented AC induction motor and transformer were licensed by George Westinghouse, who also hired Tesla as a consultant to help develop an alternating current system. Tesla is also known for his high-voltage, high-frequency power experiments in New York and Colorado Springs which included patented devices and theoretical work used in the invention of radio communication, for his X-ray experiments, and for his ill-fated attempt at intercontinental wireless transmission in his unfinished Wardenclyffe Tower project.</p>
			<p class="text-right"><em>Find out more about Nikola Tesla from <a href="http://en.wikipedia.org/wiki/Nikola_Tesla" target="_blank">Wikipedia</a>.</em></p>
		</li>
		
		<li class="tab-content tab-content-2 typography">
			<h1>Leonardo da Vinci</h1>
			<p>Italian Renaissance polymath: painter, sculptor, architect, musician, mathematician, engineer, inventor, anatomist, geologist, cartographer, botanist, and writer. His genius, perhaps more than that of any other figure, epitomized the Renaissance humanist ideal. Leonardo has often been described as the archetype of the Renaissance Man, a man of "unquenchable curiosity" and "feverishly inventive imagination". He is widely considered to be one of the greatest painters of all time and perhaps the most diversely talented person ever to have lived. According to art historian Helen Gardner, the scope and depth of his interests were without precedent and "his mind and personality seem to us superhuman, the man himself mysterious and remote". Marco Rosci states that while there is much speculation about Leonardo, his vision of the world is essentially logical rather than mysterious, and that the empirical methods he employed were unusual for his time.</p>
			<p class="text-right"><em>Find out more about Leonardo da Vinci from <a href="http://en.wikipedia.org/wiki/Leonardo_da_Vinci" target="_blank">Wikipedia</a>.</em></p>
		</li>
		
		<li class="tab-content tab-content-3 typography">
			<h1>Albert Einstein</h1>
			<p>German-born theoretical physicist who developed the general theory of relativity, one of the two pillars of modern physics (alongside quantum mechanics). While best known for his mass–energy equivalence formula E = mc2 (which has been dubbed "the world's most famous equation"), he received the 1921 Nobel Prize in Physics "for his services to theoretical physics, and especially for his discovery of the law of the photoelectric effect". The latter was pivotal in establishing quantum theory.</p>
			<p>Near the beginning of his career, Einstein thought that Newtonian mechanics was no longer enough to reconcile the laws of classical mechanics with the laws of the electromagnetic field. This led to the development of his special theory of relativity. He realized, however, that the principle of relativity could also be extended to gravitational fields, and with his subsequent theory of gravitation in 1916, he published a paper on the general theory of relativity.</p>
			<p class="text-right"><em>Find out more about Albert Einstein from <a href="http://en.wikipedia.org/wiki/Albert_Einstein" target="_blank">Wikipedia</a>.</em></p>				
		</li>
		
		<li class="tab-content tab-content-last typography">
			<div class="typography">
				<h1>Isaac Newton</h1>
				<p>English physicist and mathematician who is widely regarded as one of the most influential scientists of all time and as a key figure in the scientific revolution. His book Philosophiæ Naturalis Principia Mathematica ("Mathematical Principles of Natural Philosophy"), first published in 1687, laid the foundations for most of classical mechanics. Newton also made seminal contributions to optics and shares credit with Gottfried Leibniz for the invention of the infinitesimal calculus.</p>
				<p>Newton's Principia formulated the laws of motion and universal gravitation that dominated scientists' view of the physical universe for the next three centuries. It also demonstrated that the motion of objects on the Earth and that of celestial bodies could be described by the same principles. By deriving Kepler's laws of planetary motion from his mathematical description of gravity, Newton removed the last doubts about the validity of the heliocentric model of the cosmos.</p>
			<p class="text-right"><em>Find out more about Isaac Newton from <a href="http://en.wikipedia.org/wiki/Isaac_Newton" target="_blank">Wikipedia</a>.</em></p>		
			</div>
		</li>
	</ul>
</div>*/
