package ibase.webitm.ejb.fin;

import java.rmi.RemoteException;
import java.sql.*;
import java.text.*;

import ibase.utility.CommonConstants;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.utility.TransIDGenerator;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;

import java.text.SimpleDateFormat;
import java.util.*;

import ibase.webitm.utility.*;

import java.util.HashMap;

import ibase.webitm.ejb.*;

import org.w3c.dom.*;

import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.ejb.fin.FinCommon;

public class InvAcct
{
	FinCommon finCommon = new FinCommon();
	GenericUtility genericUtility = GenericUtility.getInstance(); 
	ValidatorEJB validator = new ValidatorEJB();
	public String acctPoRcpt(String tranId, Connection conn)throws ITMException
	{
		FinCommon finCommon = null;
        GenericUtility genericUtility = null;
		ITMDBAccessEJB itmDBAccessEJB = null;

		String sql = "",errString = "", errCode = "";
		PreparedStatement pstmt = null;
		PreparedStatement pstmt1 = null;
		PreparedStatement pstmtUpd = null;
		ResultSet rs = null;
		ResultSet rs1 = null;
		java.sql.Timestamp tranDate = null, effDate = null;

		String siteCode = "", suppCode = "", itemSer = "", currCode = "";
		String purcOrder = "", postType = "", postProv = "", analCode = "";

		double excRate = 0, addAmtHdr = 0, frtAmt = 0, insurAmt = 0, clearAmt = 0, adjTotAmount = 0, amountNP = 0;
		double othChgAmt = 0, excRateFrt = 0, excRateIns = 0, excRateClr = 0, excRateOthCh = 0,tempValue = 0, actualAmount = 0;

		String remarks = "", pordType = "", projCode = "", acctType = "", currCodeBase = "";
		String invOnline = "",vouchOnLine = "", invAcct = "", acctCodeChrg = "", cctrCodeChrg = "";
		boolean bExit = false, qcReqd = false;
		int qcCount  = 0;
		String finEntity = "", acctAP = "", cctrAP = "", acctAdCost = "", cctrAdCost = "";
		String acctFreCost = "", cctrFreCost = "", acctCleCost = "", cctrCleCost = "", acctInsCost = "", cctrInsCost = "";
		double amountCR = 0, netAmount = 0, addAmount = 0, quantity = 0, stdRate = 0, grAmount = 0, recoAmount = 0, stdAmount = 0, rateStduom = 0;

		String itemCode = "", lineNo = "", acctCodeCR = "", acctCodeDR = "", cctrCodeCR = "", cctrCodeDR = "", tranSer = "";
		String deptCode = "", acctCodeProvDR = "", acctCodeProvCR = "", cctrCodeProvDR = "", cctrCodeProvCR = "", mapKey = "";
		//double insurAmt = 0, clearAmt = 0, othChgAmt = 0, excRateFrt = 0, excRateIns = 0, excRateClr = 0, excRateOthCh = 0, amountNP = 0;
		HashMap poRcpMap = null, tempMap = null, glTraceMap = null;
		String acctCodePpv = "", cctrCodePpv = "", acctCodeReco = "", ccrtCodeReco = "", acctCodeNP = "", cctrCodeNP = "";
		String tranType="",analysis="";        // added by cpatil on 09-03-13
		String[] analysisStr =null;
		String analysis1__dr="",analysis2__dr="",analysis3__dr="",analysis1__cr="",analysis2__cr="",analysis3__cr="" ;
		
		try
		{
		
			finCommon = new FinCommon();
			genericUtility = GenericUtility.getInstance();
			itmDBAccessEJB = new ITMDBAccessEJB();

			sql = " SELECT TRAN_DATE, EFF_DATE, SITE_CODE, SUPP_CODE, " 
				+ " ITEM_SER, CURR_CODE, EXCH_RATE, TOTAL_ADDITIONAL_COST, PURC_ORDER, " 
				+ " POST_type,FRT_AMT,INSURANCE_AMT,CLEARING_CHARGES,OTHER_CHARGES, EXCH_RATE__FRT, " 
				+ " EXCH_RATE__INS, EXCH_RATE__CLR,EXCH_RATE__OTHCH, POST_PROV,ANAL_CODE, TRAN_SER, TRAN_TYPE "      // added by cpatil: tran_type 
				+ " FROM PORCP WHERE TRAN_ID = ? ";

			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,tranId);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				tranDate = rs.getTimestamp("TRAN_DATE");
				effDate = rs.getTimestamp("EFF_DATE");
				siteCode = rs.getString("SITE_CODE");
				suppCode = rs.getString("SUPP_CODE");
				itemSer = rs.getString("ITEM_SER");
				currCode = rs.getString("CURR_CODE");
				excRate = rs.getDouble("EXCH_RATE");
				addAmtHdr = rs.getDouble("TOTAL_ADDITIONAL_COST");
				purcOrder = rs.getString("PURC_ORDER");
				postType = rs.getString("POST_type");
				frtAmt = rs.getDouble("FRT_AMT");
				insurAmt = rs.getDouble("INSURANCE_AMT");
				clearAmt = rs.getDouble("CLEARING_CHARGES");
				othChgAmt = rs.getDouble("OTHER_CHARGES");
				excRateFrt = rs.getDouble("EXCH_RATE__FRT");
				excRateIns = rs.getDouble("EXCH_RATE__INS");
				excRateClr = rs.getDouble("EXCH_RATE__CLR");
				excRateOthCh = rs.getDouble("EXCH_RATE__OTHCH");
				postProv = rs.getString("POST_PROV");
				analCode = rs.getString("ANAL_CODE");
				tranSer = rs.getString("TRAN_SER");
				tranType = rs.getString("TRAN_TYPE");
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

			if (postType == null)
			{
				postType = "A";
			}
			remarks = "Against purchase order no. " + purcOrder.trim();
			
			sql = "SELECT PORD_type,PROJ_CODE FROM PORDER WHERE PURC_ORDER = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,purcOrder);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				pordType = rs.getString("PORD_TYPE");
				projCode = rs.getString("PROJ_CODE");
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			sql = "SELECT A.CURR_CODE  AS CURR_CODE FROM FINENT A, SITE B WHERE B.FIN_ENTITY = A.FIN_ENTITY AND B.SITE_CODE = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,siteCode);
			rs = pstmt.executeQuery();
			System.out.println("siteCode...>>>>>>>>>>>>>>>>>>>>>>::"+siteCode);
			if(rs.next())
			{
				currCodeBase = rs.getString(1);
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

			invOnline = finCommon.getFinparams("999999", "INV_ACCT_PORCP", conn);
			System.out.println("invOnline = ["+invOnline+"]");
			if ("NULLFOUND".equals(invOnline))
			{
				errCode = "VTFINPARM";
				errString = itmDBAccessEJB.getErrorString("",errCode,"","",conn);
				return errString;
			}

			if (!"Y".equals(invOnline) && !"N".equals(invOnline) && !"S".equals(invOnline) )
			{
				errCode = "VTFINPARM";
				errString = itmDBAccessEJB.getErrorString("",errCode,"","",conn);
				return errString;
			}
			
			vouchOnLine = finCommon.getFinparams("999999", "VOUCHER_CREATION", conn);
			System.out.println("vouchOnLine = ["+vouchOnLine+"]");
			if ("NULLFOUND".equals(vouchOnLine))
			{
				errCode = "VTFINPARM";
				errString = itmDBAccessEJB.getErrorString("",errCode,"","",conn);
				return errString;
			}
			if (invOnline == null || invOnline.trim().length() ==  0)
			{
				invOnline = "N";
			}	
			if (vouchOnLine == null || vouchOnLine.trim().length() == 0)
			{
				vouchOnLine = "N";
			}	
			bExit = false;
			
			if ("S".equals(invOnline))
			{
				sql = "SELECT CASE WHEN S.INV_ACCT IS NULL THEN 'N' ELSE S.INV_ACCT END AS INV_ACCT "
						+" FROM PORCPDET D, ITEM I, ITEMSER S "
						+ " WHERE D.ITEM_CODE = I.ITEM_CODE "
						+ " AND S.ITEM_SER = I.ITEM_SER "
						+ " AND D.TRAN_ID = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,siteCode);
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					invAcct = rs.getString("INV_ACCT");
					if (!"Y".equals(invAcct))
					{
						bExit = true;
						//break;
					}
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				if (bExit == true)
				{
					errCode = "VTFINPARM";
					errString = itmDBAccessEJB.getErrorString("",errCode,"","",conn);
					return errString;
				}
			}
			
			sql = "SELECT COUNT(QC_REQD) FROM ITEM "
				+ " WHERE ITEM_CODE IN (SELECT ITEM_CODE FROM PORCPDET "
				+ " WHERE TRAN_ID = ?) AND QC_REQD = 'Y'";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,tranId);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				qcCount = rs.getInt(1);
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			if (qcCount > 0)
			{
				qcReqd = true;
			}
			else	
			{
				qcReqd = false;
			}
			if ("Y".equals(invOnline) ||("S".equals(invOnline) && bExit != true))
			{
				sql = "SELECT FIN_ENTITY FROM SITE WHERE SITE_CODE = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,siteCode);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					finEntity = rs.getString(1);
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;

				if (postProv == null || postProv.trim().length() == 0 || "N".equals(postProv))
				{
					cctrAP = finCommon.getAcctDetrTtype(" ", itemSer, "PORCP", pordType, conn);
					if (cctrAP != null && cctrAP.trim().length() > 0)
					{
						acctAP = cctrAP.substring(0,cctrAP.indexOf(","));
						cctrAP = cctrAP.substring(cctrAP.indexOf(",")+1);
					}
					
					if (acctAP == null || acctAP.trim().length() == 0)
					{
						errCode = "VTACCTAP";
						errString = itmDBAccessEJB.getErrorString("",errCode,"","",conn);
						return errString;
					}
					if (cctrAP == null)
					{
						cctrAP = " ";
					}
				}
				
				cctrAdCost = finCommon.getAcctDetrTtype(" ", itemSer, "ADDCOST", pordType, conn);
				if (cctrAdCost != null && cctrAdCost.trim().length() > 0)
				{
					acctAdCost = cctrAdCost.substring(0,cctrAdCost.indexOf(","));
					cctrAdCost = cctrAdCost.substring(cctrAdCost.indexOf(",")+1);
				}

				cctrFreCost = finCommon.getAcctDetrTtype(" ", itemSer, "FRECOST", pordType, conn);
				if (cctrFreCost != null && cctrFreCost.trim().length() > 0)
				{
					acctFreCost = cctrFreCost.substring(0,cctrFreCost.indexOf(","));
					cctrFreCost = cctrFreCost.substring(cctrFreCost.indexOf(",")+1);
				}
				if (acctFreCost == null || acctFreCost.trim().length() == 0)
				{
					acctFreCost = acctAdCost;
					cctrFreCost = cctrAdCost;
				}
				
				cctrCleCost = finCommon.getAcctDetrTtype(" ", itemSer, "CLECOST", pordType, conn);
				if (cctrCleCost != null && cctrCleCost.trim().length() > 0)
				{
					acctCleCost = cctrCleCost.substring(0,cctrCleCost.indexOf(","));
					cctrCleCost = cctrCleCost.substring(cctrCleCost.indexOf(",")+1);
				}
				if (acctCleCost == null || acctCleCost.trim().length() == 0)
				{
					acctCleCost = acctAdCost;
					cctrCleCost = cctrAdCost;
				}
			
				cctrInsCost = finCommon.getAcctDetrTtype(" ", itemSer, "INSCOST", pordType, conn);
				if (cctrInsCost != null && cctrInsCost.trim().length() > 0)
				{
					acctInsCost = cctrInsCost.substring(0,cctrInsCost.indexOf(","));
					cctrInsCost = cctrInsCost.substring(cctrInsCost.indexOf(",")+1);
				}
				if (acctInsCost == null || acctInsCost.trim().length() == 0)
				{
					acctInsCost = acctAdCost;
					cctrInsCost = cctrAdCost;
				}
				amountCR = 0;
				if ( "Y".equals(invOnline) || ("S".equals(invOnline) && bExit == false))
				{
					poRcpMap = new HashMap();
					// Cursor to get PO Detail Data
					// In below select acct_code__prov_dr,acct_code__prov_cr,cctr_code__prov_dr,cctr_code__prov_cr-Added by fatema - 03/04/2007-DI7SUN0018
					sql = "select item_code, line_no, "
						+ " acct_code__cr, acct_code__dr,   "
						+ " cctr_code__cr, cctr_code__dr, (case when net_amt is null then 0 else net_amt end) as net_amt, " 
						+ "	(case when additional_cost is null then 0 else additional_cost end) as additional_cost, "
						+ "	quantity, std_rate,rate__stduom, dept_code, "
						+ " acct_code__prov_dr, acct_code__prov_cr, cctr_code__prov_dr, cctr_code__prov_cr "
						+ " from porcpdet where tran_id = ? " ;
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,tranId);
					rs = pstmt.executeQuery();
					int porcpDetCnt = 0;
					while (rs.next())
					{
						porcpDetCnt++;
						System.out.println("porcpDetCnt = ["+porcpDetCnt+"]");
						// In below fetch ls_adr_prov,ls_acr_prov,ls_cdr_prov,ls_ccr_prov-Added by fatema - 03/04/2007-DI7SUN0018
						itemCode = rs.getString("item_code");
						lineNo = rs.getString("line_no");
						acctCodeCR = rs.getString("acct_code__cr");
						acctCodeDR = rs.getString("acct_code__dr");
						cctrCodeCR = rs.getString("cctr_code__cr");
						cctrCodeDR = rs.getString("cctr_code__dr");
						netAmount = rs.getDouble("net_amt");
						addAmount = rs.getDouble("additional_cost");
						quantity = rs.getDouble("quantity");
						stdRate = rs.getDouble("std_rate");
						// 06/11/13 manoharan as per change in PB code
						rateStduom = rs.getDouble("rate__stduom");
						if (stdRate == -1)
						{
							stdRate = rateStduom;
						}
						// end 06/11/13 manoharan as per change in PB code
						deptCode = rs.getString("dept_code");
						acctCodeProvDR = rs.getString("acct_code__prov_dr");
						acctCodeProvCR = rs.getString("acct_code__prov_cr");
						cctrCodeProvDR = rs.getString("cctr_code__prov_dr");
						cctrCodeProvCR = rs.getString("cctr_code__prov_cr");
						if (cctrCodeDR == null || cctrCodeDR.trim().length() == 0 )
						{
							if (cctrCodeCR != null && cctrCodeCR.trim().length() > 0)
							{
								cctrCodeDR = cctrCodeCR;
							}
						}
						if (cctrCodeCR == null || cctrCodeCR.trim().length() == 0 )
						{
							if (cctrCodeDR == null && cctrCodeDR.trim().length() > 0)
							{
								cctrCodeCR = cctrCodeDR;
							}
						}
						// 28/10/02 end
						if (cctrAP == null || cctrAP.trim().length() == 0 )
						{
							cctrAP = cctrCodeCR;
						}
						//added by prince --13-10-06
						if (cctrFreCost == null || cctrFreCost.trim().length() == 0)
						{
							cctrFreCost = cctrCodeCR;
						}
						if (cctrCleCost == null || cctrCleCost.trim().length() == 0)
						{
							cctrCleCost = cctrCodeCR;
						}
						if (cctrInsCost == null || cctrInsCost.trim().length() == 0)
						{
							cctrInsCost = cctrCodeCR;
						}
						//ended by prince
						
						//dept code added by sandip 27/05/05
						if (deptCode == null || deptCode.trim().length() == 0)
						{
							deptCode = " ";
						}
						
						
						///////////////////////////////////////////////////////////////
						// ********************** IMPORTANT *************************//
						///////////////////////////////////////////////////////////////
						// 23/03/02 manoharan new column 'type' added in d_porcp
						// for additional cost it will be 'A' and all other amount
						// it will be 'X'
						// in all the dw find function it should be considered
						// because the acct/cctr will be same 
						// Purpose :- additional cost will be in base currency
						// posting should be done separately
													
						// Loop to process the Accounting Effect
						// 28/03/02 mamoharan based on old object
						amountCR = amountCR + netAmount;
						System.out.println("amountCR = ["+amountCR+"]");
						
						// Added by fatema - 03/04/2007 - DI7SUN0018
						if (postProv != null && "Y".equals(postProv))
						{
							acctAP = acctCodeProvCR;
							cctrAP = cctrCodeProvCR;
							
							if (acctAP  == null || acctAP.trim().length() == 0)
							{
								errCode = "VTPROVACCT";
								errString = itmDBAccessEJB.getErrorString("",errCode,"","",conn);
								break;
							}
							if (cctrAP == null)
							{
								cctrAP = " ";
							}
							
							acctCodeDR = acctCodeProvDR;
							cctrCodeDR = cctrCodeProvDR;
							
							if (acctCodeDR == null || acctCodeDR.trim().length() == 0)
							{
								errCode = "VTPROVACCT";
								errString = itmDBAccessEJB.getErrorString("",errCode,"","",conn);
								break;
							}
						}
						// Ended by fatema - 03/04/2007 - DI7SUN0018
						
						// If ACCT Code is NULL/SPACE Then Exit
						if (acctCodeDR == null || acctCodeDR.trim().length() == 0)
						{
							  errCode = "VTACCTPO";
							  errString = itmDBAccessEJB.getErrorString("",errCode,"","",conn);
							  break;
						}
						// If CCTR Code is NULL Then Space
						if (cctrCodeDR == null)
						{
							cctrCodeDR = " ";
						}
						System.out.println("postType ==================== ["+postType+"]");
						if ("S".equals(postType))
						{
							/// amish 05-10-04 // if post type is s then transaction to be post in base currency					
							currCode = currCodeBase;
							excRate = 1; 
							///////////////////end by amish 05-10-04

							/// amish pick up the ppv a/c and cctr				
							cctrCodePpv = finCommon.getAcctDetrTtype(" ", itemSer, "PPV", pordType, conn);
							if (cctrCodePpv != null && cctrCodePpv.trim().length() > 0)
							{
								acctCodePpv = cctrCodePpv.substring(0,cctrCodePpv.indexOf(","));
								cctrCodePpv = cctrCodePpv.substring(cctrCodePpv.indexOf(",")+1);
							}
							if (acctCodePpv == null || acctCodePpv.trim().length() == 0)
							{
							  errCode = "VTACCTPP";
							  errString = itmDBAccessEJB.getErrorString("",errCode,"","",conn);
							  break;
							}
						}
						// added by cpatil on 09-03-13 start
						
						//ls_analysis = nvo_fin.gbf_acct_analysis_ttype(ls_item,ls_tran_ser,ls_tran_type,)  
								analysis =  AcctAnalysisType(  itemCode,  tranSer,  tranType, "CR", conn);		
								//analysis =  gbf_acct_analysis_type(  itemCode,  tranSer,  tranType, "CR", conn);
								//ls_analysis1_cr = f_get_token(ls_analysis,'~t')			 
								//ls_analysis2_cr = f_get_token(ls_analysis,'~t')			 				
								//ls_analysis3_cr = f_get_token(ls_analysis,'~t')			 				
								//System.out.println("@@@@CR return analysis["+analysis+"]");
								//analysisStr = analysis.split("@@@@@@1 analysis::["+analysis+"]");
								analysisStr = analysis.split("@");
								int len = analysisStr.length-1;
								//System.out.println("@@@cr len["+len+"]");
								if( len > -1 )
								{
									analysis1__cr = analysisStr[0];
								}
								else
								{
									analysis1__cr = "";	
								}	
								if( len > 0 )
								{
									analysis2__cr = analysisStr[1];	
								}
								else
								{	
								  analysis2__cr = "";
								}
								if( len > 1)
								{
								analysis3__cr = analysisStr[2];
								}
								else
								{
									analysis3__cr ="";	
								}
								//System.out.println("@@@@@CR analysis1__cr["+analysis1__cr+"]:::analysis2__cr["+analysis2__cr+"]::::analysis3__cr["+analysis3__cr+"]");
								
						//ls_analysis = nvo_fin.gbf_acct_analysis_ttype(ls_item,ls_tran_ser,ls_tran_type,'DR')  
								//analysis =  gbf_acct_analysis_type(  itemCode,  tranSer,  tranType, "DR", conn);
								analysis =  AcctAnalysisType(  itemCode,  tranSer,  tranType, "DR", conn);
								//ls_analysis1_dr = f_get_token(ls_analysis,'~t')			 
								//ls_analysis2_dr = f_get_token(ls_analysis,'~t')			 				
								//ls_analysis3_dr = f_get_token(ls_analysis,'~t')	
								System.out.println("@@@@DR return analysis["+analysis+"]");
								//analysisStr = analysis.split("@@@@@@2 analysis::["+analysis+"]");
								
								analysisStr = analysis.split("@");
								len = analysisStr.length-1;
								System.out.println("@@@Dr len["+len+"]");
								if( len > -1)
								{
								  analysis1__dr = analysisStr[0];
								}
								else
								{
								  analysis1__dr = "";
								}
								if( len > 0)
								{
								  analysis2__dr = analysisStr[1];
								}
								else
								{
								  analysis2__dr = "";
								}
								if( len > 1)
								{
								  analysis3__dr = analysisStr[2];
								}
								else
								{
								  analysis3__dr ="";	
								}
								System.out.println("@@@@@DR analysis1__dr["+analysis1__dr+"]:::analysis2__dr["+analysis2__dr+"]::::analysis3__dr["+analysis3__dr+"]");
						//  end
						System.out.println("addAmount ==================== ["+addAmount+"]");
						if (addAmount != 0)
						{
							if (poRcpMap.containsKey("A" + acctCodeDR + cctrCodeDR + analysis1__dr + analysis2__dr + analysis3__dr ))
							{
								tempMap = (HashMap) poRcpMap.get("A" + acctCodeDR + cctrCodeDR + analysis1__dr + analysis2__dr + analysis3__dr );
								grAmount = Double.parseDouble(tempMap.get("amount").toString());
								System.out.println("tempMap[old] ==================== ["+tempMap+"]");
								//System.out.println("grAmount[old] ==================== ["+grAmount+"]");
								//System.out.println("netAmount[new] ==================== ["+netAmount+"]");
								tempMap.put("amount", grAmount + addAmount);
								System.out.println("tempMap[new] ==================== ["+tempMap+"]");
								// 07/11/13 manoharan added as this has to be updated in the porcpmap
								poRcpMap.put("A" + acctCodeDR + cctrCodeDR + analysis1__dr + analysis2__dr + analysis3__dr, tempMap);
							}
							else
							{
								tempMap = new HashMap();
								tempMap.put("type", "A");
								tempMap.put("acct_code", acctCodeDR);
								tempMap.put("cctr_code", cctrCodeDR);
								tempMap.put("amount", addAmount);
								// added by cpatil on 09-03-13 start
								tempMap.put("analysis1",analysis1__dr);
								tempMap.put("analysis2",analysis2__dr);
								tempMap.put("analysis3",analysis3__dr);
								// added by cpatil on 09-03-13 end

							}
							//poRcpMap.put("A" + acctCodeDR + cctrCodeDR, tempMap); // 07/11/13 manoharan commented and added following line
							poRcpMap.put("A" + acctCodeDR + cctrCodeDR + analysis1__dr + analysis2__dr + analysis3__dr, tempMap);
						}
						//System.out.println("poRcpMap[" + porcpDetCnt + "] 000==================== ["+poRcpMap+"]");

						if ("S".equals(postType))
						{
							// post inventory at standards						
							/// and diff to PPV a/c				
							stdAmount = quantity * stdRate;	
							
							if (stdAmount != 0)
							{
								if (poRcpMap.containsKey("X" + acctCodeDR + cctrCodeDR + analysis1__dr + analysis2__dr + analysis3__dr ))  //modify bay cpatil on 
								{
									tempMap = (HashMap) poRcpMap.get("X" + acctCodeDR + cctrCodeDR + analysis1__dr + analysis2__dr + analysis3__dr );
									System.out.println("tempMap[old] ==================== ["+tempMap+"]");
									grAmount = Double.parseDouble(tempMap.get("amount").toString());
									tempMap.put("amount", (grAmount + stdAmount));
									System.out.println("tempMap[new] ==================== ["+tempMap+"]");
									// 07/11/13 manoharan added as this has to be updated in the porcpmap
									poRcpMap.put("X" + acctCodeDR + cctrCodeDR + analysis1__dr + analysis2__dr + analysis3__dr, tempMap);
								}
								else
								{
									tempMap = new HashMap();
									tempMap.put("type", "X");
									tempMap.put("acct_code", acctCodeDR);
									tempMap.put("cctr_code", cctrCodeDR);
									tempMap.put("amount", stdAmount);
									// added by cpatil on 09-03-13 start
									tempMap.put("analysis1",analysis1__dr);
									tempMap.put("analysis2",analysis2__dr);
									tempMap.put("analysis3",analysis3__dr);
									// added by cpatil on 09-03-13 end
								}
								//poRcpMap.put("X" + acctCodeDR + cctrCodeDR, tempMap); // 07/11/13 manoharan commented and added following line
								poRcpMap.put("X" + acctCodeDR + cctrCodeDR + analysis1__dr + analysis2__dr + analysis3__dr, tempMap);
								System.out.println("poRcpMap[" + porcpDetCnt + "] 1 ==================== ["+poRcpMap+"]");
							}
						}		
						else						
						{
							System.out.println("netAmount ==================== ["+netAmount+"]");	
							if (netAmount != 0)
							{
								System.out.println("poRcpMap.containsKey(X + acctCodeDR + cctrCodeDR ) ==================== ["+(poRcpMap.containsKey("X" + acctCodeDR + cctrCodeDR ))+"]");
								if ( poRcpMap.containsKey("X" + acctCodeDR + cctrCodeDR + analysis1__dr + analysis2__dr + analysis3__dr ) )   // modify by cpatil on 09-03-13
								{
									tempMap = (HashMap) poRcpMap.get("X" + acctCodeDR + cctrCodeDR + analysis1__dr + analysis2__dr + analysis3__dr );
									grAmount = Double.parseDouble(tempMap.get("amount").toString());
									System.out.println("tempMap[old] ==================== ["+tempMap+"]");
									System.out.println("grAmount[old] ==================== ["+grAmount+"]");
									System.out.println("netAmount[new] ==================== ["+netAmount+"]");
									tempMap.put("amount", grAmount + netAmount);
									System.out.println("tempMap[new] ==================== ["+tempMap+"]");
									// 07/11/13 manoharan added as this has to be updated in the porcpmap
									poRcpMap.put("X" + acctCodeDR + cctrCodeDR + analysis1__dr + analysis2__dr + analysis3__dr, tempMap);
								}
								else
								{
									tempMap = new HashMap();
									tempMap.put("type", "X");
									tempMap.put("acct_code", acctCodeDR);
									tempMap.put("cctr_code", cctrCodeDR);
									tempMap.put("amount", netAmount);
									// added by cpatil on 09-03-13 start
									tempMap.put("analysis1",analysis1__dr);
									tempMap.put("analysis2",analysis2__dr);
									tempMap.put("analysis3",analysis3__dr);
									// added by cpatil on 09-03-13 end
								}
								//poRcpMap.put("X" + acctCodeDR + cctrCodeDR, tempMap); // 07/11/13 manoharan commented and added following line
								poRcpMap.put("X" + acctCodeDR + cctrCodeDR + analysis1__dr + analysis2__dr + analysis3__dr, tempMap);
								System.out.println("poRcpMap[" + porcpDetCnt + "] 2 ==================== ["+poRcpMap+"]");
							}
						}
						System.out.println("postType ==================== ["+postType+"]");
						if ("A".equals(postType))
						{
						
							// Cursor for Tax recovery for the item, if any
							sql = "SELECT ACCT_CODE__RECO,	CCTR_CODE__RECO, SUM(RECO_AMOUNT) AS RECO_AMOUNT "
								+ " FROM TAXTRAN "
								+ " WHERE TRAN_CODE= ?  "
								+ " AND TRAN_ID	= ? "
								+ " AND LINE_NO	= ? "
								+ " AND RECO_AMOUNT <> 0 "
								+ " GROUP BY ACCT_CODE__RECO, CCTR_CODE__RECO " ;
											
							pstmt1 = conn.prepareStatement(sql);
							pstmt1.setString(1,tranSer);
							pstmt1.setString(2,tranId);
							pstmt1.setString(3,lineNo);
							rs1 = pstmt1.executeQuery();
							while (rs1.next())
							{
								acctCodeReco = rs1.getString("ACCT_CODE__RECO");
								ccrtCodeReco = rs1.getString("CCTR_CODE__RECO");
								recoAmount  = rs1.getDouble("RECO_AMOUNT");
								if (acctCodeReco == null || acctCodeReco.trim().length() == 0)
								{
									// Selecting ACCT/CCTR Code from ITEM_ACCT_DETR Table
									// shiri 22/04/02 changed func call from gbf_acct_detr to gbf_acct_detr_type for a/cing on tran type
									ccrtCodeReco = finCommon.getAcctDetrTtype(itemCode, itemSer, "TAXRECO", pordType, conn);
									if (ccrtCodeReco != null && ccrtCodeReco.trim().length() > 0)
									{
										acctCodeReco = ccrtCodeReco.substring(0,ccrtCodeReco.indexOf(","));
										ccrtCodeReco = ccrtCodeReco.substring(ccrtCodeReco.indexOf(",")+1);
									}
								}
								
								// If ACCT Code is NULL/SPACE Then Exit
								if (acctCodeReco  == null || acctCodeReco.trim().length() == 0)
								{
									errCode = "VTACCTRECO";
									errString = itmDBAccessEJB.getErrorString("",errCode,"","",conn);
									break;
								}
								
								// If CCTR Code is NULL/SPACE Then set to inventory cost centre
								// 28/10/02 manoharan
								//if isnull(ccrtCodeReco) then
								if (ccrtCodeReco == null || ccrtCodeReco.trim().length() == 0)
								{
									// 28/10/02 end
									ccrtCodeReco = cctrCodeDR;
								}
							
								// If CCTR Code is still NULL/SPACE Then set to blank
								if (ccrtCodeReco ==  null)
								{
									ccrtCodeReco =  " ";
								}
								// the tax recovery amount is subtracted from the effect going to the inventory
								///amish for std acct
								tempMap = (HashMap) poRcpMap.get("X" + acctCodeDR + cctrCodeDR + analysis1__dr + analysis2__dr + analysis3__dr ); // 07/11/13 manoharan added
								tempMap.put("amount", grAmount - recoAmount);
								//poRcpMap.put("X" + acctCodeDR + cctrCodeDR, tempMap); // 07/11/13 manoharan commented and added following line
								poRcpMap.put("X" + acctCodeDR + cctrCodeDR + analysis1__dr + analysis2__dr + analysis3__dr, tempMap);
							
								////////////////////////////////////////////////////////////
								// 23/03/02 consider type additional cost should be posted 
								// separately
								if (poRcpMap.containsKey("X" + acctCodeReco + ccrtCodeReco + analysis1__dr + analysis2__dr + analysis3__dr))  // modify  by cpatil on 09-03-13 start
								{
									tempMap = (HashMap) poRcpMap.get("X" + acctCodeReco + ccrtCodeReco + analysis1__dr + analysis2__dr + analysis3__dr );
									grAmount = Double.parseDouble(tempMap.get("amount").toString());
									System.out.println("tempMap[old] ==================== ["+tempMap+"]");
									tempMap.put("amount", grAmount + recoAmount);
									System.out.println("tempMap[new] ==================== ["+tempMap+"]");
									// 07/11/13 manoharan added following line as the porcpmap to be replaced with the new amount
									poRcpMap.put("X" + acctCodeReco + ccrtCodeReco + analysis1__dr + analysis2__dr + analysis3__dr, tempMap);
								}
								else
								{
									tempMap = new HashMap();
									tempMap.put("type", "X");
									tempMap.put("acct_code", acctCodeDR);
									tempMap.put("cctr_code", cctrCodeDR);
									tempMap.put("amount", recoAmount);
									// added by cpatil on 09-03-13 start
									tempMap.put("analysis1",analysis1__dr);
									tempMap.put("analysis2",analysis2__dr);
									tempMap.put("analysis3",analysis3__dr);
									// added by cpatil on 09-03-13 end
								}
								//poRcpMap.put("X" + acctCodeReco + ccrtCodeReco, tempMap); // 07/11/13 manoharan commented and added following line
								poRcpMap.put("X" + acctCodeReco + ccrtCodeReco + analysis1__dr + analysis2__dr + analysis3__dr, tempMap); 
								System.out.println("poRcpMap[" + porcpDetCnt + "] 3 ==================== ["+poRcpMap+"]");
							}
							rs1.close();
							rs1 = null;
							pstmt1.close();
							pstmt1 = null;
							
							// If error then exit
							if (errString != null && errString.trim().length() > 0)
							{
								break;
							}
						
							// Cursor for non payable taxes to be removed from the effect to unbooked purchases
							sql = "SELECT A.ACCT_CODE, A.CCTR_CODE, SUM(A.TAX_AMT) AS TAX_AMT "
								+ " FROM TAXTRAN A, TAX B "
								+ " WHERE A.TAX_CODE = B.TAX_CODE "
								+ " AND A.TRAN_CODE = ? "
								+ " AND A.TRAN_ID = ? " 
								+ " AND A.LINE_NO = ? "
								+ " AND A.TAX_AMT <> 0 "
								+ " AND B.NON_PAYABLE = 'Y' "
								+ " GROUP BY A.ACCT_CODE, A.CCTR_CODE" ;
											
							pstmt1 = conn.prepareStatement(sql);
							pstmt1.setString(1,tranSer);
							pstmt1.setString(2,tranId);
							pstmt1.setString(3,lineNo);
							rs1 = pstmt1.executeQuery();
							while (rs1.next())
							{
							
								acctCodeNP = rs1.getString("ACCT_CODE");
								cctrCodeNP = rs1.getString("CCTR_CODE");
								amountNP = rs1.getDouble("TAX_AMT");
								
								// If ACCT Code is NULL/SPACE Then Exit
								if (acctCodeNP  == null || acctCodeNP.trim().length() == 0)
								{
									errCode = "VMACCT1";
									errString = itmDBAccessEJB.getErrorString("",errCode,"","",conn);
									break;
								}
								
								// If CCTR Code is NULL/SPACE Then set to inventory cost centre
								if (cctrCodeNP == null)
								{
									cctrCodeNP = cctrCodeDR;
								}
							
								// If CCTR Code is still NULL/SPACE Then set to blank
								if (cctrCodeNP == null)
								{
									cctrCodeNP = " ";
								}
							
								// before changing sign subtract from credit amount to go to unbooked purchases
								//amountCR = amountCR + netAmount - amountNP
								amountCR = amountCR - amountNP;
							
								// chnage sign so that it goes as credit
								amountNP = 0 - amountNP;
								////////////////////////////////////////////////////
								// 23/03/02 consider type - additional cost posting
								// separate
								//
								//// cr effect being generated for the non payable tax
								//ll_taxrow = poRcpMap.Find( &
								//		"acct_code = '"+ acctCodeNP + "' and cctr_code = '" + cctrCodeNP + "'", 1, ll_nbr);
								//if ll_taxrow = 0 then
								//	ll_taxrow = poRcpMap.insertrow(0)
								//	poRcpMap.setitem(ll_taxrow,"acct_code",acctCodeNP)
								//	poRcpMap.setitem(ll_taxrow,"cctr_code",cctrCodeNP)
								//	poRcpMap.setitem(ll_taxrow,"amount",amountNP)
								//elseif ll_taxrow > 0 then
								//	grAmount = poRcpMap.getitemnumber(ll_taxrow,"amount")
								//	poRcpMap.setitem(ll_taxrow,"amount",grAmount + amountNP)
								//end if
								// cr effect being generated for the non payable tax
								//ll_taxrow = poRcpMap.Find( &
								//		" type = 'X' and acct_code = '"+ acctCodeNP + "' and cctr_code = '" + cctrCodeNP + "'", 1, ll_nbr);
								// gf_nulltostr() called  to convert null to blank string by Amit on 19/09/03 for DB2.		

								if (poRcpMap.containsKey("X" + acctCodeNP + cctrCodeNP + analysis1__dr + analysis2__dr + analysis3__dr))  // modify  by cpatil on 09-03-13 start
								{
									tempMap = (HashMap) poRcpMap.get("X" + acctCodeReco + ccrtCodeReco + analysis1__dr + analysis2__dr + analysis3__dr );
									grAmount = Double.parseDouble(tempMap.get("amount").toString());
									System.out.println("tempMap[old] ==================== ["+tempMap+"]");
									tempMap.put("amount", grAmount + amountNP);
									System.out.println("tempMap[new] ==================== ["+tempMap+"]");
									// 07/11/13 manoharan added following line as the porcpmap to be replaced with the new amount
									poRcpMap.put("X" + acctCodeNP + cctrCodeNP + analysis1__dr + analysis2__dr + analysis3__dr, tempMap);
								}
								else
								{
									tempMap = new HashMap();
									tempMap.put("type", "X");
									tempMap.put("acct_code", acctCodeNP);
									tempMap.put("cctr_code", cctrCodeNP);
									tempMap.put("amount", amountNP);
									// added by cpatil on 09-03-13 start
									tempMap.put("analysis1",analysis1__dr);
									tempMap.put("analysis2",analysis2__dr);
									tempMap.put("analysis3",analysis3__dr);
									// added by cpatil on 09-03-13 end
								}
								//poRcpMap.put("X" + acctCodeNP + cctrCodeNP, tempMap); // 07/11/13 manoharan commented and added following line
								poRcpMap.put("X" + acctCodeNP + cctrCodeNP + analysis1__dr + analysis2__dr + analysis3__dr, tempMap);
								System.out.println("poRcpMap[" + porcpDetCnt + "] 4 ==================== ["+poRcpMap+"]");
							}
							rs1.close();
							rs1 = null;
							pstmt1.close();
							pstmt1 = null;
						} // post actual
						System.out.println("errString ==================== ["+errString+"]");
										
						///// this code if for posting ppv at grn
						//// amish for standard accounting
						/// post diff to PPV account.
						//if postType = 'S' then 					
						//	
						//	ll_nbr = poRcpMap.RowCount()
						//	
						//	netAmount = poRcpMap.getitemnumber(ll_foundrow,"net_amt")										
						//	lc_actual = addAmount + (netAmount * excRate) 
						//	stdAmount = quantity * stdRate	
						//	/// diff amt should be calculat in base curr
						//	lc_diffamt = lc_actual - ( stdAmount * excRate) 
						//	
						//	if lc_diffamt <> 0 then							
						//		
						//		ll_foundrow = poRcpMap.Find( &
						//				" type = 'A' and acct_code = '" + gf_nulltostr(acctCodeDR) +"' and cctr_code = '" + gf_nulltostr(cctrCodeDR) + "'", 1, ll_nbr);
						//		if ll_foundrow = 0 then
						//			ll_foundrow = poRcpMap.insertrow(0)
						//			poRcpMap.setitem(ll_foundrow,"type",'A')
						//			poRcpMap.setitem(ll_foundrow,"acct_code",acctCodePpv)
						//			poRcpMap.setitem(ll_foundrow,"cctr_code",cctrCodePpv)
						//			poRcpMap.setitem(ll_foundrow,"amount",lc_diffamt)
						//		elseif ll_foundrow > 0 then
						//			grAmount = poRcpMap.getitemnumber(ll_foundrow,"amount")
						//			poRcpMap.setitem(ll_foundrow,"amount",grAmount + lc_diffamt)
						//		end if						
						//	end if
						//	
						//end if
						// 19/01/2009 manoharan commented while sqlca.sqlcode  = 0 creating problem as
						// there were many other select statements inside the loop
						//
						// In below fetch acctCodeProvDR,acctCodeProvCR,cctrCodeProvDR,cctrCodeProvCR-Added by fatema - 03/04/2007-DI7SUN0018
						//fetch cur_rcpdet into :itemCode, :lineNo,
						//							:acctCodeCR, :acctCodeDR, 
						//							:cctrCodeCR, :cctrCodeDR, :netAmount, :addAmount, 
						//							:quantity, :stdRate, :deptCode, //dept code added by sandip 27/05/05
						//							:acctCodeProvDR, :acctCodeProvCR, :cctrCodeProvDR, :cctrCodeProvCR ;
						// end 19/01/2009 manoharan
					} // end porcpdet
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					
					// If error then exit
					if (errString != null && errString.trim().length() > 0)
					{
						return errString;
					}
					
					// Initialising the variable to ZERO
					netAmount = 0;
					grAmount = 0;
					actualAmount = 0;
					Map.Entry poRcpMapEntry =  null;
					Set poRcpSet = poRcpMap.entrySet();
					Iterator itrPoRcp = poRcpSet.iterator();
					int glTraceCtr = 0;
					System.out.println("07/11/13 poRcpMap final ==================== ["+poRcpMap+"]");
					while(itrPoRcp.hasNext())
					{
						poRcpMapEntry = (Map.Entry)itrPoRcp.next();
						mapKey = (String)poRcpMapEntry.getKey();
						tempMap = (HashMap)poRcpMap.get(mapKey);
						glTraceCtr++;
						System.out.println("manohar 07/11/13 glTraceCtr 1 [" + glTraceCtr + "] mapKey [" + mapKey + "] poRcpMapEntry [" + poRcpMapEntry + "] tempMap [" + tempMap + "]");
						// Debit Entry for Inventory / credit entry for non payable taxes
						acctCodeDR	= (String) tempMap.get("acct_code");
						cctrCodeDR	= (String) tempMap.get("cctr_code");
						grAmount = Double.parseDouble(tempMap.get("amount").toString());
						//actualAmount = poRcpMap.getitemnumber(i,"net_amt") //amish 
						//added by cpatil on 09-03-12 start 
						//glTraceMap.put("analysis1",analysis1");
						//glTraceMap.put("analysis2","analysis2");
						//glTraceMap.put("analysis3","analysis3");

						System.out.println("tempMap.get(analysis1):::"+tempMap.get("analysis1").toString());
						System.out.println("tempMap.get(analysis2):::"+tempMap.get("analysis2").toString());
						System.out.println("tempMap.get(analysis3):::"+tempMap.get("analysis3").toString());
						
						glTraceMap = new HashMap();
						glTraceMap.put("analysis1", (String) tempMap.get("analysis1"));
						glTraceMap.put("analysis2", (String) tempMap.get("analysis2"));
						glTraceMap.put("analysis3", (String) tempMap.get("analysis3"));

						//added by cpatil on 09-03-12 end								

						// shiri 22/12/01
						if ("P-RET".equals(tranSer))
						{
							grAmount = 0 - grAmount;
							//actualAmount = 0 - actualAmount //amish 
						}
						
						glTraceMap.put("tran_date",tranDate);
						glTraceMap.put("eff_date",effDate);
						glTraceMap.put("fin_entity",finEntity);
						glTraceMap.put("site_code",siteCode);
						glTraceMap.put("sundry_type","O");
						//glTraceMap.put("sundry_code",);
						glTraceMap.put("acct_code",acctCodeDR);
						glTraceMap.put("cctr_code",cctrCodeDR);
						//glTraceMap.put("emp_code",);
						glTraceMap.put("dept_code",deptCode);
						glTraceMap.put("proj_code",projCode);
						glTraceMap.put("anal_code ",analCode);

						if ("A".equals( (String) tempMap.get("type")) )
						{
							glTraceMap.put("curr_code",currCodeBase);
							glTraceMap.put("exch_rate", 1);
						}
						else
						{
							glTraceMap.put("curr_code",currCode);
							glTraceMap.put("exch_rate", excRate);
						}

						if (grAmount > 0 )
						{
							glTraceMap.put("dr_amt",grAmount);
							glTraceMap.put("cr_amt","0");
						}
						else
						{
							glTraceMap.put("dr_amt","0");
							glTraceMap.put("cr_amt",-1 * grAmount);
						}
						glTraceMap.put("ref_type","D");
						glTraceMap.put("ref_ser",tranSer);
						glTraceMap.put("ref_id",tranId);
						glTraceMap.put("remarks",remarks);
						System.out.println("manohar 07/11/13 glTraceCtr before gltrace update 2 [" + glTraceCtr + "]");
						errString = finCommon.glTraceUpdate(glTraceMap,conn);
						System.out.println("manohar 07/11/13 glTraceCtr after gltrace update 2 [" + glTraceCtr + "] errString [" + errString + "]");
						glTraceMap = null;
						if(errString != null && errString.trim().length() > 0 )
						{
							break;
						}
						///////////////////////////////////////////////////////////
						// 07/04/02 manoharan additional cost not to be added to net
						// because additonal cost of header will posted separately 
						if (!"A".equals( (String) tempMap.get("type")) )
						{
							netAmount = netAmount + grAmount;
							//if postType = 'S' then // amish 
							//	netAmount = netAmount + actualAmount
							//else							
							//	netAmount = netAmount + grAmount
							//end if

						}
							//////////// 07/04/02 //////////////////////////////////////
					}
					System.out.println("manohar 07/11/13 after posting poRcpMap  netAmount [" + netAmount + "] errString [" + errString + "]");
					if(errString != null && errString.trim().length() > 0 )
					{
						return errString;
					}
					///////////////////////////////////////////////////////////
					
					// Assigning the PO Receipt A/c & CC Code to the variable
					acctCodeCR = acctAP;
					cctrCodeCR = cctrAP;
					
					//shiri modified this posting instead of using netAmount, lc_amount_hdr is used so that the credit for
					//the additional cost can be taken separately in the posting - 29/11/01
					//on 20/12/01 used separate credit amount as it is net off non payable taxes
					// Crediting Entry for PO Receipt
					if (netAmount != 0 )
					{
						// the sign of netAmount is already reverted while recalculating
						//// shiri 22/12/01
						//if as_transer = 'P-RET' then
						//	netAmount = 0 - netAmount
						//end if	
						glTraceMap = new HashMap();

						glTraceMap.put("tran_date",tranDate);
						glTraceMap.put("eff_date",effDate);
						glTraceMap.put("fin_entity",finEntity);
						glTraceMap.put("site_code",siteCode);
						glTraceMap.put("sundry_type","O");
						glTraceMap.put("acct_code",acctCodeCR);
						glTraceMap.put("cctr_code",cctrCodeCR);
						glTraceMap.put("dept_code",deptCode);
						glTraceMap.put("anal_code ",analCode);
						glTraceMap.put("curr_code",currCode);
						glTraceMap.put("exch_rate", excRate);
						if (grAmount > 0 )
						{
							glTraceMap.put("dr_amt","0");
							glTraceMap.put("cr_amt",netAmount);
						}
						else
						{
							glTraceMap.put("dr_amt",-1 * netAmount);
							glTraceMap.put("cr_amt","0");
						}
						glTraceMap.put("ref_type","D");
						glTraceMap.put("ref_ser",tranSer);
						glTraceMap.put("ref_id",tranId);
						glTraceMap.put("remarks",remarks);
						// added by cpatil on 09-03-13 start   test
						glTraceMap.put("analysis1",analysis1__cr);
						glTraceMap.put("analysis2",analysis2__cr);
						glTraceMap.put("analysis3",analysis3__cr);
						// added by cpatil on 09-03-13 end
						
						
						errString = finCommon.glTraceUpdate(glTraceMap,conn);
						glTraceMap = null;
						if(errString != null && errString.trim().length() > 0 )
						{
							return errString;
						}
					}
					
					//credit entry for the additional cost
					//added by prince --31-05-06
					// if the total addnl cost entered does not match the break up, then the posting is to be done only for the total
					adjTotAmount = (frtAmt * excRateFrt) + (insurAmt * excRateIns) + (clearAmt * excRateClr) + (othChgAmt * excRateOthCh);
					
											
					if	(adjTotAmount != addAmtHdr)
					{
						//ended by prince	
						//if addAmtHdr <> 0 and postType = 'A' then 								
						if (addAmtHdr != 0 )  /// amish 30-12-04 post additional cost for standard and actual both
						{
							
							// if ACCT Code is NULL/SPACE Then Exit
							if (acctAdCost == null || acctAdCost.trim().length() == 0)
							{
								errCode = "VMACCT1";
								errString = itmDBAccessEJB.getErrorString("",errCode,"","",conn);
								return errString;
							}
									
							// if additional cost centre is null then set to ap cost centre
							if (cctrAdCost == null || cctrAdCost.trim().length() == 0)
							{
								cctrAdCost = cctrCodeCR;
							}
							// if additional cost centre is still null then set to space
							if (cctrAdCost == null )
							{
								cctrAdCost = " ";
							}
							
							// Ashok 14/02/03
							if ("P-RET".equals(tranSer))
							{
								addAmtHdr = -1 * addAmtHdr;
							}
							// End of changes on 14/02/03					
							glTraceMap = new HashMap();

							glTraceMap.put("tran_date",tranDate);
							glTraceMap.put("eff_date",effDate);
							glTraceMap.put("fin_entity",finEntity);
							glTraceMap.put("site_code",siteCode);
							glTraceMap.put("sundry_type","O");
							glTraceMap.put("acct_code",acctAdCost);
							glTraceMap.put("cctr_code",cctrAdCost);
							glTraceMap.put("dept_code",deptCode);

							glTraceMap.put("curr_code",currCodeBase);
							glTraceMap.put("exch_rate", 1);
							if (grAmount > 0 )
							{
								glTraceMap.put("dr_amt","0");
								glTraceMap.put("cr_amt",addAmtHdr);
							}
							else
							{
								glTraceMap.put("dr_amt",-1 * addAmtHdr);
								glTraceMap.put("cr_amt","0");
							}
							glTraceMap.put("ref_type","D");
							glTraceMap.put("ref_ser",tranSer);
							glTraceMap.put("ref_id",tranId);
							glTraceMap.put("remarks",remarks);
							// added by cpatil on 09-03-13 start test
							glTraceMap.put("analysis1",analysis1__cr);
							glTraceMap.put("analysis2",analysis2__cr);
							glTraceMap.put("analysis3",analysis3__cr);
							// added by cpatil on 09-03-13 end
							
							errString = finCommon.glTraceUpdate(glTraceMap,conn);
							glTraceMap = null;
							if(errString != null && errString.trim().length() > 0 )
							{
								return errString;
							}
						}
						//ended by prince 25-01-06
					}
					else
					{
						// if the total matches the break up, then individual posting is to be done
						//added by prince 27-01-06
						// reset this dw so that there is no previous data, as the posting will be done from the data now generated
						// all previous data has been already posted and has no use here
						poRcpMap = null;
						if (addAmtHdr != 0)
						{
							for ( int i = 1; i < 4; i++)
							{
								tempValue = 0;
								if (i == 1 && frtAmt != 0)
								{
									//tempValue = frtAmt //prince --28-10-06
									tempValue = frtAmt * excRateFrt; //prince --28-10-06
									acctCodeChrg = acctFreCost;
									cctrCodeChrg = cctrFreCost;
								}
								else if (i == 2 && insurAmt != 0)
								{
									//tempValue = insurAmt //prince --28-10-06
									tempValue = insurAmt * excRateIns;
									acctCodeChrg = acctInsCost;
									cctrCodeChrg = cctrInsCost;
								}
								else if (i == 3 && clearAmt != 0)
								{
									//tempValue = clearAmt //prince --28-10-06
									tempValue = clearAmt * excRateClr;
									acctCodeChrg = acctCleCost;
									cctrCodeChrg = cctrCleCost;
								}
								else if (i == 4 && othChgAmt != 0)
								{
									//tempValue = othChgAmt //prince --28-10-06
									tempValue = othChgAmt * excRateOthCh;
									acctCodeChrg = acctAdCost;
									cctrCodeChrg = cctrAdCost;
								}
								
								// if additional cost centre is null then set to ap cost centre
								if (cctrAdCost  == null || cctrAdCost.trim().length() == 0)
								{
									cctrAdCost = cctrCodeCR;
								}
								// if additional cost centre is still null then set to space
								if (cctrAdCost ==  null )
								{
									cctrAdCost = " ";
								}
								
								if (acctAdCost == null || acctAdCost.trim().length() == 0)
								{
									errCode = "VMACCT1";
									errString = itmDBAccessEJB.getErrorString("",errCode,"","",conn);
									break;
								}
																
								if (tempValue != 0)
								{
									if (poRcpMap.containsKey("A" + acctCodeChrg + cctrCodeChrg + analysis1__cr + analysis2__cr + analysis3__cr ))  // modify  by cpatil on 09-03-13 start
									{
										tempMap = (HashMap) poRcpMap.get("X" + acctCodeChrg + ccrtCodeReco + analysis1__cr + analysis2__cr + analysis3__cr );
										grAmount = Double.parseDouble(tempMap.get("amount").toString());
										tempMap.put("amount", grAmount + tempValue);
										// 07/11/13 manoharan added following line as the porcpmap to be replaced with the new amount
										poRcpMap.put("A" + acctCodeChrg + cctrCodeChrg + analysis1__cr + analysis2__cr + analysis3__cr, tempMap);
									}
									else
									{
										tempMap = new HashMap();
										tempMap.put("type", "A");
										tempMap.put("acct_code", acctCodeChrg);
										tempMap.put("cctr_code", cctrCodeChrg);
										tempMap.put("amount", tempValue);
										// added by cpatil on 09-03-13 start
										tempMap.put("analysis1",analysis1__cr);
										tempMap.put("analysis2",analysis2__cr);
										tempMap.put("analysis3",analysis3__cr);
										// added by cpatil on 09-03-13 end
									}
									//poRcpMap.put("A" + acctCodeChrg + cctrCodeChrg, tempMap); // 07/11/13 manoharan commented and added following line
									poRcpMap.put("A" + acctCodeChrg + cctrCodeChrg + analysis1__cr + analysis2__cr + analysis3__cr, tempMap);
								}
							}
						}
						if(errString != null && errString.trim().length() > 0 )
						{
							return errString;
						}

						poRcpMapEntry =  null;
						System.out.println("poRcpMap = "+poRcpMap);//Gulzar
						if ( poRcpMap != null )
						{
							poRcpSet = poRcpMap.entrySet();
							itrPoRcp = poRcpSet.iterator();
						}
						while(itrPoRcp.hasNext())
						{
							poRcpMapEntry = (Map.Entry)itrPoRcp.next();
							mapKey = (String)poRcpMapEntry.getKey();
							tempMap = (HashMap)poRcpMap.get(mapKey);
							
							// Debit Entry for Inventory / credit entry for non payable taxes
							acctCodeChrg	= (String) tempMap.get("acct_code");
							cctrCodeChrg	= (String) tempMap.get("cctr_code");
							tempValue = Double.parseDouble(tempMap.get("amount").toString());
							acctType =  (String) tempMap.get("type");
							
							if ("A".equals(acctType) && "P-RET".equals(tranSer))
							{
								tempValue = -1 * tempValue;
							}
							// End of changes on 14/02/03					
							glTraceMap = new HashMap();

							// added by cpatil on 09-03-13 start
							glTraceMap.put("analysis1",analysis1__cr);
							glTraceMap.put("analysis2",analysis2__cr);
							glTraceMap.put("analysis3",analysis3__cr);
							// added by cpatil on 09-03-13 end
							glTraceMap.put("tran_date",tranDate);
							glTraceMap.put("eff_date",effDate);
							glTraceMap.put("fin_entity",finEntity);
							glTraceMap.put("site_code",siteCode);
							glTraceMap.put("sundry_type","O");
							glTraceMap.put("acct_code",acctCodeChrg);
							glTraceMap.put("cctr_code",cctrCodeChrg);
							glTraceMap.put("dept_code",deptCode);

							glTraceMap.put("curr_code",currCodeBase);
							glTraceMap.put("exch_rate", 1);
							if (grAmount > 0 )
							{
								glTraceMap.put("dr_amt","0");
								glTraceMap.put("cr_amt",tempValue);
							}
							else
							{
								glTraceMap.put("dr_amt",-1 * tempValue);
								glTraceMap.put("cr_amt","0");
							}
							glTraceMap.put("ref_type","D");
							glTraceMap.put("ref_ser",tranSer);
							glTraceMap.put("ref_id",tranId);
							glTraceMap.put("remarks",remarks);
							
							errString = finCommon.glTraceUpdate(glTraceMap,conn);
							glTraceMap = null;
							if(errString != null && errString.trim().length() > 0 )
							{
								return errString;
							}
						}
					}
					//ended by prince

					//--------------------
					// 28/09/00 manoharan check coin diff.

					if(errString != null && errString.trim().length() > 0 )
					{
						return errString;
					}
					errString = finCommon.checkGlTranDrCr(tranSer,tranId,conn);
					if(errString != null && errString.trim().length() > 0)
					{
						return errString;
					}
					//--------------------------
				} // inventory accounting on
			} // inventory accounting on
			
			// If QC is required OR Create Voucher Online is No Then
			// Debit the Inventory & Credit PO Receipt
			
			// amit-26-04-02

			if (qcReqd == false && "Y".equals(vouchOnLine))
			{
				errString = "CREATE-VOUCHER";
			}
			sql = "update porcp set acct_inv_online = ?, acct_porcp_online = ? "
				+ " where tran_id = ? ";
			pstmtUpd = conn.prepareStatement(sql);
			pstmtUpd.setString(1,invOnline);
			pstmtUpd.setString(2,vouchOnLine);
			pstmtUpd.setString(3,tranId);
			pstmtUpd.executeUpdate();
			// end - amit-26-04-02
		}//try
		catch(Exception exception)
		{   
			exception.printStackTrace();
			throw new ITMException(exception);
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close(); rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close(); pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
	    return (errString);
	}
	
////added by cpatil..... migrate pb code into java on 09-03-13 start 
	//public String gbf_acct_analysis_type( String itemCode, String refSer, String tranType,String drcr,Connection conn) throws RemoteException, ITMException, SQLException
	public String AcctAnalysisType( String itemCode, String refSer, String tranType,String drcr,Connection conn) throws RemoteException, ITMException, SQLException        //// change the method name gbf_acct_analysis_type to AcctAnalysisType on 22/07/13 as per manoharan sir suggestion
	{
		
		String analysis1__dr="",analysis2__dr="",analysis3__dr="",analysis1__cr="",analysis2__cr="",analysis3__cr="" , analysis="";
		String sql="";
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		//String itemCode="", refSer="", tranType="";
		int rCnt=0;
		
		if ( itemCode != null && itemCode.trim().length() > 0)
		{
			itemCode=itemCode.trim();
		}
		if ( refSer != null && refSer.trim().length() > 0)
		{
			refSer=refSer.trim();
		}
		if ( tranType != null && tranType.trim().length() > 0)
		{
			tranType=tranType.trim();
		}
		
			sql = " select analysis1__dr,analysis2__dr,analysis3__dr,analysis1__cr,analysis2__cr,analysis3__cr " +
			      " from item_acct_analysis where item_code = ? and tran_ser = ? and tran_type = ? " ;
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,itemCode );
			pstmt.setString(2,refSer );
			pstmt.setString(3,tranType );
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				analysis1__dr=rs.getString("analysis1__dr");
				analysis2__dr=rs.getString("analysis2__dr");
				analysis3__dr=rs.getString("analysis3__dr");
				analysis1__cr=rs.getString("analysis1__cr");
				analysis2__cr=rs.getString("analysis2__cr");
				analysis3__cr=rs.getString("analysis3__cr");
				rCnt++;
			}
			if( rs != null )
			{
				rs.close();
				rs = null;
			}
			if( pstmt != null )
			{
					pstmt.close();
					pstmt = null;
			}
			
			if( rCnt == 0)	
			{
				sql = " select analysis1__dr,analysis2__dr,analysis3__dr,analysis1__cr,analysis2__cr,analysis3__cr " +
					      " from item_acct_analysis where tran_ser = ? and item_code = ? AND ( tran_type is null or tran_type = ' ' ) ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,refSer );
					pstmt.setString(2,itemCode );
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						analysis1__dr=rs.getString("analysis1__dr");
						analysis2__dr=rs.getString("analysis2__dr");
						analysis3__dr=rs.getString("analysis3__dr");
						analysis1__cr=rs.getString("analysis1__cr");
						analysis2__cr=rs.getString("analysis2__cr");
						analysis3__cr=rs.getString("analysis3__cr");
						rCnt++;
					}
					if( rs != null )
					{
						rs.close();
						rs = null;
					}
					if( pstmt != null )
					{
							pstmt.close();
							pstmt = null;
					}
			}
			
			if( rCnt == 0 )
			{
						sql = " select analysis1__dr,analysis2__dr,analysis3__dr,analysis1__cr,analysis2__cr,analysis3__cr " +
								 " from item_acct_analysis where tran_ser = ?  and ( item_code is null or item_code = ' ' ) " +
								 " AND ( tran_type is null or tran_type = ' ' )";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1,refSer );
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								analysis1__dr=rs.getString("analysis1__dr");
								analysis2__dr=rs.getString("analysis2__dr");
								analysis3__dr=rs.getString("analysis3__dr");
								analysis1__cr=rs.getString("analysis1__cr");
								analysis2__cr=rs.getString("analysis2__cr");
								analysis3__cr=rs.getString("analysis3__cr");
							}
							if( rs != null )
							{
								rs.close();
								rs = null;
							}
							if( pstmt != null )
							{
									pstmt.close();
									pstmt = null;
							}
			}
			
			analysis1__dr = checkNull( analysis1__dr );	
			analysis2__dr = checkNull( analysis2__dr );	
			analysis3__dr = checkNull( analysis3__dr );			
			analysis1__cr = checkNull( analysis1__cr );	
			analysis2__cr = checkNull( analysis2__cr );	
			analysis3__cr = checkNull( analysis3__cr );	
			
			System.out.println("@@@@ analysis1__dr["+analysis1__dr+"]::analysis2__dr["+analysis2__dr+"]::analysis3__dr["+analysis3__dr+"]");
			System.out.println("@@@@ analysis1__cr["+analysis1__cr+"]::analysis2__cr["+analysis2__cr+"]::analysis3__cr["+analysis3__cr+"]");					
			System.out.println("@@@@ drcr::::["+drcr+"]");
			
			if ("CR".equalsIgnoreCase(drcr))
			{
				analysis = analysis1__cr+"@"+analysis2__cr+"@"+analysis3__cr;
			}
			else
			{
				analysis = analysis1__dr+"@"+analysis2__dr+"@"+analysis3__dr;
			}
			
			System.out.println("@@@@ analysis::::["+analysis+"]");
			
	return analysis	;		
	}
	
	private String checkNull( String input )
	{
		if( input == null )
		{
			input = "";
		}
		else
		{
			input = input.trim();
		}
		return input;
	}
	//// added by cpatil..... migrate pb code into java on 09-03-13 end
	//added by sbehera ---migrating pb code on 31.07.13
	public String retreiveStockTrans(String tranId, Connection conn) throws ITMException{
		System.out.println("<-------Inside retrieve stock transfer------->");
		PreparedStatement pstmt=null;
		ResultSet rs=null;
		ResultSet rs1=null;
		PreparedStatement pstmt1=null;
		String sql="";
		ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
		FinCommon finCommon= new FinCommon();
		DistCommon distCommon = new DistCommon();
		String retString="";
		String errString="";
		
		java.sql.Timestamp tranDate=null;
		java.sql.Timestamp confDate=null;
		java.sql.Timestamp refDate=null;
		java.sql.Timestamp effDate=null;
		
		HashMap glTraceMap = null;
		HashMap stkmap=new HashMap();
		String combination="";
		//variables of Stock Transfer		
		String siteCode="",refserFor="",refIdFor="", reasCode="", confirmed="", itemSer="";
		String empCodeAprv="", tranType="",truckNo=""; 
		
		//variables of Stock Transfer Detail
		String lineNo="", itemCode="", locCodeFrom="", locCodeTo="", lotNoFrom="";
		String lotNoTo="", lotslFrom="", lotslTo="", remarks="", acctCodCr="", acctCodDr="";
		String cctrCodeCr="", cctrCodeDr="", locCodeSys="";
		int noArt=0, count=0;
		double quantity=0.0;
		
		//variable from pb comp.
		String invOnline="", finEntity="", currCode="";
		double amount=0, rate=0, exchRate=1;
		String mcctrCode="", macctCode="", analysis="",analysis1="", analysis2="", analysis3="", stkList="";
		int sum=0;
		ITMDBAccessEJB itmDBAccess = new ITMDBAccessEJB();
		try{
			
			invOnline=distCommon.getDisparams("999999", "INV_ACCT_TRF", conn);
			if(invOnline==null||invOnline.trim().length()==0){
				errString = itmDBAccessEJB.getErrorString("","VTFINPARM","","",conn);
				return errString;		
			}
			if ("Y".equals(invOnline)) // 06/11/13 manoharan condition added
			{
				sql =" select tran_date,site_code,ref_ser__for,ref_id__for,reas_code,item_ser, "
						+" confirmed,conf_date,emp_code__aprv,tran_type,truck_no,ref_date "
						+" from stock_transfer "   
						+" where tran_id = ? " ;
				pstmt=conn.prepareStatement(sql);
				pstmt.setString(1, tranId);
				rs=pstmt.executeQuery();
				if(rs.next()){
					tranDate = rs.getTimestamp("tran_date");
					siteCode = rs.getString("site_code");
					refserFor= rs.getString("ref_ser__for");
					refIdFor = rs.getString("ref_id__for");
					reasCode = rs.getString("reas_code");
					itemSer  = rs.getString("item_ser");
					confirmed= rs.getString("confirmed");
					confDate = rs.getTimestamp("conf_date");
					empCodeAprv=rs.getString("emp_code__aprv");
					tranType = rs.getString("tran_type");
					truckNo = rs.getString("truck_no");
					refDate = rs.getTimestamp("ref_date");
					System.out.println("@@@siteCode"+siteCode);
				}
				rs.close();
				rs=null;
				pstmt.close();
				pstmt=null;
				sql="select count(*) from stock_transfer_det where tran_id = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,tranId);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					count =rs.getInt(1);
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				
				if(count <= 0)	
				{
					System.out.println("no record found in stock_transfer_det");
					errString = itmDBAccessEJB.getErrorString("","VTNOREC2","","",conn);
					return errString;
				}
				sql =" select line_no,item_code,quantity,loc_code__fr,loc_code__to,lot_no__fr, "
						+" lot_no__to,lot_sl__fr,lot_sl__to,remarks,acct_code__cr,acct_code__dr, "
						+" cctr_code__dr,cctr_code__cr,no_art,loc_code__sys"
						+" from stock_transfer_det "   
						+" where tran_id = ? " ;
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,tranId);
				rs = pstmt.executeQuery();
				while(rs.next()){
					
					lineNo=rs.getString("line_no");
					itemCode=rs.getString("item_code");
					quantity=rs.getDouble("quantity");
					locCodeFrom=rs.getString("loc_code__fr");
					locCodeTo=rs.getString("loc_code__to");
					lotNoFrom=rs.getString("lot_no__fr");
					lotNoTo=rs.getString("lot_no__to");
					lotslFrom=rs.getString("lot_sl__fr");
					lotslTo=rs.getString("lot_sl__to");
					remarks=rs.getString("remarks");
					acctCodCr=rs.getString("acct_code__cr");
					acctCodDr=rs.getString("acct_code__dr");
					cctrCodeDr=rs.getString("cctr_code__dr");
					cctrCodeCr=rs.getString("cctr_code__cr");
					noArt=rs.getInt("no_art");
					locCodeSys=rs.getString("loc_code__sys");
				//Condition2 from pb comp.
				sql="select fin_entity from site where site_code=? ";
				pstmt1 = conn.prepareStatement(sql);
				pstmt1.setString(1,siteCode);
				rs1 = pstmt1.executeQuery();
				if(rs1.next()){
					finEntity=rs1.getString("fin_entity");
					
				}else{
					errString = itmDBAccessEJB.getErrorString("","DS000","","",conn);
					return errString;	
				}
				rs1.close();
				rs1=null;
				pstmt1.close();
				pstmt1=null;
				
				//Condition3 from pb comp.
				sql="select curr_code from finent where fin_entity=?";
				pstmt1 = conn.prepareStatement(sql);
				pstmt1.setString(1,finEntity);
				rs1 = pstmt1.executeQuery();
				if(rs1.next()){
					currCode=rs1.getString("curr_code");
					
				}else{
					errString = itmDBAccessEJB.getErrorString("","DS000","","",conn);
					return errString;	
				}
				rs1.close();
				rs1=null;
				pstmt1.close();
				pstmt1=null;
				
				
				//condition 4
				sql="select rate from stock where item_code=? and site_code=? and loc_code=? and lot_no=? and lot_sl=?";
				pstmt1 = conn.prepareStatement(sql);
				pstmt1.setString(1,itemCode);
				pstmt1.setString(2, siteCode);
				pstmt1.setString(3, locCodeFrom);
				pstmt1.setString(4, lotNoFrom);
				pstmt1.setString(5, lotslFrom);
				rs1 = pstmt1.executeQuery();
				if(rs1.next()){
					rate=rs1.getDouble("rate");
					
				}else{
					errString = itmDBAccessEJB.getErrorString("","DS000","","",conn);
					return errString;	
				}
				
				rs1.close();
				rs1=null;
				pstmt1.close();
				pstmt1=null;
				
				//1st- Add to glTrace
				amount=quantity*rate;
				System.out.println("@@@@@@@amount@@@@@@"+amount);
				glTraceMap=new HashMap();
				glTraceMap.put("tran_date", tranDate);
				glTraceMap.put("eff_date", tranDate);
				glTraceMap.put("fin_entity", finEntity);
				glTraceMap.put("site_code", siteCode);
				glTraceMap.put("sundry_type", 'O');
				glTraceMap.put("acct_code", acctCodDr);
				glTraceMap.put("cctr_code", cctrCodeDr);
				glTraceMap.put("curr_code", currCode);
				glTraceMap.put("exch_rate", exchRate);
				glTraceMap.put("dr_amt", amount);
				glTraceMap.put("cr_amt", 0);
				glTraceMap.put("ref_type", "");
				glTraceMap.put("ref_ser", refserFor);
				glTraceMap.put("ref_id", tranId);
				glTraceMap.put("remarks", remarks);
				
				
				errString=finCommon.glTraceUpdate(glTraceMap, conn);
				System.out.println("errString@@@@@@"+errString);
				if(errString != null && errString.trim().length() > 0)
				{
					System.out.println("errString---inside"+errString);
					return errString;
				}
				//2nd part	
				glTraceMap.put("tran_date", tranDate);
				glTraceMap.put("eff_date", tranDate);
				glTraceMap.put("fin_entity", finEntity);
				glTraceMap.put("site_code", siteCode);
				glTraceMap.put("sundry_type", 'O');
				glTraceMap.put("acct_code", acctCodCr);
				glTraceMap.put("cctr_code", cctrCodeCr);
				glTraceMap.put("curr_code", currCode);
				glTraceMap.put("exch_rate", exchRate);
				glTraceMap.put("dr_amt", 0);
				glTraceMap.put("cr_amt", amount);
				glTraceMap.put("ref_type", "");
				glTraceMap.put("ref_ser", refserFor);
				glTraceMap.put("ref_id", tranId);
				glTraceMap.put("remarks", remarks);
				errString=finCommon.glTraceUpdate(glTraceMap, conn);
				if(errString != null && errString.trim().length() > 0)
				{
					return errString;
				}
				String temp=finCommon.getAcctDetrTtype(itemCode, " ", "XFRX", tranType, conn);
				String split[]=temp.split(",");
				if(split==null || split.length==0){
					
					errString = itmDBAccessEJB.getErrorString("","VTACTCDND","","",conn);
					return errString;	
				}
				
				macctCode=split[0];
				if(split.length==2)
					mcctrCode=split[1];
				
				combination=macctCode+"@"+mcctrCode;
				System.out.println("combination::"+combination);
				
				
				
				
				
				if(!stkmap.containsKey(combination)){
					stkmap.put(combination, amount);
				}else{
					
					stkmap.put(combination,(Double)stkmap.get(combination)+amount);
					System.out.println("get value::::"+(Double)stkmap.get(combination)+(amount));
				}	
				
					
				}
				rs.close();
				rs=null;
				pstmt.close();
				pstmt=null;
				
				
				Set keyset=stkmap.keySet();
				Iterator itr=keyset.iterator();
				
				while(itr.hasNext()){
					String key=(String)itr.next();
				String split1[]=key.split("@");
				if(split1!=null || split1.length>0)
				{
					macctCode=split1[0];
					if(split1.length==2)
						mcctrCode=split1[1];
				}
				
				
				
				
				glTraceMap.put("tran_date", tranDate);
				glTraceMap.put("eff_date", tranDate);	
				glTraceMap.put("fin_entity", finEntity);
				glTraceMap.put("site_code", siteCode);
				glTraceMap.put("sundry_type", 'O');
				
				if((macctCode==null)||(macctCode.trim().length()==0))	
				{
					errString = itmDBAccessEJB.getErrorString("","VTACTCDND","","",conn);
					return errString;	
				}else{
					glTraceMap.put("acct_code", macctCode);
				}
				if((mcctrCode==null)||(mcctrCode.trim().length()==0))
				{
					glTraceMap.put("cctr_code", cctrCodeCr);
				}
				else
				{
					glTraceMap.put("cctr_code", mcctrCode);
				}
				
				glTraceMap.put("curr_code", currCode);
				glTraceMap.put("exch_rate", exchRate);
				glTraceMap.put("dr_amt", 0);
				glTraceMap.put("cr_amt", (stkmap.get(combination)));
				glTraceMap.put("ref_ser", refserFor);
				glTraceMap.put("ref_id", tranId);
				glTraceMap.put("remarks", remarks);
				errString=finCommon.glTraceUpdate(glTraceMap, conn);
				
				if(errString != null && errString.trim().length() > 0)
				{
						return errString;
				}
		
				
				glTraceMap.put("tran_date", tranDate);
				glTraceMap.put("eff_date", tranDate);
				glTraceMap.put("fin_entity", finEntity);
				glTraceMap.put("site_code", siteCode);
				glTraceMap.put("sundry_type", 'O');
				glTraceMap.put("acct_code", macctCode);
				
				if((mcctrCode==null)||(mcctrCode.trim().length()==0))
				{
					glTraceMap.put("cctr_code", cctrCodeCr);
				}
				else
				{
					glTraceMap.put("cctr_code", mcctrCode);
				}
				glTraceMap.put("curr_code", currCode);
				glTraceMap.put("exch_rate", exchRate);
				glTraceMap.put("dr_amt", (stkmap.get(combination)));
				glTraceMap.put("cr_amt", 0);
				glTraceMap.put("ref_type", "");
				glTraceMap.put("ref_ser", refserFor);
				glTraceMap.put("ref_id", tranId);
				glTraceMap.put("remarks", remarks);
				errString=finCommon.glTraceUpdate(glTraceMap, conn);
					if(errString != null && errString.trim().length() > 0)
					{
						return errString;
					}
					
				}
				
				errString=finCommon.checkGlTranDrCr(refserFor, tranId, conn);
				if(errString != null && errString.trim().length() > 0)
				{
					errString=itmDBAccess.getErrorString("","VCOINDIFF1","");	
					return errString;
				}
				
				System.out.println("all correct");
			}
	
		}catch(Exception e){
			System.out.println("Exception :StockTransferConf :retreiveStockTrans :==>"+e.getMessage());
			errString = GenericUtility.getInstance().createErrorString(e);
			throw new ITMException(e);
		}finally{

			try
			{				
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				System.out.println("Exception : "+e);e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return errString;
	}

	public String stkAdjust(String tranId,String lineNo, Connection conn)throws ITMException
	{
		System.out.println("Enter in stkAdjust >>");
		String siteCode="",itemCode ="",locCode="",lotNo="",lotSl="",itemSer="",acctCode="",cctrCode="";
		String getAcctCctr="",errString="";
		String[] values;
		double Rate,oldRate,amt,amt_old,diffAmt;
		HashMap updateAcctMap =new HashMap();
		ResultSet rs=null,rs1=null;
		String confirmed = "";
		PreparedStatement pstmt=null,pstmt1=null;
		String sql="",sql1="",acctCdInv="",acctCdInvR="",cctrCdInv="",cctrCdInvR="";
		String tranType="",analysis="";        // added by cpatil on 09-03-13
		String[] analysisStr =null;
		String analysis1__dr="",analysis2__dr="",analysis3__dr="",analysis1__cr="",analysis2__cr="",analysis3__cr="" ;
		tranId=tranId==null ? "" :tranId.trim();
		double exchRate=1;
		String currCodeBase="",currCode="",finEntity="";
		SimpleDateFormat sdf = null;
		java.sql.Timestamp tranDate = null, effDate = null;
		ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
		try{
			
			
			
		sql="select h.site_code,d.rate,d.rate__old,d.amount,d.amount__old,d.item_code,d.loc_code,d.lot_no,d.lot_sl,h.item_ser,d.acct_code__inv,d.acct_code__inrev,d.cctr_code__inv,d.cctr_code__inrev,h.tran_type ,h.tran_date,h.eff_date,d.amount__diff "
				+ "from stock_val_adj h,stock_val_adj_det d where h.tran_id=d.tran_id and d.tran_id = ? and d.line_no = ?";
		 pstmt=conn.prepareStatement(sql);
		 pstmt.setString(1, tranId);
		 pstmt.setString(2, lineNo);
		  rs=pstmt.executeQuery();
		  while(rs.next())
		  {
			    siteCode=checkNull(rs.getString(1));				  
			   	Rate=rs.getDouble(2);
			   	oldRate=rs.getDouble(3);
			   	amt=rs.getDouble(4);
			   	amt_old=rs.getDouble(5);
				itemCode=checkNull(rs.getString(6));
				locCode=checkNull(rs.getString(7));
				lotNo=rs.getString(8);
				lotSl=rs.getString(9);
				itemSer=checkNull(rs.getString(10));
				acctCdInv = checkNull(rs.getString(11));
				acctCdInvR = checkNull(rs.getString(12));
				cctrCdInv = rs.getString(13);
				cctrCdInvR = rs.getString(14);
				tranType = checkNull(rs.getString(15));
				tranDate = rs.getTimestamp(16);
				effDate = rs.getTimestamp(17);
				diffAmt = rs.getDouble(18);
				  
			   
				
			    updateAcctMap.put("rate",Double.toString(Rate));
			    updateAcctMap.put("rate__old",Double.toString(oldRate));
			    updateAcctMap.put("amount",Double.toString(amt));
			    updateAcctMap.put("amount__old",Double.toString(amt_old));
			    updateAcctMap.put("item_code",itemCode);
			    updateAcctMap.put("site_code",siteCode);
			    updateAcctMap.put("loc_code",locCode);
			 	updateAcctMap.put("lot_no",lotNo);
			 	updateAcctMap.put("lot_sl",lotSl);
			 	updateAcctMap.put("tran_type",tranType);
			 	updateAcctMap.put("tran_date",tranDate);
			 	updateAcctMap.put("eff_date",effDate);
			 	updateAcctMap.put("exch_rate",exchRate);
			 	updateAcctMap.put("sundry_type", 'O');
			
			 	updateAcctMap.put("ref_type", "");
			 	updateAcctMap.put("ref_id", tranId);
			 	updateAcctMap.put("ref_ser","STKVAT");
			 	sql1 = "SELECT A.CURR_CODE  AS CURR_CODE FROM FINENT A, SITE B WHERE B.FIN_ENTITY = A.FIN_ENTITY AND B.SITE_CODE = ?";
				pstmt1 = conn.prepareStatement(sql1);
				pstmt1.setString(1,siteCode);
				rs1 = pstmt1.executeQuery();
				System.out.println("siteCode...>>>>>>>>>>>>>>>>>>>>>>::"+siteCode);
				if(rs1.next())
				{
					currCodeBase = rs1.getString(1);
				}
				rs1.close();
				rs1 = null;
				pstmt1.close();
				pstmt1 = null;
				currCode = currCodeBase;
				
				sql1 = "SELECT FIN_ENTITY FROM SITE WHERE SITE_CODE = ?";
				pstmt1 = conn.prepareStatement(sql1);
				pstmt1.setString(1,siteCode);
				rs1 = pstmt1.executeQuery();
				if(rs1.next())
				{
					finEntity = rs1.getString(1);
				}
				rs1.close();
				rs1 = null;
				pstmt1.close();
				pstmt1 = null;
			
			 	updateAcctMap.put("curr_code",currCode);
			 	updateAcctMap.put("fin_entity",finEntity);
				
			 	analysis =  AcctAnalysisType(  itemCode,"STKVAT",  tranType, "CR", conn);
			  
			 	analysisStr = analysis.split("@");
				int len = analysisStr.length-1;
				//System.out.println("@@@cr len["+len+"]");
				if( len > -1 )
				{
					analysis1__cr = analysisStr[0];
				}
				else
				{
					analysis1__cr = "";	
				}	
				if( len > 0 )
				{
					analysis2__cr = analysisStr[1];	
				}
				else
				{	
				  analysis2__cr = "";
				}
				if( len > 1)
				{
				analysis3__cr = analysisStr[2];
				}
				else
				{
					analysis3__cr ="";	
				}
			 	
				analysis =  AcctAnalysisType(  itemCode,  "STKVAT",  tranType, "DR", conn);
				
				System.out.println("@@@@DR return analysis["+analysis+"]");
				//analysisStr = analysis.split("@@@@@@2 analysis::["+analysis+"]");
				
				analysisStr = analysis.split("@");
				len = analysisStr.length-1;
				System.out.println("@@@Dr len["+len+"]");
				if( len > -1)
				{
				  analysis1__dr = analysisStr[0];
				}
				else
				{
				  analysis1__dr = "";
				}
				if( len > 0)
				{
				  analysis2__dr = analysisStr[1];
				}
				else
				{
				  analysis2__dr = "";
				}
				if( len > 1)
				{
				  analysis3__dr = analysisStr[2];
				}
				else
				{
				  analysis3__dr ="";	
				}
				System.out.println("@@@@@DR analysis1__dr["+analysis1__dr+"]:::analysis2__dr["+analysis2__dr+"]::::analysis3__dr["+analysis3__dr+"]");
				
			 	if(amt >= amt_old)
			 	{
			 		
				 	System.out.println("stk debit"+diffAmt);
				 	updateAcctMap.put("acct_code",acctCdInv);
				 	updateAcctMap.put("cctr_code",cctrCdInv);
				 	updateAcctMap.put("analysis1",analysis1__dr);
				 	updateAcctMap.put("analysis2",analysis2__dr);
				 	updateAcctMap.put("analysis3",analysis3__dr);
				 	updateAcctMap.put("dr_amt", diffAmt);
				 	updateAcctMap.put("cr_amt", 0);
				 	System.out.println("CREDIT MA"+updateAcctMap);
				 	if(diffAmt != 0)
				 	{
				 	errString = finCommon.glTraceUpdate(updateAcctMap,conn);
					
					if(errString != null && errString.trim().length() > 0 )
					{
						break;
					}
				 	}
			 	//	stk acct debit
			 	}
			 	else
			 	{
			 		if(0 > diffAmt)
			 		{
			 			diffAmt = amt_old - amt;
			 			updateAcctMap.put("dr_amt", diffAmt);
					 	updateAcctMap.put("cr_amt", 0);
			 			
			 		}
			 		/*else
			 		{
			 			updateAcctMap.put("dr_amt", 0);
					 	updateAcctMap.put("cr_amt", diffAmt);
			 		}*/
			 		
			 		System.out.println("stk credit"+diffAmt);
			 		updateAcctMap.put("acct_code",acctCdInvR);
				 	updateAcctMap.put("cctr_code",cctrCdInvR);
				 	updateAcctMap.put("analysis1",analysis1__cr);
				 	updateAcctMap.put("analysis2",analysis2__cr);
				 	updateAcctMap.put("analysis3",analysis3__cr);
				 	
				 	System.out.println("DEBIT MA"+updateAcctMap);
				 	
				 	if(diffAmt != 0)
				 	{
				 	errString = finCommon.glTraceUpdate(updateAcctMap,conn);
					
					if(errString != null && errString.trim().length() > 0 )
					{
						break;
					}
				 	}
			 		//inrev cred
			 	}
			 	
			 	if(amt_old > amt)
			 	{
			 		if(0 < diffAmt)
			 		{
			 			
			 			updateAcctMap.put("dr_amt", 0);
					 	updateAcctMap.put("cr_amt", diffAmt);
			 		}/*else
			 		{
			 			updateAcctMap.put("dr_amt", diffAmt);
					 	updateAcctMap.put("cr_amt", 0);
			 		}*/
			 		
				 	System.out.println("stk debit1"+diffAmt+"{"+acctCdInv+"}{"+cctrCdInv+"");
				 	updateAcctMap.put("acct_code",acctCdInv);
				 	updateAcctMap.put("cctr_code",cctrCdInv);
				 	updateAcctMap.put("analysis1",analysis1__dr);
				 	updateAcctMap.put("analysis2",analysis2__dr);
				 	updateAcctMap.put("analysis3",analysis3__dr);
				 	System.out.println("DEBIT MA1"+updateAcctMap);
					if(diffAmt != 0)
				 	{
				 	errString = finCommon.glTraceUpdate(updateAcctMap,conn);
					
					if(errString != null && errString.trim().length() > 0 )
					{
						break;
					}
			 	//	stk acct debit
				 	}
			 	
			 		
			 	}
			 	else
			 	{

			 		System.out.println("stk credit1"+diffAmt);
			 		updateAcctMap.put("acct_code",acctCdInvR);
				 	updateAcctMap.put("cctr_code",cctrCdInvR);
				 	updateAcctMap.put("analysis1",analysis1__cr);
				 	updateAcctMap.put("analysis2",analysis2__cr);
				 	updateAcctMap.put("analysis3",analysis3__cr);
				 	updateAcctMap.put("dr_amt", 0);
				 	updateAcctMap.put("cr_amt", diffAmt);
				 	System.out.println("CREDIT MA1"+updateAcctMap);
					if(diffAmt != 0)
				 	{
				 	errString = finCommon.glTraceUpdate(updateAcctMap,conn);
					
					if(errString != null && errString.trim().length() > 0 )
					{
						break;
					}
			 		//inrev cred
				 	}
			 	
			 	}
			 	
			 	System.out.println();
			 	errString=finCommon.checkGlTranDrCr("STKVAT", tranId, conn);
				if(errString != null && errString.trim().length() > 0)
				{
					errString=itmDBAccessEJB.getErrorString("","VCOINDIFF1","");	
					return errString;
				}
				
				System.out.println("all correct");
			 	
				
		  }
		  
		  //Changes by Dadaso pawar on 18-04-14- START
		  if(rs!=null){
			  rs.close();
			  rs=null;			  
		  }
		  if(pstmt!=null){
			  pstmt.close();
			  pstmt=null;
		  }
		  
		  //Changes by Dadaso pawar on 18-04-14- END
		}catch(Exception e)
		{
			e.printStackTrace();
		}
		
		return errString;
		
		
		
		
	}
	// code Added by mahesh on 23-05-2014
	 public String rbfpost(String tranId,String tranSer,Connection conn) throws ITMException{
	        PreparedStatement pstmt = null,pstmt1 = null;        
	        ResultSet rs = null,rs1 = null;
	        String errString = "",invOnLine = "";
	        String sql = "",itemSer = "",tempAcctcodeCr = "" ,itemSerHdr = "";
	        java.sql.Date rcpTranDate = null;
	        String siteCodeHdr = "",finEntityHdr = "",currCodeHdr = "";
	        String tranType="",analysis="";        // added by cpatil on 09-03-13
			String[] analysisStr =null;
			String analysis1__dr="",analysis2__dr="",analysis3__dr="",analysis1__cr="",analysis2__cr="",analysis3__cr="" ;
	        Timestamp tranDateHdr = null;
	        double exchRateHdr = 1;
	        String rcpItemCode = "",rcpLocCode = "",rcpLotNo = "",rcpLotSl = "";
	        double rcpAmount = 0,rcpInvValue = 0,rcpGrossInvValue = 0;
	        String issItemCode = "",issLocCode = "",issLotNo = "",issLotSl = "";
	        double issAmount = 0,issGrossAmount = 0;
	        String acctCodeCr = "",acctCodeDr = "",cctrCodeCr = "",cctrCodeDr = "";
	        double convGl = 0;
	        String acctCodeConvGl = "",cctrCodeConvGl = "";
	        FinCommon finCommon = null;
	        ITMDBAccessEJB  itmDBAccessEJB = null;
	        HashMap glTrace = null;
	        int len=0;
	        try{
	            System.out.println("///////////////////Inside Rbf Post/////////////////////");
/*	            stmt = conn.createStatement();
	            stmt1 = conn.createStatement();*/
	            glTrace = new HashMap();
	            itmDBAccessEJB = new ITMDBAccessEJB();
	            finCommon = new FinCommon();
	            invOnLine = finCommon.getFinparams("999999","INV_ACCT_RB",conn);
	            if(invOnLine == null || invOnLine.equalsIgnoreCase("NULLFOUND")){
	                errString = itmDBAccessEJB.getErrorString("","VTFINPARM","","",conn);
	                return errString;
	            }
	            System.out.println("invOnLine :: "+invOnLine);
	            invOnLine = invOnLine.substring(0,1);
	            if("Y_N".indexOf(invOnLine) == -1){
	                errString = itmDBAccessEJB.getErrorString("","VTFINPARM1","","",conn);
	                return errString;
	            }
	            if(!invOnLine.equalsIgnoreCase("Y")){
	                return "";
	            }
	            sql = "select tran_date,site_code,acct_code__conv_gl,cctr_code__conv_gl from receipt_backflush where tran_id = ?";
	            System.out.println("SQL :"+sql);
	            pstmt = conn.prepareStatement(sql);
	            pstmt.setString(1, tranId);
	            rs1 = pstmt.executeQuery();
	            if(rs1.next()){
	                tranDateHdr = rs1.getTimestamp("tran_date");
	                siteCodeHdr = rs1.getString("site_code");
	                acctCodeConvGl = rs1.getString("acct_code__conv_gl");
	                cctrCodeConvGl = rs1.getString("cctr_code__conv_gl");
	            }
	            rs1.close();
	            pstmt.close();
	            pstmt = null;
	            
	            sql = "select fin_entity from site where site_code = ?";
	            System.out.println("SQL :"+sql);
	            pstmt = conn.prepareStatement(sql);
	            pstmt.setString(1, siteCodeHdr);
	            rs1 = pstmt.executeQuery();
	            if(rs1.next()){
	                finEntityHdr = rs1.getString("fin_entity");
	            }
	            rs1.close();
	            pstmt.close();
	            pstmt = null;
	            
	            sql = "select curr_code from finent where fin_entity = ?";
	            System.out.println("SQL :"+sql);
	            pstmt = conn.prepareStatement(sql);
	            pstmt.setString(1, finEntityHdr);
	            rs1 = pstmt.executeQuery();
	            if(rs1.next()){
	                currCodeHdr = rs1.getString("curr_code");
	            }
	            rs1.close();
	            pstmt.close();
	            pstmt = null;
	            
	            sql = "select item_code, loc_code, lot_no, lot_sl,amount " +
	                    "from receipt_backflush_det where tran_id = ?";
	            System.out.println("SQL :"+sql);
	            pstmt = conn.prepareStatement(sql);
	            pstmt.setString(1, tranId);
	            rs = pstmt.executeQuery();
	            while(rs.next()){
	                issItemCode = rs.getString("item_code");
	                issLocCode = rs.getString("loc_code");
	                issLotNo = rs.getString("lot_no");
	                issLotSl = rs.getString("lot_sl");
	                issAmount = rs.getDouble("amount");
	                
	                if(issAmount > 0){
	                    sql = "select acct_code__inv, cctr_code__inv from stock " +
	                            "where item_code = ? and " +
	                            "site_code = ? and " +
	                            "loc_code = ? and " +
	                            "lot_no = ? and " +
	                            "lot_sl = ? ";
	                    System.out.println("SQL :"+sql);
	                    pstmt1 = conn.prepareStatement(sql);
	                    pstmt1.setString(1, issItemCode);
	                    pstmt1.setString(2, siteCodeHdr);
	                    pstmt1.setString(3, issLocCode);
	                    pstmt1.setString(4, issLotNo);
	                    pstmt1.setString(5, issLotSl);
	                    rs1 = pstmt1.executeQuery();
	                    if(rs1.next()){
	                        acctCodeCr = rs1.getString("acct_code__inv");
	                        cctrCodeCr = rs1.getString("cctr_code__inv");
	                    }else{
	                        errString = itmDBAccessEJB.getErrorString("","VTACCTINV","","",conn);
	                        return errString;
	                    }
	                    rs1.close();
	    	            pstmt1.close();
	    	            pstmt1 = null;
	                }else{
	                    sql = "select item_ser from item where item_code = ?";
	                    System.out.println("SQL :"+sql);
	                    pstmt1 = conn.prepareStatement(sql);
	                    pstmt1.setString(1, issItemCode);
	                    rs1 = pstmt1.executeQuery();
	                    if(rs1.next()){
	                        itemSer = rs1.getString("item_ser");
	                    }
	                    rs1.close();
	    	            pstmt1.close();
	    	            pstmt1 = null;
	    	            
	                    tempAcctcodeCr = finCommon.getFromAcctDetr(issItemCode,itemSer,"IN",conn);
	                    acctCodeCr = tempAcctcodeCr.substring(0,tempAcctcodeCr.indexOf(","));
	                    cctrCodeCr = tempAcctcodeCr.substring(tempAcctcodeCr.indexOf(",")+1);
	                }
	                glTrace.put("tran_date",tranDateHdr);
	                glTrace.put("eff_date",tranDateHdr);
	                glTrace.put("fin_entity",finEntityHdr);
	                glTrace.put("site_code",siteCodeHdr);
	                glTrace.put("sundry_type","O");
	                glTrace.put("sundry_code","");
	                glTrace.put("acct_code",acctCodeCr);
	                glTrace.put("cctr_code",cctrCodeCr);
	                glTrace.put("emp_code","");
	                glTrace.put("anal_code","");
	                glTrace.put("curr_code",currCodeHdr);
	                glTrace.put("exch_rate",Double.toString(exchRateHdr));
	                if(issAmount > 0){
	                    glTrace.put("dr_amt","0");
	                    glTrace.put("cr_amt",Double.toString(issAmount));
	                }else{
	                    glTrace.put("dr_amt",Double.toString( 0 - issAmount));
	                    glTrace.put("cr_amt","0");
	                }
	                glTrace.put("ref_type","I");
	                glTrace.put("ref_ser",tranSer);
	                glTrace.put("ref_id",tranId);
	                glTrace.put("remarks","");
	                
	                
	                //------ Analysis CR 23-May-2014
	                
				 	analysis =  AcctAnalysisType(  issItemCode,"R-BFS",  tranType, "CR", conn);
					  
				 	analysisStr = analysis.split("@");
					 len = analysisStr.length-1;
					//System.out.println("@@@cr len["+len+"]");
					if( len > -1 )
					{
						analysis1__cr = analysisStr[0];
					}
					else
					{
						analysis1__cr = "";	
					}	
					if( len > 0 )
					{
						analysis2__cr = analysisStr[1];	
					}
					else
					{	
					  analysis2__cr = "";
					}
					if( len > 1)
					{
					analysis3__cr = analysisStr[2];
					}
					else
					{
						analysis3__cr ="";	
					}
					
					System.out.println("@@@@@CR analysis1__cr["+analysis1__cr+"]:::analysis2__cr["+analysis2__cr+"]::::analysis3__cr["+analysis3__cr+"]");
					
					glTrace.put("analysis1",analysis1__cr);
					glTrace.put("analysis2",analysis2__cr);
					glTrace.put("analysis3",analysis3__cr);

	                //---  Analysis CR ends here
	                
	                errString = finCommon.glTraceUpdate(glTrace,conn);
	                if(errString != null && errString.trim().length() > 0){
	                    return errString;
	                }
	                issGrossAmount = issGrossAmount + issAmount;
	                glTrace.clear();
	            }
	            rs.close();
	            pstmt.close();
	            pstmt = null;
	            //amount field should be same as inv_value in rcp_backflush_rcpt
	            sql = "select item_code,loc_code,lot_no,lot_sl,amount,inv_value from receipt_backflush " +
	                    "where tran_id = ?";
	            System.out.println("SQL :"+sql);
	            pstmt = conn.prepareStatement(sql);
	            pstmt.setString(1, tranId);
	            rs = pstmt.executeQuery();
	            if(rs.next()){
	                rcpItemCode = rs.getString("item_code");
	                rcpLocCode = rs.getString("loc_code");
	                rcpLotNo = rs.getString("lot_no");
	                rcpLotSl = rs.getString("lot_sl");
	                rcpAmount = rs.getDouble("amount");
	                rcpInvValue = rs.getDouble("inv_value");
	                
	                
	                sql = "select item_ser from item where item_code = ?"; //added by kunal on 26/jun/14 
                    System.out.println("SQL =:"+sql);
                    pstmt1 = conn.prepareStatement(sql);
                    pstmt1.setString(1, rcpItemCode);
                    rs1 = pstmt1.executeQuery();
                    if(rs1.next())
                    {
                        itemSerHdr = rs1.getString("item_ser");
                    }
                    rs1.close();
    	            pstmt1.close();
    	            pstmt1 = null;
    	            
	                
	                if(rcpAmount >= 0){
	                    tempAcctcodeCr = finCommon.getFromAcctDetr(rcpItemCode,itemSerHdr,"IN",conn);
	                    acctCodeDr = tempAcctcodeCr.substring(0,tempAcctcodeCr.indexOf(","));
	                    cctrCodeDr = tempAcctcodeCr.substring(tempAcctcodeCr.indexOf(",")+1);                    
	                }else{
	                    sql = "select acct_code__inv, cctr_code__inv from stock " +
	                            "where item_code = ? " +
	                            "and site_code = ? " +
	                            "and loc_code = ? " +
	                            "and lot_no = ? " +
	                            "and lot_sl = ?";
	                    System.out.println("SQL :"+sql);
	                    pstmt1 = conn.prepareStatement(sql);
	                    pstmt1.setString(1, rcpItemCode);
	                    pstmt1.setString(2, siteCodeHdr);
	                    pstmt1.setString(3, rcpLocCode);
	                    pstmt1.setString(4, rcpLotNo);
	                    pstmt1.setString(5, rcpLotSl);
	                    rs1 = pstmt1.executeQuery();
	                    if(rs1.next()){
	                        acctCodeDr = rs1.getString("acct_code__inv");
	                        cctrCodeDr = rs1.getString("cctr_code__inv");
	                    }
	                    rs1.close();
	    	            pstmt1.close();
	    	            pstmt1 = null;
	                }
	                if(acctCodeDr == null || acctCodeDr.trim().length() == 0){
	                    errString = itmDBAccessEJB.getErrorString("","VTACCTIN","","",conn);
	                    return errString;
	                }
	                
	                glTrace.put("tran_date",tranDateHdr);
	                glTrace.put("eff_date",tranDateHdr);
	                glTrace.put("fin_entity",finEntityHdr);
	                glTrace.put("site_code",siteCodeHdr);
	                glTrace.put("sundry_type","O");
	                glTrace.put("sundry_code","");
	                glTrace.put("acct_code",acctCodeDr);
	                glTrace.put("cctr_code",cctrCodeDr);
	                glTrace.put("emp_code","");
	                glTrace.put("anal_code","");
	                glTrace.put("curr_code",currCodeHdr);
	                glTrace.put("exch_rate",Double.toString(exchRateHdr));
	                if(rcpInvValue > 0){
	                    glTrace.put("dr_amt",Double.toString(rcpInvValue));
	                    glTrace.put("cr_amt","0");
	                }else{
	                    glTrace.put("dr_amt","0");
	                    glTrace.put("cr_amt",Double.toString(0 - rcpInvValue));
	                }
	                glTrace.put("ref_type","I");
	                glTrace.put("ref_ser",tranSer);
	                glTrace.put("ref_id",tranId);
	                glTrace.put("remarks","");

	                // Analysis debit code added  23-May-2014

					analysis =  AcctAnalysisType(  rcpItemCode,  "R-BFS",  tranType, "DR", conn);
					
					System.out.println("@@@@DR return analysis["+analysis+"]");
					//analysisStr = analysis.split("@@@@@@2 analysis::["+analysis+"]");
					
					analysisStr = analysis.split("@");
					len = analysisStr.length-1;
					System.out.println("@@@Dr len["+len+"]");
					if( len > -1)
					{
					  analysis1__dr = analysisStr[0];
					}
					else
					{
					  analysis1__dr = "";
					}
					if( len > 0)
					{
					  analysis2__dr = analysisStr[1];
					}
					else
					{
					  analysis2__dr = "";
					}
					if( len > 1)
					{
					  analysis3__dr = analysisStr[2];
					}
					else
					{
					  analysis3__dr ="";	
					}
					System.out.println("@@@@@DR analysis1__dr["+analysis1__dr+"]:::analysis2__dr["+analysis2__dr+"]::::analysis3__dr["+analysis3__dr+"]");	                
	                
					glTrace.put("analysis1",analysis1__dr);
					glTrace.put("analysis2",analysis2__dr);
					glTrace.put("analysis3",analysis3__dr);

					//---------  Analysis code debit ends here
					
	                errString = finCommon.glTraceUpdate(glTrace,conn);
	                if(errString != null && errString.trim().length() > 0){
	                    return errString;
	                }
	                rcpGrossInvValue = rcpGrossInvValue + rcpInvValue;
	                //glTrace.clear();
	            }
	            convGl = issGrossAmount - rcpGrossInvValue;
	            System.out.println("ConvGl (issGrossAmount - rcpGrossInvValue): "+convGl);
	            if(convGl != 0){
	                if(acctCodeConvGl == null || acctCodeConvGl.trim().length() == 0){
	                    errString = itmDBAccessEJB.getErrorString("","VTACCTIN","","",conn);
	                    return errString;
	                }
	                if(cctrCodeConvGl == null || cctrCodeConvGl.trim().length() == 0){
	                    cctrCodeConvGl = " ";
	                }
	                glTrace.put("acct_code",acctCodeConvGl);
	                glTrace.put("cctr_code",cctrCodeConvGl);
	                if(convGl > 0){
	                    glTrace.put("dr_amt",Double.toString(convGl));
	                    glTrace.put("cr_amt","0");
	                }else{
	                    glTrace.put("dr_amt","0");
	                    glTrace.put("cr_amt",Double.toString(0 - convGl));
	                }
	                errString = finCommon.glTraceUpdate(glTrace,conn);
	                if(errString != null && errString.trim().length() > 0){
	                    return errString;
	                }
	            }
	            errString = finCommon.checkGlTranDrCr(tranSer,tranId,conn);
	        }catch(Exception e){
	            System.out.println("Exception e"+e);
	            e.printStackTrace();
	            throw new ITMException(e);
	        }finally{
	            try{
	                glTrace.clear();
	                glTrace = null;
	                if(rs != null){
	                    rs.close();
	                    rs = null;
	                }
	                if(rs1 != null){
	                    rs1.close();
	                    rs1 = null;
	                }
	                if(pstmt != null){
	                	pstmt.close();
	                	pstmt = null;
	                }
	                if(pstmt1 != null){
	                	pstmt1.close();
	                	pstmt1 = null;
	                }
	            }catch(Exception e){
	                System.out.println("Exception in Finally : "+e);
	            }
	        }
	        System.out.println("Returning String From Rbfpost :: "+errString);
	        return errString;
	    }
	 // End of Code added by mahesh
	

}
