SET DEFINE OFF

--- SUN CCF No: IT2016-047-02 Request ID:A16ESUN003.Start --- 

ALTER TABLE EMPLOYEE_DET_CHANGE ADD EMP_CODE__FUNCHEAD_O CHAR(10);
ALTER TABLE EMPLOYEE_DET_CHANGE ADD EMP_CODE__FUNCHEAD CHAR(10);

ALTER TABLE EMPLOYEE_DET_CHANGE ADD BU_CODE__O CHAR(5);
ALTER TABLE EMPLOYEE_DET_CHANGE ADD BU_CODE CHAR(5);
ALTER TABLE EMPLOYEE_DET_CHANGE ADD CONSTRAINT FK_EMPDETCHG_BU_CODE FOREIGN KEY ( BU_CODE ) REFERENCES BUSINESS_UNITS ;



INSERT INTO OBJ_ITEMCHANGE 
(
	OBJ_NAME,
	FORM_NO,
	FIELD_NAME,
	MANDATORY
)
VALUES 
(
	'emp_det_chg',
	'1',
	'bu_code',
	'Y'
);

INSERT INTO OBJ_ITEMCHANGE 
(
	OBJ_NAME,
	FORM_NO,
	FIELD_NAME,
	MANDATORY
)
VALUES 
(
	'emp_det_chg',
	'1',
	'func_group',
	'Y'
);


INSERT INTO OBJ_ITEMCHANGE 
(
	OBJ_NAME,
	FORM_NO,
	FIELD_NAME,
	MANDATORY
)
VALUES 
(
	'emp_det_chg',
	'1',
	'emp_code__funchead',
	'Y'
);

COMMIT;

INSERT INTO POPHELP (FIELD_NAME,MOD_NAME,SQL_STR,MSG_TITLE,WIDTH,HEIGHT,CHG_DATE,CHG_USER,CHG_TERM,DIST_OPT,SQL_INPUT,DEFAULT_COL) 
VALUES 
('BU_CODE','W_EMP_DET_CHG','SELECT DESCR AS Description, BU_CODE AS Business_Unit FROM BUSINESS_UNITS','Business Units',0,0,FN_SYSDATE(),'BASE','BASE','1',null,2);

INSERT INTO POPHELP (FIELD_NAME,MOD_NAME,SQL_STR,MSG_TITLE,WIDTH,HEIGHT,CHG_DATE,CHG_USER,CHG_TERM,DIST_OPT,SQL_INPUT,DEFAULT_COL) 
VALUES 
('FUNC_GROUP','W_EMP_DET_CHG','SELECT  DESCR AS Description, FUNC_CODE AS Function_Code FROM BUSI_FUNCTIONS','Business Functions',0,0,FN_SYSDATE(),'BASE','BASE','1',null,2);

INSERT INTO POPHELP (FIELD_NAME,MOD_NAME,SQL_STR,MSG_TITLE,WIDTH,HEIGHT,CHG_DATE,CHG_USER,CHG_TERM,DIST_OPT,SQL_INPUT,DEFAULT_COL) 
VALUES 
('EMP_CODE__FUNCHEAD','W_EMP_DET_CHG','SELECT '''' AS Code,''Enter short name (min 3 characters ) to populate data'' AS Employee_Name,'''' AS Designation FROM DUAL WHERE LENGTH(NVL(''?'','' '')) < 3 UNION ALL SELECT A.EMP_CODE AS Code,(TRIM(A.EMP_FNAME)||'' ''||TRIM(A.EMP_MNAME)||'' ''||TRIM(A.EMP_LNAME)) AS Employee_Name,A.DESIGNATION AS Designation FROM EMPLOYEE A WHERE A.RELIEVE_DATE IS NULL AND (TRIM(A.EMP_FNAME)||'' ''||TRIM(A.EMP_MNAME)||'' ''||TRIM(A.EMP_LNAME)) LIKE UPPER(''%?%'') AND LENGTH(''?'') >= 3 ORDER BY EMPLOYEE_NAME','Employee List',0,0,FN_SYSDATE(),'BASE','BASE','1',':emp_code__funchead:emp_code__funchead:emp_code__funchead',1);

COMMIT;

INSERT INTO MESSAGES 
(MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,MSG_TIME,ALARM,ERR_SOURCE,CHG_DATE,CHG_USER,CHG_TERM,OVERRIDE_INPUT,MAIL_OPTION) 
VALUES ('VMEMPFGRP1','Invalid Function Code!','Entered Function code does not existing in business function master, Please enter function code which is available in business function master','E','Y',NULL, NULL,NULL,FN_SYSDATE(),'BASE','BASE',NULL,NULL); 

INSERT INTO MESSAGES 
(MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,MSG_TIME,ALARM,ERR_SOURCE,CHG_DATE,CHG_USER,CHG_TERM,OVERRIDE_INPUT,MAIL_OPTION) 
VALUES ('VMEMPFUHD1','Invalid Function Head!','Entered employee code in function head does not exist in employee, Please enter employee code in function head which is available in employee master','E','Y',NULL, NULL,NULL,FN_SYSDATE(),'BASE','BASE',NULL,NULL); 

INSERT INTO MESSAGES 
(MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,MSG_TIME,ALARM,ERR_SOURCE,CHG_DATE,CHG_USER,CHG_TERM,OVERRIDE_INPUT,MAIL_OPTION) 
VALUES ('VMEMPFUHD2','Invalid Function Head!','Entered employee code in function head should not be same as employee, Please enter employee code in function head which is not same as employee code','E','Y',NULL, NULL,NULL,FN_SYSDATE(),'BASE','BASE',NULL,NULL); 

INSERT INTO MESSAGES 
(MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,MSG_TIME,ALARM,ERR_SOURCE,CHG_DATE,CHG_USER,CHG_TERM,OVERRIDE_INPUT,MAIL_OPTION) 
VALUES ('VMEMPFUHD3','Invalid Function Head!','Entered employee code in function head is relieved, Please enter employee code in function head which is not relieved','E','Y',NULL, NULL,NULL,FN_SYSDATE(),'BASE','BASE',NULL,NULL); 

INSERT INTO MESSAGES 
(MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,MSG_TIME,ALARM,ERR_SOURCE,CHG_DATE,CHG_USER,CHG_TERM,OVERRIDE_INPUT,MAIL_OPTION) 
VALUES ('VMEMPBUCD1','Invalid Business Unit!','Entered Business Unit code does not existing in business unit master, Please enter business unit code which is available in business unit master','E','Y',NULL, NULL,NULL,FN_SYSDATE(),'BASE','BASE',NULL,NULL); 

COMMIT;

--- SUN CCF No: IT2016-047-02 Request ID:A16ESUN003.End --- 
