package ibase.webitm.ejb.fin;

import ibase.system.config.ConnDriver;
//import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import ibase.webitm.utility.GenericUtility;
import javax.ejb.Stateless;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.webitm.ejb.ValidatorEJB;
/**
 * Session Bean implementation class AccountsIC
 */
@Stateless
public class AccountsIC extends ValidatorEJB implements AccountsICRemote, AccountsICLocal 
{
	//changes and commented by sarita on 01/06/2017
	//E12GenericUtility genericUtility = new E12GenericUtility();
	GenericUtility genericUtility = GenericUtility.getInstance();
	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		   Document dom = null;
		   Document dom1 = null;
		   Document dom2 = null;
		   String retString = "";
		   try
		   {
			   if(xmlString != null && xmlString.trim().length() > 0)
			   {
				  dom =  genericUtility.parseString(xmlString);
			   }
			   if(xmlString1 != null && xmlString1.trim().length() > 0)
			   {
				   dom1 = genericUtility.parseString(xmlString1);
			   }
			   if(xmlString2 != null && xmlString2.trim().length() > 0)
			   {
				   dom2 = genericUtility.parseString(xmlString2);
			   }
			   retString = wfValData(dom,dom1,dom2,objContext,editFlag,xtraParams);
			   System.out.println("retString:::"+retString);
		   }
		   catch(Exception e)
		   {
			   System.out.println(":::" + getClass().getSimpleName() + "::"+ e.getMessage());
			   e.getMessage();
		   }
		   return retString;
	}
	
	private String checkNull(String input) 
	{
		return input == null ? "" : input;
	}
	
	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		//changes and commented by sarita on 01/06/2017
		//E12GenericUtility genericUtility = new E12GenericUtility();
		GenericUtility genericUtility = GenericUtility.getInstance();
		int childNodeLength = 0;
		int currentFormNo=0;
		int ctr=0,cnt=0;
		Connection conn = null;
		//Added by sarita on 01/06/2017
		ConnDriver connDriver = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		NodeList parentNodeList = null;
		Node parentNode = null;
		NodeList childNodeList = null;
		Node childNode = null;
		String childNodeName = "";
		String userId="";
		String acct_code__par="",sgroup_code="",curr_code="",acct_code__ntyp="",ls_acc="",acct_code="",sundry_type="";
		String sundtype = "";
		String sql = "";
		String errCode = "";
		ArrayList<String> errList = new ArrayList<String>();
		ArrayList<String> errFields = new ArrayList<String>();
		String errorType = "",errString="";
		StringBuffer errStringXml = new StringBuffer("<?xml version = \"1.0\"?> \r\n <Root> <Errors>");
		try
		{
			//changes and commented by sarita for DBConnection on 01/06/2017 :START
			//conn = getConnection();
			connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			conn.setAutoCommit(false);
			connDriver = null;
			//changes and commented by sarita for DBConnection on 01/06/2017 :END
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode"); 
			if(objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext);
				System.out.println("currentFormNo:::"+currentFormNo);
				
			    switch(currentFormNo)
			    {
			    	case 1:
			    	{
				    	parentNodeList = dom.getElementsByTagName("Detail1");
			    	  	parentNode = parentNodeList.item(0);
			    		childNodeList = parentNode.getChildNodes();
			    		childNodeLength = childNodeList.getLength();
			    		
			    		for(ctr = 0; ctr < childNodeLength; ctr++)
			    		{	
			    			childNode =  childNodeList.item(ctr);
							childNodeName = childNode.getNodeName();
							if("acct_code__par".equalsIgnoreCase(childNodeName))
							{
								acct_code__par = checkNull(genericUtility.getColumnValue("acct_code__par",dom)).trim();
								acct_code = checkNull(genericUtility.getColumnValue("acct_code",dom)).trim();
								System.out.println("acct_code__par>>>>>"+acct_code__par);
								
								if(!(acct_code__par.equalsIgnoreCase(acct_code)))
								{
									sql = "select count(*) as cnt from accounts where acct_code =?";
									pstmt = conn.prepareStatement(sql);
									pstmt.setString(1,acct_code__par);
									rs = pstmt.executeQuery();
									
									if(rs.next())
									{
										cnt = rs.getInt("cnt");
									}
									if(pstmt != null)
									{
									    pstmt.close(); 
									    pstmt = null;
									}
									if(rs != null)
									{
										rs.close();
									    rs = null;
									}
									
									if(cnt == 0)
									{
								    	errCode = "VMACCT1";
								    	errList.add(errCode);
										errFields.add(childNodeName.toLowerCase());
									}
								}
							}// end if block for acct_code__par
							
							else if("sgroup_code".equalsIgnoreCase(childNodeName))
							{
						    	sgroup_code = checkNull(genericUtility.getColumnValue("sgroup_code",dom)).trim();
								System.out.println("sgroup_code>>>>>"+sgroup_code);
								
								sql = "select count(*) as cnt from acctsgrp where sgroup_code =?";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1,sgroup_code);
								rs = pstmt.executeQuery();
								
								if(rs.next())
								{
									cnt = rs.getInt("cnt");
								}
								if(pstmt != null)
								{
									pstmt.close(); 
								    pstmt = null;
								}
								if(rs != null)
								{
									rs.close();
								    rs = null;
								}
									
								if(cnt == 0)
								{
									errCode = "VMACCTSGR1";
								    errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
								}
								
							}// end if block for sgroup_code
							
							else if("curr_code".equalsIgnoreCase(childNodeName))
							{
						    	curr_code = checkNull(genericUtility.getColumnValue("curr_code",dom)).trim();
						        System.out.println("curr_code>>>>>"+curr_code);
						        
						        sql = "select count(*) as cnt from currency where curr_code =?";
						        pstmt = conn.prepareStatement(sql);
								pstmt.setString(1,curr_code);
								rs = pstmt.executeQuery();
								
								if(rs.next())
								{
									cnt = rs.getInt("cnt");
								}
								if(pstmt != null)
								{
									pstmt.close(); 
								    pstmt = null;
								}
								if(rs != null)
								{
									rs.close();
								    rs = null;
								}
									
								if(cnt == 0)
								{
									errCode = "VMCUR1";
								    errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
								}
							}// end if block for curr_code
							
							else if("acct_code__ntyp".equalsIgnoreCase(childNodeName))
							{
						    	acct_code__ntyp = checkNull(genericUtility.getColumnValue("acct_code__ntyp",dom)).trim();
						        System.out.println("acct_code__ntyp>>>>>"+acct_code__ntyp);
						        
						        if(acct_code__ntyp != null && acct_code__ntyp.trim().length() > 0)
						        {
						        	sql = "select count(*) as cnt from accounts where acct_code =?";
						        	pstmt = conn.prepareStatement(sql);
									pstmt.setString(1,acct_code__ntyp);
									rs = pstmt.executeQuery();
									
									if(rs.next())
									{
										cnt = rs.getInt("cnt");
									}
									if(pstmt != null)
									{
										pstmt.close(); 
									    pstmt = null;
									}
									if(rs != null)
									{
										rs.close();
									    rs = null;
									}
									
									if(cnt == 0)
									{
										errCode = "VMACCT";
									    errList.add(errCode);
										errFields.add(childNodeName.toLowerCase());
									}
						        }
							}// end if block for acct_code__ntyp
							
							else if("sundry_type".equalsIgnoreCase(childNodeName))
							{
								acct_code = checkNull(genericUtility.getColumnValue("acct_code",dom)).trim();
								if("E".equalsIgnoreCase(editFlag))
								{
									sql = "select sundry_type from accounts where acct_code=?";
									pstmt = conn.prepareStatement(sql);
									pstmt.setString(1,acct_code);
									rs = pstmt.executeQuery();
									
									if(rs.next())
									{
										sundtype = rs.getString("sundry_type");
									}
									if(pstmt != null)
									{
										pstmt.close(); 
									    pstmt = null;
									}
									if(rs != null)
									{
										rs.close();
									    rs = null;
									}
																		
									sql = "select count(acct_code) as cnt from gltrace where acct_code =?";
									pstmt = conn.prepareStatement(sql);
									pstmt.setString(1,acct_code);
									rs = pstmt.executeQuery();
									
									if(rs.next())
									{
										cnt = rs.getInt("cnt");
									}
									if(pstmt != null)
									{
										pstmt.close(); 
									    pstmt = null;
									}
									if(rs != null)
									{
										rs.close();
									    rs = null;
									}
									
									if(cnt > 0)
									{
										errCode = "VMACCTSRS1";
									    errList.add(errCode);
										errFields.add(childNodeName.toLowerCase());
									}	
								}
							}//end of if block for sundry_type
			    		}
			    	}// end case1
			        break;
			    }// end switch 
			    int errListSize = errList.size();
		        System.out.println("errListSize::::::::::"+errListSize);
				int count = 0;
				String errFldName = null;
				if (errList != null && errListSize > 0)
				{
					for (count = 0; count < errListSize; count++)
					{
						errCode = errList.get(count);
						errFldName = errFields.get(count);
						System.out.println(" testing :errCode .:" + errCode);
						errString = getErrorString(errFldName, errCode, userId);
						System.out.println("errString>>>>>>>>>"+errString);
						errorType = errorType(conn, errCode);
						if (errString.length() > 0)
						{
							String bifurErrString = errString.substring(errString.indexOf("<Errors>") + 8, errString.indexOf("<trace>"));
							bifurErrString = bifurErrString + errString.substring(errString.indexOf("</trace>") + 8, errString.indexOf("</Errors>"));
							errStringXml.append(bifurErrString);
							errString = "";
						}
						if (errorType.equalsIgnoreCase("E"))
						{
							break;
						}
					}
					errList.clear();
					errList = null;
					errFields.clear();
					errFields = null;
					errStringXml.append("</Errors> </Root> \r\n");
				} 
				else
				{
					errStringXml = new StringBuffer("");
				}
			}
		}//end of try block
		catch(Exception e)
		{
			System.out.println(":::" + getClass().getSimpleName() + "::"+ e.getMessage());
			throw new ITMException(e);
		}	
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					{
						rs.close();
						rs = null;
					}
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
						conn.close();
				}
					conn = null;
			} 
			catch (Exception d)
			{
				d.printStackTrace();
				throw new ITMException(d);
			}
		}
		errString = errStringXml.toString();
		System.out.println("testing : final errString : " + errString);
		return errString;
	}
	
	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		Document dom = null;
		Document domhr = null;
		Document domAll = null;
		String retString="";
		try
		{
			System.out.println("**************  Inside itemChanged method ****************");
			if(xmlString != null && xmlString.trim().length() > 0)
			{
				dom = genericUtility.parseString(xmlString);
			}
			if(xmlString1 != null && xmlString1.trim().length() > 0)
			{
				domhr = genericUtility.parseString(xmlString1);
			}
			if(xmlString2 != null && xmlString2.trim().length() > 0)
			{
				domAll = genericUtility.parseString(xmlString2);
			}
			retString = itemChanged(dom,domhr,domAll,objContext,currentColumn,editFlag,xtraParams);	
			System.out.println("retString::::::::::"+retString);
		}
		catch(Exception e)
		{
			System.out.println(":::" + getClass().getSimpleName() + "::"+ e.getMessage());
			e.getMessage(); 
		}
		return retString;
	}
	
	public String itemChanged(Document dom, Document dom1, Document dom2,String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		Connection conn = null;
		//Added by sarita on 01/06/2017
		ConnDriver connDriver = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		SimpleDateFormat sdf;
		int childNodeListLength = 0;
		int currentFormNo=0,ctr=0;
		StringBuffer valueXmlString = new StringBuffer();
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		String childNodeName = null;
		String acct_code="";
		String acct_code__par="";
		String sgroup_code="";
		String sql = "";
		String ls_descr = "";
		String ls_descr1 = "",acctgrp_descr="",curr_code="";
		String currency_descr = "",acct_type="";
		String sundry_type = "",group_code = "";
		
		try
		{
			//changes and commented by sarita for DBConnection on 01/06/2017 :START
			//conn = getConnection();
			connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			conn.setAutoCommit(false);
			connDriver = null;
			//changes and commented by sarita for DBConnection on 01/06/2017 :END
			sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			System.out.println("[AccountsIC] [itemChanged] :currentFormNo ....." +currentFormNo);
			valueXmlString = new StringBuffer("<?xml version=\"1.0\"?><Root><header><editFlag>");
			valueXmlString.append(editFlag).append("</editFlag></header>");
			
			switch(currentFormNo)
			{
				case 1:
				{
					parentNodeList = dom.getElementsByTagName("Detail1");
					parentNode = parentNodeList.item(0);
					childNodeList = parentNode.getChildNodes();
					valueXmlString.append("<Detail1>");
					childNodeListLength = childNodeList.getLength();
					do
					{   
						childNode = childNodeList.item(ctr);
						childNodeName = childNode.getNodeName();
						ctr ++;
					}
					while(ctr < childNodeListLength  && ! childNodeName.equals(currentColumn));
					
					if("itm_defaultedit".equalsIgnoreCase(currentColumn.trim()))
					{
						acct_code  = checkNull(genericUtility.getColumnValue("acct_code", dom));
						acct_code__par = checkNull(genericUtility.getColumnValue("acct_code__par", dom));
						
						if(acct_code__par == null || acct_code__par.trim().length() == 0)
						{
							valueXmlString.append("<acct_code__par>").append("<![CDATA["+acct_code+"]]>").append("</acct_code__par>");
						}
						
						sgroup_code = checkNull(genericUtility.getColumnValue("sgroup_code", dom));
						System.out.println("sgroup_code>>>>>>>>>>"+sgroup_code);
						
						sql = "select descr,group_code from acctsgrp where sgroup_code=?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,sgroup_code);
						rs = pstmt.executeQuery();
						
						while(rs.next())
						{
							ls_descr = rs.getString("descr");
							ls_descr1 = rs.getString("group_code");
						}
						if(pstmt != null)
						{
						    pstmt.close(); 
						    pstmt = null;
						}
						if(rs != null)
						{
							rs.close();
						    rs = null;
						}
						valueXmlString.append("<acctsgrp_descr>").append("<![CDATA["+ls_descr+"]]>").append("</acctsgrp_descr>");
						valueXmlString.append("<group_code>").append("<![CDATA["+ls_descr1+"]]>").append("</group_code>");	
					
						sql = "select descr from acctgrp where group_code=?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,ls_descr1);	
						rs = pstmt.executeQuery();
						
						if(rs.next())
						{
							acctgrp_descr = rs.getString("descr");
						}
						if(pstmt != null)
						{
						    pstmt.close(); 
						    pstmt = null;
						}
						if(rs != null)
						{
							rs.close();
						    rs = null;
						}
						valueXmlString.append("<acctgrp_descr>").append("<![CDATA["+acctgrp_descr+"]]>").append("</acctgrp_descr>");
						
						curr_code = checkNull(genericUtility.getColumnValue("curr_code", dom));
						System.out.println("curr_code>>>>>>>>>>"+curr_code);
						
						sql = "Select descr from currency where curr_code =?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,curr_code);
						rs = pstmt.executeQuery();
						
						if(rs.next())
						{
							currency_descr = rs.getString("descr");
						}
						if(pstmt != null)
						{
						    pstmt.close(); 
						    pstmt = null;
						}
						if(rs != null)
						{
							rs.close();
						    rs = null;
						}
						valueXmlString.append("<currency_descr>").append("<![CDATA["+currency_descr+"]]>").append("</currency_descr>");
						
						acct_type = checkNull(genericUtility.getColumnValue("acct_type", dom));
						System.out.println("acct_type>>>>>>>>>>"+acct_type);
						
						if(acct_type.equals("O"))
						{
							valueXmlString.append("<sundry_type protect='1'>").append("<![CDATA["+"1"+"]]>").append("</sundry_type>");
						}
						else
						{
							valueXmlString.append("<sundry_type protect='O'>").append("<![CDATA["+"O"+"]]>").append("</sundry_type>");
						}				
					}
					
					if("acct_code".equalsIgnoreCase(currentColumn.trim()))
					{
						acct_code  = checkNull(genericUtility.getColumnValue("acct_code", dom));
						acct_code__par = checkNull(genericUtility.getColumnValue("acct_code__par", dom));
						
						if(acct_code__par == null || acct_code__par.trim().length() == 0)
						{
							valueXmlString.append("<acct_code__par>").append("<![CDATA["+acct_code+"]]>").append("</acct_code__par>");
						}
					}// end of if block for acct_code
					
					else if("sgroup_code".equalsIgnoreCase(currentColumn.trim()))
					{
						sgroup_code = checkNull(genericUtility.getColumnValue("sgroup_code", dom));
						System.out.println("sgroup_code>>>>>>>>>>"+sgroup_code);
						
						sql = "select descr,group_code from acctsgrp where sgroup_code=?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,sgroup_code);
						rs = pstmt.executeQuery();
						
						while(rs.next())
						{
							ls_descr = rs.getString("descr");
							ls_descr1 = rs.getString("group_code");
						}
						if(pstmt != null)
						{
						    pstmt.close(); 
						    pstmt = null;
						}
						if(rs != null)
						{
							rs.close();
						    rs = null;
						}
						valueXmlString.append("<acctsgrp_descr>").append("<![CDATA["+ls_descr+"]]>").append("</acctsgrp_descr>");
						valueXmlString.append("<group_code>").append("<![CDATA["+ls_descr1+"]]>").append("</group_code>");	
					
						sql = "select descr from acctgrp where group_code=?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,ls_descr1);	
						rs = pstmt.executeQuery();
						
						if(rs.next())
						{
							acctgrp_descr = rs.getString("descr");
						}
						if(pstmt != null)
						{
						    pstmt.close(); 
						    pstmt = null;
						}
						if(rs != null)
						{
							rs.close();
						    rs = null;
						}
						valueXmlString.append("<acctgrp_descr>").append("<![CDATA["+acctgrp_descr+"]]>").append("</acctgrp_descr>");						
					}
					
					else if("curr_code".equalsIgnoreCase(currentColumn.trim()))
					{
						curr_code = checkNull(genericUtility.getColumnValue("curr_code", dom));
						System.out.println("curr_code>>>>>>>>>>"+curr_code);
						
						sql = "Select descr from currency where curr_code =?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,curr_code);
						rs = pstmt.executeQuery();
						
						if(rs.next())
						{
							currency_descr = rs.getString("descr");
						}
						if(pstmt != null)
						{
						    pstmt.close(); 
						    pstmt = null;
						}
						if(rs != null)
						{
							rs.close();
						    rs = null;
						}
						valueXmlString.append("<currency_descr>").append("<![CDATA["+currency_descr+"]]>").append("</currency_descr>");
					}// end of if block for curr_code
					
					else if("acct_type".equalsIgnoreCase(currentColumn.trim()))
					{
						acct_type = checkNull(genericUtility.getColumnValue("acct_type", dom));
						System.out.println("acct_type>>>>>>>>>>"+acct_type);
						
						if(acct_type.equals("O"))
						{
							valueXmlString.append("<sundry_type protect='1'>").append("<![CDATA["+"1"+"]]>").append("</sundry_type>");
						}
						else
						{
							valueXmlString.append("<sundry_type protect='O'>").append("<![CDATA["+"O"+"]]>").append("</sundry_type>");
						}				
					}// end of if block for acct_type
				}// end of case1
				valueXmlString.append("</Detail1>");
				break;
			}// end of switch statement
				valueXmlString.append("</Root>");
		}// end of try block
		catch(Exception e)
		{
			System.out.println(":::" + getClass().getSimpleName() + "::"+ e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(conn != null){conn.close();conn = null;}
			}
			catch(Exception e)
			{
				System.out.println("Exception in EJB["+ getClass().getSimpleName() + "]::itemChanged::["+ e.getMessage() + "]");	
			}	
		}
		return valueXmlString.toString();
	}
	
	private String errorType(Connection conn, String errorCode) throws ITMException
	{
		String msgType = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try
		{
			String sql = "SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, errorCode);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				msgType = rs.getString("MSG_TYPE");
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
		} 
		catch (Exception ex)
		{
			ex.printStackTrace();
			throw new ITMException(ex);
		} 
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			} 
			catch (Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return msgType;
	}
}
