package ibase.webitm.ejb.fin;

import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import javax.ejb.Stateless;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless
public class ReceiptAdv extends ValidatorEJB implements ReceiptAdvLocal, ReceiptAdvRemote
{
	GenericUtility genericUtility = GenericUtility.getInstance();
	String winName = null;
	FinCommon finCommon = null;
	DistCommon  disCommon = null;
	ValidatorEJB validator = null;

	public String wfValData(String xmlString, String xmlString1, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		String errString = "";
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		try
		{
			System.out.println("Val xmlString :: " + xmlString);
			System.out.println("Val xmlString1 :: " + xmlString1);
			dom = parseString(xmlString);
			dom1 = parseString(xmlString1);
			errString = wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams);
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return errString;
	}
	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		String errString = "";
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		try
		{
			System.out.println("Val xmlString :: " + xmlString);
			System.out.println("Val xmlString1 :: " + xmlString1);
			System.out.println("Val xmlString2 :: " + xmlString2);
			dom = parseString(xmlString);
			dom1 = parseString(xmlString1);
			if (xmlString2.trim().length() > 0)
			{
				dom2 = parseString("<Root>" + xmlString2 + "</Root>");
			}
			errString = wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams);
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return errString;
	}

	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException 
	{
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		String childNodeName = null;
		StringBuffer valueXmlString = new StringBuffer();
		String tranId = "";
		String custCode = "";
		String siteCode = "";
		String finEntity = "";
		String currCode = "";
		String acctCodeBal = "";
		String tranDateS = "";
		String cctrCodeBal = "";
		String userId = "";
		String sql = "";
		String errCode = "";
		String errorType = "";
		String errString = "";
		String hsiteCode = "";
		String hcurrCode = "";
		String acctCodeAdv = "";
		String cctrCodeAdv = "";
		String tranType = "";
		String rcpMode = "";
		String cctrCodeCf = "";
		String groupCode = "";
		String hgroupCode = "";
		String acctCodeCf = "";
		String finScheme = "";
		String projCode = "";
		String tranIdAdvbking = "";
		String htranIdAdvbking = "";
		String hcustCode = "";
		String bankCode = "";
		String analCode = "";
		String refNo = "";
		String refSer = "";
		String lineNoRef = "";
		String htranId = "";
		String cctrCodeAr = "";
		String acctCode = "";
		String cctrCode = "";
		String empCode = "";
		String acctCodeAr = "";
		String hbankCode = "";
		String Sdays = "";
		String remark = "";
		String refDateS = "" ;
		String dueDateS = "";
		String siteSpecificBank = "";
		String taxClass = "",taxEnv = "",taxChap;//added by akhilesh on 31/july/13 for tax provision
		double diffAmtExch = 0.0D;
		double exchRate = 0.0D;
		double amount = 0.0D;
		double chequeAmt = 0.0D;
		double balAmt = 0.0D;
		double amountBc = 0.0D;
		double rcpAmt = 0.0D;
		double rcpAmt1 = 0.0D;
		double billDiscAmt = 0.0D;
		double advAmt = 0.0D;
		double Amt = 0.0D;
		double totAmt = 0.0D;
		double pendingAmt = 0.0D;
		double adjAmt = 0.0D;

		int ctr = 0;
		int currentFormNo = 0;
		int cnt = 0;
		int crt = 0;
		int Idays = 0;
		java.util.Date tranDate = null;
		java.util.Date effDate = null;
		java.util.Date refDate = null;
		java.util.Date dueDate = null;
		java.util.Date heffDate = null;
		java.util.Date htranDate = null;
		ArrayList errList = new ArrayList();
		ArrayList errFields = new ArrayList();
		//SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MMM-yy");
		//SimpleDateFormat dateFormat1 = new SimpleDateFormat("yyyy-mm-dd");
		SimpleDateFormat dateFormat2 = null;
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		ConnDriver connDriver = new ConnDriver();
		StringBuffer errStringXml = new StringBuffer("<?xml version = \"1.0\"?> \r\n <Root> <Errors>");
		try
		{
			finCommon = new FinCommon();
			disCommon = new DistCommon();
			validator = new ValidatorEJB();
			conn = connDriver.getConnectDB("DriverITM");
			userId = getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			dateFormat2=new SimpleDateFormat(genericUtility.getApplDateFormat());//Changed By Manoj dtd 08/08/2014
			if ((objContext != null) && (objContext.trim().length() > 0))
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			valueXmlString = new StringBuffer("<?xml version = \"1.0\"?> <Root> <header> <editFlag>");
			valueXmlString.append(editFlag).append("</editFlag> </header>");
			switch (currentFormNo)
			{
			case 1:
				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				valueXmlString.append("<Detail1>");
				int childNodeListLength = childNodeList.getLength();
				for (ctr = 0; ctr < childNodeListLength; ctr++)
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					if (childNodeName.equalsIgnoreCase("tran_date"))
					{
						tranDateS=this.genericUtility.getColumnValue("tran_date", dom);
						siteCode = this.genericUtility.getColumnValue("site_code", dom);

						if (tranDateS != null && !tranDateS.matches("\\d{4}-[01]\\d-[0-3]\\d"))
						{
							tranDate = dateFormat2.parse(tranDateS);
							/*	errCode = this.checkPeriod("FIN", siteCode, tranDate, conn);

							if(errCode != null && errCode.trim().length() >0)
							{
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}*/
						}
						else
						{
							errCode = "VMTRANDT";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
					}

					else if (childNodeName.equalsIgnoreCase("tran_type"))
					{
						tranType=this.genericUtility.getColumnValue("tran_type", dom);
						if (tranType == null || tranType.trim().length() == 0)
						{

							errCode = "TRTYPEBK";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
					}
					// As par discuss with manoharan sir it is not required

					/* 	else if (childNodeName.equalsIgnoreCase("tran_type"))
					{
						tranType=this.genericUtility.getColumnValue("tran_type", dom);
						if (tranType != null && tranType.trim().length() > 0)
						{
							if(!tranType.trim().equals("L"))
							{
								if(!tranType.trim().equals("U"))
								{
									errCode = "VTRECTYPE";
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
								}
							}
						}
						else
						{
							errCode = "VTRECTYPE";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
					}*/
					else if(childNodeName.equalsIgnoreCase("cust_code"))
					{
						custCode = this.genericUtility.getColumnValue("cust_code", dom);
						// 21/09/13 manoharan commented and added call to common function
						/*
						if(custCode != null && custCode.trim().length() > 0 )
						{
							sql = "select count(*) from customer where cust_code = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, custCode);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								cnt = rs.getInt(1);


							}
							if (cnt == 0)
							{
								errCode = "VTCUSTCD1";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
						}
						else
						{
							errCode = "VMCUSTCD1";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}

						siteCode = this.genericUtility.getColumnValue("site_code", dom);
						if(siteCode != null &&  siteCode.trim().length() > 0 )
						{
							sql = "select count(*)  from site_customer where cust_code = ? and site_code =?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, custCode);
							pstmt.setString(2, siteCode);
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								cnt = rs.getInt(1);
							}
							if (cnt == 0)
							{
								errCode = "VTCUSTCD2";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
						}
						else
						{
							errCode = "VMSITSUPP";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
						*/
						siteCode = this.genericUtility.getColumnValue("site_code", dom);
						errCode = finCommon.isSundryCode(siteCode, "C", custCode, "RCP",  conn);
						if (errCode != null && errCode.trim().length() > 0 )
						{
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}

					}
					else if (childNodeName.equalsIgnoreCase("site_code"))
					{
						siteCode = this.genericUtility.getColumnValue("site_code", dom);
						if(siteCode != null && siteCode.trim().length() > 0 )
						{
							sql = "select count(*) from site where site_code = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, siteCode);
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								cnt = rs.getInt(1);
							}
							if (cnt == 0)
							{
								errCode = "VMSITE1";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
						}
						else
						{
							errCode = "VMSITSUPP";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
						if ((errCode == null) ||  (errCode.trim().length() == 0))
						{
							System.out.println("prioddddddddd");

							tranDate = dateFormat2.parse(this.genericUtility.getColumnValue("tran_date", dom));
							errCode = this.nfCheckPeriod("FIN", tranDate, siteCode);
							if(errCode != null && errCode.trim().length() >0)
							{
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
						}
					}
					else if (childNodeName.equalsIgnoreCase("fin_entity"))
					{
						finEntity = this.genericUtility.getColumnValue("fin_entity", dom);
						if(finEntity != null && finEntity.trim().length() > 0)
						{
							sql = "select count(*) from finent where fin_entity = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, finEntity);
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								cnt = rs.getInt(1);
							}
							if (cnt == 0)
							{
								errCode = "VMFENTY1";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
						}						
					}
					else if (childNodeName.equalsIgnoreCase("curr_code"))
					{
						currCode = this.genericUtility.getColumnValue("curr_code", dom);
						if(currCode != null && currCode.trim().length() > 0)
						{
							sql = "select count(*) from currency where curr_code = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, currCode);
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								cnt = rs.getInt(1);
							}
							if (cnt == 0)
							{
								errCode = "VMCUR1";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}

							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
						}
						else
						{

							errCode = "VMCURRCD1";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
					}
					else if (childNodeName.equalsIgnoreCase("acct_code__bal"))
					{
						
						acctCodeBal = this.genericUtility.getColumnValue("acct_code__bal", dom);
						if(acctCodeBal != null && acctCodeBal.trim().length() > 0)
						{
							siteCode = this.genericUtility.getColumnValue("site_code", dom);
							errCode = finCommon.isAcctCode(siteCode, acctCodeBal, "FIN", conn);
							//errCode = validateAccount(siteCode, acctCodeBal, conn);
							if(errCode != null && errCode.trim().length() > 0)
							{
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
						}
					}
					else if (childNodeName.equalsIgnoreCase("cctr_code__bal"))
					{

						
						cctrCodeBal = this.genericUtility.getColumnValue("cctr_code__bal", dom);
						analCode = this.genericUtility.getColumnValue("anal_code", dom);
						refSer = this.genericUtility.getColumnValue("ref_ser", dom);

						if(cctrCodeBal != null && cctrCodeBal.trim().length() > 0)
						{
							acctCodeBal = this.genericUtility.getColumnValue("acct_code__bal", dom);
							errCode = finCommon.isCctrCode(acctCodeBal, cctrCodeBal, "FIN", conn);
							//errCode = validateCctrCode(cctrCodeBal, acctCodeBal, conn);
							if(errCode != null && errCode.trim().length() > 0)
							{
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
						}
					}

					else if (childNodeName.equalsIgnoreCase("acct_code__adv"))
					{
						
		
						
						acctCodeAdv = this.genericUtility.getColumnValue("acct_code__adv", dom);
						advAmt = doublevalue(this.genericUtility.getColumnValue("adv_amt", dom));
						if ((advAmt != 0.0) && ((acctCodeAdv.trim().length() != 0) && (acctCodeAdv != null)))
						{
							siteCode = this.genericUtility.getColumnValue("site_code", dom);
							errCode = finCommon.isAcctCode(siteCode, acctCodeAdv, "FIN", conn);
							//errCode = validateAccount(siteCode, acctCodeAdv, conn);
							if(errCode != null && errCode.trim().length() > 0)
							{
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
						}

					}
					else if (childNodeName.equalsIgnoreCase("cctr_code__adv"))
					{
					
						
						cctrCodeAdv = this.genericUtility.getColumnValue("cctr_code__adv", dom);
						acctCodeAdv = this.genericUtility.getColumnValue("acct_code__adv", dom);
						advAmt = Double.parseDouble(this.genericUtility.getColumnValue("adv_amt", dom));
						if ((advAmt != 0.0) && ((acctCodeAdv.trim().length() != 0) && (acctCodeAdv != null)))
						{
							errCode = finCommon.isCctrCode(acctCodeAdv, cctrCodeAdv, "FIN", conn);
							//errCode = validateCctrCode(cctrCodeAdv ,acctCodeAdv, conn);
							if(errCode != null && errCode.trim().length() > 0)
							{
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
						}

					}

					if (childNodeName.equalsIgnoreCase("acct_code__cf"))
					{
						acctCodeCf = this.genericUtility.getColumnValue("acct_code__cf", dom);
						if(acctCodeCf != null && acctCodeCf.trim().length() > 0)
						{
							siteCode = this.genericUtility.getColumnValue("site_code", dom);
							diffAmtExch = doublevalue(this.genericUtility.getColumnValue("diff_amt__exch", dom));
							if (diffAmtExch != 0.0D)
							{
								errCode = finCommon.isAcctCode(siteCode, acctCodeCf, "FIN", conn);
								//errCode = validateAccount(siteCode ,acctCodeCf,  conn);
								if(errCode != null && errCode.trim().length() > 0)
								{
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
								}
							}
						}
					}
					else if (childNodeName.equalsIgnoreCase("cctr_code__cf"))
					{
						cctrCodeCf = this.genericUtility.getColumnValue("cctr_code__cf", dom);
						if(cctrCodeCf != null && cctrCodeCf.trim().length() > 0)
						{
							acctCodeCf = this.genericUtility.getColumnValue("acct_code__cf", dom);
							advAmt = doublevalue(this.genericUtility.getColumnValue("adv_amt", dom));
							if ((acctCodeCf != null) && (acctCodeCf.trim().length() > 0))
							{
								errCode = finCommon.isCctrCode(acctCodeCf, cctrCodeCf, "FIN", conn);
								//errCode = validateCctrCode(cctrCodeCf, acctCodeCf, conn);
								if(errCode != null && errCode.trim().length() > 0)
								{
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
								}
							}
						}
					}
					else if (childNodeName.equalsIgnoreCase("ref_date"))
					{
						refDate = dateFormat2.parse(this.genericUtility.getColumnValue("ref_date", dom));
						if (refDate == null)
						{
							errCode = "VTDAT3";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
						tranType = this.genericUtility.getColumnValue("tran_type", dom);
						rcpMode = this.genericUtility.getColumnValue("rcp_mode", dom);
						effDate = dateFormat2.parse(this.genericUtility.getColumnValue("eff_date", dom));

						if(tranType != null && tranType.trim().length() != 0)
						{						
							if (tranType.equals("L"))
							{
								if ((!rcpMode.equals("Q")) && (!rcpMode.equals("D")) && (!rcpMode.equals("P")))
									continue;
								Sdays = finCommon.getFinparams("999999", "RCP_REF_DATE",conn);
								if (Sdays == null || Sdays.equals("") )
								{
									Sdays = "0";
								}
								Idays = Integer.parseInt(Sdays);
								effDate.setDate(effDate.getDate() + Idays);
								if (effDate.before(refDate))
								{
									errCode = "VTDATEEFF5~t" + Idays + "Days";
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
								}
							}
							else {
								if (!tranType.equals("U"))
									continue;
								if ((!rcpMode.equals("Q")) && (!rcpMode.equals("D")))
									continue;
								Sdays = finCommon.getFinparams("999999", "RCP_REF_DATE",conn);
								if (Sdays == null || Sdays.equals(""))
								{
									Sdays = "0";
								}
								Idays = Integer.parseInt(Sdays);
								if ((!rcpMode.equals("Q")) && (!rcpMode.equals("D")))
									continue;
								effDate.setDate(effDate.getDate() + Idays);
								if (!effDate.before(refDate))
									continue;
								errCode = "VTDATEEFF6~t" + Idays + "Days";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
						}
					}
					else if (childNodeName.equalsIgnoreCase("bank_code"))
					{
						bankCode = this.genericUtility.getColumnValue("bank_code", dom);
						if(bankCode != null && bankCode.trim().length() > 0)
						{

							sql = "select count(*) from bank where bank_code = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, bankCode);
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								cnt = rs.getInt(1);
							}
							if (cnt == 0)
							{
								errCode = "VMBANK1";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;

							// added by akhilesh on 01/aug/13 as discuss with manoj sharma
							siteSpecificBank = finCommon.getFinparams("999999", "SITE_SPECIFIC_BANK", conn);
							if(siteSpecificBank != null &&  "Y".equalsIgnoreCase(siteSpecificBank))
							{

								siteCode = this.genericUtility.getColumnValue("site_code", dom);
								errCode = this.isBankCode(siteCode, bankCode, "FIN");
								//errCode = validateBankCode(bankCode, siteCode, conn);
								if(errCode != null && errCode.trim().length() > 0)
								{
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
								}
							}
							// ended by akhilesh on 01/aug/13 as discuss with manoj 
						}
						else
						{
							errCode = "VMBCNCD1";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}

					}
					else if (childNodeName.equalsIgnoreCase("anal_code"))
					{
						
						analCode = this.genericUtility.getColumnValue("anal_code", dom);
						if(analCode != null && analCode.trim().length() >0)
						{
							refSer = checkNull(this.genericUtility.getColumnValue("ref_ser", dom));
							acctCodeBal = this.genericUtility.getColumnValue("acct_code__bal", dom);
							errCode =finCommon.isAnalysis(acctCodeBal, analCode, refSer, conn);
							//errCode = validateAnalysisCode(acctCodeBal, analCode, conn);
							if(errCode != null && errCode.trim().length() > 0)
							{
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
						}
					}
					else if (childNodeName.equalsIgnoreCase("fin_scheme"))
					{
						finScheme = this.genericUtility.getColumnValue("fin_scheme", dom);
						if(finScheme != null && finScheme.trim().length() > 0)
						{
							tranDate = dateFormat2.parse(this.genericUtility.getColumnValue("tran_date", dom));
							java.sql.Date tranDatesql = new java.sql.Date(tranDate.getTime());
							sql = "select count(*) from fin_scheme where fin_scheme = ? and start_date <= ? and end_date >= ? and amt_type = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, finScheme);
							pstmt.setDate(2, tranDatesql);
							pstmt.setDate(3, tranDatesql);
							pstmt.setString(4, "P");
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								cnt = rs.getInt(1);
							}
							if (cnt < 1)
							{
								errCode = "VMFINSCHMT";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}

							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
						}

					}
					else if (childNodeName.equalsIgnoreCase("proj_code"))
					{
						projCode = this.genericUtility.getColumnValue("proj_code", dom);
						if ((projCode != null) && (projCode.trim().length() > 0))
						{
							sql = "Select count(*) From project where proj_code = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, projCode);
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								cnt = rs.getInt(1);
							}
							if (cnt <= 0)
							{
								errCode = "VMPROJCDIN";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}

							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
						}
					}
					else if(childNodeName.equalsIgnoreCase("remarks"))
					{
						remark = this.genericUtility.getColumnValue("remarks", dom);
						if(remark == null || remark.trim().length() == 0 )
						{

							errCode = "GVNBREM";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
					}


					//added by akhilesh on 19/AUG/13 for tax provision



					else if(childNodeName.equalsIgnoreCase("tax_class"))
					{
						taxClass = checkNull(genericUtility.getColumnValue("tax_class", dom));
						if( taxClass != null && taxClass.trim().length() > 0)
						{
							sql = "select count(*) from taxclass where tax_class = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, taxClass);
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								cnt = rs.getInt(1);
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;

							if(cnt == 0)
							{
								errCode = "VTTAXCLA1";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());   
							}
						}
					}
					else if(childNodeName.equalsIgnoreCase("tax_chap"))
					{
						taxChap = checkNull(genericUtility.getColumnValue("tax_chap", dom));
						if( taxChap != null && taxChap.trim().length() > 0)
						{
							sql = "select count(*) from taxchap where tax_chap = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, taxChap);
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								cnt = rs.getInt(1);
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;

							if(cnt == 0)
							{
								errCode = "VTTCHAP1";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());   
							}
						}
					}
					else if(childNodeName.equalsIgnoreCase("tax_env"))
					{
						taxEnv = checkNull(genericUtility.getColumnValue("tax_env", dom));
						if( taxEnv != null && taxEnv.trim().length() > 0)
						{
							sql = "select count(*) from taxenv where tax_env = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, taxEnv);
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								cnt = rs.getInt(1);
							}

							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;

							if(cnt == 0)
							{
								errCode = "VMTAXENVNF";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());   
							}
						}
					}
					//ended by akhilesh on 19/AUG/13 for tax provision


					else if(childNodeName.equalsIgnoreCase("tran_id__advbking"))
					{
						tranIdAdvbking = this.genericUtility.getColumnValue("tran_id__advbking", dom);
						if(tranIdAdvbking != null && tranIdAdvbking.trim().length() > 0)
						{					
							tranDate = dateFormat2.parse(this.genericUtility.getColumnValue("tran_date", dom));
							bankCode = this.genericUtility.getColumnValue("bank_code", dom);
							sql = "select count(*) from advbking where confirmed = 'Y' and bal_amt > 0 and (? between to_char(eff_date,'yyyy-mm-dd')  and to_char(valid_upto,'yyyy-mm-dd'))and bank_code = ? tran_id = ? and status = 'A' ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, bankCode);
							pstmt.setString(2, tranDate.toString());
							pstmt.setString(3, tranIdAdvbking);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								cnt = rs.getInt(1);
							}
							if (cnt < 0)
							{
								errCode = "VTADVBKID";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
						}

					}

				}
				valueXmlString.append("</Detail1>");
				break;
			case 2:
				parentNodeList = dom.getElementsByTagName("Detail2");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				valueXmlString.append("<Detail2>");
				childNodeListLength = childNodeList.getLength();
				for (ctr = 0; ctr < childNodeListLength; ctr++)
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					if (childNodeName.trim().equalsIgnoreCase("ref_ser"))
					{
						refSer = this.genericUtility.getColumnValue("ref_ser", dom);
						if(refSer != null && refSer.trim().length() > 0)
						{
							sql = " select count(*) from refser  where  ref_ser = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, refSer);
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								cnt = rs.getInt(1);
							}
							if (cnt == 0)
							{
								errCode = "VMREFSER";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
						}
						else
						{
							errCode = "COPAB";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
					}
					else if (childNodeName.equalsIgnoreCase("ref_no"))
					{
						refNo = this.genericUtility.getColumnValue("ref_no", dom);
						if(refNo != null && refNo.trim().length() > 0)
						{
							refSer = this.genericUtility.getColumnValue("ref_ser", dom);
							lineNoRef = this.genericUtility.getColumnValue("line_no__ref", dom);

							sql = " select count(*) from receivables  where  tran_ser = ? and ref_no = ? and line_no__ref = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, refSer);
							pstmt.setString(2, refNo);
							pstmt.setString(3, lineNoRef);
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								cnt = rs.getInt(1);
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;

							if (cnt == 0)
							{
								errCode = "VMREF1";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
							else
							{
								hsiteCode = this.genericUtility.getColumnValue("site_code", dom1);
								sql = " select site_code  from receivables  where  tran_ser = ? and ref_no = ?  and line_no__ref = ?";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, refSer);
								pstmt.setString(2, refNo);
								pstmt.setString(3, lineNoRef);
								rs = pstmt.executeQuery();
								if (rs.next())
								{
									siteCode = rs.getString(1);
								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;

								if (!siteCode.trim().equals(hsiteCode.trim()))
								{
									errCode = "VTSITE1";
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
								}
							}
							if(errCode == null || errCode.trim().length() == 0)
							{
								errCode = checkBadDebtAmt(1, conn, dom);
								if(errCode != null && errCode.trim().length() > 0)
								{
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
								}
							}
						}
						else
						{
							errCode = "VTSPECREF";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
					}
					else if (childNodeName.equalsIgnoreCase("ref_date"))
					{
						refDateS = this.genericUtility.getColumnValue("ref_date", dom);
						if(refDateS != null && !refDateS.equals("DD/MM/YY"))
						{
							refDate = dateFormat2.parse(refDateS);
							htranDate = dateFormat2.parse(this.genericUtility.getColumnValue("tran_date", dom1));
							if (!htranDate.before(refDate))
								continue;
							errCode = "VXVOUDATE";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
					}
					else if (childNodeName.equalsIgnoreCase("due_date"))
					{
						dueDateS = this.genericUtility.getColumnValue("due_date", dom);
						if(dueDateS != null && !dueDateS.equals("DD/MM/YY")) 
						{
							dueDate = dateFormat2.parse(dueDateS);
						}
					}
					else if (childNodeName.equalsIgnoreCase("curr_code"))
					{
						currCode = this.genericUtility.getColumnValue("curr_code", dom);
						if (currCode != null && currCode.trim().length() > 0) 
						{
							sql = "select count(*) from currency where curr_code = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, currCode);
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								cnt = rs.getInt(1);
							}
							if (cnt == 0)
							{
								errCode = "VMCUR1";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}

							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
						
						
							/*hcurrCode = this.genericUtility.getColumnValue("curr_code", dom1);
							if(hcurrCode != null && hcurrCode.trim().length() > 0)
							{
								if (currCode.trim().equals(hcurrCode.trim()))
									continue;
								errCode = "VTCUR3";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
							*/
						}
						else
						{

							errCode = "VMCURRCD1";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
					}
					else if (childNodeName.equalsIgnoreCase("acct_code__ar"))
					{
						acctCodeAr = this.genericUtility.getColumnValue("acct_code__ar", dom);
						if (acctCodeAr != null && acctCodeAr.trim().length() > 0) 
						{
							hsiteCode = this.genericUtility.getColumnValue("site_code", dom1);
							errCode = finCommon.isAcctCode(hsiteCode, acctCodeAr, "FIN", conn);
							if(errCode != null && errCode.trim().length() >0)
							{
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
						}
					}
					else if (childNodeName.equalsIgnoreCase("cctr_code__ar"))
					{
						
						cctrCodeAr = this.genericUtility.getColumnValue("cctr_code__ar", dom);
						if (cctrCodeAr != null && cctrCodeAr.trim().length() > 0) 
						{
							acctCodeAr = this.genericUtility.getColumnValue("acct_code__ar", dom);
							errCode = finCommon.isCctrCode(acctCodeAr, cctrCodeAr, "FIN", conn);
							//errCode = validateCctrCode(cctrCodeAr ,acctCodeAr, conn);
							if(errCode != null && errCode.trim().length() >0)
							{
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());

							}
						}
					}
					else if (childNodeName.equalsIgnoreCase("cust_code"))
					{
						custCode = this.genericUtility.getColumnValue("cust_code", dom);
						if(custCode != null && custCode.trim().length() > 0)
						{
							hcustCode = this.genericUtility.getColumnValue("cust_code", dom1);

							sql = "select count(*) from customer where cust_code = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, custCode);
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								cnt = rs.getInt(1);
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;

							if (cnt == 0)
							{
								errCode = "VMCUS1";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							} 

							else if(hcustCode.trim().length() > 0)
							{
								sql = "select group_code from customer where cust_code = ?";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, hcustCode);
								rs = pstmt.executeQuery();
								if (rs.next())
								{
									hgroupCode = rs.getString(1);
								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;

								sql = "select group_code from customer where cust_code = ?";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, custCode);
								rs = pstmt.executeQuery();
								if (rs.next())
								{
									groupCode = rs.getString(1);
								}

								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;

								if (hgroupCode.equals(groupCode))
									continue;
								errCode = "VTCGRP1";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
						}
					}
					else if(childNodeName.equalsIgnoreCase("bill_disc_amt")) 			//added by ritesh as per discusion with pravin on 14/05/13 start
					{
						if(this.genericUtility.getColumnValue("bill_disc_amt", dom)!= null && this.genericUtility.getColumnValue("bill_disc_amt", dom).trim().length() >0)
						{

							billDiscAmt = Double.parseDouble(this.genericUtility.getColumnValue("bill_disc_amt", dom));
							if (billDiscAmt > 0) 
							{
								rcpAmt1 = doublevalue(this.genericUtility.getColumnValue("rcp_amt", dom));
								if(billDiscAmt > rcpAmt1)
								{
									errCode = "VTBDAMT";
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
								}
							}	
						}
					}																	//added by ritesh as per discusion with pravin on 14/05/13 end
					else if(childNodeName.equalsIgnoreCase("rcp_amt"))
					{
						rcpAmt = doublevalue(this.genericUtility.getColumnValue("rcp_amt", dom));
						refNo = this.genericUtility.getColumnValue("ref_no", dom);
						refSer = this.genericUtility.getColumnValue("ref_ser", dom);
						lineNoRef = this.genericUtility.getColumnValue("line_no__ref", dom);
						if (rcpAmt == 0.0D)
						{
							errCode = "VTRCAMT";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}

						else
						{
							sql = "select (tot_amt - adj_amt) from receivables where tran_ser = ? and ref_no = ? and line_no__ref = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, refSer);
							pstmt.setString(2, refNo);
							pstmt.setString(3, lineNoRef);
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								balAmt = rs.getDouble(1);
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;

							if (((balAmt < 0.0D) && (rcpAmt < 0.0D) && (Math.abs(balAmt) < Math.abs(rcpAmt))) || 
									((balAmt > 0.0D) && (rcpAmt > 0.0D) && (Math.abs(balAmt) < Math.abs(rcpAmt))) || ((balAmt > 0.0D) && (rcpAmt < 0.0D)) || (
											(balAmt < 0.0D) && (rcpAmt > 0.0D)))
							{
								errCode = "VTBAL1";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
							else
							{
								htranIdAdvbking = this.genericUtility.getColumnValue("tran_id__advbking", dom1);
								if ((htranIdAdvbking == null) || (htranIdAdvbking.trim().length() <= 0))
									continue;
								sql = "select bal_amt from advbking where tran_id = ?";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, htranIdAdvbking);
								rs = pstmt.executeQuery();
								if (rs.next())
								{
									balAmt = rs.getDouble(1);
								}

								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;

								tranId = this.genericUtility.getColumnValue("tran_id", dom);

								sql = "select sum(case when det.rcp_amt is null then 0 else det.rcp_amt end) from receipt hdr, rcpdet det where hdr.tran_id = det.tran_id and hdr.tran_id != ? and hdr.tran_id__advbking = ? and (case when hdr.confirmed is null then 'N' else hdr.confirmed end) != 'Y' ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, tranId);
								pstmt.setString(2, htranIdAdvbking);
								rs = pstmt.executeQuery();
								if (rs.next())
								{
									pendingAmt = rs.getDouble(1);
								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;

								if (pendingAmt != 0.0D)
									continue;
								for (crt = 1; crt <= parentNodeList.getLength(); crt++)
								{
									pendingAmt += Double.parseDouble(this.genericUtility.getColumnValue("rcp_amt", dom));
								}

								if (crt > 0)
								{
									pendingAmt -= Double.parseDouble(this.genericUtility.getColumnValue("rcp_amt", dom));
								}

								if (pendingAmt + rcpAmt >  balAmt)
								{
									errCode = "VTINVADVAM";
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
								}

							}


						}

					}

					//added by akhilesh on 31/july/13 for tax provision



					else if(childNodeName.equalsIgnoreCase("tax_class"))
					{
						taxClass = checkNull(genericUtility.getColumnValue("tax_class", dom));
						if( taxClass != null && taxClass.trim().length() > 0)
						{
							sql = "select count(*) from taxclass where tax_class = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, taxClass);
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								cnt = rs.getInt(1);
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;

							if(cnt == 0)
							{
								errCode = "VTTAXCLA1";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());   
							}
						}
					}
					else if(childNodeName.equalsIgnoreCase("tax_chap"))
					{
						taxChap = checkNull(genericUtility.getColumnValue("tax_chap", dom));
						if( taxChap != null && taxChap.trim().length() > 0)
						{
							sql = "select count(*) from taxchap where tax_chap = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, taxChap);
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								cnt = rs.getInt(1);
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;

							if(cnt == 0)
							{
								errCode = "VTTCHAP1";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());   
							}
						}
					}
					else if(childNodeName.equalsIgnoreCase("tax_env"))
					{
						taxEnv = checkNull(genericUtility.getColumnValue("tax_env", dom));
						if( taxEnv != null && taxEnv.trim().length() > 0)
						{
							sql = "select count(*) from taxenv where tax_env = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, taxEnv);
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								cnt = rs.getInt(1);
							}

							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;

							if(cnt == 0)
							{
								errCode = "VMTAXENVNF";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());   
							}
						}
					}
					//ended by akhilesh on 31/july/13 for tax provision
					else if (childNodeName.trim().equalsIgnoreCase("bad_debt_amt"))
					{
						errCode = checkBadDebtAmt(1, conn, dom);
						if(errCode == null && errCode.trim().length() == 0)
						{
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
					}
				}
				valueXmlString.append("</Detail2>");
				break;
			case 3:
				parentNodeList = dom.getElementsByTagName("Detail3");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				valueXmlString.append("<Detail3>");
				childNodeListLength = childNodeList.getLength();
				for (ctr = 0; ctr < childNodeListLength; ctr++)
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					if (childNodeName.equalsIgnoreCase("ref_no"))
					{
						refNo = this.genericUtility.getColumnValue("ref_no", dom);
						if(refNo != null && refNo.trim().length() > 0)
						{
							refSer = this.genericUtility.getColumnValue("ref_ser", dom);
							hcustCode = this.genericUtility.getColumnValue("cust_code", dom1);
							hsiteCode = this.genericUtility.getColumnValue("site_code", dom1);
							hcurrCode = this.genericUtility.getColumnValue("curr_code", dom1);
							htranDate = dateFormat2.parse(this.genericUtility.getColumnValue("tran_date", dom1));
							sql = "select  cust_code, site_code, curr_code, due_date from receivables where tran_ser = ? and ref_no = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, refSer);
							pstmt.setString(2, refNo);
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								custCode = rs.getString(1);
								siteCode = rs.getString(2);
								currCode = rs.getString(3);
								dueDate = rs.getDate(4);
								if(!custCode.trim().equals(hcustCode.trim()))
								{
									errCode = "VTCGRP1";
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
								}
								else if(!siteCode.trim().equals(hsiteCode.trim()))
								{
									errCode = "VTSITE1";
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
								}
								else if(!currCode.trim().equals(hcurrCode.trim()))
								{
									errCode = "VTCURR1";
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
								}
								else {
									if (dueDate.after(htranDate))
									{
										errCode = "VTADVDT";
										errList.add(errCode);
										errFields.add(childNodeName.toLowerCase());
									}
								}
							}
							else
							{    
								errCode = "VMREF1";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
						}
						else
						{
							errCode = "VTSPECREF";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
					}
					else if (childNodeName.equalsIgnoreCase("adj_amt"))
					{
						adjAmt = Double.parseDouble(this.genericUtility.getColumnValue("adj_amt", dom));
						refNo = this.genericUtility.getColumnValue("ref_no", dom);
						refSer = this.genericUtility.getColumnValue("ref_ser", dom);
						sql = "select tot_amt - adj_amt from receivables where tran_ser = ? and ref_no = ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, refSer);
						pstmt.setString(2, refNo);
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							balAmt = rs.getDouble(1);
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;

						if (((balAmt >= 0.0D) || (rcpAmt >= 0.0D) || (Math.abs(balAmt) >= Math.abs(rcpAmt))) && 
								((balAmt <= 0.0D) || (rcpAmt <= 0.0D) || (Math.abs(balAmt) >= Math.abs(rcpAmt))) && ((balAmt <= 0.0D) || (rcpAmt >= 0.0D)) && (
										(balAmt >= 0.0D) || (rcpAmt <= 0.0D)))
							continue;
						errCode = "VTBAL1";
						errList.add(errCode);
						errFields.add(childNodeName.toLowerCase());

					}
				}
				valueXmlString.append("</Detail3>");
				break;
			case 4:
				parentNodeList = dom.getElementsByTagName("Detail4");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				valueXmlString.append("<Detail4>");
				childNodeListLength = childNodeList.getLength();
				for (ctr = 0; ctr < childNodeListLength; ctr++)
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					if (childNodeName.equalsIgnoreCase("ref_no"))
					{
						refNo = this.genericUtility.getColumnValue("ref_no", dom);
						if(refNo != null && refNo.trim().length() > 0)
						{
							refSer = this.genericUtility.getColumnValue("ref_ser", dom);
							amount = doublevalue(this.genericUtility.getColumnValue("amount", dom));
							htranDate = dateFormat2.parse(this.genericUtility.getColumnValue("tran_date", dom1));
							hbankCode = this.genericUtility.getColumnValue("bank_code", dom1);

							sql = "select count(*) from misc_payables where tran_ser = ? and ref_no = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, "E-FUND");
							pstmt.setString(2, refNo);
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								cnt = rs.getInt(1);
							}
							if (cnt == 0)
							{
								errCode = "VMREF1";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}	
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;

							sql = "select tot_amt, adj_amt, bank_code from misc_payables where tran_ser = ? and ref_no = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, "E-FUND");
							pstmt.setString(2, refNo);
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								totAmt = rs.getDouble(1);
								adjAmt = rs.getDouble(2);
								bankCode = rs.getString(3);
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;

							if (Math.abs(totAmt - adjAmt) < Math.abs(amount))
							{
								errCode = "VTINVPCAMT";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}

							if (!bankCode.trim().equals(hbankCode.trim()))
							{
								errCode = "VTBNKBD1";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}

						}
						else
						{
							errCode = "VTSPECREF";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}

					}
					else if(childNodeName.equalsIgnoreCase("curr_code"))
					{
						currCode = this.genericUtility.getColumnValue("curr_code", dom);
						if(currCode != null && currCode.trim().length() > 0)
						{
							sql = "select count(*) from currency where curr_code = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, currCode);
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								cnt = rs.getInt(1);
							}
							if (cnt == 0)
							{
								errCode = "VMCUR1";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}

							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							/*
							hcurrCode = this.genericUtility.getColumnValue("curr_code", dom1);
							exchRate = doublevalue(this.genericUtility.getColumnValue("exch_rate", dom));
							if (!currCode.trim().equalsIgnoreCase(hcurrCode.trim()) && (exchRate != 1.0))
							{
								errCode = "VTCUR3";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
							*/
							
						}
						else
						{

							errCode = "VMCURRCD1";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
					}
					else if (childNodeName.equalsIgnoreCase("tran_date"))
					{
						heffDate = dateFormat2.parse(this.genericUtility.getColumnValue("tran_date", dom1));

						htranDate = dateFormat2.parse(this.genericUtility.getColumnValue("tran_date", dom1));
						if (heffDate.before(htranDate))
						{
							errCode = "VTINVDT";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
					}

					else if(childNodeName.equalsIgnoreCase("amount"))
					{
						amount = doublevalue(this.genericUtility.getColumnValue("amount", dom));
						refNo = this.genericUtility.getColumnValue("ref_no", dom);
						htranId = this.genericUtility.getColumnValue("tran_id", dom1);
						if (amount == 0.0)
						{
							errCode = "VTLNAMT";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
						else
						{
							sql = "select (case when bal_amt is null then 0.0 else bal_amt end) from export_fund where tran_id = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, refNo);
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								balAmt = rs.getDouble(1);
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;

							sql = "select sum(case when e.amount is null then 0.0 else e.amount end) from receipt r, rcpepc_adj e where r.tran_id = e.tran_id and r.tran_id != ? and e.ref_no = ? and (case when r.confirmed is null then 'N' else r.confirmed end) != 'Y'";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, htranId);
							pstmt.setString(2, refNo);
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								Amt = rs.getDouble(1);
							}
							else
							{
								Amt = 0.0;
							}

							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;

							if (Math.abs(amount) + Math.abs(Amt) > balAmt)
							{
								errCode = "VTINVPCAMT";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
							else
							{
								amountBc = doublevalue(this.genericUtility.getColumnValue("amount__bc", dom));
								amountBc = (amountBc+doublevalue(this.genericUtility.getColumnValue("diff_amt__exch", dom)));
								chequeAmt = doublevalue(this.genericUtility.getColumnValue("cheque_amt", dom1));
								exchRate = doublevalue(this.genericUtility.getColumnValue("exch_rate", dom1));
								if (chequeAmt == 10.0D)
								{
									chequeAmt = 0.0D;
								}
								if (exchRate == 0.0D)
								{
									exchRate = 1.0D;
								}
								chequeAmt *= exchRate;
								for (crt = 1; crt <= parentNodeList.getLength(); crt++)
								{
									amountBc += Math.abs(doublevalue(this.genericUtility.getColumnValue("amount__bc", dom)));
									amountBc += doublevalue(this.genericUtility.getColumnValue("diff_amt__exch", dom));
								}

								if (crt > 0)
								{
									amountBc += Math.abs(doublevalue(this.genericUtility.getColumnValue("amount__bc", dom)));
									amountBc += doublevalue(this.genericUtility.getColumnValue("diff_amt__exch", dom));
								}
								if (chequeAmt - amountBc >= 0.0D)
									continue;
								errCode = "VTAMT1";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}

						}

					}
				}

				valueXmlString.append("</Detail4>");
				break;
			case 5:
				parentNodeList = dom.getElementsByTagName("Detail5");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				valueXmlString.append("<Detail5>");
				childNodeListLength = childNodeList.getLength();
				for (ctr = 0; ctr < childNodeListLength; ctr++)
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					if (childNodeName.equalsIgnoreCase("acct_code"))
					{
						acctCode = this.genericUtility.getColumnValue("acct_code", dom);
						if(acctCode != null && acctCode.trim().length() > 0)
						{
							hsiteCode = this.genericUtility.getColumnValue("site_code", dom1);
							errCode = finCommon.isAcctCode(hsiteCode, acctCode,"FIN", conn);
							if(errCode != null && errCode.trim().length() > 0)
							{
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
						}
					}
					else if (childNodeName.equalsIgnoreCase("curr_code"))
					{
						currCode = this.genericUtility.getColumnValue("curr_code", dom);
						if(currCode != null && currCode.trim().length() > 0)
						{
							sql = "select count(*) from currency where curr_code = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, currCode);
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								cnt = rs.getInt(1);
							}
							if (cnt == 0)
							{
								errCode = "VMCUR1";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}

							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							/*
							hcurrCode = this.genericUtility.getColumnValue("curr_code", dom1);
							exchRate = Double.parseDouble(this.genericUtility.getColumnValue("exch_rate", dom));
							if(!currCode.trim().equals(hcurrCode.trim()))
							{
								errCode = "VTCUR3";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
							*/
						}
						else
						{

							errCode = "VMCURRCD1";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}

					}
					else if (childNodeName.equalsIgnoreCase("cctr_code"))
					{
						cctrCode = this.genericUtility.getColumnValue("cctr_code", dom);
						System.out.println("CTTC CODE "+cctrCode);
						if(cctrCode != null && cctrCode.trim().length() > 0)
						{
							acctCode = this.genericUtility.getColumnValue("acct_code", dom);
							//if(acctCode == null || acctCode.trim().length() == 0){acctCode="";}
							System.out.println("CTTC CODE 111["+cctrCode+""+acctCode);
							errCode = finCommon.isCctrCode(acctCode, cctrCode, "FIN", conn);
							if(errCode != null && errCode.trim().length() > 0)
							{
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}

						}
					}

					else if (childNodeName.equalsIgnoreCase("anal_code"))
					{
						analCode = this.genericUtility.getColumnValue("anal_code", dom);
						System.out.println("CTTC CODE "+cctrCode);
						if(analCode != null && analCode.trim().length() > 0)
						{
							sql = "select count(*) from analysis where anal_code = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, analCode);
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								cnt = rs.getInt(1);
							}
							if(cnt == 0)
							{
								errCode = "VMANAL1";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
						}
					}
					else if(childNodeName.equalsIgnoreCase("emp_code"))
					{
						refSer = checkNull(this.genericUtility.getColumnValue("ref_ser", dom));
						empCode = this.genericUtility.getColumnValue("emp_code", dom);
						if(empCode != null && empCode.trim().length() > 0)
						{
							hsiteCode = this.genericUtility.getColumnValue("site_code", dom1);
							errCode = finCommon.isEmployee(hsiteCode, empCode, refSer, conn);
							//errCode = this.validateEmpCode(hsiteCode, empCode, conn);
							if(errCode != null && errCode.trim().length() > 0)
							{
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
						}

					}
				}

				valueXmlString.append("</Detail5>");				
			}

			int errListSize = errList.size();
			cnt = 0;
			String errFldName = null;
			System.out.println("errListSize [" + errListSize + "] errFields size [" + errFields.size() + "]");
			if ((errList != null) && (errListSize > 0))
			{
				for (cnt = 0; cnt < errListSize; cnt++)
				{
					errCode = (String)errList.get(cnt);
					errFldName = (String)errFields.get(cnt);
					System.out.println(" cnt [" + cnt + "] errCode [" + errCode + "] errFldName [" + errFldName + "]");
					errString = getErrorString(errFldName, errCode, userId);
					errorType = errorType(conn, errCode);
					if (errString.length() > 0)
					{
						String bifurErrString = errString.substring(errString.indexOf("<Errors>") + 
								8, errString.indexOf("<trace>"));
						bifurErrString = bifurErrString + 
								errString.substring(errString.indexOf("</trace>") + 
										8, errString.indexOf("</Errors>"));
						errStringXml.append(bifurErrString);
						errString = "";
					}
					if (errorType.equalsIgnoreCase("E"))
					{
						break;
					}
				}

				errStringXml.append("</Errors> </Root> \r\n");
			}
			else
			{
				errStringXml = new StringBuffer("");
			}

		}
		catch (Exception e)
		{
			e.printStackTrace();
			errString = e.getMessage();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					{
						rs.close();
						rs = null;
					}
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}

					conn.close();
				}
				conn = null;
			}
			catch (Exception d)
			{
				d.printStackTrace();
				throw new ITMException(d);
			}
		}
		errString = errStringXml.toString();
		return errString;
	}

	/*public String getfinparm(String pCode, String varName,Connection conn )
	{
		String sql = "";
		String varValue = "";
		String addValue = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try
		{
			sql = "select var_value, addl_value from finparm where prd_code = ? and var_name = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, pCode);
			pstmt.setString(2, varName);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				varValue = rs.getString(1);
				addValue = rs.getString(2);
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

			if(addValue == null || addValue.trim().length() == 0)
			{
				return varValue.trim();
			}
		}
		catch (Exception e)
		{
			System.out.println(e.getMessage());
		}
		return addValue.trim();
	}
	 */
	/*	public String validateAccount(String sitecode, String acctcode, Connection conn)
	{

		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String siteSpec = "";
		String active = "";
		String errCode = "";
		int cnt = 0;
		try
		{
			sql = "select var_value from finparm where prd_code = '999999' and var_name = 'SITE_SPECIFIC_ACCT' ";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				siteSpec = rs.getString(1);
			}
			sql = "select count(*) from accounts where acct_code = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, acctcode);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				cnt = rs.getInt(1);
			}
			if (cnt != 0)
			{
				sql = "select active from accounts where acct_code = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, acctcode);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					active = rs.getString(1);
				}
				if (!active.equals("Y"))
				{
					errCode = "VMACCTA";
				}
				else if ((siteSpec != null) && (siteSpec.equals("Y")))
				{
					sql = "select count(*) from  site_account where site_code = ? and acct_code = ?";

					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, sitecode);
					pstmt.setString(2, acctcode);
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						cnt = rs.getInt(1);
					}
					if (cnt == 0)
					{
						errCode = "VMACCT3";
					}
				}

			}
			else
			{
				errCode = "VMACCT1";
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
		}
		catch (Exception e)
		{
			System.out.println(e.getMessage());
		}
		return errCode;
	}*/

	/*public String validateCctrCode(String cctrCode, String acctCode, Connection conn) {

		String sql = "";
		String errCode = "";
		String finparamCcterm = "";
		int cnt = 1;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try
		{
			finparamCcterm = getfinparm("999999", "CCTR_CHECK", conn) ;
			if (finparamCcterm.equalsIgnoreCase("Y"))
			{
				if ((cctrCode.trim().length() > 0) && (cctrCode != null))
				{
					sql = "select count(*) from costctr where cctr_code = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, cctrCode);
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						cnt = rs.getInt(1);
					}
					if(cnt == 0)
					{
						errCode = "VMCCTR1";
					}

					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
				}
				sql = "select count(*) from accounts_cctr where acct_code = ? and cctr_code = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, acctCode);
				pstmt.setString(2, cctrCode);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					cnt = rs.getInt(1);
				}
				if (cnt == 0)
				{
					sql = "select count(*) from accounts_cctr where acct_code = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, acctCode);
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						cnt = rs.getInt(1);
						if (cnt == 0)
						{
							if(cctrCode != null && cctrCode.trim().length() > 0)
							{

								errCode = "VMCCTR2";
							}
						}
					}
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
			}
		}
		catch (Exception e)
		{
			System.out.println(e.getMessage());
		}
		return errCode;
	}*/

	/*	public String validateBankCode(String bankCode, String siteCode, Connection conn) {
		String sql = "";
		String errCode = "";
		String siteCodel = "";
		int cnt = 0;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try
		{
			sql = "select count(*) from bank where bank_code = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, bankCode);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				cnt = rs.getInt(1);
			}
			if (cnt == 0)
			{
				errCode = "VMBANK1";
			}
			else
			{
				sql = "select site_code from bank where bank_code = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, bankCode);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					siteCodel = rs.getString(1);
				}
				if (!siteCodel.trim().equalsIgnoreCase(siteCode.trim()))
				{
					errCode = "VTBANKMIS";
				}
				sql = "select count(*) from site_bank where site_code = ? and bank_code = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, siteCode);
				pstmt.setString(2, bankCode);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					cnt = rs.getInt(1);
				}
				if (cnt == 0)
				{
					errCode = "VMBANKMIS1";
				}
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
		}
		catch (Exception e) {
			System.out.println(e.getMessage());
		}
		return errCode;
	}*/

	/*public String validateAnalysisCode(String acctCodeBal, String analCode, Connection conn)
	{
		String sql = "";
		String errCode = "";
		int cnt = 1;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try
		{
			if ((analCode.trim().length() > 0) && (analCode != null))
			{
				sql = "select count(*) from analysis where anal_code = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, analCode);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					cnt = rs.getInt(1);
					if (cnt == 0)
					{
						errCode = "VMANAL1";
					}
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
			}

			if (errCode.trim().length() > 0)
				return errCode;
			sql = "select count(*) from accounts_analysis where acct_code = ? and anal_code = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, acctCodeBal);
			pstmt.setString(2, analCode);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				cnt = rs.getInt(1);
			}

			if (cnt == 0)
			{
				sql = "select count(*) from accounts_analysis where acct_code = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, acctCodeBal);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					cnt = rs.getInt(1);
				}
				if (cnt > 0)
					errCode = "VMANAL1";
				else if (cnt == 0)
				{
					if ((analCode.trim().length() > 0) && (analCode != null))
					{
						errCode = "VMANAL2";
					}
				}
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
		}
		catch (Exception e) {
			System.out.println(e.getMessage());
		}
		return errCode;
	}*/
	/*	public String validateEmpCode(String siteCode, String empCode, Connection conn)
	{
		String sql = "";
		String errCode = "";
		String empSite = "";
		String finEntity1 = "";
		String finEntity2 = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		int cnt = 0;
		try
		{

			sql = "select count(*) from employee where emp_code = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, empCode);
			rs = pstmt.executeQuery();
			if (rs.next())
			{	
				cnt = rs.getInt(1);
			}
			if( cnt > 0)
			{
				sql = "select emp_site from employee where emp_code = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, empCode);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					empSite = rs.getString(1);
				}

				sql = "select fin_entity from site where site_code = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, siteCode);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					finEntity1 = rs.getString(1);
				}
				sql = "select fin_entity from site where site_code = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, empSite);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					finEntity2 = rs.getString(1);
				}
				if (!finEntity1.equals(finEntity2))
				{
					errCode = "VEMPINSITE";
				}
				else if (siteCode.equalsIgnoreCase(empSite))
				{
					errCode = "VMSITE2";
				}
			}
			else
			{
				errCode = "VMEMPCDMT";	
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

		}
		catch (Exception e)
		{
			System.out.println(e.getMessage());
		}

		return errCode;
	}*/

	public String itemChanged(String xmlString, String xmlString1, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String valueXmlString = "";
		try
		{
			dom = parseString(xmlString);
			dom1 = parseString(xmlString1);
			valueXmlString = itemChanged(dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams);
		}
		catch (Exception e)
		{
			System.out.println("Exception : [MiscVal][itemChanged( String, String )] :==>\n" + 
					e.getMessage());
		}
		return valueXmlString;
	}
	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) 			throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String valueXmlString = "";
		try
		{
			dom = parseString(xmlString);
			dom1 = parseString(xmlString1);
			if (xmlString2.trim().length() > 0)
			{
				dom2 = parseString(xmlString2);
			}
			valueXmlString = itemChanged(dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams);
		}
		catch (Exception e)
		{
			System.out.println("Exception : [MiscVal][itemChanged( String, String )] :==>\n" + 
					e.getMessage());
		}
		return valueXmlString;
			}


	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		String childNodeName = null;
		String sql = "";
		String dateNow = "";
		String siteDescr = "";
		String currCode = "";
		String columnValue = "";
		String empFname = "";
		String empLname = "";
		String tranType = "";
		String errCode = "";
		String BankCode = "";
		String tranIdAdvbking = "";
		String tranId = "";
		String hTranId = "";
		String saleOrder = "";
		String custCode = "";
		String siteCode = "";
		String hsiteCode = "";
		String acctCodeAr = "";
		String cctrCodeAr = "";
		String rcpMode = "";
		String bankName = "";
		String acctCodeAdv = "";
		String cctrCodeAdv = "";
		String finEntity = "";
		String acctPrd = "";
		String lsAdvbking = "";
		String CurrCode = "";
		String finentDescr = "";
		String bankCode = "";
		String cashCode = "";
		String acctCodeBal = "";
		String cctrCodeBal = "";
		String loginSite = "";
		String acctCodeCf = "";
		String cctrCodeCf = "";
		String acctCodeCfAr = "";
		String cctrCodeCfAr = "";
		String chqamt = "";
		String billamt = "";
		String advadjamt = "";
		String netamt = "";
		String othamt = "";
		String finchg = "";
		String billdiscamt = "";
		String chequeamt = "";
		String CurrCodeFrom = "";
		String billDisc = "";
		String rcvSer = "";
		String refNo = "";
		String refSer = "";
		String lineNoRef = "";
		String tranSer = "";
		String acctCode = "";
		String cctrCode = "";
		String currDescr = "";
		String accDescr = "";
		String crTrem = "";
		String fchgType = "";
		String sundryType = "";
		String sundryCode = "";
		String empCode = "";
		String fcurrCode = "";
		String deteditflag = "";
		String hcurrCode = "";
		String bdFluctuationCf = "";
		String rcpAutoFinchg = "";
		String custName = "";
		String lcBillDescAmt = "";
		double amountBc = 0.0D;
		double discExchRate = 0.0D;
		double mexchrate = 0.0D;
		double amount = 0.0D;
		double adjAmt = 0.0D;
		double discount = 0.0D;
		double lcDiff = 0.0D;
		double discountLc = 0.0D;
		double taxAmt = 0.0D;
		double totAmt = 0.0D;
		double chqAmt = 0.0D;
		double billAmt = 0.0D;
		double advAmt = 0.0D;
		double exchRate = 0.0D;
		double hexchRate = 0.0D;
		double sumAdvAmt = 0.0D;
		double advadjAmt = 0.0D;
		double badDebtAmt = 0.0D;
		double othAmt = 0.0D;
		double billDisCamt = 0.0D;
		double diffAmtExch = 0.0D;
		double finChg = 0.0D;
		double adv = 0.0D;
		double netAmt = 0.0D;
		double chequeAmt = 0.0D;
		double rcpAmt = 0.0D;
		double exch = 0.0D;
		int instrPerSlip = 0;
		double stdExRt = 0 ;
		int days = 0;
		int ctr = 0;
		int currentFormNo = 0;
		int childNodeListLength = 0;
		java.util.Date tranDate = null;
		//String tranDate = null;
		java.util.Date refDate = null;
		java.util.Date effDate = null;
		java.util.Date dueDate = null;
		java.util.Date htranDate = null;
		ArrayList errList = new ArrayList();
		ArrayList errFields = new ArrayList();
		//SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/mm/dd");
		//SimpleDateFormat dateFormat1 = new SimpleDateFormat("dd/MM/yy");
		SimpleDateFormat dateFormat1 = null;;
		//SimpleDateFormat dateFormat2 = new SimpleDateFormat("dd-MMM-yy");
		SimpleDateFormat sdf;
		StringBuffer valueXmlString = new StringBuffer();
		Connection conn = null;
		PreparedStatement pstmt = null;
		String hCurrCode = "";
		ResultSet rs = null;
		GenericUtility genericUtility = GenericUtility.getInstance();
		ConnDriver connDriver = new ConnDriver();
		try
		{
			sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			dateFormat1=new SimpleDateFormat(genericUtility.getApplDateFormat());
			conn = connDriver.getConnectDB("DriverITM");
			conn.setAutoCommit(false);
			connDriver = null;
			this.finCommon = new FinCommon();
			Calendar currentDate = Calendar.getInstance();
			SimpleDateFormat simpleDateFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
			if ((objContext != null) && (objContext.trim().length() > 0))
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			valueXmlString = new StringBuffer("<?xml version = \"1.0\"?> <Root> <header> <editFlag>");
			valueXmlString.append(editFlag).append("</editFlag> </header>");
			switch (currentFormNo)
			{
			case 1:
				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				valueXmlString.append("<Detail1>");
				childNodeListLength = childNodeList.getLength();
				System.out.println("first receipt mode ------>"+genericUtility.getColumnValue("rcp_mode", dom));
				do
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					if (childNodeName.equals(currentColumn))
					{
						childNode.getFirstChild();
					}

					ctr++;
				}
				while ((ctr < childNodeListLength) && (!
						childNodeName.equals(currentColumn)));
				if (currentColumn.trim().equalsIgnoreCase("itm_defaultedit"))
				{
					tranType = genericUtility.getColumnValue("tran_type", dom);
					valueXmlString.append("<tran_type>").append("<![CDATA["+tranType.trim()+"]]>").append("</tran_type>");
					BankCode = genericUtility.getColumnValue("bank_code", dom);
					sql = "select  case when instr_per_slip is null then 0 else instr_per_slip end from bank where bank_code = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, BankCode);
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						instrPerSlip = rs.getInt(1);
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;

					if (instrPerSlip == 0)
					{
						valueXmlString.append("<entry_batch_no protect = \"0\">").append("<![CDATA["+""+"]]>").append("</entry_batch_no>");
					}
					else
					{
						valueXmlString.append("<entry_batch_no protect = \"1\">").append("<![CDATA["+""+"]]>").append("</entry_batch_no>");
					}

					tranIdAdvbking = genericUtility.getColumnValue("tran_id__advbking", dom);
					if ((tranIdAdvbking == null) || (tranIdAdvbking.length() == 0))
					{
						valueXmlString.append("<curr_code protect = \"0\">").append("<![CDATA["+genericUtility.getColumnValue("curr_code", dom)+"]]>").append("</curr_code>");
						valueXmlString.append("<exch_rate protect = \"0\">").append("<![CDATA["+genericUtility.getColumnValue("exch_rate", dom)+"]]>").append("</exch_rate>");
					}
					else
					{
						valueXmlString.append("<curr_code protect = \"1\">").append("<![CDATA["+genericUtility.getColumnValue("curr_code", dom)+"]]>").append("</curr_code>");
						siteCode = genericUtility.getColumnValue("site_code", dom);
						currCode = genericUtility.getColumnValue("curr_code", dom);
						sql = "select curr_code from finent, site where finent.fin_entity = site.fin_entity and site.site_code = ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, siteCode);
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							fcurrCode =  rs.getString(1);
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
					
						if (fcurrCode.trim().equals(currCode.trim()) )
						{
							valueXmlString.append("<exch_rate protect = \"1\">").append("<![CDATA["+genericUtility.getColumnValue("exch_rate", dom)+"]]>").append("</exch_rate>");
						}
						else
						{
							valueXmlString.append("<exch_rate protect = \"0\">").append("<![CDATA["+genericUtility.getColumnValue("exch_rate", dom)+"]]>").append("</exch_rate>");
						}
					}

					tranId = genericUtility.getColumnValue("tran_id", dom);
					sql = " select count(*) from rcpdet where tran_id = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, tranId);
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						instrPerSlip =  rs.getInt(1);
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					
					
					if (instrPerSlip > 0)
					{
						//valueXmlString.append("<exch_rate protect = \"1\">").append("<![CDATA["+genericUtility.getColumnValue("exch_rate", dom)+"]]>").append("</exch_rate>");
						valueXmlString.append("<site_code protect = \"1\">").append("<![CDATA["+genericUtility.getColumnValue("site_code", dom)+"]]>").append("</site_code>");
						valueXmlString.append("<cust_code protect = \"1\">").append("<![CDATA["+genericUtility.getColumnValue("cust_code", dom)+"]]>").append("</cust_code>");
						valueXmlString.append("<curr_code protect = \"1\">").append("<![CDATA["+genericUtility.getColumnValue("curr_code", dom)+"]]>").append("</curr_code>");
						valueXmlString.append("<sale_order protect = \"1\">").append("<![CDATA["+checkNull(genericUtility.getColumnValue("sale_order", dom))+"]]>").append("</sale_order>");
					}
					else
					{
						valueXmlString.append("<cust_code protect = \"0\">").append("<![CDATA["+genericUtility.getColumnValue("cust_code", dom)+"]]>").append("</cust_code>");
						valueXmlString.append("<curr_code protect = \"0\">").append("<![CDATA["+genericUtility.getColumnValue("curr_code", dom)+"]]>").append("</curr_code>");
						valueXmlString.append("<sale_order protect = \"0\">").append("<![CDATA["+checkNull(genericUtility.getColumnValue("sale_order", dom))+"]]>").append("</sale_order>");
					}
					System.out.println(" detail count [" + instrPerSlip + "] valueXmlString [" + valueXmlString.toString() + "]" );

				}
				else if (currentColumn.trim().equalsIgnoreCase("itm_default"))
				{
					loginSite = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
					valueXmlString.append("<tran_date >").append("<![CDATA[" + sdf.format(new Date())+ "]]>").append("</tran_date>");
					valueXmlString.append("<ref_date >").append("<![CDATA[" + sdf.format(new Date()) + "]]>").append("</ref_date>");
					valueXmlString.append("<eff_date >").append("<![CDATA[" + sdf.format(new Date()) + "]]>").append("</eff_date>");
					valueXmlString.append("<net_amt >").append("<![CDATA[0]]>").append("</net_amt>");
					valueXmlString.append("<bill_amt >").append("<![CDATA[0]]>").append("</bill_amt>");
					valueXmlString.append("<diff_amt__exch >").append("<![CDATA[0]]>").append("</diff_amt__exch>");
					valueXmlString.append("<exch_rate protect = \"0\">").append("<![CDATA["+""+"]]>").append("</exch_rate>");
					valueXmlString.append("<site_code >").append("<![CDATA[" + loginSite + "]]>").append("</site_code>");
					setNodeValue(dom, "site_code", getAbsString(siteCode));
				}
				else if (currentColumn.trim().equalsIgnoreCase("tran_date"))
				{
					tranDate = dateFormat1.parse(genericUtility.getColumnValue("tran_date", dom));
					refDate = dateFormat1.parse(genericUtility.getColumnValue("ref_date", dom));
					valueXmlString.append("<ref_date >").append("<![CDATA[" + simpleDateFormat.format(tranDate) + "]]>").append("</ref_date>");
					valueXmlString.append("<eff_date >").append("<![CDATA[" + simpleDateFormat.format(tranDate) + "]]>").append("</eff_date>");
				}
				else if (currentColumn.trim().equalsIgnoreCase("sale_order"))
				{
					saleOrder = genericUtility.getColumnValue("sale_order", dom);
					if ((saleOrder != null) && (saleOrder.trim().length() > 0))
					{
						sql = " select cust_code, site_code FROM sorder where sale_order = ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, saleOrder);
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							custCode = rs.getString(1);
							siteCode = rs.getString(2);
							valueXmlString.append("<cust_code>").append("<![CDATA[" + custCode + "]]>").append("</cust_code>");
							setNodeValue(dom, "cust_code", getAbsString(custCode));
							valueXmlString.append("<site_code>").append("<![CDATA[" + siteCode + "]]>").append("</site_code>");
							setNodeValue(dom, "site_code", getAbsString(siteCode));
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
					}
				}
				else if (currentColumn.trim().equalsIgnoreCase("site_code"))
				{
					siteCode = genericUtility.getColumnValue("site_code", dom);
					rcpMode = genericUtility.getColumnValue("rcp_mode", dom);
					if (rcpMode.equals("C"))
					{
						sql = "select descr, fin_entity, cash_code from site where site_code = ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, siteCode);
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							siteDescr = rs.getString(1);
							finEntity = rs.getString(2);
							cashCode = rs.getString(3);
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
					}
					else
					{
						sql = "select descr, fin_entity, bank_code from site where site_code = ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, siteCode);
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							siteDescr = rs.getString(1);
							finEntity = rs.getString(2);
							bankCode = rs.getString(3);
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;

						sql = "select curr_code from bank where bank_code = ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, bankCode);
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							currCode = rs.getString(1);
							valueXmlString.append("<curr_code>").append("<![CDATA["+ currCode+"]]>").append("</curr_code>");
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;

						sql = "select std_exrt  from currency where curr_code = ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, currCode);
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							stdExRt = rs.getDouble(1);
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;

						//valueXmlString.append("<exch_rate protect = \"1\">").append("<![CDATA[" + stdExRt +"]]>").append("</exch_rate>");
					}
					sql = "select descr from finent where fin_entity = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, finEntity);
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						finentDescr = rs.getString(1);
					}

					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;


					//bankCode = bankCode.trim();

					sql = " select bank_name, acct_code__bal, cctr_code__bal, acct_code__cf, cctr_code__cf,acct_code__cf_ar, cctr_code__cf_ar from bank where bank_code = ?";

					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, bankCode);
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						bankName = rs.getString(1);
						acctCodeBal = rs.getString(2);
						cctrCodeBal = rs.getString(3);
						acctCodeCf = rs.getString(4);
						cctrCodeCf = rs.getString(5);
						acctCodeCfAr = rs.getString(6);
						cctrCodeCfAr = rs.getString(7);
					}

					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;


					if ((acctCodeCfAr != null) && (acctCodeCfAr.trim().length() > 0))
					{
						acctCodeCf = acctCodeCfAr;
					}
					if ((cctrCodeCfAr != null) && (cctrCodeCfAr.trim().length() > 0))
					{
						cctrCodeCf = cctrCodeCfAr;
					}
					valueXmlString.append("<site_descr>").append("<![CDATA[" + siteDescr + "]]>").append("</site_descr>");
					valueXmlString.append("<fin_entity>").append("<![CDATA[" + finEntity + "]]>").append("</fin_entity>");
					valueXmlString.append("<finent_descr>").append("<![CDATA[" + finentDescr + "]]>").append("</finent_descr>");
					valueXmlString.append("<bank_code>").append("<![CDATA[" + bankCode + "]]>").append("</bank_code>");
					valueXmlString.append("<bank_bank_name>").append("<![CDATA[" + bankName + "]]>").append("</bank_bank_name>");
					valueXmlString.append("<acct_code__bal>").append("<![CDATA[" + acctCodeBal + "]]>").append("</acct_code__bal>");
					valueXmlString.append("<cctr_code__bal>").append("<![CDATA[" + cctrCodeBal + "]]>").append("</cctr_code__bal>");
					valueXmlString.append("<acct_code__cf>").append("<![CDATA[" + acctCodeCf + "]]>").append("</acct_code__cf>");
					valueXmlString.append("<cctr_code__cf >").append("<![CDATA[" + cctrCodeCf + "]]>").append("</cctr_code__cf>");
					custCode = genericUtility.getColumnValue("cust_code", dom);
					if (custCode.equals("          "))
					{
						valueXmlString.append("<cust_name>").append("<![CDATA["+""+"]]>").append("</cust_name>");
						valueXmlString.append("<acct_code__ar>").append("<![CDATA[]]>").append("</acct_code__ar>");
						valueXmlString.append("<cctr_code__ar>").append("<![CDATA[]]>").append("</cctr_code__ar>");
						tranDate = dateFormat1.parse(genericUtility.getColumnValue("tran_date", dom));
						// 21/09/13 manoharan caqll common function
						//mexchrate = takeExchRate(currCode, "", siteCode, tranDate, "S", conn);
						mexchrate = finCommon.getDailyExchRateSellBuy(currCode,"",siteCode, genericUtility.getColumnValue("tran_date", dom), "S", conn);

						currCode = genericUtility.getColumnValue("curr_code", dom);
						setNodeValue(dom, "curr_code", getAbsString(currCode));
						tranIdAdvbking = genericUtility.getColumnValue("tran_id__advbking", dom);
						if ((tranIdAdvbking == null) || (tranIdAdvbking.length() == 0))
						{
							valueXmlString.append("<exch_rate >").append("<![CDATA[" + mexchrate + "]]>").append("</exch_rate>");
							valueXmlString.append("<exch_rate_spot >").append("<![CDATA[" + mexchrate + "]]>").append("</exch_rate_spot>");
							//valueXmlString.append("<exch_rate protect = \"1\">").append("<![CDATA["+ mexchrate +"]]>").append("</exch_rate>");
						}
						else
						{
							valueXmlString.append("<exch_rate_spot>").append("<![CDATA[" + mexchrate + "]]>").append("</exch_rate_spot>");
						}

					}



				}
				else if (currentColumn.trim().equalsIgnoreCase("bank_code"))
				{
					bankCode = genericUtility.getColumnValue("bank_code", dom);
					sql = "select bank_name,case when acct_code__bal is null then '' else acct_code__bal end,case when cctr_code__bal is null then '' else cctr_code__bal end,acct_code__cf, cctr_code__cf, instr_per_slip,case when acct_code__cf_ar is null then '' else acct_code__cf_ar end, case when cctr_code__cf_ar is null then '' else cctr_code__cf_ar end from bank where bank_code = ?";

					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, bankCode);
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						bankName = rs.getString(1);
						acctCodeBal = rs.getString(2);
						cctrCodeBal = rs.getString(3);
						acctCodeCf = rs.getString(4);
						cctrCodeCf = rs.getString(5);
						instrPerSlip = rs.getInt(6);
						acctCodeCfAr = rs.getString(7);
						cctrCodeCfAr = rs.getString(8);
					}

					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;

					if ((acctCodeCfAr != null) && (acctCodeCfAr.trim().length() > 0))
					{
						acctCodeCf = acctCodeCfAr;
					}
					if ((cctrCodeCfAr != null) && (cctrCodeCfAr.trim().length() > 0))
					{
						cctrCodeCf = cctrCodeCfAr;
					}
					valueXmlString.append("<bank_bank_name>").append("<![CDATA[" + bankName + "]]>").append("</bank_bank_name>");
					valueXmlString.append("<acct_code__bal>").append("<![CDATA[" + acctCodeBal + "]]>").append("</acct_code__bal>");
					valueXmlString.append("<cctr_code__bal>").append("<![CDATA[" + cctrCodeBal + "]]>").append("</cctr_code__bal>");
					valueXmlString.append("<acct_code__cf>").append("<![CDATA[" + acctCodeCf + "]]>").append("</acct_code__cf>");
					valueXmlString.append("<cctr_code__cf >").append("<![CDATA[" + cctrCodeCf + "]]>").append("</cctr_code__cf>");
					if (instrPerSlip == 0)
					{
						valueXmlString.append("<entry_batch_no protect = \"0\">").append("<![CDATA[0]]>").append("</entry_batch_no>");
					}
					else
					{
						valueXmlString.append("<entry_batch_no protect = \"1\">").append("<![CDATA[]]>").append("</entry_batch_no>");
					}

				}

				else if(currentColumn.trim().equalsIgnoreCase("cust_code"))
				{
					custCode = genericUtility.getColumnValue("cust_code", dom);
					siteCode = genericUtility.getColumnValue("site_code", dom);

					sql = "select cust_name, acct_code__ar, cctr_code__ar, curr_code, rcp_mode, bank_name, acct_code__adv, cctr_code__adv from customer where cust_code = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, custCode);
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						custName = rs.getString(1);
						acctCodeAr = rs.getString(2);
						cctrCodeAr = rs.getString(3);
						currCode = rs.getString(4);
						rcpMode = rs.getString(5);
						bankName = rs.getString(6);
						acctCodeAdv = rs.getString(7);
						cctrCodeAdv = rs.getString(8);
					}

					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;


					valueXmlString.append("<cust_name>").append("<![CDATA[" + custName + "]]>").append("</cust_name>");
					valueXmlString.append("<acct_code__ar>").append("<![CDATA[" + acctCodeAr + "]]>").append("</acct_code__ar>");
					valueXmlString.append("<cctr_code__ar>").append("<![CDATA[" + cctrCodeAr + "]]>").append("</cctr_code__ar>");
					valueXmlString.append("<curr_code>").append("<![CDATA[" + currCode + "]]>").append("</curr_code>");
					bankName = (bankName== null ? "" : bankName);
					valueXmlString.append("<cust_bank_ref>").append("<![CDATA[" + bankName + "]]>").append("</cust_bank_ref>");
					valueXmlString.append("<acct_code__adv>").append("<![CDATA[" + acctCodeAdv + "]]>").append("</acct_code__adv>");
					valueXmlString.append("<cctr_code__adv>").append("<![CDATA[" + cctrCodeAdv + "]]>").append("</cctr_code__adv>");
					tranDate = dateFormat1.parse(genericUtility.getColumnValue("tran_date", dom));
					// 21/09/13 manoharan caqll common function
					//mexchrate = takeExchRate(currCode, "", siteCode, tranDate, "S", conn);
					mexchrate = finCommon.getDailyExchRateSellBuy(currCode,"",siteCode, genericUtility.getColumnValue("tran_date", dom), "S", conn);
					tranIdAdvbking = genericUtility.getColumnValue("tran_id__advbking", dom);
					if ((tranIdAdvbking == null) || (tranIdAdvbking.length() == 0))
					{
						valueXmlString.append("<exch_rate >").append("<![CDATA[" + mexchrate + "]]>").append("</exch_rate>");
						valueXmlString.append("<exch_rate_spot >").append("<![CDATA[" + mexchrate + "]]>").append("</exch_rate_spot>");
						//valueXmlString.append("<exch_rate protect = \"1\">").append("<![CDATA["+ mexchrate +"]]>").append("</exch_rate>");
					}
					else
					{
						valueXmlString.append("<exch_rate_spot protect = \"1\">").append("<![CDATA["+mexchrate+"]]>").append("</exch_rate_spot>");
					}
					if ((rcpMode != null) && (rcpMode.length() > 0))
					{
						valueXmlString.append("<rcp_mode>").append("<![CDATA[" + rcpMode + "]]>").append("</rcp_mode>");
						setNodeValue(dom, "site_code", getAbsString(siteCode));
					}

					sql = "select fin_entity from site where site_code = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, siteCode);
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						finEntity = rs.getString(1);
					}

					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;

					advAmt = Double.parseDouble(genericUtility.getColumnValue("adv_amt", dom));
					if (advAmt == 0.0D)
					{
						effDate = dateFormat1.parse(genericUtility.getColumnValue("eff_date", dom));
						sql = "select acct_prd from period where fr_date <= ? and to_date >= ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setDate(1, new java.sql.Date(tranDate.getTime()));
						pstmt.setDate(2, new java.sql.Date(tranDate.getTime()));
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							acctPrd = rs.getString(1);
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;

						sql = "select sum(case when adv_amt is null then 0 else adv_amt end) from sundrybal where acct_prd = ? and prd_code = ? and fin_entity = ? and sundry_code = ? and sundry_type = ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, acctPrd);
						pstmt.setString(2, "zzzzzz");
						pstmt.setString(3, finEntity);
						pstmt.setString(4, custCode);
						pstmt.setString(5, "C");
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							sumAdvAmt = rs.getDouble(1);
						}

						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;

						sumAdvAmt *= -1.0D;
						valueXmlString.append("<CFC_REMARKS >").append("<![CDATA[" + sumAdvAmt + "]]>").append("</CFC_REMARKS>");
					}


					setNodeValue(dom, "curr_code", getAbsString(currCode));
				}

				else if (currentColumn.trim().equalsIgnoreCase("curr_code"))
				{
					currCode = genericUtility.getColumnValue("curr_code", dom);
					siteCode = genericUtility.getColumnValue("site_code", dom);
					tranDate = dateFormat1.parse(getColumnValue("tran_date", dom));
					// 21/09/13 manoharan caqll common function
					//mexchrate = takeExchRate(currCode, "", siteCode, tranDate, "S", conn);
					mexchrate = finCommon.getDailyExchRateSellBuy(currCode,"",siteCode, genericUtility.getColumnValue("tran_date", dom), "S", conn);
					lsAdvbking = genericUtility.getColumnValue("tran_id__advbking", dom);
					if ((lsAdvbking == null) || (lsAdvbking.trim().length() == 0))
					{
						valueXmlString.append("<exch_rate_spot>").append("<![CDATA[" + mexchrate + "]]>").append("</exch_rate_spot>");
						valueXmlString.append("<exch_rate>").append("<![CDATA[" + mexchrate + "]]>").append("</exch_rate>");
						finEntity = genericUtility.getColumnValue("fin_entity", dom);
						sql = "select curr_code  from finent where fin_entity = ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, finEntity);
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							CurrCode = rs.getString(1);
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;


						if (currCode.trim().equals(CurrCode.trim()))
						{
							valueXmlString.append("<exch_rate protect = \"1\">").append("<![CDATA[" + mexchrate + "]]>").append("</exch_rate>");
						}
						else
						{
							valueXmlString.append("<exch_rate protect = \"0\">").append("<![CDATA[" + mexchrate + "]]>").append("</exch_rate>");
						}
					}
					else
					{
						valueXmlString.append("<exch_rate_spot>").append("<![CDATA[" + mexchrate + "]]>").append("</exch_rate_spot>");
					}

					sql = "select std_exrt  from currency where curr_code = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, currCode);
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						stdExRt = rs.getDouble(1);
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;

					//valueXmlString.append("<exch_rate protect = \"1\">").append("<![CDATA[" + stdExRt +"]]>").append("</exch_rate>");
					valueXmlString.append("<exch_rate_spot protect = \"0\">").append("<![CDATA[" + stdExRt + "]]>").append("</exch_rate_spot>");



				}
				else if (currentColumn.trim().equalsIgnoreCase("chq_amt"))
				{
					chqAmt = doublevalue(genericUtility.getColumnValue("chq_amt", dom));
					billAmt = doublevalue(genericUtility.getColumnValue("bill_amt", dom));
					advadjAmt = doublevalue(genericUtility.getColumnValue("advadj_amt", dom));
					netAmt = doublevalue(genericUtility.getColumnValue("net_amt", dom));
					othAmt = doublevalue(genericUtility.getColumnValue("oth_amt", dom));
					finChg = doublevalue(genericUtility.getColumnValue("fin_chg", dom));

					advAmt = chqAmt - billAmt - advadjAmt - (netAmt - othAmt) - finChg;
					billDisCamt = doublevalue(genericUtility.getColumnValue("bill_disc_amt", dom));
					chequeAmt = advAmt + billAmt + advadjAmt + othAmt - billDisCamt;
					valueXmlString.append("<cheque_amt>").append("<![CDATA[" + chequeAmt + "]]>").append("</cheque_amt>");
				}
				else if (currentColumn.trim().equalsIgnoreCase("tran_id__advbking"))
				{
					tranIdAdvbking = genericUtility.getColumnValue("tran_id__advbking", dom);
					sql = "select curr_code__from, exch_rate from advbking where tran_id = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, tranIdAdvbking);
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						CurrCodeFrom = rs.getString(1);
						exchRate = rs.getDouble(2);
					}

					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;

					valueXmlString.append("<curr_code>").append("<![CDATA[" + CurrCodeFrom + "]]>").append("</curr_code>");
					valueXmlString.append("<exch_rate >").append("<![CDATA[" + exchRate + "]]>").append("</exch_rate>");
					setNodeValue(dom, "curr_code", getAbsString(currCode));
					if ((tranIdAdvbking == null) || (tranIdAdvbking.trim().length() == 0))
					{
						valueXmlString.append("<curr_code>").append("<![CDATA[" + CurrCodeFrom + "]]>").append("</curr_code>");
						valueXmlString.append("<exch_rate>").append("<![CDATA[" + exchRate + "]]>").append("</exch_rate>");
						setNodeValue(dom, "cust_code", getAbsString(custCode));
					}
					else
					{
						valueXmlString.append("<curr_code protect = \"1\">").append("<![CDATA[" + CurrCodeFrom + "]]>").append("</curr_code>");
						//valueXmlString.append("<exch_rate protect = \"1\" >").append("<![CDATA[" + exchRate + "]]>").append("</exch_rate>");
					}

				}
				valueXmlString.append("</Detail1>");
				break;
			case 2:
				parentNodeList = dom.getElementsByTagName("Detail2");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				valueXmlString.append("<Detail2>");
				childNodeListLength = childNodeList.getLength();
				do
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					if (childNodeName.equals(currentColumn))
					{
						if (childNode.getFirstChild() != null)
						{
							columnValue = childNode.getFirstChild().getNodeValue().trim();
						}
					}
					ctr++;
				}
				while ((ctr < childNodeListLength) && (!
						childNodeName.equals(currentColumn)));
				if (currentColumn.trim().equalsIgnoreCase("itm_default"))
				{
					tranId = genericUtility.getColumnValue("tran_id", dom);


					sql = "select rcv_ser from finctrl";
					pstmt = conn.prepareStatement(sql);
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						rcvSer = rs.getString(1);
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;

					valueXmlString.append("<tran_id>").append("<![CDATA[" + tranId + "]]>").append("</tran_id>");
					valueXmlString.append("<ref_ser>").append("<![CDATA[" + rcvSer + "]]>").append("</ref_ser>");
					valueXmlString.append("<bill_disc>").append("<![CDATA[" + "N" + "]]>").append("</bill_disc>");

					//added by akhilesh on 19/AUG/13 for tax provision
					valueXmlString.append("<tax_class>").append("<![CDATA[" + checkNull(genericUtility.getColumnValue("tax_class", dom1)) + "]]>").append("</tax_class>");
					valueXmlString.append("<tax_chap>").append("<![CDATA[" + checkNull(genericUtility.getColumnValue("tax_chap", dom1)) + "]]>").append("</tax_chap>");
					valueXmlString.append("<tax_env>").append("<![CDATA[" + checkNull(genericUtility.getColumnValue("tax_env", dom1))+ "]]>").append("</tax_env>");
					//ended by akhilesh on 19/AUG/13 for tax provision

				}
				else if (currentColumn.trim().equalsIgnoreCase("itm_defaultedit"))
				{
					billDisc = genericUtility.getColumnValue("bill_disc", dom);
					if ((billDisc == null) || (billDisc.trim().length() == 0))
					{
						valueXmlString.append("<bill_disc").append("<![CDATA[" + "N" + "]]>").append("</bill_disc>");
					}
				}
				else if (currentColumn.trim().equalsIgnoreCase("ref_ser"))
				{
					refNo = genericUtility.getColumnValue("ref_ser", dom);

					setNodeValue(dom, "ref_no", getAbsString(refNo));
				}
				else if ((currentColumn.trim().equalsIgnoreCase("ref_no")) || (currentColumn.trim().equalsIgnoreCase("line_no__ref")))
				{
					billDisc = "N";
					refNo = genericUtility.getColumnValue("ref_no", dom);
					refSer = genericUtility.getColumnValue("ref_ser", dom);
					sql = "select count(*) from receivables where tran_ser = ? and ref_no = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, refSer);
					pstmt.setString(2, refNo);
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						ctr = rs.getInt(1);
						if (ctr == 1)
						{
							lineNoRef = "1";
							valueXmlString.append("<line_no__ref>").append("<![CDATA[" + lineNoRef + "]]>").append("</line_no__ref>");

						}
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;

					if ((lineNoRef != null) || (lineNoRef.trim().length() > 0))
					{
						if (!refSer.equals("E-FUND"))
						{
							sql = "select tran_ser, tran_date, ref_no, ref_date, curr_code, exch_rate, acct_code,cctr_code, due_date, discount, tax_amt, tot_amt, cust_code, case when adj_amt is null then 0.0 else adj_amt end,case when bad_debt_amt is null then 0 else bad_debt_amt end from receivables where tran_ser = ? and ref_no = ? and line_no__ref = ?";

							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, refSer);
							pstmt.setString(2, refNo);
							pstmt.setString(3, lineNoRef);
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								tranSer = rs.getString(1);
								tranDate = rs.getDate(2);
								refNo = rs.getString(3);
								refDate = rs.getDate(4);
								currCode = rs.getString(5);
								exchRate = rs.getDouble(6);
								acctCode = rs.getString(7);
								cctrCode = rs.getString(8);
								dueDate = rs.getDate(9);
								discount = rs.getDouble(10);
								//taxAmt = rs.getDouble(11);
								totAmt = rs.getDouble(12);
								custCode = rs.getString(13);
								adjAmt = rs.getDouble(14);
								badDebtAmt = rs.getDouble(15);
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
						}
						// 21/09/13 manoharan to get the exchange rate for detail currency
						// 03/07/14 manoharan in case receivables.curr_code = header curr_code use the same exch_rate in header
						// else get the exch_rate from master
						
						siteCode = genericUtility.getColumnValue("site_code", dom1);
						hCurrCode = genericUtility.getColumnValue("curr_code", dom1);
						if ( hCurrCode.trim().equals(currCode.trim()) )
						{
							hexchRate = doublevalue(genericUtility.getColumnValue("exch_rate", dom1));
						}
						else
						{
							hexchRate = finCommon.getDailyExchRateSellBuy(currCode,"",siteCode, genericUtility.getColumnValue("tran_date", dom1), "S", conn);
						}
						sql = "select descr from currency where currency.curr_code = ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, currCode);
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							currDescr = rs.getString(1);
						}

						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
						sql = "select descr from accounts where accounts.acct_code =  ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, acctCode);
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							accDescr = rs.getString(1);
						}

						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;



						sql = "select receivables.bill_disc from receivables where tran_ser = ? and ref_no = ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, refSer);
						pstmt.setString(2, refNo);
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							billDisc = rs.getString(1);
						}

						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;


						if ((billDisc == null) || (billDisc.trim().length() == 0))
							billDisc = "N";

						if (billDisc.trim().equalsIgnoreCase("Y"))
						{													//added by ritesh 
							sql = "select export_fund.exch_rate,export_fundet.amount from export_fund, export_fundet where ( export_fund.tran_id = export_fundet.tran_id ) and ( export_fund.confirmed = 'Y' ) and ( ( export_fundet.ref_ser = ? ) and ( export_fundet.ref_no = ? ) )";

							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, refSer);
							pstmt.setString(2, refNo);
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								discExchRate = rs.getDouble(1);				// change by ritesh on 25/05/13
								lcBillDescAmt  = rs.getString(2);
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;

							valueXmlString.append("<bill_disc_amt>").append("<![CDATA[" + lcBillDescAmt + "]]>").append("</bill_disc_amt>");   	//added by ritesh  as per discussion with pravin
						}												
						valueXmlString.append("<bill_disc>").append("<![CDATA[" + billDisc + "]]>").append("</bill_disc>");
						valueXmlString.append("<curr_code>").append("<![CDATA[" + currCode + "]]>").append("</curr_code>");
						valueXmlString.append("<currency_descr>").append("<![CDATA[" + currDescr + "]]>").append("</currency_descr>");
						if (refDate != null )
						{
							valueXmlString.append("<ref_date>").append("<![CDATA[" + simpleDateFormat.format(refDate) + "]]>").append("</ref_date>");
						}
						else
						{
							valueXmlString.append("<ref_date/>");
						}
						if ( hCurrCode.trim().equals(currCode.trim()) )
						{
							valueXmlString.append("<exch_rate protect = \"1\">").append("<![CDATA[" + hexchRate + "]]>").append("</exch_rate>");
						}
						else
						{
							valueXmlString.append("<exch_rate protect = \"0\">").append("<![CDATA[" + hexchRate + "]]>").append("</exch_rate>");
						}
						valueXmlString.append("<exch_rate__rcv>").append("<![CDATA[" + exchRate + "]]>").append("</exch_rate__rcv>");
						if (dueDate != null )
						{
							valueXmlString.append("<due_date>").append("<![CDATA[" + simpleDateFormat.format(dueDate)+ "]]>").append("</due_date>");
						}
						else
						{
							valueXmlString.append("<due_date/>");
						}
						valueXmlString.append("<disc_amt>").append("<![CDATA[" + discount + "]]>").append("</disc_amt>");
						valueXmlString.append("<tax_amt>").append("<![CDATA[" + taxAmt + "]]>").append("</tax_amt>");
						valueXmlString.append("<net_amt>").append("<![CDATA[" + totAmt + "]]>").append("</net_amt>");
						valueXmlString.append("<bad_debt_amt>").append("<![CDATA[" + badDebtAmt + "]]>").append("</bad_debt_amt>");
						advAmt = doublevalue(genericUtility.getColumnValue("adv_amt", dom1)); 
						Double diffvalue = Double.valueOf(totAmt - adjAmt);
						if((advAmt < diffvalue.doubleValue()) && (advAmt != 0.0) && (Sing(advAmt) == Sing(diffvalue.doubleValue())))
						{
							valueXmlString.append("<rcp_amt>").append("<![CDATA[" + advAmt + "]]>").append("</rcp_amt>");
							rcpAmt = advAmt;
						}
						else
						{
							valueXmlString.append("<rcp_amt>").append("<![CDATA[" + (totAmt - adjAmt) + "]]>").append("</rcp_amt>");
							rcpAmt = totAmt - adjAmt;
						}
						valueXmlString.append("<acct_code__ar>").append("<![CDATA[" + acctCode + "]]>").append("</acct_code__ar>");
						valueXmlString.append("<accounts_descr>").append("<![CDATA[" + accDescr + "]]>").append("</accounts_descr>");
						valueXmlString.append("<cctr_code__ar>").append("<![CDATA[" + cctrCode + "]]>").append("</cctr_code__ar>");
						valueXmlString.append("<cust_code>").append("<![CDATA[" + custCode + "]]>").append("</cust_code>");
						bdFluctuationCf = finCommon.getFinparams("999999", "BD_FLUCTUATION_CF",conn);
						if (bdFluctuationCf.equals("") || bdFluctuationCf == null)
						{
							bdFluctuationCf = "N";
						}
						if ((billDisc.equals("Y")) && (bdFluctuationCf.equals("Y")))
						{
							valueXmlString.append("<exch_rate>").append("<![CDATA[" + discExchRate + "]]>").append("</exch_rate>");	    // change by ritesh on 25/05/13 as per discussion with pravin
							diffAmtExch = rcpAmt * exchRate - rcpAmt * discExchRate;
							valueXmlString.append("<diff_amt__exch>").append("<![CDATA[" + diffAmtExch + "]]>").append("</diff_amt__exch>");
						}
						else
						{
							diffAmtExch = rcpAmt * exchRate - rcpAmt * hexchRate;
							valueXmlString.append("<diff_amt__exch>").append("<![CDATA[" + diffAmtExch + "]]>").append("</diff_amt__exch>");
						}

						valueXmlString.append("<site_code protect = \"1\" >").append("<![CDATA[" + siteCode + "]]>").append("</site_code>");
						valueXmlString.append("<cust_code protect = \"1\">").append("<![CDATA[" + custCode + "]]>").append("</cust_code>");
						valueXmlString.append("<curr_code protect = \"1\" >").append("<![CDATA[" + currCode + "]]>").append("</curr_code>");
						valueXmlString.append("<sale_order protect = \"1\" >").append("<![CDATA[" + saleOrder + "]]>").append("</sale_order>");
						errCode = checkBadDebtAmt(0, conn, dom);
						if(errCode == null && errCode.trim().length() == 0)
						{
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
						rcpAutoFinchg = finCommon.getFinparams("999999", "RCP_AUTO_FINCHG",conn).trim();
						if (rcpAutoFinchg.equals("") || rcpAutoFinchg == null )
						{
							rcpAutoFinchg = "N";
						}
						if (rcpAutoFinchg.equals("Y"))
						{
							sql = "select count(*) from receivables where tran_ser = ? and ref_ser__org = ? and ref_no = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, "R-IBCA");
							pstmt.setString(2, "S-INV");
							pstmt.setString(3, refNo);
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								ctr = rs.getInt(1);
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;

							if ((tranSer == "S-INV") || (ctr == 1))
							{
								sql = "select due_date,cr_term from invoice where invoice_id = ?";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, refNo);
								rs = pstmt.executeQuery();
								if (rs.next())
								{
									dueDate = rs.getDate(1);
									crTrem = rs.getString(2);
								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;

								tranDate = dateFormat1.parse(genericUtility.getColumnValue("tran_date", dom1));
								if (tranDate.before(dueDate))
								{
									days = (int)(dueDate.getTime() - tranDate.getTime()) / 361440000;
									if (days > 0)
									{
										sql = "select fchg_type,case when fin_chg is null then 0 else fin_chg end from crtermfc where (min_day <= ? and max_day >= ? ) and cr_term = ?";

										pstmt = conn.prepareStatement(sql);
										pstmt.setInt(1, days);
										pstmt.setInt(2, days);
										pstmt.setString(3, crTrem);
										rs = pstmt.executeQuery();
										if (rs.next())
										{
											finChg = rs.getDouble(1);
											fchgType = rs.getString(2);

											if (finChg == 0.0D) finChg = 0.0D;
											if (discountLc == 0.0D) discountLc = 0.0D;
											if ("P".equals(fchgType))
											{
												discountLc = rcpAmt * (finChg / 36500.0D) * days;
											}
											else
											{
												discountLc = finChg;
											}
											discountLc = Math.round(discountLc) * -1L;
											valueXmlString.append("<fin_chg>").append("<![CDATA[" + discountLc + "]]>").append("</fin_chg>");
										}
										rs.close();
										rs = null;
										pstmt.close();
										pstmt = null;
									}
								}
							}
						}
					}
				}
				else if ((currentColumn.trim().equalsIgnoreCase("exch_rate")) || (currentColumn.trim().equalsIgnoreCase("rcp_amt")))
				{
					billDisc = "N";
					refNo = genericUtility.getColumnValue("ref_no", dom);
					refSer = genericUtility.getColumnValue("ref_ser", dom);
					rcpAmt = Double.parseDouble(genericUtility.getColumnValue("rcp_amt", dom));

					sql = "select bill_disc  FROM receivables where tran_ser = ? and ref_no = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, refSer);
					pstmt.setString(2, refNo);
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						billDisc = rs.getString(1);
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;

					if (billDisc == null) billDisc = "N";
					if (billDisc == "Y")
					{
						sql = "select export_fund.exch_rate from export_fund, export_fundet where ( export_fund.tran_id = export_fundet.tran_id ) and  ( export_fund.confirmed = 'Y') and( ( export_fundet.ref_ser = ? ) and  ( export_fundet.ref_no = ?) )";

						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, refSer);
						pstmt.setString(2, refNo);
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							exchRate = rs.getDouble(1);
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;

						// 21/09/13 manoharan 
						//hexchRate = Double.parseDouble(genericUtility.getColumnValue("exch_rate", dom));
						siteCode = genericUtility.getColumnValue("site_code", dom1);
						currCode = genericUtility.getColumnValue("curr_code", dom);
						hexchRate = finCommon.getDailyExchRateSellBuy(currCode,"",siteCode, genericUtility.getColumnValue("tran_date", dom1), "S", conn);
						
						exchRate = Double.parseDouble(genericUtility.getColumnValue("exch_rate__rcv", dom));
					}
					bdFluctuationCf = finCommon.getFinparams("999999", "BD_FLUCTUATION_CF" ,conn);
					if (bdFluctuationCf.equals("") || bdFluctuationCf == null)
					{
						bdFluctuationCf = "Y";
					}
					if ((billDisc.equals("Y")) && (bdFluctuationCf.equals("Y")))
					{
						diffAmtExch = rcpAmt * exchRate - rcpAmt * exchRate;
						valueXmlString.append("<diff_amt__exch>").append("<![CDATA[" + diffAmtExch + "]]>").append("</diff_amt__exch>");
					}
					else
					{
						
						siteCode = genericUtility.getColumnValue("site_code", dom1);
						currCode = genericUtility.getColumnValue("curr_code", dom);
						exchRate = Double.parseDouble(genericUtility.getColumnValue("exch_rate__rcv", dom));
						hexchRate = Double.parseDouble(genericUtility.getColumnValue("exch_rate", dom)); //finCommon.getDailyExchRateSellBuy(currCode,"",siteCode, genericUtility.getColumnValue("tran_date", dom1), "S", conn);
						System.out.println("rcp_amt change calculating diff_amt__exch  rcpAmt [" + rcpAmt + "] exchRate[" + exchRate + "] hexchRate ["+ hexchRate+ "]" );
						diffAmtExch = (rcpAmt * exchRate) - (rcpAmt * hexchRate);
						valueXmlString.append("<diff_amt__exch>").append("<![CDATA[" + diffAmtExch + "]]>").append("</diff_amt__exch>");
					}

					//valueXmlString.append("<site_code protect = \"1\">").append("<![CDATA[" + siteCode + "]]>").append("</site_code>");
					//valueXmlString.append("<cust_code protect = \"1\">").append("<![CDATA[" + custCode + "]]>").append("</cust_code>");
					//valueXmlString.append("<curr_code protect = \"1\">").append("<![CDATA[" + currCode + "]]>").append("</curr_code>");
					//valueXmlString.append("<sale_order protect = \"1\">").append("<![CDATA[" + saleOrder + "]]>").append("</sale_order>");
					errCode = checkBadDebtAmt(0, conn, dom);
					if(errCode == null && errCode.trim().length() == 0)
					{
						errList.add(errCode);
						errFields.add(childNodeName.toLowerCase());
					}
					rcpAutoFinchg = finCommon.getFinparams("999999", "RCP_AUTO_FINCHG", conn);
					if (rcpAutoFinchg.equals("") || rcpAutoFinchg == null)
					{
						rcpAutoFinchg = "N";
					}
					if (rcpAutoFinchg.equals("Y"))
					{
						sql = "select count(*) from receivables where tran_ser = ? and ref_ser__org = ? and ref_no = ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, "R-IBCA");
						pstmt.setString(2, "S-INV");
						pstmt.setString(3, refNo);
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							ctr = rs.getInt(1);
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;

						rcpAmt = Double.parseDouble(genericUtility.getColumnValue("rcp_amt", dom));
						if ((tranSer == "S-INV") || (ctr == 1))
						{
							sql = "select due_date,cr_term from invoice where invoice_id = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, refNo);
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								dueDate = rs.getDate(1);
								crTrem = rs.getString(2);
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;

							tranDate = dateFormat1.parse(genericUtility.getColumnValue("tran_date", dom));
							if (tranDate.before(dueDate))
							{
								days = (int)(dueDate.getTime() - tranDate.getTime()) / 361440000;
								if (days > 0)
								{
									sql = "select fchg_type,case when fin_chg is null then 0 else fin_chg end from crtermfc where (min_day <= ? and max_day >= ? ) and cr_term = ?";

									pstmt = conn.prepareStatement(sql);
									pstmt.setInt(1, days);
									pstmt.setInt(2, days);
									pstmt.setString(3, crTrem);
									rs = pstmt.executeQuery();
									if (rs.next())
									{
										finChg = rs.getDouble(1);
										fchgType = rs.getString(2);
									}
									rs.close();
									rs = null;
									pstmt.close();
									pstmt = null;

									if (finChg == 0.0D) finChg = 0.0D;
									if (discountLc == 0.0D) discountLc = 0.0D;
									if (fchgType == "P")
									{
										discountLc = rcpAmt * (finChg / 36500.0D) * days;
									}
									else
									{
										discountLc = finChg;
									}
									discountLc = Math.round(discountLc) * -1L;
									valueXmlString.append("<fin_chg>").append("<![CDATA[" + discountLc + "]]>").append("</fin_chg>");


								}
							}
						}
					}
				}

				valueXmlString.append("</Detail2>");
				break;
			case 3:
				parentNodeList = dom.getElementsByTagName("Detail3");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				valueXmlString.append("<Detail3>");
				childNodeListLength = childNodeList.getLength();
				do
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					if (childNodeName.equals(currentColumn))
					{
						if (childNode.getFirstChild() != null)
						{
							columnValue = childNode.getFirstChild().getNodeValue().trim();
						}
					}
					ctr++;
				}
				while ((ctr < childNodeListLength) && (!childNodeName.equals(currentColumn)));
				if (currentColumn.trim().equalsIgnoreCase("itm_default"))
				{

				}
				else if (currentColumn.trim().equalsIgnoreCase("ref_no"))
				{
					refNo = genericUtility.getColumnValue("ref_no", dom);
					refSer = genericUtility.getColumnValue("ref_ser", dom);
					sql = "select curr_code, exch_rate, acct_code, cctr_code, tot_amt, tot_amt - adj_amt from receivables where tran_ser = ? and ref_no = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, refSer);
					pstmt.setString(2, refNo);
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						currCode = rs.getString(1);
						exch = rs.getDouble(2);
						acctCode = rs.getString(3);
						cctrCode = rs.getString(4);
						totAmt = rs.getDouble(5);
						adv = rs.getDouble(6);
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;

					valueXmlString.append("<curr_code>").append("<![CDATA[" + currCode + "]]>").append("</curr_code>");
					valueXmlString.append("<exch_rate__vouch>").append("<![CDATA[" + exch + "]]>").append("</exch_rate__vouch>");
					valueXmlString.append("<tot_amt>").append("<![CDATA[" + totAmt + "]]>").append("</tot_amt>");
					valueXmlString.append("<adj_amt>").append("<![CDATA[" + adv + "]]>").append("</adj_amt>");
					valueXmlString.append("<acct_code>").append("<![CDATA[" + acctCode + "]]>").append("</acct_code>");
					valueXmlString.append("<cctr_code>").append("<![CDATA[" + cctrCode + "]]>").append("</cctr_code>");
					hexchRate = doublevalue(genericUtility.getColumnValue("exch_rate", dom1));
					lcDiff = adv * exch - adv * hexchRate;
					valueXmlString.append("<diff_amt__exch>").append("<![CDATA[" + lcDiff + "]]>").append("</diff_amt__exch>");
					valueXmlString.append("<site_code>").append("<![CDATA[" + siteCode + "]]>").append("</site_code>");
					valueXmlString.append("<cust_code>").append("<![CDATA[" + custCode + "]]>").append("</cust_code>");
					valueXmlString.append("<curr_code>").append("<![CDATA[" + currCode + "]]>").append("</curr_code>");
					valueXmlString.append("<sale_order>").append("<![CDATA[" + saleOrder + "]]>").append("</sale_order>");

				}
				else if (currentColumn.trim().equalsIgnoreCase("adj_amt"))
				{
					adv = doublevalue(genericUtility.getColumnValue("adj_amt", dom));
					hexchRate = doublevalue(genericUtility.getColumnValue("exch_rate", dom1));
					exch = doublevalue(genericUtility.getColumnValue("exch_rate__vouch", dom));
					lcDiff = adv * exch - adv * hexchRate;
					valueXmlString.append("<diff_amt__exch>").append("<![CDATA[" + lcDiff + "]]>").append("</diff_amt__exch>");
				}

				valueXmlString.append("</Detail3>");
				break;
			case 4:
				parentNodeList = dom.getElementsByTagName("Detail4");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				valueXmlString.append("<Detail4>");
				childNodeListLength = childNodeList.getLength();
				do
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					if (childNodeName.equals(currentColumn))
					{
						if (childNode.getFirstChild() != null)
						{
							columnValue = childNode.getFirstChild().getNodeValue().trim();
						}
					}
					ctr++;
				}
				while ((ctr < childNodeListLength) && (!
						childNodeName.equals(currentColumn)));
				if (currentColumn.trim().equalsIgnoreCase("itm_default"))
				{
				}
				else if (currentColumn.trim().equalsIgnoreCase("ref_no"))
				{
					refNo = genericUtility.getColumnValue("ref_no", dom);
					refSer = genericUtility.getColumnValue("ref_ser", dom);
					if ((refNo == null) || (refNo.trim().length() == 0)) refNo = "";

					sql = "select ref_no,ref_date,curr_code,exch_rate,due_date,tot_amt,sundry_type,sundry_code,case when adj_amt is null then 0 else adj_amt end,ACCT_CODE,CCTR_CODE from misc_payables where ref_no = ? and tran_ser = 'E-FUND'";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, refNo);
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						refNo = rs.getString(1);
						refDate = rs.getDate(2);
						currCode = rs.getString(3);
						exchRate = rs.getDouble(4);
						dueDate = rs.getDate(5);
						totAmt = rs.getDouble(6);
						sundryType = rs.getString(7);
						sundryCode = rs.getString(8);
						adjAmt = rs.getDouble(9);
						acctCode = rs.getString(10);
						cctrCode = rs.getString(11);
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;

					sql = "select descr from currency where currency.curr_code = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, currCode);
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						currDescr = rs.getString(1);
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;


					valueXmlString.append("<curr_code>").append("<![CDATA[" + currCode + "]]>").append("</curr_code>");
					valueXmlString.append("<currency_descr>").append("<![CDATA[" + currDescr + "]]>").append("</currency_descr>");
					valueXmlString.append("<exch_rate>").append("<![CDATA[" + exchRate + "]]>").append("</exch_rate>");
					valueXmlString.append("<tran_date>").append("<![CDATA[" + simpleDateFormat.format(dueDate) + "]]>").append("</tran_date>");
					valueXmlString.append("<amount>").append("<![CDATA[" + (adjAmt - totAmt) + "]]>").append("</amount>");
					valueXmlString.append("<sundry_type>").append("<![CDATA[" + sundryType + "]]>").append("</sundry_type>");
					valueXmlString.append("<sundry_code>").append("<![CDATA[" + sundryCode + "]]>").append("</sundry_code>");
					valueXmlString.append("<acct_code>").append("<![CDATA[" + acctCode + "]]>").append("</acct_code>");
					valueXmlString.append("<cctr_code>").append("<![CDATA[" + cctrCode + "]]>").append("</cctr_code>");
					tranDate = dateFormat1.parse(genericUtility.getColumnValue("tran_date", dom1));
					amount = doublevalue(genericUtility.getColumnValue("amount", dom));
					exchRate = doublevalue(genericUtility.getColumnValue("exch_rate", dom));
					hexchRate = doublevalue(genericUtility.getColumnValue("exch_rate", dom1));
					valueXmlString.append("<amount__bc>").append("<![CDATA[" + (amount * exchRate) + "]]>").append("</amount__bc>");
					if (amount < 0.0D){ amount = Math.abs(amount);}
					if (exchRate != 1.0D)
					{
						valueXmlString.append("<diff_amt__exch>").append("<![CDATA[" + ((amount * hexchRate )- (amount * exchRate)) + "]]>").append("</diff_amt__exch>");
					}


				}
				else if ((currentColumn.trim().equalsIgnoreCase("exch_rate")) || (currentColumn.trim().equalsIgnoreCase("amount")))
				{
					amount = doublevalue(genericUtility.getColumnValue("amount", dom));
					exchRate = doublevalue(genericUtility.getColumnValue("exch_rate", dom));
					hexchRate = doublevalue(genericUtility.getColumnValue("exch_rate", dom1));
					valueXmlString.append("<amount__bc>").append("<![CDATA[" + (amount * exchRate) + "]]>").append("</amount__bc>");
					if(amount < 0.0) {amount = Math.abs(amount);}
					if (exchRate != 1.0D)
					{
						valueXmlString.append("<diff_amt__exch>").append("<![CDATA[" + (amount * hexchRate - amount * exchRate) + "]]>").append("</diff_amt__exch>");
					}
				}

				valueXmlString.append("</Detail4>");
				break;
			case 5:
				parentNodeList = dom.getElementsByTagName("Detail5");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				valueXmlString.append("<Detail5>");
				childNodeListLength = childNodeList.getLength();
				do
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					if (childNodeName.equals(currentColumn))
					{
						if (childNode.getFirstChild() != null)
						{
							columnValue = childNode.getFirstChild().getNodeValue().trim();
						}
					}
					ctr++;
				}
				while ((ctr < childNodeListLength) && (!
						childNodeName.equals(currentColumn)));
				if (currentColumn.trim().equalsIgnoreCase("itm_default"))
				{
					hTranId = genericUtility.getColumnValue("tran_id", dom1);
					hcurrCode = genericUtility.getColumnValue("curr_code", dom1);
					hexchRate = doublevalue(genericUtility.getColumnValue("exch_rate", dom1));
					valueXmlString.append("<tran_id>").append("<![CDATA[" + hTranId + "]]>").append("</tran_id>");
					valueXmlString.append("<curr_code>").append("<![CDATA[" + hcurrCode + "]]>").append("</curr_code>");
					valueXmlString.append("<exch_rate>").append("<![CDATA[" + hexchRate + "]]>").append("</exch_rate>");

					setNodeValue(dom, "curr_code", getAbsString(currCode));
					hcurrCode = genericUtility.getColumnValue("curr_code", dom);
					if(hcurrCode.trim().equalsIgnoreCase(currCode.trim()))
					{
						valueXmlString.append("<eff_bank>").append("<![CDATA["+"Y"+"]]>").append("</eff_bank>");
					}
				}
				else if (currentColumn.trim().equalsIgnoreCase("acct_code"))
				{
					acctCode = genericUtility.getColumnValue("acct_code", dom);
					sql = "select descr from accounts where acct_code = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, acctCode);
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						accDescr = rs.getString(1);
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;

					valueXmlString.append("<accounts_descr>").append("<![CDATA[" + accDescr + "]]>").append("</accounts_descr>");

				}

				else if (currentColumn.trim().equalsIgnoreCase("emp_code"))
				{
					empCode = genericUtility.getColumnValue("emp_code", dom);
					sql = "select emp_fname, emp_lname from employee where emp_code = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, empCode);
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						empFname = rs.getString(1);
						empLname = rs.getString(2);
					}

					valueXmlString.append("<emp_fname>").append("<![CDATA[" + empFname + "]]>").append("</emp_fname>");
					valueXmlString.append("<emp_lname>").append("<![CDATA[" + empLname + "]]>").append("</emp_lname>");

					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
				}

				else if (currentColumn.trim().equalsIgnoreCase("curr_code"))
				{
					currCode = genericUtility.getColumnValue("curr_code", dom);
					htranDate = dateFormat1.parse(genericUtility.getColumnValue("tran_date", dom1));
					hsiteCode = genericUtility.getColumnValue("site_code", dom1);
					hcurrCode = genericUtility.getColumnValue("curr_code", dom1);
					// 21/09/13 manoharan caqll common function
					//mexchrate = takeExchRate(currCode, "", hsiteCode, htranDate, "S", conn);
					mexchrate = finCommon.getDailyExchRateSellBuy(currCode,"",hsiteCode, genericUtility.getColumnValue("tran_date", dom1), "S", conn);
					valueXmlString.append("<exch_rate>").append("<![CDATA[" + mexchrate + "]]>").append("</exch_rate>");
					sql = "select finent.curr_code from site, finent where ( site.fin_entity = finent.fin_entity and site.site_code = ? )";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, hsiteCode);
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						fcurrCode = rs.getString(1);
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;

					if (fcurrCode.trim().equalsIgnoreCase(currCode.trim()))
					{
						valueXmlString.append("<exch_rate protect = \"1\">").append("<![CDATA[" + mexchrate + "]]>").append("</exch_rate>");
					}
					else
					{
						valueXmlString.append("<exch_rate protect = \"0\">").append("<![CDATA[" + mexchrate + "]]>").append("</exch_rate>");
					}
					int lineNo= Integer.parseInt(genericUtility.getColumnValue("line_no", dom));
					if(lineNo > 0){deteditflag = "E"; }else{ deteditflag = "A" ;}
					if (hcurrCode.trim().equalsIgnoreCase(currCode.trim()))
					{
						hexchRate = doublevalue(genericUtility.getColumnValue("exch_rate", dom1));
						valueXmlString.append("<exch_rate protect = \"1\">").append("<![CDATA[" + hexchRate + "]]>").append("</exch_rate>");
						if (deteditflag.equals("A"))
						{
							valueXmlString.append("<eff_bank>").append("<![CDATA[" + "N" + "]]>").append("</eff_bank>");
						}
						else if (deteditflag.equals("E"))
						{
							valueXmlString.append("<eff_bank>").append("<![CDATA[" + "Y" + "]]>").append("</eff_bank>");
						}
					}
					amount = Double.parseDouble(genericUtility.getColumnValue("amount", dom));
					exchRate = Double.parseDouble(genericUtility.getColumnValue("exch_rate", dom));
					valueXmlString.append("<amount__bc>").append("<![CDATA[" + (amount * exchRate) + "]]>").append("</amount__bc>");


				}
				else if ((currentColumn.trim().equalsIgnoreCase("amount")) || (currentColumn.trim().equalsIgnoreCase("exch_rate")))
				{
					amount = Double.parseDouble(genericUtility.getColumnValue("amount", dom));
					exchRate = Double.parseDouble(genericUtility.getColumnValue("exch_rate", dom));
					valueXmlString.append("<amount__bc>").append("<![CDATA[" + amount * exchRate + "]]>").append("</amount__bc>");
				}
				valueXmlString.append("</Detail5>");
			}

			valueXmlString.append("</Root>");
		}
		catch (Exception e)
		{
			e.printStackTrace();
			System.out.println("Exception ::" + e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (pstmt != null)
						pstmt.close();
					if (rs != null)
						rs.close();
					rs = null;
					pstmt = null;
					conn.close();
					conn = null;
				}
			}
			catch (Exception d)
			{
				d.printStackTrace();
			}
		}
		return valueXmlString.toString();
			}

	private String errorType(Connection conn, String errorCode)
	{
		String msgType = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try
		{
			String sql = "SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, errorCode);
			rs = pstmt.executeQuery();
			while (rs.next())
			{
				msgType = rs.getString("MSG_TYPE");
			}
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch (Exception e)
			{
				e.printStackTrace();
			}
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch (Exception e)
			{
				e.printStackTrace();
			}
		}
		return msgType;
	}

	private static void setNodeValue(Document dom, String nodeName, String nodeVal)
			throws Exception
			{
		Node tempNode = dom.getElementsByTagName(nodeName).item(0);

		if (tempNode != null)
		{
			if (tempNode.getFirstChild() == null)
			{
				CDATASection cDataSection = dom.createCDATASection(nodeVal);
				tempNode.appendChild(cDataSection);
			}
			else
			{
				tempNode.getFirstChild().setNodeValue(nodeVal);
			}
		}
		tempNode = null;
			}

	private static String getAbsString(String str) {
		return (str == null) || (str.trim().length() == 0) || ("null".equalsIgnoreCase(str.trim())) ? "" : str.trim();
	}

	public double doublevalue(String str) {
		if (str == null || str.trim().length() == 0) { return 0.0D; }
		else
		{
			return Double.parseDouble(str);
		}
	}

	public int Sing(double str)
	{
		if (str > 0.0D) {
			return 1;
		}
		if (str < 0.0D) {
			return -1;
		}

		return 0;
	}

	/*private double takeExchRate(String currCode, String blank, String siteCode, java.util.Date tranDate, String type, Connection conn)
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "";
		String finEntity = "";
		String currCodeSql = "";
		String rtrim = "";
		double exchRate = 0.0D;
		try
		{
			if ((currCode == null) || (currCode.trim().length() == 0))
			{
				sql = "select fin_entity from site where site_code = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, siteCode);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					finEntity = rs.getString(1);
				}
				rs.close();
				rs = null;;
				pstmt.close();
				pstmt = null;

				sql = "select curr_code from finent where fin_entity = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, finEntity);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					currCodeSql = rs.getString(1);
				}
				rs.close();
				rs = null;;
				pstmt.close();
				pstmt = null;

			}
			else
			{
				currCodeSql = currCode;
			}
			if (currCode.trim().equals(currCodeSql.trim()))
			{
				return 1.0D;
			}

			if(type.equalsIgnoreCase("S"))
			{
				sql = "select exch_rate__sell from daily_exch_rate_sell_buy where curr_code = ? and curr_code__to = ? and ? between from_date and to_date ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, currCode);
				pstmt.setString(2, currCodeSql);
				pstmt.setDate(3, new java.sql.Date(tranDate.getTime()));
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					exchRate = rs.getDouble(1);
				}
				rs.close();
				rs = null;;
				pstmt.close();
				pstmt = null;

				if (exchRate == 0.0D)
				{
					sql = "select exch_rate from daily_exch_rate_sell_buy where curr_code = ? and curr_code__to = ? and ? between from_date and to_date ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, currCodeSql);
					pstmt.setString(2, currCode);
					pstmt.setDate(3, new java.sql.Date(tranDate.getTime()));
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						exchRate = rs.getInt(1);
					}
					if (exchRate != 0.0D)
					{
						exchRate = 1.0D / exchRate;
					}
					rs.close();
					rs = null;;
					pstmt.close();
					pstmt = null;
				}

			}

			if (exchRate == 0.0D)
			{
				sql = "select exch_rate from daily_exch_rate_sell_buy where curr_code = ? and curr_code__to = ?  and ? between from_date and to_date ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, currCode);
				pstmt.setString(2, currCodeSql);
				pstmt.setDate(3, new java.sql.Date(tranDate.getTime()));
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					exchRate = rs.getDouble(1);
				}
				rs.close();
				rs = null;;
				pstmt.close();
				pstmt = null;

				if (exchRate == 0.0D)
				{
					sql = "select exch_rate from daily_exch_rate_sell_buy where curr_code = ? and curr_code__to = ? and ? between from_date and to_date ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, currCodeSql);
					pstmt.setString(2, currCode);
					pstmt.setDate(3, new java.sql.Date(tranDate.getTime()));
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						exchRate = rs.getDouble(1);
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;

				}

			}

			if (exchRate == 0.0D)
			{
				sql = "select rtrim(case when var_value is null then 'Y' else var_value end) from finparm where prd_code = '999999'   and var_name = 'EXCRT_CURR' ";
				pstmt = conn.prepareStatement(sql);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					rtrim = rs.getString(1);
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;


				if (rtrim.equals("Y"))
				{
					sql = "select std_exrt from currency where curr_code = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, currCode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						exchRate = rs.getDouble(1);
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
				}
				else
				{
					return 0.0D;
				}
			}

			if (exchRate == 0.0D)
			{
				exchRate = 0.0D;
			}
		}
		catch (Exception e) {
			System.out.println(e.getMessage());
		}
		return exchRate;
	} */

	private String checkBadDebtAmt(int value, Connection conn, Document dom)
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "";
		String errCode = "";
		String refNo = "";
		String refSer = "";
		String lineNoRef = "";
		double rcpAmt = 0.0D;
		double balAmt = 0.0D;
		double badAmt = 0.0D;
		double badRev = 0.0D;
		double badAmtMax = 0.0D;
		StringBuffer valueXmlString = new StringBuffer();
		try
		{
			refNo = this.genericUtility.getColumnValue("ref_no", dom);
			refSer = this.genericUtility.getColumnValue("ref_ser", dom);
			rcpAmt = Double.parseDouble(this.genericUtility.getColumnValue("rcp_amt", dom));
			lineNoRef = this.genericUtility.getColumnValue("line_no__ref", dom);
			sql = "select (tot_amt - adj_amt) , case when bad_debt_amt is null then 0 else bad_debt_amt end from receivables where tran_ser = ? and ref_no = ? and line_no__ref = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, refSer);
			pstmt.setString(2, refNo);
			pstmt.setString(3, lineNoRef);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				balAmt = rs.getDouble(1);
				badAmt = rs.getDouble(2);
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

			if (badAmt > 0.0D)
			{
				if ((balAmt == rcpAmt) || (balAmt == badAmt))
				{
					if (rcpAmt == balAmt)
					{
						badRev = badAmt;
					}
					else {
						badRev = rcpAmt;
					}

					valueXmlString.append("<bad_debt_amt protect = \"1\">").append("<![CDATA[" + badRev + "]]>").append("</bad_debt_amt>");
				}
				else
				{
					valueXmlString.append("<bad_debt_amt protect = \"0\"").append("<![CDATA[" + badRev + "]]>").append("</bad_debt_amt>");
				}
			}
			else
			{
				valueXmlString.append("<bad_debt_amt protect = \"1\">").append("<![CDATA[0]]>").append("</bad_debt_amt>");
			}
			if(badAmt > 0.0D)
			{
				badRev = Double.parseDouble(this.genericUtility.getColumnValue("bad_debt_amt", dom));
				if ((balAmt == rcpAmt) || (balAmt == badAmt))
				{
					if (rcpAmt == balAmt)
					{
						if (badRev != badAmt)
						{
							errCode = "VTBAMTREV";
						}

					}
					else if (badRev != rcpAmt)
					{
						errCode = "VTBAMTREV";
					}

				}
				else
				{
					badAmtMax = Math.min(rcpAmt, badAmt);
					if (badRev > badAmtMax)
					{
						errCode = "VTBAMTREV";

						valueXmlString.append("").append("<![CDATA[" + badRev + "]]>").append("</bad_debt_amt>");
					}
				}

			}
		}
		catch (Exception e)
		{
			System.out.println(e.getMessage());
		}
		return errCode;

	}

	/*private String checkPeriod(String mode, String siteCode, java.util.Date tranDate, Connection con)
	{
		String errorCode = "";
		String sql = "";
		String prdCode = "";
		String statAdm = "";
		String statFin = "";
		String statPur = "";
		String statSal = "";
		String statMfg = "";
		String statIc = "";
		String statDis = "";

		ResultSet rs = null;
		java.util.Date procDate = null;
		try
		{
			if ("ADM_FIN_PUR_SAL_MFG_IC_DIS".indexOf(mode) != 0)
			{
				sql = "select code  from period where ? between fr_date and to_date";
				PreparedStatement pst = con.prepareStatement(sql);
				pst.setDate(1, new java.sql.Date(tranDate.getTime()));
				rs = pst.executeQuery();
				if (rs.next())
				{
					prdCode = rs.getString(1);
				}
				pst.close();
				pst = null;
				rs.close();
				rs = null;
			}
			if (mode.equalsIgnoreCase("FIN"))
			{

				sql = "select stat_fin,proc_date from period_stat where site_code = ? and prd_code = ?";
				PreparedStatement pst = con.prepareStatement(sql);
				pst.setString(1, siteCode);
				pst.setString(2, prdCode);
				rs = pst.executeQuery();
				if (rs.next())
				{
					statFin = rs.getString(1);
					procDate = rs.getDate(2);
					if (statFin.trim().equalsIgnoreCase("N"))
					{
						errorCode = "VTPRDSAL";
					}
					else if (procDate.after(tranDate))
					{
						errorCode = "VTPRDTSAL";
					}
				}
				else
				{
					errorCode = "VMSTATSND";
				}


				pst.close();
				pst = null;
				rs.close();
				rs = null;
			}

		}
		catch (Exception e)
		{
			System.out.println(e.getMessage());
		}

		return errorCode;
	}
	 */

	private String checkNull(String str)
	{
		if(str == null)
		{
			return "";
		}
		else
		{
			return str ;
		}

	}
}