/*
 * Author:sarita
 * Date:
 * Request ID:
 */
package ibase.webitm.ejb.fin.adv;

import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.MasterStatefulLocal;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.HashMap;

import javax.ejb.Stateless;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;


/**
 * Session Bean implementation class EtaWizardPosEJB
 */
@Stateless
public class CostCtrAllocPosEJB extends ValidatorEJB implements CostCtrAllocPosEJBRemote,CostCtrAllocPosEJBLocal 
{
	E12GenericUtility genericUtility = new E12GenericUtility();
	MasterStatefulLocal masterStatefulLocal = null;
	DistCommon distComm = new DistCommon();
	ITMDBAccessEJB itmDBAccessLocal = new ITMDBAccessEJB();
    /**
     * Default constructor. 
     */
    public CostCtrAllocPosEJB() {
        // TODO Auto-generated constructor stub
    }

    @Override
	public String postSave(String xmlStringAll, String tranID, String editFlag, String xtraParams, Connection conn) throws RemoteException, ITMException 
	{
		String retString="";
		try 
		{
			retString = postSave(xmlStringAll, xtraParams, "", conn);
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		return retString;
	}
	
		
	public String postSave(String xmlstring, String xtraParams, String forcedFlag, Connection conn) throws RemoteException,ITMException
	{
		System.out.println("CostCtrAllocPosEJB ["+xmlstring+"] \n xtraParams ["+xtraParams+"] \n forcedFlag["+forcedFlag+"]");
		
		boolean isLocCon = false;
		PreparedStatement pstmt = null,pstmt1=null,pstmt2=null,pstmt3=null, pstmtPdet = null,pstmtPorder = null,pstmtUpd = null,pstmtAsnDet = null;
		ResultSet rs = null;
		Document dom = null;
		String sql = "",retString = "";
		boolean deleteFlag = false;
		String statusFlag = "";
		int selCnt = 0;
		String tran_id="",prd_code="",site_code="",from_date="",to_date="",
				acct_code="",cctr_code="",exp_head="",alloc_basis="",res_basis="",tot_units="";
		String acctCodeDtl3="",tranIdDtl3="",lineNoDtl3="",siteCodeDtl3="",cctrCodeDtl3="",cctrDescrDtl3="",unitAllocDtl3="";
		Timestamp fromDateTimestamp = null;
		Timestamp toDateTimestamp = null;
		boolean isError = false;
		String currDate = "",loginSiteCode="",tranID="",drcrFlag="",tranIDJNRL="";
		String userId="",chgTerm="";
		Timestamp tranDate = null;
		int domIDLineNo=0,lineNo=0;
		boolean flag = true;
		try
		{	
			if(conn == null || conn.isClosed())
			{
				System.out.println("@@Connection is null");
				conn = getConnection();
				isLocCon = true;
			}
			else
			{
				System.out.println("@@Connection is not null");
			}
			
			if(xmlstring != null &&  (xmlstring.indexOf("Detail2") != -1))
			{
			    currDate = getCurrdateAppFormat();
			    tranDate = getCurrtDate();
			    loginSiteCode = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginSiteCode" );
			    userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
				chgTerm = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "chgTerm" );
			    
			   
			    System.out.println("generated transaction ID is :::::["+tranID+"]");
			    System.out.println("Line Number for Detail3 is :::["+lineNoDtl3+"]");
			    
				sql =   "insert into resource_cons " 
						+"(tran_id,prd_code,site_code,from_date,to_date,acct_code,cctr_code,exp_head,tot_units,add_date,add_user,add_term,chg_date,chg_user,chg_term) " 
						+"values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
				pstmt = conn.prepareStatement(sql);
				
				sql = "insert into resource_cons_det" 
						  +"(tran_id,line_no,dept_code,work_ctr,cctr_code_alloc,unit_alloc,acct_code) " 
						  +"values(?,?,?,?,?,?,?)";
					
				pstmt1 = conn.prepareStatement(sql);
				
				
				sql = "insert into journal" +
					 "(tran_id,tran_date,site_code,site_code__rev,reversible,eff_date,fin_entity,curr_code,exch_rate,dr_amt,cr_amt,auto_rev,status,confirmed,remarks,tran_type) " +
					 "values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
				pstmt2 = conn.prepareStatement(sql);
				
				
				sql = "insert into jourdet " 
					  +"(tran_id,line_no,acct_code,cctr_code,drcr_flag,amount,remarks)" 
					  +"values(?,?,?,?,?,?,?)";
				
				pstmt3 = conn.prepareStatement(sql);
				
				tranIDJNRL = generateTranTd("w_journal", currDate, loginSiteCode, conn);
				dom = genericUtility.parseString(xmlstring);
				NodeList detail2NodeList =dom.getElementsByTagName("Detail2");
				int detail2NodeListlen = detail2NodeList.getLength();
				for(int ctrH = 0; ctrH < detail2NodeListlen ; ctrH++)
				{
                    deleteFlag = false;
                    tranID = generateTranTd("w_cctr_alloc_wiz", currDate, loginSiteCode, conn);
                   
					NodeList childNodeList = detail2NodeList.item(ctrH).getChildNodes();
					int childNodeListlen = childNodeList.getLength();
					lineNo++;

					for(int ctrD = 0; ctrD < childNodeListlen ; ctrD++)
					{
						Node childNode = childNodeList.item(ctrD);
						
						if("attribute".equalsIgnoreCase(childNode.getNodeName()))
						{
							statusFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
							System.out.println("Post Save Status["+statusFlag+"]");
							
							if("D".equalsIgnoreCase(statusFlag))
							{
								deleteFlag = true;
								break;
							}
						}
						else if(childNode != null && "tran_id".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
						{
							tran_id = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
							System.out.println("tran_id is===="+tran_id);
						}
						else if(childNode != null && "prd_code".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
						{
							prd_code = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
							System.out.println("prd_code is===="+prd_code);
						}
						else if(childNode != null && "site_code".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
						{
							site_code = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
							System.out.println("site_code is===="+site_code);
						}
						else if(childNode != null && "from_date".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
						{
							from_date = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
							System.out.println("from_date is===="+from_date);
						}
						else if(childNode != null && "to_date".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
						{
							to_date = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
							System.out.println("to_date is===="+to_date);
						}
						else if(childNode != null && "acct_code".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
						{
							acct_code = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
							System.out.println("acct_code is===="+acct_code);
						}
						else if(childNode != null && "cctr_code".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
						{
							cctr_code = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
							System.out.println("cctr_code is===="+cctr_code);
						}
						else if(childNode != null && "exp_head".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
						{
							exp_head = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
							System.out.println("exp_head is===="+exp_head);
						}
						else if(childNode != null && "alloc_basis".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
						{
							alloc_basis = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
							System.out.println("alloc_basis is===="+alloc_basis);
						}
						else if(childNode != null && "res_basis".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
						{
							res_basis = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
							System.out.println("res_basis is===="+res_basis);
						}
						else if(childNode != null && "tot_units".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
						{
							tot_units = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
							System.out.println("tot_units is===="+tot_units);
						}
						else if(childNode != null && "drcr_flag".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
						{
							drcrFlag = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
							System.out.println("drcrFlag is===="+drcrFlag);
						}		
					}
					
					System.out.println("tran_id["+tranID+"]" +"prd_code["+prd_code+"]"+"site_code["+site_code+"]"+"from_date["+from_date+"]"+"to_date["+to_date+"]"+"acct_code["+acct_code+"]"+"cctr_code["+cctr_code+"]"+"exp_head["+exp_head+"]"+"alloc_basis["+alloc_basis+"]"+"res_basis["+res_basis+"]"+"tot_units["+tot_units+"]");
					System.out.println("domIDLineNoDet ::"+lineNo);
					System.out.println("tranIDJNRL ::["+tranIDJNRL+"]"+"site_code ["+site_code+"]" +"acc_code ["+acct_code+"]" + "lineNo ::["+lineNo+"]"+"drcrFlag ::["+drcrFlag+"]");
					
					pstmt.setString(1,tranID);
					pstmt.setString(2,prd_code);
					pstmt.setString(3,site_code);
					pstmt.setTimestamp(4,fromDateTimestamp);
					pstmt.setTimestamp(5,toDateTimestamp);
					pstmt.setString(6,acct_code);
					pstmt.setString(7,cctr_code);
					pstmt.setString(8,exp_head);
					pstmt.setDouble(9,Double.valueOf(tot_units));
					pstmt.setTimestamp(10,tranDate);
					pstmt.setString(11,userId);
					pstmt.setString(12,chgTerm);
					pstmt.setTimestamp(13,tranDate);
					pstmt.setString(14,userId);
					pstmt.setString(15,chgTerm);
					pstmt.addBatch();
					
					if(flag)
					{
						pstmt2.setString(1,tranIDJNRL);
						pstmt2.setTimestamp(2,tranDate);
						pstmt2.setString(3,site_code);
						pstmt2.setString(4,site_code);
						pstmt2.setString(5,"N");
						pstmt2.setTimestamp(6,tranDate);
						pstmt2.setString(7,"");
						pstmt2.setString(8,"");
						pstmt2.setDouble(9,Double.valueOf(1));
						pstmt2.setDouble(10,Double.valueOf(tot_units));
						pstmt2.setDouble(11,Double.valueOf(tot_units));
						pstmt2.setString(12,"N");
						pstmt2.setString(13,"N");
						pstmt2.setString(14,"N");
						pstmt2.setString(15,"");
						pstmt2.setString(16,"");
						pstmt2.executeUpdate();
						//pstmt2.addBatch();
						flag = false;
					}
										
					pstmt3.setString(1,tranIDJNRL);
					pstmt3.setInt(2,lineNo);
					pstmt3.setString(3,acct_code);
					pstmt3.setString(4,cctr_code);
					pstmt3.setString(5,drcrFlag);
					pstmt3.setDouble(6,Double.valueOf(tot_units));					
					pstmt3.setString(7,"");
					pstmt3.executeUpdate();
					//pstmt3.addBatch();
					 
					
					NodeList nodeList =dom.getElementsByTagName("Detail3");
					int nodeListlen = nodeList.getLength();
					
					System.out.println("NodeList for Detail3 is ========"+nodeListlen);
					for(int ctr = 0; ctr < nodeListlen ; ctr++)
					{
						
						NodeList childNodeListData = nodeList.item(ctr).getChildNodes();
						int childNodeListlenData = childNodeList.getLength();
						System.out.println("childNodeListlenData>>>>>"+childNodeListlenData);
						System.out.println("domIDLineNo is ========="+domIDLineNo);
						acctCodeDtl3 = "";
						for(int ctrD = 0; ctrD < childNodeListlenData ; ctrD++)
						{
							
							Node childNodeData = childNodeListData.item(ctrD);
							if(childNodeData != null && "acct_code".equalsIgnoreCase(childNodeData.getNodeName()) && childNodeData.getFirstChild() != null)
							{
								acctCodeDtl3 = checkNullAndTrim(childNodeData.getFirstChild().getNodeValue());
							}
							if(childNodeData != null && "tran_id".equalsIgnoreCase(childNodeData.getNodeName()) && childNodeData.getFirstChild() != null)
							{
								tranIdDtl3 = checkNullAndTrim(childNodeData.getFirstChild().getNodeValue());
								System.out.println("tranIdDtl3 tran_id::"+tranIdDtl3);
							}
							else if(childNodeData != null && "line_no".equalsIgnoreCase(childNodeData.getNodeName()) && childNodeData.getFirstChild() != null)
							{
								lineNoDtl3 = checkNullAndTrim(childNodeData.getFirstChild().getNodeValue());
								System.out.println("lineNoDtl3 tran_id::"+lineNoDtl3);
							}
							else if(childNodeData != null && "site_code".equalsIgnoreCase(childNodeData.getNodeName()) && childNodeData.getFirstChild() != null)
							{
								siteCodeDtl3 = checkNullAndTrim(childNodeData.getFirstChild().getNodeValue());
								System.out.println("siteCodeDtl3 site_code::"+siteCodeDtl3);
							}
							else if(childNodeData != null && "cctr_code_alloc".equalsIgnoreCase(childNodeData.getNodeName()) && childNodeData.getFirstChild() != null)
							{
								cctrCodeDtl3 = checkNullAndTrim(childNodeData.getFirstChild().getNodeValue());
								System.out.println("cctrCodeDtl3 cctr_code_alloc::"+cctrCodeDtl3);
							}
							else if(childNodeData != null && "cctr_descr".equalsIgnoreCase(childNodeData.getNodeName()) && childNodeData.getFirstChild() != null)
							{
								cctrDescrDtl3 = checkNullAndTrim(childNodeData.getFirstChild().getNodeValue());
								System.out.println("cctrDescrDtl3 cctr_descr::"+cctrDescrDtl3);
							}
							else if(childNodeData != null && "unit_alloc".equalsIgnoreCase(childNodeData.getNodeName()) && childNodeData.getFirstChild() != null)
							{
								unitAllocDtl3 = checkNullAndTrim(childNodeData.getFirstChild().getNodeValue());
								System.out.println("unitAllocDtl3 unit_alloc::"+unitAllocDtl3);
							}
							
						}
						
						if(acctCodeDtl3 != null && acctCodeDtl3.length() > 0)
						{
							if(!acctCodeDtl3.equalsIgnoreCase(acct_code))
							{
								System.out.println("Account code belogs to Detail3");
								continue;
							}
							
						}
						
						domIDLineNo++;
						pstmt1.setString(1,tranID);
						pstmt1.setInt(2,domIDLineNo);
						pstmt1.setString(3,"");
						pstmt1.setString(4,"");
						pstmt1.setString(5,cctrCodeDtl3);
						pstmt1.setString(6,unitAllocDtl3);
						pstmt1.setString(7,acctCodeDtl3);
						pstmt1.addBatch();		
					}					
					System.out.println("acctCodeDtl3["+acctCodeDtl3+"]"+"tranIdDtl3["+tranIdDtl3+"]"+"lineNoDtl3["+lineNoDtl3+"]"+"siteCodeDtl3["+siteCodeDtl3+"]"+"cctrCodeDtl3["+cctrCodeDtl3+"]"+"cctrDescrDtl3["+cctrDescrDtl3+"]"+"unitAllocDtl3["+unitAllocDtl3+"]");
				
									
					if(from_date != null && from_date.length() > 0)
					{
						fromDateTimestamp = Timestamp.valueOf(from_date);
					}
					
					if(to_date != null && to_date.length() > 0)
					{
						toDateTimestamp = Timestamp.valueOf(to_date);
						//toDateTimestamp = Timestamp.valueOf(genericUtility.getValidDateTimeString(toDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateTimeFormat()));
					}
					  
					/*    currDate = getCurrdateAppFormat();
					    tranDate = getCurrtDate();
					    loginSiteCode = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginSiteCode" );
					    userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
						chgTerm = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "chgTerm" );
					    
					    tranID = generateTranTd("w_cctr_alloc_wiz", currDate, loginSiteCode, conn);
					    System.out.println("generated transaction ID is :::::["+tranID+"]");
					    System.out.println("Line Number for Detail3 is :::["+lineNoDtl3+"]");
					    
						sql =   "insert into resource_cons " 
								+"(tran_id,prd_code,site_code,from_date,to_date,acct_code,cctr_code,exp_head,tot_units,add_date,add_user,add_term,chg_date,chg_user,chg_term) " 
								+"values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
						pstmt = conn.prepareStatement(sql);*/
						/*pstmt.setString(1,tranID);
						pstmt.setString(2,prd_code);
						pstmt.setString(3,site_code);
						pstmt.setTimestamp(4,fromDateTimestamp);
						pstmt.setTimestamp(5,toDateTimestamp);
						pstmt.setString(6,acct_code);
						pstmt.setString(7,cctr_code);
						pstmt.setString(8,exp_head);
						pstmt.setDouble(9,Double.valueOf(tot_units));
						pstmt.setTimestamp(10,tranDate);
						pstmt.setString(11,userId);
						pstmt.setString(12,chgTerm);
						pstmt.setTimestamp(13,tranDate);
						pstmt.setString(14,userId);
						pstmt.setString(15,chgTerm);
						pstmt.addBatch();
						pstmt.executeBatch();*/
						
					
					
						/*sql = "insert into resource_cons_det" 
							  +"(tran_id,line_no,cctr_code_alloc,unit_alloc,acct_code) " 
							  +"values(?,?,?,?,?,?,?)";
						
						pstmt = conn.prepareStatement(sql);*/
						/*pstmt1.setString(1,tranID);
						pstmt1.setInt(2,Integer.parseInt(lineNoDtl3));
						pstmt1.setString(3,cctrCodeDtl3);
						pstmt1.setString(4,unitAllocDtl3);
						pstmt1.setString(5,acctCodeDtl3);
						pstmt1.addBatch();*/
					
				/*	  sql = "insert into jourdet " 
							  +"(tran_id,line_no,acct_code,cctr_code,drcr_flag,amount,remarks)" 
							  +"values(?,?,?,?,?,?,?)";
						
					  pstmt3 = conn.prepareStatement(sql);*/
					 
							
						pstmt.clearParameters();
						pstmt1.clearParameters();
						pstmt2.clearParameters();
						pstmt3.clearParameters();
					
					System.out.println("Delete Flag="+deleteFlag);
			    	if(deleteFlag)
					{
						continue;
					}
			    	
			    	selCnt++;
				}
				System.out.println("Total selected record for Form 3="+selCnt);
				if(selCnt == 0) 
				{
					retString = itmDBAccessLocal.getErrorString("","VTBLNKDTL","","",conn);
					return retString;
				}
				else
				{
					pstmt.executeBatch();
					pstmt1.executeBatch();
					pstmt2.executeBatch();
					//pstmt3.executeBatch();
					
					if(pstmt != null)
					{
						pstmt.close(); 
						pstmt = null;
					}
					if(pstmt1 != null)
					{
						pstmt1.close(); 
						pstmt1 = null;
					}
					if(pstmt2 != null)
					{
						pstmt2.close(); 
						pstmt2 = null;
					}
					if(pstmt3 != null)
					{
						pstmt3.close(); 
						pstmt3 = null;
					}
				}	
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				System.out.println("Inside finally CostCtrAllocPosEJB isError["+isError+"] connStatus["+isLocCon+"]");
				if ( rs != null )
				{
					rs.close();rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();pstmt = null;
				}
				
				if(isLocCon)
				{
					if(isError)
					{
						System.out.println("Inside rollbacking....");
						conn.rollback();
					}
					else
					{
						System.out.println("Inside committing....");
						conn.commit();
					}
					if (conn != null )
					{
						conn.close();conn = null;
					}
				}
			}
			catch( Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		System.out.println("errString from post save CostCtrAllocPosEJB =["+retString+"]");
		return retString;
	}
	
	private static String checkNullAndTrim(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input.trim();
	}
	
	private java.sql.Timestamp getCurrtDate() throws RemoteException,ITMException 
	{
		String currAppdate = "";
		java.sql.Timestamp currDate = null;
		try 
		{
			Object date = null;
			currDate = new java.sql.Timestamp(System.currentTimeMillis());
			java.text.SimpleDateFormat sdf = new java.text.SimpleDateFormat(genericUtility.getDBDateFormat());
			date = sdf.parse(currDate.toString());
			currDate = java.sql.Timestamp.valueOf(sdf.format(date).toString()+ " 00:00:00.0");

		} 
		catch (Exception e) 
		{
			throw new ITMException(e);
		}
		return (currDate);
	}
	
	private String getCurrdateAppFormat() 
	{
		String s = "";
		GenericUtility genericUtility = GenericUtility.getInstance();
		try
		{
			java.util.Date date = null;
			Timestamp timestamp = new Timestamp(System.currentTimeMillis());

			SimpleDateFormat simpledateformat = new SimpleDateFormat(genericUtility.getDBDateFormat());
			date = simpledateformat.parse(timestamp.toString());
			timestamp = Timestamp.valueOf(simpledateformat.format(date).toString() + " 00:00:00.0");
			s = new SimpleDateFormat(genericUtility.getApplDateFormat()).format(timestamp).toString();
		}
		catch (Exception localException)
		{
		}

		return s;
	}
	
	public int GetRandomNumber()
    {
        long timeSeed = System.nanoTime(); // to get the current date time value
        double randSeed = Math.random() * 1000; // random number generation
        long midSeed = (long) (timeSeed * randSeed); 
        String s = midSeed + "";
        String subStr = s.substring(0, 9);
        int finalSeed = Integer.parseInt(subStr);    // integer value
        return finalSeed;
    }
	
		
	private String generateTranTd(String windowName,String tranDate,String siteCode, Connection  conn )throws ITMException
	{		
		System.out.println("inside generateTranTd@@.........");
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "";
		String tranId = "";
		String newKeystring = "",tranSer1 = "",keyString = "",keyCol = "";
		CommonConstants commonConstants = new CommonConstants();
		try
		{		 	
			sql = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, windowName);

			rs = pstmt.executeQuery();
			System.out.println("keyString :"+sql);

			if (rs.next())
			{
				keyString = rs.getString(1);
				keyCol = rs.getString(2);
				tranSer1 = rs.getString(3);
			}
			else
			{
				sql = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, "GENERAL");
				rs = pstmt.executeQuery();
				System.out.println("keyString :"+sql);				
				if (rs.next())
				{
					keyString = rs.getString(1);
					keyCol = rs.getString(2);
					tranSer1 = rs.getString(3);
				}
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

			System.out.println("keyString :"+keyString);
			System.out.println("keyCol :"+keyCol);
			System.out.println("tranSer1 :"+tranSer1);
			String xmlValues = "";
			xmlValues ="<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
			xmlValues = xmlValues + "<Header></Header>";
			xmlValues = xmlValues + "<Detail1>";
			xmlValues = xmlValues +	"<tran_id></tran_id>";
			xmlValues = xmlValues + "<site_code>" + siteCode + "</site_code>";
			xmlValues = xmlValues + "<tran_date>"+ tranDate + "</tran_date>";
			xmlValues = xmlValues + "<tran_type>"+"U"+"</tran_type>";
			xmlValues = xmlValues + "</Detail1></Root>";
			System.out.println("xmlValues  :["+xmlValues+"]");
			TransIDGenerator tg = new TransIDGenerator(xmlValues, "BASE", commonConstants.DB_NAME);
			tranId = tg.generateTranSeqID(tranSer1, keyCol, keyString, conn);

			System.out.println("tranId ::"+tranId);
		}
		catch (SQLException ex)
		{			
			System.out.println("Exception ::" +sql+ ex.getMessage() + ":");
			ex.printStackTrace();
			throw new ITMException(ex);
		}
		catch (Exception e)
		{		
			System.out.println("Exception ::" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}

		return tranId;
	}
}
