/********************************************************
 Title : MSRTWisePBPRReport (Request Id: BI3DNOV001)
 Date  : 13/11/2013
 Developer: Swati Bade

 ********************************************************/

package ibase.dashboard.umpl.ejb;

import ibase.system.config.ConnDriver;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import javax.ejb.Stateless;


/**
 * Session Bean implementation class MSRTerritoryWisePBPR
 */
@Stateless

public class MSRTWisePBPRReport  extends ValidatorEJB implements MSRTWisePBPRReportRemote, MSRTWisePBPRReportLocal 
{

    /**
     * Default constructor. 
     */
	StringBuffer xmlDataForTerr = null;
	String terrLocationNames="";
	
    public MSRTWisePBPRReport() throws RemoteException,ITMException 
    {
        // TODO Auto-generated constructor stub
    	
    	// TODO Auto-generated constructor stub
    	String sql = "";
		ResultSet rs = null;		
		Connection conn = null;		
		PreparedStatement pstmt = null;
		ConnDriver connDriver = new ConnDriver();	   
	   
	    List<String> terrLoc=new ArrayList<String>();
	    try
		{
			conn = connDriver.getConnectDB("DriverITM");
			connDriver = null;
			//coding for generate  territory location combo box 
			sql=" select distinct EMP.hobby4 as Ter_code,STATION.DESCR AS Ter_desc "
				 +" from EMPLOYEE EMP ,Station "
				 +" where TRIM(EMP.HOBBY4) = TRIM(Station.Stan_Code)";
			pstmt = conn.prepareStatement(sql); 
			rs    = pstmt.executeQuery();
			xmlDataForTerr = new StringBuffer("<?xml version=\"1.0\"?><Root>");
			while(rs.next())
			{ 
				terrLoc.add(checkNull(rs.getString("Ter_code")));
				xmlDataForTerr.append("<Detail>");				
				xmlDataForTerr.append("<fld_value>").append("<![CDATA[" + checkNull(rs.getString("Ter_code"))+"]]>").append("</fld_value>");
				xmlDataForTerr.append("<descr>").append("<![CDATA[" + checkNull(rs.getString("Ter_desc"))+"]]>").append("</descr>");
				xmlDataForTerr.append("</Detail>");
			}
			xmlDataForTerr.append("</Root>");
			for(int i=0;i<terrLoc.size();i++)
			{
				if(i==0)
					terrLocationNames=""+terrLoc.get(i)+"',";
				else if(i<(terrLoc.size()-1))
					terrLocationNames=terrLocationNames+"'"+terrLoc.get(i)+"',";
				else
					terrLocationNames=terrLocationNames+"'"+terrLoc.get(i)+"";
			}
			System.out.println("Territory Location Drop Down List=="+terrLocationNames);
			pstmt.close();
		    rs.close();
			pstmt = null;   					  
			rs = null;
		}
	    catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} finally
		{
			try
			{
				  if (conn != null)
			       {
				  	conn.close();
					conn = null;
			       }
					if (rs != null)
					{
						rs.close();
					    rs = null;
					}
					if (pstmt != null)
					{
						pstmt.close();
					    pstmt = null;
					}
				
			} catch (Exception d)
			{
				d.printStackTrace();
				throw new ITMException(d);
			}
		}
    }
    
    
    public String getTerritoryLocXmlData() throws RemoteException, ITMException
	{
    	return xmlDataForTerr.toString();
	}
    
    /*public String getMSRXmlData(String msrCodeList) throws RemoteException, ITMException
	{
	
    	return "";
    	
	}*/
    
    public String getMSRWisePBPRDetail(String frmDate,String toDate,String territoryLoc,String specialtyCode) throws RemoteException, ITMException
	{
    	GenericUtility genericUtility = GenericUtility.getInstance();
    	StringBuffer xmlData = null;
    	ResultSet rs = null;		
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		String sql="",territoryDescr="",terrCode="",prevTerritoyCode="";
		String salesPerson="",msrName="";
		int count=0,targetDoctor=0;
		try
		{
			conn = connDriver.getConnectDB("DriverITM");
			connDriver = null;
			
			if(territoryLoc!=null && territoryLoc.equals("allIndia"))
			{
				territoryLoc=terrLocationNames;
			}
			if(specialtyCode!=null && specialtyCode.equals("ALL"))
			{
				specialtyCode="PAED','GP','GYNC','ENT";
			}
			System.out.println(" EJB: territoryLoc from jsp -->"+territoryLoc+" specialtyCode:"+specialtyCode);
			
			/**** Start of block for Target doctor  - MSR wise data  ****/ 
			
			sql = 	"  SELECT COUNT(SS.SC_CODE) as targetDoct,EMP.HOBBY4 as TER_CODE ,Station.DESCR as TERRITORY, SS.SALES_PERS,S.SP_NAME "
					+" FROM STRG_SERIES SS JOIN SALES_PERS S ON SS.SALES_PERS=S.SALES_PERS " 
					+" INNER JOIN "
					+" EMPLOYEE EMP " 
					+" ON EMP.EMP_CODE = S.SALES_PERS "
					+" Inner join "
					+" Station on TRIM(EMP.HOBBY4) = TRIM(Station.Stan_Code) "
					+" WHERE "
					+" SS.SALES_PERS IN(SELECT SALES_PERS FROM SALES_PERS " 
					+" WHERE ITEM_SER = 'OTC') "
					+" AND SS.ITEM_SER ='OTC' AND SS.STATUS ='Y' "
					+" AND  EMP.HOBBY4 in ('"+territoryLoc+"') "
					+" AND SS.CUST_TYPE ='D' GROUP BY EMP.HOBBY4, Station.DESCR, SS.SALES_PERS, S.SP_NAME "; 
			
			pstmt = conn.prepareStatement(sql); 					   
			rs = pstmt.executeQuery();
			xmlData = new StringBuffer("<?xml version=\"1.0\"?><Root>");			
			xmlData.append("<Detail1>");	
			while(rs.next())
			{
				count++;
				terrCode=checkNull(rs.getString("TER_CODE"));
				territoryDescr=checkNull(rs.getString("TERRITORY"));	
				salesPerson=checkNull(rs.getString("SALES_PERS"));		
				msrName=checkNull(rs.getString("SP_NAME"));
				targetDoctor=rs.getInt("targetDoct");
				
				
				prevTerritoyCode=prevTerritoyCode==null?"":prevTerritoyCode.trim();
				System.out.println("prevTerritoy:"+prevTerritoyCode+": terrCode:"+terrCode+": territoryDescr:"+territoryDescr);
				
				if(count>1 && (!(prevTerritoyCode).equals(terrCode.trim())))
				{
					xmlData.append("</territory>");
					xmlData.append("<territory name='"+territoryDescr+"'>");	
					xmlData.append("<sales_pers code='"+salesPerson+"'>");	
					xmlData.append("<msr_name>").append("<![CDATA["+msrName+"]]>").append("</msr_name>");
					xmlData.append("<target_doct>").append("<![CDATA["+targetDoctor+"]]>").append("</target_doct>");
					xmlData.append("</sales_pers>");
					
				}
				if(count>1 && ((prevTerritoyCode).equals(terrCode.trim())))
				{
					xmlData.append("<sales_pers code='"+salesPerson+"'>");	
					xmlData.append("<msr_name>").append("<![CDATA["+msrName+"]]>").append("</msr_name>");
					xmlData.append("<target_doct>").append("<![CDATA["+targetDoctor+"]]>").append("</target_doct>");
					xmlData.append("</sales_pers>");
				}
				if(count==1 && (!(prevTerritoyCode).equals(terrCode.trim())))
				{
					xmlData.append("<territory name='"+territoryDescr+"'>");									
					xmlData.append("<sales_pers code='"+salesPerson+"'>");
					xmlData.append("<msr_name>").append("<![CDATA["+msrName+"]]>").append("</msr_name>");
					xmlData.append("<target_doct>").append("<![CDATA["+targetDoctor+"]]>").append("</target_doct>");
					xmlData.append("</sales_pers>");
					
				}
				prevTerritoyCode=checkNull(rs.getString("TER_CODE"));
			}
			if(count>0)
			{
				
				xmlData.append("</territory>");
			}
			xmlData.append("</Detail1>");
			pstmt.close();
		    rs.close();
			pstmt = null; 					   
			rs = null;
			/**** End of block for Target doctor  - MSR wise data  ****/ 
			
			
			
			/**** Start of block for PB doctor - MSR wise data ****/
			
			sql="  SELECT DISTINCT TAB.TER_CODE,TAB.TERRITORY, TAB.STRG_CODE,TAB.SALES_PERS,TAB.SP_NAME,TAB.SALES_PROD_GRP,TAB.SG_DESCR, "
				+" TAB.FIRST_NAME,TAB.MIDDLE_NAME, TAB.LAST_NAME,TAB.SPL_CODE, "
				+" TAB.LOCALITY_CODE,TAB.LC_DESCR,SMI.PITCH_BASE,SMI.PITCH_RATE "
				+" FROM "
				+" ( "
				+" SELECT  "
				+" DISTINCT "
				+" EMP.hobby4 as Ter_code,STATION.DESCR AS TERRITORY, "
				+" SMI.STRG_CODE , "
				+" SM.SALES_PERS, "
				+" SP.SP_NAME , "
				+" SMI.SALES_PROD_GRP , "
				+" SG.DESCR AS SG_DESCR, "
				+" SC.FIRST_NAME, "
				+" SC.MIDDLE_NAME,  "
				+" SC.LAST_NAME, "
				+" SR.SPL_CODE, "
				+" SC.LOCALITY_CODE, "
				+" LC.DESCR AS LC_DESCR "
				+" FROM STRG_MEET_ITEMS SMI JOIN STRG_CUSTOMER SC "
				+" ON SMI.STRG_CODE = SC.SC_CODE "
				+" JOIN LOCALITY LC "
				+" ON SC.LOCALITY_CODE = LC.LOCALITY_CODE "
				+" JOIN SALES_PROD_GRP SG "
				+" ON SMI.SALES_PROD_GRP = SG.SALES_PROD_GRP "
				+" JOIN STRG_MEET SM "
				+" ON SMI.DCR_ID = SM.DCR_ID "
				+" JOIN SALES_PERS SP "
				+" ON SM.SALES_PERS = SP.SALES_PERS "
				+" INNER JOIN "
				+" EMPLOYEE EMP  "
				+" ON EMP.EMP_CODE = SP.SALES_PERS "
				+" Inner join "
				+" Station on TRIM(EMP.HOBBY4) = TRIM(Station.Stan_Code) "
				+" JOIN STRG_SERIES SR  "
				+" ON SMI.STRG_CODE=SR.SC_CODE "
				+" WHERE SM.EVENT_DATE BETWEEN  ?  AND ?  "
				+" AND SP.ITEM_SER = 'OTC' "
				+" AND SMI.PITCH_RATE = 'N' "
				+" AND SMI.PITCH_BASE = 'Y' "
				+" and Station.Stan_Code in ('"+territoryLoc+"') "
				+" MINUS "
				+" SELECT  "
				+" DISTINCT  "
				+" EMP.hobby4 as Ter_code,STATION.DESCR AS TERRITORY, "
				+" SMI.STRG_CODE , "
				+" SM.SALES_PERS, "
				+" SP.SP_NAME , "
				+" SMI.SALES_PROD_GRP , "
				+" SG.DESCR AS SG_DESCR, "
				+" SC.FIRST_NAME, "
				+" SC.MIDDLE_NAME,  "
				+" SC.LAST_NAME, "
				+" SR.SPL_CODE, "
				+" SC.LOCALITY_CODE, "
				+" LC.DESCR AS LC_DESCR "
				+" FROM STRG_MEET_ITEMS SMI JOIN STRG_CUSTOMER SC "
				+" ON SMI.STRG_CODE = SC.SC_CODE "
				+" JOIN LOCALITY LC "
				+" ON SC.LOCALITY_CODE = LC.LOCALITY_CODE "
				+" JOIN SALES_PROD_GRP SG "
				+" ON SMI.SALES_PROD_GRP = SG.SALES_PROD_GRP "
				+" JOIN STRG_MEET SM "
				+" ON SMI.DCR_ID = SM.DCR_ID "
				+" JOIN SALES_PERS SP "
				+" ON SM.SALES_PERS = SP.SALES_PERS "
				+" INNER JOIN "
				+" EMPLOYEE EMP  "
				+" ON EMP.EMP_CODE = SP.SALES_PERS "
				+" Inner join "
				+" Station on TRIM(EMP.HOBBY4) = TRIM(Station.Stan_Code) "
				+" JOIN STRG_SERIES SR  "
				+" ON SMI.STRG_CODE=SR.SC_CODE "
				+" WHERE SM.EVENT_DATE BETWEEN  ?  AND  ? "
				+" AND SP.ITEM_SER = 'OTC' "
				+" AND SMI.PITCH_RATE = 'Y' "
				+" AND SMI.PITCH_BASE = 'Y' "
				+" and EMP.HOBBY4 in ('"+territoryLoc+"') "
				+" ) TAB "
				+" INNER JOIN STRG_MEET_ITEMS SMI "
				+" ON TAB.STRG_CODE=SMI.STRG_CODE "
				+" AND TAB.SALES_PROD_GRP = SMI.SALES_PROD_GRP "
				+" AND SMI.PITCH_RATE = 'N' "
				+" AND SMI.PITCH_BASE = 'Y' "
				+" ORDER BY TAB.TERRITORY ";
			
			pstmt = conn.prepareStatement(sql); 
			pstmt.setString(1,frmDate);
		    pstmt.setString(2,toDate);
		    pstmt.setString(3,frmDate);
		    pstmt.setString(4,toDate);		   
			rs = pstmt.executeQuery();
			prevTerritoyCode="";
			count=0;
			xmlData.append("<Detail2>");	
			while(rs.next())
			{
				count++;
				terrCode=checkNull(rs.getString("TER_CODE"));
				territoryDescr=checkNull(rs.getString("TERRITORY"));				
				salesPerson=checkNull(rs.getString("SALES_PERS"));		
				msrName=checkNull(rs.getString("SP_NAME"));
				
				prevTerritoyCode=prevTerritoyCode==null?"":prevTerritoyCode.trim();
				System.out.println("prevTerritoy_pb:"+prevTerritoyCode+": terrCode_pb:"+terrCode+": territoryDescr_pb:"+territoryDescr);
				
				if(count>1 && (!(prevTerritoyCode).equals(terrCode.trim())))
				{
					xmlData.append("</territory_pb>");
					xmlData.append("<territory_pb name='"+territoryDescr+"'>");	
					xmlData.append("<sales_pers_pb code='"+salesPerson+"'>");	
					xmlData.append("<msr_name_pb>").append("<![CDATA["+msrName+"]]>").append("</msr_name_pb>");
					xmlData.append("</sales_pers_pb>");
					
				}
				if(count>1 && ((prevTerritoyCode).equals(terrCode.trim())))
				{
					xmlData.append("<sales_pers_pb code='"+salesPerson+"'>");	
					xmlData.append("<msr_name_pb>").append("<![CDATA["+msrName+"]]>").append("</msr_name_pb>");
					xmlData.append("</sales_pers_pb>");
				}
				if(count==1 && (!(prevTerritoyCode).equals(terrCode.trim())))
				{
					xmlData.append("<territory_pb name='"+territoryDescr+"'>");									
					xmlData.append("<sales_pers_pb code='"+salesPerson+"'>");
					xmlData.append("<msr_name_pb>").append("<![CDATA["+msrName+"]]>").append("</msr_name_pb>");
					xmlData.append("</sales_pers_pb>");
					
				}
				prevTerritoyCode=checkNull(rs.getString("TER_CODE"));
			}
			if(count>0)
			{
				
				xmlData.append("</territory_pb>");
			}
			xmlData.append("</Detail2>");
			pstmt.close();
		    rs.close();
			pstmt = null; 					   
			rs = null;
			
			/**** End of block for PB doctor - MSR wise data ****/
			
			
			/****  Start of block for for PR doctor - MSR wise data ****/
			  
			sql=" SELECT DISTINCT EMP.HOBBY4 as TER_CODE ,Station.DESCR as TERRITORY, "
				+" SMI.STRG_CODE,SM.SALES_PERS,SP.SP_NAME,SMI.SALES_PROD_GRP,SG.DESCR, "
				+" SC.FIRST_NAME,SC.MIDDLE_NAME, SC.LAST_NAME,SR.SPL_CODE, "
				+" SC.LOCALITY_CODE,LC.DESCR, SMI.PITCH_BASE,SMI.PITCH_RATE "
				+" FROM STRG_MEET_ITEMS SMI JOIN STRG_CUSTOMER SC "
				+" ON SMI.STRG_CODE = SC.SC_CODE "
				+" JOIN LOCALITY LC "
				+" ON SC.LOCALITY_CODE = LC.LOCALITY_CODE "
				+" JOIN SALES_PROD_GRP SG "
				+" ON SMI.SALES_PROD_GRP = SG.SALES_PROD_GRP "
				+" JOIN STRG_MEET SM "
				+" ON SMI.DCR_ID = SM.DCR_ID "
				+" JOIN SALES_PERS SP "
				+" ON SM.SALES_PERS = SP.SALES_PERS "
				+" INNER JOIN "
				+" EMPLOYEE EMP  "
				+" ON EMP.EMP_CODE = SP.SALES_PERS "
				+" Inner join "
				+" Station on TRIM(EMP.HOBBY4) = TRIM(Station.Stan_Code) "
				+" JOIN STRG_SERIES SR  "
				+" ON SMI.STRG_CODE=SR.SC_CODE "
				+" WHERE SM.EVENT_DATE BETWEEN ? AND ? "
				+" AND SP.ITEM_SER = 'OTC' "
				+" AND SMI.PITCH_RATE = 'Y' "				
				+" and EMP.HOBBY4 in ('"+territoryLoc+"') "				
				+" AND SR.SPL_CODE in ('"+specialtyCode+"')  "
				+" ORDER BY EMP.HOBBY4, SM.SALES_PERS,SMI.SALES_PROD_GRP ";
			
			pstmt = conn.prepareStatement(sql); 
			pstmt.setString(1,frmDate);
		    pstmt.setString(2,toDate);
			rs = pstmt.executeQuery();
			prevTerritoyCode="";
			count=0;
			xmlData.append("<Detail3>");	
			while(rs.next())
			{
				count++;
				terrCode=checkNull(rs.getString("TER_CODE"));
				territoryDescr=checkNull(rs.getString("TERRITORY"));				
				salesPerson=checkNull(rs.getString("SALES_PERS"));		
				msrName=checkNull(rs.getString("SP_NAME"));
				
				prevTerritoyCode=prevTerritoyCode==null?"":prevTerritoyCode.trim();
				System.out.println("prevTerritoy_pr:"+prevTerritoyCode+": terrCode_pr:"+terrCode+": territoryDescr_pr:"+territoryDescr);
				
				if(count>1 && (!(prevTerritoyCode).equals(terrCode.trim())))
				{
					xmlData.append("</territory_pr>");
					xmlData.append("<territory_pr name='"+territoryDescr+"'>");	
					xmlData.append("<sales_pers_pr code='"+salesPerson+"'>");	
					xmlData.append("<msr_name_pr>").append("<![CDATA["+msrName+"]]>").append("</msr_name_pr>");
					xmlData.append("</sales_pers_pr>");
					
				}
				if(count>1 && ((prevTerritoyCode).equals(terrCode.trim())))
				{
					xmlData.append("<sales_pers_pr code='"+salesPerson+"'>");	
					xmlData.append("<msr_name_pr>").append("<![CDATA["+msrName+"]]>").append("</msr_name_pr>");
					xmlData.append("</sales_pers_pr>");
				}
				if(count==1 && (!(prevTerritoyCode).equals(terrCode.trim())))
				{
					xmlData.append("<territory_pr name='"+territoryDescr+"'>");									
					xmlData.append("<sales_pers_pr code='"+salesPerson+"'>");
					xmlData.append("<msr_name_pr>").append("<![CDATA["+msrName+"]]>").append("</msr_name_pr>");
					xmlData.append("</sales_pers_pr>");
					
				}
				prevTerritoyCode=checkNull(rs.getString("TER_CODE"));
			}
			if(count>0)
			{
				
				xmlData.append("</territory_pr>");
			}
			xmlData.append("</Detail3>");
			pstmt.close();
		    rs.close();
			pstmt = null; 					   
			rs = null;
			
			/****  End of block for for PR doctor - MSR wise data ****/
			
			/****  Start of block for for Others doctor - MSR wise data ****/ 
			
			sql=" SELECT DISTINCT  EMP.HOBBY4 as TER_CODE ,Station.DESCR as TERRITORY, "
			    +" SMI.STRG_CODE,SM.SALES_PERS,SP.SP_NAME,SMI.SALES_PROD_GRP,SG.DESCR, "
			    +" SC.FIRST_NAME,SC.MIDDLE_NAME, SC.LAST_NAME,SR.SPL_CODE, "
			    +" SC.LOCALITY_CODE,LC.DESCR, SMI.PITCH_BASE,SMI.PITCH_RATE "
			    +" FROM STRG_MEET_ITEMS SMI JOIN STRG_CUSTOMER SC "
			    +" ON SMI.STRG_CODE = SC.SC_CODE "
			    +" JOIN LOCALITY LC "
			    +" ON SC.LOCALITY_CODE = LC.LOCALITY_CODE "
			    +" JOIN SALES_PROD_GRP SG "
			    +" ON SMI.SALES_PROD_GRP = SG.SALES_PROD_GRP "
			    +" JOIN STRG_MEET SM "
			    +" ON SMI.DCR_ID = SM.DCR_ID "
			    +" JOIN SALES_PERS SP "
			    +" ON SM.SALES_PERS = SP.SALES_PERS "
			    +" INNER JOIN "
			    +" EMPLOYEE EMP  "
			    +" ON EMP.EMP_CODE = SP.SALES_PERS "
			    +" Inner join "
			    +" Station on TRIM(EMP.HOBBY4) = TRIM(Station.Stan_Code) "
			    +" JOIN STRG_SERIES SR  "
			    +" ON SMI.STRG_CODE=SR.SC_CODE "
			    +" WHERE SM.EVENT_DATE BETWEEN ? AND ? "
			    +" AND SP.ITEM_SER = 'OTC' "
			    +"  AND SMI.PITCH_RATE = 'N' "
			    +" AND SMI.PITCH_BASE = 'N' "
			    +"  AND SMI.SALES_PROD_GRP LIKE 'TM%' "
			    +" AND SR.SPL_CODE in ('"+specialtyCode+"')  "
			    +" and EMP.HOBBY4 in ('"+territoryLoc+"') "
			    +" ORDER BY EMP.HOBBY4,SM.SALES_PERS,SMI.SALES_PROD_GRP ";
		
			pstmt = conn.prepareStatement(sql); 
			pstmt.setString(1,frmDate);
		    pstmt.setString(2,toDate);		    
			rs = pstmt.executeQuery();
			prevTerritoyCode="";
			count=0;
			xmlData.append("<Detail4>");	
			while(rs.next())
			{
				count++;
				terrCode=checkNull(rs.getString("TER_CODE"));
				territoryDescr=checkNull(rs.getString("TERRITORY"));				
				salesPerson=checkNull(rs.getString("SALES_PERS"));		
				msrName=checkNull(rs.getString("SP_NAME"));
				
				prevTerritoyCode=prevTerritoyCode==null?"":prevTerritoyCode.trim();
				System.out.println("prevTerritoy:"+prevTerritoyCode+": terrCode:"+terrCode+": territoryDescr:"+territoryDescr);
				
				if(count>1 && (!(prevTerritoyCode).equals(terrCode.trim())))
				{
					xmlData.append("</territory_oth>");
					xmlData.append("<territory_oth name='"+territoryDescr+"'>");	
					xmlData.append("<sales_pers_oth code='"+salesPerson+"'>");	
					xmlData.append("<msr_name_oth>").append("<![CDATA["+msrName+"]]>").append("</msr_name_oth>");
					xmlData.append("</sales_pers_oth>");
					
				}
				if(count>1 && ((prevTerritoyCode).equals(terrCode.trim())))
				{
					xmlData.append("<sales_pers_oth code='"+salesPerson+"'>");	
					xmlData.append("<msr_name_oth>").append("<![CDATA["+msrName+"]]>").append("</msr_name_oth>");
					xmlData.append("</sales_pers_oth>");
				}
				if(count==1 && (!(prevTerritoyCode).equals(terrCode.trim())))
				{
					xmlData.append("<territory_oth name='"+territoryDescr+"'>");									
					xmlData.append("<sales_pers_oth code='"+salesPerson+"'>");
					xmlData.append("<msr_name_oth>").append("<![CDATA["+msrName+"]]>").append("</msr_name_oth>");
					xmlData.append("</sales_pers_oth>");
					
				}
				prevTerritoyCode=checkNull(rs.getString("TER_CODE"));
			}
			if(count>0)
			{
				
				xmlData.append("</territory_oth>");
			}
			xmlData.append("</Detail4>");
			pstmt.close();
		    rs.close();
			pstmt = null; 					   
			rs = null;
			/****  End of block for for Others doctor - MSR wise data ****/ 
			
			xmlData.append("</Root>");
			System.out.println("xml in ejb:"+xmlData.toString());
			
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
						rs.close();
					rs = null;
					if (pstmt != null)
						pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :MSRTerritoryWisePBPR:getMSRWisePBPRDetail:"+d.getMessage());
				throw new ITMException(d);
			}
		}
		return xmlData.toString();
	}
    
    private String checkNull(String input)
   	{
   		if (input == null)
   		{
   			input = "";
   		} else
   		{
   			input = input.trim();
   		}
   		return input;
   	}
}
