package ibase.dashboard.mfg.servlet;
import ibase.dashboard.mfg.ejb.MFGDashboardRemote;
import ibase.system.config.AppConnectParm;
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.ITMException;

import java.io.IOException;
import java.io.OutputStream;

import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.json.simple.JSONObject;

@SuppressWarnings("serial")
public class ProductDeviationServlet extends HttpServlet
{

	public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		 doPost( request, response );
	}
    
	@SuppressWarnings("unchecked")
	public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		MFGDashboardRemote mfgDashboardRemote = null;
		InitialContext context = null;
		AppConnectParm appConnectParm = new AppConnectParm();
		JSONObject jsonObjData = null;
		OutputStream outputStream = null;
		String dataSourceName = "";
		String loginId = "";
		String businessType                   = "";
		String facilityCode                   = "";
		String selectedView                   = "";
		String sessionSiteCode                = "";
		String fromDate="";
		String toDate="";
		ibase.utility.UserInfoBean userInfo=null;
		
		try
		{
			response.setContentType("application/xml");
			
			HttpSession session = request.getSession(true);
			userInfo = (ibase.utility.UserInfoBean) session.getAttribute("USER_INFO");
			sessionSiteCode = userInfo.getSiteCode();
			//sessionSiteCode  ="SP804";
			System.out.println("SessionSiteCode: "+sessionSiteCode);
			dataSourceName      = request.getParameter("dataSourceName");
			selectedView        = request.getParameter("viewOptionSelectd");
			facilityCode        = request.getParameter("facilityCode");
			businessType        = request.getParameter("businessType");
			fromDate			=request.getParameter("fromDate");
			toDate				=request.getParameter("toDate");
			context             = new InitialContext(appConnectParm.getProperty());
			mfgDashboardRemote  = (MFGDashboardRemote) context.lookup("ibase/MFGDashboard/remote");
			jsonObjData         = (JSONObject) mfgDashboardRemote.getProductDeviationSumm(dataSourceName, businessType, facilityCode, selectedView, sessionSiteCode, fromDate, toDate);
			outputStream        = response.getOutputStream();
		    outputStream.write(jsonObjData.toString().getBytes());
			outputStream.flush();
			outputStream.close();
			System.out.println("Final data set for ProductDeviationServlet build the Graph is===" + jsonObjData);

		} catch (Exception e)
		{
			System.out.println("Exception : ProductDeviationServlet :doPost(HttpServletRequest request, HttpServletResponse response) :" + e);
			try
			{
				throw new ITMException(e);
			} catch (ITMException e1)
			{
				e1.printStackTrace();
			}
		}

	}

		
	
}