package ibase.webitm.ejb.mfg;

import java.net.URL;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Set;

import javax.naming.InitialContext;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.scheduler.utility.interfaces.Schedule;
import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.MasterStatefulLocal;
import ibase.webitm.ejb.fin.adv.GenericWorkflowClass;
//import ibase.webitm.utility.GenericUtility;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.utility.CommonConstants;

import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.encoding.XMLType;

@SuppressWarnings({"unused"})
public class WorderIssueWfJB implements Schedule
{
	E12GenericUtility genericUtility=new E12GenericUtility();
	ConnDriver connDriver = null;
	Connection conn = null;
	
	@Override
	public String schedule(String scheduleParamXML)throws Exception{	
		
		PreparedStatement pStmt = null;
		ResultSet rs = null;
		String sql="",refId="",retString="",errString="";
		String tranId="",loginSiteCode="";
		UserInfoBean userInfo = null;
		String sysDate ="";
		boolean isError = false;
		String xtraParams = "",siteCode="";
		
		System.out.println("in schedule()-->>>>>>>>>");
		try
		{
			System.out.println("in try block of schedule()>>>>>>>>>");
			connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			connDriver = null;
			Document dom = null;
			int noOfParam=0;			
			userInfo = new ibase.utility.UserInfoBean( scheduleParamXML );
			loginSiteCode = userInfo.getSiteCode();			
			xtraParams = "loginCode="+userInfo.getLoginCode()+"~~termId="+userInfo.getRemoteHost()+"~~loginSiteCode="+loginSiteCode+"~~loginEmpCode="+userInfo.getEmpCode();
			
			System.out.println("XTRAPARAMS contain :- ["+xtraParams+"]");
			System.out.println("ScheduleParamXML contains :- ["+scheduleParamXML+"]");
			
			sql = "select iss.tran_id from workorder_iss iss " +
					"where iss.tran_id not in (select ref_id from wf_prc_status where ref_ser = 'W-ISS') "
					+ " and iss.iss_slip = 'A' and iss.confirmed = 'N'";
			
			pStmt = conn.prepareStatement(sql);
            rs = pStmt.executeQuery();
			
			while (rs.next()) {
				refId = rs.getString(1);
				GenericWorkflowClass wfGenericClass = new GenericWorkflowClass();
				retString = wfGenericClass.invokeWorkflow(conn,refId, xtraParams, "w_worder_iss", "worder_iss");
				if ("success".equalsIgnoreCase(retString)) {
					errString = new ITMDBAccessEJB().getErrorString("","VFMWRKFLWS", "");
				} else {
					isError = true;
					errString = new ITMDBAccessEJB().getErrorString("","VFMWRKFLWF", "");
				}
			}
			closePstmtRs(pStmt, rs);
		}		
		catch(Exception e)
		{
			System.out.println(">>>>>>>>>>>>>In catch:");
			e.printStackTrace();
		}
		finally
		{
			if(conn != null)
			{
				if( ! conn.isClosed())
				{
					conn.close();
					conn = null;
				}
			}
		}
		return retString;
	}
	
	private void closePstmtRs(PreparedStatement pStmt, ResultSet rs) {
		if (pStmt != null) {
			try {
				pStmt.close();
			} catch (SQLException localSQLException1) {
			}
			pStmt = null;
		}
		if (rs != null) {
			try {
				rs.close();
			} catch (SQLException e) {
				e.printStackTrace();
			}
			rs = null;
		}
	}
	
	public String confirm(String tranId, String empCodeAprv, String xmlDataAll, String processId, String keyFlag) throws ITMException, Exception {
		System.out.println("Parameters ::: tranId["+tranId+"],empCodeAprv["+empCodeAprv+"],xmlDataAll["+xmlDataAll+"],processId["+processId+"],keyFlag["+keyFlag+"]");
		String loginCode = "";
		String loginSiteCode = "";
		String loginEmpCode = "";
		String retString = "";
		Boolean isError = false;
		PreparedStatement pStmt = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "";
		//GenericUtility genericUtility = null;
		E12GenericUtility genericUtility = null;
		//Added By Aniket on 04-07-2016  for different database datetime issue:START
		SimpleDateFormat  simpleDateFormat = null;
		String currDate = "";
		//Added By Aniket on 04-07-2016  for different database datetime issue:END
		String activityId = "", roleCode = "", signStatus = "", userCode = "",processInfo[] = null;
		int resultCnt = 0;
		
		try
		{
			connDriver = new ConnDriver();
			genericUtility = new E12GenericUtility();
			conn = connDriver.getConnectDB("DriverITM");
			conn.setAutoCommit(false);
			connDriver = null;
			//Changes & commented By Aniket on 04-07-2016 for different database datetime issue:START
			simpleDateFormat  = new SimpleDateFormat(genericUtility.getApplDateTimeFormat());
			currDate          = simpleDateFormat.format( Calendar.getInstance().getTime() );
			currDate          = genericUtility.getValidDateTimeString( currDate, genericUtility.getApplDateTimeFormat(),genericUtility.getDBDateTimeFormat() ) ;
			System.out.println(" confirm :: currDate :: ["+currDate+"]");

			if("E".equalsIgnoreCase(keyFlag)){
				//sql = "update workorder_iss set confirmed = 'Y', conf_date = sysdate where tran_id = ?";
				sql = "update workorder_iss set confirmed = 'Y', conf_date = ? where tran_id = ?";
				pStmt = conn.prepareStatement(sql);
				//pStmt.setString(1,tranId);
				pStmt.setTimestamp(1,java.sql.Timestamp.valueOf(currDate));
				pStmt.setString(2,tranId);
				//Changes & commented By Aniket on 04-07-2016  for different database datetime issue:END
	            int count = pStmt.executeUpdate();
	            System.out.println("No of rows updated>>>>"+count);
	            pStmt.close();
	            pstmt = null;
			}
			else{

				if("WOISSAPRV2".equalsIgnoreCase(keyFlag)) 
				{
					activityId = "WISSAPRV2_SIGN"; roleCode = "APRVWISS2";
				}
				
				sql = "select SIGN_STATUS from OBJ_SIGN_TRANS "
					+ "WHERE ltrim(rtrim(REF_SER)) = 'W-ISS' AND ltrim(rtrim(REF_ID)) = ? AND ltrim(rtrim(ROLE_CODE__SIGN)) = ? "
					+ "AND SIGN_STATUS = 'U'";
					
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, tranId);
				pstmt.setString(2, roleCode);
				rs = pstmt.executeQuery();
				
				if (rs.next()) 
				{
					signStatus = rs.getString("SIGN_STATUS");
				}
				System.out.println("signStatus = " + signStatus);
	
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				
				if("U".equalsIgnoreCase(signStatus)){
					
					sql = "select code from users where emp_code = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, empCodeAprv);
					rs = pstmt.executeQuery();
					
					if (rs.next()) 
					{
						userCode = rs.getString("code");
					}
					userCode = userCode == null ? "" : userCode.trim();
		
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					
					sql = "UPDATE OBJ_SIGN_TRANS "
							+ "SET SIGN_DATE = ?, USER_ID__SIGN = ?, SIGN_REMARKS = 'HR_SPAN is over', SIGN_STATUS = 'V', EMP_CODE = ? "
							+ "WHERE ltrim(rtrim(REF_SER)) = 'W-ISS' AND ltrim(rtrim(REF_ID)) = ? AND ltrim(rtrim(ROLE_CODE__SIGN)) = ? "
							+ "AND SIGN_STATUS = 'U'";
							
					pstmt = conn.prepareStatement(sql);
					pstmt.setTimestamp(1,java.sql.Timestamp.valueOf(currDate));
					pstmt.setString(2, userCode);
					pstmt.setString(3, empCodeAprv);
					pstmt.setString(4, tranId);
					pstmt.setString(5, roleCode);
					
					resultCnt += pstmt.executeUpdate();
					pstmt.close();
					pstmt = null;
					System.out.println("Update Successfully:"+resultCnt);
					
					processInfo = processId.split(":");
					sql = "UPDATE WF_PRC_STATUS "
							+ "SET STATUS_DATE = ?, PROCESS_STATUS = 4, ERR_STATUS = '0', "
							+ "STATUS_REMARKS='Escalated -> Completing :"+processId+" Invoked :"+processId+"' "
							+ "WHERE ltrim(rtrim(REF_SER)) = 'W-ISS' AND REF_ID = ? AND PROCESS_ID = ? AND INSTANCE_ID = ? AND ACTIVITY_ID = ? AND PROCESS_STATUS != 3";
					
					pstmt = conn.prepareStatement(sql);
					pstmt.setTimestamp(1,java.sql.Timestamp.valueOf(currDate));
					pstmt.setString(2, tranId);
					pstmt.setString(3, processInfo[0]);
					pstmt.setString(4, processInfo[1]);
					pstmt.setString(5, activityId);
					resultCnt += pstmt.executeUpdate();
					pstmt.close();
					pstmt = null;
					System.out.println("Update Successfully:"+resultCnt);
					if(resultCnt > 1) 
					{
						conn.commit();
						retString = "Y";
					} 
					else 
					{
						conn.rollback();
					}
				} 
				else 
				{
					retString = "N";
				}
			}
		}
		catch (Exception e) {
			System.out.println("Exception: confirm method ..> " + e.getMessage());
			isError = true;
			throw new ITMException(e);
		} finally {
			if (conn != null) {
				try {
					if (isError) {
						conn.rollback();
						retString = "N";
						System.out.println("confirm: Connection Rollback");
					} else {
						conn.commit();
						retString = "Y";
						System.out.println("confirm: Connection Commit");
					}
					conn.close();
					conn = null;
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		}
		return retString;
	}	
	
	
	@Override
	public String schedule(HashMap arg0) throws Exception {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public String schedulePriority(String arg0) throws Exception {
		// TODO Auto-generated method stub
		return null;
	}
}
