package ibase.webitm.ejb.fin;

/********************************************************
Title :RPTValAprvWF[F16ASUN008]
Date  : 02/05/16
Developer: Bhushan Lad
Purpose: For checking RPT limit in PO and SO workflow
********************************************************/
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.sql.Statement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;

import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;

public class RPTValAprvWF
{
	public String checkRPTVal(String orderId , String ordCode, String refSer) throws ITMException
	{
		System.out.println("checkRPTVal() called............");
		System.out.println("orderId:::::[" + orderId + "]");
		System.out.println("ordCode:::::[" + ordCode + "]");
		System.out.println("refSer:::::[" + refSer + "]");
		String rptVal ="";
		ConnDriver connDriver = null;
		Connection conn = null;
		String sql = "";
		
		PreparedStatement pstmtSet = null;
		ResultSet rsSet = null;
		try
		{	
			connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			
			if(refSer != null && refSer.equalsIgnoreCase("P-ORD"))
			{
				sql ="SELECT RELATED_PARTY AS RPT_VAL FROM CONTACT " +
					    "WHERE CONTACT_CODE IN (SELECT CONTACT_CODE FROM SUPPLIER WHERE SUPP_CODE = ? )";
			}
			else if(refSer != null && refSer.equalsIgnoreCase("S-ORD"))
			{
				sql= "SELECT RELATED_PARTY AS RPT_VAL FROM CONTACT " +
						"WHERE CONTACT_CODE IN (SELECT CONTACT_CODE FROM CUSTOMER WHERE CUST_CODE = ? )";
			}
			pstmtSet= conn.prepareStatement(sql);
			pstmtSet.setString(1, ordCode);
			rsSet = pstmtSet.executeQuery();
			
			if(rsSet.next())
			{
				rptVal = rsSet.getString("RPT_VAL");

				if(rptVal != null && rptVal.trim().length() > 0)
				{
					rptVal = rptVal.trim();
				}
				else
				{
					rptVal = "N";
				}
			}
			System.out.println("rptVal::::["+rptVal+"]");
			
		}
		catch (Exception e)
		{
			e.printStackTrace();
			System.out.println("Exception : RPTValAprvWF.java : checkRPTVal:::==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rsSet != null)
				{
					rsSet.close();
					rsSet = null;
				}
				if(pstmtSet !=null)
				{
					pstmtSet.close();
					pstmtSet = null;
				}
				if(conn !=null)
				{
					conn.close();
					conn = null;
				}
				
			}
			catch(Exception e)
			{
				e.printStackTrace();
				System.out.println("Exception : RPTValAprvWF.java : checkRPTVal:==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		System.out.println("checkRPTVal() ::::return rptVal::["+rptVal+"]");
		return rptVal;
	}
	
	public String checkRPTLimit(String orderId , String ordCode, String refSer ) throws ITMException
	{
		System.out.println("checkRPTLimit() called...............");
		System.out.println("orderId:::::[" + orderId + "]"); // PURC_ORDER in PORDER ; SALE_ORDER in SORDER
		System.out.println("ordCode:::::[" + ordCode + "]"); // supp_code in PORDER ; cust_code__bil in SORDER
		System.out.println("refSer:::::[" + refSer + "]"); // refSer= P-ORD in PORDER ; S-ORD in SORDER
		
		ConnDriver connDriver = null;
		Connection conn = null;
		PreparedStatement pstmtSet = null;
		ResultSet rsSet = null;
		PreparedStatement pstmtDt = null;
		ResultSet rsDt = null;
		SimpleDateFormat sdf = null;
		
		String sunDryType = "";
		String sunDryTable = "";
		String sunDryColumn = "";
		String tranTable = "";
		String tranColumn = "";
		String totAmtColumn = "";
		
		String cntSql ="";
		String siteSql = "";
		String itemSql = "";
		String tranCatSql = "";
		String totAmtSql="";
		String finEnttotAmt = "";
		
		String retStr = "";
		String insrtStr = "";
		String cntCodeVal ="";
		String siteCodeVal ="";
		String itemCode ="";
		String itemSer ="";
		String tranCatVal = "";
		String finEntVal ="";
		String acctCode = "";
		String minCode = "";
		String maxCode = "";
		String tranID = "";
		String prdCodeFr = "";
		String prdCodeTo = "";
		String tranCat = "";
		String sumTotAmt = "";
		
		Timestamp acctFrDt = null;
		Timestamp acctToDt = null;
		Timestamp ordDate = null;
		Timestamp frDate = null;
		Timestamp toDate = null;
		int cntFinCont = 0;
		int cntFinEntCont = 0;
		double ordTotAmt = 0.0;
		double cntcdTotAmt = 0.0;
		double finEntTotAmt = 0.0;
		double maxAmt = 0.0;
		double alrtAmtPer = 0.0;
		double calAmt = 0.0;
		double projTurn = 0.0;
		double replAllwPer = 0.0;
		double calprojTurn = 0.0;
		boolean isCntCode = false;
		HashMap<String,Double> rptDetAmtMap=new HashMap<String,Double>();  
		
		try
		{	
			connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			
			E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
			sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			
			refSer =checkNull(refSer);
			System.out.println("refSer::["+refSer+"]");
			
			if(refSer != null && refSer.equals("P-ORD"))
			{
				 sunDryType = "S";
				 sunDryTable = "SUPPLIER";
				 sunDryColumn = "SUPP_CODE";
				 tranTable = "PORDER";
				 tranColumn = "PURC_ORDER";
				 totAmtColumn = "TOT_AMT";
			}
			else if(refSer != null && refSer.equals("S-ORD"))
			{
				 sunDryType = "C";
				 sunDryTable = "CUSTOMER";
				 sunDryColumn = "CUST_CODE";
				 tranTable = "SORDER";
				 tranColumn = "SALE_ORDER";
				 totAmtColumn = "NET_TOT_AMT";
			}
			else
			{
				System.out.println("refSer is null...");
			}
			
		 	if(refSer != null && refSer.equals("P-ORD"))
			{
			 cntSql ="SELECT CONTACT_CODE FROM SUPPLIER WHERE SUPP_CODE = ? ";
			}
			else if(refSer != null && refSer.equals("S-ORD"))
			{
				cntSql ="SELECT CONTACT_CODE FROM CUSTOMER WHERE CUST_CODE = ? ";
			}
			pstmtSet= conn.prepareStatement(cntSql);
			pstmtSet.setString(1, ordCode);
			rsSet = pstmtSet.executeQuery();
			if(rsSet.next())
			{
				cntCodeVal = checkNull(rsSet.getString("CONTACT_CODE"));
			}
			System.out.println("cntCodeVal::::["+cntCodeVal+"]");
			if (rsSet != null)
			{
				rsSet.close();
				rsSet = null;
			}
			if(pstmtSet !=null)
			{
				pstmtSet.close();
				pstmtSet = null;
			}
			
			if(refSer != null && refSer.equals("P-ORD"))
			{
				siteSql ="SELECT SITE_CODE__BILL AS SITE_CODE, ORD_DATE AS ORD_DATE, TOT_AMT AS TOT_AMT FROM PORDER WHERE PURC_ORDER =  ? ";
			}
			else if(refSer != null && refSer.equals("S-ORD"))
			{
				siteSql ="SELECT SITE_CODE AS SITE_CODE, ORDER_DATE AS ORD_DATE, NET_TOT_AMT AS TOT_AMT FROM SORDER WHERE SALE_ORDER =  ? ";
			}
			
			pstmtSet= conn.prepareStatement(siteSql);
			pstmtSet.setString(1, orderId);
			rsSet = pstmtSet.executeQuery();
			if(rsSet.next())
			{
				siteCodeVal = checkNull(rsSet.getString("SITE_CODE"));
				ordDate = rsSet.getTimestamp("ORD_DATE");
				ordTotAmt = rsSet.getDouble("TOT_AMT");
				
			}
			System.out.println("siteCodeVal::::["+siteCodeVal+"] ordDate:::["+ordDate+"] ordTotAmt:::["+ordTotAmt+"]");
			if (rsSet != null)
			{
				rsSet.close();
				rsSet = null;
			}
			if(pstmtSet !=null)
			{
				pstmtSet.close();
				pstmtSet = null;
			}
			
			String acctSql = "SELECT CODE ,FR_DATE,TO_DATE FROM ACCTPRD WHERE ? BETWEEN FR_DATE AND TO_DATE ";
			pstmtSet= conn.prepareStatement(acctSql);
			pstmtSet.setTimestamp(1, ordDate);
			rsSet = pstmtSet.executeQuery();
			if(rsSet.next())
			{
				acctCode = checkNull(rsSet.getString("CODE"));
				acctFrDt = rsSet.getTimestamp("FR_DATE");
				acctToDt = rsSet.getTimestamp("TO_DATE");
			}
			System.out.println("acctCode::::["+acctCode+"] acctFrDt::::["+acctFrDt+"] acctToDt::::["+acctToDt+"]");
			if (rsSet != null)
			{
				rsSet.close();
				rsSet = null;
			}
			if(pstmtSet !=null)
			{
				pstmtSet.close();
				pstmtSet = null;
			}
			
			String prdSql = "SELECT MIN(CODE) AS MIN_CODE, MAX(CODE) AS MAX_CODE FROM PERIOD WHERE ACCT_PRD = ? ";
			pstmtSet= conn.prepareStatement(prdSql);
			pstmtSet.setString(1, acctCode);
			rsSet = pstmtSet.executeQuery();
			if(rsSet.next())
			{
				minCode = checkNull(rsSet.getString("MIN_CODE"));
				maxCode = checkNull(rsSet.getString("MAX_CODE"));
				
			}
			System.out.println("minCode::::["+minCode+"] maxCode::::["+maxCode+"]");
			if (rsSet != null)
			{
				rsSet.close();
				rsSet = null;
			}
			if(pstmtSet !=null)
			{
				pstmtSet.close();
				pstmtSet = null;
			}
			
			if(refSer != null && refSer.equals("P-ORD"))
			{
				itemSql ="SELECT PH.ITEM_SER AS ITEM_SER , PD.ITEM_CODE AS ITEM_CODE  FROM PORDER PH , PORDDET PD  " +
						"WHERE   PH.PURC_ORDER = PD.PURC_ORDER AND PH.PURC_ORDER =  ? ";
			}
			else if(refSer != null && refSer.equals("S-ORD"))
			{
				itemSql ="SELECT SH.ITEM_SER AS ITEM_SER , SD.ITEM_CODE__ORD AS ITEM_CODE  FROM SORDER SH , SORDDET SD  " +
						"WHERE   SH.SALE_ORDER = SD.SALE_ORDER AND SH.SALE_ORDER =  ? ";
			}
			
			pstmtSet= conn.prepareStatement(itemSql);
			pstmtSet.setString(1, orderId);
			rsSet = pstmtSet.executeQuery();
			if(rsSet.next())
			{
				itemSer = checkNull(rsSet.getString("ITEM_SER"));
				itemCode = checkNull(rsSet.getString("ITEM_CODE"));
			}
			System.out.println("itemSer::::["+itemSer+"] itemCode:::["+itemCode+"]");
			if (rsSet != null)
			{
				rsSet.close();
				rsSet = null;
			}
			if(pstmtSet !=null)
			{
				pstmtSet.close();
				pstmtSet = null;
			}
			
			tranCatSql = "SELECT TRAN_CAT  FROM ITEM_ACCT_DETR WHERE ITEM_CODE = ? AND ITEM_SER = ? AND TRAN_TYPE = ' '";
			
			pstmtSet= conn.prepareStatement(tranCatSql);
			pstmtSet.setString(1, itemCode);
			pstmtSet.setString(2, itemSer);
			rsSet = pstmtSet.executeQuery();
			if(rsSet.next())
			{
				tranCatVal = checkNull(rsSet.getString("TRAN_CAT"));
			}
			System.out.println("tranCatVal::::["+tranCatVal+"]");
			if (rsSet != null)
			{
				rsSet.close();
				rsSet = null;
			}
			if(pstmtSet !=null)
			{
				pstmtSet.close();
				pstmtSet = null;
			}
			
			if(tranCatVal == null ||tranCatVal.trim().length() == 0 )
			{
				System.out.println("tranCatVal is null....");
				
				tranCatSql = "SELECT TRAN_CAT  FROM ITEM_ACCT_DETR WHERE ITEM_CODE = ? AND ITEM_SER = ' ' AND TRAN_TYPE = ' '";
				
				pstmtSet= conn.prepareStatement(tranCatSql);
				pstmtSet.setString(1, itemCode);
				rsSet = pstmtSet.executeQuery();
				if(rsSet.next())
				{
					tranCatVal = checkNull(rsSet.getString("TRAN_CAT"));
				}
				System.out.println("tranCatVal::::===["+tranCatVal+"]");
				if (rsSet != null)
				{
					rsSet.close();
					rsSet = null;
				}
				if(pstmtSet !=null)
				{
					pstmtSet.close();
					pstmtSet = null;
				}
			}
			System.out.println("Final_tranCatVal::::["+tranCatVal+"]");
			
			String cntFinSql ="SELECT COUNT(*) AS COUNT_FIN  FROM FIN_CTRL_EXCP WHERE   REF_SER = '"+refSer+"' AND  REF_NO = ? " +
					          "AND SUNDRY_CODE = ?  and CONTR_DOMAIN= 'RP' and OVER_RIDE ='Y'";
			pstmtSet= conn.prepareStatement(cntFinSql);
			pstmtSet.setString(1, orderId);
			pstmtSet.setString(2, ordCode);
			rsSet = pstmtSet.executeQuery();
			if(rsSet.next())
			{
				cntFinCont = rsSet.getInt("COUNT_FIN");
			}
			System.out.println("cntFinCont::::["+cntFinCont+"]");
			if (rsSet != null)
			{
				rsSet.close();
				rsSet = null;
			}
			if(pstmtSet !=null)
			{
				pstmtSet.close();
				pstmtSet = null;
			}
			
			if(cntFinCont > 0)
			{
				System.out.println("Approved RPT order Existed contact_code wise......");
				retStr="N";
			}
			else
			{
			//contact_code wise :START
			System.out.println("contact_code wise :START.......");
			String rptHder = "SELECT TRAN_ID, PRD_CODE__FR, PRD_CODE__TO FROM RELA_PARTY_HDR WHERE CONTACT_CODE = ? AND SITE_CODE = ?  AND CONFIRMED = 'Y' " +
					         "and  PRD_CODE__FR >= ?  and PRD_CODE__TO  <= ?  and ACCT_PRD = ? ";
			pstmtSet= conn.prepareStatement(rptHder);
			pstmtSet.setString(1, cntCodeVal);
			pstmtSet.setString(2, siteCodeVal);
			pstmtSet.setString(3, minCode);
			pstmtSet.setString(4, maxCode);
			pstmtSet.setString(5, acctCode);
			
			rsSet = pstmtSet.executeQuery();
			while(rsSet.next())
			{
				tranID = checkNull(rsSet.getString(1));
				prdCodeFr = checkNull(rsSet.getString(2));
				prdCodeTo = checkNull(rsSet.getString(3));
				
				System.out.println("RELA_PARTY_HDR:tranID::::["+tranID+"] prdCodeFr:::["+prdCodeFr+"] prdCodeTo:::["+prdCodeTo+"]");
			
				String dateSql = "SELECT P1.FR_DATE AS FR_DATE ,  P2.TO_DATE AS TO_DATE  FROM PERIOD P1, PERIOD P2 " +
						         " WHERE P1.CODE = ? AND  P2.CODE = ? and P1.ACCT_PRD =P2.ACCT_PRD and  P1.ACCT_PRD = ? ";
				pstmtDt= conn.prepareStatement(dateSql);
				pstmtDt.setString(1, prdCodeFr);
				pstmtDt.setString(2, prdCodeTo);
				pstmtDt.setString(3, acctCode);
				
				rsDt = pstmtDt.executeQuery();
				if(rsDt.next())
				{
					frDate = rsDt.getTimestamp("FR_DATE");
					toDate = rsDt.getTimestamp("TO_DATE");
				}
				
				System.out.println("frDate::::["+frDate+"] toDate:::["+toDate+"]");
				
				if (rsDt != null)
				{
					rsDt.close();
					rsDt = null;
				}
				if(pstmtDt !=null)
				{
					pstmtDt.close();
					pstmtDt = null;
				}
				
				System.out.println("ordDate::===["+ordDate+"]");
				
				if(frDate != null && toDate != null && ordDate != null )
				{
					boolean d1 =frDate.before(ordDate);
					boolean d2 =toDate.after(ordDate);
					System.out.println("frDate.before(ordDate)::"+d1);
					System.out.println("toDate.after(ordDate)::"+d2);
					
					if(frDate.before(ordDate) && toDate.after(ordDate))
				    {
						System.out.println(" ordDate is between frDate and toDate......");
						break;
				    }
					else
					{
						System.out.println(" ordDate is not between frDate and toDate......");
					}
				}
			}
			System.out.println("Final..RELA_PARTY_HDRtranID::==["+tranID+"] frDate::==["+frDate+"] toDate::==["+toDate+"]");
			
			if (rsSet != null)
			{
				rsSet.close();
				rsSet = null;
			}
			if(pstmtSet !=null)
			{
				pstmtSet.close();
				pstmtSet = null;
			}
			
			if(refSer != null && refSer.equals("P-ORD"))
			{
				totAmtSql ="SELECT SUM(TOT_AMT) AS SUM_TOT_AMT FROM PORDER   WHERE  SUPP_CODE IN(SELECT SUPP_CODE FROM SUPPLIER WHERE CONTACT_CODE= ? )  " +
				          " AND ORD_DATE  BETWEEN ? AND ?  and SITE_CODE__BILL = ?  ";
			}
			else if(refSer != null && refSer.equals("S-ORD"))
			{
				totAmtSql ="SELECT SUM(NET_TOT_AMT) AS SUM_TOT_AMT FROM SORDER   WHERE  CUST_CODE__BIL IN(SELECT CUST_CODE FROM CUSTOMER WHERE CONTACT_CODE= ? ) " +
						"AND ORDER_DATE  BETWEEN ? AND ?  and SITE_CODE =  ? ";
			}
			
			pstmtSet= conn.prepareStatement(totAmtSql);
			pstmtSet.setString(1, cntCodeVal);
			pstmtSet.setTimestamp(2, frDate);
			pstmtSet.setTimestamp(3, toDate);
			pstmtSet.setString(4, siteCodeVal);
			
			rsSet = pstmtSet.executeQuery();
			if(rsSet.next())
			{
				cntcdTotAmt = rsSet.getDouble("SUM_TOT_AMT");
			}
			System.out.println("contact_code wise sumTotAmt::::==["+cntcdTotAmt+"] ");
			if (rsSet != null)
			{
				rsSet.close();
				rsSet = null;
			}
			if(pstmtSet !=null)
			{
				pstmtSet.close();
				pstmtSet = null;
			}
			
			String rptDet = "SELECT TRAN_CAT , MAX_AMT, ALERT_AMT_PERC  FROM  RELA_PARTY_DET WHERE TRAN_ID =  ? AND TRAN_CAT = ? ";
			
			pstmtSet= conn.prepareStatement(rptDet);
			pstmtSet.setString(1, tranID);
			pstmtSet.setString(2, tranCatVal);
			rsSet = pstmtSet.executeQuery();
			while(rsSet.next())
			{
				tranCat = checkNull(rsSet.getString("TRAN_CAT"));
				maxAmt = rsSet.getDouble("MAX_AMT");
				alrtAmtPer = rsSet.getDouble("ALERT_AMT_PERC");
				System.out.println("tranCat::::["+tranCat+"] maxAmt:::["+maxAmt+"] alrtAmtPer:::["+alrtAmtPer+"]");
				
				calAmt = (maxAmt * alrtAmtPer)/100;
				System.out.println("calAmt value=[maxAmt * alrtAmtPer)/100]::::["+calAmt+"]");
				
				if(calAmt > 0 && cntcdTotAmt > 0)
				{
					System.out.println("cntcdTotAmt::::==["+cntcdTotAmt+"] calAmt::::==["+calAmt+"]");
					if(calAmt < cntcdTotAmt)
					{
						System.out.println("Inserting into FIN_CTRL_EXCP......");
						
						insrtStr = insertFinCtrlExcp( orderId ,  ordCode, refSer,  cntCodeVal,  siteCodeVal,  prdCodeFr,  prdCodeTo, tranCat,  maxAmt,  calAmt,  ordTotAmt,  conn);
						if("VTSUCC".equalsIgnoreCase(insrtStr))
						{
							retStr="Y"; 
							isCntCode = true;
						}
						else
						{
							System.out.println("Error while Inserting into FIN_CTRL_EXCP...");
							retStr= insrtStr;
							return retStr;
						}
					}
					else
					{
						System.out.println("contact_code wise Limit is not exceed...");
						retStr="N";
					}
				}
			}
			System.out.println("isCntCode::::["+isCntCode+"]");
			if (rsSet != null)
			{
				rsSet.close();
				rsSet = null;
			}
			if(pstmtSet !=null)
			{
				pstmtSet.close();
				pstmtSet = null;
			}
			//contact_code wise :END
			
			}
			
			String cntFinEntSql ="SELECT COUNT(*) AS COUNT_FIN  FROM FIN_CTRL_EXCP WHERE   REF_SER = '"+refSer+"' AND  REF_NO = ? " +
			          			"AND SUNDRY_CODE = ?  and CONTR_DOMAIN= 'OL' and OVER_RIDE ='Y'";
			pstmtSet= conn.prepareStatement(cntFinEntSql);
			pstmtSet.setString(1, orderId);
			pstmtSet.setString(2, ordCode);
			rsSet = pstmtSet.executeQuery();
			if(rsSet.next())
			{
				cntFinEntCont = rsSet.getInt("COUNT_FIN");
			}
			System.out.println("cntFinEntCont::::["+cntFinEntCont+"]");
			if (rsSet != null)
			{
				rsSet.close();
				rsSet = null;
			}
			if(pstmtSet !=null)
			{
				pstmtSet.close();
				pstmtSet = null;
			}
			
			if(cntFinEntCont > 0)
			{
				System.out.println("Approved RPT order Existed FIN_ENTITY wise......");
				retStr="N";
			}
			else
			{
			//FIN_ENTITY wise :START
			System.out.println("FIN_ENTITY wise :START.......");
			String finsql ="SELECT FIN_ENTITY  FROM SITE WHERE SITE_CODE = ? ";
			pstmtSet= conn.prepareStatement(finsql);
			pstmtSet.setString(1, siteCodeVal);
			rsSet = pstmtSet.executeQuery();
			if(rsSet.next())
			{
				finEntVal = checkNull(rsSet.getString("FIN_ENTITY"));
			}
			System.out.println("finEntVal::::["+finEntVal+"]");
			
			if (rsSet != null)
			{
				rsSet.close();
				rsSet = null;
			}
			if(pstmtSet !=null)
			{
				pstmtSet.close();
				pstmtSet = null;
			}
			
			if(refSer != null && refSer.equals("P-ORD"))
			{
				
				finEnttotAmt = "SELECT SUM(TOT_AMT) AS SUM_TOT_AMT FROM PORDER A,SITE B WHERE A.SITE_CODE__BILL=B.SITE_CODE " +
						       "AND B.FIN_ENTITY IN(SELECT FIN_ENTITY FROM SITE WHERE SITE_CODE= ? ) " +
						       "AND ORD_DATE BETWEEN  ? AND ? ";
			}
			else if(refSer != null && refSer.equals("S-ORD"))
			{
				finEnttotAmt ="SELECT SUM(NET_TOT_AMT) AS SUM_TOT_AMT FROM SORDER A,SITE B WHERE A.SITE_CODE=B.SITE_CODE " +
						      "AND B.FIN_ENTITY IN(SELECT FIN_ENTITY FROM SITE WHERE SITE_CODE= ? ) " +
						      "AND ORDER_DATE BETWEEN ? AND ? ";
			}
			
			pstmtSet= conn.prepareStatement(finEnttotAmt);
			pstmtSet.setString(1, siteCodeVal);
			pstmtSet.setTimestamp(2, acctFrDt);
			pstmtSet.setTimestamp(3, acctToDt);
			
			rsSet = pstmtSet.executeQuery();
			if(rsSet.next())
			{
				finEntTotAmt = rsSet.getDouble("SUM_TOT_AMT");
			}
			System.out.println("FIN_ENTITY wise sumTotAmt::::==["+finEntTotAmt+"] ");
			if (rsSet != null)
			{
				rsSet.close();
				rsSet = null;
			}
			if(pstmtSet !=null)
			{
				pstmtSet.close();
				pstmtSet = null;
			}
			
			String rptAppl = "SELECT PROJ_TURNOVER , RELP_ALLW_PERC  FROM RELA_PARTY_APPL WHERE FIN_ENTITY = ?  AND ACCT_PRD = ? AND TRAN_CAT = ? ";
					
			pstmtSet= conn.prepareStatement(rptAppl);
			pstmtSet.setString(1, finEntVal);
			pstmtSet.setString(2, acctCode);
			pstmtSet.setString(3, tranCatVal);
			rsSet = pstmtSet.executeQuery();
			if(rsSet.next())
			{
				projTurn = rsSet.getDouble("PROJ_TURNOVER");
				replAllwPer = rsSet.getDouble("RELP_ALLW_PERC");
				System.out.println("projTurn::::["+projTurn+"] replAllwper:::["+replAllwPer+"]");
				
				calprojTurn = (projTurn * replAllwPer)/100;
				System.out.println("calprojTurn value=[(projTurn * replAllwPer)/100]::::["+calprojTurn+"]");
				
				if(calprojTurn > 0 && finEntTotAmt > 0)
				{
					System.out.println("calprojTurn::::==["+calprojTurn+"] finEntTotAmt::::==["+finEntTotAmt+"]");
					if(calprojTurn < finEntTotAmt)
					{
						System.out.println("Inserting into FIN_CTRL_EXCP......");
						
						insrtStr = insertFinCtrlExcpMst( orderId ,  ordCode, refSer,  finEntVal,  siteCodeVal,  prdCodeFr,  prdCodeTo, acctCode, tranCatVal,  projTurn,  calprojTurn,  ordTotAmt,  conn);
						if("VTSUCC".equalsIgnoreCase(insrtStr))
						{
							retStr="Y";
						}
						else
						{	
							System.out.println("Error while Inserting into FIN_CTRL_EXCP......");
							retStr = insrtStr;
							return retStr;
						}
					}
					else
					{
						System.out.println("FIN_ENTITY wise Limit is not exceed...");
						retStr="N";
					}
				}
			}
			if (rsSet != null)
			{
				rsSet.close();
				rsSet = null;
			}
			if(pstmtSet !=null)
			{
				pstmtSet.close();
				pstmtSet = null;
			}
			//FIN_ENTITY wise :END
			}
			
			//For RPTlimit exceed contact code wise but not exceed fin entity wise 
			if(isCntCode)
			{
				System.out.println("isCntCode::====["+isCntCode+"]");
				retStr="Y";
			}
			
		}
		catch (Exception e)
		{
			e.printStackTrace();
			System.out.println("Exception : RPTValAprvWF.java : checkRPTLimit:::==>\n"+e.getMessage());
			try
			{
				System.out.println("checkRPTLimit rollbacking transaction....");
				conn.rollback();
				retStr = e.getMessage();
			}
			catch(Exception e1)
			{
				System.out.println("Exception while rollbacking transaction....");
				e1.printStackTrace();
			}
		}
		finally
		{
			try
			{
				
				if (rsSet != null)
				{
					rsSet.close();
					rsSet = null;
				}
				if(pstmtSet !=null)
				{
					pstmtSet.close();
					pstmtSet = null;
				}
				if(conn !=null)
				{
					if("Y".equalsIgnoreCase(retStr))
					{
						conn.commit();
						System.out.println("commit successfully::::::");
					}
					else
					{
						conn.rollback();
					}
					conn.close();
					conn = null;
				}
				
			}
			catch(Exception e)
			{
				e.printStackTrace();
				System.out.println("Exception : RPTValAprvWF.java : checkRPTLimit:==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		System.out.println("RPTValAprvWF.java :: checkRPTLimit() return retStr::["+retStr+"]");
		return retStr;
	}
	
	public String insertFinCtrlExcp(String orderId , String ordCode, String refSer, String cntCodeVal, String siteCodeVal, String prdCodeFr, String prdCodeTo,String tranCat, double maxAmt, double calAmt, double ordTotAmt, Connection conn) throws ITMException
	{
		System.out.println("In side insertFinCtrlExcp contact_code wise....refSer::"+refSer);
		String insrtFlag = "";
		String tranIDFin = "";
		String windowName = "";
		String userId = "";
		String termID ="";
		String sunDryType ="";
		PreparedStatement pstmtInsrt = null;
		try
		{
			InetAddress ownIP=InetAddress.getLocalHost();
			termID = checkNull(ownIP.getHostAddress());
			System.out.println("termID :-["+termID+"]");
			E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String currDate = sdf.format(new java.util.Date());
			currDate = genericUtility.getValidDateTimeString( currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
			System.out.println("currDate::::["+currDate+"]");
			
			if(refSer != null && refSer.equals("P-ORD"))
			{
				sunDryType ="S";
			}
			else if(refSer != null && refSer.equals("S-ORD"))
			{
				sunDryType ="C";
			}
			
			windowName = "w_fin_ctrl_excp";
			userId = getUserId(orderId,refSer,conn);
			
			System.out.println("userId :- ["+userId+"] windowName::::["+windowName+"]");
			tranIDFin = generateTranId( windowName,  userId, siteCodeVal, currDate,  conn);
			
			String insrtSql = "INSERT INTO FIN_CTRL_EXCP ( TRAN_ID, TRAN_DATE, REF_SER, REF_NO, CONTACT_CODE, CONTR_DOMAIN, SITE_CODE, FIN_ENTITY , " +
					"SUNDRY_TYPE, SUNDRY_CODE, PRD_CODE__FR, PRD_CODE__TO, TRAN_CAT, ALERT_AMT, TRAN_AMT, MAX_AMT,OVER_RIDE , ADD_DATE , ADD_USER, ADD_TERM ) " +
					"VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) ";
			
			pstmtInsrt = conn.prepareStatement(insrtSql);
			pstmtInsrt.setString(1, tranIDFin);
			pstmtInsrt.setTimestamp(2, java.sql.Timestamp.valueOf(currDate));
			pstmtInsrt.setString(3, refSer);
			pstmtInsrt.setString(4, orderId);
			pstmtInsrt.setString(5, cntCodeVal);
			pstmtInsrt.setString(6, "RP");
			pstmtInsrt.setString(7, siteCodeVal);
			pstmtInsrt.setString(8, "");
			pstmtInsrt.setString(9, sunDryType);
			pstmtInsrt.setString(10, ordCode);
			pstmtInsrt.setString(11, prdCodeFr);
			pstmtInsrt.setString(12, prdCodeTo);
			pstmtInsrt.setString(13, tranCat);
			pstmtInsrt.setDouble(14, calAmt);
			pstmtInsrt.setDouble(15, ordTotAmt);
			pstmtInsrt.setDouble(16, maxAmt);
			pstmtInsrt.setString(17, "N");
			pstmtInsrt.setTimestamp(18, java.sql.Timestamp.valueOf(currDate));
			pstmtInsrt.setString(19, userId);
			pstmtInsrt.setString(20, termID);
			
			int inCnt = pstmtInsrt.executeUpdate();
			
			pstmtInsrt.clearParameters();
			if (inCnt > 0)
			{
				System.out.println("Inserted successfully into FIN_CTRL_EXCP::="+inCnt);
				insrtFlag = "VTSUCC";
			}
			else
			{
				insrtFlag = "VTFAIL";
			}
		
		}
		catch (Exception e)
		{
			//insrtFlag = "VTFAIL";
			e.printStackTrace();
			System.out.println("Exception : insertFinCtrlExcp ==>\n"+e.getMessage());
			try
			{
				System.out.println("insertFinCtrlExcp Rollbacking transaction....");
				conn.rollback();
				insrtFlag =e.getMessage();
			}
			catch(Exception e1)
			{
				System.out.println("Exception while rollbacking transaction....");
				e1.printStackTrace();
			}
			
		}
		finally
		{
			try
			{
				if(pstmtInsrt !=null)
				{
					pstmtInsrt.close();
					pstmtInsrt = null;
				}
				
				System.out.println("Inserted successfully into FIN_CTRL_EXCP..........");
			}
			catch(Exception e)
			{
				e.printStackTrace();
				System.out.println("Exception : insertFinCtrlExcp ==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		
		return insrtFlag;
	}
	
	public String insertFinCtrlExcpMst(String orderId , String ordCode,String refSer, String finEntVal, String siteCodeVal, String prdCodeFr, String prdCodeTo,String acctCode, String tranCat, double projTurn, double calprojTurn, double ordTotAmt, Connection conn) throws ITMException
	{
		System.out.println("In side insertFinCtrlExcpMst FIN_ENTITY wise....refSer::"+refSer);
		String insrtFlag = "";
		String tranIDFin = "";
		String windowName = "";
		String userId = "";
		String termID ="";
		String sunDryType ="";
		PreparedStatement pstmtInsrt = null;
		try
		{
			InetAddress ownIP=InetAddress.getLocalHost();
			termID = checkNull(ownIP.getHostAddress());
			System.out.println("termID :-["+termID+"]");
			E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String currDate = sdf.format(new java.util.Date());
			currDate = genericUtility.getValidDateTimeString( currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
			System.out.println("currDate::::["+currDate+"]");
			
			if(refSer != null && refSer.equals("P-ORD"))
			{
				sunDryType ="S";
			}
			else if(refSer != null && refSer.equals("S-ORD"))
			{
				sunDryType ="C";
			}
			
			windowName = "w_fin_ctrl_excp";
			userId = getUserId(orderId,refSer,conn);
			
			System.out.println("userId :- ["+userId+"] windowName::::["+windowName+"]");
			tranIDFin = generateTranId( windowName,  userId, siteCodeVal, currDate, conn);
			
			String insrtSql = "INSERT INTO FIN_CTRL_EXCP ( TRAN_ID, TRAN_DATE, REF_SER, REF_NO, CONTACT_CODE, CONTR_DOMAIN, SITE_CODE, FIN_ENTITY , " +
					"SUNDRY_TYPE, SUNDRY_CODE, PRD_CODE__FR, PRD_CODE__TO, TRAN_CAT, ALERT_AMT, TRAN_AMT, MAX_AMT,OVER_RIDE , ADD_DATE , ADD_USER, ADD_TERM , ACCT_PRD ) " +
					"VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) ";
			
			pstmtInsrt = conn.prepareStatement(insrtSql);
			pstmtInsrt.setString(1, tranIDFin);
			pstmtInsrt.setTimestamp(2, java.sql.Timestamp.valueOf(currDate));
			pstmtInsrt.setString(3, refSer);
			pstmtInsrt.setString(4, orderId);
			pstmtInsrt.setString(5, "");
			pstmtInsrt.setString(6, "OL");
			pstmtInsrt.setString(7, siteCodeVal);
			pstmtInsrt.setString(8, finEntVal);
			pstmtInsrt.setString(9, sunDryType);
			pstmtInsrt.setString(10, ordCode);
			pstmtInsrt.setString(11, "");
			pstmtInsrt.setString(12, "");
			pstmtInsrt.setString(13, tranCat);
			pstmtInsrt.setDouble(14, calprojTurn);
			pstmtInsrt.setDouble(15, ordTotAmt);
			pstmtInsrt.setDouble(16, projTurn);
			pstmtInsrt.setString(17, "N");
			pstmtInsrt.setTimestamp(18, java.sql.Timestamp.valueOf(currDate));
			pstmtInsrt.setString(19, userId);
			pstmtInsrt.setString(20, termID);
			pstmtInsrt.setString(21, acctCode);
			
			int inCnt = pstmtInsrt.executeUpdate();
			
			pstmtInsrt.clearParameters();
			if (inCnt > 0)
			{
				System.out.println("Inserted successfully into FIN_CTRL_EXCP::="+inCnt);
				insrtFlag = "VTSUCC";
			}
			else
			{
				insrtFlag = "VTFAIL";
			}
		
		}
		catch (Exception e)
		{
			//insrtFlag = "VTFAIL";
			e.printStackTrace();
			System.out.println("Exception : insertFinCtrlExcpMst ==>\n"+e.getMessage());
			try
			{
				System.out.println("insertFinCtrlExcpMst Rollbacking transaction....");
				conn.rollback();
				insrtFlag =e.getMessage();
			}
			catch(Exception e1)
			{
				System.out.println("Exception while rollbacking transaction....");
				e1.printStackTrace();
			}
			
		}
		finally
		{
			try
			{
				if(pstmtInsrt !=null)
				{
					pstmtInsrt.close();
					pstmtInsrt = null;
				}
				
				System.out.println("Inserted successfully into FIN_CTRL_EXCP..........");
			}
			catch(Exception e)
			{
				e.printStackTrace();
				System.out.println("Exception : insertFinCtrlExcpMst ==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return insrtFlag;
	}

	public String updatetFinCtrlExcp(String orderId , String ordCode, String refSer, String overRide) throws ITMException
	{
		System.out.println("Inside updatetFinCtrlExcp..........refSer::"+refSer);
		String updtStatus ="";
		String roleCode = "";
		String userID = "";
		String termID = "";
		PreparedStatement pstmtUpdt = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		ConnDriver connDriver = null;
		Connection conn = null;
		
		try
		{
			connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			InetAddress ownIP=InetAddress.getLocalHost();
			termID = checkNull(ownIP.getHostAddress());
			System.out.println("termID :-["+termID+"]");
			
			E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String currDate = sdf.format(new java.util.Date());
			currDate = genericUtility.getValidDateTimeString( currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
			System.out.println("currDate::::["+currDate+"]");
			System.out.println("orderId::::["+orderId+"] ordCode:::["+ordCode+"] overRide:::["+overRide+"]");
			
			if(refSer != null && refSer.equals("P-ORD"))
			{
				roleCode ="PORPT_APRV";
			}
			else if(refSer != null && refSer.equals("S-ORD"))
			{
				roleCode ="SORPT_APRV";
			}
			String userSql= "SELECT USER_ID__SIGN AS USER_ID FROM OBJ_SIGN_TRANS WHERE REF_ID = ? AND REF_SER = ? and ROLE_CODE__SIGN = ? ";
			
			pstmt = conn.prepareStatement(userSql);
			pstmt.setString(1, orderId);
			pstmt.setString(2, refSer);
			pstmt.setString(3, roleCode);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				userID = checkNull(rs.getString("USER_ID"));
			}
			
			System.out.println("userID::::["+userID+"] roleCode::["+roleCode+"]");
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt !=null)
			{
				pstmt.close();
				pstmt = null;
			}
			
			
			String updtSql = "UPDATE FIN_CTRL_EXCP SET OVER_RIDE= ? , OVER_RIDE_DT = ?, ROLE_CODE = '"+roleCode+"' , USER_ID = '"+userID+"', " +
					" CHG_DATE = ? , CHG_USER = ? , CHG_TERM = ?  "  +
					" WHERE REF_NO = ? AND SUNDRY_CODE = ? AND REF_SER = '"+refSer+"' AND OVER_RIDE = 'N'";
			
			pstmtUpdt = conn.prepareStatement(updtSql);
			pstmtUpdt.setString(1,overRide);
			pstmtUpdt.setTimestamp(2, java.sql.Timestamp.valueOf(currDate));
			pstmtUpdt.setTimestamp(3, java.sql.Timestamp.valueOf(currDate));
			pstmtUpdt.setString(4,userID);
			pstmtUpdt.setString(5,termID);
			pstmtUpdt.setString(6,orderId);
			pstmtUpdt.setString(7,ordCode);
			
			int upCnt = pstmtUpdt.executeUpdate();
			System.out.println("upCnt in FIN_CTRL_EXCP::::["+upCnt+"]");
			if(upCnt > 0)
			{
				updtStatus ="Y";
			}
			pstmtUpdt.close();
			pstmtUpdt = null; 
			
		}
		catch (Exception e)
		{
			//insrtFlag = "VTFAIL";
			e.printStackTrace();
			System.out.println("Exception : updatetFinCtrlExcp ==>\n"+e.getMessage());
			try
			{
				System.out.println("updatetFinCtrlExcp rollbacking transaction....");
				conn.rollback();
				updtStatus = e.getMessage();
			}
			catch(Exception e1)
			{
				System.out.println("Exception while rollbacking transaction....");
				e1.printStackTrace();
			}
			
		}
		finally
		{
			try
			{
				if(pstmtUpdt !=null)
				{
					pstmtUpdt.close();
					pstmtUpdt = null;
				}
				if(conn !=null)
				{
					if("Y".equalsIgnoreCase(updtStatus))
					{
						conn.commit();
						System.out.println("commit successfully::::::");
					}
					else
					{
						//conn.rollback();
					}
					conn.close();
					conn = null;
				}
				System.out.println("Update successfully into FIN_CTRL_EXCP..........");
			}
			catch(Exception e)
			{
				e.printStackTrace();
				System.out.println("Exception : updatetFinCtrlExcp ==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		System.out.println("updatetFinCtrlExcp :: return updtStatus="+updtStatus);
		return updtStatus;
	}
	
	private static String generateTranId(String windowName, String userId,String siteCode, String currDate, Connection conn) throws Exception
	{
		Statement stmt = null;
		ResultSet rs = null;
		String sql = "";
		String tranId = "";
		CommonConstants commonConstants = new CommonConstants();
		try
		{
			sql = "SELECT KEY_STRING, TRAN_ID_COL, nvl(REF_SER,'PEXRE') FROM TRANSETUP WHERE TRAN_WINDOW = '"+windowName+"'";
			stmt = conn.createStatement();
			rs = stmt.executeQuery(sql);
			System.out.println("keyString :"+rs.toString());
			String keyString = "";
			String keyCol = "";
			String tranSer ="";
			if (rs.next())
			{
				keyString = rs.getString(1);
				keyCol = rs.getString(2);
				tranSer = rs.getString(3);
			}
			String xmlValues = "";
			System.out.println("keyCol::["+keyCol+"]");
			System.out.println("keyString::["+keyString+"]");
			System.out.println("tranSer::["+tranSer+"]");
			
			xmlValues ="<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
			xmlValues = xmlValues + "<Header></Header>";
			xmlValues = xmlValues + "<Detail1>";
			xmlValues = xmlValues + "<tran_id></tran_id>" ;
			xmlValues = xmlValues + "<site_code>"+siteCode+"</site_code>" ;
			xmlValues = xmlValues + "<tran_date>"+currDate+"</tran_date>" ;
			xmlValues = xmlValues + "</Detail1></Root>";
			System.out.println("xmlValues for tranid :["+xmlValues+"]");
			TransIDGenerator tg = new TransIDGenerator(xmlValues, userId, commonConstants.DB_NAME);
			tranId = tg.generateTranSeqID(tranSer, keyCol, keyString, conn);
			
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if(stmt !=null)
			{
				stmt.close();
				stmt = null;
			}
	
		}
		catch (SQLException ex)
		{
			System.out.println("Exception in generateTranId::" +sql+ ex.getMessage() + ":");
			ex.printStackTrace();
			throw new Exception(ex);
		}
		catch (Exception e)
		{
			System.out.println("Exception in generateTranId::" + e.getMessage() + ":");
			e.printStackTrace();
			throw new Exception(e);
		}
		System.out.println("tranId::"+tranId+"]");
		return tranId;
	}
	
	public String getUserId(String orderId ,String refSer,Connection conn) throws ITMException
	{
		System.out.println("Inside getUserId......");
		String usrID ="";
		String usrSql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try
		{
			if(refSer != null && refSer.equals("P-ORD"))
			{
				usrSql = "SELECT CHG_USER FROM PORDER WHERE PURC_ORDER = ? ";
			}
			else if(refSer != null && refSer.equals("S-ORD"))
			{
				usrSql = "SELECT CHG_USER FROM SORDER WHERE SALE_ORDER = ? ";
			}
			pstmt = conn.prepareStatement(usrSql);
			pstmt.setString(1,orderId);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				usrID = checkNull(rs.getString("CHG_USER"));
			}
			System.out.println("USER_ID::::==["+usrID+"]");
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt !=null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
			System.out.println("Exception : getUserId ==>\n"+e.getMessage());
			
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt !=null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
				System.out.println("Exception : getUserId ==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return usrID;
	}
	
	public String checkNull(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input= "";
		}
		return input.trim();
	}
}
