package ibase.webitm.ejb.dis;
import org.w3c.dom.Document;

import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ValidatorEJB;
//import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;

import javax.ejb.Stateless;

@Stateless
public class SaleOrderPostSave extends ValidatorEJB implements SaleOrderPostSaveLocal,SaleOrderPostSaveRemote {
	E12GenericUtility genericUtility= new  E12GenericUtility();
	public String postSave(String xmlString,String tranId,String editFlag, String xtraParams,Connection conn) throws RemoteException,ITMException
	{

		System.out.println("------------ postSave method called-----------------SaleOrderPostSave : ");
		System.out.println("tranId111--->>["+tranId+"]");
		System.out.println("xml String--->>["+xmlString+"]");
		Document dom = null;
		String errString="";

		try
		{
			if (xmlString != null && xmlString.trim().length() > 0)
			{
				dom = parseString(xmlString);				
				errString = postSave(dom,tranId,xtraParams,conn);
			}

		}
		catch(Exception e)
		{
			System.out.println("Exception : SaleOrderPostSave.java : postSave : ==>\n"+e.getMessage());
			throw new ITMException(e);
		}		
		return errString;
	}	
	public String postSave(Document dom,String tranId,String xtraParams,Connection conn)
	{
		System.out.println("in SaleOrderPostSave postSave tran_id---->>["+tranId+"]");
		ResultSet rs=null,rs1=null;
		PreparedStatement pstmt=null,pstmt1=null;
		String sql="",sql1="",errorString="";
		double quantityStduom = 0,rateStduom=0,discount=0,taxAmt=0,netAmt=0,taxAmtH=0,totAmtH=0,
		ordAmtH=0,ordValueH=0,ordValue=0,totOrdValueH=0,
		billBackAmt=0,offInvAmt=0,netTotAmtDet=0,netTotAmtHdr=0,ordBillBackAmt=0,ordOffInvAmt=0,lineBillBackAmt=0,lineOffInvAmt=0;
		int count=0,lineNo=0;
		try
		{
			//GenericUtility genericUtility = GenericUtility.getInstance();	
			ITMDBAccessEJB	itmDBAccessEJB = new ITMDBAccessEJB();
			tranId = genericUtility.getColumnValue("sale_order",dom);
			System.out.println("sale_order--->>["+tranId+"]");
			sql="select quantity__stduom,rate__stduom,discount,tax_amt,line_no,ord_value,"
				+ "billback_amt,offinv_amt "		//VALLABH KADAM [20/JUL/15] find billback_amt,offinv_amt
				+ "from sorddet where sale_order = ?";
			pstmt=conn.prepareStatement(sql);
			pstmt.setString(1, tranId);
			rs=pstmt.executeQuery();
			while(rs.next())
			{
				quantityStduom=rs.getDouble(1);
				rateStduom=rs.getDouble(2);
				discount=rs.getDouble(3);
				taxAmt=rs.getDouble(4);
				lineNo=rs.getInt(5);
				ordValue=rs.getDouble(6);
				billBackAmt=rs.getDouble(7); 	//VALLABH KADAM [20/JUL/15] find billback_amt
				offInvAmt=rs.getDouble(8);		//VALLABH KADAM [20/JUL/15] find offinv_amt

				System.out.println("quantityStduom-->["+quantityStduom+"]");
				System.out.println("rateStduom-->["+rateStduom+"]taxAmt-->["+taxAmt+"]");
				System.out.println("discount-->["+discount+"] lineNo-->["+lineNo+"]");

				netAmt=(quantityStduom*rateStduom)-((quantityStduom*rateStduom*discount)/100)+taxAmt;
				System.out.println("NetAmt--->>["+netAmt+"]");

				/**
				 * VALLABH KADAM [20/JUL/15]
				 * Calculate net_tot_amt
				 * for every detail
				 * */
				netTotAmtDet=netAmt-billBackAmt-offInvAmt;
				System.out.println("Nte Total Amt Det:- ["+netTotAmtDet+"]");

				sql1="update sorddet set net_amt = ?,net_tot_amt=? where sale_order = ? and line_no = ?";
				pstmt1=conn.prepareStatement(sql1);
				pstmt1.setDouble(1, netAmt);
				pstmt1.setDouble(2, netTotAmtDet); //VALLABH KADAM [20/JUL/15]set net_tot_amt for every detail
				pstmt1.setString(3, tranId);
				pstmt1.setInt(4, lineNo);
				pstmt1.executeUpdate();
				if (pstmt1 != null){
					pstmt1.close();
					pstmt1=null;
				}

				taxAmtH=taxAmtH + taxAmt;
				totAmtH=totAmtH + netAmt;

				totOrdValueH=totOrdValueH + ordValue;				
			} //end while
			if (pstmt != null)
			{
				pstmt.close();
				pstmt=null;
			}
			if (rs !=null)
			{
				rs.close();
				rs=null;
			}
			ordAmtH=totAmtH - taxAmtH;
			System.out.println("pre count---->>["+count+"]");
			System.out.println("taxAmtH-->["+taxAmtH+"] totAmtH-->["+totAmtH+"]");
			System.out.println("ordAmtH-->["+ordAmtH+"] totOrdValueH-->["+totOrdValueH+"]");

			/**
			 * VALLABH KADAM [20/JUL/15]
			 * find ord_billback_amt, ord_offinv_amt, line_billback_amt, line_offinv_amt
			 * to calculate net_tot_amt for header
			 * */
			sql1="SELECT ORD_BILLBACK_AMT,ORD_OFFINV_AMT, LINE_BILLBACK_AMT,LINE_OFFINV_AMT FROM SORDER WHERE SALE_ORDER=?";
			pstmt1=conn.prepareStatement(sql1);
			pstmt1.setString(1, tranId);
			rs1=pstmt1.executeQuery();
			if(rs1.next())
			{
				ordBillBackAmt=rs1.getDouble("ORD_BILLBACK_AMT");
				ordOffInvAmt=rs1.getDouble("ORD_OFFINV_AMT");
				lineBillBackAmt=rs1.getDouble("LINE_BILLBACK_AMT");
				lineOffInvAmt=rs1.getDouble("LINE_OFFINV_AMT");
			}
			pstmt1.close();
			pstmt1=null;
			rs1.close();
			rs1=null;

			netTotAmtHdr=totAmtH-ordBillBackAmt-ordOffInvAmt-lineBillBackAmt-lineOffInvAmt;
			System.out.println("Net Tot Amt Hdr :- ["+netTotAmtHdr+"]");


			sql="update sorder set tax_amt = ? ,tot_amt= ? ,ord_amt = ?,tot_ord_value= ?,net_tot_amt=?  where sale_order = ?";
			pstmt=conn.prepareStatement(sql);
			pstmt.setDouble(1, taxAmtH);
			pstmt.setDouble(2, totAmtH);
			pstmt.setDouble(3, ordAmtH);
			pstmt.setDouble(4, totOrdValueH);	
			pstmt.setDouble(5, netTotAmtHdr);		// VALLABH KADAM [20/JUL/15] net_tot_amt for header	
			pstmt.setString(6, tranId);
			count=pstmt.executeUpdate();
			System.out.println("post count---->>["+count+"]");
			//Manoj dtd 18/03/2016 Removed Commit and Rollback condition
			if(count==0)
			{
				errorString=itmDBAccessEJB.getErrorString("","VTNORUPDT","","",conn);
				System.out.println("errorString :"+errorString);
			}
			// Changed by Manish for Maximum open cursor on 29/03/16 [start]
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			// Changed by Manish for Maximum open cursor on 29/03/16 [end]		
		}
		catch(Exception e)
		{
			System.out.println("Exception : SaleOrderPostSave -->["+e.getMessage()+"]");
			e.printStackTrace();
			try
			{
				conn.rollback();
			}
			catch(Exception e1)
			{
				System.out.println("Exception while rollbacking transaction....");
				e1.printStackTrace();
			}
		}
		// Changed by Manish for Maximum open cursor on 29/03/16 [start]
		finally
		{
			try
			{
				if (pstmt != null)
				{
					pstmt.close();
					pstmt=null;
				}
				if (rs !=null)
				{
					rs.close();
					rs=null;
				}
				if (pstmt1 != null)
				{
					pstmt1.close();
					pstmt1=null;
				}
				if (rs1 !=null)
				{
					rs1.close();
					rs1=null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		// Changed by Manish for Maximum open cursor on 29/03/16 [end]
		return errorString;
	}
}
