package ibase.dashboard.iem.ejb;
import ibase.dashboard.Report.Utility.DashboardUtility;
import ibase.system.config.ConnDriver;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.List;

import javax.ejb.Stateless;

import org.json.simple.JSONObject;

@Stateless
public class ManagmentDashboard implements ManagmentDashboardLocal, ManagmentDashboardRemote
{
	GenericUtility genericUtility = GenericUtility.getInstance();
	SimpleDateFormat gridDateFormat=null;
	SimpleDateFormat convrtToTimStmDate=null;
	public ManagmentDashboard()
	{
	}

	private String checkNull(String str)
	{
		if (str == null)
		{
			return "";
		} else
		{
			return str;
		}

	}
	/**** Start Of getPendingReqSummary() Method
	* Method Name  : getPendingReqSummary (String dataSourceName, String empCode, String fromDate, String toDate)
	* Metadata Xml : management.xml
	* Servlet Name : PendingReqSummaryServlet
	* 
	*******/
	@SuppressWarnings("unchecked")
	@Override
	public JSONObject getPendingReqSummary(String dataSourceName, String empCode, String fromDate, String toDate) throws RemoteException, ITMException
	{
		JSONObject rowDataPendingTaskJson = new JSONObject();
		JSONObject rowData = null;
		String sql         = "";
		ResultSet rs       = null;
		PreparedStatement pstmt = null;
		Connection conn    = null;
		Timestamp frmDateInTs = null;
		Timestamp toDateInTs  = null;
		ConnDriver connDriver = new ConnDriver();
		SimpleDateFormat convertToDbDate  = null;
		SimpleDateFormat simpleDateFormat = null;
		Calendar calendar = null;
		/*Start Added By sachin 13-Jan-16*/
		String timeSpent="";
		String stdCompTime="";
		String openingRequest="";
		String promisDurPrd="";
		String receDurPrd="";
		String delDurPrd="";
		String cntWisePromise="";
		String cntWrkGng="";
		String noOfReq="";
		
		/*End Added By sachin 13-Jan-16*/		
		try
		{
			conn       = connDriver.getConnectDB(dataSourceName);
			connDriver = null;
			rowData    = new JSONObject();
			convertToDbDate = new SimpleDateFormat(genericUtility.getDBDateFormat());
			if((fromDate==null) ||(fromDate.equals("")) && (toDate==null) || (toDate.equals("")))
			{ 				
				simpleDateFormat   = new SimpleDateFormat( genericUtility.getApplDateFormat());
	  			calendar           = Calendar.getInstance();
	  			toDate             = simpleDateFormat.format(calendar.getTime());	
	  			calendar           = Calendar.getInstance();
	  			calendar.add(Calendar.MONTH, -12);
	  			fromDate        = simpleDateFormat.format(calendar.getTime());
				frmDateInTs     = java.sql.Timestamp.valueOf(convertToDbDate.format(simpleDateFormat.parse(fromDate)).toString() + " 00:00:00.0");
				toDateInTs      = java.sql.Timestamp.valueOf(convertToDbDate.format(simpleDateFormat.parse(toDate)).toString() + " 00:00:00.0");
				
			}  	 
			else
			{  
				//comment date 
				//simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy");
				
				/*Comment and change code to date format by Dhanendra on date 16-06-2016*/
				
				/*simpleDateFormat   = new SimpleDateFormat( genericUtility.getApplDateFormat());
				frmDateInTs        = java.sql.Timestamp.valueOf(convertToDbDate.format(simpleDateFormat.parse(fromDate)).toString() + " 00:00:00.0");
				toDateInTs         = java.sql.Timestamp.valueOf(convertToDbDate.format(simpleDateFormat.parse(toDate)).toString() + " 00:00:00.0");*/
				
				frmDateInTs= Timestamp.valueOf(genericUtility.getValidDateString(fromDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat()) + " 00:00:00.0");
				toDateInTs= Timestamp.valueOf(genericUtility.getValidDateString(toDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat()) + " 00:00:00.0");

			}
			System.out.println("getPendingReqSummary frmDateInTs :"+frmDateInTs+"----- toDateInTs :"+toDateInTs);
			/* For Opening Request * */
            if((frmDateInTs!=null && frmDateInTs.toString().length()>0) 
            	&& (toDateInTs!=null && toDateInTs.toString().length()>0) 
            	&& (empCode!=null && empCode.trim().length()>0) )
            {
		//	sql = "select count(1) opening_request from ser_request where req_date < ?   and emp_code__assign = ? and (comp_stat <> 'C' or comp_stat_dt>=?)";
		
			/* [START] Modify  SQL By sachin on 20-JAN-16 For Adding Ticket data*/
			sql=" select sum (opening_request) as opening_request from (select count(1) opening_request  from ser_request " +
				" where req_date < ? and emp_code__assign = ? and req_id <>'9999999999' and (comp_stat <> 'C' or " +
				" comp_stat_dt >= ?) " +
				//" and req_id not like 'CO%' and lower(dtl_descr) not like 'client sup%' AND ITEM_SER <>'TRG'" +
				" and  REQ_TYPE <> 'GENSUPP' "+
				" union all " +
				" select count(1) opening_request  from service_complaint where TICKET_DATE < ? and submitted_to2 = ? " +
				" and (status <> 'C' or Resolve_date1 >= ?))";
			
			
			
			pstmt = conn.prepareStatement(sql);
			pstmt.setTimestamp(1, frmDateInTs);
			pstmt.setString(2, empCode);
			/*Add for comp_stat_dt as a from date as per manohar sir by Dhanendra on 12-01-2016*/
			pstmt.setTimestamp(3, frmDateInTs);
			/*End for comp_stat_dt as a from date as per manohar sir by Dhanendra on 12-01-2016*/
			
			pstmt.setTimestamp(4, frmDateInTs);
			pstmt.setString(5, empCode);
			/*Add for comp_stat_dt as a from date as per manohar sir by Dhanendra on 12-01-2016*/
			pstmt.setTimestamp(6, frmDateInTs);
			
			
			/*[END] Modify  SQL By sachin on 20-JAN-16 For Adding Ticket data*/
			
			
			rs = pstmt.executeQuery();
			if (rs.next())
			{
			 openingRequest=	checkNull(rs.getString("opening_request"));
			}
			
			/*Start  modify Code by sachin on 13-Jan-16*/
			if(openingRequest.trim().length()>0)
			{
			   rowData.put("openingrequest", openingRequest);
			}else
			{
				rowData.put("openingrequest", 0);	
			}
			/*End  modify Code by sachin on 13-Jan-16*/
			
			pstmt.close();
			pstmt = null;
			rs.close();
			rs = null;

			/*Receive Opening Request * */
		//	sql = "select count(1) as rece_dur_prd from ser_request where req_date between  ? and ?   and emp_code__assign = ?";
			
			/* [START] Modify  SQL By sachin on 20-JAN-16 For Adding Ticket data*/	
			sql="select sum(rece_dur_prd) as   rece_dur_prd from ( select count(1) as rece_dur_prd from ser_request where req_date between  ? and ?   and emp_code__assign = ? " +
				" and req_id <>'9999999999'  and " +
				//"req_id not like 'CO%' and lower(dtl_descr) not like 'client sup%' AND ITEM_SER <>'TRG' " +
				" REQ_TYPE <> 'GENSUPP' "+
				" union all select count(1) as rece_dur_prd from service_complaint " +
				" where ticket_date  between  ? and ?   and submitted_to2 = ? )";
			
			
			pstmt = conn.prepareStatement(sql);
			pstmt.setTimestamp(1, frmDateInTs);
			pstmt.setTimestamp(2, toDateInTs);
			pstmt.setString(3, empCode);
			pstmt.setTimestamp(4, frmDateInTs);
			pstmt.setTimestamp(5, toDateInTs);
			pstmt.setString(6, empCode);
			
			/* [END] Modify  SQL By sachin on 20-JAN-16 For Adding Ticket data*/
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				 receDurPrd=checkNull(rs.getString("rece_dur_prd"));
			}
			/*Start  modify Code by sachin on 13-Jan-16*/
			
			if(receDurPrd.trim().length()>0)
			{
				rowData.put("receiveduringprd",receDurPrd);
			}else
			{
				rowData.put("receiveduringprd", 0);	
			}
			/*End  modify Code by sachin on 13-Jan-16*/
			
			pstmt.close();
			pstmt = null;
			rs.close();
			rs = null;

			//Promised during this period
			//sql = "select count(1) as proms_dur_prd from ser_request where EXP_END_DATE between  ? and ?   and emp_code__assign = ?";
			/* [START] Modify  SQL By sachin on 20-JAN-16 For Adding Ticket data*/
			
		sql="select sum(proms_dur_prd)  proms_dur_prd from ( select count(1) as proms_dur_prd from ser_request where EXP_END_DATE between  ? and ?   and emp_code__assign = ? and req_id <>'9999999999' " +
			//" and req_id not like 'CO%' and lower(dtl_descr) not like 'client sup%' AND ITEM_SER <>'TRG' " +
			" and REQ_TYPE <> 'GENSUPP'" +
			" union all select count(1)" +
			" as proms_dur_prd from service_complaint  where resolve_date1 between ? and ?   and submitted_to2 = ? )" ;
		
			pstmt = conn.prepareStatement(sql);
			pstmt.setTimestamp(1, frmDateInTs);
			pstmt.setTimestamp(2, toDateInTs);
			pstmt.setString(3, empCode);
			pstmt.setTimestamp(4, frmDateInTs);
			pstmt.setTimestamp(5, toDateInTs);
			pstmt.setString(6, empCode);
			/* [END] Modify  SQL By sachin on 20-JAN-16 For Adding Ticket data*/
			
			rs = pstmt.executeQuery();
			
			if (rs.next())
			{
				 promisDurPrd= checkNull(rs.getString("proms_dur_prd"));
			}
			
			/*Start  modify Code by sachin on 13-Jan-16*/
			if(promisDurPrd.trim().length()>0)
			{
				rowData.put("promceduringprd",promisDurPrd);
			}else
			{
				rowData.put("promceduringprd", 0);	
			}
			/*End  modify Code by sachin on 13-Jan-16*/
			pstmt.close();
			pstmt = null;
			rs.close();
			rs = null;

			//--- Delivered during this period
			//sql = "select count(1) as del_dur_prd  from ser_request where COMP_STAT_DT between  ? and ?   and emp_code__assign = ? and comp_stat = 'C'";
			
			/* [START] Modify  SQL By sachin on 20-JAN-16 For Adding Ticket data*/
			sql = " select sum( del_dur_prd)  as del_dur_prd  from (select  count(1) as del_dur_prd from ser_request where " +
					" COMP_STAT_DT between  ? and ?  and emp_code__assign = ? and comp_stat = 'C' and req_id <>'9999999999'  " +
					//" and req_id not like 'CO%' and lower(dtl_descr) not like 'client sup%' AND ITEM_SER <>'TRG'" +
					" and REQ_TYPE <> 'GENSUPP'" +
					" union all" +
					" select  count(1) as del_dur_prd from service_complaint  where Resolve_date1  between  ? and ?  and submitted_to2  = ? " +
					" and status = 'C' )";	
			
			
			
			pstmt = conn.prepareStatement(sql);
			pstmt.setTimestamp(1, frmDateInTs);
			pstmt.setTimestamp(2, toDateInTs);
			pstmt.setString(3, empCode);
			pstmt.setTimestamp(4, frmDateInTs);
			pstmt.setTimestamp(5, toDateInTs);
			pstmt.setString(6, empCode);
			/* [END] Modify  SQL By sachin on 20-JAN-16 For Adding Ticket data*/
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				delDurPrd= checkNull(rs.getString("del_dur_prd"));
			}

			/*Start  modify Code by sachin on 13-Jan-16*/
			if(delDurPrd.trim().length()>0)
			{
				rowData.put("deliduringprd",delDurPrd);
			}else
			{
				rowData.put("deliduringprd", 0);	
			}
			/*End  modify Code by sachin on 13-Jan-16*/
			
			pstmt.close();
			pstmt = null;
			rs.close();
			rs = null;

			//	--- Count without a promised date
			System.out.println("***** SQL Start for  Count without a promised date**** ");
			//sql = "select count(1)  cnt_wit_prom from ser_request where emp_code__assign = ? and EXP_END_DATE is null";
			/* [START] Modify  SQL By sachin on 20-JAN-16 For Adding Ticket data*/
			sql = "select sum(cnt_wit_prom)  AS cnt_wit_prom from (select count(1) as cnt_wit_prom " +
					" from ser_request where emp_code__assign = ? and EXP_END_DATE is null and req_id <>'9999999999' and " +
					" comp_stat <> 'C' and" +
					//" req_id not like 'CO%' and lower(dtl_descr) not like 'client sup%' AND ITEM_SER <>'TRG'" +
					" REQ_TYPE <> 'GENSUPP'" +
					" union all select count(1) as cnt_wit_prom from service_complaint  where submitted_to2 = ? and resolve_date1 is null  " +
					" and status <> 'C' )"; 
			
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, empCode);
			pstmt.setString(2, empCode);
			/* [END] Modify  SQL By sachin on 20-JAN-16 For Adding Ticket data*/
			rs = pstmt.executeQuery();
			
			if (rs.next())
			{
			 cntWisePromise= checkNull(rs.getString("cnt_wit_prom"));
			}

			/*Start  modify Code by sachin on 13-Jan-16*/
			if(cntWisePromise.trim().length()>0)
			{
				rowData.put("cntwitpromise",cntWisePromise);
			}else
			{
				rowData.put("cntwitpromise", 0);	
			}
			/*End  modify Code by sachin on 13-Jan-16*/
			pstmt.close();
			pstmt = null;
			rs.close();
			rs = null;

			//--- Count on which work going on
			//sql = "select count(distinct r.req_id)  as cnt_wrk_gng from ser_req_feedbk f, ser_request r where f.req_id = r.req_id and r.emp_code__assign = ? and f.EXECUT_DT between ? and ? ";
			/*
			 * Added by sachin on 13-Jan-15
			 */
			// sql = "select count(distinct r.req_id)  as cnt_wrk_gng from ser_req_feedbk f, ser_request r where f.req_id = r.req_id and r.emp_code__assign = ? and f.EXECUT_DT between ? and ?  and r.comp_stat <> 'C'";
				/*
				  End Added by sachin on 13-Jan-15
				 */
			/* [START] Modify  SQL By sachin on 20-JAN-16 For Adding Ticket data*/
			 sql = " SELECT count(DISTINCT cnt_wrk_gng) as cnt_wrk_gng FROM ( select r.req_id  as  cnt_wrk_gng  from ser_req_feedbk f ," +
			 		" ser_request r WHERE f.req_id = r.req_id AND r.emp_code__assign = ? AND f.EXECUT_DT BETWEEN ? AND ? AND r.comp_stat <> 'C'  " +
			 		" and r.req_id <>'9999999999' and" +
			 		//" R.req_id not like 'CO%' and lower(R.dtl_descr) not like 'client sup%' AND R.ITEM_SER <>'TRG' " +
			 		" R.REQ_TYPE <> 'GENSUPP'" +
			 		" union all select s.ticket_no as cnt_wrk_gng  from ser_req_feedbk f ,service_complaint  s WHERE f.ticket_no = s.ticket_no " +
			 		" AND s.submitted_to2 = ? AND f.EXECUT_DT BETWEEN ? AND ? AND s.status <> 'C' )"; 
			
		
			 
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, empCode);
			pstmt.setTimestamp(2, frmDateInTs);
			pstmt.setTimestamp(3, toDateInTs);
			pstmt.setString(4, empCode);
			pstmt.setTimestamp(5, frmDateInTs);
			pstmt.setTimestamp(6, toDateInTs);
			/* [END] Modify  SQL By sachin on 20-JAN-16 For Adding Ticket data*/
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				  cntWrkGng=checkNull(rs.getString("cnt_wrk_gng"));
			}

			/*Star modify Code by sachin on 13-Jan-16*/
			
			if(cntWrkGng.trim().length()>0)
			{
				rowData.put("cntwrkgoing",cntWrkGng);
			}else
			{
				rowData.put("cntwrkgoing", 0);	
			}
			/*End  modify Code by sachin on 13-Jan-16*/
			pstmt.close();
			pstmt = null;
			rs.close();
			rs = null;

			//--- Total man hours spent on completed request
			//--- Estimated man hours for the completed request

		/*	sql = " select nvl(fn_feedbk_time(sum(d.time_spent)),'0') as  time_spent,nvl(r.STD_COMP_TIME,'0') as STD_COMP_TIME  "
				+ " from ser_request r, SER_REQ_FEEDBKDTL d,SER_REQ_FEEDBK h "
				+ " where d.feedbk_id = h.feedbk_id "
				+ " and r.req_id = h.req_id "
				+ " and r.COMP_STAT_DT between  ? and ?   "
				+ " and r.emp_code__assign = ? and r.comp_stat = 'C' group by r.STD_COMP_TIME ";*/
			
			/* [START] Modify  SQL By sachin on 20-JAN-16 For Adding Ticket data*/
			sql = " SELECT nvl(fn_feedbk_time(sum(time_spent)), '0') AS time_spent ,nvl(STD_COMP_TIME, '0') AS STD_COMP_TIME from " +
					" (select d.time_spent ,r.std_comp_time FROM ser_request r ,SER_REQ_FEEDBKDTL d ,SER_REQ_FEEDBK h WHERE d.feedbk_id = h.feedbk_id " +
					" AND r.req_id = h.req_id AND r.COMP_STAT_DT BETWEEN ? AND ? AND r.emp_code__assign = ? AND r.comp_stat = 'C' and r.req_id <>'9999999999' " +
					//" and r.req_id not like 'CO%' and lower(r.dtl_descr) not like 'client sup%' AND r.ITEM_SER <>'TRG'" +
					" and r.REQ_TYPE <> 'GENSUPP'" +
					" union all select d.time_spent ,0 as std_comp_time FROM " +
					" service_complaint s ,SER_REQ_FEEDBKDTL d ,SER_REQ_FEEDBK h WHERE d.feedbk_id = h.feedbk_id AND s.ticket_no = h.ticket_no AND s.resolve_date1" +
					" BETWEEN ? AND ? AND s.submitted_to2 = ? AND s.status = 'C' ) group by  STD_COMP_TIME";
		
			pstmt = conn.prepareStatement(sql);
			pstmt.setTimestamp(1, frmDateInTs);
			pstmt.setTimestamp(2, toDateInTs);
			pstmt.setString(3, empCode);
			pstmt.setTimestamp(4, frmDateInTs);
			pstmt.setTimestamp(5, toDateInTs);
			pstmt.setString(6, empCode);
			/* [END] Modify  SQL By sachin on 20-JAN-16 For Adding Ticket data*/
			rs = pstmt.executeQuery();

			if (rs.next())
			{
				timeSpent=checkNull(rs.getString("time_spent"));
				stdCompTime=checkNull(rs.getString("STD_COMP_TIME"));
			}
			/*Star Added Code by sachin on 13-Jan-16*/
			if(timeSpent.trim().length()>0)
			{
				rowData.put("totalmanhrs", timeSpent);
			}else
			{
				rowData.put("totalmanhrs", 0);
			}
			
			if(stdCompTime.trim().length()>0)
			{
				rowData.put("estimatedmanhrs", stdCompTime);
			}else
			{
				rowData.put("estimatedmanhrs", 0);
			}

			/*End Added Code by sachin on 13-Jan-16*/
			
			pstmt.close();
			pstmt = null;
			rs.close();
			rs = null;

			//--- Closing  Opening + received - delivered

			/*sql = " select sum(no_request) as no_req from (select count(1) as no_request from ser_request where " +
					//" req_date  between  ? and ?  " +// commented by swati 05 Dec 2016
					" req_date < ? "+ // added by swati 05 Dec 2016
					"and emp_code__assign = ? and (comp_stat <> 'C' or comp_stat_dt>=?) union all select count(1) " +
					" from ser_request where " +
					"req_date between  ? and ?   " +
					//" req_date < ? "+// added by swati 05 Dec 2016
					"and emp_code__assign = ? " +
					" union all select -1 * count(1) from ser_request where " +
					" COMP_STAT_DT between  ? and ?   and emp_code__assign = ? and comp_stat = 'C' )";
*/			
			//--- Closing  Opening + received - delivered
			/* [START] Modify  SQL By sachin on 20-JAN-16 For Adding Ticket data*/
			sql = " SELECT sum(no_request) AS no_req FROM ( SELECT count(1) AS no_request FROM ser_request WHERE req_date < ? AND emp_code__assign = ? AND ( comp_stat <> 'C' OR comp_stat_dt >= ? ) " +
				" and req_id <>'9999999999' " +
				//" req_id not like 'CO%' and lower(dtl_descr) not like 'client sup%' AND ITEM_SER <>'TRG' " +
				" and REQ_TYPE <> 'GENSUPP'" +
				" UNION ALL SELECT count(1) AS no_request FROM " +
				
				" ser_request WHERE req_date BETWEEN ? AND ? AND emp_code__assign = ? and req_id <>'9999999999' " +
				//"  req_id not like 'CO%' and lower(dtl_descr) not like 'client sup%' AND ITEM_SER <>'TRG' " +
				" and REQ_TYPE <> 'GENSUPP'" +
				" UNION ALL SELECT - 1 * count(1) AS no_request FROM ser_request WHERE COMP_STAT_DT BETWEEN ? AND ? AND emp_code__assign = ? " +
				" AND comp_stat = 'C' and req_id <>'9999999999' and " +
				//" req_id not like 'CO%' and lower(dtl_descr) not like 'client sup%' AND ITEM_SER <>'TRG' " +
				" REQ_TYPE <> 'GENSUPP'" +
				" UNION ALL SELECT count(1) " +
				" AS no_request FROM service_complaint WHERE ticket_date < ? AND submitted_to2 = ? AND ( status <> 'C' OR Resolve_date1 >= ? ) UNION ALL SELECT count(1) AS no_request " +
				" FROM service_complaint WHERE ticket_date BETWEEN ? AND ? AND submitted_to2 = ? UNION ALL SELECT - 1 * count(1) AS no_request FROM service_complaint WHERE Resolve_date1 " +
				" BETWEEN ? AND ? AND submitted_to2 = ? AND status = 'C' ) ";
			
			
			pstmt = conn.prepareStatement(sql);
			pstmt.setTimestamp(1, frmDateInTs);
			pstmt.setString(2, empCode);
			/*Add for comp_stat_dt as a from date as per manohar sir by Dhanendra on 12-01-2016*/
			pstmt.setTimestamp(3, frmDateInTs); 
			/*End for comp_stat_dt as a from date as per manohar sir by Dhanendra on 12-01-2016*/
			pstmt.setTimestamp(4, frmDateInTs);
			pstmt.setTimestamp(5, toDateInTs);
			pstmt.setString(6, empCode);
			pstmt.setTimestamp(7, frmDateInTs);
			pstmt.setTimestamp(8, toDateInTs);
			pstmt.setString(9,empCode);
            
			
			pstmt.setTimestamp(10, frmDateInTs);
			pstmt.setString(11, empCode);
			/*Add for comp_stat_dt as a from date as per manohar sir by Dhanendra on 12-01-2016*/
			pstmt.setTimestamp(12, frmDateInTs); 
			/*End for comp_stat_dt as a from date as per manohar sir by Dhanendra on 12-01-2016*/
			pstmt.setTimestamp(13, frmDateInTs);
			pstmt.setTimestamp(14, toDateInTs);
			pstmt.setString(15, empCode);
			pstmt.setTimestamp(16, frmDateInTs);
			pstmt.setTimestamp(17, toDateInTs);
			pstmt.setString(18,empCode);
			
			/* [END] Modify  SQL By sachin on 20-JAN-16 For Adding Ticket data*/
			
			rs = pstmt.executeQuery();

			if (rs.next())
			{
				 noOfReq=checkNull(rs.getString("no_req"));
			}

			if(noOfReq.trim().length()>0)
			{
				rowData.put("noreq",noOfReq);
			}else
			{
				rowData.put("noreq", 0);	
			}
			pstmt.close();
			pstmt = null;
			rs.close();
			rs = null;

			rowDataPendingTaskJson.put(Integer.valueOf(0), rowData);			
			System.out.println(" getPendingReqSummary json  is =" + rowDataPendingTaskJson);
			
		}

		} catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
						rs.close();
					rs = null;
					if (pstmt != null)
						pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :TaskActivity: getPendingReqSummary() :" + d.getMessage());
				throw new ITMException(d);
			}
		}

		return rowDataPendingTaskJson;
	}
	/**** End of getPendingReqSummary() Method ***/
	
	/**** Start Of getPendingReqSummaryGrpah() Method
	* Method Name  : getPendingReqSummaryGrpah (String dataSourceName, String empCode, String fromDate, String toDate)
	* Metadata Xml : management.xml
	* Servlet Name : PendingReqSummaryGraphServlet
	* 
	*******/
	@SuppressWarnings("unchecked")
	@Override
	public JSONObject getPendingReqSummaryGrpah(String dataSourceName, String empCode, String fromDate, String toDate) throws RemoteException, ITMException
	{
		JSONObject rowDataPendingTaskJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		ResultSet rs            = null;
		PreparedStatement pstmt = null;
		Connection conn       = null;
		Timestamp frmDateInTs = null;
		Timestamp toDateInTs  = null;
		ConnDriver connDriver = new ConnDriver();
		SimpleDateFormat convertToDbDate = null;
		SimpleDateFormat simpleDateFormat = null;
		Calendar calendar=null;		
		int count=0;
		try
		{
			conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;
			rowData = new JSONObject();
			convertToDbDate = new SimpleDateFormat(genericUtility.getDBDateFormat());
			
			
			if((fromDate==null) ||(fromDate.equals("")) && (toDate==null) || (toDate.equals("")))
			{ 
 				
				simpleDateFormat   = new SimpleDateFormat( genericUtility.getApplDateFormat());
	  			calendar           = Calendar.getInstance();
	  			toDate             = simpleDateFormat.format(calendar.getTime());	
	  			calendar           = Calendar.getInstance();
	  			/* Start Modify by sachin on 14-JAN-16*/
	  			
	  			calendar.add(Calendar.MONTH, -12);
	  			
	  			/*End Modify by sachin on 14-JAN-16*/
	  			fromDate        = simpleDateFormat.format(calendar.getTime());
				frmDateInTs     = java.sql.Timestamp.valueOf(convertToDbDate.format(simpleDateFormat.parse(fromDate)).toString() + " 00:00:00.0");
				toDateInTs      = java.sql.Timestamp.valueOf(convertToDbDate.format(simpleDateFormat.parse(toDate)).toString() + " 00:00:00.0");
			
			}  	 
			else
			{
				//comment date
				//simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy");
				
				/*Comment and change code to date format by Dhanendra on date 16-06-2016*/
				
				/*simpleDateFormat   = new SimpleDateFormat( genericUtility.getApplDateFormat());
				frmDateInTs = java.sql.Timestamp.valueOf(convertToDbDate.format(simpleDateFormat.parse(fromDate)).toString() + " 00:00:00.0");
				toDateInTs = java.sql.Timestamp.valueOf(convertToDbDate.format(simpleDateFormat.parse(toDate)).toString() + " 00:00:00.0");*/
				
				frmDateInTs= Timestamp.valueOf(genericUtility.getValidDateString(fromDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat()) + " 00:00:00.0");
				toDateInTs= Timestamp.valueOf(genericUtility.getValidDateString(toDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat()) + " 00:00:00.0");
				
			}
			System.out.println("getPendingReqSummaryGrpah frmDateInTs  :"+frmDateInTs +"---- toDateInTs :"+toDateInTs);

			/* Foe Opening Request * */
			if((frmDateInTs!=null && frmDateInTs.toString().length()>0) 
	            	&& (toDateInTs!=null && toDateInTs.toString().length()>0) 
	            	&& (empCode!=null && empCode.trim().length()>0) )
	        {
			/*Add or condition by Dhanendra as per manohar sir on 12-01-16*/
		/*	sql = "select count(1) opening_request from ser_request where req_date < ?   and emp_code__assign = ? and (comp_stat <> 'C' or comp_stat_dt>=?)";
			pstmt = conn.prepareStatement(sql);
			pstmt.setTimestamp(1, frmDateInTs);
			pstmt.setString(2, empCode);
			Add for comp_stat_dt as a from date as per manohar sir by Dhanendra on 12-01-2016
			pstmt.setTimestamp(3, frmDateInTs);
			End for comp_stat_dt as a from date as per manohar sir by Dhanendra on 12-01-2016*/
				
				/* [START] Modify  SQL By sachin on 20-JAN-16 For Adding Ticket data*/
				sql=" select sum (opening_request) as opening_request from (select count(1) opening_request  from ser_request " +
						" where req_date < ? and emp_code__assign = ? and req_id <>'9999999999' and (comp_stat <> 'C' or " +
						" comp_stat_dt >= ?) " +
						" and  REQ_TYPE <> 'GENSUPP' "+
						" union all " +
						" select count(1) opening_request  from service_complaint where TICKET_DATE < ? and submitted_to2 = ? " +
						" and (status <> 'C' or Resolve_date1 >= ?))";
					
				
				pstmt = conn.prepareStatement(sql);
				pstmt.setTimestamp(1, frmDateInTs);
				pstmt.setString(2, empCode);
				/*Add for comp_stat_dt as a from date as per manohar sir by Dhanendra on 12-01-2016*/
				pstmt.setTimestamp(3, frmDateInTs);
				/*End for comp_stat_dt as a from date as per manohar sir by Dhanendra on 12-01-2016*/
				
				pstmt.setTimestamp(4, frmDateInTs);
				pstmt.setString(5, empCode);
				/*Add for comp_stat_dt as a from date as per manohar sir by Dhanendra on 12-01-2016*/
				pstmt.setTimestamp(6, frmDateInTs);
				
				/*[END] Modify  SQL By sachin on 20-JAN-16 For Adding Ticket data*/
				
				
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				 rowData.put("descr","Opening" );
				 rowData.put("count",checkNull(rs.getString("opening_request")) );
				 rowDataPendingTaskJson.put(count, rowData);
				 count++;
			}
			pstmt.close();
			pstmt = null;
			rs.close();
			rs = null;

			/* End Foe Opening Request * */

		/*	sql = "select count(1) as rece_dur_prd from ser_request where req_date between  ? and ?   and emp_code__assign = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setTimestamp(1, frmDateInTs);
			pstmt.setTimestamp(2, toDateInTs);
			pstmt.setString(3, empCode);
	*/		
			/* [START] Modify  SQL By sachin on 20-JAN-16 For Adding Ticket data*/	
			sql="select sum(rece_dur_prd) as   rece_dur_prd from ( select count(1) as rece_dur_prd from ser_request where req_date between  ? and ?   and emp_code__assign = ? " +
					" and req_id <>'9999999999'  and " +
					" REQ_TYPE <> 'GENSUPP' "+
					" union all select count(1) as rece_dur_prd from service_complaint " +
					" where ticket_date  between  ? and ?   and submitted_to2 = ? )";
				
			
			pstmt = conn.prepareStatement(sql);
			pstmt.setTimestamp(1, frmDateInTs);
			pstmt.setTimestamp(2, toDateInTs);
			pstmt.setString(3, empCode);
			pstmt.setTimestamp(4, frmDateInTs);
			pstmt.setTimestamp(5, toDateInTs);
			pstmt.setString(6, empCode);
			
			/* [END] Modify  SQL By sachin on 20-JAN-16 For Adding Ticket data*/
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				 rowData = new JSONObject();
				 rowData.put("descr","Received" );
				 rowData.put("count",checkNull(rs.getString("rece_dur_prd")) );
				 rowDataPendingTaskJson.put(count, rowData);
				 count++;
			}

			pstmt.close();
			pstmt = null;
			rs.close();
			rs = null;

			//Promised during this period
		/*	sql = "select count(1) as proms_dur_prd from ser_request where EXP_END_DATE between  ? and ?   and emp_code__assign = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setTimestamp(1, frmDateInTs);
			pstmt.setTimestamp(2, toDateInTs);
			pstmt.setString(3, empCode);
			*/
			
			sql="select sum(proms_dur_prd)  proms_dur_prd from ( select count(1) as proms_dur_prd from ser_request where EXP_END_DATE between  ? and ?   and emp_code__assign = ? and req_id <>'9999999999' " +
				//" and req_id not like 'CO%' and lower(dtl_descr) not like 'client sup%' AND ITEM_SER <>'TRG' " +
				" and REQ_TYPE <> 'GENSUPP'" +
				" union all select count(1)" +
				" as proms_dur_prd from service_complaint  where resolve_date1 between ? and ?   and submitted_to2 = ? )" ;
					
					pstmt = conn.prepareStatement(sql);
					pstmt.setTimestamp(1, frmDateInTs);
					pstmt.setTimestamp(2, toDateInTs);
					pstmt.setString(3, empCode);
					pstmt.setTimestamp(4, frmDateInTs);
					pstmt.setTimestamp(5, toDateInTs);
					pstmt.setString(6, empCode);
					/* [END] Modify  SQL By sachin on 20-JAN-16 For Adding Ticket data*/
			
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				 rowData = new JSONObject();
				 rowData.put("descr","Promised" );
				 rowData.put("count",checkNull(rs.getString("proms_dur_prd")) );
				 rowDataPendingTaskJson.put(count, rowData);
				 count++;
			}

			pstmt.close();
			pstmt = null;
			rs.close();
			rs = null;

			//--- Delivered during this period
/*
			sql = "select count(1) as del_dur_prd  from ser_request where COMP_STAT_DT between  ? and ?   and emp_code__assign = ? and comp_stat = 'C'";
			pstmt = conn.prepareStatement(sql);
			pstmt.setTimestamp(1, frmDateInTs);
			pstmt.setTimestamp(2, toDateInTs);
			pstmt.setString(3, empCode);*/

			/* [START] Modify  SQL By sachin on 20-JAN-16 For Adding Ticket data*/
			sql = " select sum( del_dur_prd)  as del_dur_prd  from (select  count(1) as del_dur_prd from ser_request where " +
					" COMP_STAT_DT between  ? and ?  and emp_code__assign = ? and comp_stat = 'C' and req_id <>'9999999999'  " +
					//" and req_id not like 'CO%' and lower(dtl_descr) not like 'client sup%' AND ITEM_SER <>'TRG'" +
					" and REQ_TYPE <> 'GENSUPP'" +
					" union all" +
					" select  count(1) as del_dur_prd from service_complaint  where Resolve_date1  between  ? and ?  and submitted_to2  = ? " +
					" and status = 'C' )";	
			
			
			pstmt = conn.prepareStatement(sql);
			pstmt.setTimestamp(1, frmDateInTs);
			pstmt.setTimestamp(2, toDateInTs);
			pstmt.setString(3, empCode);
			pstmt.setTimestamp(4, frmDateInTs);
			pstmt.setTimestamp(5, toDateInTs);
			pstmt.setString(6, empCode);
			/* [END] Modify  SQL By sachin on 20-JAN-16 For Adding Ticket data*/
			
			
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				 rowData = new JSONObject();
				 rowData.put("descr","Delivered" );
				 rowData.put("count",checkNull(rs.getString("del_dur_prd")) );
				 rowDataPendingTaskJson.put(count, rowData);
				 count++;
			}

			pstmt.close();
			pstmt = null;
			rs.close();
			rs = null;

			//	--- Count without a promised date
		//	sql   = "select count(1)  cnt_wit_prom from ser_request where emp_code__assign = ? and COMP_STAT_DT is null";
			/*Start Modify by sachin on 13 -Jan-16*/
			/*sql = "select count(1)  cnt_wit_prom from ser_request where emp_code__assign = ? and EXP_END_DATE is null";
			 End Modify by sachin on 13 -Jan-16
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, empCode);*/
			
			/* [START] Modify  SQL By sachin on 20-JAN-16 For Adding Ticket data*/
			sql = "select sum(cnt_wit_prom)  AS cnt_wit_prom from (select count(1) as cnt_wit_prom " +
					" from ser_request where emp_code__assign = ? and EXP_END_DATE is null and req_id <>'9999999999' and " +
					" comp_stat <> 'C' and" +
				//	" req_id not like 'CO%' and lower(dtl_descr) not like 'client sup%' AND ITEM_SER <>'TRG'" +
					" REQ_TYPE <> 'GENSUPP'" +
					" union all select count(1) as cnt_wit_prom from service_complaint  where submitted_to2 = ? and resolve_date1 is null  " +
					" and status <> 'C' )"; 
			
					pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, empCode);
			pstmt.setString(2, empCode);
			/* [END] Modify  SQL By sachin on 20-JAN-16 For Adding Ticket data*/

			rs = pstmt.executeQuery();
			if (rs.next())
			{
				 rowData = new JSONObject();
				 rowData.put("descr","Without Promised Date" );
				 rowData.put("count",checkNull(rs.getString("cnt_wit_prom")) );
				 rowDataPendingTaskJson.put(count, rowData);
				 count++;
			}

			pstmt.close();
			pstmt = null;
			rs.close();
			rs    = null;

			//--- Count on which work going on
		//	sql = "select count(distinct r.req_id)  as cnt_wrk_gng from ser_req_feedbk f, ser_request r where f.req_id = r.req_id and r.emp_code__assign = ? and f.EXECUT_DT between ? and ? ";
			/*
			 * Added by sachin on 13-Jan-16
			 */
			/* sql = "select count(distinct r.req_id)  as cnt_wrk_gng from ser_req_feedbk f, ser_request r where f.req_id = r.req_id and r.emp_code__assign = ? and f.EXECUT_DT between ? and ?  and r.comp_stat <> 'C'";
				  End Added by sachin on 13-Jan-16
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, empCode);
			pstmt.setTimestamp(2, frmDateInTs);
			pstmt.setTimestamp(3, toDateInTs);*/
			
			/* [START] Modify  SQL By sachin on 20-JAN-16 For Adding Ticket data*/
			 sql = " SELECT count(DISTINCT cnt_wrk_gng) as cnt_wrk_gng FROM ( select r.req_id  as  cnt_wrk_gng  from ser_req_feedbk f ," +
				 		" ser_request r WHERE f.req_id = r.req_id AND r.emp_code__assign = ? AND f.EXECUT_DT BETWEEN ? AND ? AND r.comp_stat <> 'C'  " +
				 		" and r.req_id <>'9999999999' and" +
				 		//" R.req_id not like 'CO%' and lower(R.dtl_descr) not like 'client sup%' AND R.ITEM_SER <>'TRG' " +
				 		" R.REQ_TYPE <> 'GENSUPP'" +
				 		" union all select s.ticket_no as cnt_wrk_gng  from ser_req_feedbk f ,service_complaint  s WHERE f.ticket_no = s.ticket_no " +
				 		" AND s.submitted_to2 = ? AND f.EXECUT_DT BETWEEN ? AND ? AND s.status <> 'C' )"; 
			
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, empCode);
			pstmt.setTimestamp(2, frmDateInTs);
			pstmt.setTimestamp(3, toDateInTs);
			pstmt.setString(4, empCode);
			pstmt.setTimestamp(5, frmDateInTs);
			pstmt.setTimestamp(6, toDateInTs);
			/* [END] Modify  SQL By sachin on 20-JAN-16 For Adding Ticket data*/
			
			rs = pstmt.executeQuery();
			if (rs.next())
			{
			     rowData = new JSONObject();
				 rowData.put("descr","Work Going On" );
				 rowData.put("count",checkNull(rs.getString("cnt_wrk_gng")) );
				 rowDataPendingTaskJson.put(count, rowData);
				 count++;
			}

			pstmt.close();
			pstmt = null;
			rs.close();
			rs    = null;

			//--- Total man hours spent on completed request
			//--- Estimated man hours for the completed request
		/*	sql = " select nvl(fn_feedbk_time(sum(d.time_spent)),'0') as time_spent,nvl(r.STD_COMP_TIME,'0') as STD_COMP_TIME from ser_request r, SER_REQ_FEEDBKDTL d,SER_REQ_FEEDBK h where d.feedbk_id = h.feedbk_id and r.req_id = h.req_id and r.COMP_STAT_DT between  ? and ?   and r.emp_code__assign = ? and r.comp_stat = 'C' group by r.STD_COMP_TIME ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setTimestamp(1, frmDateInTs);
			pstmt.setTimestamp(2, toDateInTs);
			pstmt.setString(3, empCode);
*/
			
			/* [START] Modify  SQL By sachin on 20-JAN-16 For Adding Ticket data*/
			sql = " SELECT nvl(fn_feedbk_time(sum(time_spent)), '0') AS time_spent ,nvl(STD_COMP_TIME, '0') AS STD_COMP_TIME from " +
					" (select d.time_spent ,r.std_comp_time FROM ser_request r ,SER_REQ_FEEDBKDTL d ,SER_REQ_FEEDBK h WHERE d.feedbk_id = h.feedbk_id " +
					" AND r.req_id = h.req_id AND r.COMP_STAT_DT BETWEEN ? AND ? AND r.emp_code__assign = ? AND r.comp_stat = 'C' and r.req_id <>'9999999999' " +
					//" and r.req_id not like 'CO%' and lower(r.dtl_descr) not like 'client sup%' AND r.ITEM_SER <>'TRG'" +
					" and r.REQ_TYPE <> 'GENSUPP'" +
					" union all select d.time_spent ,0 as std_comp_time FROM " +
					" service_complaint s ,SER_REQ_FEEDBKDTL d ,SER_REQ_FEEDBK h WHERE d.feedbk_id = h.feedbk_id AND s.ticket_no = h.ticket_no AND s.resolve_date1" +
					" BETWEEN ? AND ? AND s.submitted_to2 = ? AND s.status = 'C' ) group by  STD_COMP_TIME";
			
			pstmt = conn.prepareStatement(sql);
			pstmt.setTimestamp(1, frmDateInTs);
			pstmt.setTimestamp(2, toDateInTs);
			pstmt.setString(3, empCode);
			pstmt.setTimestamp(4, frmDateInTs);
			pstmt.setTimestamp(5, toDateInTs);
			pstmt.setString(6, empCode);
			/* [END] Modify  SQL By sachin on 20-JAN-16 For Adding Ticket data*/
			
			rs = pstmt.executeQuery();
			String time_spnet="",STD_COMP_TIME="";
			if (rs.next())
			{
				time_spnet=checkNull(rs.getString("time_spent"));
				STD_COMP_TIME=checkNull(rs.getString("STD_COMP_TIME"));
			}
			/*Start : Code commnent for Total Hours hide from dashboard as per manohar sir told On date 15-07-2016*/
			
			/*rowData = new JSONObject();
			rowData.put("descr","Total Hours" );
			rowData.put("count",(time_spnet=="" ? 0 : time_spnet) );
			rowDataPendingTaskJson.put(count, rowData);
			count++;*/
			
			/*End : Code commnent for Total Hours hide from dashboard as per manohar sir told On date 15-07-2016*/
			
			rowData = new JSONObject();
			rowData.put("descr","Estimated Hours" );
			rowData.put("count",(STD_COMP_TIME=="" ? 0 : STD_COMP_TIME));
			rowDataPendingTaskJson.put(count, rowData);
			count++;

			pstmt.close();
			pstmt = null;
			rs.close();
			rs = null;
		/*	sql = " select sum(no_request) as no_req from (select count(1) as no_request from ser_request where " +
					//" req_date  between  ? and ?  " +// commented by swati 05 Dec 2016
					" req_date < ? "+ // added by swati 05 Dec 2016
					"and emp_code__assign = ? and (comp_stat <> 'C' or comp_stat_dt>=?) union all select count(1) " +
					" from ser_request where " +
					"req_date between  ? and ?   " +
					//" req_date < ? "+// added by swati 05 Dec 2016
					"and emp_code__assign = ? " +
					" union all select -1 * count(1) from ser_request where " +
					" COMP_STAT_DT between  ? and ?   and emp_code__assign = ? and comp_stat = 'C' )";
			pstmt = conn.prepareStatement(sql);
			pstmt.setTimestamp(1, frmDateInTs);
			//pstmt.setTimestamp(2, toDateInTs);
			pstmt.setString(2, empCode);
			
			pstmt.setTimestamp(3, frmDateInTs);
			
			pstmt.setTimestamp(4, frmDateInTs);
			pstmt.setTimestamp(5, toDateInTs);
			pstmt.setString(6, empCode);
			pstmt.setTimestamp(7, frmDateInTs);
			pstmt.setTimestamp(8, toDateInTs);
			pstmt.setString(9,empCode);*/
            
			//--- Closing  Opening + received - delivered
			/* [START] Modify  SQL By sachin on 20-JAN-16 For Adding Ticket data */
			sql = "SELECT sum(no_request) AS no_req FROM ( SELECT count(1) AS no_request FROM ser_request WHERE req_date < ? AND emp_code__assign = ? AND ( comp_stat <> 'C' OR comp_stat_dt >= ? ) " +
					" and req_id <>'9999999999' " +
					//" req_id not like 'CO%' and lower(dtl_descr) not like 'client sup%' AND ITEM_SER <>'TRG' " +
					" and REQ_TYPE <> 'GENSUPP'" +
					" UNION ALL SELECT count(1) AS no_request FROM " +
					" ser_request WHERE req_date BETWEEN ? AND ? AND emp_code__assign = ? and req_id <>'9999999999' " +
					//"  req_id not like 'CO%' and lower(dtl_descr) not like 'client sup%' AND ITEM_SER <>'TRG' " +
					" and REQ_TYPE <> 'GENSUPP'" +
					" UNION ALL SELECT - 1 * count(1) AS no_request FROM ser_request WHERE COMP_STAT_DT BETWEEN ? AND ? AND emp_code__assign = ? " +
					" AND comp_stat = 'C' and req_id <>'9999999999' and " +
					//" req_id not like 'CO%' and lower(dtl_descr) not like 'client sup%' AND ITEM_SER <>'TRG' " +
					" REQ_TYPE <> 'GENSUPP'" +
					" UNION ALL SELECT count(1) " +
					" AS no_request FROM service_complaint WHERE ticket_date < ? AND submitted_to2 = ? AND ( status <> 'C' OR Resolve_date1 >= ? ) UNION ALL SELECT count(1) AS no_request " +
					" FROM service_complaint WHERE ticket_date BETWEEN ? AND ? AND submitted_to2 = ? UNION ALL SELECT - 1 * count(1) AS no_request FROM service_complaint WHERE Resolve_date1 " +
					" BETWEEN ? AND ? AND submitted_to2 = ? AND status = 'C' ) ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setTimestamp(1, frmDateInTs);
			//pstmt.setTimestamp(2, toDateInTs);
			pstmt.setString(2, empCode);
			/*Add for comp_stat_dt as a from date as per manohar sir by Dhanendra on 12-01-2016*/
			pstmt.setTimestamp(3, frmDateInTs); 
			/*End for comp_stat_dt as a from date as per manohar sir by Dhanendra on 12-01-2016*/
			pstmt.setTimestamp(4, frmDateInTs);
			pstmt.setTimestamp(5, toDateInTs);
			pstmt.setString(6, empCode);
			pstmt.setTimestamp(7, frmDateInTs);
			pstmt.setTimestamp(8, toDateInTs);
			pstmt.setString(9,empCode);
			pstmt.setTimestamp(10, frmDateInTs);
			//pstmt.setTimestamp(2, toDateInTs);
			pstmt.setString(11, empCode);
			/*Add for comp_stat_dt as a from date as per manohar sir by Dhanendra on 12-01-2016*/
			pstmt.setTimestamp(12, frmDateInTs); 
			/*End for comp_stat_dt as a from date as per manohar sir by Dhanendra on 12-01-2016*/
			pstmt.setTimestamp(13, frmDateInTs);
			pstmt.setTimestamp(14, toDateInTs);
			pstmt.setString(15, empCode);
			pstmt.setTimestamp(16, frmDateInTs);
			pstmt.setTimestamp(17, toDateInTs);
			pstmt.setString(18,empCode);
			/* [END] Modify  SQL By sachin on 20-JAN-16 For Adding Ticket data*/
			
			
			rs = pstmt.executeQuery();

			if (rs.next())
			{
				
				 rowData = new JSONObject();
				 rowData.put("descr","Closing" );
				 rowData.put("count",checkNull(rs.getString("no_req")) );
				 rowDataPendingTaskJson.put(count, rowData);
				 count++;
			}

			pstmt.close();
			pstmt = null;
			rs.close();
			rs = null;
	        }

		} catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
						rs.close();
					rs = null;
					if (pstmt != null)
						pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :TaskActivity: getPendingReqSummaryGrpah ():" + d.getMessage());
				throw new ITMException(d);
			}
		}

		return rowDataPendingTaskJson;
	}
	/**** End of getPendingReqSummaryGrpah() Method ***/
    

	/**** Start Of getWorkAlloSummary() Method
	* Method Name  : getWorkAlloSummary (String dataSourceName, String empCode, String fromDate, String toDate)
	* Metadata Xml : management.xml
	* Servlet Name : WorkAlloSummaryServlet
	* 
	*******/
	@SuppressWarnings("unchecked")
	@Override
	public JSONObject getWorkAlloSummary(String dataSourceName, String empCode, String fromDate, String toDate) throws RemoteException, ITMException
	{
		JSONObject rowDataEmpWrkAllJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		Timestamp frmDateInTs=null;
		Timestamp toDateInTs=null;
		SimpleDateFormat convertToDbDate=null;
		SimpleDateFormat simpleDateFormat=null;
		DashboardUtility dashboardUtility=null;
		String dateInput="", dateInput1 = "";
		try
		{
			conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;
			convertToDbDate   = new SimpleDateFormat(genericUtility.getDBDateFormat());
			System.out.println("In Management Dashboard Work Allocation: ");	
			dashboardUtility   = new DashboardUtility();
			
			simpleDateFormat   = new SimpleDateFormat( genericUtility.getApplDateFormat());
			if((fromDate==null) ||(fromDate.equals("")) && (toDate==null) || (toDate.equals("")))
			{ 				
				/*simpleDateFormat   = new SimpleDateFormat(genericUtility.getApplDateFormat());
	  			calendar             = Calendar.getInstance();
	  			//calendar.set(Calendar.DAY_OF_MONTH, calendar.getActualMaximum(Calendar.DAY_OF_MONTH));
	  			toDate          = simpleDateFormat.format(calendar.getTime());	
	  			calendar        = Calendar.getInstance();
	  			calendar.set(Calendar.DAY_OF_MONTH, calendar.getActualMinimum(Calendar.DAY_OF_MONTH));
	  			fromDate        = simpleDateFormat.format(calendar.getTime());
				frmDateInTs = java.sql.Timestamp.valueOf(convertToDbDate.format(simpleDateFormat.parse(fromDate)).toString() + " 00:00:00.0");
				toDateInTs = java.sql.Timestamp.valueOf(convertToDbDate.format(simpleDateFormat.parse(toDate)).toString() + " 00:00:00.0");
				System.out.println("get default date ,when user not entering date from GUI in TS format: From Date="+frmDateInTs+"To Date="+toDateInTs);*/
				
			}  	 
			else
			{  
				/*Comment and change code to date format by Dhanendra on date 16-06-2016*/					
				//frmDateInTs        = java.sql.Timestamp.valueOf(convertToDbDate.format(simpleDateFormat.parse(fromDate)).toString() + " 00:00:00.0");
				//toDateInTs         = java.sql.Timestamp.valueOf(convertToDbDate.format(simpleDateFormat.parse(toDate)).toString() + " 00:00:00.0");
				frmDateInTs= Timestamp.valueOf(genericUtility.getValidDateString(fromDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat()) + " 00:00:00.0");
				toDateInTs= Timestamp.valueOf(genericUtility.getValidDateString(toDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat()) + " 00:00:00.0");
				//dateInput         =" and h.TRAN_DATE >= ?  AND h.TRAN_DATE <= ?";
				
				dateInput = "and (select count(1) from SER_REQ_FEEDBK f,SER_REQ_FEEDBKDTL fd where f.feedbk_id = fd.feedbk_id and fd.action_id = d.action_id and fd.action_code = d.action_code and  f.req_id = h.req_id and f.execut_dt between ?  AND  ? ) > 0 ";
				dateInput1 = "and (select count(1) from SER_REQ_FEEDBK f,SER_REQ_FEEDBKDTL fd where f.feedbk_id = fd.feedbk_id and fd.action_id = d.action_id and fd.action_code = d.action_code and f.ticket_no = h.ticket_no and f.execut_dt between ?  AND  ? ) > 0 ";
			}
			System.out.println("getWorkAlloSummary frmDateInTs  :"+frmDateInTs +"---- toDateInTs :"+toDateInTs);
			
			if( (empCode!=null && empCode.trim().length()>0) )
			{
			empCode            = dashboardUtility.getCommaSeparated(empCode);
			
			
			/**Change Sql For Emp Unit time by sachin on 13-Jan-16**/
		/*	sql="select e.emp_fname || ' ' || e.emp_lname Employee ,i.req_id, i.dtl_descr,i.cust_code, cc.cust_name, sum(i.time_spent) as time_spent," +
					" sum(i.emp_time_spent) as emp_time_spent, i.plan_start_date,i.act_start_date, i.plan_end_date  ,I.STD_TIME,I.ACTION_DETL" +
					" from ( select d.emp_code,  r.req_id," +
					" r.cust_code,r.dtl_descr, d.STD_TIME, d.ACTION_DETL , (select min(di.PLANSTDATE) from ser_req_act_detl di, ser_req_act hi where hi.action_id = di.action_id " +
					" and hi.req_id = r.req_id and di.emp_code =  d.emp_code ) plan_start_date, (select min(fd.START_DATE_ACTUAL) from SER_REQ_FEEDBKDTL " +
					" fd, SER_REQ_FEEDBK fh where fd.feedbk_id = fh.feedbk_id  and fh.req_id = r.req_id and fh.emp_code =  d.emp_code) act_start_date," +
					" (select max(di.PLANENDDATE) from ser_req_act_detl di, ser_req_act hi where hi.action_id = di.action_id and hi.req_id = r.req_id " +
					" and di.emp_code =  d.emp_code ) plan_end_date, (select fn_feedbk_time(sum(iid.time_spent))  from SER_REQ_FEEDBKDTL iid,SER_REQ_FEEDBK iih " +
					" where iid.feedbk_id = iih.feedbk_id and iih.req_id = r.req_id ) time_spent, (select fn_feedbk_time(sum(iiid.time_spent)) as dd from " +
					" SER_REQ_FEEDBKDTL iiid, SER_REQ_FEEDBK iiih where iiid.feedbk_id = iiih.feedbk_id and iiih.req_id          = r.req_id and " +
					" iiid.action_id     = h.action_id and iiid.action_code = d.action_code and iiih.emp_code   = d.emp_code ) emp_time_spent from  " +
					" ser_request r,  ser_req_act h, ser_req_act_detl d where d.action_id = h.action_id and r.req_id = h.req_id and r.comp_stat <> 'C' " +
					" and ((d.emp_code in (select emp_code FROM EMPLOYEE START WITH EMP_CODE = "+empCode+" CONNECT BY PRIOR EMP_CODE = REPORT_TO AND " +
					" REPORT_TO IS NOT NULL AND  ( RELIEVE_DATE IS NULL OR RELIEVE_DATE >= SYSDATE ))) or (d.emp_code = "+empCode+")) " + dateInput +
					" group by d.emp_code, r.req_id, r.cust_code, r.dtl_descr,d.action_code,h.action_id,d.STD_TIME,d.ACTION_DETL ) i, employee e, customer cc" +
					" where i.emp_code = e.emp_code and cc.cust_code = i.cust_code group by  e.emp_fname || ' ' || e.emp_lname,i.req_id, i.dtl_descr," +
					" i.cust_code, cc.cust_name, i.plan_start_date,i.act_start_date, i.plan_end_date ,I.STD_TIME,I.ACTION_DETL order by e.emp_fname || ' ' || e.emp_lname,i.req_id" ;
*/			
			/**Change Sql For Emp Unit time by sachin on 13-Jan-16**/
					
			/**Modify  Sql Add Ticket Condition   by sachin on 20-Jan-16**/
			
		/*sql= " SELECT e.emp_fname || ' ' || e.emp_lname Employee ,i.req_id ,i.dtl_descr ,i.cust_code ,cc.cust_name ,sum(i.time_spent) AS time_spent ,sum(i.emp_time_spent) AS emp_time_spent, " +
				" i.plan_start_date ,i.act_start_date ,i.plan_end_date ,I.STD_TIME ,I.ACTION_DETL FROM ( SELECT d.emp_code ,r.req_id ,r.cust_code ,r.dtl_descr ,d.STD_TIME ,d.ACTION_DETL ," +
				" ( SELECT min(di.PLANSTDATE) FROM ser_req_act_detl di ,ser_req_act hi WHERE hi.action_id = di.action_id AND hi.req_id = r.req_id AND di.emp_code = d.emp_code ) plan_start_date ," +
				" ( SELECT min(fd.START_DATE_ACTUAL) FROM SER_REQ_FEEDBKDTL fd ,SER_REQ_FEEDBK fh WHERE fd.feedbk_id = fh.feedbk_id AND fh.req_id = r.req_id " +
				" AND fh.emp_code = d.emp_code ) act_start_date ,( SELECT max(di.PLANENDDATE) FROM ser_req_act_detl di ,ser_req_act hi WHERE " +
				" hi.action_id = di.action_id AND hi.req_id = r.req_id AND di.emp_code = d.emp_code ) plan_end_date ," +
				" ( SELECT sum(fn_feedbk_time(iid.time_spent)) FROM SER_REQ_FEEDBKDTL iid ,SER_REQ_FEEDBK iih WHERE iid.feedbk_id = iih.feedbk_id AND" +
				" iih.req_id = r.req_id ) time_spent ,( SELECT sum(fn_feedbk_time(iiid.time_spent)) AS dd FROM SER_REQ_FEEDBKDTL iiid ,SER_REQ_FEEDBK iiih " +
				" WHERE iiid.feedbk_id = iiih.feedbk_id AND iiih.req_id = r.req_id AND iiid.action_id = h.action_id AND iiid.action_code = d.action_code AND" +
				" iiih.emp_code = d.emp_code ) emp_time_spent FROM ser_request r ,ser_req_act h ,ser_req_act_detl d WHERE d.action_id = h.action_id AND" +
				" r.req_id = h.req_id AND r.comp_stat <> 'C' and r.req_id <>'9999999999' and " +
				" r.REQ_TYPE <> 'GENSUPP'" +
				" AND ( ( d.emp_code IN ( SELECT emp_code FROM EMPLOYEE START WITH EMP_CODE = "+empCode+" CONNECT BY PRIOR EMP_CODE = REPORT_TO AND" +
				" REPORT_TO IS NOT NULL AND ( RELIEVE_DATE IS NULL OR RELIEVE_DATE >= SYSDATE ) ) ) OR (d.emp_code = "+empCode+")) "+ dateInput  +
				" GROUP BY d.emp_code ,r.req_id ,r.cust_code ,r.dtl_descr ,d.action_code ,h.action_id ,d.STD_TIME ,d.ACTION_DETL UNION " +
				" ALL SELECT d.emp_code ,r.ticket_no AS req_id ,r.cust_code ,r.TICKET_DETAIL AS dtl_descr ,d.STD_TIME ,d.ACTION_DETL ," +
				" ( SELECT min(di.PLANSTDATE) FROM ser_req_act_detl di ,ser_req_act hi WHERE hi.action_id = di.action_id AND hi.ticket_no = r.ticket_no " +
				" AND di.emp_code = d.emp_code ) plan_start_date ,( SELECT min(fd.START_DATE_ACTUAL) FROM SER_REQ_FEEDBKDTL fd ,SER_REQ_FEEDBK fh " +
				" WHERE fd.feedbk_id = fh.feedbk_id AND fh.ticket_no = r.ticket_no AND fh.emp_code = d.emp_code ) act_start_date ," +
				" ( SELECT max(di.PLANENDDATE) FROM ser_req_act_detl di ,ser_req_act hi WHERE hi.action_id = di.action_id AND hi.ticket_no = r.ticket_no " +
				" AND di.emp_code = d.emp_code ) plan_end_date ,( SELECT fn_feedbk_time(sum(iid.time_spent)) FROM SER_REQ_FEEDBKDTL iid ,SER_REQ_FEEDBK iih " +
				" WHERE iid.feedbk_id = iih.feedbk_id AND iih.ticket_no = r.ticket_no ) time_spent ,( SELECT fn_feedbk_time(sum(iiid.time_spent)) AS dd FROM " +
				" SER_REQ_FEEDBKDTL iiid ,SER_REQ_FEEDBK iiih WHERE iiid.feedbk_id = iiih.feedbk_id AND iiih.ticket_no = r.ticket_no AND iiid.action_id = h.action_id " +
				" AND iiid.action_code = d.action_code AND iiih.emp_code = d.emp_code ) emp_time_spent FROM service_complaint r ,ser_req_act h ,ser_req_act_detl d WHERE" +
				" d.action_id = h.action_id AND r.ticket_no = h.ticket_no AND r.STATUS <> 'C' AND ( ( d.emp_code IN ( SELECT emp_code FROM EMPLOYEE START WITH " +
				" EMP_CODE = "+empCode+" CONNECT BY PRIOR EMP_CODE = REPORT_TO AND REPORT_TO IS NOT NULL AND ( RELIEVE_DATE IS NULL OR RELIEVE_DATE >= SYSDATE ) ) ) " +
				" OR (d.emp_code = "+empCode+") ) "+ dateInput1 +" GROUP BY d.emp_code ,r.ticket_no ,r.cust_code ,r.TICKET_DETAIL ,d.action_code , " +
				" h.action_id,d.STD_TIME ,d.ACTION_DETL ) i ,employee e ,customer cc WHERE i.emp_code = e.emp_code AND cc.cust_code = i.cust_code " +
				" GROUP BY e.emp_fname || ' ' || e.emp_lname ,i.req_id ,i.dtl_descr ,i.cust_code ,cc.cust_name ,i.plan_start_date ,i.act_start_date ,i.plan_end_date ," +
				" I.STD_TIME ,I.ACTION_DETL ORDER BY e.emp_fname || ' ' || e.emp_lname ,i.req_id "; 
			*/
		// manoharan in case of multiple resolution for same req_id,emp_code,action_code there is issue of double timespend
		
			sql= " SELECT e.emp_code, e.emp_fname || ' ' || e.emp_lname Employee ,i.req_id ,i.dtl_descr ,i.cust_code ,cc.cust_name ,sum(i.time_spent) AS time_spent ,sum(i.emp_time_spent) AS emp_time_spent,  min(i.plan_start_date) as plan_start_date,min(i.act_start_date) as act_start_date ,max(i.plan_end_date) as plan_end_date ,I.STD_TIME ,I.ACTION_DETL "
				+" FROM ( "
				+" SELECT d.emp_code ,r.req_id ,r.cust_code ,r.dtl_descr  ,a.ACTION_DETL, "
				+" ( SELECT sum(di.std_time) FROM ser_req_act_detl di ,ser_req_act hi WHERE  hi.action_id = di.action_id  and hi.req_id = r.req_id AND di.emp_code = d.emp_code and di.action_code = d.action_code  ) std_time, "
				+" ( SELECT min(di.PLANSTDATE) FROM ser_req_act_detl di ,ser_req_act hi WHERE  hi.req_id = r.req_id AND di.emp_code = d.emp_code ) plan_start_date,  "
				+" ( SELECT min(fd.START_DATE_ACTUAL) FROM SER_REQ_FEEDBKDTL fd ,SER_REQ_FEEDBK fh WHERE fd.feedbk_id = fh.feedbk_id AND fh.req_id = r.req_id  AND fh.emp_code = d.emp_code ) act_start_date, "
				+" ( SELECT max(di.PLANENDDATE) FROM ser_req_act_detl di ,ser_req_act hi WHERE   hi.req_id = r.req_id AND di.emp_code = d.emp_code ) plan_end_date,  "
				+" ( SELECT sum(fn_feedbk_time(iid.time_spent)) FROM SER_REQ_FEEDBKDTL iid ,SER_REQ_FEEDBK iih WHERE iid.feedbk_id = iih.feedbk_id AND iih.req_id = r.req_id ) time_spent, "
				+" ( SELECT sum(fn_feedbk_time(iiid.time_spent)) AS dd FROM SER_REQ_FEEDBKDTL iiid ,SER_REQ_FEEDBK iiih  WHERE iiid.feedbk_id = iiih.feedbk_id AND iiih.req_id = r.req_id AND  iiid.action_code = d.action_code AND iiih.emp_code = d.emp_code ) emp_time_spent "
				+" FROM ser_request r ,ser_req_act h ,ser_req_act_detl d,SER_COMP_RES a "
				+" WHERE d.action_id = h.action_id  "
				+" AND r.req_id = h.req_id "
				+" and a.action_code = d.action_code "
				+" and a.action_type = d.action_type "
				+" AND r.comp_stat <> 'C' "
				+" and r.req_id <>'9999999999' "
				+" and  r.REQ_TYPE <> 'GENSUPP'  "
				+" AND ( ( d.emp_code IN ( SELECT emp_code FROM EMPLOYEE START WITH EMP_CODE = "+empCode+" CONNECT BY PRIOR EMP_CODE = REPORT_TO AND REPORT_TO IS NOT NULL AND ( RELIEVE_DATE IS NULL OR RELIEVE_DATE >= SYSDATE ) ) ) OR (d.emp_code = "+empCode+")) " + dateInput
				+" GROUP BY d.emp_code ,r.req_id ,r.cust_code ,r.dtl_descr ,d.action_code   ,a.ACTION_DETL "
				+" UNION  ALL "
				+" SELECT d.emp_code ,r.ticket_no AS req_id ,r.cust_code ,r.TICKET_DETAIL AS dtl_descr ,a.ACTION_DETL, "
				+" ( SELECT sum(di.std_time) FROM ser_req_act_detl di ,ser_req_act hi WHERE  hi.action_id = di.action_id  and hi.ticket_no = r.ticket_no AND di.emp_code = d.emp_code and di.action_code = d.action_code  ) as std_time,  "
				+" ( SELECT min(di.PLANSTDATE) FROM ser_req_act_detl di ,ser_req_act hi WHERE  hi.ticket_no = r.ticket_no  AND di.emp_code = d.emp_code ) plan_start_date, "
				+" ( SELECT min(fd.START_DATE_ACTUAL) FROM SER_REQ_FEEDBKDTL fd ,SER_REQ_FEEDBK fh  WHERE fd.feedbk_id = fh.feedbk_id AND fh.ticket_no = r.ticket_no AND fh.emp_code = d.emp_code ) act_start_date,  "
				+" ( SELECT max(di.PLANENDDATE) FROM ser_req_act_detl di ,ser_req_act hi WHERE  hi.ticket_no = r.ticket_no  AND di.emp_code = d.emp_code ) plan_end_date, "
				+" ( SELECT nvl(sum(fn_feedbk_time(nvl(iid.time_spent,0))),0) FROM SER_REQ_FEEDBKDTL iid ,SER_REQ_FEEDBK iih  WHERE iid.feedbk_id = iih.feedbk_id AND iih.ticket_no = r.ticket_no ) time_spent, "
				+" ( SELECT nvl(sum(fn_feedbk_time(nvl(iiid.time_spent,0))),0) AS dd FROM  SER_REQ_FEEDBKDTL iiid ,SER_REQ_FEEDBK iiih WHERE iiid.feedbk_id = iiih.feedbk_id AND iiih.ticket_no = r.ticket_no   AND iiid.action_code = d.action_code AND iiih.emp_code = d.emp_code ) emp_time_spent "
				+" FROM service_complaint r ,ser_req_act h ,ser_req_act_detl d,SER_COMP_RES a "
				+" WHERE d.action_id = h.action_id "
				+" AND r.ticket_no = h.ticket_no  "
				+" and a.action_code = d.action_code "
				+" and a.action_type = d.action_type "
				+" AND r.STATUS <> 'C' "
				+" AND ( ( d.emp_code IN ( SELECT emp_code FROM EMPLOYEE START WITH  EMP_CODE = "+empCode+" CONNECT BY PRIOR EMP_CODE = REPORT_TO AND REPORT_TO IS NOT NULL AND ( RELIEVE_DATE IS NULL OR RELIEVE_DATE >= SYSDATE ) ) )  OR (d.emp_code = "+empCode+") ) "+ dateInput1 
				+" GROUP BY d.emp_code ,r.ticket_no ,r.cust_code ,r.TICKET_DETAIL ,d.action_code  ,a.ACTION_DETL "
				+" ) i ,employee e ,customer cc "
				+" WHERE i.emp_code = e.emp_code "
				+" AND cc.cust_code = i.cust_code  "
				+" GROUP BY e.emp_code, e.emp_fname || ' ' || e.emp_lname ,i.req_id ,i.dtl_descr ,i.cust_code ,cc.cust_name , I.STD_TIME ,I.ACTION_DETL "
				+" having sum(i.emp_time_spent) >0 "
				+" ORDER BY e.emp_fname || ' ' || e.emp_lname ,i.req_id ";

		/** End Modify  Sql Add Ticket Condition   by sachin on 20-Jan-16**/
			
		pstmt = conn.prepareStatement(sql);
				if(dateInput.trim().length()>0)
				{
				pstmt.setTimestamp(1,frmDateInTs);
				pstmt.setTimestamp(2,toDateInTs);
				pstmt.setTimestamp(3,frmDateInTs);
				pstmt.setTimestamp(4,toDateInTs);
				}
				rs = pstmt.executeQuery();
				int count = 0;
				while (rs.next())
				{
					
					rowData = new JSONObject();
					rowData.put("employee", checkNull(rs.getString("EMPLOYEE")));
					rowData.put("req_no",   checkNull(rs.getString("REQ_ID")));
					rowData.put("descr",    checkNull(rs.getString("DTL_DESCR")));
					rowData.put("client",   checkNull(rs.getString("CUST_NAME")));
					
					String startDate       =checkNull(rs.getString("PLAN_START_DATE"));
					String endDate         =checkNull(rs.getString("PLAN_END_DATE"));
					String actStartDate    =checkNull(rs.getString("ACT_START_DATE"));
					
					if(!startDate.equals(null) && startDate.trim().length()>0)
					{
						rowData.put("pln_strt_date", simpleDateFormat.format(convertToDbDate.parse(startDate)));
					}
					else
					{							
						rowData.put("pln_strt_date",checkNull(rs.getString("PLAN_START_DATE")));
					}	
					if(!endDate.equals(null) && endDate.trim().length()>0)
					{
						rowData.put("pln_end_date", simpleDateFormat.format(convertToDbDate.parse(endDate)));
						rowData.put("exp_cmplt_date", simpleDateFormat.format(convertToDbDate.parse(endDate)));
					}
					else
					{							
						rowData.put("pln_end_date",checkNull(rs.getString("PLAN_END_DATE")));
						rowData.put("exp_cmplt_date",checkNull(rs.getString("PLAN_END_DATE")));
					}
					if(!actStartDate.equals(null) && actStartDate.trim().length()>0)
					{
						rowData.put("act_strt_date", simpleDateFormat.format(convertToDbDate.parse(actStartDate)));
					}
					else
					{							
						rowData.put("act_strt_date",checkNull(rs.getString("ACT_START_DATE")));
					}
					rowData.put("man_days_spent",String.format("%.2f",(Double.parseDouble(checkDouble(rs.getString("time_spent"))))/8));
					rowData.put("act_descr", checkNull(rs.getString("ACTION_DETL")));
					rowData.put("est_man_hour", checkNull(rs.getString("STD_TIME")));
					rowData.put("hour_spent", checkNull(rs.getString("time_spent")));
					
					/**Added by sachin on 7-Jan-16*/
					rowData.put("emp_hour_spent", checkNull(rs.getString("emp_time_spent")));
					/**End Addede by sachin on 7-Jan-16*/
					
					rowDataEmpWrkAllJson.put(Integer.valueOf(count), rowData);
					count++;
				}
		      }
		} catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
						rs.close();
					rs = null;
					if (pstmt != null)
						pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in : ManagmentDashboard : getEmpWorkAllocation() :" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return rowDataEmpWrkAllJson;
	
	}
	/**** End of getEmpWorkAllocation() Method ***/
	
	/**** Start Of getReqEfficiencySummary() Method
	* Method Name  : getReqEfficiencySummary (String dataSourceName, String empCode, String fromDate, String toDate)
	* Metadata Xml : management.xml
	* Servlet Name : ReqEfficiencySummaryServlet
	* 
	*******/
	
	@SuppressWarnings("unchecked")
	@Override
	public JSONObject getReqEfficiencySummary(String dataSourceName, String empCode, String fromDate, String toDate) throws RemoteException, ITMException
	{

		JSONObject rowDataEmpReqEffJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		Timestamp fromDateInTS=null;
		Timestamp toDateInTS=null;
		double deviation=0.0,stdTime=0.0,actTime=0.0;
		double totDeviation=0.0,totStdTime=0.0,totActTime=0.0;
		SimpleDateFormat	simpleDateFormat = null;
		SimpleDateFormat    convertToDbDate=null;
		Calendar calendar=null;
		DashboardUtility dashboardUtility=null;
		String compStat="";
		try
		{
			conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;
			//comment date static 
			//simpleDateFormat  = new SimpleDateFormat("dd/MM/yyyy");
			convertToDbDate   = new SimpleDateFormat(genericUtility.getDBDateFormat());
			System.out.println("In Management Dashboard Req Efficiency: ");
			dashboardUtility  = new DashboardUtility();
			empCode=dashboardUtility.getCommaSeparated(empCode);
			simpleDateFormat  = new SimpleDateFormat( genericUtility.getApplDateFormat());
			
			if((fromDate==null) ||(fromDate.equals("")) && (toDate==null) || (toDate.equals("")))
			{ 				
	  			calendar         = Calendar.getInstance();
	  			toDate           = simpleDateFormat.format(calendar.getTime());	
	  			calendar         = Calendar.getInstance();
	  			calendar.add(Calendar.DAY_OF_MONTH, -7);
	  			fromDate         = simpleDateFormat.format(calendar.getTime());
	  			fromDateInTS     = java.sql.Timestamp.valueOf(convertToDbDate.format(simpleDateFormat.parse(fromDate)).toString() + " 00:00:00.0");
	  			toDateInTS       = java.sql.Timestamp.valueOf(convertToDbDate.format(simpleDateFormat.parse(toDate)).toString() + " 00:00:00.0");
	  			
			}  	 
			else
			{
				/*Comment and change code for date format by Dhanendra on date 16-06-2016 */
				
				/*fromDateInTS = java.sql.Timestamp.valueOf(convertToDbDate.format(simpleDateFormat.parse(fromDate)).toString() + " 00:00:00.0");
				toDateInTS   = java.sql.Timestamp.valueOf(convertToDbDate.format(simpleDateFormat.parse(toDate)).toString() + " 00:00:00.0");
				fromDateInTS     = java.sql.Timestamp.valueOf(convertToDbDate.format(simpleDateFormat.parse(fromDate)).toString() + " 00:00:00.0");
				toDateInTS       = java.sql.Timestamp.valueOf(convertToDbDate.format(simpleDateFormat.parse(toDate)).toString() + " 00:00:00.0");*/
				
				fromDateInTS= Timestamp.valueOf(genericUtility.getValidDateString(fromDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat()) + " 00:00:00.0");
				toDateInTS= Timestamp.valueOf(genericUtility.getValidDateString(toDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat()) + " 00:00:00.0");
				
			}
			System.out.println("getReqEfficiencySummary fromDateInTS :"+fromDateInTS+"-------- toDateInTS : "+toDateInTS);
			
			if((fromDateInTS!=null && fromDateInTS.toString().length()>0) && (toDateInTS!=null && toDateInTS.toString().length()>0) 
	            	&& (empCode!=null && empCode.trim().length()>0) )
			{
				
				/* sql = "SELECT  r.comp_stat_dt,r.COMP_STAT,R.REQ_ID,R.DTL_DESCR, AD.ACTION_DETL, E.EMP_FNAME || ' ' || E.EMP_LNAME EMP_NAME, "
	                      +" AD.STD_TIME as STD_TIME ,max((SELECT FN_FEEDBK_TIME(SUM(FD.TIME_SPENT)) FROM SER_REQ_FEEDBKDTL FD, "
	                      +" SER_REQ_FEEDBK FH WHERE FD.FEEDBK_ID = FH.FEEDBK_ID AND FH.REQ_ID = R.REQ_ID "
	                      +" AND  FD.ACTION_ID = AD.ACTION_ID "
	                      +" AND FD.ACTION_CODE = AD.ACTION_CODE and fh.emp_code = e.emp_code )) ACTUAL_TIME " //added fh.emp_code = e.emp_code by dhanendra on 24 dec 2015
	                      +" from ser_request r, ser_req_act ah, ser_req_act_detl ad, employee e "
	                      +" where ah.action_id = ad.action_id "
	                      +" and ah.req_id = r.req_id "
	                      +" AND E.EMP_CODE =  ad.EMP_CODE AND r.comp_stat ='C' "
	                      +" and r.comp_stat_dt >= ? and r.comp_stat_dt <= ?  "//--?
	                      +" AND ((ad.emp_code in (select emp_code FROM EMPLOYEE START WITH EMP_CODE = "+empCode+"  "     
	                      +" CONNECT BY PRIOR EMP_CODE = REPORT_TO AND REPORT_TO IS NOT NULL "
	                      +" AND  ( RELIEVE_DATE IS NULL OR RELIEVE_DATE >= SYSDATE )) ) OR (ad.emp_code="+empCode+"))"
	                      +" group by r.req_id,r.dtl_descr, ad.action_detl, r.COMP_STAT,e.emp_fname || ' ' || e.emp_lname,  ad.STD_TIME ,r.comp_stat_dt " 
	                      + " order by r.comp_stat_dt desc ";*/
				 
				 /* [Start] Modify SQL By sachin on 20-Jan-16 for Adding Ticket Condition*/
					sql=" SELECT comp_stat_dt ,COMP_STAT ,REQ_ID ,DTL_DESCR ,ACTION_DETL ,EMP_NAME ,STD_TIME ,ACTUAL_TIME FROM" +
							" ( SELECT r.comp_stat_dt ,r.COMP_STAT ,R.REQ_ID ,R.DTL_DESCR ,AD.ACTION_DETL ,E.EMP_FNAME || ' ' || E.EMP_LNAME EMP_NAME ," +
							" AD.STD_TIME AS STD_TIME ,max(( SELECT FN_FEEDBK_TIME(SUM(FD.TIME_SPENT)) FROM SER_REQ_FEEDBKDTL FD ,SER_REQ_FEEDBK FH WHERE" +
							" FD.FEEDBK_ID = FH.FEEDBK_ID AND FH.REQ_ID = R.REQ_ID AND FD.ACTION_ID = AD.ACTION_ID AND FD.ACTION_CODE = AD.ACTION_CODE AND " +
							" fh.emp_code = e.emp_code )) ACTUAL_TIME FROM ser_request r ,ser_req_act ah ,ser_req_act_detl ad ,employee e " +
							" WHERE ah.action_id = ad.action_id AND ah.req_id = r.req_id AND E.EMP_CODE = ad.EMP_CODE AND r.comp_stat = 'C' " +
							" and r.req_id <>'9999999999' AND r.ITEM_SER <>'TRG' AND r.comp_stat_dt >= ? AND r.comp_stat_dt <= ? " +
							" AND ( ( ad.emp_code IN ( SELECT emp_code FROM EMPLOYEE START WITH EMP_CODE = "+empCode+" CONNECT BY PRIOR " +
							" EMP_CODE = REPORT_TO AND REPORT_TO IS NOT NULL AND ( RELIEVE_DATE IS NULL OR RELIEVE_DATE >= SYSDATE ) ) ) " +
							" OR (ad.emp_code = "+empCode+") ) GROUP BY r.comp_stat_dt ,r.COMP_STAT ,R.REQ_ID ,R.DTL_DESCR ,AD.ACTION_DETL ," +
							" E.EMP_FNAME || ' ' || E.EMP_LNAME ,AD.STD_TIME UNION ALL SELECT r.resolve_date3 AS comp_stat_dt ," +
							" r.STATUS AS COMP_STAT ,R.ticket_no AS REQ_ID ,r.ticket_Detail AS DTL_DESCR ,AD.ACTION_DETL ACTION_DETL ,E.EMP_FNAME || ' ' || E.EMP_LNAME AS EMP_NAME ," +
							" AD.STD_TIME AS STD_TIME ,max(( SELECT FN_FEEDBK_TIME(SUM(FD.TIME_SPENT)) FROM SER_REQ_FEEDBKDTL FD ,SER_REQ_FEEDBK FH " +
							" WHERE FD.FEEDBK_ID = FH.FEEDBK_ID AND FH.ticket_no = r.ticket_no AND FD.ACTION_ID = AD.ACTION_ID AND FD.ACTION_CODE = AD.ACTION_CODE" +
							" AND fh.emp_code = e.emp_code )) ACTUAL_TIME FROM service_complaint r ,ser_req_act ah ,ser_req_act_detl ad ,employee e WHERE ah.action_id = ad.action_id " +
							" AND ah.ticket_no = r.ticket_no AND E.EMP_CODE = ad.EMP_CODE AND r.STATUS = 'C' AND r.resolve_date3 >= ? AND r.resolve_date3 <= ? " +
							" AND ( ( ad.emp_code IN ( SELECT emp_code FROM EMPLOYEE START WITH EMP_CODE = "+empCode+" CONNECT BY PRIOR EMP_CODE = REPORT_TO AND REPORT_TO IS NOT NULL " +
							" AND ( RELIEVE_DATE IS NULL OR RELIEVE_DATE >= SYSDATE ) ) ) OR (ad.emp_code = "+empCode+") ) GROUP BY r.resolve_date3 ,r.STATUS ,R.ticket_no ,r.ticket_Detail ," +
							" AD.ACTION_DETL ,E.EMP_FNAME || ' ' || E.EMP_LNAME ,AD.STD_TIME ) ORDER BY comp_stat_dt DESC";
					
					/* [END] Modify SQL By sachin on 20-Jan-16 for Adding Ticket Condition*/
				 
				pstmt = conn.prepareStatement(sql);
				pstmt.setTimestamp(1,fromDateInTS);
				pstmt.setTimestamp(2,toDateInTS);		
				pstmt.setTimestamp(3,fromDateInTS);
				pstmt.setTimestamp(4,toDateInTS);	
				rs = pstmt.executeQuery();
				int count = 0;
				while (rs.next())
				{
					rowData = new JSONObject();
				    
					stdTime=Double.parseDouble(checkDouble(rs.getString("STD_TIME")));
					actTime=Double.parseDouble(checkDouble(rs.getString("ACTUAL_TIME")));
					deviation=Math.round(stdTime -  actTime  );
					totDeviation=totDeviation+deviation;
					totStdTime=totStdTime+stdTime;
					totActTime=totActTime+actTime;
					rowData.put("employee", checkNull(rs.getString("EMP_NAME")));
					rowData.put("req_id", checkNull(rs.getString("REQ_ID")));
					rowData.put("descr", checkNull(rs.getString("DTL_DESCR")));
					rowData.put("act_descr", checkNull(rs.getString("ACTION_DETL")));
					rowData.put("est_man_hour", checkNull(rs.getString("STD_TIME")));
					rowData.put("act_man_hour", checkNull(rs.getString("ACTUAL_TIME")));
					rowData.put("deviation", ""+deviation);		
					
					//*Added New code by sachin on 7-Jan-16*/
					 compStat=checkNull(rs.getString("COMP_STAT"));
					/*if(compStat.trim().length()>0)
					{
						if("C".equalsIgnoreCase(compStat))
						{
							compStat="CLOSED";
						}else
						{
							compStat="PENDING";
						}
					}*/
					
					//rowData.put("req_status",checkNull(rs.getString("COMP_STAT")));			
					
						rowData.put("req_status",compStat);
					
					//*Added New code by sachin on 7-Jan-16*/					
					
					String comp_stat_dt=checkNull(rs.getString("comp_stat_dt"));
					
					if(!comp_stat_dt.equals(null) && comp_stat_dt.trim().length()>0)
					{
						rowData.put("dlv_date", simpleDateFormat.format(convertToDbDate.parse(comp_stat_dt)));
					}
					else
					{							
						rowData.put("dlv_date",checkNull(rs.getString("comp_stat_dt")));
					}
					/*if(deviation==0.0)
					{
						onTimeCtr++;
					}
					else if(deviation>0.0)
					{
						posTimeCtr++;
					}
					else if(deviation<0.0)
					{
						negTimeCtr++;
					}
					rowData.put("tot_deviation", "");
					rowData.put("time_lag", "");
					rowData.put("time_lag_descr", "");
					*/
					rowDataEmpReqEffJson.put(Integer.valueOf(count), rowData);
					count++;
				}
				   /* rowData = new JSONObject();
					rowData.put("employee", "");
					rowData.put("req_id", "");
					rowData.put("descr", "");
					rowData.put("act_descr", "");
					rowData.put("est_man_hour", "");
					rowData.put("act_man_hour", "");
					rowData.put("deviation", "");
					rowData.put("tot_deviation", totDeviation);
					rowData.put("tot_descr", "Deviation");
					rowData.put("time_lag", onTimeCtr);
					rowData.put("time_lag_descr", "On Time");
					rowDataEmpReqEffJson.put(Integer.valueOf(count), rowData);
					count++;
					
					rowData = new JSONObject();
					rowData.put("employee", "");
					rowData.put("req_id", "");
					rowData.put("descr", "");
					rowData.put("act_descr", "");
					rowData.put("est_man_hour", "");
					rowData.put("act_man_hour", "");
					rowData.put("deviation", "");
					rowData.put("tot_deviation", totActTime);
					rowData.put("tot_descr", "Actual Man Hour");
					rowData.put("time_lag", posTimeCtr);
					rowData.put("time_lag_descr", "Extra Time");
					rowDataEmpReqEffJson.put(Integer.valueOf(count), rowData);
					count++;
					
					rowData = new JSONObject();
					rowData.put("employee", "");
					rowData.put("req_id", "");
					rowData.put("descr", "");
					rowData.put("act_descr", "");
					rowData.put("est_man_hour", "");
					rowData.put("act_man_hour", "");
					rowData.put("deviation", "");
					rowData.put("tot_deviation", totStdTime);
					rowData.put("tot_descr", "Estimated Man Hour");
					rowData.put("time_lag", negTimeCtr);
					rowData.put("time_lag_descr", "Before Time");
					rowDataEmpReqEffJson.put(Integer.valueOf(count), rowData);*/
			}

		} catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
						rs.close();
					rs = null;
					if (pstmt != null)
						pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in : ManagmentDashboard : getEmpReqEfficiency() :" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return rowDataEmpReqEffJson;
	
	}
	/**** End of getEmpReqEfficiency() Method ***/
	
	/**** Start Of getMissingFDBack() Method
	* Method Name  : getMissingFDBack (String fromDate, String toDate,String empCode,String dataSourceName)
	* Metadata Xml : management.xml
	* Servlet Name : MissingFDBackServlet
	* 
	*******/
	@SuppressWarnings("unchecked")
	@Override
	public JSONObject getMissingFDBack(String fromDate, String toDate,String empCode,String dataSourceName) throws RemoteException, ITMException
	{
		JSONObject rowDataMissingFeedbackJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		Calendar calendar=null;
		Timestamp fromDateInTS= null;
		Timestamp toDateInTS= null;
		List<String> executeDayList= new ArrayList<String>();
		LinkedHashMap<String, List<String> > empMap =   new LinkedHashMap<String, List<String>>();
		List<String> empList= new ArrayList<String>();
		DateFormat originalFormat = new SimpleDateFormat("dd/MM/yy");
		int count=0;
		List<String> valueList=null;
		StringBuilder excDate=null;
		String emp="";
		String empName="";
		SimpleDateFormat simpleDateFormat=null;
		SimpleDateFormat convertToDbDate = null;
		SimpleDateFormat sqlDateFormat  = null;
		try
		{
			conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;
			//comment date
			//simpleDateFormat   = new SimpleDateFormat("dd/MM/yyyy");
			simpleDateFormat   = new SimpleDateFormat( genericUtility.getApplDateFormat());
			convrtToTimStmDate = new SimpleDateFormat( genericUtility.getDBDateFormat());
			convertToDbDate    = new SimpleDateFormat(genericUtility.getDBDateFormat());
			gridDateFormat     = new SimpleDateFormat("dd/MMM");
			sqlDateFormat     = new SimpleDateFormat("dd-MMM-yy");
			System.out.println("In Employee Dashboard Missing FeedBack: "+empCode);
			if((fromDate==null) ||(fromDate.equals("")) && (toDate==null) || (toDate.equals("")))
			{ 				
				simpleDateFormat   = new SimpleDateFormat( genericUtility.getApplDateFormat());
	  			calendar           = Calendar.getInstance();
	  			toDate             = simpleDateFormat.format(calendar.getTime());	
	  			calendar           = Calendar.getInstance();
	  			calendar.add(Calendar.DAY_OF_MONTH, -7);
	  			fromDate           = simpleDateFormat.format(calendar.getTime());
	  			fromDateInTS       = java.sql.Timestamp.valueOf(convertToDbDate.format(simpleDateFormat.parse(fromDate)).toString() + " 00:00:00.0");
	  			toDateInTS         = java.sql.Timestamp.valueOf(convertToDbDate.format(simpleDateFormat.parse(toDate)).toString() + " 00:00:00.0");
			}  	
			else
			{
				/*Comment and change code for date format by Dhanendra on date 16-06-2016*/
				
				//fromDateInTS =java.sql.Timestamp.valueOf(convrtToTimStmDate.format(originalFormat.parse(fromDate)).toString() + " 00:00:00.0");
				//toDateInTS=java.sql.Timestamp.valueOf(convrtToTimStmDate.format(originalFormat.parse(toDate)).toString() + " 00:00:00.0");
				
				fromDateInTS= Timestamp.valueOf(genericUtility.getValidDateString(fromDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat()) + " 00:00:00.0");
				toDateInTS= Timestamp.valueOf(genericUtility.getValidDateString(toDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat()) + " 00:00:00.0");
				
			}
			System.out.println("getMissingFDBack fromDateInTS :"+fromDateInTS+"---- toDateInTS :"+toDateInTS);
			
			if((fromDateInTS!=null && fromDateInTS.toString().length()>0) 
	            	&& (toDateInTS!=null && toDateInTS.toString().length()>0) 
	            	&& (empCode!=null && empCode.trim().length()>0) )
			{
				
				
			//	sql="select  mydate from (SELECT TO_DATE(?, 'DD/MM/YY') - 1 + rownum AS mydate " +" FROM all_objects " +" WHERE TO_DATE(?, 'DD/MM/YY') - 1 + rownum <= TO_DATE(?, 'DD/MM/YY') " +" ) " +" where mydate not in " +" ( " +" select hol_date from holiday where hol_date >= TO_DATE(?, 'DD/MM/YY') " +" and hol_date <= TO_DATE(?, 'DD/MM/YY') " +" )";
				
				/*Start Modify By sachin on 13-Jan-16*/
				
				 sql="select  mydate from (SELECT TO_DATE(?, 'DD/MM/YY') - 1 + rownum AS mydate "
				 +" FROM all_objects " +" WHERE TO_DATE(?, 'DD/MM/YY') - 1 + rownum < TO_DATE(?, 'DD/MM/YY') " +" ) "
				 +" where mydate not in " +" ( " +" select hol_date from holiday where hol_date >= TO_DATE(?, 'DD/MM/YY') "
				 +" and hol_date <= TO_DATE(?, 'DD/MM/YY') " +" )";
				
				 /*End Modify By sachin on 13-Jan-16*/ 
				 
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,fromDate);
				pstmt.setString(2,fromDate);
				pstmt.setString(3,toDate);
				pstmt.setString(4,fromDate);
				pstmt.setString(5,toDate);
				rs = pstmt.executeQuery();
				while (rs.next())
				{
					executeDayList.add(checkNull(rs.getString("mydate")));
				}
				rs.close();
				rs=null;
				pstmt.close();
				pstmt=null;
				
				sql=" select c.emp_fname || ' ' || c.emp_lname || '' emp_name, c.emp_code  emp_code ,b.execut_dt as execut_dt "
						 +" from ser_req_feedbkdtl a, ser_req_feedbk b,    employee c, ser_request  "
						 +" where a.feedbk_id = b.feedbk_id and a.req_id = ser_request.req_id "
						 +" AND B.EMP_CODE = C.EMP_CODE  "
						 +" AND B.EXECUT_DT >= ? "
						 +" AND B.EXECUT_DT < ? "
						 +" and ((c.emp_code in (  select EMP_CODE FROM EMPLOYEE START WITH EMP_CODE = ?  CONNECT BY PRIOR EMP_CODE = REPORT_TO " 
						 +" AND REPORT_TO IS NOT NULL AND   ( RELIEVE_DATE IS NULL OR RELIEVE_DATE >= SYSDATE ) ))OR (c.emp_code = ? ) ) "
						 +" order by emp_name,b.execut_dt ";
				    pstmt = conn.prepareStatement(sql);
				    
				    pstmt.setTimestamp(1, fromDateInTS);
				    pstmt.setTimestamp(2, toDateInTS);
				    pstmt.setString(3,empCode);
					pstmt.setString(4,empCode);
					//pstmt.setTimestamp(2,toDateInTS);
					rs = pstmt.executeQuery();
					while (rs.next())
					{
						 empCode=((checkNull(rs.getString("emp_code"))).trim())+"@"+((checkNull(rs.getString("emp_name"))).trim());
						String exeDate=(checkNull(rs.getString("execut_dt"))).trim();
						if(empMap.containsKey(empCode))
						{
							empList=empMap.get(empCode);
							empList.add(exeDate);
							empMap.put(empCode, empList);
						}
						else 
						{
							empList=new ArrayList<String>();
							empList.add(exeDate);
							empMap.put(empCode, empList);
						}
					}
					rs.close();
					rs=null;
					pstmt.close();
					pstmt=null;
					
					System.out.println("empMap in missing feedback : "+empMap);
					for (String empCodeName : empMap.keySet())
					{
						
						System.out.println("empCodeName is= : "+empCodeName);
						int cnt=0;
						excDate=new StringBuilder();
						valueList = new ArrayList<String>();
						valueList = empMap.get(empCodeName);
						rowData = new JSONObject();
						String[] temp = empCodeName.split("@");
						emp= temp[0];
						empName= temp[1];
						for(int keyCtr=0;keyCtr<executeDayList.size();keyCtr++)
						{
							if(!valueList.contains(executeDayList.get(keyCtr)))
							{
								
								/*Start - Commnent code beacause add in condition by Dhanendra on date 08-07-2016*/
								/*cnt++;
								if(excDate.length()==0)
								{
									excDate.append(gridDateFormat.format(convrtToTimStmDate.parse(executeDayList.get(keyCtr))));
								}
								else
								{
									excDate.append("; "+gridDateFormat.format(convrtToTimStmDate.parse(executeDayList.get(keyCtr))));
								}*/
								/*End - Commnent code beacause add in condition by Dhanendra on date 08-07-2016*/
								
								/*Add code emp is present by Dhanendra as per manohar sir observation on date 08-07-2016*/
								int presentCnt = 0;
								String attdDate = sqlDateFormat.format(convrtToTimStmDate.parse(executeDayList.get(keyCtr)));
								sql = "select count(1) as presentCnt from attendance_day where emp_code = ? and attd_date  = ? and in_time <> '00:00' and out_time <> '00:00'";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1,emp);
								pstmt.setString(2,attdDate);
								
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									presentCnt = rs.getInt("presentCnt");
								}
								rs.close();
								rs=null;
								pstmt.close();
								pstmt=null;
								
								if(presentCnt == 1)
								{
									cnt++;
									
									if(excDate.length()==0)
									{
										excDate.append(gridDateFormat.format(convrtToTimStmDate.parse(executeDayList.get(keyCtr))));
									}
									else
									{
										excDate.append("; "+gridDateFormat.format(convrtToTimStmDate.parse(executeDayList.get(keyCtr))));
									}
								}
								/*End code emp is present by Dhanendra as per manohar sir observation on date 08-07-2016*/
							}
						}
						rowData.put("emp_code", emp);
						rowData.put("emp_name", empName);
						rowData.put("missing_count",""+cnt );
						rowData.put("missing_date",excDate.toString() );
						/* Start Modify Code by sachin on 14-JAN-16*/
						if(cnt>0)
						{
						rowDataMissingFeedbackJson.put(count, rowData);
						count++;
						}
						
						/* End Modify Code by sachin on 14-JAN-16*/
					}
					System.out.println("rowDataMissingFeedbackJson in missing feedback: "+rowDataMissingFeedbackJson);
			}

		} catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
						rs.close();
					rs = null;
					if (pstmt != null)
						pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in : EmployeeDashboard : getEmpMissingFDBack() :" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return rowDataMissingFeedbackJson;
	}
	/**** End of getEmpMissingFDBack() Method ***/
	
	/**** Start Of getReqEfficiencySummaryPie() Method
	* Method Name  : getReqEfficiencySummaryPie (String dataSourceName, String empCode, String fromDate, String toDate)
	* Metadata Xml : management.xml
	* Servlet Name : ReqEfficiencySummaryPieChartServlet
	* 
	*******/
	/*Added by swati for Pie chart Deviation on date : 30 Dec 2015*/
	@SuppressWarnings("unchecked")
	@Override
	public JSONObject getReqEfficiencySummaryPie(String dataSourceName, String empCode, String fromDate, String toDate) throws RemoteException, ITMException
	{
		JSONObject rowDataEmpReqEffJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		Timestamp fromDateInTS=null;
		Timestamp toDateInTS=null;
		double deviation=0.0,stdTime=0.0,actTime=0.0;
		double totDeviation=0.0,totStdTime=0.0,totActTime=0.0;
		int   onTimeCtr=0,posTimeCtr=0,negTimeCtr=0;
		SimpleDateFormat	simpleDateFormat = null;
		SimpleDateFormat    convertToDbDate=null;
		Calendar calendar=null;
		DashboardUtility dashboardUtility=null;
		try
		{
			conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;
			convertToDbDate   = new SimpleDateFormat(genericUtility.getDBDateFormat());
			dashboardUtility  = new DashboardUtility();
			empCode=dashboardUtility.getCommaSeparated(empCode);
			simpleDateFormat  = new SimpleDateFormat( genericUtility.getApplDateFormat());
			
			if((fromDate==null) ||(fromDate.equals("")) && (toDate==null) || (toDate.equals("")))
			{ 				
	  			calendar         = Calendar.getInstance();
	  			toDate           = simpleDateFormat.format(calendar.getTime());	
	  			calendar         = Calendar.getInstance();
	  			calendar.add(Calendar.DAY_OF_MONTH, -7);
	  			fromDate         = simpleDateFormat.format(calendar.getTime());
	  			fromDateInTS     = java.sql.Timestamp.valueOf(convertToDbDate.format(simpleDateFormat.parse(fromDate)).toString() + " 00:00:00.0");
	  			toDateInTS       = java.sql.Timestamp.valueOf(convertToDbDate.format(simpleDateFormat.parse(toDate)).toString() + " 00:00:00.0");
			}  	 
			else
			{
				/*Comment and change code for date format by Dhanendra on date 16-06-2016*/
				
				/*fromDateInTS = java.sql.Timestamp.valueOf(convertToDbDate.format(simpleDateFormat.parse(fromDate)).toString() + " 00:00:00.0");
				toDateInTS   = java.sql.Timestamp.valueOf(convertToDbDate.format(simpleDateFormat.parse(toDate)).toString() + " 00:00:00.0");
				fromDateInTS     = java.sql.Timestamp.valueOf(convertToDbDate.format(simpleDateFormat.parse(fromDate)).toString() + " 00:00:00.0");
				toDateInTS       = java.sql.Timestamp.valueOf(convertToDbDate.format(simpleDateFormat.parse(toDate)).toString() + " 00:00:00.0");*/
				fromDateInTS= Timestamp.valueOf(genericUtility.getValidDateString(fromDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat()) + " 00:00:00.0");
				toDateInTS= Timestamp.valueOf(genericUtility.getValidDateString(toDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat()) + " 00:00:00.0");
				
			}
			System.out.println("getReqEfficiencySummaryPie fromDateInTS :"+fromDateInTS+"---- toDateInTS :"+toDateInTS);
			
			if((fromDateInTS!=null && fromDateInTS.toString().length()>0) && (toDateInTS!=null && toDateInTS.toString().length()>0) 
	            	&& (empCode!=null && empCode.trim().length()>0) )
			{
				
				
				/* sql =    " SELECT  r.comp_stat_dt,r.COMP_STAT,R.REQ_ID,R.DTL_DESCR, AD.ACTION_DETL, E.EMP_FNAME || ' ' || E.EMP_LNAME EMP_NAME, "
	                      +" AD.STD_TIME as STD_TIME ,max((SELECT FN_FEEDBK_TIME(SUM(FD.TIME_SPENT)) FROM SER_REQ_FEEDBKDTL FD, "
	                      +" SER_REQ_FEEDBK FH WHERE FD.FEEDBK_ID = FH.FEEDBK_ID AND FH.REQ_ID = R.REQ_ID "
	                      +" AND  FD.ACTION_ID = AD.ACTION_ID "
	                      +" AND FD.ACTION_CODE = AD.ACTION_CODE and fh.emp_code = e.emp_code )) ACTUAL_TIME "
	                      +" from ser_request r, ser_req_act ah, ser_req_act_detl ad, employee e "
	                      +" where ah.action_id = ad.action_id "
	                      +" and ah.req_id = r.req_id "
	                      +" AND E.EMP_CODE =  ad.EMP_CODE  AND r.comp_stat ='C'"
	                      +" and r.comp_stat_dt >= ? and r.comp_stat_dt <= ?  "//--?
	                      +" AND ((ad.emp_code in (select emp_code FROM EMPLOYEE START WITH EMP_CODE = "+empCode+"  "     
	                      +" CONNECT BY PRIOR EMP_CODE = REPORT_TO AND REPORT_TO IS NOT NULL "
	                      +" AND  ( RELIEVE_DATE IS NULL OR RELIEVE_DATE >= SYSDATE ))) OR (ad.emp_code ="+empCode+"))  "
	                      +" group by r.req_id,r.dtl_descr, ad.action_detl, r.COMP_STAT,e.emp_fname || ' ' || e.emp_lname,  ad.STD_TIME ,r.comp_stat_dt  " +
	                      " order by r.comp_stat_dt desc ";
			*/	 
				 
				 /* [START] Modify SQL By sachin on 20-Jan-15 for Adding Ticket Condition*/
				sql=" SELECT comp_stat_dt ,COMP_STAT ,REQ_ID ,DTL_DESCR ,ACTION_DETL ,EMP_NAME ,STD_TIME ,ACTUAL_TIME FROM" +
						" ( SELECT r.comp_stat_dt ,r.COMP_STAT ,R.REQ_ID ,R.DTL_DESCR ,AD.ACTION_DETL ,E.EMP_FNAME || ' ' || E.EMP_LNAME EMP_NAME ," +
						" AD.STD_TIME AS STD_TIME ,max(( SELECT FN_FEEDBK_TIME(SUM(FD.TIME_SPENT)) FROM SER_REQ_FEEDBKDTL FD ,SER_REQ_FEEDBK FH WHERE" +
						" FD.FEEDBK_ID = FH.FEEDBK_ID AND FH.REQ_ID = R.REQ_ID AND FD.ACTION_ID = AD.ACTION_ID AND FD.ACTION_CODE = AD.ACTION_CODE AND " +
						" fh.emp_code = e.emp_code )) ACTUAL_TIME FROM ser_request r ,ser_req_act ah ,ser_req_act_detl ad ,employee e " +
						" WHERE ah.action_id = ad.action_id AND ah.req_id = r.req_id AND E.EMP_CODE = ad.EMP_CODE AND r.comp_stat = 'C' " +
						" and r.req_id <>'9999999999' AND r.ITEM_SER <>'TRG' AND r.comp_stat_dt >= ? AND r.comp_stat_dt <= ? " +
						" AND ( ( ad.emp_code IN ( SELECT emp_code FROM EMPLOYEE START WITH EMP_CODE = "+empCode+" CONNECT BY PRIOR " +
						" EMP_CODE = REPORT_TO AND REPORT_TO IS NOT NULL AND ( RELIEVE_DATE IS NULL OR RELIEVE_DATE >= SYSDATE ) ) ) " +
						" OR (ad.emp_code = "+empCode+") ) GROUP BY r.comp_stat_dt ,r.COMP_STAT ,R.REQ_ID ,R.DTL_DESCR ,AD.ACTION_DETL ," +
						" E.EMP_FNAME || ' ' || E.EMP_LNAME ,AD.STD_TIME UNION ALL SELECT r.resolve_date3 AS comp_stat_dt ," +
						" r.STATUS AS COMP_STAT ,R.ticket_no AS REQ_ID ,r.ticket_Detail AS DTL_DESCR ,AD.ACTION_DETL ACTION_DETL ,E.EMP_FNAME || ' ' || E.EMP_LNAME AS EMP_NAME ," +
						" AD.STD_TIME AS STD_TIME ,max(( SELECT FN_FEEDBK_TIME(SUM(FD.TIME_SPENT)) FROM SER_REQ_FEEDBKDTL FD ,SER_REQ_FEEDBK FH " +
						" WHERE FD.FEEDBK_ID = FH.FEEDBK_ID AND FH.ticket_no = r.ticket_no AND FD.ACTION_ID = AD.ACTION_ID AND FD.ACTION_CODE = AD.ACTION_CODE" +
						" AND fh.emp_code = e.emp_code )) ACTUAL_TIME FROM service_complaint r ,ser_req_act ah ,ser_req_act_detl ad ,employee e WHERE ah.action_id = ad.action_id " +
						" AND ah.ticket_no = r.ticket_no AND E.EMP_CODE = ad.EMP_CODE AND r.STATUS = 'C' AND r.resolve_date3 >= ? AND r.resolve_date3 <= ? " +
						" AND ( ( ad.emp_code IN ( SELECT emp_code FROM EMPLOYEE START WITH EMP_CODE = "+empCode+" CONNECT BY PRIOR EMP_CODE = REPORT_TO AND REPORT_TO IS NOT NULL " +
						" AND ( RELIEVE_DATE IS NULL OR RELIEVE_DATE >= SYSDATE ) ) ) OR (ad.emp_code = "+empCode+") ) GROUP BY r.resolve_date3 ,r.STATUS ,R.ticket_no ,r.ticket_Detail ," +
						" AD.ACTION_DETL ,E.EMP_FNAME || ' ' || E.EMP_LNAME ,AD.STD_TIME ) ORDER BY comp_stat_dt DESC";
							 
			
			/*[END] Modify SQL By sachin on 20-Jan-15 for Adding Ticket Condition*/
				pstmt = conn.prepareStatement(sql);
				pstmt.setTimestamp(1,fromDateInTS);
				pstmt.setTimestamp(2,toDateInTS);	
				pstmt.setTimestamp(3,fromDateInTS);
				pstmt.setTimestamp(4,toDateInTS);	
				rs = pstmt.executeQuery();
				int count = 0;
				while (rs.next())
				{
					rowData = new JSONObject();
				    
					stdTime=Double.parseDouble(checkDouble(rs.getString("STD_TIME")));
					actTime=Double.parseDouble(checkDouble(rs.getString("ACTUAL_TIME")));
					deviation=Math.round(stdTime -  actTime  );
					totDeviation=totDeviation+deviation;
					totStdTime=totStdTime+stdTime;
					totActTime=totActTime+actTime;
				
					if(deviation==0.0)
					{
						onTimeCtr++;
					}
					else if(deviation>0.0)
					{
						posTimeCtr++;
					}
					else if(deviation<0.0)
					{
						negTimeCtr++;
					}
				}
				    
					if(totDeviation == 0 && totStdTime == 0 && totActTime == 0)
					{
						
					}
					else
					{
						rowData = new JSONObject();
					    rowData.put("tot_deviation", totDeviation);
						rowData.put("tot_descr", "Deviation");
						rowData.put("time_lag", onTimeCtr);
						rowData.put("time_lag_descr", "On Time");
						rowDataEmpReqEffJson.put(Integer.valueOf(count), rowData);
						count++;
						
						rowData = new JSONObject();
						rowData.put("tot_deviation", totActTime);
						rowData.put("tot_descr", "Actual Man Hour");
						rowData.put("time_lag",negTimeCtr );
						rowData.put("time_lag_descr", "Extra Time");
						rowDataEmpReqEffJson.put(Integer.valueOf(count), rowData);
						count++;
						
						rowData = new JSONObject();			
						rowData.put("tot_deviation", totStdTime);
						rowData.put("tot_descr", "Estimated Man Hour");
						rowData.put("time_lag", posTimeCtr);
						rowData.put("time_lag_descr", "Before Time");
						rowDataEmpReqEffJson.put(Integer.valueOf(count), rowData);
					}
			}

		} catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
						rs.close();
					rs = null;
					if (pstmt != null)
						pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in : ManagmentDashboard : getReqEfficiencySummaryPie() :" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return rowDataEmpReqEffJson;
	}
	/*Ended by swati for Pie chart Deviation on date : 30 Dec 2015*/
	/**** End of getReqEfficiencySummaryPie() Method ***/
	
	private String checkDouble(String str)
	{
		if (str == null)
		{
			return "0.0";
		} else
		{
			return str;
		}

	}

}