/**
 *  Purpose:Create transaction  screen Pallet Request, Request ID:  W15GSUN001
 *  Purpose:Create Pallet Request with stock details ,Request ID: W15HSUN003
 *  Normal Pallet         :Item_ser__rg1::other than 'FS',Location Group::other than Exempted,QC status::not in QC
 *  Pallet with suffix 'Q':Item_ser__rg1::other than 'FS',Location Group::other than Exempted,QC status::pending in QC
 *  Pallet with suffix 'X':Item_ser__rg1::other than 'FS',Location Group::Exempted           ,QC status::not in QC
 *  Pallet with suffix 'M':Item_ser__rg1::other than 'FS',Location Group::Exempted           ,QC status::pending in QC
 *  Pallet with suffix 'B':Item_ser__rg1::'FS'           ,Location Group::other than Exempted,QC status::not in QC
 *  Pallet with suffix 'S':Item_ser__rg1::'FS'           ,Location Group::other than Exempted,QC status::pending in QC
 *  Pallet with suffix 'P':Item_ser__rg1::'FS'           ,Location Group::Exempted           ,QC status::not in QC
 *  Pallet with suffix 'U':Item_ser__rg1::'FS'           ,Location Group::Exempted           ,QC status::pending in QC
 *  Pallet with suffix 'R':Rejected Pallet     
 */

package ibase.webitm.ejb.wms;

import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.wms.CommonWmsUtil;
import java.io.PrintStream;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ejb.Stateless;

@Stateless
public class PalletReqConf extends ActionHandlerEJB
implements PalletReqConfLocal, PalletReqConfRemote
{
	String loginEmpCode = "";
	String confDateStr = "";
	E12GenericUtility genericUtility = new E12GenericUtility();

	public String confirm(String tranID, String xtraParams, String forcedFlag)
	throws RemoteException, ITMException
	{
		String retString = "";
		Connection conn = null;
		//Commented by Santosh on 14-06-2016
		//ConnDriver connDriver = new ConnDriver();
		boolean isConn = true;
		try
		{
			//Changed and Commented By Santosh on 14-06-2016 :[START]
			//conn = connDriver.getConnectDB("DriverITM");
			conn = getConnection();
			//conn.setAutoCommit(false);
			//connDriver = null;
			//Changed and Commented By Santosh on 14-06-2016 :[END]
			retString = confirm(tranID, xtraParams, forcedFlag, conn, isConn);

			if ((retString == null) && (retString.length() < 0))
			{
				throw new Exception("Exception while calling confirm for tran  Id:[" + tranID + "]");
			}
		}
		catch (Exception exception)
		{
			System.out.println("Exception in [PalletReqConf]  " + exception.getMessage());
		}
		return retString;
	}

	public String confirm(String tranId, String xtraParams, String forcedFlag, Connection conn, boolean conStat) throws RemoteException, ITMException
	{
		System.out.println("PalletReqConf Called........");

		boolean isError = false;
		String confirmed = "";
		String sql = "";
		ResultSet rs = null; ResultSet rs1 = null;
		PreparedStatement pstmt = null; PreparedStatement pstmt1 = null;
		String errString = ""; Timestamp tranDate = null;
		String palletNo = ""; String palletStatus = "F";
		String lineNo = ""; String itemCode = ""; String lotNo = ""; String lotSl = ""; String noArt = ""; String quantity = "";
		String empCodeAprv = ""; String siteCode = "";
		String loginSite = ""; String qtyPerArt = ""; String refSer = "PRS";
		String descr = "",unit = "",itemType = "",mfgDate = "", expiryDate = "",tranType="",sqlDetails="";
		ArrayList palletList = new ArrayList();
		ArrayList lineList = new ArrayList();
		int cntPal = 0;
		ITMDBAccessEJB itmdbAccess = new ITMDBAccessEJB();
		ArrayList interfaceArrList = new ArrayList();
		Timestamp today = new Timestamp(System.currentTimeMillis());
		CommonWmsUtil commonWmsUtility = CommonWmsUtil.getInstance();
		try
		{
			System.out.println(" tranId [" + tranId + "]");
			System.out.println(" force flag [" + forcedFlag + "]");
			System.out.println(" xtraParams --> [" + xtraParams + "]");

			empCodeAprv = this.genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode");
			siteCode = this.genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSite");
			System.out.println(" site code [" + siteCode + "]");
			SimpleDateFormat sdf = new SimpleDateFormat(this.genericUtility.getDBDateTimeFormat());
			java.util.Date confDate = new java.util.Date();
			this.confDateStr = sdf.format(confDate);

			sql = "SELECT CONFIRMED FROM PALLET_REQ_HDR WHERE TRAN_ID=?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				confirmed = checkNullAndTrim(rs.getString("CONFIRMED"));
				System.out.println("CONFIRMED >>>>>>>" + confirmed);
			}
			rs.close();
			pstmt.close();
			String str1;
			if ((confirmed != null) && (confirmed.equalsIgnoreCase("Y")))
			{
				System.out.println("error" + errString);
				errString = itmdbAccess.getErrorString("", "VMTRANSCOF", "", "", 
						conn);
				str1 = errString;
				int count;
				return str1;
			}

			sql = "SELECT COUNT(1) FROM PALLET_REQ_DET WHERE TRAN_ID=?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				cntPal = rs.getInt(1);
				System.out.println("pallet_count---" + cntPal);
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if (cntPal == 0)
			{
				System.out.println("palletno cannot be blank for confirm");
				errString = itmdbAccess.getErrorString("", "VMPALLETCF", "", "", conn);
				str1 = errString;
				int count;
				return str1;
			}
			sql = "UPDATE  PALLET_REQ_HDR SET CONFIRMED=? ,CONF_DATE=? ,EMP_CODE__APRV=? WHERE TRAN_ID=?";
			System.out.println("pallet_req_hdr [" + this.confDateStr + "]");
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, "Y");
			pstmt.setDate(2, new java.sql.Date(System.currentTimeMillis()));
			pstmt.setString(3, empCodeAprv);
			pstmt.setString(4, tranId);
			int count = pstmt.executeUpdate();
			if (count > 0)
			{
				System.out.println(" count --> [" + count + "]");
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}

			sql = "SELECT D.PALLET_NO ,D.LINE_NO,D.ITEM_CODE,D.LOT_NO,D.LOT_SL,D.NO_ART,D.QUANTITY ,H.TRAN_TYPE FROM PALLET_REQ_DET D ,PALLET_REQ_HDR H WHERE D.TRAN_ID = H.TRAN_ID AND D.TRAN_ID=?";

			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			while (rs.next())
			{
				palletNo = checkNullAndTrim(rs.getString("PALLET_NO"));
				itemCode = checkNullAndTrim(rs.getString("ITEM_CODE"));
				lotNo = checkNullAndTrim(rs.getString("LOT_NO"));
				lotSl = checkNullAndTrim(rs.getString("LOT_SL"));
				noArt = checkNullAndTrim(rs.getString("NO_ART"));
				quantity = checkNullAndTrim(rs.getString("QUANTITY"));
				lineNo = checkNullAndTrim(rs.getString("LINE_NO"));
				tranType=checkNullAndTrim(rs.getString("TRAN_TYPE"));

				System.out.println("Tran Type="+tranType);
				sqlDetails = "SELECT S.QTY_PER_ART,I.DESCR ,S.UNIT,I.ITEM_TYPE ,S.MFG_DATE,S.EXP_DATE FROM STOCK S ,ITEM I WHERE S.SITE_CODE=? AND S.LOC_CODE IN (?,?,?,?,?,?,?,?,?) AND S.ITEM_CODE= ? AND S.LOT_NO= ? AND S.LOT_SL= ? AND S.ITEM_CODE=I.ITEM_CODE AND S.QUANTITY>0";

				pstmt1 = conn.prepareStatement(sqlDetails);
				pstmt1.setString(1, siteCode);
				pstmt1.setString(2, palletNo);
				pstmt1.setString(3, palletNo + "Q");
				pstmt1.setString(4, palletNo + "B");
				pstmt1.setString(5, palletNo + "X");
				pstmt1.setString(6, palletNo + "M");
				pstmt1.setString(7, palletNo + "U");
				pstmt1.setString(8, palletNo + "P");
				pstmt1.setString(9, palletNo + "S");
				//Changed by Jagruti Shinde,for considering QC rejected locations in Pallet out.Request id:[W16ASUN022][start]
				pstmt1.setString(10, palletNo + "R");
				pstmt1.setString(11, itemCode);
				pstmt1.setString(12, lotNo);
				pstmt1.setString(13, lotSl);
				//Changed by Jagruti Shinde,for considering QC rejected locations in Pallet out.Request id:[W16ASUN022][end]

				rs1 = pstmt1.executeQuery();
				if (rs1.next())
				{
					qtyPerArt = checkNullAndTrim(rs1.getString("QTY_PER_ART"));
					descr = checkNullAndTrim(rs1.getString("DESCR"));
					unit = checkNullAndTrim(rs1.getString("UNIT"));
					itemType = checkNullAndTrim(rs1.getString("ITEM_TYPE"));
					mfgDate = checkNullAndTrim(rs1.getString("MFG_DATE"));
					expiryDate = checkNullAndTrim(rs1.getString("EXP_DATE"));
					palletStatus = CommonWmsUtil.getFullOrPrtialPalletOut(palletNo, refSer, tranId, siteCode, conn);
					System.out.println("palletStatus for PRS" + palletStatus);
				}
				rs1.close();
				pstmt1.close();
				if("O".equalsIgnoreCase(tranType))
				{
					System.out.println("Trantype:::O");
					if ((itemCode != null) && (itemCode.length() > 0))
					{
						HashMap hm = new HashMap();
						hm.put("ITEM_CODE", itemCode);
						hm.put("REF_ID", tranId);
						hm.put("REF_SER", refSer);
						hm.put("TRAN_DATE", checkNullAndTrim(String.valueOf(today)));
						hm.put("QTY_PER_ART", qtyPerArt);
						hm.put("LOT_NO", lotNo);
						hm.put("LOT_SL", lotSl);
						hm.put("QUANTITY", noArt);
						hm.put("TOTAL_QTY", quantity);
						hm.put("PALLET_NO", palletNo);
						hm.put("LINE_NO", lineNo);
						hm.put("DESCR", descr);
						hm.put("UNIT", unit);
						hm.put("ITEM_TYPE", itemType);
						hm.put("FAMILY_GRP", "");
						hm.put("TRAN_ID", "");
						hm.put("IN_OUT", "O");
						hm.put("EXP_DATE", expiryDate);
						hm.put("MFG_DATE", mfgDate);
						hm.put("PALLET_STATUS", palletStatus);
						hm.put("MSG_STAT", "N");
						hm.put("LOCK_STAT", "");
						hm.put("ERR_COD", "");
						hm.put("ERR_DESC", "");
						hm.put("QC_TYPE", "");
						hm.put("TRANS_DT_ACK", "");
						hm.put("STRO_PREF", "");

						interfaceArrList.add(hm);
						System.out.println("interfacearraylist::PRS" + interfaceArrList.size());
						//}
						/*rs1.close();
						pstmt1.close();*/
					}
					else
					{
						HashMap hm = new HashMap();
						hm.put("REF_ID", tranId);
						hm.put("REF_SER", "PR");
						hm.put("TRAN_DATE", checkNullAndTrim(String.valueOf(today)));
						hm.put("PALLET_NO", palletNo);
						hm.put("LINE_NO", lineNo);
						hm.put("DESCR", "");
						hm.put("UNIT", "");
						hm.put("ITEM_TYPE", "");
						hm.put("FAMILY_GRP", "");
						hm.put("TRAN_ID", "");
						hm.put("IN_OUT", "O");
						hm.put("EXP_DATE", "");
						hm.put("MFG_DATE", "");
						hm.put("PALLET_STATUS", palletStatus);
						hm.put("MSG_STAT", "N");
						hm.put("LOCK_STAT", "");
						hm.put("ERR_COD", "");
						hm.put("ERR_DESC", "");
						hm.put("QC_TYPE", "");
						hm.put("TRANS_DT_ACK", "");
						hm.put("STRO_PREF", "");

						interfaceArrList.add(hm);
						System.out.println("interfacearraylist::PR" + interfaceArrList.size());
					}
				}
				else
				{
					System.out.println(" in  rpz trantype");
					HashMap hm = new HashMap();
					hm.put("REF_ID", tranId);
					hm.put("REF_SER", "RPZ");
					hm.put("TRAN_DATE", checkNullAndTrim(String.valueOf(today)));
					hm.put("PALLET_NO", palletNo);
					hm.put("LINE_NO", lineNo);
					hm.put("DESCR", "");
					hm.put("UNIT", "");
					hm.put("ITEM_TYPE", "");
					hm.put("FAMILY_GRP", "");
					hm.put("TRAN_ID", "");
					hm.put("IN_OUT", "R");
					hm.put("EXP_DATE", "");
					hm.put("MFG_DATE", "");
					hm.put("PALLET_STATUS", palletStatus);
					hm.put("MSG_STAT", "N");
					hm.put("LOCK_STAT", "");
					hm.put("ERR_COD", "");
					hm.put("ERR_DESC", "");
					hm.put("QC_TYPE", "");
					hm.put("TRANS_DT_ACK", "");
					hm.put("STRO_PREF", "");

					interfaceArrList.add(hm);
					System.out.println("interfacearraylist::RPZ" + interfaceArrList.size());
				}
				/*rs1.close();
				pstmt1.close();*/
				//}
			}
			rs.close();
			pstmt.close();
			commonWmsUtility.updateAwmsInterface(interfaceArrList, siteCode, conn);

			System.out.println("Inserted into SWMS TO AWMS table ::::::::: ");
		}
		catch (Exception e)
		{
			isError = true;
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				System.out.println("is error in finally" + isError);
				System.out.println("Connection status in finally"+conStat);//Changed by wasim on 22-04-2016 to use boolean connection status
				if (isError)
				{
					conn.rollback();
				}
				else
				{
					if(conStat != false)//Changed by wasim on 22-04-2016 to use boolean connection status
					{	
						conn.commit();
					}
					errString = itmdbAccess.getErrorString("", "VMTRANSACN", "", "", conn);
				}
				if(conStat != false)//Changed by wasim on 22-04-2016 to use boolean connection status
				{	
					if (conn != null)
					{
						conn.close();
						conn = null;
					}
				}	
			}
			catch (Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}

		return errString;
	}

	private String checkNullAndTrim(String inputVal)
	{
		if (inputVal == null)
		{
			inputVal = "";
		}
		else
		{
			inputVal = inputVal.trim();
		}
		return inputVal;
	}
}