/*
 * Author: Wasim Ansari
 * Date: 02-MAY-2016
 * Request: F17BBAS001 (GST Wizard)
 */

package ibase.webitm.ejb.gst;

import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.ejb.dis.DistUtility;
import ibase.webitm.utility.ITMException;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Map;

import javax.ejb.Stateless;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless
public class GSTRecoWizEJB extends ValidatorEJB implements GSTRecoWizEJBLocal, GSTRecoWizEJBRemote
{
	E12GenericUtility genericUtility = new E12GenericUtility();
	DistCommon distCommon = new DistCommon();
	ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();

    public GSTRecoWizEJB() {
        // TODO Auto-generated constructor stub
    }
    
	@Override
	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException 
	{
		String errString = "";
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		
		try
		{
			System.out.println("@@@ wfvalData \n xmlString : ["+ xmlString+ "] \n xmlString1 : ["+ xmlString1 +"] \n xmlString2 : ["+ xmlString2 +"] "
							+ "\n objContext["+objContext+"] \n editFlag["+editFlag+"] \n xtraParams["+xtraParams+"]");
			
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString); 
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1); 
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2); 
			}
			
			errString = wfValData(dom,dom1,dom2,objContext,editFlag,xtraParams);
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		
		return(errString);
	}
	
	
	@Override
	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams)throws RemoteException, ITMException 
	{
		NodeList parentNodeList = null;
		NodeList childNodeList = null;	
		Node parentNode = null;
		Node childNode = null;
		String childNodeName = null;
		String userId = "";
		String errCode = "";
		String errorType = "";
		String errString = "";
		int ctr=0;
		int childNodeListLength;
		int currentFormNo = 0;
		long cnt = 0;
		ArrayList<String> errList = new ArrayList<String>();
		ArrayList<String> errFields = new ArrayList<String>();
		Connection conn = null;
		PreparedStatement pstmt = null ;
		ResultSet rs = null;
		boolean flag = false;
		
		String sql = "",columnValue = "",prdCode = "",gstin = "";
		int count = 0;
		
		StringBuffer errStringXml = new StringBuffer("<?xml version = \"1.0\"?> \r\n <Root> <Errors>"); 
		try
		{
			conn = getConnection();
			
			if(objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			
			switch(currentFormNo)
			{
				case 1:
				{
					prdCode = checkNullAndTrim(genericUtility.getColumnValue("prd_code", dom));
					gstin = checkNullAndTrim(genericUtility.getColumnValue("gstin", dom));
					
					if(prdCode.length() == 0)
					{
						errString =  itmDBAccessEJB.getErrorString("","VMPRDCD","","",conn);
						return errString;
					}
					else
					{	
						//sql = " SELECT COUNT(*) FROM PERIOD WHERE CODE = ? ";
						sql = " SELECT COUNT(*) AS CNT FROM PERIOD WHERE TO_CHAR(TO_DATE(code,'yyyymm'),'mmyyyy') = ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, prdCode);
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							count = rs.getInt(1);
						}
						if (rs != null) 
						{					
							rs.close();rs = null;
						}
						if (pstmt != null ) 
						{					
							pstmt.close();pstmt = null;
						}
						
						if(count == 0)
						{
							errString =  itmDBAccessEJB.getErrorString("","VMPRDNTDF","","",conn);
							return errString;
						}
					}
					
					if(gstin.length() == 0)
					{
						errString =  itmDBAccessEJB.getErrorString("","VTNLGSTIN","","",conn);
						return errString;
					}
					
					count = 0;
					//sql = " SELECT COUNT(*) FROM GST_DATA_HDR WHERE TAX_REG_NO = ? AND PRD_CODE = ? ";
					sql = " SELECT COUNT(*) FROM GST_DATA_HDR WHERE TAX_REG_NO = ? AND PRD_CODE = ? AND SUBMISSION_TYPE = 'P' AND REC_TYPE = '2' AND RECO_STATUS ! = 'M' ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, gstin);
					pstmt.setString(2, prdCode);
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						count = rs.getInt(1);
					}
					if (rs != null) 
					{					
						rs.close();rs = null;
					}
					if (pstmt != null ) 
					{					
						pstmt.close();pstmt = null;
					}
					
					if(count == 0)
					{
						errString =  itmDBAccessEJB.getErrorString("","VTRECGSTIN","","",conn);
						return errString;
					}
					
				}//End case1
				break;
			}
			
			int errListSize = errList.size();
			cnt = 0;
			String errFldName = null;
			if(errList != null && errListSize > 0)
			{
				for(cnt = 0; cnt < errListSize; cnt ++)
				{
					errCode = errList.get((int) cnt);
					errFldName = errFields.get((int) cnt);
					errString = getErrorString(errFldName, errCode, userId);
					errorType =  errorType(conn , errCode);
					if(errString.length() > 0)
					{
						String bifurErrString = errString.substring(errString.indexOf("<Errors>") + 8, errString.indexOf("<trace>"));
						bifurErrString = bifurErrString + errString.substring(errString.indexOf("</trace>") + 8, errString.indexOf("</Errors>"));
						errStringXml.append(bifurErrString);
						errString = "";
					}
					if(errorType.equalsIgnoreCase("E"))
					{
						break;
					}
				}
				errList.clear();
				errList = null;
				errFields.clear();
				errFields = null;
				errStringXml.append("</Errors> </Root> \r\n");
			}
			
			else
			{
				errStringXml = new StringBuffer("");
			}
		}// End of try
		catch(Exception e)
		{
			System.out.println("Exception: wfValData GSTWizardEJB: ==>\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs != null) 
				{
					rs.close();rs = null;
				}
				if(pstmt != null) 
				{
					pstmt.close();pstmt = null;
				}
				if(conn != null) 
				{
					conn.close();conn = null;
				}
			} 
			catch(Exception d)
			{
				d.printStackTrace();
				throw new ITMException(d);
			}
		}
		errString = errStringXml.toString();
		return errString;
	}
	
	/**
	 * select error description from MESSAGES
	 * @param conn
	 * @param errorCode
	 * @return
	 */
	private String errorType(Connection conn , String errorCode)
	{
		String msgType = "";
		PreparedStatement pstmt = null ; 
		ResultSet rs = null;
		try
		{			
			String sql = "SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO = ?";
			pstmt = conn.prepareStatement(sql);			
			pstmt.setString(1,errorCode);			
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				msgType = rs.getString("MSG_TYPE");
			}			
		}
		catch(Exception ex)
		{
			ex.printStackTrace();
		}		
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}		
		return msgType;
	}

	public  String getError(String message,String Code, Connection conn)  throws ITMException, Exception
	{
		String mainStr ="";

		try
		{
			String errString = "";
			errString =  new ITMDBAccessEJB().getErrorString("",Code,"","",conn);
			
			String begPart = errString.substring(0,errString.indexOf("</description>"));
			String endDesc = errString.substring(errString.indexOf("</description>"),errString.length());
		
			mainStr = begPart + message + endDesc;
			begPart = null;
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		return mainStr;
	}
	
	@Override
	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException 
	{
		Document dom1 = null;
		Document dom = null;
		Document dom2 = null;
		String valueXmlString = "";
		
		try
		{
			System.out.println("@@@Item Change \n xmlString : ["+ xmlString+ "] \n xmlString1 : ["+ xmlString1 +"] \n xmlString2 : ["+ xmlString2 +"] "
					+ "\n objContext["+objContext+"] \n editFlag["+editFlag+"] \n xtraParams["+xtraParams+"]");
			
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString); 
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1); 
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2); 
			}
			
			valueXmlString = itemChanged(dom,dom1,dom2,objContext,currentColumn,editFlag,xtraParams);
		}
		catch(Exception e)
		{
			valueXmlString = genericUtility.createErrorString(e);
		}
		
		return (valueXmlString);
	}
	
	
	
	@Override
	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException 
	{
		Connection conn = null;
		PreparedStatement pstmt = null,pstmtDet = null;
		ResultSet rs = null,rsDet = null;
		int currentFormNo = 0;
		StringBuffer valueXmlString = new StringBuffer();
		
		String currDate = "",userId = "",chgTerm = "",loginSiteCode = "",empCode = "";
		String prdCode = "",gstin = "";
		
		String sql = "";
		
		java.util.Map<String,ArrayList> suppMap = new java.util.HashMap<String,ArrayList>();
		ArrayList<String> invoiceIDList = new ArrayList<String>();
		java.util.Map<String,String> suppDetails = new java.util.HashMap<String,String>();
		
		String orderNo = "",tranID = "",suppCode = "",invoiceID = "",suppName = "",suppAddr = "",suppImgPath = "",submissionType = "";
		int id = 1,gstrDataCount = 0,gstrDataCountTemp = 0;
		int domIDDetail2 = 0;
		int domIDInvoice = 0;
		int domIDGstr = 0;
		try
		{
			conn = getConnection();
			//currDate = getCurrdateAppFormat();

			userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
			chgTerm = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "chgTerm" );
			loginSiteCode = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginSiteCode" );
			empCode =  checkNullAndTrim(genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginEmpCode" ));
			
			if(objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			/*valueXmlString = new StringBuffer("<?xml version = \"1.0\"?><Root><header><editFlag>");
			valueXmlString.append(editFlag).append("</editFlag></header>");*/
			
			valueXmlString = new StringBuffer( "<?xml version=\"1.0\"?><Root><Header><editFlag>" );
			valueXmlString.append( editFlag ).append( "</editFlag></Header>" );
			
			System.out.println("currentColumn["+currentColumn+"] && currentFormNo["+currentFormNo+"]");
			
			switch ( currentFormNo )
			{
				case 1:
				{   
					valueXmlString.append("<Detail1 domID='1' selected = 'N'>\r");
					
					if( currentColumn.trim().equalsIgnoreCase( "itm_default" ))
					{
						valueXmlString.append("<prd_code>").append("<![CDATA[]]>").append("</prd_code>");
						valueXmlString.append("<gstin>").append("<![CDATA[]]>").append("</gstin>");
					}
					
					valueXmlString.append("</Detail1>\r\n");
				}
				break;
				case 2 :
				{
					prdCode = genericUtility.getColumnValue("prd_code", dom1);
					gstin = genericUtility.getColumnValue("gstin", dom1);
							
					System.out.println("Period code ["+prdCode+"] gstin ["+gstin+"]");
					
					if( currentColumn.trim().equalsIgnoreCase( "itm_default" ))
					{
						valueXmlString.append("<Detail2 domID='0'>");
						valueXmlString.append("<prd_code>").append("<![CDATA["+prdCode+"]]>").append("</prd_code>");
						valueXmlString.append("<gstin>").append("<![CDATA["+gstin+"]]>").append("</gstin>");
						valueXmlString.append("</Detail2>");
						 
						/* sql = " SELECT P.SUPP_CODE,I.INVOICE_ID FROM PORCP P, SUPPLIER S, INVOICE I, GST_DATA_HDR G WHERE "
							  +" P.SUPP_CODE = S.SUPP_CODE "
							  +" AND P.INVOICE_NO = I.INVOICE_ID "
							  +" AND G.ORDER_NO = P.INVOICE_NO"
							  +" AND G.TAX_REG_NO = ? AND G.PRD_CODE = ? AND G.REC_TYPE = '1' AND G.RECO_STATUS ! = 'M' ";*/
						 
						 /*sql = " SELECT P.SUPP_CODE,I.INVOICE_ID FROM PORCP P, SUPPLIER S, INVOICE I, GST_DATA_HDR G WHERE "
								  +" P.SUPP_CODE = S.SUPP_CODE "
								  +" AND P.INVOICE_NO = I.INVOICE_ID "
								  +" AND G.DOC_NO = P.INVOICE_NO"
								  +" AND G.TAX_REG_NO = ? AND G.PRD_CODE = ? AND G.SUBMISSION_TYPE = 'P' AND G.RECO_STATUS ! = 'M' ";*/
						
						sql = " SELECT CUST_CODE,DOC_NO FROM GST_DATA_HDR WHERE "
							+ " TAX_REG_NO = ? AND PRD_CODE = ? AND SUBMISSION_TYPE = 'P' AND REC_TYPE = '2' AND RECO_STATUS ! = 'M' ";
						
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, gstin);
						pstmt.setString(2, prdCode);
						rs = pstmt.executeQuery();
						while (rs.next())
						{
							suppCode = checkNullAndTrim(rs.getString("CUST_CODE"));
							invoiceID = rs.getString("DOC_NO");
							
							if (suppMap.containsKey(suppCode))
							{
								invoiceIDList = (ArrayList) suppMap.get(suppCode);
								invoiceIDList.add(invoiceID);
								suppMap.put(suppCode, invoiceIDList);
							} 
			  				else
							{
			  					invoiceIDList = new ArrayList();
			  					invoiceIDList.add(invoiceID);
			  					suppMap.put(suppCode, invoiceIDList);
							}
						}
						if ( rs != null )
						{
							rs.close();rs = null;
						}
						if( pstmt != null )
						{
							pstmt.close();pstmt = null;
						}
						
						java.util.Iterator itr = suppMap.entrySet().iterator();
						while(itr.hasNext())
						{
							 Map.Entry pair = (Map.Entry)itr.next();
							 suppCode = (String) pair.getKey();
							 invoiceIDList = (ArrayList) pair.getValue();
							 
							 System.out.println("SuppCode["+suppCode+"]-->>Invoice ID List ["+invoiceIDList+"]");
							 
							 domIDDetail2++;
							 valueXmlString.append("<Detail2 domID='"+domIDDetail2+"' selected = 'N'>");//Start Multiple suppliers
							 
							 	sql = " SELECT CUST_NAME,STATE_CODE FROM GST_DATA_HDR WHERE CUST_CODE = ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, suppCode);
								rs = pstmt.executeQuery();
								if (rs.next())
								{
									suppName = checkNullAndTrim(rs.getString("CUST_NAME"));
									suppAddr = checkNullAndTrim(rs.getString("STATE_CODE"));
								}
								if(rs!=null)
								{
									rs.close();rs=null;
								}
								if(pstmt!=null)
								{
									pstmt.close();pstmt=null;
								}
								
								DistUtility utility = new DistUtility();
								suppImgPath = utility.getImagePath("w_gstWiz", suppCode , suppName , "customer", null);
							 
							 	valueXmlString.append("<supp_code>").append("<![CDATA["+suppCode+"]]>").append("</supp_code>");
								valueXmlString.append("<supp_name>").append("<![CDATA["+suppName+"]]>").append("</supp_name>");
								valueXmlString.append("<supp_addr>").append("<![CDATA["+suppAddr+"]]>").append("</supp_addr>");
								valueXmlString.append("<supp_img_path>").append("<![CDATA["+suppImgPath+"]]>").append("</supp_img_path>");
							 
									 valueXmlString.append("<Invoices>");//Start Multiple invoice inside single supplier
									
									 for(int i = 0; i< invoiceIDList.size(); i++)
									 {
										 domIDInvoice = i + 1;
										 invoiceID = (String) invoiceIDList.get(i);
										 
										 	valueXmlString.append("<invoice domID='"+domIDInvoice+"'>");
										 	
										 	String orderDate = "",docDate = "";
										 	
										 	sql = " SELECT ORDER_DATE, DOC_DATE, DOC_NO, AMOUNT, SITE_CODE, RECO_STATUS FROM GST_DATA_HDR WHERE DOC_NO = ? AND SUBMISSION_TYPE = 'P' ";
											pstmt = conn.prepareStatement(sql);
											pstmt.setString(1, invoiceID);
											rs = pstmt.executeQuery();
											if (rs.next())
											{
												orderDate = rs.getString("ORDER_DATE");
												docDate = rs.getString("DOC_DATE");
												
												valueXmlString.append("<invoice_id>").append("<![CDATA["+invoiceID+"]]>").append("</invoice_id>");
												valueXmlString.append("<sale_order>").append("<![CDATA["+rs.getString("DOC_NO")+"]]>").append("</sale_order>");
												valueXmlString.append("<inv_amt>").append("<![CDATA["+rs.getString("AMOUNT")+"]]>").append("</inv_amt>");
												valueXmlString.append("<tax_amt>").append("<![CDATA["+rs.getString("SITE_CODE")+"]]>").append("</tax_amt>");
												valueXmlString.append("<reco_status>").append("<![CDATA["+rs.getString("RECO_STATUS")+"]]>").append("</reco_status>");
												
												if(orderDate == null)
												{
													valueXmlString.append("<tran_date>").append("<![CDATA[]]>").append("</tran_date>");
												}
												else
												{
													valueXmlString.append("<tran_date>").append("<![CDATA["+genericUtility.getValidDateString(orderDate, genericUtility.getDBDateTimeFormat(), genericUtility.getApplDateFormat())+"]]>").append("</tran_date>");
												}
												if(docDate == null)
												{
													valueXmlString.append("<doc_date>").append("<![CDATA[]]>").append("</doc_date>");
												}
												else
												{
													valueXmlString.append("<doc_date>").append("<![CDATA["+genericUtility.getValidDateString(docDate, genericUtility.getDBDateTimeFormat(), genericUtility.getApplDateFormat())+"]]>").append("</doc_date>");
												}
											}
											if(rs!=null)
											{
												rs.close();rs=null;
											}
											if(pstmt!=null)
											{
												pstmt.close();pstmt=null;
											}
										 
											for(int j = 1 ;j<=2 ; j++)
											{
												gstrDataCount = 0;
												domIDGstr = 0;
												
												if(j==1)
												{
													submissionType = "P";
												}
												if(j==2)
												{
													submissionType = "D";
												}
												
											    /*sql = " SELECT D.TRAN_ID,D.LINE_NO,D.STATUS,D.GS_CODE,D.TAXABLE_AMT,D.IGST_PERC,D.IGST_AMT,D.CGST_PERC,D.CGST_AMT, "
											    	+ " D.SGST_PERC,D.SGST_AMT,D.GS_DESCR,D.UNIT,D.QUANTITY,D.SUPPLY_TYPE,D.CESS_PERC,D.CESS_AMT,D.REMARKS "
											    	+ " FROM GST_DATA_HDR H, GST_DATA_DET D WHERE H.TRAN_ID = D.TRAN_ID "
											    	+ " AND H.ORDER_NO = ? AND H.REC_TYPE = ? ORDER BY D.GS_CODE ";*/
												
												sql = " SELECT D.TRAN_ID,D.LINE_NO,D.STATUS,D.GS_CODE,D.TAXABLE_AMT,D.IGST_PERC,D.IGST_AMT,D.CGST_PERC,D.CGST_AMT, "
												    	+ " D.SGST_PERC,D.SGST_AMT,D.GS_DESCR,D.UNIT,D.QUANTITY,D.SUPPLY_TYPE,D.CESS_PERC,D.CESS_AMT,D.REMARKS "
												    	+ " FROM GST_DATA_HDR H, GST_DATA_DET D WHERE H.TRAN_ID = D.TRAN_ID "
												    	+ " AND H.DOC_NO = ? AND H.SUBMISSION_TYPE = ? AND H.REC_TYPE = ? ORDER BY D.GS_CODE ";
												pstmtDet = conn.prepareStatement(sql);
												pstmtDet.setString(1, invoiceID);
												pstmtDet.setString(2, submissionType);
												pstmtDet.setString(3, "2");
												rsDet = pstmtDet.executeQuery();
												while (rsDet.next())
												{
													gstrDataCount++;
													
													domIDGstr++;
													valueXmlString.append("<gstr"+j+" domID='"+domIDGstr+"'>");
														valueXmlString.append("<tran_id>").append("<![CDATA["+checkNullAndTrim(rsDet.getString("TRAN_ID"))+"]]>").append("</tran_id>");
														valueXmlString.append("<line_no>").append("<![CDATA["+checkNullAndTrim(rsDet.getString("LINE_NO"))+"]]>").append("</line_no>");
														valueXmlString.append("<status>").append("<![CDATA["+checkNullAndTrim(rsDet.getString("STATUS"))+"]]>").append("</status>");
														valueXmlString.append("<gs_code>").append("<![CDATA["+checkNullAndTrim(rsDet.getString("GS_CODE"))+"]]>").append("</gs_code>");
														valueXmlString.append("<taxable_amt>").append("<![CDATA["+checkNullAndTrim(rsDet.getString("TAXABLE_AMT"))+"]]>").append("</taxable_amt>");
														valueXmlString.append("<igst_perc>").append("<![CDATA["+checkNullAndTrim(rsDet.getString("IGST_PERC"))+"]]>").append("</igst_perc>");
														valueXmlString.append("<igst_amt>").append("<![CDATA["+checkNullAndTrim(rsDet.getString("IGST_AMT"))+"]]>").append("</igst_amt>");
														valueXmlString.append("<cgst_perc>").append("<![CDATA["+checkNullAndTrim(rsDet.getString("CGST_PERC"))+"]]>").append("</cgst_perc>");
														valueXmlString.append("<cgst_amt>").append("<![CDATA["+checkNullAndTrim(rsDet.getString("CGST_AMT"))+"]]>").append("</cgst_amt>");
														valueXmlString.append("<sgst_perc>").append("<![CDATA["+checkNullAndTrim(rsDet.getString("SGST_PERC"))+"]]>").append("</sgst_perc>");
														valueXmlString.append("<sgst_amt>").append("<![CDATA["+checkNullAndTrim(rsDet.getString("SGST_AMT"))+"]]>").append("</sgst_amt>");
														valueXmlString.append("<gs_descr>").append("<![CDATA["+checkNullAndTrim(rsDet.getString("GS_DESCR"))+"]]>").append("</gs_descr>");
														valueXmlString.append("<unit>").append("<![CDATA["+checkNullAndTrim(rsDet.getString("UNIT"))+"]]>").append("</unit>");
														valueXmlString.append("<quantity>").append("<![CDATA["+checkNullAndTrim(rsDet.getString("QUANTITY"))+"]]>").append("</quantity>");
														valueXmlString.append("<supply_type>").append("<![CDATA["+checkNullAndTrim(rsDet.getString("SUPPLY_TYPE"))+"]]>").append("</supply_type>");
														valueXmlString.append("<cess_perc>").append("<![CDATA["+checkNullAndTrim(rsDet.getString("CESS_PERC"))+"]]>").append("</cess_perc>");
														valueXmlString.append("<cess_amt>").append("<![CDATA["+checkNullAndTrim(rsDet.getString("CESS_AMT"))+"]]>").append("</cess_amt>");
														valueXmlString.append("<remarks>").append("<![CDATA["+checkNullAndTrim(rsDet.getString("REMARKS"))+"]]>").append("</remarks>");
													valueXmlString.append("</gstr"+j+">");
												}
												if ( rsDet != null )
												{
													rsDet.close();rsDet = null;
												}
												if( pstmtDet != null )
												{
													pstmtDet.close();pstmtDet = null;
												}
												
												System.out.println("J-->["+j+"] and gstrDataCount--["+gstrDataCount+"]");
												
												if(j == 2)
												{
													gstrDataCount = gstrDataCountTemp - gstrDataCount;
													
													for(int x = 1 ;x<=gstrDataCount ; x++)
													{
														valueXmlString.append("<gstr"+j+">");
															System.out.println("For making blank row as GSTR2 data not found for this row");
														valueXmlString.append("</gstr"+j+">");
													}
												}
												gstrDataCountTemp = gstrDataCount;
											}
											
											valueXmlString.append("<data_match>").append("<![CDATA["+gstrDataCount+"]]>").append("</data_match>");
											valueXmlString.append("</invoice>");
									 }
									 
									 valueXmlString.append("</Invoices>"); //End Multiple invoice inside single supplier
								 
							 valueXmlString.append("</Detail2>");//End Multiple suppliers	 
						 }		 
					}
				}
				break;
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception: itemChange GSTWizardEJB: ==>\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();rs = null;
				}	
				if(pstmt != null)
				{	
					pstmt.close();pstmt = null;
				}
				if(conn != null)
				{	
					conn.close();conn = null;
				}
			}
			catch(Exception d)
			{
				d.printStackTrace();
				throw new ITMException(d);
			}			
		}

		valueXmlString.append("</Root>");
		return valueXmlString.toString();
	}
	
	
	
	
	
	
	
	
	
	
	
	/*@Override
	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException 
	{
		Connection conn = null;
		PreparedStatement pstmt = null,pstmtDet = null;
		ResultSet rs = null,rsDet = null;
		int currentFormNo = 0;
		StringBuffer valueXmlString = new StringBuffer();
		
		String currDate = "",userId = "",chgTerm = "",loginSiteCode = "",empCode = "";
		String prdCode = "",gstin = "";
		
		String sql = "";
		
		java.util.Map<String,ArrayList> suppMap = new java.util.HashMap<String,ArrayList>();
		ArrayList<String> invoiceIDList = new ArrayList<String>();
		java.util.Map<String,String> suppDetails = new java.util.HashMap<String,String>();
		
		String orderNo = "",tranID = "",suppCode = "",invoiceID = "",suppName = "",suppAddr = "",suppImgPath = "",submissionType = "";
		int id = 1,gstrDataCount = 0,gstrDataCountTemp = 0;
		int domIDDetail2 = 0;
		int domIDInvoice = 0;
		int domIDGstr = 0;
		try
		{
			conn = getConnection();
			//currDate = getCurrdateAppFormat();

			userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
			chgTerm = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "chgTerm" );
			loginSiteCode = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginSiteCode" );
			empCode =  checkNullAndTrim(genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginEmpCode" ));
			
			if(objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			valueXmlString = new StringBuffer("<?xml version = \"1.0\"?><Root><header><editFlag>");
			valueXmlString.append(editFlag).append("</editFlag></header>");
			
			valueXmlString = new StringBuffer( "<?xml version=\"1.0\"?><Root><Header><editFlag>" );
			valueXmlString.append( editFlag ).append( "</editFlag></Header>" );
			
			System.out.println("currentColumn["+currentColumn+"] && currentFormNo["+currentFormNo+"]");
			
			switch ( currentFormNo )
			{
				case 1:
				{   
					valueXmlString.append("<Detail1 domID='1' selected = 'N'>\r");
					
					if( currentColumn.trim().equalsIgnoreCase( "itm_default" ))
					{
						valueXmlString.append("<prd_code>").append("<![CDATA[]]>").append("</prd_code>");
						valueXmlString.append("<gstin>").append("<![CDATA[]]>").append("</gstin>");
					}
					
					valueXmlString.append("</Detail1>\r\n");
				}
				break;
				case 2 :
				{
					prdCode = genericUtility.getColumnValue("prd_code", dom1);
					gstin = genericUtility.getColumnValue("gstin", dom1);
							
					System.out.println("Period code ["+prdCode+"] gstin ["+gstin+"]");
					
					if( currentColumn.trim().equalsIgnoreCase( "itm_default" ))
					{
						valueXmlString.append("<Detail2 domID='0'>");
						valueXmlString.append("<prd_code>").append("<![CDATA["+prdCode+"]]>").append("</prd_code>");
						valueXmlString.append("<gstin>").append("<![CDATA["+gstin+"]]>").append("</gstin>");
						valueXmlString.append("</Detail2>");
						 
						 sql = " SELECT P.SUPP_CODE,I.INVOICE_ID FROM PORCP P, SUPPLIER S, INVOICE I, GST_DATA_HDR G WHERE "
							  +" P.SUPP_CODE = S.SUPP_CODE "
							  +" AND P.INVOICE_NO = I.INVOICE_ID "
							  +" AND G.ORDER_NO = P.INVOICE_NO"
							  +" AND G.TAX_REG_NO = ? AND G.PRD_CODE = ? AND G.REC_TYPE = '1' AND G.RECO_STATUS ! = 'M' ";
						 
						 sql = " SELECT P.SUPP_CODE,I.INVOICE_ID FROM PORCP P, SUPPLIER S, INVOICE I, GST_DATA_HDR G WHERE "
								  +" P.SUPP_CODE = S.SUPP_CODE "
								  +" AND P.INVOICE_NO = I.INVOICE_ID "
								  +" AND G.DOC_NO = P.INVOICE_NO"
								  +" AND G.TAX_REG_NO = ? AND G.PRD_CODE = ? AND G.SUBMISSION_TYPE = 'P' AND G.RECO_STATUS ! = 'M' ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, gstin);
						pstmt.setString(2, prdCode);
						rs = pstmt.executeQuery();
						while (rs.next())
						{
							suppCode = checkNullAndTrim(rs.getString("SUPP_CODE"));
							invoiceID = rs.getString("INVOICE_ID");
							
							if (suppMap.containsKey(suppCode))
							{
								invoiceIDList = (ArrayList) suppMap.get(suppCode);
								invoiceIDList.add(invoiceID);
								suppMap.put(suppCode, invoiceIDList);
							} 
			  				else
							{
			  					invoiceIDList = new ArrayList();
			  					invoiceIDList.add(invoiceID);
			  					suppMap.put(suppCode, invoiceIDList);
							}
						}
						if ( rs != null )
						{
							rs.close();rs = null;
						}
						if( pstmt != null )
						{
							pstmt.close();pstmt = null;
						}
						
						java.util.Iterator itr = suppMap.entrySet().iterator();
						while(itr.hasNext())
						{
							 Map.Entry pair = (Map.Entry)itr.next();
							 suppCode = (String) pair.getKey();
							 invoiceIDList = (ArrayList) pair.getValue();
							 
							 System.out.println("SuppCode["+suppCode+"]-->>Invoice ID List ["+invoiceIDList+"]");
							 
							 domIDDetail2++;
							 valueXmlString.append("<Detail2 domID='"+domIDDetail2+"' selected = 'N'>");//Start Multiple suppliers
							 
							 	sql = " SELECT SH_NAME,ADDR1 FROM SUPPLIER WHERE SUPP_CODE = ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, suppCode);
								rs = pstmt.executeQuery();
								if (rs.next())
								{
									suppName = checkNullAndTrim(rs.getString("SH_NAME"));
									suppAddr = checkNullAndTrim(rs.getString("ADDR1"));
								}
								if(rs!=null)
								{
									rs.close();rs=null;
								}
								if(pstmt!=null)
								{
									pstmt.close();pstmt=null;
								}
								
								DistUtility utility = new DistUtility();
								suppImgPath = utility.getImagePath("w_gstWiz", suppCode , suppName , "customer", null);
							 
							 	valueXmlString.append("<supp_code>").append("<![CDATA["+suppCode+"]]>").append("</supp_code>");
								valueXmlString.append("<supp_name>").append("<![CDATA["+suppName+"]]>").append("</supp_name>");
								valueXmlString.append("<supp_addr>").append("<![CDATA["+suppAddr+"]]>").append("</supp_addr>");
								valueXmlString.append("<supp_img_path>").append("<![CDATA["+suppImgPath+"]]>").append("</supp_img_path>");
							 
									 valueXmlString.append("<Invoices>");//Start Multiple invoice inside single supplier
									
									 for(int i = 0; i< invoiceIDList.size(); i++)
									 {
										 domIDInvoice = i + 1;
										 invoiceID = (String) invoiceIDList.get(i);
										 
										 	valueXmlString.append("<invoice domID='"+domIDInvoice+"'>");
										 	
										 	sql = " SELECT I.INVOICE_ID,I.TRAN_DATE,I.SALE_ORDER,I.INV_AMT,I.TAX_AMT,G.RECO_STATUS FROM INVOICE I,GST_DATA_HDR G "
										 		+ " WHERE I.INVOICE_ID = G.ORDER_NO AND G.REC_TYPE = '1' AND I.INVOICE_ID = ? ";
										 	sql = " SELECT I.INVOICE_ID,I.TRAN_DATE,I.SALE_ORDER,I.INV_AMT,I.TAX_AMT,G.RECO_STATUS FROM INVOICE I,GST_DATA_HDR G "
											 		+ " WHERE I.INVOICE_ID = G.DOC_NO AND G.SUBMISSION_TYPE = 'P' AND I.INVOICE_ID = ? ";
											pstmt = conn.prepareStatement(sql);
											pstmt.setString(1, invoiceID);
											rs = pstmt.executeQuery();
											if (rs.next())
											{
												valueXmlString.append("<invoice_id>").append("<![CDATA["+invoiceID+"]]>").append("</invoice_id>");
												valueXmlString.append("<tran_date>").append("<![CDATA["+genericUtility.getValidDateString(rs.getString("tran_date"), genericUtility.getDBDateTimeFormat(), genericUtility.getApplDateFormat())+"]]>").append("</tran_date>");
												valueXmlString.append("<sale_order>").append("<![CDATA["+rs.getString("SALE_ORDER")+"]]>").append("</sale_order>");
												valueXmlString.append("<inv_amt>").append("<![CDATA["+rs.getString("INV_AMT")+"]]>").append("</inv_amt>");
												valueXmlString.append("<tax_amt>").append("<![CDATA["+rs.getString("TAX_AMT")+"]]>").append("</tax_amt>");
												valueXmlString.append("<reco_status>").append("<![CDATA["+rs.getString("RECO_STATUS")+"]]>").append("</reco_status>");
											}
											if(rs!=null)
											{
												rs.close();rs=null;
											}
											if(pstmt!=null)
											{
												pstmt.close();pstmt=null;
											}
										 
											for(int j = 1 ;j<=2 ; j++)
											{
												gstrDataCount = 0;
												domIDGstr = 0;
												
												if(j==1)
												{
													submissionType = "P";
												}
												if(j==2)
												{
													submissionType = "D";
												}
												
											    sql = " SELECT D.TRAN_ID,D.LINE_NO,D.STATUS,D.GS_CODE,D.TAXABLE_AMT,D.IGST_PERC,D.IGST_AMT,D.CGST_PERC,D.CGST_AMT, "
											    	+ " D.SGST_PERC,D.SGST_AMT,D.GS_DESCR,D.UNIT,D.QUANTITY,D.SUPPLY_TYPE,D.CESS_PERC,D.CESS_AMT,D.REMARKS "
											    	+ " FROM GST_DATA_HDR H, GST_DATA_DET D WHERE H.TRAN_ID = D.TRAN_ID "
											    	+ " AND H.ORDER_NO = ? AND H.REC_TYPE = ? ORDER BY D.GS_CODE ";
												
												sql = " SELECT D.TRAN_ID,D.LINE_NO,D.STATUS,D.GS_CODE,D.TAXABLE_AMT,D.IGST_PERC,D.IGST_AMT,D.CGST_PERC,D.CGST_AMT, "
												    	+ " D.SGST_PERC,D.SGST_AMT,D.GS_DESCR,D.UNIT,D.QUANTITY,D.SUPPLY_TYPE,D.CESS_PERC,D.CESS_AMT,D.REMARKS "
												    	+ " FROM GST_DATA_HDR H, GST_DATA_DET D WHERE H.TRAN_ID = D.TRAN_ID "
												    	+ " AND H.DOC_NO = ? AND H.SUBMISSION_TYPE = ? ORDER BY D.GS_CODE ";
												pstmtDet = conn.prepareStatement(sql);
												pstmtDet.setString(1, invoiceID);
												//pstmtDet.setString(2, String.valueOf(j));
												pstmtDet.setString(2, submissionType);
												rsDet = pstmtDet.executeQuery();
												while (rsDet.next())
												{
													gstrDataCount++;
													
													domIDGstr++;
													valueXmlString.append("<gstr"+j+" domID='"+domIDGstr+"'>");
														valueXmlString.append("<tran_id>").append("<![CDATA["+rsDet.getString("TRAN_ID")+"]]>").append("</tran_id>");
														valueXmlString.append("<line_no>").append("<![CDATA["+rsDet.getString("LINE_NO")+"]]>").append("</line_no>");
														valueXmlString.append("<status>").append("<![CDATA["+rsDet.getString("STATUS")+"]]>").append("</status>");
														valueXmlString.append("<gs_code>").append("<![CDATA["+rsDet.getString("GS_CODE")+"]]>").append("</gs_code>");
														valueXmlString.append("<taxable_amt>").append("<![CDATA["+rsDet.getString("TAXABLE_AMT")+"]]>").append("</taxable_amt>");
														valueXmlString.append("<igst_perc>").append("<![CDATA["+rsDet.getString("IGST_PERC")+"]]>").append("</igst_perc>");
														valueXmlString.append("<igst_amt>").append("<![CDATA["+rsDet.getString("IGST_AMT")+"]]>").append("</igst_amt>");
														valueXmlString.append("<cgst_perc>").append("<![CDATA["+rsDet.getString("CGST_PERC")+"]]>").append("</cgst_perc>");
														valueXmlString.append("<cgst_amt>").append("<![CDATA["+rsDet.getString("CGST_AMT")+"]]>").append("</cgst_amt>");
														valueXmlString.append("<sgst_perc>").append("<![CDATA["+rsDet.getString("SGST_PERC")+"]]>").append("</sgst_perc>");
														valueXmlString.append("<sgst_amt>").append("<![CDATA["+rsDet.getString("SGST_AMT")+"]]>").append("</sgst_amt>");
														valueXmlString.append("<gs_descr>").append("<![CDATA["+rsDet.getString("GS_DESCR")+"]]>").append("</gs_descr>");
														valueXmlString.append("<unit>").append("<![CDATA["+rsDet.getString("UNIT")+"]]>").append("</unit>");
														valueXmlString.append("<quantity>").append("<![CDATA["+rsDet.getString("QUANTITY")+"]]>").append("</quantity>");
														valueXmlString.append("<supply_type>").append("<![CDATA["+rsDet.getString("SUPPLY_TYPE")+"]]>").append("</supply_type>");
														valueXmlString.append("<cess_perc>").append("<![CDATA["+rsDet.getString("CESS_PERC")+"]]>").append("</cess_perc>");
														valueXmlString.append("<cess_amt>").append("<![CDATA["+rsDet.getString("CESS_AMT")+"]]>").append("</cess_amt>");
														valueXmlString.append("<remarks>").append("<![CDATA["+rsDet.getString("REMARKS")+"]]>").append("</remarks>");
													valueXmlString.append("</gstr"+j+">");
												}
												if ( rsDet != null )
												{
													rsDet.close();rsDet = null;
												}
												if( pstmtDet != null )
												{
													pstmtDet.close();pstmtDet = null;
												}
												
												System.out.println("J-->["+j+"] and gstrDataCount--["+gstrDataCount+"]");
												
												if(j == 2)
												{
													gstrDataCount = gstrDataCountTemp - gstrDataCount;
													
													for(int x = 1 ;x<=gstrDataCount ; x++)
													{
														valueXmlString.append("<gstr"+j+">");
															System.out.println("For making blank row as GSTR2 data not found for this row");
														valueXmlString.append("</gstr"+j+">");
													}
												}
												gstrDataCountTemp = gstrDataCount;
											}
											
											valueXmlString.append("<data_match>").append("<![CDATA["+gstrDataCount+"]]>").append("</data_match>");
											valueXmlString.append("</invoice>");
									 }
									 
									 valueXmlString.append("</Invoices>"); //End Multiple invoice inside single supplier
								 
							 valueXmlString.append("</Detail2>");//End Multiple suppliers	 
						 }		 
					}
				}
				break;
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception: itemChange GSTWizardEJB: ==>\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();rs = null;
				}	
				if(pstmt != null)
				{	
					pstmt.close();pstmt = null;
				}
				if(conn != null)
				{	
					conn.close();conn = null;
				}
			}
			catch(Exception d)
			{
				d.printStackTrace();
				throw new ITMException(d);
			}			
		}

		valueXmlString.append("</Root>");
		return valueXmlString.toString();
	}*/
	
	/**
	 * @param input String
	 * @return
	 */
	private static String checkNullAndTrim(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input.trim();
	}
	
	/**
	 * get current date in Timestap formate
	 */
	private java.sql.Timestamp getCurrtDate() throws RemoteException,ITMException 
	{
		String currAppdate = "";
		java.sql.Timestamp currDate = null;
		try 
		{
			Object date = null;
			currDate = new java.sql.Timestamp(System.currentTimeMillis());
			java.text.SimpleDateFormat sdf = new java.text.SimpleDateFormat(genericUtility.getDBDateFormat());
			date = sdf.parse(currDate.toString());
			currDate = java.sql.Timestamp.valueOf(sdf.format(date).toString()+ " 00:00:00.0");

		} 
		catch (Exception e) 
		{
			throw new ITMException(e);
		}
		return (currDate);
	}
	
	/**
	 * get current date in Application Time format
	 */
	private String getCurrdateAppFormat() 
	{
		String s = "";
		E12GenericUtility genericUtility = new E12GenericUtility();
		try
		{
			java.util.Date date = null;
			Timestamp timestamp = new Timestamp(System.currentTimeMillis());

			SimpleDateFormat simpledateformat = new SimpleDateFormat(genericUtility.getDBDateFormat());
			date = simpledateformat.parse(timestamp.toString());
			timestamp = Timestamp.valueOf(simpledateformat.format(date).toString() + " 00:00:00.0");
			s = new SimpleDateFormat(genericUtility.getApplDateFormat()).format(timestamp).toString();
		}
		catch (Exception localException)
		{
		}

		return s;
	}
	
}
