package ibase.dashboard.sfa.ejb;

import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.LinkedHashMap;
import javax.ejb.Stateless;
import org.json.simple.JSONObject;


@Stateless
public class ZonewiseCoachingDays extends ValidatorEJB implements ZonewiseCoachingDaysLocal,ZonewiseCoachingDaysRemote
{
	@SuppressWarnings("unchecked")
	public JSONObject getZonewiseCoachingDay(String loginCode,String dataSourceName,String fromDate,String toDate,String loginEmpCode)throws RemoteException, ITMException
	{
		JSONObject rowDataZonewiseCoachingJson = null;
		JSONObject rowData                  = null;
		String sql                          = "";		
		ResultSet rs                        = null;
		PreparedStatement pstmt             = null;
		Connection conn                     = null;
		ConnDriver connDriver               = null;
		int count                           = 0 , noOfRows = 0;
		E12GenericUtility e12GenericUtility = null;
   		SimpleDateFormat convertToDBDate    = null;
		Calendar calendar                   = null;
		DecimalFormat df                    = null;
		String year                         = "", ytdYear = "", coachDayAndTimeHeading = "";
		StringBuffer zoneValueBuffer        = null,finalBuffer = null, monthBuffer = null, headingBuffer = null, monthAvgValBuffer = null;
		LinkedHashMap<String, StringBuffer> zonewiseDataMap = null;
		LinkedHashMap<String, double[]> monthDataMap = null, ytdDataMap= null;
		double[] ytdValueArray = null,monthValSumArray = null;
		double monthSumValue = 0.0D, ytdSumValue = 0.0D, monthPercSumValue = 0.0D, ytdPercSumValue = 0.0D, allIndiaYtdSum = 0.0D, allIndiaYtdPercSum = 0.0;
		
		try
		{
			connDriver 		= new ConnDriver();
			conn       		= connDriver.getConnectDB(dataSourceName);
			connDriver 		= null;
			//df         		= new DecimalFormat("#.##");
			df         		= new DecimalFormat("#.#");
			toDate     		= checkNull(toDate);
			fromDate   		= checkNull(fromDate);
			zonewiseDataMap = new LinkedHashMap<String, StringBuffer>();
			monthDataMap    = new LinkedHashMap<String, double[]>();
			ytdDataMap      = new LinkedHashMap<String, double[]>();
			finalBuffer     = new StringBuffer();
			monthBuffer     = new StringBuffer();
			headingBuffer   = new StringBuffer();
			coachDayAndTimeHeading = "<td class='cardSalesPersonTitlehtml' width='7%' style = 'line-height: 17px;'>NO. OF COACHING DAYS</td><td class='cardSalesPersonTitlehtml' width='7%' style = 'line-height: 17px;'>COACHING TIME %</td>";
					
			if(("".equalsIgnoreCase(fromDate)) && ("".equalsIgnoreCase(toDate)))
			{ 				
				e12GenericUtility = new E12GenericUtility();
				convertToDBDate   = new SimpleDateFormat("dd-MMM-yy");
				calendar          = Calendar.getInstance();
				fromDate          = getDateString("firstDayOfYear", convertToDBDate, calendar);
				toDate            = getDateString("lastDayOfYear", convertToDBDate, calendar);
				year              = String.valueOf(calendar.get(Calendar.YEAR));
				ytdYear           = year.substring(2);
				System.out.println("From date = "+fromDate+" toDate ="+toDate);				
			}
			else
			{
				e12GenericUtility = new E12GenericUtility();
				fromDate          = e12GenericUtility.getValidDateString(fromDate, "dd/MM/yyyy", "dd-MMM-yy");
				toDate            = e12GenericUtility.getValidDateString(toDate, "dd/MM/yyyy",  "dd-MMM-yy");
				ytdYear           = (fromDate.split("-"))[2];
				System.out.println("From date = "+fromDate+" toDate ="+toDate);
			}
			/*Zone wise sql on dated 09022017*/
			//sql = "SELECT H.ZONE, SM.YEAR, SM.EVENT_MONTH, SM.MONTH,  SM.SALES_PERS, count(sm.sales_pers), (SUM(vw_flm_qtq_teamwise.daysinfield) /count(sm.sales_pers))as avg, SUM(FN_SP_CNT_NEW_MT(SM.SALES_PERS,SM.MONTH,SM.YEAR,'REP')) AS MONTHLY_COUNT, SUM(vw_flm_qtq_teamwise.availdaysinfield)AS AVAILDAYSINFIELD, SUM(vw_flm_qtq_teamwise.daysinfield)AS DAYSINFIELD, (SUM(vw_flm_qtq_teamwise.daysinfield)/ SUM(vw_flm_qtq_teamwise.availdaysinfield)*100 ) AS PERCETGE FROM sales_pers INNER JOIN ( SELECT DISTINCT sales_pers, TO_CHAR(SM.event_date,'mm')   AS Event_month , TO_CHAR(SM.event_date,'MON')  AS MONTH, TO_CHAR(SM.event_date,'YYYY') AS YEAR FROM strg_meet SM WHERE SM.Sales_Pers IN (SELECT Emp_Code FROM Employee START WITH Emp_Code = (SELECT emp_code FROM users WHERE code='"+loginCode+"' ) CONNECT BY Prior Emp_Code = Report_To ) AND SM.EVENT_DATE BETWEEN '"+fromDate+"' AND '"+toDate+"' ) SM ON sales_pers.sales_pers = SM.sales_pers INNER JOIN (SELECT DISTINCT(ABMCODE) AS ABMCODE,ZONE FROM vw_SALES_HIER ) H ON SM.SALES_PERS = H.ABMCODE INNER JOIN users ON users.emp_code = SM.SALES_PERS INNER JOIN vw_flm_qtq_teamwise ON vw_flm_qtq_teamwise.sales_pers = SM.SALES_PERS AND vw_flm_qtq_teamwise.month = sm.Event_month AND vw_flm_qtq_teamwise.year = sm.YEAR WHERE users.profile_id ='FLM1' AND ZONE='WEST ZONE I' GROUP BY H.ZONE, SM.SALES_PERS, SM.YEAR, SM.EVENT_MONTH, SM.MONTH ORDER BY H.ZONE, SM.YEAR, SM.EVENT_MONTH, SM.MONTH ";
			//sql = "SELECT H.ZONE, SM.YEAR, SM.EVENT_MONTH, SM.MONTH, SUM(FN_RCOACHING_SP_NEW(SM.SALES_PERS,SM.MONTH,SM.YEAR,'REP')) AS MONTHLY_COUNT, SUM(vw_flm_qtq_teamwise.availdaysinfield) AS AVAILDAYSINFIELD, SUM(vw_flm_qtq_teamwise.daysinfield) AS DAYSINFIELD FROM sales_pers INNER JOIN ( SELECT DISTINCT sales_pers, TO_CHAR(SM.event_date,'mm')   AS Event_month , TO_CHAR(SM.event_date,'MON')  AS MONTH, TO_CHAR(SM.event_date,'YYYY') AS YEAR FROM strg_meet SM WHERE SM.Sales_Pers IN (SELECT Emp_Code FROM Employee START WITH Emp_Code = (SELECT emp_code FROM users WHERE code='"+loginCode+"' ) CONNECT BY Prior Emp_Code = Report_To ) AND SM.EVENT_DATE BETWEEN '"+fromDate+"' AND '"+toDate+"' ) SM ON sales_pers.sales_pers = SM.sales_pers INNER JOIN (SELECT DISTINCT(ABMCODE) AS ABMCODE,ZONE FROM vw_SALES_HIER ) H ON SM.SALES_PERS = H.ABMCODE INNER JOIN users ON users.emp_code = SM.SALES_PERS INNER JOIN vw_flm_qtq_teamwise ON vw_flm_qtq_teamwise.sales_pers = SM.SALES_PERS AND vw_flm_qtq_teamwise.month = sm.Event_month AND vw_flm_qtq_teamwise.year = sm.YEAR WHERE users.profile_id = 'FLM1' GROUP BY H.ZONE, SM.YEAR, SM.EVENT_MONTH, SM.MONTH ORDER BY H.ZONE, SM.YEAR, SM.EVENT_MONTH, SM.MONTH";
			sql = "SELECT H.ZONE, SM.YEAR, SM.EVENT_MONTH, SM.MONTH, SUM(FN_SP_CNT_NEW_MT(SM.SALES_PERS,SM.MONTH,SM.YEAR,'REP')) AS MONTHLY_COUNT1,(SUM(vw_flm_qtq_teamwise.daysinfield) /count(sm.sales_pers))as MONTHLY_COUNT, SUM(vw_flm_qtq_teamwise.availdaysinfield) AS AVAILDAYSINFIELD, SUM(vw_flm_qtq_teamwise.daysinfield) AS DAYSINFIELD FROM sales_pers INNER JOIN ( SELECT DISTINCT sales_pers, TO_CHAR(SM.event_date,'mm')   AS Event_month , TO_CHAR(SM.event_date,'MON')  AS MONTH, TO_CHAR(SM.event_date,'YYYY') AS YEAR FROM strg_meet SM WHERE SM.Sales_Pers IN (SELECT Emp_Code FROM Employee START WITH Emp_Code = (SELECT emp_code FROM users WHERE code='"+loginCode+"' ) CONNECT BY Prior Emp_Code = Report_To ) AND SM.EVENT_DATE BETWEEN '"+fromDate+"' AND '"+toDate+"' ) SM ON sales_pers.sales_pers = SM.sales_pers INNER JOIN (SELECT DISTINCT(ABMCODE) AS ABMCODE,ZONE FROM vw_SALES_HIER ) H ON SM.SALES_PERS = H.ABMCODE INNER JOIN users ON users.emp_code = SM.SALES_PERS INNER JOIN vw_flm_qtq_teamwise ON vw_flm_qtq_teamwise.sales_pers = SM.SALES_PERS AND vw_flm_qtq_teamwise.month = sm.Event_month AND vw_flm_qtq_teamwise.year = sm.YEAR WHERE users.profile_id = 'FLM1' GROUP BY H.ZONE, SM.YEAR, SM.EVENT_MONTH, SM.MONTH ORDER BY H.ZONE, SM.YEAR, SM.EVENT_MONTH, SM.MONTH";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			
			while(rs.next())
			{	
				String zoneName      = checkNull(rs.getString("ZONE"));
				String monthName     = checkNull(rs.getString("MONTH"));
				String monthlyCount  = checkDouble(rs.getString("MONTHLY_COUNT"));
				String avlDayInField = checkDouble(rs.getString("AVAILDAYSINFIELD"));
				String daysInField   = checkDouble(rs.getString("DAYSINFIELD"));
				String coachDaysPerc = getCoachingDaysPerc(avlDayInField,daysInField,df);
				
				if (ytdDataMap.containsKey(zoneName)) 
				{
					ytdValueArray    = ytdDataMap.get(zoneName);
					ytdSumValue      = ytdValueArray[0] + Double.parseDouble(monthlyCount);
					ytdPercSumValue  = ytdValueArray[1] + Double.parseDouble(coachDaysPerc);
					ytdValueArray[0] = ytdSumValue;
					ytdValueArray[1] = ytdPercSumValue;
					ytdDataMap.put(zoneName, ytdValueArray);
				}
				else 
				{
					ytdValueArray    = new double[2];
					ytdValueArray[0] = Double.parseDouble(monthlyCount);
					ytdValueArray[1] = Double.parseDouble(coachDaysPerc);
					ytdDataMap.put(zoneName, ytdValueArray); 
				}	
				
				if (monthDataMap.containsKey(monthName)) 
				{
					monthValSumArray    = monthDataMap.get(monthName);
					monthSumValue       = monthValSumArray[0] + Double.parseDouble(monthlyCount);
					monthPercSumValue   = monthValSumArray[1] + Double.parseDouble(coachDaysPerc);
					monthValSumArray[0] = monthSumValue;
					monthValSumArray[1] = monthPercSumValue; 
					monthDataMap.put(monthName, monthValSumArray);
				}
				else 
				{
					monthValSumArray    = new double[2];
					monthValSumArray[0] = Double.parseDouble(monthlyCount);
					monthValSumArray[1] = Double.parseDouble(coachDaysPerc);
					monthDataMap.put(monthName, monthValSumArray);
					monthBuffer.append("<td class='cardSalesPersonTitlehtml' align='center' width='14%' colspan = '2'>"+monthName+" ' "+ytdYear+"</td>");
					headingBuffer.append(coachDayAndTimeHeading);
				}
				
				if (zonewiseDataMap.containsKey(zoneName)) 
				{
					zoneValueBuffer = zonewiseDataMap.get(zoneName);
					zoneValueBuffer.append("<td align='right' width='7%' style='padding-right: 5px;'>"+dfFormatter(Double.parseDouble(monthlyCount))+"</td>"+"<td width='7%' style = 'padding-left: 0px;'>"+getcolorDotFromValue(Double.parseDouble(coachDaysPerc),df)+"</td>");
					zonewiseDataMap.put(zoneName, zoneValueBuffer);
				}
				else 
				{
					zoneValueBuffer = new StringBuffer();
					zoneValueBuffer.append("<td align='right' width='7%' style='padding-right: 5px;'>"+dfFormatter(Double.parseDouble(monthlyCount))+"</td>"+"<td width='7%' style = 'padding-left: 0px;'>"+getcolorDotFromValue(Double.parseDouble(coachDaysPerc),df)+"</td>");
					zonewiseDataMap.put(zoneName, zoneValueBuffer);
				}
				noOfRows++;
			}
			
			if(noOfRows > 0){
				
				finalBuffer.append("<tr><td class='cardSalesPersonTitlehtml' rowspan = '2' width='15%'>ZONE</td>"+monthBuffer.toString()+" <td class='cardSalesPersonTitlehtml' align='center' width='14%' colspan = '2'>"+"YTD "+" ' "+ytdYear+"</td></tr>");
				finalBuffer.append("<tr>"+headingBuffer.toString()+coachDayAndTimeHeading+"</tr>");
				
				for (String key : zonewiseDataMap.keySet()) 
			    {
					double ytdArr[]       = ytdDataMap.get(key);
					double ytdSum         = ytdArr[0];
					double ytdSumPerc     = ytdArr[1];
					String ytdAvg         = df.format((ytdSum)/monthDataMap.size());
					String ytdPercAvg     = getcolorDotFromValue((ytdSumPerc)/monthDataMap.size(),df);
					
					finalBuffer.append("<tr><td class='cardSalesPersonTitlehtml' width='15%'>"+key+"</td>"+zonewiseDataMap.get(key).toString()+"<td align='right' width='7%' style='padding-right: 5px;'>"+ytdAvg+"</td><td width='7%'style = 'padding-left: 0px;'>"+ytdPercAvg+"</td></tr>");
			    }
				
				monthAvgValBuffer = new StringBuffer();
				for (String key : monthDataMap.keySet()) 
			    {
					double monthAvgArr[]  = monthDataMap.get(key);
					double monthSum       = monthAvgArr[0];
					double monthSumPerc   = monthAvgArr[1];
					String monthAvg       = df.format((monthSum)/zonewiseDataMap.size());
					String monthPercAvg   = df.format((monthSumPerc)/zonewiseDataMap.size());
					allIndiaYtdSum        = allIndiaYtdSum + Double.parseDouble(monthAvg);
					allIndiaYtdPercSum    = allIndiaYtdPercSum + Double.parseDouble(monthPercAvg);
					monthAvgValBuffer.append("<td class='cardHtmlTableBodyAlignRgt' width='7%' background-color='antiquewhite' style='padding-right: 5px;'>"+monthAvg+"</td><td width='7%'style = 'padding-left: 0px;'>"+getcolorDotFromValue(Double.parseDouble(monthPercAvg),df)+"</td>");
			    }
				
				finalBuffer.append("<tr><td class='cardSalesPersonTitlehtml' width='15%'>ALL INDIA</td>"+monthAvgValBuffer.toString()+"<td class='cardHtmlTableBodyAlignRgt' width='7%' style='padding-right: 5px;'>"+dfFormatter(allIndiaYtdSum/monthDataMap.size())+"</td><td  width='7%' style = 'padding-left: 0px;'>"+getcolorDotFromValue(allIndiaYtdPercSum/monthDataMap.size(),df)+"</td></tr>");
			
				rowData                       = new JSONObject();
				rowDataZonewiseCoachingJson   = new JSONObject();
				rowData.put("coachingDays", "<table cellpadding = '5' border= '1' class = 'mt' id='htmlTable' width = '105%'> <tbody> <tr> <td colspan = '27' width = '100%' align = 'center' class='cardSalesPersonTitle'> % COACHING CALL REPORT DETAIL </td> </tr> "+finalBuffer.toString()+" </tbody> </table>");
				rowData.put("exportToExcel", CommonConstants.TOMCAT_HOME+"/ibase/dwh/FusionChart/images/excel.png");
				rowDataZonewiseCoachingJson.put(count, rowData);
				count++;
			}
			else{
				rowData                       = new JSONObject();
				rowDataZonewiseCoachingJson   = new JSONObject();
				rowData.put("coachingDays", "<table cellpadding = '5' width = '100%'> <tbody> <tr> <td width = '100%' align = 'center'>No Data to Display</td> </tr>  </tbody> </table>");
				rowData.put("exportToExcel", CommonConstants.TOMCAT_HOME+"/ibase/dwh/FusionChart/images/excel.png");
				rowDataZonewiseCoachingJson.put(count, rowData);
				count++;
			}		
		}catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
						rs.close();
					rs = null;
					if (pstmt != null)
						pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			}
			catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :getZonewiseCoachingDay():" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return rowDataZonewiseCoachingJson;
	}
 
	private String getCoachingDaysPerc(String avlDayInField,String daysInField, DecimalFormat df) {
		
		double daysInFieldVal       = Double.parseDouble(daysInField);
		double avlDayInFieldVal     = Double.parseDouble(avlDayInField);
		String couchingDaysPercStr  = "";
		
		if((daysInFieldVal == 0.0) && (avlDayInFieldVal == 0.0)){
			couchingDaysPercStr     = "0.0";
		}
		else {
			double couchingDaysPerc = (daysInFieldVal/avlDayInFieldVal)*100;
			couchingDaysPercStr     = dfFormatter(couchingDaysPerc) ;	
		}
		return couchingDaysPercStr;
	}

	private String checkDouble(String str)
	{
		if (str == null)
		{
			return "0.0";
		} else
		{
			return str.trim();
		}
	}
	private String checkNull(String str)
	{
		if (str == null)
		{
			return "";
		} else
		{
			return str.trim();
		}
	}
	
	public String getDateString(String dateCondition,SimpleDateFormat formatter,Calendar cal ) {
        
        if("firstDayOfWeek".equalsIgnoreCase(dateCondition)){
        	int currentDOW = cal.get(Calendar.DAY_OF_WEEK);
            cal.add(Calendar.DAY_OF_YEAR, (currentDOW * -1)+1);
        }
        if("yesterday".equalsIgnoreCase(dateCondition)){
        	cal.add(Calendar.DATE, -1);
        }
        if("lastDayOfWeek".equalsIgnoreCase(dateCondition)){
        	int currentDOW = cal.get(Calendar.DAY_OF_WEEK);
            cal.add(Calendar.DAY_OF_YEAR, (currentDOW * -1)+7);
        }
        if("firstDayOfYear".equalsIgnoreCase(dateCondition)){
        	cal.set(Calendar.DAY_OF_YEAR, 1);
        }
        if("lastDayOfYear".equalsIgnoreCase(dateCondition)){
        	cal.set(Calendar.MONTH, Calendar.DECEMBER);
        	cal.set(Calendar.DAY_OF_MONTH, cal.getActualMaximum(Calendar.DAY_OF_MONTH));
        }
		return formatter.format(cal.getTime());
	}
	public String getcolorDotFromValue(double columnValue,DecimalFormat df){
		
		String valueWithImage = "";
		if(columnValue >= 70)
	     {
			valueWithImage = "<table width = '100%'><tbody><tr><td align=' center' style=' width: 40%; border-style: hidden; '>"+"<img  src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/green.png'/></td><td align='right' style=' width: 56%; border-style: hidden; '>"+" "+dfFormatter(columnValue)+"</td></tr></tbody></table>";
	     }
		else if(columnValue < 70 && columnValue >= 60)	
		 {
			valueWithImage = "<table width = '100%'><tbody><tr><td align=' center' style=' width: 40%; border-style: hidden; '>"+"<img  src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/yellow.png'/></td><td align='right' style=' width: 56%; border-style: hidden; '>"+" "+dfFormatter(columnValue)+"</td></tr></tbody></table>";
		 }
		else if(columnValue < 60)	
		 {
			valueWithImage = "<table width = '100%'><tbody><tr><td align=' center' style=' width: 40%; border-style: hidden; '>"+"<img  src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/red.png'/></td><td align='right' style=' width: 56%; border-style: hidden; '>"+" "+dfFormatter(columnValue)+"</td></tr></tbody></table>";
		 }
		return valueWithImage;
	}
	
	private String dfFormatter(double columnValue)
	{
		DecimalFormat df1 =new DecimalFormat("#.0");
		String average="";
		if(columnValue>0)
		{
			if(columnValue>1)
			{
				average=df1.format(columnValue);
			}
			else
			{
				average = "0"+df1.format(columnValue);
			}
		}
		else
		{
			average=columnValue+"";
		}
		return average;
	}
}
