package ibase.dashboard.sfa.ejb;

import ibase.system.config.ConnDriver;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import javax.ejb.Stateless;
import org.json.simple.JSONObject;

@Stateless
public class TaskTracking  implements TaskTrackingLocal, TaskTrackingRemote
{

	public TaskTracking()
	{
	}

	@SuppressWarnings("unchecked")
	public JSONObject getTask(String dataSourceName, String groupid, String userid) throws RemoteException, ITMException
	{
		JSONObject rowDataPendingTaskJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		try
		{
			conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;
			sql = "SELECT TASK_ID,DESCR, TO_CHAR(TASK_DATE,'DD-MM-YYYY') AS TASK_DATE,PROGRESS,TASK_STATUS,PRIORITY,TASK_ID__PARENT,PLAN_START_DATE,PLAN_END_DATE,( PLAN_END_DATE-PLAN_START_DATE) AS DURATION  FROM  TASK_TRACK WHERE Group_ID = '"+groupid+"' AND User_ID = '"+userid+"'"; 
			
			
			System.out.println("sql is in new Interface =" + sql);
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			int count = 0;
			while (rs.next())
			{
				rowData = new JSONObject();
				rowData.put("id", checkNull(rs.getString("TASK_ID")));
				rowData.put("text",  checkNull(rs.getString("DESCR")));
				rowData.put("start_date", checkNull(rs.getString("TASK_DATE")));
				rowData.put("duration",  checkNull(rs.getString("DURATION")));
				rowData.put("order",  checkNull(rs.getString("TASK_ID")));
				rowData.put("progress", checkNull(rs.getString("PROGRESS")));
				rowData.put("open", checkNull(rs.getString("TASK_STATUS")));
				rowData.put("priority", checkNull(rs.getString("PRIORITY")));
				rowData.put("parent", checkNull(rs.getString("TASK_ID__PARENT")));

				rowDataPendingTaskJson.put(Integer.valueOf(count),rowData);
				count++;
			}
			System.out.println(" rowDataPendingTaskJson is =" + rowDataPendingTaskJson);

		} catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
						rs.close();
					rs = null;
					if (pstmt != null)
						pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :TaskActivity:getTask():" + d.getMessage());
				throw new ITMException(d);
			}
		}

		return rowDataPendingTaskJson;
	}

	private String checkNull(String str)
	{
		if (str == null)
		{
			return "";
		} else
		{
			return str;
		}

	}
}