package ibase.dashboard.crm.ejb;

import ibase.system.config.ConnDriver;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.*;

import java.rmi.RemoteException;
import java.sql.*;

import javax.ejb.*;
import org.json.simple.JSONObject;

@Stateless
public class OpportunityStageInfo implements OpportunityStageInfoLocal,OpportunityStageInfoRemote {

	public OpportunityStageInfo() {

	}
	@SuppressWarnings({ "unchecked"})
	public JSONObject getOpportunityStage(String dataSourceName,
			String loginCode, String empCode) throws RemoteException,
			ITMException {
		JSONObject rowDataBasicJsn = new JSONObject();
		JSONObject rowData = null;
		StringBuffer xmlString = null;
		StringBuffer dataSourceSql = null;
		String sql = "", pstmtDSInput = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		PreparedStatement pstmtDS = null;
		Connection conn = null;
		ConnDriver connection = new ConnDriver();
		String opprName = "", opprType = "", opprDate = "", sconCode = "", opprDescr = "", salesTeam = "",
				currCode = "", opprValue = "", salesProdGrp = "", profitPerc = "", forecastCloseDate = "",
				salesPersonAssign = "", probPercStart = "", probVolumeCurrent = "", stageCode = "", assDate = "",
				commId = "", salesPers = "", opprId = "", prodPerc = "", volume = "", reqType = "", reqDescr = "", 
				remarks = "", probPercCurrent = "", spName = "", stageDescr = "", contactName = "", mobileNo = "",
				emailAddr = "", sorgName = "", sorgCode = "";
		boolean noScrollRequired;
		int count = 0;
		String dbDateFormat = "",applDateFormat = "";
		Date asDate=null,forecastCloserDate=null,oppDate=null;

		try {
			conn = connection.getConnectDB(dataSourceName);
			E12GenericUtility genericUtility = new E12GenericUtility();
			dbDateFormat = genericUtility.getDBDateFormat();
			applDateFormat = genericUtility.getApplDateFormat();

			if (empCode == null || empCode.trim().length() == 0)
			{
				empCode = loginCode;
			}
			sql = "SELECT opp.oppr_id," 
					+ "opp.oppr_name,"
					+ "opp.oppr_type,"
					+ "opp.oppr_date as new_oppr_date,"
					+ "opp.scon_code,"
					+ "opp.sorg_code,"
					+ "opp.oppr_descr,"
					+ "opp.sales_team,"
					+ "opp.curr_code,"
					+ "opp.oppr_value,"
					+ "opp.sales_prod_grp,"
					+ "opp.profit_perc,"
					+ "opp.forecast_close_date  as new_forecast_close_date,"
					+ "opp.sales_person_assign,"
					+ "opp.prob_perc_start,"
					+ "opp.prob_volume_current,"
					+ "opp.stage_code,"
					+ "opass.ass_date  as new_ass_date,"
					+ "opass.comm_id,"
					+ "opass.prod_perc,"
					+ "opass.volume,"
					+ "opass.req_type,"
					+ "opass.req_descr,"
					+ "opass.remarks,"
					+ "opass.prob_perc_current,"
					+ "sales.sp_name,"
					+ "stage.descr as stage_descr,"
					+ "(contact.first_name||' '||case when contact.last_name is null or length(trim(contact.last_name)) = 0 then '' else trim(contact.last_name) end) as contact_name,"
					+ "contact.mobile_no,"
					+ "contact.email_addr,"
					+ "org.sorg_name "
					+ "FROM opportunity opp "
					+ "INNER JOIN oppr_assesment opass "
					+ "ON opp.oppr_id = opass.oppr_id "
					+ "INNER JOIN sales_pers sales "
					+ "ON sales.sales_pers = opass.sales_pers "
					+ "INNER JOIN sales_stage stage "
					+ "ON stage.stage_code = opp.stage_code "
					+ "INNER JOIN strg_contact contact "
					+ "ON contact.scon_code = opp.scon_code "
					+ "INNER JOIN strg_org org "
					+ "ON org.sorg_code = opp.sorg_code "
					+ "where opass.ass_date >= ADD_MONTHS(trunc(SYSDATE) , -40) "
					+ "and (opass.oppr_id , opass.ass_date) in (SELECT oppr_id,max(ass_date) FROM oppr_assesment opass1 where opass1.oppr_id = opass.oppr_id group by opass1.oppr_id)" ;

			dataSourceSql = new StringBuffer(sql);

			pstmtDSInput = "";
			
			if(empCode.equalsIgnoreCase("TEAM")){
				dataSourceSql.append(" AND sales.emp_code in (select emp_code from employee start with emp_code = ? connect by prior emp_code = report_to)  order by oppr_date,ass_date");
				pstmtDSInput = loginCode;
			}else{
				dataSourceSql.append(" AND sales.emp_code = ? order by oppr_date,ass_date");
				pstmtDSInput = empCode;
			}

			sql = dataSourceSql.toString();
			pstmtDS = conn.prepareStatement(sql);
			pstmtDS.setString(1, pstmtDSInput);

			rs = pstmtDS.executeQuery();

			while (rs.next()) {
				count++;
				if(count == 1){
					xmlString = new StringBuffer(
							"<table class='mtBackgroundWhite' border='' style='width: 100%;'><tbody><tr>"
									+ "<th class='mtBackgroundWhite' style='width: 12%;'>Sales Person</th>"
									+ "<th class='mtBackgroundWhite' style='width: 10%;'>Contact Person</th>"
									+ "<th class='mtBackgroundWhite' style='width: 20%;'>Opportunity</th>"
									+ "<th class='mtBackgroundWhite' style='width: 25%;'>Stage Detail</th>"
									+ "</tr>");
				}

				opprId = checkNull(rs.getString("oppr_id"));
				opprName = checkNull(rs.getString("oppr_name"));
				opprType = checkNull(rs.getString("oppr_type"));
				oppDate = rs.getDate("new_oppr_date");
				sconCode = checkNull(rs.getString("scon_code"));
				sorgCode = checkNull(rs.getString("sorg_code"));
				opprDescr = checkNull(rs.getString("oppr_descr"));
				salesTeam = checkNull(rs.getString("sales_team"));
				currCode = checkNull(rs.getString("curr_code"));
				opprValue = checkNull(rs.getString("oppr_value"));
				salesProdGrp = checkNull(rs.getString("sales_prod_grp"));
				profitPerc = checkNull(rs.getString("profit_perc"));
				forecastCloserDate = rs.getDate("new_forecast_close_date");
				salesPersonAssign = checkNull(rs.getString("sales_person_assign"));
				probPercStart = checkNull(rs.getString("prob_perc_start"));
				probVolumeCurrent = checkNull(rs.getString("prob_volume_current"));
				stageCode = checkNull(rs.getString("stage_code"));
				asDate = rs.getDate("new_ass_date");
				commId = checkNull(rs.getString("comm_id"));
				prodPerc = checkNull(rs.getString("prod_perc"));
				volume = checkNull(rs.getString("volume"));
				reqType = checkNull(rs.getString("req_type"));
				reqDescr = checkNull(rs.getString("req_descr"));
				remarks = checkNull(rs.getString("remarks"));
				probPercCurrent = checkNull(rs.getString("prob_perc_current"));
				spName = checkNull(rs.getString("sp_name"));
				stageDescr = checkNull(rs.getString("stage_descr"));
				contactName = checkNull(rs.getString("contact_name"));
				mobileNo = checkNull(rs.getString("mobile_no"));
				emailAddr = checkNull(rs.getString("email_addr"));
				sorgName = checkNull(rs.getString("sorg_name"));

				String newAsDate = (asDate != null)?genericUtility.getValidDateString(asDate.toString(),dbDateFormat,applDateFormat):null;
				String newForecastCloserDate = (forecastCloserDate != null)?genericUtility.getValidDateString(forecastCloserDate.toString(),dbDateFormat,applDateFormat):null;
				String newOppDate = (oppDate != null)?genericUtility.getValidDateString(oppDate.toString(),dbDateFormat,applDateFormat):null;

				xmlString.append("<tr> <td class= 'cardHtmlTableBodyAlignLft' rowspan='5' style='text-align: center;'>" + spName+ "</td>"
						+ "<td class= 'cardHtmlTableBodyAlignLft'>" + contactName + "</td> "
						+ "<td class= 'cardHtmlTableBodyAlignLft'> Date:" + newOppDate + "</td>"
						+ "<td class= 'cardHtmlTableBodyAlignLft'>As on: " + newAsDate + "</td> </tr> <tr>"
						+ "<td class= 'cardHtmlTableBodyAlignLft' style='border-top: 1px solid transparent;'><img src='../webitm/images/Standard/tele-1-1.ico' style='width:10px;height:10px;'> " + mobileNo + "</td> "
						+ "<td class= 'cardHtmlTableBodyAlignLft' style='border-top: 1px solid transparent;'>Name:" + opprName + "</td>"
						+ "<td class= 'cardHtmlTableBodyAlignLft' style='border-top: 1px solid transparent;'>Stage:" + stageDescr + "</td> </tr> <tr> "
						+ "<td class= 'cardHtmlTableBodyAlignLft' rowspan='3' style='vertical-align:top;border-top: 1px solid transparent;'>" + emailAddr + "</td>"
						+ "<td class= 'cardHtmlTableBodyAlignLft' rowspan='3' style='vertical-align:top;border-top: 1px solid transparent;'>Detail:" + opprDescr + "</td>"
						+ "<td class= 'cardHtmlTableBodyAlignLft' style='border-top: 1px solid transparent;'>Forecast Close Date:" + newForecastCloserDate + "</td> </tr>"
						+ "<tr> <td class= 'cardHtmlTableBodyAlignLft' style='border-top: 1px solid transparent;'>Value:" + opprValue + "</td> </tr>"
						+ "<tr> <td cddlass= 'cardHtmlTableBodyAlignLft' style='border-top: 1px solid transparent;'>Probabilty Percentage:" + prodPerc + "</td>" + "</tr>");

			}
			if (rs != null) {
				rs.close();
				rs = null;
			}
		    	if (pstmtDS != null) {
				pstmtDS.close();
				pstmtDS = null;
			}

			if(count == 0)
			{
				xmlString = new StringBuffer("<table  id='htmlTable' cellpadding='2'"
						+"align='center'><tbody><tr><td align = 'center' class='gwt-ScrollTable'>" 
						+"NO Data Found</td></tr>");
				noScrollRequired = true;
			}
			xmlString.append("</tbody></table>");
			System.out.println("::::[ "+xmlString+" ]");
			rowData = new JSONObject();
			rowData.put("xmlString", xmlString.toString());
			rowDataBasicJsn.put(0, rowData);

		} catch (Exception e) {
			e.printStackTrace();
			System.out.println("Exception in Opportunity Dashboard :" + e.getMessage());

		} finally {
			try {

				if (conn != null) {
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d) {
				d.printStackTrace();
				try {
					throw new ITMException(d);
				} catch (ITMException e) {
					e.printStackTrace();
				}
			}
		}
		return rowDataBasicJsn;
	}

	private String checkNull(String str) {
		if (str == null) {
			return "";
		} else {
			return str.trim();
		}
	}
}