package ibase.webitm.ejb.mfg;
 
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import org.w3c.dom.Document;

@javax.ejb.Stateless
public class BomPostSave extends ValidatorEJB implements BomPostSaveLocal,BomPostSaveRemote
{
	public String postSave(String xmlString,String tranId,String editFlag, String xtraParams,Connection conn) throws RemoteException,ITMException
	{

		System.out.println("------------ postSave method called-----------------tranId : "+ tranId);		
		Document dom = null;
		String errString="";
		
		try
		{
			if (xmlString != null && xmlString.trim().length() > 0)
			{
				dom = parseString(xmlString);				
				errString = postSave(dom,tranId,editFlag,xtraParams,conn);
			}
			
		}
		catch(Exception e)
		{
			System.out.println("Exception : BomPostSave : postSave : ==>\n"+e.getMessage());
			throw new ITMException(e);
		}		
		return errString;
	}
	
	public String postSave(Document dom,String tranId,String editflag,String xtraParams,Connection conn)
	{
		System.out.println("post save dom data1 ---------------:"+dom);
		String chgTerm = "", chgUser = "", sql = "", error = "";
		int cnt1 = 0;
		GenericUtility genericUtility = GenericUtility.getInstance(); 
				 
		PreparedStatement pstmt = null,pstmt1=null;
		ResultSet rs=null;
		try
		{
			tranId=genericUtility.getColumnValue("bom_code",dom);
			chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "chgTerm");
			chgUser = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			
			sql = "update bom set chg_date = sysdate, chg_term = ?, chg_user = ? where bom_code = ?";
			pstmt1 = conn.prepareStatement(sql);
			pstmt1.setString(1, chgTerm);
			pstmt1.setString(2, chgUser);
			pstmt1.setString(3, tranId);
			cnt1 = pstmt1.executeUpdate();
			System.out.println(">>>>>>>successfully updated record bom post save cnt1:" + cnt1);
			conn.commit();
		}catch(Exception e)
		{
			try {
				System.out.println(">>>>>>>>>>>>In catch Before rollback>>>");
				conn.rollback();
			} catch (SQLException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
				error=e1.getMessage();
			}
			System.out.println("Exception ::"+e);
			e.printStackTrace();
			error=e.getMessage();
            
		}	
		finally
		{
			try {
				System.out.println(">>>>>>>>>>>>In finally Before Commit>>>");
				pstmt1.close();
				pstmt1 = null;
			} catch (SQLException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
				error=e.getMessage();
			}		
		}
		
		return error;
		
	}
	
}
