package ibase.webitm.utility.wms;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;

import org.w3c.dom.Document;

import ibase.planner.utility.ITMException;
import ibase.scheduler.utility.interfaces.Schedule;
import ibase.system.config.ConnDriver;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.ejb.wms.WaveGenerationPrc;
import ibase.utility.E12GenericUtility;

public class WaveGenSchedule implements Schedule
{
	public String schedule(HashMap map)throws Exception
	{
		return "";
	}
	
	@Override
	public String schedulePriority(String arg0) throws Exception {
		// TODO Auto-generated method stub
		return null;
	}
	
	public String schedule(String scheduleParamXML)throws ITMException, Exception
	{
		System.out.println("scheduleParamXML Thoug I am testing diffrently@@----->>["+scheduleParamXML+"]");
		String siteCode="",tranDate="",currDate = "",loginSiteCode="",loginCode="",remoteHost="",sql = "",
				applDateFormat = "";
		E12GenericUtility genericUtility=new E12GenericUtility();
		Document dom = genericUtility.parseString(scheduleParamXML);
		ResultSet rs=null;
		PreparedStatement pstmt=null,pstmt1=null;
		Connection conn = null;
		ConnDriver connDriver = null;
		ibase.utility.UserInfoBean userInfo = null;
		ArrayList<String> sorderList = new ArrayList<String>();
		String errorString = "";
		//E12GenericUtility genericUtility = new E12GenericUtility(); 
		if(dom != null)
		{
			loginSiteCode = genericUtility.getColumnValue("siteCode",dom);
			loginCode = genericUtility.getColumnValue("loginCode",dom);
			remoteHost = genericUtility.getColumnValue("remoteHost",dom);
		}
				
		try
		{
			connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			connDriver = null;		
			applDateFormat = genericUtility.getApplDateFormat();
			Calendar currentDate = Calendar.getInstance();
			SimpleDateFormat simpleDateFormat = new SimpleDateFormat(applDateFormat);
			tranDate = simpleDateFormat.format(currentDate.getTime());
			userInfo = new ibase.utility.UserInfoBean(scheduleParamXML);
			String xtraParams= getXtraParams( userInfo );			
			
			errorString = waveGeneration(xtraParams,applDateFormat,loginSiteCode,conn);
			System.out.println("errorStringAfter waveGeneration@@.......................["+errorString+"]");
			
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			if(rs!=null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt !=null)
			{
				pstmt.close();
				pstmt = null;
			}
			//Changed by wasim on 02-08-2016 to close the connection [Start]
			if(conn !=null)
			{
				conn.close();
				conn = null;
			}
			//Changed by wasim on 02-08-2016 to close the connection [End]
		}
		return errorString;
	}
	public String waveGeneration(String xtraParams,String applDateFormat,String loginSiteCode, Connection conn) throws ITMException,Exception
	{
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		String dueDateStr = "";
		StringBuffer xmlString = null;	
		DistCommon dComm = new DistCommon();
		String varValue = "";
		try
		{
			E12GenericUtility genericUtility = new E12GenericUtility();
			Calendar currentDate = Calendar.getInstance();
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			dueDateStr = sdf.format(currentDate.getTime());
			System.out.println("datestring@@--------->> : "+dueDateStr + " loginSiteCode--->>["+loginSiteCode+"]");
			varValue = dComm.getDisparams("999999","WAVE_PRINTER",conn); //Added by Manish for enable printer name on 24/02/16
			xmlString = new StringBuffer();
			xmlString.append( "<DocumentRoot>" );
			xmlString.append( "<description>").append("Datawindow Root").append( "</description>\r\n" );
			xmlString.append( "<group0>\r\n" );
			xmlString.append( "<description>").append("Group0 description").append( "</description>\r\n" );
			xmlString.append( "<Header0>\r\n" );
			xmlString.append( "<description>\r\n" ).append("Header0 members").append( "</description>\r\n" );
			xmlString.append( "<Detail1 dbID=\"\" domID=\"1\" objContext=\"1\" objName=\"wavegen\">\r\n" );
			xmlString.append( "<attribute pkNames=\"\" selected=\"N\" status=\"N\" updateFlag=\"A\"/>\r\n" );

			xmlString.append( "<site_code><![CDATA[" ).append(loginSiteCode).append( "]]></site_code>\r\n" );

			xmlString.append( "<default_qty_flag><![CDATA[" ).append( "Y" ).append( "]]></default_qty_flag>\r\n" );
			xmlString.append( "<item_ser__from><![CDATA[" ).append( "00" ).append( "]]></item_ser__from>\r\n" );

			xmlString.append("<item_ser__to><![CDATA[").append("ZZ").append("]]></item_ser__to>\r\n");
			xmlString.append("<item_code__from><![CDATA[").append("00").append("]]></item_code__from>\r\n");

			xmlString.append( "<item_code__to ><![CDATA[" ).append( "ZZ" ).append( "]]></item_code__to>\r\n" );
			xmlString.append( "<cust_code__dlv__from  ><![CDATA[" ).append( "00").append( "]]></cust_code__dlv__from>\r\n" );
			xmlString.append( "<cust_code__dlv__to><![CDATA[" ).append("ZZ").append( "]]></cust_code__dlv__to>\r\n" );

			xmlString.append( "<cust_code__from ><![CDATA[" ).append("00").append( "]]></cust_code__from>\r\n" );
			xmlString.append("<cust_code__to ><![CDATA[").append("ZZ").append("]]></cust_code__to>\r\n");

			xmlString.append("<sale_order__from><![CDATA[").append("00").append("]]></sale_order__from>\r\n");
			xmlString.append("<sale_order__to><![CDATA[").append("ZZ").append("]]></sale_order__to>\r\n");

			xmlString.append("<due_date__from><![CDATA[").append(dueDateStr).append("]]></due_date__from>\r\n");
			xmlString.append("<due_date__to><![CDATA[").append(dueDateStr).append("]]></due_date__to>\r\n");

			xmlString.append("<wave_mode><![CDATA[").append("P").append("]]></wave_mode>\r\n");
			xmlString.append("<single_lot><![CDATA[").append("N").append("]]></single_lot>\r\n");
			xmlString.append("<master_pack_allow><![CDATA[").append("N").append("]]></master_pack_allow>\r\n");
			xmlString.append("<active_pick_allow><![CDATA[").append("Y").append("]]></active_pick_allow>\r\n");
			xmlString.append("<stock_to_dock_allow><![CDATA[").append("N").append("]]></stock_to_dock_allow>\r\n");
			/*xmlString.append("<printer_name><![CDATA[").append("N").append("]]></printer_name>\r\n");
			xmlString.append("<print_label><![CDATA[").append("N").append("]]></print_label>\r\n");*/
			
			//Changed by Manish for enable printer name on 24/02/16 [Start]
			xmlString.append("<printer_name><![CDATA[").append(varValue).append("]]></printer_name>\r\n");
			xmlString.append("<print_label><![CDATA[").append("Y").append("]]></print_label>\r\n");
			//Changed by Manish for enable printer name on 24/02/16 [End]
			
			xmlString.append("<parcelpack_allow><![CDATA[").append("Y").append("]]></parcelpack_allow>\r\n");
			xmlString.append("<ship_type><![CDATA[").append("A").append("]]></ship_type>\r\n");
			xmlString.append("<direct_pick_loc><![CDATA[").append("").append("]]></direct_pick_loc>\r\n");
			xmlString.append("<pallet_no><![CDATA[").append("").append("]]></pallet_no>\r\n");
			xmlString.append("<order_type><![CDATA[").append("").append("]]></order_type>\r\n");
			xmlString.append("<remarks><![CDATA[").append("").append("]]></remarks>\r\n");
			xmlString.append("<tran_code><![CDATA[").append("").append("]]></tran_code>\r\n");
			xmlString.append("<tran_name><![CDATA[").append("").append("]]></tran_name>\r\n");
			xmlString.append("<loc_type_parent><![CDATA[").append("").append("]]></loc_type_parent>\r\n");
			xmlString.append("<trans_mode><![CDATA[").append("").append("]]></trans_mode>\r\n");
			xmlString.append( "</Detail1>\r\n" );
			xmlString.append( "</Header0>\r\n" );
			xmlString.append( "</group0>\r\n" );
			xmlString.append( "</DocumentRoot>\r\n" );

			System.out.println("Before waveGeneration xmlString------>>["+xmlString.toString()+"]");
			WaveGenerationPrc prcNew = new WaveGenerationPrc();
			String getData = prcNew.getData(xmlString.toString(), xmlString.toString(), "W_WAVEGEN", xtraParams);
			System.out.println("Return String from WaveGenerationPrc getData---->>["+getData+"]");
			String processData = prcNew.process(xmlString.toString(), getData, "w_wavegen", xtraParams);
			System.out.println("Return String from WaveGenerationPrc process------["+processData+"]");
			//} //end for loop of sorderList

		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			if(rs!=null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt !=null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
	return "";
		
	}
	public String getXtraParams( UserInfoBean userInfoBean )throws Exception
	{
		String XTRA_PARAMS_SEPARATOR = "~~";
		StringBuffer xtraParamsBuff = new StringBuffer();
		xtraParamsBuff.append("loginCode=" + userInfoBean.getLoginCode());
		xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("loginEmpCode=" + userInfoBean.getEmpCode());
		xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("loginSiteCode=" + userInfoBean.getSiteCode());
		xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("entityCode=" + userInfoBean.getEntityCode());
		xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("profileId=" + userInfoBean.getProfileId());
		xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("userType=" + userInfoBean.getUserType());
		xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("runMode=I");
		xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("user_lang=" + userInfoBean.getUserLanguage());
		xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("user_country=" + userInfoBean.getUserCountry());
		xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("charEnc=" + userInfoBean.getCharEnc());		
		xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("termId="+userInfoBean.getRemoteHost());

		String chgTerm = userInfoBean.getRemoteHostName();
		if( chgTerm != null && chgTerm.length() > 15 )
		{
			chgTerm = chgTerm.substring(0, 15);
		}
		else if( chgTerm == null || chgTerm.length() == 0 )
		{
			chgTerm = userInfoBean.getRemoteHost();
		}
		xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("chgTerm=" + chgTerm );
		
		System.out.println("xtraParamsBuff ["+xtraParamsBuff+"]");
		
		return xtraParamsBuff.toString();
	}
	private String checkNull(String input)
	{
		if(input == null)
		{
			return "";
		}
		else
		{
			return input.trim();
		}
	}
		

}
