package ibase.webitm.ejb.mfg;

import ibase.system.config.ConnDriver;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

import javax.ejb.Stateless;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * Session Bean implementation class ProvisionalRelItems
 */
@Stateless
public class ProvisionalRelItems extends ValidatorEJB implements ProvisionalRelItemsRemote, ProvisionalRelItemsLocal {

   
	// Code for Validation
 	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		E12GenericUtility genericUtility = new E12GenericUtility();
		try
		{			
			System.out.println("xmlString ["+xmlString+"]");
			System.out.println("xmlString1 ["+xmlString1+"]");
			System.out.println("xmlString2 ["+xmlString2+"]");
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString); 
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1); 
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2); 
			}
			errString = wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams);
			System.out.println ( "ErrString: " + errString);
		}
		catch(Exception e)
		{
			System.out.println ( "Exception: ProvisionalRelItems: wfValData(String xmlString): " + e.getMessage() + ":" );
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
		}
		System.out.println ( "Returning from ProvisionalRelItems wfValData" );
		return (errString); 
	}
 	
 	
 	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Connection conn = null;
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		int childNodeListLength = 0;
		int count = 0;
		String childNodeName = "";
		String sql = "", siteCode = "", itemCode = "", provRelAllow = "", qcLockReqd = "", errorType = "";
		String fromDate = "", toDate = "", userId = "", lotNoFrom = "", lotNoTo = "";
		String errString = "", errCode = "";
		StringBuffer valueXmlString = new StringBuffer();
		ArrayList<String> errList = new ArrayList<String>();
		ArrayList<String> errFields = new ArrayList<String>();
		StringBuffer errStringXml = new StringBuffer("<?xml version = \"1.0\"?> \r\n <Root> <Errors>");
		E12GenericUtility genericUtility = new E12GenericUtility();
		
		try
		{
			System.out.println( "wfValData called" );
			conn = getConnection();
			userId = getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			int currentFormNo = 0;
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			valueXmlString = new StringBuffer("<?xml version = \"1.0\"?> <Root> <header> <editFlag>");
			valueXmlString.append(editFlag).append("</editFlag> </header>");
			switch(currentFormNo)
			{
			  case 1 :
				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				valueXmlString.append("<Detail1>");
				childNodeListLength = childNodeList.getLength();
				for(int ctr = 0; ctr < childNodeListLength; ctr ++)
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					if ( "site_code".equalsIgnoreCase(childNodeName) )
					{
						siteCode = checkNull(genericUtility.getColumnValue("site_code", dom));
						if ( childNode.getFirstChild() == null )
						{
							if(siteCode == null || siteCode.trim().length() == 0)
							{
								errCode = "NULLSITEC";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
						}
						else
						{
							sql ="SELECT COUNT(*) FROM SITE WHERE SITE_CODE = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, siteCode);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								count = rs.getInt(1);
							}
							rs.close();rs = null;
							pstmt.close();pstmt = null;
							
							System.out.println("count>>"+count);
							if(count == 0)
							{
								errCode = "NVSITEC";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
						}
					}
					if ( "item_code".equalsIgnoreCase(childNodeName) )
					{
						itemCode = checkNull(genericUtility.getColumnValue("item_code", dom));
						if(itemCode == null || itemCode.trim().length() == 0)
						{
							errCode = "NULLITEMC";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
						else
						{
							sql ="SELECT COUNT(*) FROM ITEM WHERE ITEM_CODE = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, itemCode);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								count = rs.getInt(1);
							}
							rs.close();rs = null;
							pstmt.close();pstmt = null;
							
							System.out.println("count>>"+count);
							if(count == 0)
							{
								errCode = "NVITEMC";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
						}
					}
					if ( "prov_rel_allow".equalsIgnoreCase(childNodeName) )
					{
						provRelAllow = checkNull(genericUtility.getColumnValue("prov_rel_allow", dom));
						if(provRelAllow == null || provRelAllow.trim().length() == 0)
						{
							errCode = "NLPRVRELA";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
					}
					if ( "qc_lock_reqd".equalsIgnoreCase(childNodeName) )
					{
						qcLockReqd = checkNull(genericUtility.getColumnValue("qc_lock_reqd", dom));
						if(qcLockReqd == null || qcLockReqd.trim().length() == 0)
						{
							errCode = "NLQCLOCK";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
					}
				}
				valueXmlString.append("</Detail1>");
				break;
				
				case 2:
					parentNodeList = dom.getElementsByTagName("Detail2");
					parentNode = parentNodeList.item(0);
					childNodeList = parentNode.getChildNodes();
					valueXmlString.append("<Detail2>");
					childNodeListLength = childNodeList.getLength();
					for(int ctr = 0; ctr < childNodeListLength; ctr ++)
					{
						childNode = childNodeList.item(ctr);
						childNodeName = childNode.getNodeName();
						if ( "site_code".equalsIgnoreCase(childNodeName) )
						{
							siteCode = checkNull(genericUtility.getColumnValue("site_code", dom));
							if ( childNode.getFirstChild() == null )
							{
								if(siteCode == null || siteCode.trim().length() == 0)
								{
									errCode = "NULLSITEC";
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
								}
							}
							else
							{
								sql ="SELECT COUNT(*) FROM SITE WHERE SITE_CODE = ?";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, siteCode);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									count = rs.getInt(1);
								}
								rs.close();rs = null;
								pstmt.close();pstmt = null;
								
								System.out.println("count>>"+count);
								if(count == 0)
								{
									errCode = "NVSITEC";
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
								}
							}
						}
						if ( "item_code".equalsIgnoreCase(childNodeName) )
						{
							itemCode = checkNull(genericUtility.getColumnValue("item_code", dom));
							if(itemCode == null || itemCode.trim().length() == 0)
							{
								errCode = "NULLITEMC";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
							else
							{
								sql ="SELECT COUNT(*) FROM ITEM WHERE ITEM_CODE = ?";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, itemCode);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									count = rs.getInt(1);
								}
								rs.close();rs = null;
								pstmt.close();pstmt = null;
								
								System.out.println("count>>"+count);
								if(count == 0)
								{
									errCode = "NVITEMC";
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
								}
							}
						}
						if ( "lot_no__from".equalsIgnoreCase(childNodeName) )
						{
							lotNoFrom = checkNull(genericUtility.getColumnValue("lot_no__from", dom));
							if(lotNoFrom == null || lotNoFrom.trim().length() == 0)
							{
								errCode = "NLLOTNOF";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
						}
						if ( "lot_no__to".equalsIgnoreCase(childNodeName) )
						{
							lotNoTo = checkNull(genericUtility.getColumnValue("lot_no__to", dom));
							if(lotNoTo == null || lotNoTo.trim().length() == 0)
							{
								errCode = "NLLOTNOT";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
						}
						if ( "from_date".equalsIgnoreCase(childNodeName) )
						{
							fromDate = checkNull(genericUtility.getColumnValue("from_date", dom));
							if(fromDate == null || fromDate.trim().length() == 0)
							{
								errCode = "NLFRMDT";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
						}
						if ( "to_date".equalsIgnoreCase(childNodeName) )
						{
							toDate = checkNull(genericUtility.getColumnValue("to_date", dom));
							if(toDate == null || toDate.trim().length() == 0)
							{
								errCode = "NLTODT";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
							else
							{
								String effFrom =genericUtility.getColumnValue( "from_date" , dom );
								String validUpto =genericUtility.getColumnValue( "to_date" , dom );
								SimpleDateFormat sdfFormat = new SimpleDateFormat(getApplDateFormat());
								
	                            java.util.Date effFromDate = null;
	                            java.util.Date validUptoDate = null;
	                            effFromDate = sdfFormat.parse(effFrom);
	                            validUptoDate = sdfFormat.parse(validUpto);
	                            
								if (effFromDate.compareTo(validUptoDate) > 0)
								{
									errCode = "INVALDATE";
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
								}
							}
						}
					}
					valueXmlString.append("</Detail2>");
					break;
					
			}
			//END switch
		
			int errListSize = errList.size();
			count = 0;
			String errFldName = null;
			if(errList != null && errListSize > 0)
			{
				for(count = 0; count < errListSize; count ++)
				{
					errCode = errList.get((int) count);
					errFldName = errFields.get((int) count);
					System.out.println("errCode .........." + errCode);
					errString = getErrorString(errFldName, errCode, userId);
					errorType =  errorType(conn , errCode);
					if(errString.length() > 0)
					{
						String bifurErrString = errString.substring(errString.indexOf("<Errors>") + 8,errString.indexOf("<trace>"));
						bifurErrString = bifurErrString +errString.substring(errString.indexOf("</trace>") + 8,errString.indexOf("</Errors>"));
						errStringXml.append(bifurErrString);
						errString = "";
					}
					if(errorType.equalsIgnoreCase("E"))
					{
						break;
					}
				}
				errList.clear();
				errList = null;
				errFields.clear();
				errFields = null;
				errStringXml.append("</Errors> </Root> \r\n");
			}
			else
			{
				errStringXml = new StringBuffer("");
			}

		}	
		catch(Exception e)
		{
			System.out.println("Exception ::" +e);
			e.printStackTrace();
			errCode = "VALEXCEP";
			errString = getErrorString( "", errCode, userId );									
		}
		finally
		{
			try
			{
				if(conn != null)
				{
					if( pstmt != null )
					{
						pstmt.close();
						pstmt = null;
					}
					
					if( rs != null )
					{
						rs.close();
						rs = null;
					}
					conn.close();
				}
				conn = null;
			}
			catch(Exception d)
				{
				  d.printStackTrace();
				}			
			System.out.println(" < LoanAppIC > CONNECTION IS CLOSED");
		}
		System.out.println("ErrString ::" + errString);
		errString = errStringXml.toString();
		return errString;
	}

 	// Code for ItemChange
 	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		E12GenericUtility genericUtility = new E12GenericUtility();
		System.out.println("xmlString ["+xmlString+"]");
		System.out.println("xmlString1 ["+xmlString1+"]");
		System.out.println("xmlString2 ["+xmlString2+"]");
		try
		{
			if (xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString); 
			}
			if (xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1); 
			}
			if (xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2); 
			}
			errString = itemChanged( dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams );
			System.out.println ( "ErrString :" + errString);
		}
		catch (Exception e)
		{
			System.out.println ( "Exception :ProvisionalRelItems :itemChanged(String,String):" + e.getMessage() + ":" );
			errString = genericUtility.createErrorString(e);
		}
		System.out.println ( "returning from ProvisionalRelItems itemChanged" );
		return errString;
	}
 	
 	public String itemChanged( Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams ) throws RemoteException,ITMException
	{
 		System.out.println("@@@@@@@ LoanAppIC itemChanged called");
 		StringBuffer valueXmlString = new StringBuffer();
 		String sql = "", siteCode="", siteDescr="", itemCode="", itemDescr="";
 		int currentFormNo = 1;
 		Connection conn = null;
 		PreparedStatement pstmt = null;
 		ResultSet rs = null;
 		E12GenericUtility genericUtility = new E12GenericUtility();
 		try 
 		{
 			conn = getConnection();
 			conn.setAutoCommit(false);
 			if (objContext != null && objContext.trim().length() > 0)
 				currentFormNo = Integer.parseInt(objContext);

 			currentColumn = currentColumn == null ? "" : currentColumn.trim();
 			System.out.println("currentColumn : " + currentColumn);		
 			
 			valueXmlString = new StringBuffer("<?xml version=\"1.0\"?><Root><header><editFlag>");
 			valueXmlString.append(editFlag).append("</editFlag></header>");
 			System.out.println("current form no: " + currentFormNo);
 			System.out.println("dom:::::::::: : " + genericUtility.serializeDom(dom));
 			System.out.println("dom11111111111111:::::::::: : " + genericUtility.serializeDom(dom1));
 			System.out.println("dom222222222222222:::::::::: : " + genericUtility.serializeDom(dom2));

 			switch (currentFormNo) 
 			{
 			   case 1:
	 				valueXmlString.append("<Detail1>");
	 				if ("itm_default".equalsIgnoreCase(currentColumn))
	 				{
	 					System.out.println("itm_default :::::::::");
	 					siteCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSite");
	 					siteCode = siteCode == null ? "" : siteCode.trim();
	 					sql = "SELECT DESCR FROM SITE WHERE SITE_CODE =?";
	 					pstmt = conn.prepareStatement(sql);
	 					pstmt.setString(1, siteCode);
	 					rs = pstmt.executeQuery();
	 					if (rs.next())
	 					{
	 						siteDescr = rs.getString(1);
	 					}
	 					rs.close();
	 					rs = null;
	 					pstmt.close();
	 					pstmt = null;
	
	 					siteDescr = siteDescr == null ? "" : siteDescr.trim();
	 					valueXmlString.append("<site_code>").append("<![CDATA["+siteCode+"]]>").append("</site_code>");
	 					valueXmlString.append("<site_descr>").append("<![CDATA["+siteDescr+"]]>").append("</site_descr>");
	 					valueXmlString.append("<prov_rel_allow >").append("<![CDATA["+'0'+"]]>").append("</prov_rel_allow>");
	 					valueXmlString.append("<qc_lock_reqd >").append("<![CDATA["+'Y'+"]]>").append("</qc_lock_reqd>");
	 				} 
	 				else if (currentColumn.trim().equalsIgnoreCase("item_code")) 
	 				{
					    itemCode = genericUtility.getColumnValue("item_code", dom);
					    itemCode = itemCode == null ? "" : itemCode.trim();
						sql = "SELECT DESCR FROM ITEM WHERE ITEM_CODE =?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, itemCode);
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							itemDescr = rs.getString(1);
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
	
						itemDescr = itemDescr == null ? "" : itemDescr.trim();
						valueXmlString.append("<item_descr>").append("<![CDATA["+itemDescr+"]]>").append("</item_descr> \r\n");
	
	 				 }
	 				else if (currentColumn.trim().equalsIgnoreCase("site_code")) 
					{
						siteCode = genericUtility.getColumnValue("site_code", dom);
						siteCode = siteCode == null ? "" : siteCode.trim();
						sql = "SELECT DESCR FROM SITE WHERE SITE_CODE =?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, siteCode);
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							siteDescr = rs.getString(1);
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
					
						siteDescr = siteDescr == null ? "" : siteDescr.trim();
						valueXmlString.append("<site_descr>").append("<![CDATA["+siteDescr+"]]>").append("</site_descr> \r\n");
					}
	 				valueXmlString.append("</Detail1>\r\n");
	 				break;
 			  case 2 : 
	 			    valueXmlString.append("<Detail2>");
	 			    if ("itm_default".equalsIgnoreCase(currentColumn))
	 				{
	 					System.out.println("itm_default :::::::::");
	 					siteCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSite");
	 					siteCode = siteCode == null ? "" : siteCode.trim();
	 					sql = "SELECT DESCR FROM SITE WHERE SITE_CODE =?";
	 					pstmt = conn.prepareStatement(sql);
	 					pstmt.setString(1, siteCode);
	 					rs = pstmt.executeQuery();
	 					if (rs.next())
	 					{
	 						siteDescr = rs.getString(1);
	 					}
	 					rs.close();
	 					rs = null;
	 					pstmt.close();
	 					pstmt = null;
	
	 					siteDescr = siteDescr == null ? "" : siteDescr.trim();
	 					valueXmlString.append("<site_descr>").append("<![CDATA["+siteDescr+"]]>").append("</site_descr>");
	 					
	 					itemCode = genericUtility.getColumnValue("item_code", dom);
	 					sql = "SELECT DESCR FROM ITEM WHERE ITEM_CODE = ?";
	 					pstmt = conn.prepareStatement(sql);
	 					pstmt.setString(1, itemCode);
	 					rs = pstmt.executeQuery();
	 					if (rs.next())
	 					{
	 						itemDescr = rs.getString("DESCR");
	 					}
	 					rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
						itemDescr = itemDescr == null ? "" : itemDescr.trim();
	 					valueXmlString.append("<item_descr>").append("<![CDATA[" + itemDescr + "]]>").append("</item_descr>");
	 				} 
	 			    if("item_code".equalsIgnoreCase(currentColumn))
	 				{
	 					System.out.println( "item_code :: item change =========== case 2 " );
	 					itemCode = genericUtility.getColumnValue("item_code", dom);
	 					sql = "SELECT DESCR FROM ITEM WHERE ITEM_CODE = ?";
	 					pstmt = conn.prepareStatement(sql);
	 					pstmt.setString(1, itemCode);
	 					rs = pstmt.executeQuery();
	 					if (rs.next())
	 					{
	 						itemDescr = rs.getString("DESCR");
	 					}
	 					rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
						itemDescr = itemDescr == null ? "" : itemDescr.trim();
	 					valueXmlString.append("<item_descr>").append("<![CDATA[" + itemDescr + "]]>").append("</item_descr>");
	 				}
	 			    else if (currentColumn.trim().equalsIgnoreCase("site_code")) 
					{
						siteCode = genericUtility.getColumnValue("site_code", dom);
						siteCode = siteCode == null ? "" : siteCode.trim();
						sql = "SELECT DESCR FROM SITE WHERE SITE_CODE =?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, siteCode);
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							siteDescr = rs.getString(1);
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
					
						siteDescr = siteDescr == null ? "" : siteDescr.trim();
						valueXmlString.append("<site_descr>").append("<![CDATA["+siteDescr+"]]>").append("</site_descr> \r\n");
					}
		        valueXmlString.append("</Detail2>\r\n");	
		        break;
 			}
 			valueXmlString.append("</Root>\r\n");
 		}   
 		catch(Exception e)
 		{
 			System.out.println("Exception ::"+e.getMessage());
 		}	
 		finally
 		{
 			try
 			{
 				conn.close();
 				conn = null;
 			}
 			catch(Exception s){}
 		}
 		return valueXmlString.toString();
	}
		
 	private String checkNull(String input)    
    {
        if (input == null)
        {
            input="";
        }
        return input;
    }
 	
 	private String errorType(Connection conn , String errorCode)
	{
		String msgType = "";
		PreparedStatement pstmt = null ; 
		ResultSet rs = null;
		try
		{                        
			String  sql = "SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO = ?";
			pstmt = conn.prepareStatement(sql);                        
			pstmt.setString(1,errorCode);                        
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				msgType = rs.getString("MSG_TYPE");
			}                        
		}
		catch(Exception ex)
		{
			ex.printStackTrace();
		}                
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}                
		return msgType;
	}
}


