package ibase.webitm.ejb.gst;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;

@javax.ejb.Stateless
public class GenerateGSTR3BIC extends ValidatorEJB implements GenerateGSTR3BICRemote, GenerateGSTR3BICLocal
{
	E12GenericUtility e12GenericUtility = new E12GenericUtility();
	ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();

	public String wfValData() throws RemoteException, ITMException
	{
		return "";
	}

	public String wfValData(String currXmlDataStr, String hdrXmlDataStr, String allXmlDataStr, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document currDom = null;
		Document hdrDom = null;
		Document allDom = null;
		String errString = null;
		
		try
		{
			System.out.println("Inside GstDataIC wfValData");
			if(currXmlDataStr != null && currXmlDataStr.trim().length()!=0)
			{
				currDom = e12GenericUtility.parseString(currXmlDataStr);
			}
			if(hdrXmlDataStr != null && hdrXmlDataStr.trim().length()!=0)
			{
				hdrDom = e12GenericUtility.parseString(hdrXmlDataStr);
			}
			if(allXmlDataStr != null && allXmlDataStr.trim().length()!=0)
			{
				allDom = e12GenericUtility.parseString(allXmlDataStr);
			}
			errString = wfValData( currDom, hdrDom, allDom, objContext, editFlag, xtraParams );

		}//end of try
		catch(Exception e)
		{
			errString = e12GenericUtility.createErrorString(e);
			e.printStackTrace();
			throw new ITMException(e);
		}//end of catch
		
		return errString ;
	}//end of wfvalData() of xml string

	public String wfValData(Document currDom, Document hdrDom, Document allDom, String objContext, String editFlag,String xtraParams) throws RemoteException, ITMException
	{
		String errString = "",sql = "";
		ResultSet rs = null;
		Connection conn = null;
		PreparedStatement pstmt = null;
		
		NodeList parentList = null;
		NodeList childList = null;
		int noOfChilds = 0;
		String childNodeName = "";
		Node childNode =null;
		boolean isNumber = true;
		String columnValue = "";
		int currentFormNo = 0,count = 0;
		
		try
		{
			conn = getConnection();
						
			String userID = e12GenericUtility.getValueFromXTRA_PARAMS( xtraParams, "LoginCode" );
	
			if ( objContext != null && objContext.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt( objContext );
			}

			parentList = currDom.getElementsByTagName("Detail" + currentFormNo );
			childList = parentList.item( 0 ).getChildNodes();
			noOfChilds = childList.getLength();
			for (int ctr = 0; ctr < noOfChilds; ctr++)
			{
				childNode = childList.item( ctr );
				childNodeName = childNode.getNodeName();
				
				System.out.println("childNodeName"+childNodeName);
				
				if ( childNode != null && childNode.getFirstChild() != null )
				{
					columnValue = childNode.getFirstChild().getNodeValue();
				}
				if ( "prd_code".equalsIgnoreCase( childNodeName ) )
				{
					if (childNode.getFirstChild()==null)
					{
					   errString = getErrorString("prd_code","VTBLNKPRD",userID);
					   break;
					}
					else
					{
						isNumber = checkNumeric( columnValue );
						System.out.println("isNumber =["+isNumber+"]");
						if ( !isNumber )
						{
							errString = getErrorString("prd_code","NOTANUMBR1",userID);
							break;
						}
						
						/*sql = " SELECT COUNT(*) AS CNT FROM PERIOD WHERE TO_CHAR(TO_DATE(code,'yyyymm'),'mmyyyy') = ? ";
						pstmt = connObject.prepareStatement(sql);
						pstmt.setString(1, columnValue);
						rSet = pstmt.executeQuery();
						if (rSet.next())
						{
							count = rSet.getInt(1);
						}
						if (rSet != null) 
						{					
							rSet.close();rSet = null;
						}
						if (pstmt != null ) 
						{					
							pstmt.close();pstmt = null;
						}*/
						
						/*if(count == 0)
						{
							errString =  itmDBAccessEJB.getErrorString("","VMPRDNTDF","","",connObject);
							break;
						}*/
					}
				}
				if ("gst_type".equalsIgnoreCase( childNodeName ) )
				{
					if (childNode.getFirstChild()==null)
					{
					   errString = getErrorString("gst_type","VTBLNKTYPE",userID);
					   break;
					}
				}
			}
		}	
		catch(Exception e)
		{
			System.out.println("Exception in GstDataIC  wfValData == >"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if( conn != null && ! conn.isClosed() )
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}//end of catch
		} //end of finally
		return (errString);
	}

	public String itemChanged(String xmlString, String xmlString1,String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String valueXmlString = "";
		try
		{   
			System.out.println("Inside GenerateGSTR3BIC itemChanged");
			
			if (xmlString != null && xmlString.trim().length()!=0)
			{
				dom = e12GenericUtility.parseString(xmlString); 
			}
			if (xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = e12GenericUtility.parseString(xmlString1); 
			}
			if (xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = e12GenericUtility.parseString(xmlString2); 
			}
			
			valueXmlString = itemChanged( dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams );
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
        return valueXmlString;
	}
	
	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		StringBuffer valueXmlString = new StringBuffer();
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		int currentFormNo = 0 ;
		String sql = "";
		String prdCode = "", gstin = "", siteCode = "", currDateStr = "";
		Calendar calendar = null;
		
		try
		{   
			conn = getConnection();
			calendar = Calendar.getInstance();
			
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			
			valueXmlString = new StringBuffer("<?xml version=\"1.0\"?><Root><header><editFlag>");
			valueXmlString.append(editFlag).append("</editFlag></header>");
			
			System.out.println("currentColumn["+currentColumn+"] && currentFormNo["+currentFormNo+"]");

			switch(currentFormNo)
			{
				case 1 :
				{
					valueXmlString.append("<Detail1>\r\n");
				    if(currentColumn.trim().equalsIgnoreCase("itm_default"))
					{
				    	siteCode = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
				    							
				    	sql  = "SELECT REG_NO FROM SITEREGNO SREG, FINENT FI WHERE REF_CODE = 'GSTIN_NO' AND SREG.FIN_ENTITY = FI.FIN_ENTITY AND SITE_CODE = ?";
				    	pstmt = conn.prepareStatement(sql);
				    	pstmt.setString(1, siteCode);
				    	
				    	rs = pstmt.executeQuery();
				    	
				    	if(rs.next())
				    	{
				    		gstin = rs.getString("REG_NO");
				    	}
				    	if(rs!=null)
				    	{
				    		rs.close();
				    		rs = null;
				    	}
				    	if(pstmt!=null)
				    	{
				    		pstmt.close();
				    		pstmt = null;
				    	}
				    	
				    	calendar.setTime(new Date());
						calendar.add(Calendar.MONTH, -1);
						
						SimpleDateFormat sdf = new SimpleDateFormat(e12GenericUtility.getApplDateFormat());
						
						currDateStr = sdf.format(calendar.getTime());
						
						System.out.println("currDateStr["+currDateStr+"]");
						
						sql = "SELECT TO_CHAR(TO_DATE(CODE,'yyyymm'),'mmyyyy') AS CODE FROM PERIOD WHERE ? BETWEEN FR_DATE AND TO_DATE";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, currDateStr);
						rs = pstmt.executeQuery();
						
						if(rs.next())
						{
							prdCode = rs.getString("CODE");
						}
						if(rs != null)
						{
							rs.close();
							rs = null;
						}
						if(pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
				    	
						valueXmlString.append("<prd_code><![CDATA["+prdCode+"]]></prd_code>");
						valueXmlString.append("<gstin><![CDATA["+gstin+"]]></gstin>");
	                }
					valueXmlString.append("</Detail1>");
				}     	
	            break;
			} 
			
			valueXmlString.append("</Root>");
		}
		catch(Exception e)	
		{
			System.out.println("GenerateGSTR3BIC.itemChanged()["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(pstmt != null)
				{	
					pstmt.close();pstmt = null;
				}	
				if(rs != null)
				{	
					rs.close();rs = null;
				}	
				if(conn != null)
				{	
					conn.close();conn = null;
				}
			}
			catch(Exception d)
			{
				d.printStackTrace();
			}			
		}
		return valueXmlString.toString();
	}
	
	private boolean checkNumeric( String noOfLabel ) throws Exception
	{
		char[] cArray = noOfLabel.toCharArray();
		boolean isNumber = true;
		for(int i = 0; i < cArray.length;i++) 
		{
			if( !Character.isDigit(cArray[i]) ) 
			{
				isNumber = false;
			}
		}
		return isNumber;
	}
}
