import { Pipe, PipeTransform } from "@angular/core";
import { DomSanitizer } from "@angular/platform-browser";

export { VisAsstResponseComponent } from './vis_asst_response/vis_asst_response.component'
export { VisAsstResponseCard } from './vis_asst_response_card/vis_asst_response_card.component'
export { VisAsstResponseTable } from './vis_asst_response_table/vis_asst_response_table.component'
export { VisAsstResponseText } from './vis_asst_response_text/vis_asst_response_text.component'

@Pipe({name: 'safeHtml'})
export class SafeHtmlPipe implements PipeTransform {
    constructor(private sanitized: DomSanitizer) {
    }
    
    transform(value: string) {
        return this.sanitized.bypassSecurityTrustHtml(value);
    }
}