import { Component, OnInit, Input, Output, EventEmitter, ChangeDetectorRef } from '@angular/core';

import { SearchComponent } from '../searchComponent.service';
import { AppDateAdapter, APP_DATE_FORMATS } from '../date.adapter';
import { DateAdapter, MAT_DATE_FORMATS } from '@angular/material/core';
import { DatePipe } from '@angular/common';

@Component({
  selector: 'add-filter',
  templateUrl: './add-filter.component.html',
  styleUrls: ['./add-filter.component.css'],
  providers: [
    {
      provide: DateAdapter, useClass: AppDateAdapter
    },
    {
      provide: MAT_DATE_FORMATS, useValue: APP_DATE_FORMATS
    },
    DatePipe
  ]
})
export class AddFilterComponent implements OnInit {
  @Input('isPermntFilter') isPermntFilter: boolean = false;
  @Input('colInfoNodeList') colInfoNodeList!: NodeListOf<Element>;
  @Input('filterNodeList') filterNodeList!: NodeList;
  @Input('objectName') objectName!: string;

  defaultOpt!: any;
  permntFilterNamesArrLst:any = [];
  allFltrNameFltrExprHMap:any = {};
  selctedOperandLinkHMap:any = {};
  selectedValuesLinkHMap = {};
  //Added By Sai
  filterCheckBoxFlag!: boolean;
  filterCondChkBxTitle!: string;
  //From custom filter
  @Input('filterValueArrLst') filterValueArrLst!: any[];
  @Input('fieldNameArrLst') fieldNameArrLst: any;
  @Input('operatorNameArrLst') operatorNameArrLst!: any[];
  @Input('promtValuOptArr') promtValuOptArr!: any[];
  @Input('codtnValueArr') codtnValueArr!: any[];
  @Input('fieldTypeMap') fieldTypeMap = {};
  @Input('filterNamesArrLst') filterNamesArrLst!: any[];
  @Input('isAddFilter') isClick: boolean = false;
  @Input('andOrAddArrCounter') andOrAddArrCounter!: any[];
  @Input('isDateArrs') isDateArrs!: any[];
  @Input('filterNameArrForExprMap') filterNameArrForExprMap!: any[];
  //Sai55
  @Input('isValueCheckBoxStatusArr') isValueCheckBoxStatusArr!: any[];
  @Input('indexArrayForPushAndOrAddArr') indexArrayForPushAndOrAddArr!: any[];
  @Output() isClickTrue: EventEmitter<any> = new EventEmitter();
  @Output() isCustomFilter: EventEmitter<any> = new EventEmitter();
  prmntFilterArrLstLabel:any = [];
  prmntFilterValueArrLst:any = [];
  prmntOperatorNameArrLst:any = [];
  prmntFieldNameArrLst:any = [];
  prmntOperandNameArrList:any = [];
  prmntValuePmptArrLst:any = [];
  prmntFilterCondChkBxArr:any = [];
  //New-Start
  prmntCheckBoxStatusArr:any = [];
  prmntFilterValuePromtTxtBoxArr:any = [];
  prmntFilterValuePromtTxtBoxArrDummy:any = [];
  prmntFilterBtwntextValueArr:any = [];
  fieldNameArrLstMap: any[] = []; //array map
  //New-End
  filterValuePromtTxtBoxArr:any = [];
  isPromptCheckBoxStatusArr: any[] = [];
  selctedFldNameLinkHMap: any;
  selctedOperatorLinkHMap: any;
  selctedPmptLinkHMap: any;
  filterBtwntextValueArr:any = [];//For Between
  filterValuePromtTxtBoxArrDummy:any = [];
  newArrDummy: any[] = [];
  idxForBtwn:any= null;
  checkBoxStatusArr = [true]; // for keeping check box status
  dateFormat = '';

  constructor(private cdr: ChangeDetectorRef, private _searchMenuService: SearchComponent, public datepipe: DatePipe) { }

  ngOnInit() {
    this.dateFormat = this._searchMenuService.getDateFormat();    //To get APPL_DATE_FORMAT
  }

  ngOnChanges() {
    this.fieldTypeMap = this._searchMenuService.getfieldTypeMap();

    if (this.isPermntFilter) {
      this.setPermntFilters(this.filterNodeList, this.colInfoNodeList);
    }
  }

  //for bydefault filter-Start
  getPrmntDate(e:any, a:any, idx:any) {
    this.prmntCheckBoxStatusArr[a] = true;
    if (idx == null) {
      console.log('getPrmntDate idx is null');
      var ipdata:any = "";
      if (e instanceof Date) {
        ipdata = this.datepipe.transform(e, this.dateFormat);
      } else {
        ipdata = e;
      }
      this.setPrmntFilterValuePromtTxtBoxArr(ipdata, a);
    }
    else if (idx != null && this.prmntOperatorNameArrLst[a][idx] != 'BETWEEN') {
      console.log('getPrmntDate idx is not null and operator is beetween');
      if (e instanceof Date) {
        this.prmntFilterValuePromtTxtBoxArrDummy[idx] = this.datepipe.transform(e, this.dateFormat);
      } else {
        this.prmntFilterValuePromtTxtBoxArrDummy[idx] = e;
      }
      var newArr = this.prmntFilterValuePromtTxtBoxArrDummy.slice(0);
      this.setPrmntFilterValuePromtTxtBoxArr(newArr, a);
    }
    //console.log(" getPrmntDate prmntFilterValuePromtTxtBoxArr in getdate", this.prmntFilterValuePromtTxtBoxArr);

    //we can check value or propmt by index and get value as per that
    this._searchMenuService.setPrmntFilterValuePromtTxtBoxArr(this.prmntFilterValuePromtTxtBoxArr[a], a);
  }

  getPrmntBtwnTextValue(event:any, a:any, ipIndx:any, idx:any) {
    this.prmntCheckBoxStatusArr[a] = true;
    var evn:any = "";
    if (event instanceof Date) {
      evn = this.datepipe.transform(event, this.dateFormat);
    } else {
      evn = event;
    }

    if (ipIndx == 0) {
      this.prmntFilterBtwntextValueArr[0] = evn; //here need to check, bcz it stores value 
    }
    if (ipIndx == 1) {
      this.prmntFilterBtwntextValueArr[1] = evn;
    }
    var newArr = this.prmntFilterBtwntextValueArr.slice(0); //coppied the array to avoid reference problem
    if (idx != null) {
      //console.log("getPrmntBtwnTextValue Stored at idx index");
      this.prmntFilterValuePromtTxtBoxArrDummy[idx] = newArr;
      var newArrDummy = this.prmntFilterValuePromtTxtBoxArrDummy.slice(0);
      this.setPrmntFilterValuePromtTxtBoxArr(newArrDummy, a);
    } else {
      //console.log("getPrmntBtwnTextValue Stored at a index");
      this.setPrmntFilterValuePromtTxtBoxArr(newArr, a);
    }
    //console.log("this.prmntFilterValuePromtTxtBoxArr", this.prmntFilterValuePromtTxtBoxArr);
    this._searchMenuService.setPrmntFilterValuePromtTxtBoxArr(this.prmntFilterValuePromtTxtBoxArr[a], a);
  }
  //Sai for bydefault filter-End

  getDate(event:any, a:any, idx:any) {
    // console.log('::In getDate::event[', event, '] a[', a, '] idx[', idx, ']');
    this.checkBoxStatusArr[a] = true;
    //this._searchMenuService.setCheckBoxStatus(true, a);1803
    var e:any= "";
    if (event instanceof Date) {
      e = this.datepipe.transform(event, this.dateFormat);
    } else {
      e = event;
    }
    if (idx == null) {
      console.log('idx is null');
      var ipdata = e;
      this.setFilterValuePromtTxtBoxArr(ipdata, a);
    }
    else if (idx != null && this.operatorNameArrLst[a][idx] != 'BETWEEN') {
      console.log('idx is not null and operator is beetween');

      this.filterValuePromtTxtBoxArrDummy[idx] = e;
      var newArr = this.filterValuePromtTxtBoxArrDummy.slice(0);
      this.setFilterValuePromtTxtBoxArr(newArr, a);
    }
    //console.log("filterValuePromtTxtBox in getdate", this.filterValuePromtTxtBoxArr);
    //we can check value or propmt by index and get value as per that
    this._searchMenuService.setFilterValuePromtTxtBoxArr(this.filterValuePromtTxtBoxArr[a], a);
  }

  getBtwnTextValue(event:any, a:any, ipIndx:any, idx:any) {
    //  console.log('::In getBtwnTextValue::');
    this.checkBoxStatusArr[a] = true;
    // console.log("filterValuePromtTxtBox event> ", event, "a>", a, "ipIndx>", ipIndx, "idx>", idx);
    var evn:any = "";
    if (event instanceof Date) {
      evn = this.datepipe.transform(event, this.dateFormat);
    } else {
      evn = event;
    }

    if (ipIndx == 0) {
      this.filterBtwntextValueArr[0] = evn; //here need to check, bcz it stores value 
    }
    if (ipIndx == 1) {
      this.filterBtwntextValueArr[1] = evn;
    }

    var newArr = this.filterBtwntextValueArr.slice(0); //coppied the array to avoid reference problem
    //console.log("this.newArr", newArr);
    if (idx != null) {
      console.log("Stored at idx index");
      this.filterValuePromtTxtBoxArrDummy[idx] = newArr;

      var newArrDummy = this.filterValuePromtTxtBoxArrDummy.slice(0);

      this.setFilterValuePromtTxtBoxArr(newArrDummy, a);
    } else {
      console.log("Stored at a index");
      this.setFilterValuePromtTxtBoxArr(newArr, a);
    }
    console.log("this.filterValuePromtTxtBoxArr", this.filterValuePromtTxtBoxArr);
    //we can check value or propmt by index and get value as per that
    this._searchMenuService.setFilterValuePromtTxtBoxArr(this.filterValuePromtTxtBoxArr[a], a);
  }
  setFilterValuePromtTxtBoxArr(filterValuePromtTxtBox: any, a: any): any {
    this.filterValuePromtTxtBoxArr[a] = filterValuePromtTxtBox;
    console.log("this.filterValuePromtTxtBoxArr111", this.filterValuePromtTxtBoxArr);
  }
  setPrmntFilterValuePromtTxtBoxArr(filterValuePromtTxtBox: any, a: any) {
    this.prmntFilterValuePromtTxtBoxArr[a] = filterValuePromtTxtBox;
    console.log("this.prmntFilterValuePromtTxtBoxArr", this.prmntFilterValuePromtTxtBoxArr);
  }

  //for permanent --Start
  /**
  * It collects permanent filter condition(s) those are received from DB (if it exists) initially & adds them to
  * the Search Option's "Custom Search Condition"  panel via addPermntFltr() method.
  *
  * @param filterNodeLst
  * @param colInfoNodeLst
  */
  setPermntFilters(filterNodeList: NodeList, colInfoNodeList: NodeList) {
    var permntFilterNamesArrLst:any = [];
    var filterName:any = "", filterExpr:any = "";
    var allFltrNameFltrExprHMap:any = {};

    try {
      console.log("setPermntFilters length ==>243 [", filterNodeList.length, ']');
      for (var i = 0; i < filterNodeList.length; i++) {
        var formalArgsEle = filterNodeList.item(i) as Element;
        var nodMap: NamedNodeMap;
        nodMap = formalArgsEle.attributes;

        this.defaultOpt = nodMap.getNamedItem("default_opt")?.nodeValue?.trim();
        //console.log('defaultOpt', this.defaultOpt);

        if (filterNodeList != null && filterNodeList.item(0) != null && filterNodeList.item(0)?.hasChildNodes()) {
          try {
            filterName = filterNodeList.item(i)?.childNodes[0].firstChild?.nodeValue;
            // console.log("filterName>>", filterName);
            filterExpr = filterNodeList.item(i)?.childNodes[1].firstChild?.nodeValue;
            // console.log("filterExpr>>", filterExpr);
          }
          catch
          {
            console.log("Error while reading filterName and filterExpr...");
          }
        }
        permntFilterNamesArrLst[i] = filterName;
        console.log('permntFilterNamesArrLst>>[i]', permntFilterNamesArrLst[i])
        this.setPermanentFltrNameList(permntFilterNamesArrLst);
        allFltrNameFltrExprHMap[filterName] = filterExpr;
        this.setAllFltrNameFltrExprHMap(allFltrNameFltrExprHMap);
        this.addPermntFltr(i, this.defaultOpt, filterName, colInfoNodeList);//,prmntFilterCondChkBxArr
      }
    }
    catch
    {
      console.log("Exception: setPermntFilters--");
    }
  }

  /**
  * It adds the permanent filters on Search Option's "My Search Condition" disclosure panel one by one those are
  * received from DB.
  *
  * @param defaultOpt
  * @param filterName
  * @param quesMrkNoAndTypeHMap i.e the "?" mark is against a Date type or Not.
  * @param customSearchCondVPnl
  * @param count
  */
  addPermntFltr(index:any, defaultOpt: string, filterName: string, colInfoNodeList: NodeList)//prmntFilterCondChkBxArr: any[]
  {
    var filterValueArrLst: any = [];
    var operatorNameArrLst: any = [];
    var fieldNameArrLst: any = [];
    var valuePmptIndxArrLst: any = [];
    var operandIndxArrList: any = [];
    var filterNamesArrLstLabel:any = [];
    var prmntFilterCondChkBxValue: boolean = false;
    try {
      if (filterName != null) {
        if (defaultOpt.trim() == "Y") {
          prmntFilterCondChkBxValue = true;
        }
        else if (defaultOpt.trim() == "N") {
          prmntFilterCondChkBxValue = false;
        }
        this.setPrmntCheckdBoxStatus(prmntFilterCondChkBxValue, index);
        //console.log('prmntFilterCondChkBxValue ::', prmntFilterCondChkBxValue);
        var filterExpr = "";
        for (var key in this.allFltrNameFltrExprHMap) {
          if (key == filterName) {
            if (this.allFltrNameFltrExprHMap.hasOwnProperty(key)) {
              filterExpr = this.allFltrNameFltrExprHMap[key];
              //console.log('filterExpr196>>', filterExpr);
            }
          }
        }
        this.getOperandList(index, filterName, filterExpr, operandIndxArrList); //operand list

        filterExpr = filterExpr.replace("AND", "~~");
        var exprArr = [] = filterExpr.split(" And ");
        //console.log('exprArr>>', exprArr);

        for (var i = 0; i < exprArr.length; i++) {
          var simpleExpr = "";
          var andExpr = exprArr[i];
          //console.log('andExpr>>', andExpr);
          if (andExpr.includes(" Or ")) {
            var orExprArr = andExpr.split(" Or ");
            //console.log('orExprArr>>', orExprArr);
            for (var j = 0; j < orExprArr.length; j++) {
              simpleExpr = orExprArr[j];
              //console.log('simpleExpr>>', simpleExpr);
              this.getExprAttribute(index, filterName, simpleExpr, filterValueArrLst, fieldNameArrLst, operatorNameArrLst, valuePmptIndxArrLst);
            }
          }
          else {
            simpleExpr = andExpr;
            this.getExprAttribute(index, filterName, simpleExpr, filterValueArrLst, fieldNameArrLst, operatorNameArrLst, valuePmptIndxArrLst);
          }
        }
  
        if (filterName.includes('?')) {
          let filterNameArr:any = [];
          filterNameArr = filterName.split('?');

          //console.log("in valaue filterNameArr", filterNameArr);
          console
          for (var i = 0; i < filterNameArr.length; i++) {
            var filter = "";
            if (filterNameArr[i] != "") {
              filter = filterNameArr[i];
              filterNamesArrLstLabel[i] = filter;
            }
          }
        }
        else {
          filterNamesArrLstLabel[0] = filterName;
        }
        this.setprmntfilterNamesArrLstLabel(filterNamesArrLstLabel, index);

        if (this.prmntFieldNameArrLst[index].length != this.prmntFilterArrLstLabel[index].length) {
          //console.log('if fild and name length is not same!!');
          for (var i = 0; i < this.prmntFieldNameArrLst[index].length; i++) {
            try {
              if (filterNamesArrLstLabel[i] == undefined) {
                console.log('filterNamesArrLst[', i, '] is undefined');
                filterNamesArrLstLabel[i] = "";
              }
            }
            catch
            {
              filterNamesArrLstLabel[i] = "";
            }
          }
          this.setprmntfilterNamesArrLstLabel(filterNamesArrLstLabel, index);
        }
      }
    }
    catch
    {
      console.log("Exception: addPermntFltr ");
    }
  }

  getOperandList(index:any, filterName: string, expr: string, operandIndxArrList: any[]) {
    //console.log("getOperandList ==>3971");

    expr = expr.replace(" And ", " & ");
    expr = expr.replace(" Or ", " | ");
    for (var i = 0; i < expr.length; i++) {
      var ch = expr.charAt(i);
      if (ch == '&') {
        operandIndxArrList.push("And");
      }
      else if (ch == '|') {
        operandIndxArrList.push("Or");
      }
    }
    //console.log('operandIndxArrList>>', operandIndxArrList);
    this.selctedOperandLinkHMap[filterName] = operandIndxArrList;
    this.setPrmntOperandNameArrList(operandIndxArrList, index);
  }

  /**
   * This method get field name, operator, oprend details from filter expression
   * @param filterName
   * @param expr
   * @param filterValueArrLst
   * @param fieldNameArrLst
   * @param operatorNameArrLst
   * @param valuePmptIndxArrLst
   */
  getExprAttribute(index: number, filterName: string, expr: string, filterValueArrLst: any[], fieldNameArrLst: any[], operatorNameArrLst: any[], valuePmptIndxArrLst: any[]): any {
    var fldValueArrForBtwn:any = [];
    expr = expr.replace("~~", "AND");
    console.log("getExprAttribute ==>expr[", expr, ']');

    var fldName = expr.substring(0, expr.indexOf(" "));
    if (fldName.includes(".")) {
      fldName = fldName.substring(fldName.indexOf(".") + 1, fldName.length);
      //console.log("getExprAttribute ==>fldName", fldName);
    }
    var dummyExpr = expr.substring(expr.indexOf(" ")).trim();
    var operator = dummyExpr.substring(0, dummyExpr.indexOf(" ")).trim();
    var fldValue = dummyExpr.substring(dummyExpr.indexOf(" ")).trim();
    fldValue = fldValue.substring(1, fldValue.length - 1);

    if (operator.toUpperCase() == "LIKE" || operator.toUpperCase() == "CONTAINS") {
      if (fldValue.startsWith("%") && fldValue.endsWith("%")) {
        operator = "CONTAINS";
        console.log("getExprAttribute ==>operator[", operator, ']')
      }
      else if (fldValue.startsWith("%")) {
        operator = "LIKE ENDS WITH";
        console.log("getExprAttribute ==>operator[", operator, ']')
      }
      else if (fldValue.endsWith("%")) {
        operator = "LIKE STARTS WITH";
        console.log("getExprAttribute ==>operator[", operator, ']')
      }
    }

    if (fldValue.includes("?")) {
      valuePmptIndxArrLst.push("Prompt"); //Sai set value promp drop down
      if (operator.toUpperCase() == "IN") {
        //console.log('operator.toUpperCase() == IN  Prompt');
        fldValue = fldValue.substring(1, fldValue.length - 1);
      }
    }
    else {
      valuePmptIndxArrLst.push("Value");
      if (operator.toUpperCase() == "IN") {
        //console.log('operator.toUpperCase() == IN  Value');
        fldValue = fldValue.substring(1, fldValue.length - 1).trim();
        fldValue = fldValue.replace("','", ",");
      }
      else if (operator.toUpperCase() == "BETWEEN") {
        fldValue = fldValue.replace("' AND '", ",");//001' AND '005 == "001,005" used to give like this
        fldValueArrForBtwn = fldValue.split(",");//["001", "005"]
      }
    }

    // this.fieldNameArrLstMap[filterName+idx] = fldName;
    fieldNameArrLst.push(fldName);
    operatorNameArrLst.push(operator);
    if (fldValueArrForBtwn.length > 0) {
      //console.log('fldValueArrForBtwn>>', fldValueArrForBtwn);
      filterValueArrLst.push(fldValueArrForBtwn);
    } else {
      filterValueArrLst.push(fldValue);
    }
    this.setPrmntValuePmptArrLst(valuePmptIndxArrLst, index);
    this.setPrmntfieldNameArrLst(fieldNameArrLst, index);
    this.setPrmntoperatorNameArrLst(operatorNameArrLst, index);
    this.setPrmntfilterValueArrLst(filterValueArrLst, index);
    //console.log('429valuePmptIndxArrLst>>', valuePmptIndxArrLst, 'fieldNameArrLst>>', fieldNameArrLst, 'operatorNameArrLst>>', operatorNameArrLst, 'filterValueArrLst>>', filterValueArrLst);
  }
  //for permanent --End

  onDoubleClick(i: number, idx: number) {
    window.alert('You clicked twice!!');
    console.log('You clicked twice!! i==[', i, '] idx==[', idx, ']');
    var filterNamesArrLst:any = [];
    var filterValueArrLst:any = [];
    var isValueCheckBoxStatusArr:any = [];
    var fieldNameArrLst:any = [];
    var promtValuOptArr:any = [];
    var codtnValueArr:any = [];
    var filterNamesArrLst:any = [];
    var editJsonValues:any = {};
    var andOrAddArrCounter:any = [];
    var operatorNameArrLst:any = [];
    var selectedInputFieldIndx:any = i;
    var isDateArr:any = [];
    var selectedFilterName = this.filterNameArrForExprMap[i];
    var indexArrayForPushAndOrAddArr:any = [];
    //console.log('You clicked >>', selectedFilterName, 'filterNameArrForExprMap>', this.filterNameArrForExprMap);

    //console.log('You clicked twice!!1 brfore filterValuePromtTxtBoxArrDummy', this.filterValuePromtTxtBoxArrDummy, 'filterBtwntextValueArr>', this.filterBtwntextValueArr);
    this.filterValuePromtTxtBoxArrDummy = [];
    this.filterBtwntextValueArr = [];
    //console.log(' filterValuePromtTxtBoxArrDummy after', this.filterValuePromtTxtBoxArrDummy, 'filterBtwntextValueArr>', this.filterBtwntextValueArr);
    isValueCheckBoxStatusArr = this.isValueCheckBoxStatusArr[i];
    //console.log('You clicked twice!! isValueCheckBoxStatusArr', isValueCheckBoxStatusArr);
    //console.log('You clicked twice!! indexArrayForPushAndOrAddArr', this.indexArrayForPushAndOrAddArr);
    indexArrayForPushAndOrAddArr = this.indexArrayForPushAndOrAddArr;


    if (idx == null) {
      console.log('You clicked twice!! idx is null');
      operatorNameArrLst = this.operatorNameArrLst[i];
      filterNamesArrLst = this.filterNamesArrLst[i];
      filterValueArrLst = this.filterValueArrLst[i];

      fieldNameArrLst = this.fieldNameArrLst[i];
      promtValuOptArr = this.promtValuOptArr[i];
      codtnValueArr = this.codtnValueArr[i];
      andOrAddArrCounter = this.andOrAddArrCounter[i];
      isDateArr = this.isDateArrs[i];

      this.filterValuePromtTxtBoxArr[i] = "";//to empty selected index from filterValuePromtTxtBoxArr

      this._searchMenuService.removeselectedFilterValuePromtTxtBoxArrIndex(i);
    }
    else {
      for (var j = 0; j < this.filterNamesArrLst[i].length; j++) {
        operatorNameArrLst[j] = this.operatorNameArrLst[i][j];
        filterNamesArrLst[j] = this.filterNamesArrLst[i][j];
        filterValueArrLst[j] = this.filterValueArrLst[i][j];
        fieldNameArrLst[j] = this.fieldNameArrLst[i][j];
        promtValuOptArr[j] = this.promtValuOptArr[i][j];
        codtnValueArr[j] = this.codtnValueArr[i][j];
        andOrAddArrCounter[j] = this.andOrAddArrCounter[i][j];
        isDateArr[j] = this.isDateArrs[i][j];

        if (this.filterValuePromtTxtBoxArr[i] != undefined) {
          if (this.filterValuePromtTxtBoxArr[i][j] != undefined) {
            //console.log('console13', this.filterValuePromtTxtBoxArr[i][j]);
            this.filterValuePromtTxtBoxArr[i][j] = []; //to empty selected index from filterValuePromtTxtBoxArr
          }
        } else {
          //console.log('console14');
          this.filterValuePromtTxtBoxArr[i] = [];
          this.filterValuePromtTxtBoxArr[i][j] = [];
        }
        this._searchMenuService.removeselectedFilterValuePromtTxtBoxArrIndex(i);
      }
    }
    editJsonValues['operatorNameArrLst'] = operatorNameArrLst;
    editJsonValues['filterNamesArrLst'] = filterNamesArrLst;
    editJsonValues['filterValueArrLst'] = filterValueArrLst;
    editJsonValues['isValueCheckBoxStatusArr'] = isValueCheckBoxStatusArr;
    editJsonValues['fieldNameArrLst'] = fieldNameArrLst;
    editJsonValues['promtValuOptArr'] = promtValuOptArr;
    editJsonValues['codtnValueArr'] = codtnValueArr;
    editJsonValues['andOrAddArrCounter'] = andOrAddArrCounter;
    editJsonValues['isDateArr'] = isDateArr;
    editJsonValues['selectedInputFieldIndx'] = selectedInputFieldIndx;
    editJsonValues['filterValuePromtTxtBoxArr'] = this.filterValuePromtTxtBoxArr;
    editJsonValues['selectedFilterName'] = selectedFilterName;
    editJsonValues['indexArrayForPushAndOrAddArr'] = indexArrayForPushAndOrAddArr;
    this.isCustomFilter.emit(editJsonValues);
  }

  prmntCheckBoxStatus(event:any, a:any) {
    console.log('In CheckBoxStatus');
    var isChecked: boolean = true;
    if (event.target.checked) {
      isChecked = true;
    }
    else {
      isChecked = false;
    }
    this.setPrmntCheckdBoxStatus(isChecked, a);
  }

  CheckBoxStatus(event:any, a:any) {
    console.log('In CheckBoxStatus');
    var isChecked: boolean = true;
    if (event.target.checked) {
      isChecked = true;
      this.setCheckdBoxStatus(isChecked, a);
    }
    else {
      isChecked = false;
      this.setCheckdBoxStatus(isChecked, a);
    }
  }

  //bydefault filter-start
  setPrmntValuePmptArrLst(valuePmptIndxArrLst: any[], index:any): any {
    this.prmntValuePmptArrLst[index] = valuePmptIndxArrLst;
    //console.log('set prmntValuePmptArrLst::', this.prmntValuePmptArrLst);
    this._searchMenuService.setPrmntValuePmptArrLst(valuePmptIndxArrLst, index);
  }
  setPrmntfilterValueArrLst(filterValueArrLst: any[], index:any): any {
    this.prmntFilterValueArrLst[index] = filterValueArrLst;
    //console.log('set prmntFilterValueArrLst::', this.prmntFilterValueArrLst);
    this._searchMenuService.setPrmntfilterValueArrLst(filterValueArrLst, index);
  }
  setPrmntoperatorNameArrLst(operatorNameArrLst: any[], index:any): any {
    this.prmntOperatorNameArrLst[index] = operatorNameArrLst;
    //console.log('set prmntOperatorNameArrLst::', this.prmntOperatorNameArrLst);
    this._searchMenuService.setPrmntoperatorNameArrLst(operatorNameArrLst, index);
  }
  setPrmntfieldNameArrLst(fieldNameArrLst: any[], index:any): any {
    this.prmntFieldNameArrLst[index] = fieldNameArrLst;
    // console.log('set prmntFieldNameArrLst::', this.prmntFieldNameArrLst);
    this._searchMenuService.setPrmntfieldNameArrLst(fieldNameArrLst, index);
  }
  setPrmntOperandNameArrList(operandIndxArrList: any[], index:any): any {
    this.prmntOperandNameArrList[index] = operandIndxArrList;
    //console.log('prmntOperandNameArrList::', this.prmntOperandNameArrList);
    this._searchMenuService.setPrmntOperandNameArrList(operandIndxArrList, index);
  }
  setPermanentFltrNameList(permntFilterNamesArrLst: any[]): any {
    this.permntFilterNamesArrLst = permntFilterNamesArrLst;
    // console.log('permntFilterNamesArrLst main for map::', permntFilterNamesArrLst);
    this._searchMenuService.setPermanentFltrNameListForMap(permntFilterNamesArrLst);
  }
  setprmntfilterNamesArrLstLabel(filterNamesArrLstLabel: any[], index:any): any {
    this.prmntFilterArrLstLabel[index] = filterNamesArrLstLabel;
    // console.log(" set prmntFilterArrLstLabel:: ", this.prmntFilterArrLstLabel);
    this._searchMenuService.setprmntfilterNamesArrLst(filterNamesArrLstLabel, index);
  }
  setPrmntCheckdBoxStatus(checkBoxStatus: boolean, a: any): any {
    this.prmntFilterCondChkBxArr[a] = checkBoxStatus;
    // console.log('checkbox status after set prmntFilterCondChkBxArr', this.prmntFilterCondChkBxArr)
    this._searchMenuService.setPrmntCheckBoxStatus(checkBoxStatus, a);
  }

  setfilterCondChkBxTitle(filterName: string): any {
    this.filterCondChkBxTitle = filterName;
    //console.log('filterCondChkBxTitle>>', this.filterCondChkBxTitle);
  }
  setAllFltrNameFltrExprHMap(AllFltrNameFltrExprHMap: {}): any {
    this.allFltrNameFltrExprHMap = AllFltrNameFltrExprHMap;
  }
  //bydefault filter-end

  setCheckdBoxStatus(checkBoxStatus: boolean, a: any): any {
    this.isValueCheckBoxStatusArr[a] = checkBoxStatus;
    //console.log('checkbox status after set', this.isValueCheckBoxStatusArr);
  }
}