import { Component, OnInit, OnDestroy, DoCheck, Input } from '@angular/core';
import { Subscription } from 'rxjs';
import { BISResponse, BISIntentService } from '../../bis-services';

@Component({
  selector: 'bis-messages',
  templateUrl: './bis-messages.component.html',
  styleUrls: ['./bis-messages.component.css']
})
export class BISMessagesComponent implements OnInit, OnDestroy, DoCheck {

  messageSubscription : Subscription | any;
  messages : BISResponse[] = [];
  userImgPath: any;
  //Added by sunny soni for displying assistant chat screen informaton in native app on 25-Feb-21[START]
  isNative: boolean = false;
  nativeStr: any;
  //Added by sunny soni for displying assistant chat screen informaton in native app on 25-Feb-21[END]
  //Added by Pratheek on 18-06-19[ using the @Input decorator to get the id values so to differentiate the Welcome screen and Quick Action Pamel]-Start
  @Input() targetId:String | any;
  //Added by Pratheek on 18-06-19[ using the @Input decorator to get id values so to differentiate the Welcome screen and Quick Action Pamel]-End
  constructor(public intentService : BISIntentService) { }

  ngOnInit() 
  {
        //Added by sunny soni for displying assistant chat screen informaton in native app on 25-Feb-21[START]
        // if (window as  { [key: string]: any }["NATIVE"] as string)
        // if (window["NATIVE"]) {
          if (window["NATIVE"]) {
            // this.isNative = window["NATIVE"]["ISNATIVE"];  
            this.isNative = window["NATIVE"]["ISNATIVE"];                
            this.isNative = !this.isNative;
            // if (window["NATIVE"]["ISNATIVE"]) {
            if (window["NATIVE"]["ISNATIVE"]) {
                // this.isNative = window["NATIVE"]["ISNATIVE"];       
                this.isNative = window["NATIVE"]["ISNATIVE"];       
            }
        }
        console.log('bis-message ngOnInit isNative::::'+this.isNative+']');
        if (this.isNative) {
            this.nativeStr = "native";
        }
        console.log('bis-message ngOnInit nativeStr=['+this.nativeStr+']');
        //Added by sunny soni for displying assistant chat screen informaton in native app on 25-Feb-21[END]
	  //Added by Pratheek on 18-06-19[ passing the id values so to differentiate the Welcome screen and Quick Action Pamel]-Start
      console.log( 'BISMessagesComponent : ngOnInit ['+this.targetId+']' );
      this.messageSubscription = this.intentService.getMessages(this.targetId).subscribe( msgs => {
      this.messages = msgs;
      console.log('Print messages::::::',this.messages);
      this.intentService.ngRefresh();
      //Added by Pratheek on 18-06-19[ passing the id values so to differentiate the Welcome screen and Quick Action Pamel]-End
    });
    // Added by Amey W. [ To get user image for Chat-bubble] on 17-07-2019
    var loginId = localStorage.getItem('userName');
    if( loginId )
    {
      this.userImgPath = "/ibase/resource/images/users/" + loginId + ".png";
    }
  }

  ngDoCheck() 
  {
    //console.log('BISMessagesComponent : ngDoCheck : ');
    //this.scrollToBottom();
    //this.intentService.scrollToBottomNFocus();
  }

  ngOnDestroy()
  {
    console.log( 'BISMessagesComponent : ngOnDestroy' );
    this.messageSubscription.unsubscribe();
  }

  scrollToBottom() 
  {
    //console.log('scrollToBottom :');
    var objDiv: any = document.getElementById("bis-message-list");
    objDiv!.scrollTop = objDiv.scrollHeight + 400;
    if ( document.getElementById("bis-intent-input") != null )
    {
      // document.getElementById("bis-intent-input").focus();
      document.getElementById("bis-intent-input")?.focus();
    }
  }
  //By Sainath T. on 23-04-2019  [For Tatal implementation in VA table response]-SATRT
  getResponsewithTotal(response: any)
  {
    console.log('Print response 87:::::',response);
    var totalArr = this.getTotalData(response);
    response[0]['total'] = totalArr; 
    return response;
  }
  
  getTotalData(responseData: any) 
  {
    var totalArr:any = [];
    var colstyle = responseData[0]['colStyle'];
    var rows = responseData[0]['rows'];
    for (var i = 0; i < colstyle.length; i++) 
    {
      var mainVal: any = 0;
      for (var k = 0; k < rows.length; k++) 
      {
        if (colstyle[i] == 'bis-numberClass') 
        {
          mainVal += Number(rows[k][i]);
        }
        else {
          mainVal = null;
        }
      }
      if(mainVal != null)
      {
        mainVal = this.intentService.round(mainVal,2);
      }
      totalArr[i] = mainVal;
    }
    return totalArr;
  }
  //By Sainath T. on 23-04-2019  [For Tatal implementation in VA table response]-END
}
