import { Component, OnInit, Input, Output, EventEmitter, HostListener, AfterViewInit, OnDestroy } from '@angular/core';

@Component({
  selector: 'bis-chip',
  template: `
    <span class='bis-chip'>
      <ng-content></ng-content>
    </span>
  `,
  styles: [`
    .bis-chip{
      position: relative;
      display: inline-block;
      padding: 7px 10px;
      color: #666;
      border: 1px solid #666;
      background: #fff;
      
      /*
      color: var(--primary);
      border: 1px solid var(--primary);
      */
      font-size : 12px;
      border-radius: 50px;
      margin: 3px 5px;
      cursor: pointer;
      white-space: nowrap;
    }
  `]
})
export class BISChipComponent implements OnInit, OnDestroy, AfterViewInit {

  @Input() intent: any;
  //Sainath T. on 11/12/18
  bottom : number | any;
  @Output() selected = new EventEmitter<any>();
  @HostListener('click') select() {
    if( this.intent )
    {
      this.selected.emit(this.intent);
    }
  }
  //By Sainath T. on 28-AUG-2019
  isBrowser: boolean = false;
  //By Sainath T. 0n 09-SEp-2019
  @Input() callFromProteusVision: any;
  constructor() { }

  ngOnInit() 
  {
    //By Sainath T. on 28-AUG-2019 -Start
    let index = window.location.pathname.indexOf('E12BROWSER');
    if (index > -1) {
      this.isBrowser = true;
      console.log('in Chip isBrowser>>', this.isBrowser);
    }
    //By Sainath T. on 28-AUG-2019 -End
    //By Sainath T. on 10/12/18 [changes to display bis-chips above the input-container] -START
    var element: any = document.getElementById('intent-input-container');
    var positionInfo = element.getBoundingClientRect();
    this.bottom = positionInfo.height;
    //console.log('intent-input-container marginvalue>>',this.bottom)
    if(this.bottom < 57)
    {
      this.bottom = 60 - 15;
    }
    else
    {
      this.bottom = this.bottom - 15;
      //console.log('intent-input-container marginvalue in else>>',this.bottom)
    }
    var inputSugg = document.getElementsByClassName("bis-intent-list");
    //var inputSugg = document.querySelectorAll('bis-chip');
    for( var i = 0; i< inputSugg.length; i++ )
    {
      inputSugg[i].setAttribute("style", "bottom:"+this.bottom+"px !important;");
    } 
    //By Sainath T. on 10/12/18 [changes to display bis-chips above the input-container] -END
  }

  //Added by Prasad on 07/08/19 [to adjust dynamic height in vision assistant] START
  ngAfterViewInit()
  {
    console.log('BISChipComponent :: ngAfterViewInit');
    var intentInputContainerEle = document.getElementById( 'intent-input-container' );
    console.log( 'intentInputContainerEle : ', intentInputContainerEle );
    if ( intentInputContainerEle )
    {
      var rootElem = <HTMLElement>document.querySelector(':root')
  
      //By Sainath T. on 14-SEP-2019 [To resolve scroll related issue] - Start
      var bisHeaderEle = document.getElementById("bis_showHeader");
      var loadDisplay = false;
      if ( bisHeaderEle )
      {
        loadDisplay = (window.getComputedStyle(bisHeaderEle, null).getPropertyValue("display") == 'none') ? false : true;
        console.log('bisHeader display style',loadDisplay);
      }
      var intentInputContainerEleHeight = ( this.callFromProteusVision && loadDisplay )? intentInputContainerEle.offsetHeight + 31 : intentInputContainerEle.offsetHeight;
      //By Sainath T. on 14-SEP-2019 [To resolve scroll related issue] - End
      rootElem.style.setProperty( '--invokeInputContainerHeight', (intentInputContainerEleHeight +"px") );
      var objDiv = document.getElementById("bis-message-list");
      if ( objDiv )
      {
        try
        {
          objDiv!.scrollTop = objDiv.scrollHeight + objDiv.clientHeight;
        }
        catch
        {
          console.log('Exception while getting objDiv in bis-intent.service.ts');
        }
      }
    }
  }

  ngOnDestroy()
  {
    setTimeout( () => 
    {
      console.log( 'BISChipComponent :: ngOnDestroy' );
      var intentInputContainerEle: any = document.getElementById('intent-input-container');
      console.log( 'intentInputContainerEle : ', intentInputContainerEle );
      if ( intentInputContainerEle )
      {
        console.log('intentInputContainerHeight : ', intentInputContainerHeight);
        var rootElem = <HTMLElement>document.querySelector(':root')
        //By Sainath T. on 14-SEP-2019 [To resolve scroll related issue] - Start
        var bisHeaderEle = document.getElementById("bis_showHeader");
        var loadDisplay = false;
        if ( bisHeaderEle )
        {
          loadDisplay = (window.getComputedStyle(bisHeaderEle, null).getPropertyValue("display") == 'none') ? false : true;
          console.log('bisHeader display style',loadDisplay);
        }
        var intentInputContainerHeight = ( this.callFromProteusVision && loadDisplay )? intentInputContainerEle.offsetHeight + 30 : intentInputContainerEle.offsetHeight;
        rootElem.style.setProperty('--invokeInputContainerHeight', intentInputContainerHeight +"px" );
       //By Sainath T. on 14-SEP-2019 [To resolve scroll related issue] - End
        var objDiv = document.getElementById("bis-message-list");
        if ( objDiv )
        {
          try
          {
            objDiv!.scrollTop = objDiv.scrollHeight + objDiv.clientHeight;
          }
          catch
          {
            console.log('Exception while getting objDiv in bis-intent.service.ts');
          }
        }
      }
    }, 0);
  }
  //Added by Prasad on 07/08/19 [to adjust dynamic height in vision assistant] END
}
