import { Component, OnInit, Input, ChangeDetectorRef, ViewChild, HostListener, Output, EventEmitter, TemplateRef, ViewContainerRef } from '@angular/core';
import { DatePipe } from '@angular/common';
import { HttpClient } from '@angular/common/http';
import { DateAdapter, MAT_DATE_FORMATS } from '@angular/material/core';
import { AppDateAdapter, APP_DATE_FORMATS } from '../date.adapter';
import { SearchComponent } from '../searchComponent.service';
import { OverlayConfig, Overlay } from '@angular/cdk/overlay';
import { TemplatePortal } from '@angular/cdk/portal';
import { MatDatepickerInputEvent } from '@angular/material/datepicker';
@Component({
  selector: 'home-page-popuppanel',
  templateUrl: './home-page-popuppanel.component.html',
  styleUrls: ['./home-page-popuppanel.component.css'],
  providers: [
    {
      provide: DateAdapter, useClass: AppDateAdapter
    },
    {
      provide: MAT_DATE_FORMATS, useValue: APP_DATE_FORMATS
    },
    DatePipe
  ]
})
export class HomePagePopuppanelComponent implements OnInit {
  @Input('objDtlResonse') objDtlResonse:any;
  @Input('objName') objName!: string;
  @Input('objDetailsMap') objDetailsMap:any;
  @Input('pophelpFieldsDetailsMap') pophelpFieldsDetailsMap:any; //gives the details of pophelp fields
  @Input('objDescr') objDescr:any;
  @Output() data: EventEmitter<any> = new EventEmitter();//Added By Vikas Lagad on 3-Oct-2019
  @Input() callFromJsp = false;
  frDate: any;
  toDate: any;
  parser!: DOMParser;
  pophelpParser!: DOMParser;
  periodOption!: string|any;
  frmlArgNames:any = "";
  selectedObject:any = null;
  fieldLbls:any = [];
  frmlArgTypes :any= "";
  frmlArgsDtBoxArrLst:any = [];
  prvButton!: string;
  nxtButton!: string;
  period!: string[];
  dayWeekMnthValShownTxtBx!: string|any;
  viewDataResponse: any;
  dateArgType = false;
  textBxTitle!: string;
  textBxId!: string;
  frmlArgsTxtBoxArrLst:any = [];
  strtDt:any = 0;
  endDt:any = 0;
  frmlArgTypeArray:any = [];
  dateFormat:any = '';
  //dPickerDateFormat = 'dd/MM/yyyy'
  searchParam = "";
  //changed by sainath t. [angular 9]
  colInfoNodeList!: HTMLCollectionOf<Element> | NodeListOf<Element>|any;
  filterNodeList!: HTMLCollectionOf<Element> | NodeList|any;
  isPermntFilter: boolean = false;
  isCustomFilter: boolean = false;

  //Sai for passing to add filter variables - START
  filterValueArrLst:any = [];
  fieldNameArrLst:any = [];
  operatorNameArrLst:any = [];
  promtValuOptArr:any = [];
  codtnValueArr:any = [];
  fieldTypeMap:any = [];
  isDateArr:any = [];
  filterNamesArrLst:any = [];
  isAddFilter: boolean = false;
  fieldDispNameMapkeys!: any[]; //for 
  filterExprMain:any = "";
  andOrAddArrCounter:any = []; //getting from custm filter
  editFilterJson:any = {};//For Edit filter data geting from add filter
  allFltrNameFltrExprHMap:any = {};
  filterNameArrForExprMap:any = [];
  isValueCheckBoxStatusArr:any = [];
  permntFilterNamesArrLstForMap:any = [];//For by default filter
  panelOpenState = false;
  //For pophelp-Start
  dataSourceForPophelpArr:any = "";
  refIdForPophelpArr:any = "";
  fieldValueForPopHelpArr:any = "";
  pophelpFieldsDetails:any = "";
  pophelpFildsArray:any = [];
  formalArgNamesForPophelpArr:any = [];//to compare with pophelp field to display pophelp if matches any
  pophelpFieldSqlInpMap:any = {};
  //For Pophelp-end
  //For input Suggestions
  dataSourceForinpSuggMap:any = {};
  pophelpIndex: number|null = null;
  isVisibleTxtBx: boolean = true;
  refIdForInpSuggArr:any = [];
  formalArgNamesForPophelpCAPSArr:any = [];//when suggestions fields come in capital from objXml.
  isBackFlag: boolean = false;
  //filterValue: any;
  randomNo = Math.random();
  mainDivId = "" + this.objName + this.randomNo;

  frmlArgsTxtBoxArrLstDummyPopHelp: any[] = [];//Temporary arr to store pophelp selected data
  frmlArgsTxtBoxArrLstDummySugg: any[] = [];//Temporary arr to store suggestions selected data
  //for overlay
  isBrowser: boolean = false;
  @ViewChild('popHelpPoptal') templatePortal!: TemplateRef<any>;
  @ViewChild('customFilterPopup') templatePortal_! :TemplateRef<any>
  overlayRef:any;
  isPophelpFlag!: boolean;
  isVisibleColDispFlag: string = "0";
  headerMenuImg = "/ibase/images/menuImages/web/exportZip.png";
  errorImage = "/ibase/images/menuImages/errMenu.png";
  indexArrayForPushAndOrAddArr: any[] = [];
  //Added By Vikas L. on 3-OCT-2019 [To Create Overlay]-START
  divHeight:any;
  isUploadStatus :boolean = false;
  responseData:any = {};
  uploadOverlayRef:any ;
  @ViewChild( 'uploadStatus' ) templateUploadStatus!: TemplateRef<any>;
  config = new OverlayConfig(); 
  isOverlay: boolean = false;
  pophelpSelectionValue = "";
  //Added By Vikas L. on 3-OCT-2019 [To Create Overlay]-END
  refreshDate:any = new Date();
  //Added By Sainath T. on 26-03-2020 [To resolve multi opt multi selection pophelp issue]
  pophelpFieldMultiOptMap: any = {};
  pophelpMultiOpt: string = "0";
  constructor(public http: HttpClient,private _searchMenuService: SearchComponent,
    public overlay: Overlay, private viewContainerRef: ViewContainerRef, public datePipe: DatePipe) { }//public overlay: Overlay

  ngOnInit() {
    console.log('::getpopupcontent()[', this.objName, ']');
    let index = window.location.pathname.indexOf('E12BROWSER');
    if (index > -1) {
      this.isBrowser = true;
    }
    //To get APPL_DATE_FORMAT
    this.dateFormat = this._searchMenuService.getDateFormat();
    console.log('callFromJsp sdsd>>'+this.callFromJsp);
  }

  ngOnChanges() {
    //console.log('ngOnChanges dayWeekMnthValShownTxtBx>>>[', this.dayWeekMnthValShownTxtBx, ']mainDivId>>>[', this.mainDivId, ']');
    if (this.objDetailsMap != undefined && this.objDetailsMap[this.objName] != null && this.objDetailsMap[this.objName] != "" && this.objDetailsMap[this.objName] != undefined) {
      this.dateArgType = false;
      this.setObjDetails(this.objDetailsMap[this.objName]);
    }
    this.pophelpFieldsDetails = this.pophelpFieldsDetailsMap[this.objName];
    if (this.pophelpFieldsDetails != null && this.pophelpFieldsDetails != "" && this.pophelpFieldsDetails != undefined) {
      this.setPophelpFields(this.pophelpFieldsDetails);
    }
  }

  setObjDetails(objDtlResonse: string) {
    var xmlDoc = new Document();
    this.parser = new DOMParser();
    //changed by sainath t. [angular 9]-start
    var filterNodeList:  HTMLCollectionOf<Element> | NodeList;
    var colInfoNodeList:HTMLCollectionOf<Element> | NodeListOf<Element>;
    var tempNodeLst:HTMLCollectionOf<Element> | NodeListOf<Element>;
    var formalArgsNodeList: HTMLCollectionOf<Element> | NodeList;
    //changed by sainath t. [angular 9]-end
    xmlDoc = this.parser.parseFromString(objDtlResonse, "text/xml");
    //console.log('xmlDoc>>1', xmlDoc.lastElementChild.lastChild);

    //formalArgsNodeList = xmlDoc.getElementsByTagName("FORMALARG");
    formalArgsNodeList = xmlDoc.getElementsByTagName("FORMALARG");
    //console.log('formalArgsNodeList142 [ ', formalArgsNodeList, ' ]');

    filterNodeList = xmlDoc.getElementsByTagName("filter");
    //console.log('filterNodeList>>1', filterNodeList);
    //for permanent filters
    this.setfilterNodeList(filterNodeList);

    colInfoNodeList = xmlDoc.getElementsByTagName("COLINFO");
    //console.log('colInfoNodeList>>1', colInfoNodeList);
    this.setcolInfoNodeList(colInfoNodeList);
    try{

    }
    catch
    {
      var date = new Date();
      var lastyear = date.getFullYear() - 1;
      this.frDate = lastyear + "-04-01 00:00:00.0";
      this.toDate = date.getFullYear() + "-03-31 00:00:00.0";
      //console.log('frmDate  is not found this.frDate==', this.frDate, 'this.toDate==', this.toDate);
    }
    tempNodeLst = xmlDoc.getElementsByTagName("PERIOD_OPTION");
    //console.log("PERIOD_OPTION [ ", tempNodeLst," ]");
    if (tempNodeLst != null && tempNodeLst.item(0) != null && tempNodeLst.item(0)?.hasChildNodes()) {
      try {
        this.periodOption = tempNodeLst.item(0)?.childNodes[0].nodeValue;
        console.log("periodOption[ ", this.periodOption, " ]");
      } catch {
        this.periodOption = "";
        console.log("Error while reading periodOption...");
      }
    }
    this.getPopupContent(formalArgsNodeList, colInfoNodeList, filterNodeList);
  }

  getPopupContent(formalArgsNodeList: HTMLCollectionOf<Element> |NodeList, colInfoNodeList: HTMLCollectionOf<Element> |NodeList, filterNodeList:HTMLCollectionOf<Element> | NodeList): any {
    //console.log('Method getpopcontent:::');
    this.addFormalArgs(formalArgsNodeList);
    if (filterNodeList.toString() != "" && filterNodeList.length > 0) {
      this.isPermntFilter = true;// to display added custom filters
      this.panelOpenState = true;
    }
  }

  setPophelpFields(pophelpFieldsDetails: string): any {
    //For string response seperated by comma
    //console.log('pophelpFieldsDetails xml or Array [', pophelpFieldsDetails, ']');
    if (pophelpFieldsDetails.indexOf("<") == -1) {
      var dummyArray = [] = pophelpFieldsDetails.split(",");
      for (var popField = 0; popField < dummyArray.length; popField++) {
        dummyArray[popField] = dummyArray[popField].replace(/\s*$/, "");
        //console.log('pophelpFieldName From Array [', dummyArray[popField], ']');
        this.setPophelpFieldArr(dummyArray[popField], popField);
        this.setPophelpFieldSqlInpMap("", dummyArray[popField]);
      }
    } 
    else {
      var pophelpXML = new Document();
      this.pophelpParser = new DOMParser();
      var pophelpFieldsNodeList: HTMLCollectionOf<Element> | NodeList;
      pophelpXML = this.pophelpParser.parseFromString(pophelpFieldsDetails, "text/xml");
      pophelpFieldsNodeList = pophelpXML.getElementsByTagName("POPUP");
      //console.log('pophelpFieldsNodeList195 [ ', pophelpFieldsNodeList, ' ]');
      for (var i = 0; i < pophelpFieldsNodeList.length; i++) {
        var pophelpArgsEle:any = pophelpFieldsNodeList.item(i) as Element;
        var nodMap: NamedNodeMap;
        var pophelpFieldName:any = "";
        var sqlInput:any = "";
        var multiOpt:any = "";
        nodMap = pophelpArgsEle.attributes;
        pophelpFieldName = nodMap.getNamedItem("FIELD_NAME")?.nodeValue?.trim();
        sqlInput = nodMap.getNamedItem("SQL_INPUT")?.nodeValue?.trim();
        //Added By Sainath T. on 26-03-2020 [To resolve multi opt multi selection pophelp issue]-Start
        multiOpt = nodMap.getNamedItem("MULTI_OPT")?.nodeValue?.trim();
        if(multiOpt.length > 0)
        {
          var multiOptNo = Number(multiOpt);
          multiOpt = multiOptNo > 0 ? "1" : "0";
        }
        console.log('pophelpFieldName [', pophelpFieldName, '] sqlInput [', sqlInput, ' ] multiOpt[',multiOpt,']');
        this.setPophelpFieldArr(pophelpFieldName, i);
        this.setPophelpFieldSqlInpMap(sqlInput, pophelpFieldName);
        this.setPophelpFieldMultiOptMap(multiOpt, pophelpFieldName);
        //Added By Sainath T. on 26-03-2020 [To resolve multi opt multi selection pophelp issue]-End

      }
    }
    for (var i = 0; i < this.formalArgNamesForPophelpArr.length; i++) {
      if (this.pophelpFildsArray.indexOf(this.formalArgNamesForPophelpArr[i]) !== -1 ||
        this.pophelpFildsArray.indexOf(this.formalArgNamesForPophelpCAPSArr[i]) !== -1) {
        var paramMap:any = {};
        var paramString = "";
        paramMap["OBJ_NAME"] = this.objName;
        paramMap["ACTION"] = "AUTO_SEARCH_POPHELP";
        paramMap["FIELD_NAME"] = this.formalArgNamesForPophelpCAPSArr[i];
        paramMap["SQL_INPUT"] = this.pophelpFieldSqlInpMap[this.formalArgNamesForPophelpCAPSArr[i]];
        paramMap["EDITOR_ID"] = "";
        paramMap["FORM_NO"] = "";
        paramMap["PARAMXML"] = "";
        paramMap["PKVLAUE"] = "";
        paramMap["EDIT_FLAG"] = "";
        paramMap[this.formalArgNamesForPophelpCAPSArr[i]] = 1;
        paramString = this._searchMenuService.getEncodedParamString(paramMap);
        var HOST_URL = this._searchMenuService.getHostURL();
        // console.log('Host UrL>>', HOST_URL);
        var dataSourceForinpSugg = HOST_URL + "/ibase/RIAWizardHandlerServlet?" + paramString;
        //console.log('dataSourceForinpSugg==', dataSourceForinpSugg, 'Index >>', i);
        this._searchMenuService.getPophelpData(dataSourceForinpSugg, this.formalArgNamesForPophelpCAPSArr[i], false, this.frmlArgsTxtBoxArrLst[i])
          .subscribe((data:any) => {
            if (data) {
              console.log('in service to get data Index [', i, '] field name[', data.DETAILS[1]['FIELD_NAME'], ']');
              this.dataSourceForinpSuggMap[data.DETAILS[1]['FIELD_NAME']] = data;
              //console.log('dataSourceForinpSuggMap data from service[', this.dataSourceForinpSuggMap, ']');
            }
          }
          );
        this.refIdForInpSuggArr[i] = this.formalArgNamesForPophelpArr[i]
      }
      else {
        this.dataSourceForinpSuggMap[this.formalArgNamesForPophelpCAPSArr[i]] = "";
        this.refIdForInpSuggArr[i] = "";
      }
    }
  }
  //Added By Sainath T. on 26-03-2020 [To resolve multi opt multi selection pophelp issue]-Start
  setPophelpFieldMultiOptMap(multiOpt: string, pophelpFieldName: string) {
    this.pophelpFieldMultiOptMap[pophelpFieldName] = multiOpt;
console.log('pophelpFieldMultiOptMap after set [', multiOpt,']');
  }
  //Added By Sainath T. on 26-03-2020 [To resolve multi opt multi selection pophelp issue]-End
  setPophelpFieldSqlInpMap(sqlInput: string, pophelpFieldName: string): any {
    this.pophelpFieldSqlInpMap[pophelpFieldName] = sqlInput;
    // console.log('pophelpFieldSqlInpMap after set [', this.pophelpFieldSqlInpMap,']');
  }

  setPophelpFieldArr(pophelpFieldName: string, i: number): any {
    this.pophelpFildsArray[i] = pophelpFieldName;
    //console.log('pophelpFildsArray after set[', this.pophelpFildsArray,']');
  }

  addFormalArgs(formalArgsNodeLst:HTMLCollectionOf<Element> | NodeList) {
    var rowNo = 0;
    var flag = false;
    var frmlArgNames:any = "";
    var frmlArgTypes:any = "";
    var fieldLbls:any = [];
    var frmlArgTypeArray:any = [];
    var frmlArgsTxtBoxArrLst:any = [];

    var arrayFromDate = [
      "fromdate", "from_date",
      "asfromdate", "asFromDate", "asfrom_date", "as_from_date", "frmdate",
      "frdt", "fdt", "fdate", "fr_date", "frdate", "mrefdt1", "date_from", "FROM_DATE"
    ];

    var arrayToDate = [
      "todate", "to_date",
      "astodate", "asToDate", "asto_date", "as_to_date", "todt", "tdt", "tdate", "mrefdt2", "date_to", "TO_DATE"
    ];

    for (var rowNo = 0; rowNo < formalArgsNodeLst.length; rowNo++) {

      var formalArgsEle = formalArgsNodeLst.item(rowNo) as Element;
      var nodMap: NamedNodeMap;
      var frmlArgName:any = "";
      var frmlArgType:any = "";
      nodMap = formalArgsEle.attributes;
      frmlArgName = nodMap.getNamedItem("field_name")?.nodeValue?.trim();
      //console.log('frmlArgName[', frmlArgName,']');

      frmlArgType = nodMap.getNamedItem("javatype")?.nodeValue?.trim();
      //console.log('frmlArgType[', frmlArgType,']');

      var fieldDisplayName = nodMap.getNamedItem("name")?.nodeValue?.trim();
      //console.log('fieldDisplayName[', fieldDisplayName,']');

      var frmlArgValue = null;
      var protectValue = null;
      if (formalArgsNodeLst.item(rowNo)?.childNodes != null) {
        var frmlArgValueNode: NodeList|any;
        frmlArgValueNode = formalArgsNodeLst.item(rowNo)?.childNodes;
        frmlArgValue = frmlArgValueNode.item(0)?.firstChild != null ? frmlArgValueNode.item(0)?.firstChild?.nodeValue : null;
        if (frmlArgValueNode.item(1) != null) {
          protectValue = frmlArgValueNode.item(1)?.firstChild != null ? frmlArgValueNode.item(1)?.firstChild?.nodeValue : null;
        }
      }

      if (frmlArgName != undefined && frmlArgName != 'undefined') {
        frmlArgNames += frmlArgName + ":";
        this.setFrmlArgNames(frmlArgNames);
        this.setFormalArgNamesForPophelp(frmlArgName, rowNo);
      }

      if (arrayFromDate.includes(frmlArgName)) {
        fieldLbls[rowNo] = "From Date :";
      }
      else if (arrayToDate.includes(frmlArgName)) {
        fieldLbls[rowNo] = "To Date :"
      }
      else {
        //Added By Sainath T. on 19-03-2020 [To resolve lables related issue]-Start
        console.log('fieldLbl2 313 else part[', this.fieldLbls,']');
        var  displayNameMap:any = this._searchMenuService.getdisplayNameMap();
        console.log('fieldLbl2 313 else displayNameMap[frmlArgName][', displayNameMap[frmlArgName],']');
        var frAndToFlag = false;
        if(displayNameMap[frmlArgName] != undefined)
        {
          fieldDisplayName = displayNameMap[frmlArgName];
        }
        else if((frmlArgName.indexOf('__') != -1))
        {
          var fromTo = frmlArgName.substring(frmlArgName.indexOf('__')+2);
          fromTo = (fromTo.indexOf('fr') != -1) ? ' from' : fromTo;
          fromTo = (fromTo.indexOf('to') != -1) ? ' to' : fromTo;

          frmlArgName = frmlArgName.substring(0, frmlArgName.indexOf('__'));
          if(displayNameMap[frmlArgName] != undefined)
          {
            fieldDisplayName = displayNameMap[frmlArgName] + fromTo;
          }
        }
        else if (fieldDisplayName?.indexOf("_") != -1) {
          fieldDisplayName = fieldDisplayName?.replace('_', ' ');
        }
        //Added By Sainath T. on 19-03-2020 [To resolve lables related issue]-End
        if (fieldDisplayName?.indexOf("fr") != -1) {
          fieldLbls[rowNo] = fieldDisplayName + ":";
        }
        else if (fieldDisplayName.indexOf("to") != -1) {
          fieldLbls[rowNo] = fieldDisplayName + ":";
        }
      }
      if (frmlArgType != undefined && frmlArgType != 'undefined') {
        frmlArgTypes += frmlArgType + ":";
        this.setFrmlArgTypes(frmlArgTypes);//to pass to viewData
        frmlArgTypeArray[rowNo] = frmlArgType;
        this.setFrmlArgTypeArray(frmlArgTypeArray);//for date picker implementation
        //console.log("frmlArgTypeArray==>[", frmlArgTypeArray,"]");

      }

      if (frmlArgType.toUpperCase() == "date".toUpperCase()) {
        console.log("Arg Type is Date");
        //get input date by date picker
        this.dateArgType = true;
        this.addFrmlArgsValCntrlCompnts();
      }
      else {
        console.log('in else part fieldDisplayName>>'+fieldDisplayName)
        //Added by Sainath T. on 19-03-2020 [for single field input]
        fieldDisplayName = fieldDisplayName?.indexOf(":") == -1 ? (fieldDisplayName + ":") : fieldDisplayName;
        fieldLbls[rowNo] = fieldDisplayName;
        this.textBxTitle = "Detail" + 1 + "." + (rowNo + 2) + "." + frmlArgName.substring(0, frmlArgName.indexOf(":")).toUpperCase();
        this.textBxId = "Detail" + 1 + "." + (rowNo + 2) + "." + frmlArgName.substring(0, frmlArgName.indexOf(":")).toUpperCase();
        var empCodeColName =
          [
            "emp_code:", "empCode:", "EmpCode:", "empcode:", "Employee Code:",
            "EmployeeCode:"
          ];

        var deptCodeColName =
          [
            "dept_code:", "deptCode:", "DeptCode:", "deptcode:", "Department Code:",
            "DepartmentCode:", "Dept_code:"
          ];

        var siteCodeColName =
          [
            "site_code:", "siteCode:", "SiteCode:", "sitecode:", "Site Code:",
            "SiteCode:", "Site_code:"
          ];

        var entityCodeColName =
          [
            "entity_code:", "entityCode:", "EntityCode:", "entitycode:", "Entity Code:",
            "EntityCode:", "Entity_code:"
          ];

        var itemSerColName =
          [
            "itemSer:", "itmSer:", "Item Ser:", "item_series:", "Item Series:"
          ];

        var userIdColName =
          [
            "user_id:", "userId:", "UserId:", "userid:", "User Id:", "user id:",
            "usr_id:", "usrId:"
          ];

        if (empCodeColName.includes(frmlArgName)) {
          frmlArgsTxtBoxArrLst[rowNo] = localStorage.getItem("userName"); // E12Constants.userID ; localstorage.getItem("user_id");
        }
        else if (deptCodeColName.includes(frmlArgName)) {
          frmlArgsTxtBoxArrLst[rowNo] = localStorage.getItem("deptCode"); //E12Constants.deptCode );
        }
        else if (siteCodeColName.includes(frmlArgName)) {
          frmlArgsTxtBoxArrLst[rowNo] = localStorage.getItem("siteCode");// E12Constants.siteCode );
        }
        else if (entityCodeColName.includes(frmlArgName)) {
          frmlArgsTxtBoxArrLst[rowNo] = localStorage.getItem("entityCode");//E12Constants.entityCode );
        }
        else if (itemSerColName.includes(frmlArgName)) {
          frmlArgsTxtBoxArrLst[rowNo] = localStorage.getItem("itemSer");// E12Constants.itemSer );
        }
        else if (userIdColName.includes(frmlArgName)) {
          frmlArgsTxtBoxArrLst[rowNo] = localStorage.getItem("userName");// E12Constants.userID );
          (<HTMLInputElement>document.getElementById(this.textBxId)).readOnly = true;
        }
        else if (frmlArgValue != null) {
          if (protectValue != null && protectValue == "1") {
            frmlArgsTxtBoxArrLst[rowNo] = frmlArgValue;
            (<HTMLInputElement>document.getElementById(this.textBxId)).readOnly = true;
          }
          else {
            frmlArgsTxtBoxArrLst[rowNo] = frmlArgValue;
          }
        }
        else {
          frmlArgsTxtBoxArrLst[rowNo] = "";
        }
        this.setfrmlArgsTxtBoxArrLst(rowNo, frmlArgsTxtBoxArrLst[rowNo]);
      }
      //console.log('fieldLbl2==>232', fieldLbls);
      this.setfieldLbls(fieldLbls);
    }
  }
  setFormalArgNamesForPophelp(frmlArgName: string, rowNo: number): any {
    this.formalArgNamesForPophelpArr[rowNo] = frmlArgName;
    this.formalArgNamesForPophelpCAPSArr[rowNo] = frmlArgName.toUpperCase();
    //console.log( 'After set formalArgNamesForPophelpArr>>', this.formalArgNamesForPophelpArr);
    //console.log( 'After set formalArgNamesForPophelpCAPSArr>>', this.formalArgNamesForPophelpCAPSArr);
    //console.log( 'pophelpFildsArray>>' +this.pophelpFildsArray );
  }
  addFrmlArgsValCntrlCompnts(): any {
    //console.log("addFrmlArgsValCntrlCompnts ==>429");
    this.prvButton = "<";
    this.nxtButton = ">";
    var frmlArgsDtBoxArrLst:any = [];
    var day = new Date();
    var today = this.datePipe.transform(day, this.dateFormat);
    var mm = this.datePipe.transform(day, 'MM')
    var yy = this.datePipe.transform(day, 'yy');
    var yyyy:any = this.datePipe.transform(day, 'yyyy');
    console.log("days ==>438::", today, 'month::', mm, 'yyyy::', yyyy, 'yy::', yy);
    if (this.periodOption == null || this.periodOption == "null" || this.periodOption == "" || this.periodOption == undefined) {
      this.periodOption = "W";
    }
    console.log('periodOption443[', this.periodOption, ']');

    this.period = ["Day", "Week", "Month", "Year", "Accounting Year", "Last 2 Months"]
    this.selectedObject = this.period[0];
    if ("D".includes(this.periodOption)) {
      this.selectedObject = this.period[0];
      frmlArgsDtBoxArrLst[0] = day;
      frmlArgsDtBoxArrLst[1] = day;
      this.dayWeekMnthValShownTxtBx = today;
    }
    else if ("W".includes(this.periodOption)) {
      this.selectedObject = this.period[1];
      var startandEndDateArr = this.getStartEnddateOfWeek();
      frmlArgsDtBoxArrLst[0] = startandEndDateArr[0];
      frmlArgsDtBoxArrLst[1] = startandEndDateArr[1];
      //console.log('frmlArgsDtBoxArrLst', frmlArgsDtBoxArrLst);
      var date:any = "";
      date = frmlArgsDtBoxArrLst[0];
      //console.log('date', date);
      this.dayWeekMnthValShownTxtBx = this.getWeekNo(date).toString();
      //console.log('dayWeekMnthValShownTxtBx>>>336', this.dayWeekMnthValShownTxtBx);
    }
    else if ("Y".includes(this.periodOption)) {
      this.selectedObject = this.period[3];
      var startDateOfYear = "01/01/" + yyyy;
      var endDateOfYear = "12/31/" + yyyy;
      frmlArgsDtBoxArrLst[0] = new Date(startDateOfYear);
      frmlArgsDtBoxArrLst[1] = new Date(endDateOfYear);
      //console.log('frmlArgsDtBoxArrLst[', frmlArgsDtBoxArrLst[0], '][', frmlArgsDtBoxArrLst[1], ']');
      this.dayWeekMnthValShownTxtBx = yyyy;
    }
    else if ("A".includes(this.periodOption)) {
      //console.log('datefrom', this.frDate, 'dateTo', this.toDate);
      var frDate = new Date(this.frDate);
      var toDate = new Date(this.toDate);
      // this.fromAccDate = frmlArgsDtBoxArrLst[0];
      // this.toAccDate = frmlArgsDtBoxArrLst[1];
      var yr1 = this.datePipe.transform(frDate, 'yyyy');
      var yr2 = this.datePipe.transform(toDate, 'yyyy');
      //console.log('y2>>', yr2, 'y1>>', yr1);
      this.dayWeekMnthValShownTxtBx = yr1 + "-" + yr2;
      frmlArgsDtBoxArrLst[0] = frDate;
      frmlArgsDtBoxArrLst[1] = toDate;
    }
    else if ("P".includes(this.periodOption)) {
      this.selectedObject = this.period[5];
      this.dayWeekMnthValShownTxtBx = yyyy + mm;
      this.setDateAsPerSelectionType(this.selectedObject);
    }
    else if ("M".includes(this.periodOption)) {
      this.selectedObject = this.period[2];
      this.dayWeekMnthValShownTxtBx = yyyy + mm;
      var fDay = new Date(day.getFullYear(), day.getMonth(), 1);
      var lDay = new Date(day.getFullYear(), day.getMonth() + 1, 0);
      frmlArgsDtBoxArrLst[0] = new Date(fDay);
      /* if (frmlArgsDtBoxArrLst.length > 1) { */
        frmlArgsDtBoxArrLst[1] = new Date(lDay);
      /* } */
    }
    this.setfrmlArgsDtBoxArrLst(frmlArgsDtBoxArrLst);
  }
  changePeriodSelectionType() {
    this.periodOption = "";
    //console.log('changePeriodSelectionType>>', this.selectedObject);
    this.setDateAsPerSelectionType(this.selectedObject);
  }
  prevDate() {
    this.setPrevDate(this.selectedObject);
  }
  nxtDate() {
    this.setNxtDate(this.selectedObject);
  }
  setDateAsPerSelectionType(selectedObject: any) {
    var day = new Date();
    var frmlArgsDtBoxArrLst:any = [];
    var today = this.datePipe.transform(day, this.dateFormat);
    var mm:any = this.datePipe.transform(day, 'MM')
    var yy = this.datePipe.transform(day, 'yy');
    var yyyy = this.datePipe.transform(day, 'yyyy');
    //console.log('changePeriodSelectionType>>', selectedObject);

    if (selectedObject == "Day")// For Day
    {
      frmlArgsDtBoxArrLst[0] = day;
      frmlArgsDtBoxArrLst[1] = day;
      this.dayWeekMnthValShownTxtBx = today;
      //console.log('dayWeekMnthValShownTxtBx>>', this.dayWeekMnthValShownTxtBx);
      // (<HTMLInputElement>document.getElementById("e12AdvSrch-txtBox")).readOnly = true;
      this.isVisibleTxtBx = true;
    }
    else if (selectedObject == "Week") {
      try {
        var startandEndDateArr = this.getStartEnddateOfWeek();
        //console.log('startandEndDateArr', startandEndDateArr[0], startandEndDateArr[1]);
        frmlArgsDtBoxArrLst[0] = startandEndDateArr[0];
        frmlArgsDtBoxArrLst[1] = startandEndDateArr[1];
        //console.log('frmlArgsDtBoxArrLst', frmlArgsDtBoxArrLst);
        var date:any = "";
        date = frmlArgsDtBoxArrLst[0];
        //console.log('date', date);
        this.dayWeekMnthValShownTxtBx = this.getWeekNo(date).toString();
        this.isVisibleTxtBx = true;
      }
      catch{
        console.log("Exception inside setDateAsPerSelectionType")
      }
    }
    else if (selectedObject == "Month") {
      this.dayWeekMnthValShownTxtBx = yyyy + mm;
      var fDay = new Date(day.getFullYear(), day.getMonth(), 1);
      var lDay = new Date(day.getFullYear(), day.getMonth() + 1, 0);
      //console.log("firstDay::416", fDay, 'lastDay::', fDay);
      frmlArgsDtBoxArrLst[0] = fDay;
      frmlArgsDtBoxArrLst[1] = lDay;
      this.isVisibleTxtBx = false;
    }
    else if (selectedObject == "Year") {
      var startDateOfYear = "01/01/" + yyyy;
      var endDateOfYear = "12/31/" + yyyy;
      frmlArgsDtBoxArrLst[0] = new Date(startDateOfYear);
      frmlArgsDtBoxArrLst[1] = new Date(endDateOfYear);
      //console.log('frmlArgsDtBoxArrLst[', frmlArgsDtBoxArrLst[0], '][', frmlArgsDtBoxArrLst[1], ']');
      this.dayWeekMnthValShownTxtBx = yyyy;
      this.isVisibleTxtBx = false;
    }
    else if (selectedObject == "Accounting Year") {
      //console.log('datefrom', this.frDate, 'dateTo', this.toDate);
      var frDate = new Date(this.frDate);
      var toDate = new Date(this.toDate);
      frmlArgsDtBoxArrLst[0] = frDate;
      frmlArgsDtBoxArrLst[1] = toDate;
      var yr1 = this.datePipe.transform(frDate, 'yyyy');
      var yr2 = this.datePipe.transform(toDate, 'yyyy');
      //console.log('y2>>', yr2);
      //console.log('y1>>', yr1);
      this.dayWeekMnthValShownTxtBx = yr1 + "-" + yr2;
      // (<HTMLInputElement>document.getElementById("e12AdvSrch-txtBox")).readOnly = true;
      this.isVisibleTxtBx = true;
    }
    else if (selectedObject == "Last 2 Months") {
      var yr:any = yyyy;
      this.dayWeekMnthValShownTxtBx = yr + mm;
      var firstAndLastDateArrLst = this.getFirstAndLastTwoMonths(mm, yr, 0);
      frmlArgsDtBoxArrLst[0] = firstAndLastDateArrLst[0];
      frmlArgsDtBoxArrLst[1] = firstAndLastDateArrLst[1];
      // (<HTMLInputElement>document.getElementById("e12AdvSrch-txtBox")).readOnly = true;
      this.isVisibleTxtBx = false;
    }
    this.setfrmlArgsDtBoxArrLst(frmlArgsDtBoxArrLst);
  }

  setPrevDate(selectedObject: any) {
    var frmlArgsDtBoxArrLst:any = [];
    var DAY_IN_MILLIS = 1000 * 60 * 60 * 24;
    if (selectedObject == "Day") {
      frmlArgsDtBoxArrLst = this.gerfrmlArgsDtBoxArrLst();
      //console.log('preDate>>  frmlArgsDtBoxArrLst>', frmlArgsDtBoxArrLst);
      var lastDate = frmlArgsDtBoxArrLst[0];
      var prevDateInMs = lastDate.getTime() - DAY_IN_MILLIS;
      var preDate = new Date(prevDateInMs);
      //console.log('preDate>>', preDate);
      this.dayWeekMnthValShownTxtBx = this.datePipe.transform(preDate, this.dateFormat);
      frmlArgsDtBoxArrLst[0] = preDate;
      frmlArgsDtBoxArrLst[1] = preDate;
    }
    else if (selectedObject == "Week") {
      frmlArgsDtBoxArrLst = this.gerfrmlArgsDtBoxArrLst();
      var currentSDate = new Date(frmlArgsDtBoxArrLst[0]);
      var currentLDate = new Date(frmlArgsDtBoxArrLst[1]);
      currentSDate.setDate(currentSDate.getDate() - 7);
      currentLDate.setDate(currentLDate.getDate() - 7);
      frmlArgsDtBoxArrLst[0] = currentSDate;
      frmlArgsDtBoxArrLst[1] = currentLDate;
      this.dayWeekMnthValShownTxtBx = this.getWeekNo(currentSDate).toString();
      //console.log('dayWeekMnthValShownTxtBx week', this.dayWeekMnthValShownTxtBx);
    }
    else if (selectedObject == 'Month') {
      var dateBoxYear = this.dayWeekMnthValShownTxtBx.trim().substring(0, 4);
      var dateBoxMonth = this.dayWeekMnthValShownTxtBx.trim().substring(4);
      //console.log('dateBoxYear11[', dateBoxYear, '] dateBoxMonth11[', dateBoxMonth, ']');

      if (Number(dateBoxMonth) == 1) {
        dateBoxYear = (Number(dateBoxYear) - 1).toString();
        dateBoxMonth = '12';
      }
      else {
        dateBoxMonth = (Number(dateBoxMonth) - 1).toString();
      }
      var firstNLastDayOfMonth = this.getfirstNLastDayOfMonth(dateBoxYear, dateBoxMonth);
      //console.log('firstNLastDayOfMonth[', firstNLastDayOfMonth, ']');
      frmlArgsDtBoxArrLst[0] = firstNLastDayOfMonth[0];
      frmlArgsDtBoxArrLst[1] = firstNLastDayOfMonth[1];
      var dateBoxMonthNo = Number(dateBoxMonth);
      if (!(dateBoxMonthNo == 10 || dateBoxMonthNo == 11 || dateBoxMonthNo == 12)) {
        dateBoxMonth = 0 + dateBoxMonth;
      }
      this.dayWeekMnthValShownTxtBx = dateBoxYear + dateBoxMonth;
    }
    else if (selectedObject == 'Year') {
      var dateBoxYear = this.dayWeekMnthValShownTxtBx.trim().substring(0, 4);
      if (dateBoxYear.length == 4) {
        dateBoxYear = (Number(dateBoxYear) - 1).toString();
        this.dayWeekMnthValShownTxtBx = dateBoxYear;

        var firstAndLastDateOfYear = this.getFirstAndLastDateOfYear(dateBoxYear);
        frmlArgsDtBoxArrLst[0] = firstAndLastDateOfYear[0];
        frmlArgsDtBoxArrLst[1] = firstAndLastDateOfYear[1];
      }
      else {
        window.alert('Please Enter Year In 4 Digit Format');
      }
      //console.log('FirstAndLastDateOfYear>>', firstAndLastDateOfYear);
    }
    else if (selectedObject == 'Accounting Year') {
      try {
        var yr1 = this.dayWeekMnthValShownTxtBx.substring(0, 4);
        var yr2 = this.dayWeekMnthValShownTxtBx.substring(5);
        if (yr1.length == 4 && yr2.length == 4) {
          frmlArgsDtBoxArrLst = this.gerfrmlArgsDtBoxArrLst();
          var currentSDate = new Date(frmlArgsDtBoxArrLst[0]);
          var currentLDate = new Date(frmlArgsDtBoxArrLst[1]);
          currentSDate.setFullYear(currentSDate.getFullYear() - 1);
          currentLDate.setFullYear(currentLDate.getFullYear() - 1);
          //  console.log('acc currentSDate[', currentSDate, '] and acc currentLDate[', currentLDate, ']');

          var fDYear = this.datePipe.transform(currentSDate, 'yyyy');
          if (currentSDate.getDate() >= 1 || currentLDate.getDate() <= 31) {
            this.strtDt = 1;
            this.endDt = 31;
          }
          var fDay = (currentSDate.getMonth() + 1) + '/' + this.strtDt + '/' + fDYear + ' 02:00:00';
          var strDate = new Date(fDay);
          frmlArgsDtBoxArrLst[0] = strDate;

          var lDYear = this.datePipe.transform(currentLDate, 'yyyy');
          var lDay = (currentLDate.getMonth() + 1) + '/' + this.endDt + '/' + lDYear + ' 02:00:00';

          var endDate = new Date(lDay);
          frmlArgsDtBoxArrLst[1] = endDate;
          //console.log('acc firstAndLastDateArrLst[', frmlArgsDtBoxArrLst);
          var yr1:any = this.datePipe.transform(strDate, 'yyyy');
          var yr2:any = this.datePipe.transform(endDate, 'yyyy');
          this.dayWeekMnthValShownTxtBx = yr1 + "-" + yr2;
        }
        else {
          window.alert('Please Enter Year In 4 Digit Format');
        }
      }
      catch{
        console.log('Exception in previous date of accyear');
      }
    }
    else if (selectedObject == 'Last 2 Months') {
      frmlArgsDtBoxArrLst = [];
      var dateBoxYear = this.dayWeekMnthValShownTxtBx.trim().substring(0, 4);
      var dateBoxYear1 = this.dayWeekMnthValShownTxtBx.trim().substring(0, 4);
      var dateBoxMon = this.dayWeekMnthValShownTxtBx.trim().substring(4);
      var dateBoxMonth = this.dayWeekMnthValShownTxtBx.trim().substring(4);
      if (dateBoxYear.length == 4 && dateBoxMon.length == 2) {
        dateBoxMonth = (Number(dateBoxMonth) - 1).toString();
        dateBoxMon = (Number(dateBoxMon) - 1).toString();

        if (dateBoxMonth == "0") {
          dateBoxMonth = "12";
          dateBoxYear = (Number(dateBoxYear) - 1).toString();
          dateBoxYear1 = (Number(dateBoxYear)).toString();
        }
        else if (dateBoxMonth == "-1") {
          dateBoxMonth = "11";
        }
        if (dateBoxMon == "0") {
          dateBoxMon = "12";
        }
        var dtBxMonthNo = Number(dateBoxMonth);
        if (!(dtBxMonthNo == 10 || dtBxMonthNo == 11 || dtBxMonthNo == 12)) {
          dateBoxMonth = 0 + dateBoxMonth;
        }
        var dtBxMonthNo1 = Number(dateBoxMon);
        if (!(dtBxMonthNo1 == 10 || dtBxMonthNo1 == 11 || dtBxMonthNo1 == 12)) {
          dateBoxMon = 0 + dateBoxMon;
        }
        var firstAndLastDate = this.getFirstAndLastTwoMonths(dateBoxMonth, dateBoxYear, 0);
        frmlArgsDtBoxArrLst[0] = firstAndLastDate[0];
        frmlArgsDtBoxArrLst[1] = firstAndLastDate[1];

        this.dayWeekMnthValShownTxtBx = dateBoxYear1 + dateBoxMon;
      }
      else {
        window.alert('Please Enter Year In 4 Digit and Month in 2 Digit Format');
      }
    }
    this.setfrmlArgsDtBoxArrLst(frmlArgsDtBoxArrLst);
  }

  setNxtDate(selectedObject: any) {
    var frmlArgsDtBoxArrLst:any = [];
    var DAY_IN_MILLIS = 1000 * 60 * 60 * 24;
    if (selectedObject == "Day") {
      frmlArgsDtBoxArrLst = this.gerfrmlArgsDtBoxArrLst();
      var lastDate = frmlArgsDtBoxArrLst[0];
      //console.log('lastDate>>', lastDate);
      var nxtDateInMs = lastDate.getTime() + DAY_IN_MILLIS;
      var nxtDate = new Date(nxtDateInMs);
      //console.log('preDate>>', nxtDate);
      this.dayWeekMnthValShownTxtBx = this.datePipe.transform(nxtDate, this.dateFormat);
      frmlArgsDtBoxArrLst[0] = nxtDate;
      frmlArgsDtBoxArrLst[1] = nxtDate;
    }
    else if (selectedObject == "Week") {
      //console.log('dayWeekMnthValShownTxtBx week in nxtclick[', this.dayWeekMnthValShownTxtBx,']');
      frmlArgsDtBoxArrLst = this.gerfrmlArgsDtBoxArrLst();
      var currentSDate = new Date(frmlArgsDtBoxArrLst[0]);
      var currentLDate = new Date(frmlArgsDtBoxArrLst[1]);
      currentSDate.setDate(currentSDate.getDate() + 7);
      currentLDate.setDate(currentLDate.getDate() + 7);
      frmlArgsDtBoxArrLst[0] = currentSDate;
      frmlArgsDtBoxArrLst[1] = currentLDate;

      this.dayWeekMnthValShownTxtBx = this.getWeekNo(currentSDate).toString();
      //console.log('dayWeekMnthValShownTxtBx week in nxtclick', this.dayWeekMnthValShownTxtBx);
    }
    else if (selectedObject == 'Month') {
      var dateBoxYear = this.dayWeekMnthValShownTxtBx.trim().substring(0, 4);
      var dateBoxMonth = this.dayWeekMnthValShownTxtBx.trim().substring(4);
      //console.log('dateBoxYear nxt[', dateBoxYear, '] dateBoxMonth nxt[', dateBoxMonth, ']');

      if (Number(dateBoxMonth) == 12) {
        dateBoxYear = (Number(dateBoxYear) + 1).toString();
        dateBoxMonth = '1';
      }
      else {
        dateBoxMonth = (Number(dateBoxMonth) + 1).toString();
      }
      var firstNLastDayOfMonth = this.getfirstNLastDayOfMonth(dateBoxYear, dateBoxMonth);
      //console.log('firstNLastDayOfMonth nxt[', firstNLastDayOfMonth, ']');
      frmlArgsDtBoxArrLst[0] = firstNLastDayOfMonth[0];
      frmlArgsDtBoxArrLst[1] = firstNLastDayOfMonth[1];
      var dateBoxMonthNo = Number(dateBoxMonth);
      if (!(dateBoxMonthNo == 10 || dateBoxMonthNo == 11 || dateBoxMonthNo == 12)) //To append 0 for single digit months i.e. for January to September.
      {
        dateBoxMonth = 0 + dateBoxMonth;
      }
      this.dayWeekMnthValShownTxtBx = dateBoxYear + dateBoxMonth;
    }
    else if (selectedObject == 'Year') {
      //console.log('FirstAndLastDateOfYear nxt>>11', this.dayWeekMnthValShownTxtBx);
      var dateBoxYear = this.dayWeekMnthValShownTxtBx.trim().substring(0, 4);
      if (dateBoxYear.length == 4) {
        dateBoxYear = (Number(dateBoxYear) + 1).toString();
        this.dayWeekMnthValShownTxtBx = dateBoxYear;
        var firstAndLastDateOfYear = this.getFirstAndLastDateOfYear(dateBoxYear);
        frmlArgsDtBoxArrLst[0] = firstAndLastDateOfYear[0];
        frmlArgsDtBoxArrLst[1] = firstAndLastDateOfYear[1];
      }
      else {
        window.alert('Please Enter Year In 4 Digit Format');
      }
      //console.log('FirstAndLastDateOfYear nxt>>', firstAndLastDateOfYear);
    }

    else if (selectedObject == 'Accounting Year') {
      try {
        var yr1 = this.dayWeekMnthValShownTxtBx.substring(0, 4);
        var yr2 = this.dayWeekMnthValShownTxtBx.substring(5);
        if (yr1.length == 4 && yr2.length == 4) {
          //this.accCount--;
          frmlArgsDtBoxArrLst = this.gerfrmlArgsDtBoxArrLst();
          var currentSDate = new Date(frmlArgsDtBoxArrLst[0]);
          var currentLDate = new Date(frmlArgsDtBoxArrLst[1]);
          currentSDate.setFullYear(currentSDate.getFullYear() + 1);
          currentLDate.setFullYear(currentLDate.getFullYear() + 1);
          // console.log('acc currentSDate nxt[', currentSDate, '] and acc currentLDate nxt[', currentLDate, ']');

          var fDYear = this.datePipe.transform(currentSDate, 'yyyy');
          if (currentSDate.getDate() >= 1 || currentLDate.getDate() <= 31) {
            this.strtDt = 1;
            this.endDt = 31;
          }
          var fDay = (currentSDate.getMonth() + 1) + '/' + this.strtDt + '/' + fDYear + ' 02:00:00';
          var strDate = new Date(fDay);

          frmlArgsDtBoxArrLst[0] = strDate;
          var lDYear = this.datePipe.transform(currentLDate, 'yyyy');
          var lDay = (currentLDate.getMonth() + 1) + '/' + this.endDt + '/' + lDYear + ' 02:00:00';

          var endDate = new Date(lDay);
          frmlArgsDtBoxArrLst[1] = endDate;
          //console.log('acc firstAndLastDateArrLst[', frmlArgsDtBoxArrLst);
          var yr1:any = this.datePipe.transform(strDate, 'yyyy');
          var yr2:any = this.datePipe.transform(endDate, 'yyyy');
          this.dayWeekMnthValShownTxtBx = yr1 + "-" + yr2;
        }
        else {
          window.alert('Please Enter Year In 4 Digit Format');
        }
      }
      catch{
        console.log('Exception in previous date of accyear');
      }
    }

    else if (selectedObject == 'Last 2 Months') {
      frmlArgsDtBoxArrLst = [];
      var dateBoxYear = this.dayWeekMnthValShownTxtBx.trim().substring(0, 4);
      var dateBoxYear1 = this.dayWeekMnthValShownTxtBx.trim().substring(0, 4);
      var dateBoxMon = this.dayWeekMnthValShownTxtBx.trim().substring(4);
      var dateBoxMonth = this.dayWeekMnthValShownTxtBx.trim().substring(4);
      //console.log('dateBoxMonth', dateBoxMonth);
      if (dateBoxYear.length == 4 && dateBoxMon.length == 2) {
        if (dateBoxMonth == "01") {
          dateBoxYear1 = (Number(dateBoxYear1) - 1).toString();
          dateBoxMonth = (Number(dateBoxMonth) + 1).toString();
          dateBoxMon = (Number(dateBoxMon) + 1).toString();
        }
        if (dateBoxMonth == "12") {
          dateBoxYear = (Number(dateBoxYear) + 1).toString();
          dateBoxMonth = "1";
          dateBoxMon = "1";
        }
        else {
          dateBoxMonth = (Number(dateBoxMonth) + 1).toString();
          dateBoxMon = (Number(dateBoxMon) + 1).toString();
        }
        var firstAndLastDate = this.getFirstAndLastTwoMonths(dateBoxMonth, dateBoxYear, 1);
        frmlArgsDtBoxArrLst[0] = firstAndLastDate[0];
        frmlArgsDtBoxArrLst[1] = firstAndLastDate[1];

        var dtBxMonthNo = Number(dateBoxMonth);
        if (!(dtBxMonthNo == 10 || dtBxMonthNo == 11 || dtBxMonthNo == 12)) {
          dateBoxMonth = 0 + dateBoxMonth;
        }
        var dtBxMonthNo1 = Number(dateBoxMon);
        if (!(dtBxMonthNo1 == 10 || dtBxMonthNo1 == 11 || dtBxMonthNo1 == 12)) {
          dateBoxMon = 0 + dateBoxMon;
        }
        this.dayWeekMnthValShownTxtBx = dateBoxYear + dateBoxMon;
      }
      else {
        window.alert('Please Enter Year In 4 Digit and Month in 2 Digit Format');
      }
    }
    this.setfrmlArgsDtBoxArrLst(frmlArgsDtBoxArrLst);
  }

  //at line no.161 in e12Advnserach
  onSearchClick() {
    var frmlArgNames = this.getFrmlArgNames();
    var frmlArgTypes = this.getFrmlArgTypes();
    //Buil filter expression for Bydefault filter -Start
    var prmntFilterValuePromtTxtBoxArr = this._searchMenuService.getPrmntFilterValuePromtTxtBoxArr();
    var isPrmntCheckBoxStatusArr = this._searchMenuService.getPrmntCheckBoxStatus();
    var prmntValuePmptArrLst = this._searchMenuService.getPrmntValuePmptArrLst();
    var prmntFilterValueArrLst = this._searchMenuService.getPrmntfilterValueArrLst();
    var prmntOperatorNameArrLst = this._searchMenuService.getPrmntoperatorNameArrLst();
    var prmntFieldNameArrLst = this._searchMenuService.getPrmntfieldNameArrLst();
    var prmntOperandNameArrList = this._searchMenuService.getPrmntOperandNameArrList();
    var permntFilterNamesArrLstForMap = this._searchMenuService.getPermanentFltrNameListForMap();
    var prmntFilterNamesArrLstLabel = this._searchMenuService.getprmntfilterNamesArrLst();

    if (prmntFieldNameArrLst.length > 0) {
      console.log('First call gone for create filter expr from by default filter!!!!!!!!');
      this.createFilterExpression(prmntFilterValuePromtTxtBoxArr, isPrmntCheckBoxStatusArr,
        permntFilterNamesArrLstForMap, prmntFilterNamesArrLstLabel, prmntOperatorNameArrLst,
        prmntFilterValueArrLst, prmntOperandNameArrList, prmntFieldNameArrLst, prmntValuePmptArrLst);
      this.setpermntFilterNamesArrLstForMap(permntFilterNamesArrLstForMap);
    }
    //Buil filter expression for Bydefault filter -End

    //Buil filter expression for custome filter -Start
    var filterValuePromtTxtBoxArr = this._searchMenuService.getFilterValuePromtTxtBoxArr();
    this.createFilterExpression(filterValuePromtTxtBoxArr, this.isValueCheckBoxStatusArr,
      this.filterNameArrForExprMap, this.filterNamesArrLst, this.operatorNameArrLst,
      this.filterValueArrLst, this.codtnValueArr, this.fieldNameArrLst, this.promtValuOptArr);
    //Buil filter expression for custome filter -End

    var advQuery = this.getAdvQuery();
    var frmlArgValues = this.getFrmlArgValues();
    var searchParam = this.getSearchParam();

    //console.log('frmlArgNames[', frmlArgNames, ']frmlArgTypes[', frmlArgTypes, '] advQuery[', advQuery, '] frmlArgValues[', frmlArgValues, '] serach param', searchParam);

    this.viewData(frmlArgValues, frmlArgNames, frmlArgTypes, advQuery, searchParam);
  }
  getAdvQuery() {
    //console.log('getAdvQuery? ==>this.allFiterExprMap', this.allFltrNameFltrExprHMap,'permntFilterNamesArrLstForMap>>', this.permntFilterNamesArrLstForMap);
    var advQuery = "";
    if (this.permntFilterNamesArrLstForMap.length > 0) {
      for (let key of this.permntFilterNamesArrLstForMap) {
        if (this.allFltrNameFltrExprHMap[key]) {
          advQuery += "(" + this.allFltrNameFltrExprHMap[key] + ")";
          advQuery += "And";
        }
      }
    }
    for (let key of this.filterNameArrForExprMap) {
      if (this.allFltrNameFltrExprHMap[key]) {
        advQuery += "(" + this.allFltrNameFltrExprHMap[key] + ")";
        advQuery += "And";
      }
    }
    advQuery = advQuery.substring(0, advQuery.length - 3);
    //console.log('fltrExpr>>1111', advQuery);
    return advQuery;
  }

  viewData(frmlArgValues: string, frmlArgNames: string, frmlArgTypes: string, advQuery: string, searchParam: string): any {
   this._searchMenuService.setLoading(true);
    var paramMap:any = {};
    var vcurrentRowNumber = 0;
    var pageSize = 100;
    paramMap["ACTION"] = "ZIP_DOWNLOAD";
    paramMap["OBJ_NAME"] = this.objName;
    paramMap["ADV_QRY"] = advQuery;
    paramMap["ARG_NAMES"] = frmlArgNames;
    paramMap["ARG_TYPE"] = frmlArgTypes;
    paramMap["ARG_VALUE"] = frmlArgValues;
    paramMap["SEARCH_PARAM"] = searchParam;
    paramMap["VISIBLE_FLD_FLAG"] = this.isVisibleColDispFlag;
    //this.currentRowNumber(0);1903
    if (searchParam.length == 0) {
      paramMap["CURR_ROW_NUM"] = vcurrentRowNumber.toString();
      paramMap["UPTO_ROW_NUM"] = pageSize.toString();
    }
    else {
      console.log('else 1025');
    }

    paramMap["dummyInt"] = "" + Math.random();
    var paramString = this._searchMenuService.getEncodedParamString(paramMap);
    this._searchMenuService.getViewData(paramString).subscribe(
      (data:any) => {
        if (data) {
          this.viewDataResponse = data;
          //console.log('viewDataResponse==>[' + this.viewDataResponse + ']');
          //Logic to download the zip file-START
          if (this.viewDataResponse != '') {
          //Commented & Added By Vikas Lagad on 20-08-2019[Start]
            this._searchMenuService.setLoading(false);
            alert('Job Id Created with : ' + this.viewDataResponse);

          /* 
           if (this.viewDataResponse.indexOf("Success Path:") != -1) {
              var fileName = this.viewDataResponse;
              //fileName = fileName.substring(fileName.indexOf("HeaderDataFiles"), fileName.length);
              fileName = fileName.substring(fileName.indexOf('HeaderDataZIPFiles/') + 19,fileName.length);
              console.log('fileName>>825', fileName);
              this._searchMenuService.downlopadFile(fileName).subscribe(
                data => {
                  this._searchMenuService.setLoading(false);

                  var myBlob = new Blob([data], { type: 'application/zip' });
                  var blobURL = (window.URL).createObjectURL(myBlob);
                  var anchor = document.createElement("a");
                  anchor.download = fileName;
                  anchor.href = blobURL;
                  anchor.click();
                });
            }
            else */ 
            //Commented & Added By Vikas Lagad on 20-08-2019[End]
            if (this.viewDataResponse == 'Failure') {
              alert('No Data Found');
              this._searchMenuService.setLoading(false);
            }
            else if (this.viewDataResponse.indexOf('Errors') != -1) {
              var errorData: any[] = this._searchMenuService.getErrorData(this.viewDataResponse);
              //console.log('errorData', errorData);
              var msg = errorData[0] != undefined ? errorData[0]:"";
              var msgDescr = errorData[1] != undefined ? errorData[1]:"";
              var msgTrace = errorData[2] != undefined ? errorData[2]:"";
              var errMsg = this._searchMenuService.getErrorMsg(msg, msgDescr, msgTrace);
              console.log('errMsg', errMsg);
              this._searchMenuService.setLoading(false);
              alert(errMsg);
            }
          }
          //Logic to download the zip file-END
        }
      }
    );
  }

  getFrmlArgValues() {
    var frmlArgValues = "";
    var frmlArgsDtBoxArrLst = this.gerfrmlArgsDtBoxArrLst();
    var frmlArgsTxtBoxArrLst = this.gerfrmlArgsTxtBoxArrLst();

    //console.log('frmlArgsDtBoxArrLst>>[', frmlArgsDtBoxArrLst, "] frmlArgsTxtBoxArrLst>>[", frmlArgsTxtBoxArrLst,"]");
    for (var i = 0; i < this.frmlArgTypeArray.length; i++) {

      if (this.frmlArgTypeArray[i].includes("date")) {
        //console.log('frmlArgType==[', this.frmlArgTypeArray[i], ' ]frmlArgsDtBox==[', frmlArgsDtBoxArrLst[i],"]")
        var dateValue = this.datePipe.transform(frmlArgsDtBoxArrLst[i], this.dateFormat);
        //Added by sadique shaikh on 19/01/2021 [check null and undefined condition] START
        if(dateValue != null && dateValue != undefined)
        {
            frmlArgValues += dateValue + ":";
        }
        //Added by sadique shaikh on 19/01/2021 [check null and undefined condition] END
      }
      else {
        for (var i = 0; i < frmlArgsTxtBoxArrLst.length; i++) 
        {
          if(frmlArgsTxtBoxArrLst[i] != undefined)
          frmlArgValues += frmlArgsTxtBoxArrLst[i] + ":";
        }
      }
    }
    return frmlArgValues;
  }

  getfirstNLastDayOfMonth(dateBoxYear: string, dateBoxMonth: string): any {
    //console.log('dateBoxYear[', dateBoxYear, '] dateBoxMonth[', dateBoxMonth, ']');
    var firstNLastDayOfMonth:any = [];
    var inputDate = dateBoxYear + '-' + dateBoxMonth + '-' + '01 00:00:00.0';
    var newdate = new Date(inputDate);
    var fDay = new Date(newdate.getFullYear(), newdate.getMonth(), 1);
    var lDay = new Date(newdate.getFullYear(), newdate.getMonth() + 1, 0);
    //console.log('fDay[', fDay, '] lDay[', lDay, ']');
    firstNLastDayOfMonth[0] = fDay;
    firstNLastDayOfMonth[1] = lDay;
    return firstNLastDayOfMonth;
  }

  getFirstAndLastDateOfYear(dateBoxYear: string): any {
    var firstAndLastDateArrLst:any = [];
    var startDateOfYear = "01/01/" + dateBoxYear;
    var endDateOfYear = "12/31/" + dateBoxYear;
    firstAndLastDateArrLst[0] = new Date(startDateOfYear);
    firstAndLastDateArrLst[1] = new Date(endDateOfYear);
    return firstAndLastDateArrLst;
  }

  getStartEnddateOfWeek() {
    var startEndDateOfWeek:any = [];
    var day = new Date();
    var firstDateOfWeek = (day.setDate(day.getDate() - ((day.getDay() + 6) % 7)));
    var lastDateOfWeek = (day.setDate(day.getDate() + 7 - day.getDay()));
    //console.log('startDate475', firstDateOfWeek);
    startEndDateOfWeek.push(new Date(firstDateOfWeek));
    //console.log('endDate1483', firstDateOfWeek);
    startEndDateOfWeek.push(new Date(lastDateOfWeek));
    return startEndDateOfWeek;
  }
  getFormattedDateString(txtdate: string, year: string) {
    var inputYear = year;
    txtdate = txtdate + ' 02:00:00';
    //console.log('inputDate>>721', txtdate); // MM/dd/yyyy 02:00:00
    var yyyy:any = "";
    try {
      yyyy = this.datePipe.transform(txtdate, 'yyyy');
    }
    catch{
      yyyy = "";
    }
    var txtdate1 = [] = txtdate.split(' ');
    var dt = txtdate1[0].split(/\//);
    var time = txtdate1[1];
    if (yyyy.length < 1) {
      if (inputYear.length > 0) {
        var yr = inputYear.substring(0, 2); //1993 - takes 19 and append the dt[2]
        yyyy = yr + dt[2];
      }
      else {
        yyyy = '20' + dt[2];
      }
    }
    //console.log('11yyyy>>', yyyy, 'MM>>', dt[1], 'DD>>', dt[0]);
    var inputD = dt[1] + '/' + dt[0] + '/' + yyyy + ' ' + time;
    //console.log('inputDate>>111', inputD); // MM/dd/yyyy 02:00:00
    return inputD;
  }

  getFirstAndLastTwoMonths(mm: string, yr: string, val: number) {
    //console.log('getFirstAndLastTwoMonths ==>534');
    //console.log('mm ==>', mm, 'yr', yr, 'val', val);

    var firstAndLastDateArrLst:any = [];
    var startDate = "";
    var endDate = "";
    var preYear = Number(yr);
    var pYear = preYear - 1;
    var nextYear = Number(yr);
    var nYear = nextYear + 1;
    switch (Number(mm)) {
      case 1:
        if (val == 1) {
          startDate = "01/Nov/" + yr;
          endDate = "31/Dec/" + yr;
        }
        else {
          startDate = "01/Nov/" + pYear;
          endDate = "31/Dec/" + pYear;
        }
        break;
      case 2:
        if (val == 1) {
          startDate = "01/Dec/" + yr;
          endDate = "31/Jan/" + nYear;
        }
        else {
          startDate = "01/Dec/" + pYear;
          endDate = "31/Jan/" + yr;
        }
        break;
      case 3:
        startDate = "01/Jan/" + yr;
        var year = Number(yr);
        //Checking for leap year.
        if (year % 4 == 0 && year % 100 != 0)							//Divisible by 4 but not 100.
        {
          endDate = "29/Feb/" + yr;
        }
        else if (year % 400 == 0) 									//Year Divisible by 4 and 100 and 400
        {
          endDate = "29/Feb/" + yr;
        }
        else {
          endDate = "28/Feb/" + yr;
        }
        break;
      case 4:
        startDate = "01/Feb/" + yr;
        endDate = "31/Mar/" + yr;
        break;
      case 5:
        startDate = "01/Mar/" + yr;
        endDate = "30/Apr/" + yr;
        break;
      case 6:
        startDate = "01/Apr/" + yr;
        endDate = "31/May/" + yr;
        break;
      case 7:
        startDate = "01/May/" + yr;
        endDate = "30/Jun/" + yr;
        break;
      case 8:
        startDate = "01/Jun/" + yr;
        endDate = "31/Jul/" + yr;
        break;
      case 9:
        startDate = "01/Jul/" + yr;
        endDate = "31/Aug/" + yr;
        break;
      case 10:
        startDate = "01/Aug/" + yr;
        endDate = "30/Sep/" + yr;
        break;
      case 11:
        startDate = "01/Sep/" + yr;
        endDate = "31/Oct/" + yr;
        break;
      case 12:
        startDate = "01/Oct/" + yr;
        endDate = "30/Nov/" + yr;
    }
    if (startDate.length > 0) {
      try {
        firstAndLastDateArrLst[0] = new Date(startDate);
        firstAndLastDateArrLst[1] = new Date(endDate);
        //console.log('firstAndLastDateArrLst[0]-[', firstAndLastDateArrLst[0], ']firstAndLastDateArrLst[1]-[', firstAndLastDateArrLst[1], ']');
      }
      catch
      {
        //console.log('Exception while converting to date format');
      }
    }
    return firstAndLastDateArrLst;
  }

  getWeekNo(dt: any) {
    var date1 = new Date(dt);
    //console.log('week no date1>>', date1);
    // Copy date so don't modify original
    var d = new Date(Date.UTC(date1.getFullYear(), date1.getMonth(), date1.getDate()));
    // Make Sunday's day number 7
    d.setUTCDate(d.getUTCDate() + 4 - (d.getUTCDay() || 7));
    // Get first day of year
    var yearStart = new Date(Date.UTC(d.getUTCFullYear(), 0, 1));
    //console.log('yearStart>>', yearStart);
    // Calculate full weeks to nearest Thursday
    var weekNo = Math.ceil((((Number(d) - Number(yearStart)) / 86400000) + 1) / 7);
    console.log('weekNo785>>', weekNo);

    return weekNo;
  }


  /**
   * @param frmlArgNames the frmlArgNames to set
   */
  setFrmlArgNames(frmlArgNames: string) {
    this.frmlArgNames = frmlArgNames;
  }

  /**
 * @return the frmlArgNames
 */
  public getFrmlArgNames(): string {
    return this.frmlArgNames;
  }
  /**
 * @return the frmlArgTypes
 */
  public getFrmlArgTypes() {
    return this.frmlArgTypes;
  }

	/**
	 * @param frmlArgTypes the frmlArgTypes to set
	 */
  public setFrmlArgTypes(frmlArgTypes: string) {
    this.frmlArgTypes = frmlArgTypes;
  }

  setfrmlArgsDtBoxArrLst(frmlArgsDtBoxArrLst: any[]) {
    this.frmlArgsDtBoxArrLst = frmlArgsDtBoxArrLst;
  }
  gerfrmlArgsDtBoxArrLst() {
    return this.frmlArgsDtBoxArrLst;
  }

  setfrmlArgsTxtBoxArrLst(idx:any, value:any) {
    this.frmlArgsTxtBoxArrLst[idx] = value;
    //console.log('after set frmlArgsTxtBoxArrLst', this.frmlArgsTxtBoxArrLst);
  }
  gerfrmlArgsTxtBoxArrLst() {
    return this.frmlArgsTxtBoxArrLst;
  }
  setFrmlArgTypeArray(frmlArgTypeArray: any[]): any {
    this.frmlArgTypeArray = frmlArgTypeArray;
  }

  setfieldLbls(fieldLbls: any[]) {
    this.fieldLbls = fieldLbls;
  }

  setcolInfoNodeList(colInfoNodeList: HTMLCollectionOf<Element> | NodeListOf<Element>): any {
    this.colInfoNodeList = colInfoNodeList;
    this._searchMenuService.setColInFoNodeListMap(this.objName, colInfoNodeList);
  }
  setfilterNodeList(filterNodeList: HTMLCollectionOf<Element> | NodeList): any {
    this.filterNodeList = filterNodeList;
  }

  getSearchParam(): any {
    return this.searchParam;
  }

  //For bydefault filter-Start
  setpermntFilterNamesArrLstForMap(permntFilterNamesArrLstForMap: any[]): any {
    this.permntFilterNamesArrLstForMap = permntFilterNamesArrLstForMap;
  }
  //For bydefault filter-End
  //Sai - Add custom Filter
  addCustomFilter(editFilterJson: any) {
    //console.log('editFilterJson in home page [', editFilterJson, ']');
    var iseditJson = this._searchMenuService.isEmpty(editFilterJson);
    //console.log('iseditJson in home page[', iseditJson, ']');
    if (!iseditJson) {
      this.editFilterJson = editFilterJson;
    }
    //console.log('addCustomFilter befor flag>>', this.isCustomFilter);
    this.setIsCustomFilter(true);
    //console.log('addCustomFilter After flag>>', this.isCustomFilter);
    if (this.isCustomFilter) {
      setTimeout(() => this.createPopup(), 200)
      
     /*  document.getElementById("homePagePopupComp" + this.randomNo).style.display = "none";

      document.getElementById("CustomFilterAddBtn" + this.randomNo).style.display = "none";

      document.getElementById("HomePageFooter" + this.randomNo).style.display = "none"; */
    }
  }
  onCustFilterCancel() {
    console.log('In onCustFilterCancel!!');
    this.setIsCustomFilter(false);

    if (!this._searchMenuService.isEmpty(this.editFilterJson)) {
      console.log('Now!! editJson is empty');
      this.editFilterJson = {};
    }
    if (!this.isCustomFilter) {
      /* document.getElementById("homePagePopupComp" + this.randomNo).style.display = "";
      document.getElementById("CustomFilterAddBtn" + this.randomNo).style.display = "";
      document.getElementById("HomePageFooter" + this.randomNo).style.display = ""; */
      this.overlayRef.dispose();
    }
  }
  onCustFilterDone(customFilterJson: any) {
    //console.log('in home page customFilterJson>>', customFilterJson);
    if (!this._searchMenuService.isEmpty(this.editFilterJson)) {
      //here we can r8 remove logic
      console.log('Now!! editJson is empty');
      this.editFilterJson = {};
    }
    this.isAddFilter = false;
    if (customFilterJson) {
      this.isAddFilter = true;

      this.filterNameArrForExprMap.push(customFilterJson['filterNameArrForExprMap'])

      this.isValueCheckBoxStatusArr.push(customFilterJson['isValueCheckBoxStatusArr']);
      //console.log('in home page this.isValueCheckBoxStatusArr>>', this.isValueCheckBoxStatusArr);

      this.filterValueArrLst.push(customFilterJson['filterValueArrLst']);
      //console.log('in home page this.filterValueArrLst>>', this.filterValueArrLst);

      this.fieldNameArrLst.push(customFilterJson['fieldNameArrLst']);
      //console.log('in home page this.fieldNameArrLst>>', this.fieldNameArrLst);
      this.operatorNameArrLst.push(customFilterJson['operatorNameArrLst']);
      //console.log('in home page this.operatorNameArrLst>>', this.operatorNameArrLst);
      this.promtValuOptArr.push(customFilterJson['promtValuOptArr']);
      //console.log('in home page this.promtValuOptArr>>', this.promtValuOptArr);
      this.codtnValueArr.push(customFilterJson['codtnValueArr']);
      //console.log('in home page this.codtnValueArr>>', this.codtnValueArr);
      this.fieldTypeMap.push(customFilterJson['fieldTypeMap']);
      //console.log('in home page this.fieldTypeMap>>', this.fieldTypeMap);
      this.filterNamesArrLst.push(customFilterJson['filterNamesArrLst']);
      //console.log('in home page this.filterNamesArrLst>>', this.filterNamesArrLst);
      this.andOrAddArrCounter.push(customFilterJson['andOrAddArr']);
      //console.log('in home page this.andOrAddArrCounter>>', this.andOrAddArrCounter);

      this.isDateArr.push(customFilterJson['isDateArr']);
      //console.log('in home page this.isDateArr>>', this.isDateArr);

      var editSelectedInputFieldIndx = customFilterJson['selectedInputFieldIndx'];
      var editselectedFilterName = customFilterJson['editselectedFilterName'];

      //console.log('in home page this.editSelectedInputFieldIndx>>', editSelectedInputFieldIndx, 'editselectedFilterName>>', editselectedFilterName);
      //2803
      this.indexArrayForPushAndOrAddArr = customFilterJson['indexArrayForPushAndOrAddArr'];
      //console.log('in home page this.indexArrayForPushAndOrAddArr>>',this.indexArrayForPushAndOrAddArr)

      if (editselectedFilterName != "") {
        this.removeSelectedFilterName(editselectedFilterName);//Remove Logic
      }

      if (editSelectedInputFieldIndx != null) {
        // console.log('editSelectedInputFieldIndx is not null==', editSelectedInputFieldIndx);
        this.removeSelectedFilterIndex(editSelectedInputFieldIndx);//Remove Logic
      }
      this.panelOpenState = true;
    }
    this.setIsCustomFilter(false);
    if (!this.isCustomFilter) {
      /* document.getElementById("homePagePopupComp" + this.randomNo).style.display = "";
      document.getElementById("CustomFilterAddBtn" + this.randomNo).style.display = "";
      document.getElementById("HomePageFooter" + this.randomNo).style.display = ""; */
      this.overlayRef.dispose();
    }
  }

  onRemoveFilterClick(removeJson: any) {
    console.log('in onRemoveFilterClick!!')
    var removeFilterIndx = removeJson['editselectedInputFieldIndx'];
    var removeFilterName = removeJson['editselectedFilterName'];
    //console.log('in onRemoveFilterClick!! removeFilterIndx', removeFilterIndx, 'removeFilterName', removeFilterName);

    this.removeSelectedFilterIndex(removeFilterIndx);
    this.removeSelectedFilterName(removeFilterName);
    if (!this._searchMenuService.isEmpty(this.editFilterJson)) {
      console.log('Now!! editJson is empty');
      this.editFilterJson = {};
    }

    this.setIsCustomFilter(false);
    if (!this.isCustomFilter) {
      /* document.getElementById("homePagePopupComp" + this.randomNo).style.display = "";
      document.getElementById("CustomFilterAddBtn" + this.randomNo).style.display = "";
      document.getElementById("HomePageFooter" + this.randomNo).style.display = ""; */
      this.overlayRef.dispose();
    }
  }
  removeSelectedFilterName(editselectedFilterName: string) {
    delete this.allFltrNameFltrExprHMap[editselectedFilterName];
  }
  removeSelectedFilterIndex(editSelectedInputFieldIndx: number): any {
    this.isValueCheckBoxStatusArr.splice(editSelectedInputFieldIndx, 1);
    //console.log('in home page this.isValueCheckBoxStatusArr after delete>>', this.isValueCheckBoxStatusArr);
    this.filterValueArrLst.splice(editSelectedInputFieldIndx, 1);
    this.fieldNameArrLst.splice(editSelectedInputFieldIndx, 1);
    this.operatorNameArrLst.splice(editSelectedInputFieldIndx, 1);
    this.promtValuOptArr.splice(editSelectedInputFieldIndx, 1);
    this.codtnValueArr.splice(editSelectedInputFieldIndx, 1);
    this.fieldTypeMap.splice(editSelectedInputFieldIndx, 1);
    this.filterNamesArrLst.splice(editSelectedInputFieldIndx, 1);
    //console.log('in home page this.filterNamesArrLst after delete>>', this.filterNamesArrLst);
    this.andOrAddArrCounter.splice(editSelectedInputFieldIndx, 1);
    this.isDateArr.splice(editSelectedInputFieldIndx, 1);
    this.filterNameArrForExprMap.splice(editSelectedInputFieldIndx, 1);
  }
  setIsCustomFilter(flag: boolean) {
    this.isCustomFilter = flag;
  }

  //For Building data Advance query -START
  createFilterExpression(filterValuePromtTxtBoxArr: any[], isValueCheckBoxStatusArr: any[],
    filterNameArrForExprMap: any[], filterNamesArrLst: any[], operatorNameArrLst: any[],
    filterValueArrLst: any[], codtnValueArr: any[], fieldNameArrLst: any[], promtValuOptArr: any[]) {
    var filterValue = "";
    var filterName = "";
    var opratrName = "";
    var codtnValue = "";
    var fielValue = "";
    var filterNameKey = "";
    var checkBoxStatus: boolean;
    //console.log('final createFilterExpression isValueCheckBoxStatusArr>>', isValueCheckBoxStatusArr);
    //console.log('createFilterExpression filterNameArrForExprMap>>', filterNameArrForExprMap);
    for (var i = 0; i < filterNamesArrLst.length; i++) {
      if (isValueCheckBoxStatusArr[i] instanceof Array) {
        checkBoxStatus = isValueCheckBoxStatusArr[i][0];
      }
      else {
        checkBoxStatus = isValueCheckBoxStatusArr[i];
      }

      // console.log('checkBoxStatus>>', checkBoxStatus);
      if (checkBoxStatus) {
        if (filterNamesArrLst[i].length == 1) {
          var filterExprMain = "";
          console.log('in if filterNamesArrLst is less the 2');
          filterName = filterNamesArrLst[i];
          opratrName = operatorNameArrLst[i];
          if (promtValuOptArr[i] == 'Prompt') {
            if (filterValuePromtTxtBoxArr[i] != undefined) {

              if (opratrName == "BETWEEN" && filterValuePromtTxtBoxArr[i] instanceof Array) {
                //console.log('if filterValuePromtTxtBoxArr betwewen!!');
                var btwnValue: any[] = filterValuePromtTxtBoxArr[i];
                filterValue = btwnValue[0] + "," + btwnValue[1];
              }
              else {
                filterValue = filterValuePromtTxtBoxArr[i];  //even we can check filterValuePromtTxtBoxArr of index if undefined
              }
            }
            else {
              if (opratrName == "BETWEEN") {
                var fltr = "";
                filterValue = fltr + "," + fltr;
              } else {
                filterValue = "";
              }
            }
          }
          else if (promtValuOptArr[i] == 'Value') {
            if (opratrName == "BETWEEN" && filterValueArrLst[i][0] instanceof Array && filterValueArrLst[i][0].length > 1) {
              var btwnValue: any[] = filterValueArrLst[i][0];//its bcz we push the array in other array
              filterValue = btwnValue[0] + "," + btwnValue[1];
            } else {
              //console.log('esle filterValueArrLst betwewen!!');
              filterValue = filterValueArrLst[i];
            }
          }
          codtnValue = codtnValueArr[i];
          fielValue = fieldNameArrLst[i];

          if (opratrName && fielValue) {
            filterExprMain += this.getFilterExpr(filterName, opratrName, filterValue, codtnValue, fielValue);
            this.allFltrNameFltrExprHMap[filterNameArrForExprMap[i]] = filterExprMain;//i can put against filtername
          }
          else {
            window.alert('Please enter opratrName?, filterValue?, fielValue?');
          }
        } /////////////////////////////////////////////////////////////////////////////////////////////
        else if (filterNamesArrLst[i].length > 1) {
          console.log('in if filterNamesArrLst is greater than 1');
          var filterExprMain = "";
          for (var idx = 0; idx < filterNamesArrLst[i].length; idx++) {
            filterName = filterNamesArrLst[i][idx];
            opratrName = operatorNameArrLst[i][idx];

            if (promtValuOptArr[i][idx] == 'Prompt') {
              if (filterValuePromtTxtBoxArr[i] == undefined) {
                filterValuePromtTxtBoxArr[i] = [];
                //console.log('filterValuePromtTxtBoxArr[i] was undefined>>', filterValuePromtTxtBoxArr[i]);
              }
              if (filterValuePromtTxtBoxArr[i][idx] != undefined) {
                if (opratrName == "BETWEEN" && filterValuePromtTxtBoxArr[i][idx] instanceof Array) {
                  var btwnValue: any[] = filterValuePromtTxtBoxArr[i][idx];
                  filterValue = btwnValue[0] + "," + btwnValue[1];
                }
                else {
                  filterValue = filterValuePromtTxtBoxArr[i][idx];  //even we can check filterValuePromtTxtBoxArr of index if undefined
                }
              }
              else {
                if (opratrName == "BETWEEN") {
                  var fltr = "";
                  filterValue = fltr + "," + fltr;
                } else {
                  filterValue = "";
                }
              }
              //console.log('this.filterValuePromtTxtBoxArr22[', i, ']=[', filterValue, ']');
            }
            else if (promtValuOptArr[i][idx] == 'Value' && promtValuOptArr[i].length > 1) {
              if (opratrName == "BETWEEN" && filterValueArrLst[i][idx] instanceof Array && filterValueArrLst[i][idx].length > 1) {
                console.log('if filterValueArrLst betwewen!!');
                var btwnValue: any[] = filterValueArrLst[i][idx];

                filterValue = btwnValue[0] + "," + btwnValue[1];
              } else {
                filterValue = filterValueArrLst[i][idx];
                // textValue = filterValueArrLst[i];//hardcoded value array
              }
              //console.log('this.filterValueArrLst11[', i, ']=[', filterValue, ']');
            }
            codtnValue = codtnValueArr[i][idx];
            fielValue = fieldNameArrLst[i][idx];
            if (opratrName && fielValue) {
              filterExprMain += this.getFilterExpr(filterName, opratrName, filterValue, codtnValue, fielValue);
              filterNameKey += filterName + "+";//not used bu can be put for map key
            }
            else {
              window.alert('Please enter  opratrName?, filterValue?,fielValue?');
            }
          }
          this.allFltrNameFltrExprHMap[filterNameArrForExprMap[i]] = filterExprMain;
        }
      }
      else {
        if (this.allFltrNameFltrExprHMap[filterNameArrForExprMap[i]]) {
          this.removeSelectedFilterName(filterNameArrForExprMap[i])
          //console.log("removed filter expression from map if checkbox status is false", this.allFltrNameFltrExprHMap);
        }
      }
      //console.log("this.allFltrNameFltrExprHMap>>", this.allFltrNameFltrExprHMap);
    }
  }

  getFilterExpr(filterName:any, operator:any, filterValue:any, operand:any, fieldName:any) {
    console.log('in getFilterExpr!!');
    //console.log('filterName', filterName, 'operator', operator, 'filterValue', filterValue, 'operand', operand, 'fieldName', fieldName);

    let filterExpr = "";
    if ("LIKE EXACT MATCH" == operator) {
      operator = "LIKE";
    }
    else if ("LIKE ENDS WITH" == operator) {
      operator = "LIKE";
      filterValue = "'%" + filterValue + "'";
    }
    else if ("LIKE STARTS WITH" == operator) {
      operator = "LIKE";
      filterValue = "'" + filterValue + "%'";
    }
    else if ("CONTAINS" == operator) {
      operator = "LIKE";
      filterValue = "'%" + filterValue + "%'";
    }
    else if ("IN" == operator) {
      if (filterValue instanceof Array) {
        filterValue = filterValue[0];
      }
      let searchInCondition = "";
      searchInCondition = filterValue;
      var regex = new RegExp(',', 'g');
      //replace via regex
      filterValue = "('";
      filterValue += searchInCondition.replace(regex, "','");
      filterValue += "')";
    }
    else if ("BETWEEN" == operator) {
      let searchBetweenCondition = "";
      searchBetweenCondition = filterValue.replace("\\s+", "");
      filterValue = searchBetweenCondition.replace(",", "' AND '");
      filterValue = "'" + filterValue + "'";
    }
    else {
      filterValue = "'" + filterValue + "'";
    }
    if (operand == undefined) {
      console.log('Operand is undefined!!');
      operand = "";
    }
    return filterExpr += " " + this._searchMenuService.getphysicalNameMap(fieldName) + " " + operator + " " + filterValue + " " + operand;
  }
  //For Building data Advance query -END

  //For Pophelp Suggession -start
  openSuggest(frmlArgsTxtBox: string, formalArgNamesForPophelp: string, idx:any) {
    console.log('index open suggest>>', idx);
    this.isPophelpFlag = true;
    this.setSuggIndex(idx);
    var paramMap:any = {};
    var paramString = "";
    //Added By Sainath T. on 26-03-2020 [To resolve multi opt multi selection pophelp issue]
    this.pophelpMultiOpt = this.pophelpFieldMultiOptMap[this.formalArgNamesForPophelpCAPSArr[idx]];
    console.log('pophelp multi opt>>['+this.pophelpFieldMultiOptMap[this.formalArgNamesForPophelpCAPSArr[idx]]+']');
    paramMap["OBJ_NAME"] = this.objName;
    paramMap["ACTION"] = "AUTO_SEARCH_POPHELP";
    paramMap["FIELD_NAME"] = this.formalArgNamesForPophelpCAPSArr[idx];//formalArgNamesForPophelp;
    paramMap["SQL_INPUT"] = this.pophelpFieldSqlInpMap[this.formalArgNamesForPophelpCAPSArr[idx]];
    paramMap["EDITOR_ID"] = "";
    paramMap["FORM_NO"] = "";
    paramMap["PARAMXML"] = "";
    paramMap["PKVLAUE"] = "";
    paramMap["EDIT_FLAG"] = "";
    paramMap[this.formalArgNamesForPophelpCAPSArr[idx]] = frmlArgsTxtBox;
    paramString = this._searchMenuService.getEncodedParamString(paramMap);
    this.fieldValueForPopHelpArr = frmlArgsTxtBox;
    this.refIdForPophelpArr = formalArgNamesForPophelp + '_' + frmlArgsTxtBox;
    this.dataSourceForPophelpArr = "/ibase/RIAWizardHandlerServlet?" + paramString;
    setTimeout(() => this.createOverlay(), 200);
  }
  onCancel() {
    this.overlayRef.dispose();
    this.isPophelpFlag = false;
    this.fieldValueForPopHelpArr = "";
    this.refIdForPophelpArr = "";
    this.dataSourceForPophelpArr = "";
    this.pophelpSelectionValue = "";
    this.pophelpMultiOpt = "0";
  }
  onSelectionChange(event:any) {
  //Added By Sainath T. on 26-03-2020 [To resolve multi opt multi selection pophelp issue]-Start
    console.log('on change selection001>', event.value, 'this.pophelpIndex>', this.pophelpIndex, ' event>>'+event);
	  if(event instanceof Array)
    {
      this.pophelpSelectionValue = event.toString();
    }
    else
    {
      this.pophelpSelectionValue = event.value;
    }
  //Added By Sainath T. on 26-03-2020 [To resolve multi opt multi selection pophelp issue]-End
  }
  onDone() {
    //Added by Sainath T. on 01-NOV-2019
    this.setfrmlArgsTxtBoxArrLst(this.pophelpIndex, this.pophelpSelectionValue);
    this.overlayRef.dispose();
    this.isPophelpFlag = false;
    this.fieldValueForPopHelpArr = "";
    this.refIdForPophelpArr = "";
    this.dataSourceForPophelpArr = "";
    this.pophelpSelectionValue = "";
    this.pophelpMultiOpt = "0";
    //console.log('on done selection22', this.frmlArgsTxtBoxArrLst);
  }
  //For Pophelp Suggession -end

  //For popup Suggestion 
  onSuggChangeValue(event:any, idx:any) {
    //console.log("onChangeValue event get called in filter - input ", event.value, 'idx>>', idx, 'event.value>>'+event);
    this.setfrmlArgsTxtBoxArrLst(idx, event);
    this.setPophelpFields(this.pophelpFieldsDetails);
  }

  changeSuggSelection(event:any, idx:any) {
  //console.log("changeSuggSelection event get called in filter - input ", event,'event.detail.id>>', event.detail.id, 'idx>>', idx);
  this.setfrmlArgsTxtBoxArrLst(idx, event.detail.id);
  }
  setSuggIndex(indx:any) {
    this.pophelpIndex = indx;
    // console.log('in setSuggIndex', indx);
  }
  onBack() {
    //console.log('On back Click!!!', this.isBackFlag, 'this.mainDivId>>', this.mainDivId);
    document.getElementById(this.mainDivId)!.style.display = "none";
    this.setEmptyAll();
    this.isBackFlag = true;
  }

  createOverlay() {
    console.log('In createOverlay!!');
    var config = new OverlayConfig();

    var width = '500px';
    var top = this.isBrowser ? '0px' : '40px';
    var height = 'auto';
    var left = "calc(100% - 360px)";
    config.hasBackdrop = true;

    config.positionStrategy = this.overlay.position()
      .global()
      .centerHorizontally()
      .width(width)
      .left(left)
      .top(top)
      .height(height);
    const templatePortal = new TemplatePortal(
      this.templatePortal,
      this.viewContainerRef
    );
    this.overlayRef = this.overlay.create(config);
    this.overlayRef.attach(templatePortal);
  }

  getDispVisibleColFlag(event:any) {
    // console.log('In getDispVisibleColFlag');
    if (event.target.checked) {
      this.isVisibleColDispFlag = "1";
    }
    else {
      this.isVisibleColDispFlag = "0";
    }
  }
//Added By Sainath T. on 28-06-19 [To show custom filter in popup]-Start
  createPopup() {
    console.log('In createPopup!!1');
    var config = new OverlayConfig();

    var width = '500px';
    var top = this.isBrowser ? '0px' : '40px';
    var height = 'auto';
    var left = "calc(100% - 354px)";
    config.hasBackdrop = true;

    config.positionStrategy = this.overlay.position()
      .global()
      .centerHorizontally()
      .width(width)
      .left(left)
      .top(top)
      .height(height);
    const templatePortal_ = new TemplatePortal(
      this.templatePortal_,
      this.viewContainerRef
    );
    this.overlayRef = this.overlay.create(config);
    this.overlayRef.attach(templatePortal_);
  }
//Added By Sainath T. on 28-06-19 [To show custom filter in popup]-End

  setEmptyAll(): any {
    this.frmlArgNames = "";
    this.selectedObject = null;
    this.objDtlResonse = "";
    this.objName = "";
    this.objDetailsMap = {};
    this.pophelpFieldsDetailsMap = {};
    this.fieldLbls = [];
    this.frmlArgTypes = "";
    this.frmlArgsDtBoxArrLst = [];
    this.period = [];
    this.dayWeekMnthValShownTxtBx = "";
    this.viewDataResponse = "";
    this.dateArgType = false;
    this.textBxTitle = "";
    this.textBxId = "";
    this.frmlArgsTxtBoxArrLst = [];
    this.strtDt = 0;
    this.endDt = 0;
    this.frmlArgTypeArray = [];
    //this.dateFormat = this.dateFormat;
    this.searchParam = "";
    //for permanent filter
    this.colInfoNodeList = null;
    this.filterNodeList = null;
    this.isPermntFilter = false;
    this.isCustomFilter = false;

    //Sai for passing to add filter variables - START
    this.filterValueArrLst = [];
    this.fieldNameArrLst = [];
    this.operatorNameArrLst = [];
    this.promtValuOptArr = [];
    this.codtnValueArr = [];
    this.fieldTypeMap = [];
    this.isDateArr = [];
    this.filterNamesArrLst = [];
    this.isAddFilter = false;
    this.fieldDispNameMapkeys = [];
    this.filterExprMain = "";
    this.andOrAddArrCounter = [];
    this.editFilterJson = {};
    this.allFltrNameFltrExprHMap = {};
    this.filterNameArrForExprMap = [];
    this.isValueCheckBoxStatusArr = [];
    this.permntFilterNamesArrLstForMap = [];

    this.panelOpenState = false;
    //For pophelp-Start
    this.dataSourceForPophelpArr = "";
    this.refIdForPophelpArr = "";
    this.fieldValueForPopHelpArr = "";

    this.pophelpFieldsDetails = "";
    this.pophelpFildsArray = [];
    this.formalArgNamesForPophelpArr = [];
    this.pophelpFieldSqlInpMap = {};
    //For Pophelp-end
    //For input Suggestions
    this.dataSourceForinpSuggMap = {};
    this.pophelpIndex = null;
    this.isVisibleTxtBx = true;
    this.refIdForInpSuggArr = [];
    this.formalArgNamesForPophelpCAPSArr = [];
    this.isBackFlag = false;
    this.randomNo = Math.random();
    this.mainDivId = "" + this.objName + this.randomNo;
    this.indexArrayForPushAndOrAddArr = [];
  }
  
  /*Added By Vikas Lagad on 3-Oct-2019 [add method for data export to zip & download file] Start*/
  exportStatus(date: any)
  {
    console.log('Inside exportStatus method.............',date);
    this.getbckGrounJobData(date, true);
  }

  getbckGrounJobData(date:any, isOverlay:any):any
  {
    console.log('Inside getbckGrounJobData......');
    this.isOverlay = isOverlay ;
    var paramMap:any = {};
    var paramString = "";
    paramMap["obj_name"] = this.objName;
    paramMap["from_date"] = date;
    //Added by Sainath T. on 10+-OCT-2019 [To get the background job data only]
    paramMap["action"] = "fromExcel";
    paramString = this._searchMenuService.getEncodedParamString(paramMap);
    this._searchMenuService.uploadStatus(paramString)
    .subscribe((data:any) => {
      if (data) {
        try {
         this.responseData['data'] = JSON.parse(data);
        } catch (error) {
          console.log('Exception while emiting.....');
        }
        console.log('Response data from UploadTemplate Servlet ',this.responseData);
        this.isUploadStatus = true;
        if(this.isOverlay)
        {
          setTimeout(()=>
          {
            this.uploadStatusOverlay(); 
          },100);

        }
      }
    }
    );
  }
  uploadStatusOverlay() 
  {
    console.log("Creating overlay for uploadStatus ::")
    setTimeout(()=>
    {
      this.setPosition();
    },200);
    const templateUploadStatus = new TemplatePortal(
    this.templateUploadStatus,
    this.viewContainerRef
    );
    this.uploadOverlayRef = this.overlay.create( this.config );
    this.uploadOverlayRef.attach( templateUploadStatus );  
  }


  setPosition()
  {
    let positionElem = document.getElementsByClassName( 'frameStyle' );
    console.log('positionElem.......',positionElem);
    let position : any;
    if(positionElem)
    {
      position = document.getElementsByClassName( 'frameStyle' )[0].getBoundingClientRect();
    }
    //let position = document.getElementById("frameStyle").parentElement.getBoundingClientRect();  //dashboardDiv
    var width = position.width + 7;
    var top = position.top;
    var height = position.height; //+34
    var left = position.left;
    var bottom = position.bottom;
    var right = position.right;
    this.divHeight = height-111;
    console.log('position:h:w:t:l:r:b:',height,'',width,'',top,'',left,'',right,'',bottom);
    this.config.hasBackdrop = false;
    console.log( 'config & templateUploadStatus ', this.config, this.templateUploadStatus );
    this.config.positionStrategy = this.overlay.position()
      .global()
      .width( width )
      .top( top )
      .bottom( bottom )        
      .height( height )
      .left( left )
      .right( right );
  }
  
  onUploadStatusCancle()
  {
    this.isOverlay = false;
    this.uploadOverlayRef.dispose();
  }

  changeDate( event: MatDatepickerInputEvent<Date> )
  {  
      console.log('selected change date--',event); 
      //Changed by Sainath T. on 04-03-2020 [For refresh button]-Start
      if(event && event != undefined)
      {
        this.refreshDate = event.value;
      }
      var date = this.datePipe.transform(this.refreshDate, this.dateFormat);
      //Changed by Sainath T. on 04-03-2020 [For refresh button]-End
      this.getbckGrounJobData(date,false);
  }
  /*Added By Vikas Lagad on 3-Oct-2019 [Add method for data export to zip & download file] End*/
}
