import { Pipe, PipeTransform } from "@angular/core";
import { DomSanitizer } from "@angular/platform-browser";
import { DatePipe } from "@angular/common";

export { BISMessagesComponent } from "./bis-messages/bis-messages.component";
export { BISSelectionListComponent } from "./bis-selection-list/bis-selection-list.component";
export { BISInvokeInputComponent } from "./bis-invoke-input.component";
export { BISChipComponent } from "./bis-chip.component";
//Added by Sainath T. on 10-06-19
export { BISSpeechRecognition } from "./bis-speech-recognition/bis-speech-recognition"

@Pipe({name: 'safeHtml'})
export class SafeHtmlPipe implements PipeTransform {
    constructor(private sanitized: DomSanitizer) {
    }
    
    transform(value: string) {
        return this.sanitized.bypassSecurityTrustHtml(value);
    }
}

@Pipe({name: 'messageDateTime'})
export class BISDateFormatPipe implements PipeTransform {
    constructor(){
    }

    transform(value: string | any) {
        
       console.log( 'value', value);
       var _value = Number(value);
       console.log( '_value', _value);
       var dif = Math.floor( ( (Date.now() - _value) / 1000 ) / 86400 );
       console.log( 'dif', dif);
       if ( dif < 30 ){
            return convertToNiceDate(value);
       }else{
           var datePipe = new DatePipe("en-US");
           value = datePipe.transform(value, 'shortTime');
           return 'Today ' + value;
       }
    }
}

function convertToNiceDate(time: string) {
    var date = new Date(time),
        diff = (((new Date()).getTime() - date.getTime()) / 1000),
        daydiff = Math.floor(diff / 86400);

    if (isNaN(daydiff) || daydiff < 0 || daydiff >= 31)
        return '';

    return daydiff == 0 && (
        diff < 60 && "Just now" ||
        diff < 120 && "1 minute ago" ||
        diff < 3600 && Math.floor(diff / 60) + " minutes ago" ||
        diff < 7200 && "1 hour ago" ||
        diff < 86400 && Math.floor(diff / 3600) + " hours ago") ||
        daydiff == 1 && "Yesterday" ||
        daydiff < 7 && daydiff + " days ago" ||
        daydiff < 31 && Math.ceil(daydiff / 7) + " week(s) ago";
}
