import { Component, OnInit, ViewEncapsulation, Input, ChangeDetectorRef, AfterViewInit } from '@angular/core';
import { BISIntentService } from '../bis-services';
import { changeThemeColor } from '../../../plugin/utils/theme-selector-util';
import { getOS } from '../../shared/hostUrl';
import { Subscription } from 'rxjs';

@Component({
  selector: 'bis-assistant',
  templateUrl: './bis-assistant.component.html',
  styleUrls: ['./bis-assistant.component.css'],
  encapsulation: ViewEncapsulation.None
})
export class BISAssistantComponent implements OnInit, AfterViewInit {

  @Input() pluginMetadata: any;

  showHeader: boolean = true;
  //Added by Pratheek on 18-06-19[ passing data when click on quick action button to open transcation in PopUp Panel]-Start
  assitantID: string ='';
  targetId:string = "";
  headerLableVal:string="";
  intentID:string ="";
  //Added by Pratheek on 18-06-19[ passing data when click on quick action button to open transcation in PopUp Panel]-End
  osType: string | any = '';
  isBrowser: boolean = false;
  //Added by sadique shaikh 10/07/2019[userPrefSubscription variable added]
  userPrefSubscription: Subscription | any;
  notificationRequest : string = "";
  notificationResponse : string = "";

  constructor(public intentService: BISIntentService, public chgDetectorRef: ChangeDetectorRef) { }

  ngOnInit() {
    this.osType = getOS();
    console.log('Current OS', this.osType);
    this.intentService.osType = this.osType;

    // By Sainath T. on 09/04/2019 [Speech mic icon should hide if e12browser ] - START
    let index = window.location.pathname.indexOf('E12BROWSER');
    if (index > -1) {
      this.isBrowser = true;
      console.log('isBrowser>>', this.isBrowser);
    }
    this.intentService.isBrowser = this.isBrowser;
    // By Sainath T. on 09/04/2019 [Speech mic icon should hide if e12browser ] - END
    var themeColor = localStorage.getItem('themeColor');
    if (themeColor) {
      changeThemeColor(themeColor);
    }
    //console.log('BISAssistantComponent pluginMetadata', this.pluginMetadata);
    this.showHeader = this.pluginMetadata.compData!.showHeader == 'true';
    //console.log('BISAssistantComponent showHeader >> ', this.showHeader);
    this.intentService.chgDetectorRef = this.chgDetectorRef;
    //Added by Pratheek on 18-06-19[ passing data when click on quick action button to open transcation in PopUp Panel]-Start
    var objNameVal = this.pluginMetadata.compData!.objName;
    this.targetId = this.pluginMetadata.compData!.targetId;
    this.headerLableVal = this.pluginMetadata.compData!.title;
    if(this.headerLableVal == undefined)
    {
      this.headerLableVal = "Vision Assistant";
    }
    this.intentID = this.pluginMetadata.compData!.intentID;
    //By Sainath T. on 09-AUG-2019 [ If intent id is not defined from cliet side]-Start
    console.log("this.intentID[",this.intentID,"]");
    if(!this.intentID || this.intentID == undefined )
    {
      this.intentID = "WELCOME";
    }
    //By Sainath T. on 09-AUG-2019 [ If intent id is not defined from cliet side]-End
    console.log('objName!!!!! ['+objNameVal+'] targetId ['+this.targetId+"]");
    
    //By Sainath T. on 09-SEP-2019 [To identify the call from to apply Css]
    var callFrom = this.pluginMetadata.compData!.callFrom;
    this.intentService.callFromProteusVision = (callFrom != undefined && callFrom == 'Proteus_vision') ? true : false;
    console.log('callFrom!!!!! ['+callFrom+']');

    this.intentService.loadComponentData(this.targetId);

    //Added by Sainath T. on 6-Aug-2019 [Push Notification Implementation]- Start
    try
    {
      this.notificationRequest = this.pluginMetadata.compData!.notificationRequest;
      console.log('bis-notificationRequest:',this.notificationRequest);
      this.notificationResponse = this.pluginMetadata.compData!.notificationResponse;
      console.log('bis-notificationResponse:',this.notificationResponse);
    }
    catch
    {
      console.log('Exception while getting notificationResponse!!');
    }
    //Added by Sainath T. on 6-Aug-2019 [Push Notification Implementation]- End

    // By sadique & sainath. on 10/07/19 [To get user preference value -Text/speech] - START
    if(!this.isBrowser)
    {
      console.log('!!!userPreferenc47 [',this.isBrowser,']');
      this.userPrefSubscription = this.intentService.getUserPref().subscribe( 
        userPrefRes =>
        {
          console.log('!!!userPreference!!! [',userPrefRes,']');
          if(userPrefRes.length > 0)
          {
            this.intentService.userPref = userPrefRes;
          }
          else 
          {
            this.intentService.userPref = 'speech';
          }
          this.loadAssistant(objNameVal);
          console.log('!!!userPreference!!! [',this.intentService.userPref,']');
        }
      );
    }
    else{
      console.log('Calling Assistant from Browser!!');
      this.loadAssistant(objNameVal);
    }
    // By sadique and sainath T. on 24/06/19 [To get user preference value -Text/speech] - END
  }

  loadAssistant(objNameVal : string)
  {
    if( objNameVal )
    {
      this.assitantID = "bi-assistant_"+objNameVal;
    }
    else
    {
      this.assitantID = "bi-assistant";
    }
    this.intentService.objNameDummy = this.intentID;
    //Added by Sainath T. on 6-Anu-2019 [To get and set push notififcation data]- Start
    if( this.notificationRequest && this.notificationRequest != undefined && this.notificationRequest.trim().length != 0 )
    {
      try
      {
        console.log('In Bis-Assistant:Recieved Notification');
        this.intentService.notificationRequest = this.notificationRequest;
        this.intentService.notificationResponse = JSON.parse(this.notificationResponse);
        console.log('notificationResponse121[', this.intentService.notificationResponse , ']');
      }
      catch
      {
        console.log('exception while parsing notification response');
      }          
    }
    //Added by Sainath T. on 6-Anu-2019 [To get and set push notififcation data]- End
    console.log('assistantID 58!!!!! ['+this.assitantID+'] this.intentID ['+this.intentID+']');
    this.intentService.fetchIntentsDM(this.targetId);
    console.log('objName Dummy 72!!!!! ['+this.intentService.objNameDummy+']');
    if( this.intentService.objNameDummy == "WELCOME" )
    {
      this.intentService.addWaitingMsg(this.targetId,"00");
    }
    //Added by Pratheek on 18-06-19[ passing data when click on quick action button to open transcation in PopUp Panel]-End
  }
  
  //Added by sadique shaikh 10/07/2019[unsubsribe userPrefSubscription ]

  //Added by Prasad on 22/08/19 [set height to assistant after view] START
  ngAfterViewInit()
  {
    var splitContainer = document.getElementById('splitContainer');
    if ( splitContainer && document.getElementById( "bi-assistant" ) && !this.isBrowser )
    {
      document.getElementById( "bi-assistant" )!.style.height = (splitContainer.clientHeight - 44) + "px";
    }
  }
  //Added by Prasad on 22/08/19 [set height to assistant after view] END

  ngOnDestroy()
  {
    if(this.userPrefSubscription)
    {
      this.userPrefSubscription.unsubscribe();
    }
  }
}