import { NgModule, CUSTOM_ELEMENTS_SCHEMA, Injector } from '@angular/core';
import { BrowserAnimationsModule } from '@angular/platform-browser/animations';
import { FormsModule, ReactiveFormsModule } from '@angular/forms';
import { CommonModule } from '@angular/common';
import { HttpClientModule } from '@angular/common/http';
import { OverlayModule } from '@angular/cdk/overlay';
import { PortalModule } from '@angular/cdk/portal';
import { createCustomElement } from '@angular/elements';

import { BISInteractionComponent } from './bis-interaction/bis-interaction.component';
import { BISInvocationLayoutComponent } from './bis-invocation-layout/bis-invocation-layout.component';
import { BISAssistantComponent } from './bis-assistant/bis-assistant.component';
import { BISIntentService, BISDatamodelService } from './bis-services';
import { BISChipComponent, BISInvokeInputComponent, BISSelectionListComponent, BISMessagesComponent, SafeHtmlPipe, BISDateFormatPipe,BISSpeechRecognition } from './bis-components';
import { BISContainerComponent } from './bis-container/bis-container.component';

import { PophelpModule } from '../ang-pophelp/pophelp.module';
import { MaterialModule } from 'base-blocks';
//Added by Sainath T on 19/09/18.[handle intent reponse for different format]
import { DynamicTemplateModule } from 'base-blocks';
//Added by Sainath T. on 03/12/2018 [to use collapsible list display intents group-wise ]
import {MatExpansionModule} from '@angular/material/expansion';
import {MatListModule} from '@angular/material/list';
//Added by Samruddhi to display vision assistance messages
import { VisAsstResponseImplModule } from '../vision_response/vis_asst_response_impl/vis_asst_response_impl.module'
@NgModule({
  imports: [
    BrowserAnimationsModule,
    CommonModule,
    FormsModule,
    ReactiveFormsModule,
    HttpClientModule,
	MaterialModule,
    OverlayModule,
    PortalModule,
    PophelpModule,
    DynamicTemplateModule,
    MatExpansionModule,
    MatListModule,
    VisAsstResponseImplModule,
  ],
  declarations: [
    BISAssistantComponent, 
    BISInteractionComponent, 
    BISInvocationLayoutComponent, 
    BISChipComponent, 
    BISInvokeInputComponent,
    BISSelectionListComponent,
    BISContainerComponent,
    SafeHtmlPipe,
    BISDateFormatPipe,
    BISMessagesComponent,
    BISSpeechRecognition
  ],
  providers: [
    BISIntentService,
    BISDatamodelService
  ],
  exports: [
    BISAssistantComponent
  ],
  entryComponents: [
    BISInvokeInputComponent,
    BISAssistantComponent
  ],
  schemas:[CUSTOM_ELEMENTS_SCHEMA]
})
export class BISAssistantModule {
  constructor(private injector: Injector) {
    const bisInvokeInput = createCustomElement(BISInvokeInputComponent, { injector });
    customElements.define('bis-invoke-input', bisInvokeInput);
    //const bisAssistantComponent = createCustomElement(BISAssistantComponent, { injector });
    //customElements.define('bis-assistant', bisAssistantComponent);
  }
  ngDoBootstrap() { }
}
