import { Injectable, Output, EventEmitter } from '@angular/core';
import { HttpClient, HttpHeaders } from '@angular/common/http';
// import { Observable } from 'rxjs/Observable';
// import { BehaviorSubject } from 'rxjs/BehaviorSubject';
import { Observable, BehaviorSubject } from 'rxjs';

@Injectable()
export class UserTaskService {
                    
    constructor(private http: HttpClient) { }

    saveUserTask (tasObject : object):Observable<any>
    {
      console.log('saveUserTask tasObject[',tasObject,']');
      var tasObjectStr = JSON.stringify( tasObject);
      console.log('saveUserTask tasObjectStr [',tasObjectStr,']');

      let URL = this.getHostURL() + '/ibase/rest/usertask';
      let headers = new HttpHeaders({ 'Content-Type': 'text/html' });
      console.log( "URL for UpdateDocTransPageInfo method >>>>>" , URL ); 
      return this.http.post( URL ,tasObjectStr, { headers: headers}) 
	}
	
	updateUserTaskStatus (tranId : string, currStatus : string)
    {
      console.log('UserTaskService :: updateUserTaskStatus tranId[',tranId,'],currStatus['+currStatus+']');

      let URL = this.getHostURL() + '/ibase/rest/usertask/'+tranId+'/'+currStatus;
      let headers = new HttpHeaders({ 'Content-Type': 'text/html' });
      console.log( "URL for UpdateDocTransPageInfo method >>>>>" , URL ); 
      return this.http.get(URL,{ headers: headers}); 
	}
  
  
   
  	public getHostURL(): string {
        let HOST_URL: string = '';
        HOST_URL = localStorage.getItem( 'HOST_URL' );
        // HOST_URL = JSON.parse(localStorage.getItem( 'HOST_URL' )||'{}');
        if ( !HOST_URL ) HOST_URL = '';
        console.log( 'getHostURL[', HOST_URL, ']' );
        return HOST_URL;
    }
    
}
