import { Component, OnInit , ViewEncapsulation , AfterViewChecked ,ChangeDetectorRef,ViewChild ,Input} from '@angular/core';
import { DomSanitizer , SafeHtml } from '@angular/platform-browser';
import { DatePipe } from '@angular/common'
import { SORT,GROUP_BY } from '../../plugin/utils/dashboard-plugin-util';

import { TreeService } from './tree.service';
import { TreeviewItem } from 'ngx-treeview';
import { BBTreeviewComponent } from 'base-blocks';
declare var groupArrayMain: any;

@Component({
  selector: 'tree-component',
  templateUrl: './tree-component.component.html',
  styleUrls: ['./tree-component.component.css'],
  encapsulation: ViewEncapsulation.None, 
  providers:[DatePipe,TreeService]

})
export class TreeComponent implements OnInit   {

    jsonData: any[] = []; 
@ViewChild(BBTreeviewComponent) bbTreeviewComponent: BBTreeviewComponent | any;
  constructor(public datepipe: DatePipe, public treeservice: TreeService) { }

   groupData:any;
   selectedVal: any;

   groupLayout  : any;
   @Input('data') response : any;
   @Input('fileName') fileName : any;
   @Input('compHeight') compHeight : any;
   finalData: any = [];
   comphtml:any;
   keyArray: any = [];
   position:any

  ngOnInit()
  {
       console.log("TreeView Component ==  > ", this.response,this.fileName,this.compHeight);
       this.comphtml=this.response.compHTML;
       this.position=this.response.expIconPos;
       var temp=this.response.column_group[0];
       if(temp != null){
           var rootDataCol = this.findInArray( this.response.column_group, 'id', 'ROOT_DATA' );
           //if(this.response.data && this.response.data.WORK_DETAIL)
           if( rootDataCol  && rootDataCol["id"]!='COLNOTDEF')
           {
               console.log("TreeView rootDataCol ==  > ", rootDataCol);
               //this.response.data = this.response.data.WORK_DETAIL;
               
               this.response.data = this.response.data[rootDataCol.id];
           }
       }

       var keyArray=this.comphtml.slice(0, this.comphtml.length-1);
       this.keyArray.push(this.response.data);
       var i =0;
       for(var data of keyArray){
           console.log('comphtml ',keyArray[i].id);
           this.keyArray.push(keyArray[i].id);
           i++;
       }
       console.log('key array',this.keyArray);
       // this.groupData=    groupArrayMain(this.response.data, this.comphtml[0].id, this.comphtml[1].id, this.comphtml[2].id,this.comphtml[3].id);
       if(this.response.data[0]){
            this.groupData=    groupArrayMain(this.response.data,this.keyArray,true );
            console.log('groupData',this.groupData);
            if(this.response.metadataname=='assessment')
            {
                this.forGroupData(this.groupData);
            }
             var tempData=this.groupData;
             for(var data of tempData){
                 console.log('group data before ',data);
                 this.finalData.push(new TreeviewItem(data));
             }  
             console.log('groupData::::::::::::',this.finalData); 
       }

  }
  
  forGroupData( groupData:any ) 
  {
      if ( groupData ) 
      {
          for ( var i = 0; i < groupData.length; i++ ) 
          {
              var regionaArray = [];
              regionaArray = groupData[i]['children'];
              if ( regionaArray ) 
              {
                  for ( var j = 0; j < regionaArray.length; j++ ) 
                  {
                      var date = [];
                      if ( regionaArray[j]['children'] ) 
                      {
                          date = regionaArray[j]['children'];
                          console.log( 'date ', date );
                          for ( var z = 0; z < date.length; z++ ) 
                          {
                              var assessor:any = [];
                              assessor = date[z]['children'];
                              console.log( 'assessor ', assessor );
                              for ( var p = 0; p < assessor.length; p++ ) 
                              {
                                  if ( assessor[p]['ASSESSEE_RESULT_RANGE_MAX_TOTAL'] || assessor[p]['ASSESSEE_TOTAL_RESULT'] ) 
                                  {
                                      var result = 0;
                                      var resultMax = 0;
                                      var assessee = [];
                                      assessee = assessor[p]['children'];
                                      console.log( 'assessee>>>> ', assessee );
                                      for ( var q = 0; q < assessee.length; q++ ) 
                                      {
                                          if ( assessee[q]['RESULT'] || assessee[q]['RESULT_RANGE_MAX'] ) 
                                          {
                                              result = result + parseInt( assessee[q]['RESULT'] );
                                              resultMax = resultMax + parseInt( assessee[q]['RESULT_RANGE_MAX'] );
                                          }
                                      }
                                      assessor[p]['ASSESSEE_RESULT_RANGE_MAX_TOTAL'] = resultMax;
                                      assessor[p]['ASSESSEE_TOTAL_RESULT'] = result;
                                      console.log( 'assessee ASSESSEE_RESULT_RANGE_MAX_TOTAL>>>', assessor[p]['ASSESSEE_RESULT_RANGE_MAX_TOTAL'] );
                                      console.log( 'assessee ASSESSEE_TOTAL_RESULT>>>>', assessor[p]['ASSESSEE_TOTAL_RESULT'] );
                                  }
                              }
                          }
                      }
                  }
              }
          }
      }
  }
  findInArray( array:any, key:any, value:any ) 
  {
      var foundObj = array.find( (obj:any) => obj[key] === value );
      if(foundObj && foundObj.columns && foundObj.columns.length > 0)
      {
          return foundObj.columns[0]; 
      }
      else 
      {
          return { "id": "COLNOTDEF", "value": "Column is not configured"};
      }
  }
}