import { Component, OnInit, Input, ViewChildren, QueryList, ElementRef, Output, EventEmitter } from '@angular/core';
import { CustomSummaryPipe } from '../../shared/pipes/custom-summary-pipe';
import { getAssetImgUrl, getHostURL, getAuthParams }  from '../../shared/hostUrl';
import * as moment from 'moment';

@Component({
  selector: 'timeline',
  templateUrl: './timeline.component.html',
  styleUrls: ['./timeline.component.css'],
  providers: [CustomSummaryPipe]
})
export class TimeLineComponent implements OnInit {

  @Input('data') dashboardData:any;  
  @Input() todaysCallInfo:any;
  @Output() onCustomerSelection: EventEmitter<any> = new EventEmitter<any>();
  
  timelineData:any;
  ASSET_IMG_URL:any;
  isExpanded = false;
  link_metadata:any;
  hostUrl:any;
  
  constructor(private elRef:ElementRef) { }

  
  ngOnInit() {
      this.ASSET_IMG_URL = getAssetImgUrl();
      this.hostUrl = getHostURL();

      console.log('Dashboard data in TimeLine',this.dashboardData);
      

      if(this.dashboardData){
          this.link_metadata = this.dashboardData.link_metadata;

          if(this.dashboardData.data && this.dashboardData.data.CALL_DETAILS){
           try {

                this.dashboardData.data.CALL_DETAILS.forEach(
                    (callDetail:any) => {
                        if(callDetail.PLACES){
                            callDetail.PLACES.forEach(
                                    (place:any) =>{
                                        if(place.CUSTOMERS){
                                            place.CUSTOMERS.sort( (a:any, b:any) => {
                                                return +new Date('1970/01/01 ' + a.EVENT_TIME) - +new Date('1970/01/01 ' + b.EVENT_TIME);
                                            });
                                            
                                            /*
                                            place.CUSTOMERS.sort( (a, b) => {
                                                return a.CUST_TYPE_DESCR.toLowerCase() == 'missed' ? 1 : 0;
                                            });
                                            */
                                           
                                            place.EVENT_TIME = place.CUSTOMERS[0].EVENT_TIME;
                                        }
                                    }
                            )
                        }
                    }
                );
                this.dashboardData.data.CALL_DETAILS.sort( (a:any, b:any) => {
                    return moment(b.EVENT_DATE).toDate().getTime() - moment(a.EVENT_DATE).toDate().getTime();
                }); 
                
                
                this.dashboardData.data.CALL_DETAILS.forEach(
                        (callDetail:any) => {
                            callDetail.PLACES.sort( (a:any, b:any) => {
                                return +new Date('1970/01/01 ' + a.EVENT_TIME) - +new Date('1970/01/01 ' + b.EVENT_TIME);
                            }); 
                            
                        });
            } catch(e){
                console.log('Exception while sorting',e);
            }
          }
          
      }
  }
  
  expand() {      
      var detailList = this.elRef.nativeElement.querySelectorAll('details');
      console.log('detailList ::',detailList);
      if(detailList){
          detailList.forEach(
                  (el:any) => {
                      if(this.isExpanded){
                          el.removeAttribute("open");
                      }else {
                          el.setAttribute("open", '');
                      }
                  }
          );
      }
      this.isExpanded = !this.isExpanded;
  }
  
  goToCustomerInfo(customerData:any) {
      console.log('customerData on drill',customerData,this.link_metadata);

      var rowData:any = {};
      rowData['STRG_CODE'] = customerData.CUST_CODE;
      rowData['TRAN_ID'] = customerData.TRAN_ID;

      if(this.link_metadata){
          var selectedFieldInfo = {
                  "linkMetadata" : this.link_metadata,
                  "rowData" : rowData
                };
                
          this.onCustomerSelection.emit(selectedFieldInfo);
      }
  }
  
  getUserImage(customerData:any):string {
      // Commented and Added by Pankaj R on 17-Apr-21 to make Cutomer icon visible on Todays Dashboard
      //return this.hostUrl + '/ibase/CustomMenuImageServlet?fldValue='+customerData.CUST_CODE+'&ALT_FLD_VALUE='+customerData.CUST_NAME + '&' + getAuthParams();
      return this.hostUrl + '/ibase/CustomMenuImageServlet?fldValue='+customerData.CUST_CODE+'&ALT_FLD_VALUE='+customerData.CUST_NAME + '&object='+ customerData.OBJ_NAME + '&objName='+ customerData.OBJ_NAME + '&' + getAuthParams();

  }

  
  
  brokenUserImage(event:any) {
      event.target.src = this.ASSET_IMG_URL + '/errUser-48.png';
  }
}
