import { BrowserModule } from '@angular/platform-browser';
import { NgModule, CUSTOM_ELEMENTS_SCHEMA } from '@angular/core';
import {BrowserAnimationsModule} from '@angular/platform-browser/animations';
import { MaterialModule } from 'base-blocks';
import { SummaryComponent } from './summary/summary.component';
import { TimelineEntryComponent } from './timeline/timeline-entry/timeline-entry.component';
import { TimeLineComponent } from './timeline/timeline.component';
import { SummaryTimeLineComponent } from './summary-timeline.component';
import { CallsInfoComponent } from './calls-info/calls-info.component';
import { ChartComponentModule } from '../../components/chart-component/chart-component.module';

import { CustomSummaryPipe } from '../shared/pipes/custom-summary-pipe';
import { HttpClientModule } from '@angular/common/http';

@NgModule({
  declarations: [
    SummaryTimeLineComponent,             
    SummaryComponent,
    CallsInfoComponent,
    TimeLineComponent,
    TimelineEntryComponent,
    CustomSummaryPipe
  ],
  imports: [
    BrowserModule,
    MaterialModule,
    BrowserAnimationsModule,
    HttpClientModule,
    ChartComponentModule,
  ],
  schemas: [ CUSTOM_ELEMENTS_SCHEMA ],
  exports: [SummaryTimeLineComponent, CallsInfoComponent, SummaryComponent, TimeLineComponent, TimelineEntryComponent],
  providers: [],
  bootstrap: []
})
export class SummaryTimeLineModule { }
