import { Injectable } from '@angular/core';
import { HttpClient, HttpResponse} from '@angular/common/http';
import { Observable } from 'rxjs';
// import { BehaviorSubject } from 'rxjs/BehaviorSubject';
import { BehaviorSubject } from 'rxjs';
import { DataModelLocalStorage } from './data-model-ls';
import { map } from 'rxjs';
// import 'rxjs/Rxjs';

@Injectable()
export class DataModelService
{
    public dmUrl = "";

    public restServiceUrl: String = "/ibase/rest/data_model/";

    private dmLocalStorage : DataModelLocalStorage = new DataModelLocalStorage();

    constructor( private http: HttpClient ) { }

    getData( dataModelName:any ):Observable<any>
    {
        this.dmUrl = this.restServiceUrl + dataModelName + "/";
        return this.http.get<any[]>( this.dmUrl );
    }

    getDataByColumn( dataModelName:any, columnValue:any ):Observable<any>
    {
    	columnValue = columnValue.trim();
        var key = dataModelName + "~" + columnValue;
        var data = this.dmLocalStorage.getItem(key);
        var dataHandler;
        if(data)
        {
            console.log("Data Found in LocalStorage");
            dataHandler = new BehaviorSubject<any>(data);
            return dataHandler;
        }
        else
        {
            console.log("Data not Found in LocalStorage");
            var dmUrl = this.restServiceUrl + dataModelName + "/" + columnValue;
            /*return this.http.get<any[]>( dmUrl ).map(
                (response:any) => {
                    this.cacheResponse(key, response);
                }
            );*/
            return this.http.get<any[]>( dmUrl ).pipe(map(
                (response:any) => {
                    this.cacheResponse(key, response);
                }
            ));
            //return dataHandler.asObservable();
        }
    }

    private cacheResponse(key:any,response:any)
    {
        console.log("cacheResponse >> ", response);
        if(response instanceof Array )
        {
            console.log('Response is an array');
            if(response.length > 0)
            {
                this.dmLocalStorage.setItem(key,response);
            }        
        }
        else
        {
            if(response.hasKey)
            {
                console.log('Response is a JSON object');
                this.dmLocalStorage.setItem(key,response);
            }
        }
    }

    getFieldValue( pluginMetadata : any )
    {
        console.log("DataModelService getFieldValue >> pluginMetadata[", pluginMetadata, "]");
        var compData = pluginMetadata!.compData;
        var fieldValue;
        if( compData )
        {
            fieldValue = compData[compData.fieldName];
        }
        console.log("DataModelService getFieldValue >> fieldValue[", fieldValue,"]");
        return fieldValue;
    }
    
    getHostURL(): string 
    {
        var HOST_URL: string = '';
        HOST_URL = localStorage.getItem( 'HOST_URL' );
        // HOST_URL =JSON.parse(localStorage.getItem( 'HOST_URL' )||'{}');
        
        if ( !HOST_URL ) HOST_URL = '';
        console.log( 'getHostURL[', HOST_URL, ']' );
        return HOST_URL;
    }

    getSundryDetails( pluginMetadata : any )
    {
        console.log("x==> In DataModelService getSundryDetails >> pluginMetadata[", pluginMetadata, "]");
        var compData = pluginMetadata!.compData;
        var sunCode = "";
        var sunType = "";
        var sunDetailArray:any = [];
        if( compData )
        {
            sunCode = compData['SUNDRY_CODE'];
            sunDetailArray[0] = sunCode;
            sunType = compData['SUNDRY_TYPE'];
            sunDetailArray[1] = sunType;
        }
        console.log("x==> DataModelService getFieldValue >> fieldValue[", sunDetailArray,"]");
        return sunDetailArray;
    }

}



