import { Component, OnInit, Input } from '@angular/core';
import { getHostURL, getAssetImgUrl } from '../../shared/hostUrl';
import * as moment from 'moment';

@Component({
  selector: 'call-history',
  templateUrl: './call-history.component.html',
  styleUrls: ['./call-history.component.css']
})
export class CallHistoryComponent implements OnInit {
  
  @Input('data') dashboardData:any;
  callHistory:any;
  hostUrl:any = '';
  ASSET_IMG_URL:any;
  //errorImg;
  template:any;
  courseHistory:any;
  displayLength = 2;
  showAll = false;

  constructor() { }

  ngOnInit() {

    console.log('dashboardData',this.dashboardData);
    this.hostUrl = getHostURL();
    this.ASSET_IMG_URL = getAssetImgUrl();
    //if(!this.hostUrl){
    //    this.ASSET_IMG_URL = "/ibase/E12BROWSER/"+this.ASSET_IMG_URL;
    //}
    //this.errorImg = this.ASSET_IMG_URL+'/broken-image.png';

    if(this.dashboardData && this.dashboardData.data){
      this.callHistory = this.dashboardData.data.CALL_HISTORY;
      this.courseHistory = this.dashboardData.data.COURSE_HISTORY;
      this.template = this.dashboardData.template;

     if(this.callHistory){
          this.callHistory.forEach(
            (callHistory:any) => {
                try {                            
                    //var eventDateObj = new Date(callHistory.EVENT_DATE);
                    var eventDateObj = moment(callHistory.EVENT_DATE).toDate();
                    console.log('eventDateObj In callHistory',eventDateObj);
                    
                    var eventDate = eventDateObj.getDate();
                    var eventMonth = eventDateObj.toLocaleString("en-us", { month: "short" });
                    var eventYear = eventDateObj.getFullYear().toString().substr(2,2);
                    
                    callHistory['eventDate'] = eventDate;
                    callHistory['eventMonth'] = eventMonth;
                    callHistory['eventYear'] = eventYear;
                } catch(e){
                    console.log('Exception',e);
                }
                
            }
          );
     }
     if(this.courseHistory){
          this.courseHistory.forEach(
            (courseHistory:any) => {
                try {                            
                    //var eventDateObj = new Date(callHistory.EVENT_DATE);
                    var eventDateObj = moment(courseHistory.COURSES[0].COURSE_DATE).toDate();
                    console.log('eventDateObj In courseHistory',eventDateObj);
                    
                    var courseDate = eventDateObj.getDate();
                    var courseMonth = eventDateObj.toLocaleString("en-us", { month: "short" });
                    var courseYear = eventDateObj.getFullYear().toString().substr(2,2);
                    
                    courseHistory['courseDate'] = courseDate;
                    courseHistory['courseMonth'] = courseMonth;
                    courseHistory['courseYear'] = courseYear;
                    
                    var durationObj:any = moment.duration(courseHistory.TOTAL_COURSE_DURATION || 0);
                    if(durationObj)
                    {                        
                        var days = durationObj['_data'].days, hours = durationObj['_data'].hours, mins = durationObj['_data'].minutes;
                        var courseDuration = '';
                        if(days > 0)
                        {
                            courseDuration = courseDuration + days + ' days '
                        }
                        if(hours > 0)
                        {
                            courseDuration = courseDuration + hours + ' hrs '
                        }
                        if(mins > 0)
                        {
                            courseDuration = courseDuration + mins + ' mins '
                        }
                        
                        courseHistory['courseDuration'] = courseDuration;
                    }
                } catch(e){
                    console.log('Exception',e);
                }
                
            }
          );
     }
     
    }
  }
  
  brokenImage(event:any) {
      event.target.src = this.ASSET_IMG_URL + '/svg/broken-image.svg';
  }
  
  showMore() {
      this.showAll = !this.showAll;
      if(this.showAll){
         this.displayLength =  this.courseHistory.length;
      }else {
         this.displayLength = 2;
      }
  }

}
