import { Component, OnInit,Inject } from '@angular/core';
//import { MatDialog, MatDialogRef, MAT_DIALOG_DATA } from '@angular/material';
import {MatDialog,MAT_DIALOG_DATA,MatDialogRef} from '@angular/material/dialog';
import { DashboardService } from '../../dashboard/dashboard.service';
import { getAssetImgUrl, getAuthParams, getHostURL } from '../../shared/hostUrl';

@Component({
    templateUrl: './open-dialog.component.html',
    styleUrls: ['./open-dialog.component.css'],
})
export class OpenDialogComponent implements OnInit {
    objName: any;
    layoutReportData: any;
    layouts: any;
    selected: boolean = false;
    selectedLayout: any;
    prefName: any;
    share: boolean = false;
    editMode: boolean = false;
    currReportName: any;
    currobjName: any;
    currentLayout: any;
    ASSET_IMG_URL: any;
    isEmptyLayout: any;
    hostUrl: any;
    delete: boolean = false;
    resp: any;//added By Vikas Lagad
  

    template: any;
    constructor(public dialog: MatDialog,
        public dialogRef: MatDialogRef<OpenDialogComponent>,
        @Inject(MAT_DIALOG_DATA) public data: any, private dashboardService: DashboardService) { }

    ngOnInit() {
        this.ASSET_IMG_URL = getAssetImgUrl();
        this.template = this.data.template;
        this.hostUrl = getHostURL();

        if (this.template == 'OPEN_DIALOG') {
            this.layoutReportData = this.data.layoutReport!.allLayoutPref;
            console.log('layoutReport in dialogBox==>', this.layoutReportData);
            if(this.layoutReportData && this.layoutReportData.MY_LAYOUT.length == 0 && this.layoutReportData.OTHER_LAYOUT.length == 0)
            {
                this.isEmptyLayout = true;
            }
            this.selectedLayout = this.data.selectedLayout;
        }
        else if (this.template == 'SAVE_DIALOG') {
            this.currReportName = this.data.reportName;
            console.log('currReportName====>', this.currReportName);
        }
        
        else if (this.template == 'DELETE_DIALOG') {
            this.objName = this.data.objName;
            this.prefName = this.data.prefName;
            this.layoutReportData =this.data.layoutData;
            console.log('currReportName====>', this.currReportName);
        }
       
    }

    onNoClick(): void {
        this.dialogRef.close();
    }
    
    //TO set current layout
    setCurrentLayout(selectedLayout: any, isOthers: any) {
        this.currentLayout = selectedLayout;
        
        if (isOthers) {
            this.currentLayout['LAYOUT_OWNER'] = selectedLayout.userId;//TO Display layout of Others users
        }
        else {
            //this.currentLayout['LAYOUT_OWNER'] = 'SELF';
            this.currentLayout['LAYOUT_OWNER'] = selectedLayout.userId //TO Display layout of login users
        }
        this.selectedLayout = selectedLayout.objName+selectedLayout.prefName+selectedLayout.userId;
    }

    getUserImage(customerData: any): string {
        return this.hostUrl + '/ibase/CustomMenuImageServlet?fldValue=' + customerData.userId + '&ALT_FLD_VALUE=' + customerData.userName + '&' + getAuthParams();
    } 

    brokenUserImage(event: any) {
        event.target.src = this.ASSET_IMG_URL + '/errUser-48.png';
    }

    ondeleteClick(){
       console.log('layoutReportData  ondeleteClick Function >>> ', this.layoutReportData);
       console.log('objName::::::::::::ondeleteClick Function' , this.objName) ;
       console.log('prefName:::::::::::: ondeleteClick Function' , this.prefName) ;
       var mylayout=this.layoutReportData.MY_LAYOUT;
       console.log('mylayout::::::::::::' , mylayout);
       this.dashboardService.deleteExploreReport(this.objName, this.prefName);
       
       this.layoutReportData.MY_LAYOUT= this.layoutReportData.MY_LAYOUT.filter((mylayout: any)=> {                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                
           return  mylayout.prefName!=this.prefName; 
         
        });
    }
    
    ondelete(objName: any,prefName: any){
       console.log('Inside on delete ',objName,prefName,this.layoutReportData);
       const openDialogRef = this.dialog.open(OpenDialogComponent, { disableClose: true, data: { 'template': 'DELETE_DIALOG', 'Title': 'Are You Sure you Want to Delete','objName': objName,'prefName': prefName,'layoutData':this.layoutReportData } });
    }
}
