import {
  OnDestroy,
  OnInit,
  OnChanges,
  EventEmitter,
  ElementRef,
  Input,
  Output,
  NgModule,
  SimpleChanges,
  Directive
} from '@angular/core';

import { DomSanitizer, SafeHtml } from '@angular/platform-browser';


var dataSetConstruct:boolean = false;

/* tslint:disable-next-line */
@Directive({
    selector: '[applyData]'
  })
export class ApplyDataDirective implements   OnInit {
  
  @Input()  shHtml !: string;
  @Input()  data:any;
  @Output() public htmlLoaded:EventEmitter<any> = new EventEmitter();

  public constructor(private el: ElementRef, private _sanitizer:DomSanitizer ) {
  }

  public ngOnInit():any {
      console.log("data == > " , this.data  , "shHtml ==> " , this.shHtml );
      this.applyData();
      this.el.nativeElement.innerHTML =  this.shHtml;
  }
  
  applyData()
  {
      let idVal: string;
      for(var key of Object.keys(this.data))
       {
         var key1 = "{{"+key+"}}";
         var value = this.data[key];
          console.log("each :" ,key , key1 ,value );
          this.shHtml = this.shHtml.replace(key1, value);
       }
      console.log("this.shHtml  ==> in directive" , this.shHtml );
  }

  getDisplayChar(descr:any)
  {
      var wordArray = descr.split(" ");
      var displayVal;
      if(wordArray.length > 1){
          displayVal = wordArray[0].charAt(0)+wordArray[1].charAt(0);
      }else {
          displayVal = descr.charAt(0)
      }
      return displayVal.toUpperCase();
  }
}
  
@NgModule({
  declarations: [
    ApplyDataDirective
  ],
  exports: [
    ApplyDataDirective
  ],
  imports: []
})
export class ApplyDataModule {
}