import { BrowserModule } from '@angular/platform-browser';
import { NgModule, CUSTOM_ELEMENTS_SCHEMA } from '@angular/core';
import { DatePipe } from '@angular/common';

import { OverlayModule } from '@angular/cdk/overlay';
import { HttpClientModule } from '@angular/common/http';
import { MatMenuModule } from '@angular/material/menu';

import { DashboardComponent } from './dashboard.component';
import { DashboardService } from './dashboard.service';
import { DashboardDatamodelService } from './dashboard-datamodel.service';
import { DashboardComponentComponent } from './dashboard-component/dashboard-component.component';
import { DashboardHeaderComponent } from './dashboard-header/dashboard-header.component';
import { DashboardOverlayComponent } from './dashboard-overlay/dashboard-overlay.component';
import { DashboardViewComponent } from './dashboard-view/dashboard-view.component';
import { DashboardKPIComponent } from '../../components/dashboard-kpi/dashboard-kpi.component';

import { DashboardFilterModule } from '../dashboard/dashboard-filter/dashboard-filter.module';
import { DashboardCompositeModule } from './dashboard-composite/dashboard-composite.module';
import { FeedComponentModule } from '../../components/feed-component/feed-component.module';
import { ContentLibraryModule } from '../content-library/content-library.module';
import { AccountActivityModule } from '../account-activity/account-activity.module';
import { lineBarChartModule } from '../line-bar-chart/line-bar-chart.module';
import { DataGridModule } from '../datagrid/datagrid.module';
import { ChartComponentModule } from '../../components/chart-component/chart-component.module';
import { FmChartModule } from '../fm-chart/fm-chart.module';
import { TreeModule } from '../../components/tree-component/tree-component.module';
import { SummaryTimeLineModule } from '../summary-timeline/summary-timeline.module'
import { CustomerInfoComponent } from '../link-components/customer-info/customer-info.component';
import { BackgroundJobStatusModule } from '../background-job/background-job-status.module';
import { UserInfoComponent } from '../../components/link-components/user-info/user-info.component';
import {FmComponentModule} from '../../components/fm-component/fm-component.module';
import { CallHistoryComponent } from '../link-components/call-history/call-history.component';
import { CourseLibraryModule } from '../../components/course-library/course-library.module';
import { SellPlanningDetailModule } from '../link-components/sell-planning/sell-planning-detail/sell-planning-detail.module';

import { MaterialModule } from 'base-blocks';
import { BBSelectModule } from 'base-blocks';
import { HttpRequestService }  from 'base-blocks';

//import { VisualViewModule } from '../visuals/visual/visual.module';

@NgModule({
  declarations: [
    DashboardComponent,
    DashboardComponentComponent,
    DashboardHeaderComponent,
    DashboardOverlayComponent,
    DashboardViewComponent,
    DashboardKPIComponent,
    CustomerInfoComponent,
    UserInfoComponent,
    CallHistoryComponent,
    /*
    */
  ],
  imports: [
    BrowserModule,
    HttpClientModule,    
    MatMenuModule,
    OverlayModule,
    DashboardFilterModule,
    DashboardCompositeModule,
    MaterialModule,
    BBSelectModule,
    FeedComponentModule,
    ContentLibraryModule,
    AccountActivityModule,
    lineBarChartModule,
    DataGridModule,
    ChartComponentModule,
    FmChartModule,
    TreeModule,
    SummaryTimeLineModule,
    BackgroundJobStatusModule,
    FmComponentModule,
    CourseLibraryModule,
    SellPlanningDetailModule,
    /*
    // //Added by Sainath T on 19/09/18.[for upload status dashbord]-start
    // //Added by Sainath T on 19/09/18.[for upload status dashbord]-end
    VisualViewModule
    */
  ],
  exports:[
    DashboardComponent,
    DashboardComponentComponent,
    DashboardHeaderComponent,
    DashboardViewComponent
  ],
  entryComponents: [DashboardComponent, DashboardViewComponent, DashboardComponentComponent],
  
  providers: [DashboardService, DatePipe, DashboardDatamodelService, HttpRequestService],
  
  schemas:[CUSTOM_ELEMENTS_SCHEMA]
})
export class DashaboardModule { }
