import { Injectable,OnDestroy } from '@angular/core';
// import { Observable } from 'rxjs/Observable';
// import { Subject } from 'rxjs/Subject';
import { Observable } from 'rxjs';
import { Subject } from 'rxjs';
// import 'rxjs/add/operator/map'

import { FilterInfo } from './filter-input/filter-info.model';

@Injectable()
export class FilterDataService {
    
   filterTitle: string = 'Search Scope';
   filterDisplay: string | any;
   private filters : FilterInfo[] = [];

   private filterParameter: any = new Subject<any>();
   private filterValues = new Subject<any>();
   
   setFilterParameters( metadataName: any, filterParameters : string, filterValues: any ) {
       this.filterParameter.next({ metadataName: metadataName, value: filterParameters });
       this.filterValues.next({ metadataName: metadataName, values: filterValues });
   }

   clearFilterParameters() {
       this.filterParameter.next();
   }

   getFilterParameters(dashboardName: any): Observable<any> {
       console.log('dashboardName',dashboardName);
       return this.filterParameter.asObservable();
   }
  
   getFilterValues(dashboardName: any): Observable<any> {
       console.log('dashboardName',dashboardName);
       return this.filterValues.asObservable();
   }
   
   /*
    {
      "filters": {
        "filter": [
          {
            "col_id": "fromDate",
            "col_descr": "From date",
            "is_pophelp": false,
            "default_value": {},
            "col_name": "fromDate",
            "type": "4",
            "show_ontitle": "0",
            "mandatory": "Y",
            "mod_name": "DASHBOARD",
            "field_name": "EVENT_DATE"
          },
          {
            "col_id": "toDate",
            "col_descr": "To date",
            "is_pophelp": false,
            "default_value": {},
            "col_name": "toDate",
            "type": "4",
            "show_ontitle": "0",
            "mandatory": "Y",
            "mod_name": "DASHBOARD",
            "field_name": "PLAN_DATE"
          },
          {
            "col_id": "salePersons",
            "col_descr": "Sale persons",
            "is_pophelp": false,
            "default_value": {},
            "col_name": "salePersons",
            "type": "3",
            "show_ontitle": "0",
            "mandatory": "Y",
            "mod_name": "DASHBOARD",
            "field_name": "SALES_PERS"
          }
        ],
        "display": "N"
      }
    }
   */
   getFilters() : FilterInfo[]
   {
       return this.filters;
   }
   
   setFilters( metadataName : string )
   {
        this.filters = [];
        var userName = localStorage.getItem('userName') || '';
        var metadataCache: any = localStorage.getItem(metadataName+userName);
        var metadata = JSON.parse(metadataCache);
        console.log( 'prepareFilters-----metadata ', metadataName, metadata );
        if( metadata )
        {
            var filtersData = metadata.filters;
            console.log( 'prepareFilters-----filtersData ', filtersData );
            if( filtersData )
            {
                this.filterDisplay = filtersData.display;
                console.log( 'prepareFilters-----filterDisplay ', this.filterDisplay );
            }
            if( filtersData && filtersData.filter )
            {
                this.filters = filtersData.filter;
                console.log( 'prepareFilters-----filters>>>> ', this.filters );
            }
        }
   }
   
}
