import { Component, Input, Output, EventEmitter,OnDestroy } from '@angular/core';
import { BBPlugin, getUniqueId } from '../../../plugin/core/bb-plugin';
import { BBPluginMetadata } from "../../../plugin/core/bb-plugin.metadata";

//import { FilterDataService } from './filter-data.service';

@Component({
  selector: 'dashboard-filter',
  templateUrl: './dashboard-filter.component.html',
  styleUrls: ['./dashboard-filter.component.css']
})
export class DashboardFilterComponent implements BBPlugin,OnDestroy {
    
    @Input() pluginId: string = getUniqueId( 'dashboard-filter' );
    @Input() title: string | any;
    @Input() pluginMetadata: BBPluginMetadata | any;

    @Output() selected: EventEmitter<any> = new EventEmitter();
    deviceType: any;
    dateFormat: any;
    metadataName: any;
    
    constructor() 
    {
        
    }
    
    ngOnInit()
    {
        console.log( 'ngOnInit pluginMetadata of dashboard-filter', this.pluginMetadata );
        this.deviceType = this.pluginMetadata.get('deviceType') ;
        this.dateFormat = this.pluginMetadata.get('dateFormat') ;
        this.metadataName = this.pluginMetadata.get('metadataname') ;
        this.pluginId='dashboard-filter_'+this.metadataName;
        
        console.log( 'init() of dashboard-filter', this.metadataName, this.deviceType,this.dateFormat );
    }
    
    init()
    {
        
    }
    
    onFilterDone(event: any)
    {
        if( this.selected )
        {
            this.selected.emit(event);
        }
    }
    ngOnDestroy() 
    {
        console.log('dashboardfilter ngOnDestroy..');
    }
}
