import { NgModule, NO_ERRORS_SCHEMA } from '@angular/core';
import { CommonModule } from '@angular/common';  


import { CourseContentComponent,DialogOverviewExampleDialog } from './course-content.component';
import { VideoPlalistComponent } from './video-playlist/video-playlist.component';
import {CourseQuestionModule} from './course-question/course-question.module';
import { BBVideoModule } from './bb-video/bb-video.module';
import { HttpClientModule } from '@angular/common/http';
import { CourseAPIService } from './course-api.service';
import { MaterialModule } from 'base-blocks';
import { FormsModule } from '@angular/forms';
import { BrowserModule } from '@angular/platform-browser';
import { CdkTableModule } from '@angular/cdk/table';

@NgModule({
  declarations: [
    CourseContentComponent,
    VideoPlalistComponent,
    DialogOverviewExampleDialog,
  ],
  imports: [
    BBVideoModule,
    CourseQuestionModule,
    CommonModule,
    HttpClientModule,
    MaterialModule,
    FormsModule,
    BrowserModule,
    CdkTableModule
  ],
  providers: [CourseAPIService],
  bootstrap: [],
  exports: [   
    CourseContentComponent,
    VideoPlalistComponent,
  ],
entryComponents: [CourseContentComponent,DialogOverviewExampleDialog],
schemas: [NO_ERRORS_SCHEMA]
})
export class CourseContentModule { }
