import { Injectable, Output, EventEmitter } from '@angular/core';

@Injectable()
export class ContentService {

    constructor() { }

    isPinned = false;
    isSortBy:boolean = false;
    filterOptions: Array<string> = [];
    selectedList: Array<string> = [];

    @Output() onFilterPin: EventEmitter<boolean> = new EventEmitter();
    @Output() onRefChange: EventEmitter<any> = new EventEmitter();
    @Output() onSortChange: EventEmitter<any> = new EventEmitter();
    @Output() onSearchChange: EventEmitter<any> = new EventEmitter();
    @Output() onAddContent: EventEmitter<any> = new EventEmitter();
    @Output() onSelectContent: EventEmitter<any> = new EventEmitter();
    @Output() onSelectRefSer: EventEmitter<any> = new EventEmitter();
    @Output() onGroupByChange: EventEmitter<any> = new EventEmitter();
    sortBy:any;

    isPinnedContent:any;

    toggleHeaderPin() {
        this.isPinned = !this.isPinned;
        this.onFilterPin.emit( this.isPinned );
    }
    toggleHeaderPinned(pinned:any) {
        this.isPinned = pinned;
        this.onFilterPin.emit( pinned );
    }


    sortContentBy( valueOpt:any ) {
        this.isSortBy = true;
        this.sortBy = valueOpt;
        this.onSortChange.emit( valueOpt );
    }

    refSerChange( refSer:any ) {
        this.filterOptions.push( refSer );
        //console.log( 'filterOptions selected', this.filterOptions );
        this.onSortChange.emit();
    }

    searchContentBy( value :any) {
        //console.log( "search value in service ===", value );
        this.onSearchChange.emit( value );
    }

    addContent( content:any ) {
        this.onAddContent.emit( content );
    }

    selectContent( content:any ) {

        //this.selectedList.splice(0, 1);
        
        //this.selectedList.push( content );
        
        const index: number = this.selectedList.indexOf( content );
        //console.log('index of selected content'+index);
        if ( index !== -1 ) {
            this.selectedList.splice( index, 1 );
        }
        else {
            this.selectedList.push( content );
        }

        this.onSelectContent.emit( this.selectedList );
    }
    
    resetSelectedList(){
        this.selectedList = [];
        this.onSelectContent.emit( this.selectedList );
    }
    
    setPinnedContentStatus(status:any){
        this.isPinnedContent = this.isPinnedContent || status;
        
        //console.log('isPinnedContent status after setPinnedContentStatus',this.isPinnedContent);
    }
    
        sortByRefSer(refSer:any)
    {
      //console.log("sortByRefSer method get called" ,refSer );
      this.onSelectRefSer.emit(refSer);  
    }
    

}
