import { Pipe, PipeTransform,NgZone, ChangeDetectorRef, OnDestroy } from '@angular/core';

@Pipe({
  name: 'timeAgo'
})
export class TimeAgoPipe implements PipeTransform , OnDestroy {
  // private timer: number;//previous
  private timer!: number|null;

  
  constructor(private changeDetectorRef: ChangeDetectorRef, private ngZone: NgZone) {}
  
  transform(value: any, args?: any): any {
    
    var tempDateStr = value.replace(/(.+) (.+)/, "$1T$2Z");  
      
    let valueDate = new Date(tempDateStr);
    let currentDate = new Date();
    let timeString = this.getTimeString(valueDate,currentDate)  
    
    return timeString;
  }

  private getSecondsUntilUpdate(seconds:number) {
    let min = 60;
    let hr = min * 60;
    let day = hr * 24;
    if (seconds < min) { // less than 1 min, update ever 2 secs
      return 2;
    } else if (seconds < hr) { // less than an hour, update every 30 secs
      return 30;
    } else if (seconds < day) { // less then a day, update every 5 mins
      return 300;
    } else { // update every hour
      return 3600;
    }
  }
  
  getTimeString(now :any ,todaysDate:any)
  {
    let seconds = Math.round(Math.abs((now.getTime() - todaysDate.getTime())/1000));
    let timeToUpdate = this.getSecondsUntilUpdate(seconds) *1000;

    this.timer = this.ngZone.runOutsideAngular(() => {
      if (typeof window !== 'undefined') {
        return window.setTimeout(() => {
          this.ngZone.run(() => this.changeDetectorRef.markForCheck());
        }, timeToUpdate);
      }
      return null;
    });
    
    let minutes = Math.round(Math.abs(seconds / 60));
    let hours = Math.round(Math.abs(minutes / 60));
    let days = Math.round(Math.abs(hours / 24));
    let months = Math.round(Math.abs(days/30.416));
    let years = Math.round(Math.abs(days/365));
   // console.log("dates which getting calculating -->",minutes, hours , days , months , years);
    
    
    if (seconds <= 45) {
      return 'a few seconds ago';
    } else if (seconds <= 90) {
      return 'a minute ago';
    } else if (minutes <= 45) {
      return minutes + ' minutes ago';
    } else if (minutes <= 90) {
      return 'an hour ago';
    } else if (hours <= 22) {
      return hours + ' hours ago';
    } else if (hours <= 36) {
      return 'a day ago';
    } else if (days <= 25) {
      return days + ' days ago';
    } else if (days <= 45) {
      return 'a month ago';
    } else if (days <= 345) {
      return months + ' months ago';
    } else if (days <= 545) {
      return 'a year ago';
    } else { // (days > 545)
      return years + ' years ago';
    }

  }

  ngOnDestroy(): void {
  }

}
