import { Pipe, PipeTransform } from '@angular/core';

@Pipe({
  name: 'searchBy'
})
export class SearchByPipe implements PipeTransform {
  
    
    transform(contents: any[], searchText: string): any[] {
            console.log('In SearchByPipe--',contents,searchText);
            if (!contents) return [];
            return contents.filter(
                  content => {
                      
                      if(content.shDescr){                          
                          return ( ( content.shDescr.toLowerCase().indexOf(searchText.toLowerCase()) > -1 ) )
                          || this.searchByDescr(content , searchText) 
                          || this.searchByRefSer(content , searchText);
                      }
                  }
            );
    }
    
    searchByRefSer(content:any, searchText:any){
        for (var index = 0; index <  content.REFERENCES.length; index++) {                
            if( content.REFERENCES[index].refSer){                
                return content.REFERENCES[index].refSer.toLowerCase().indexOf(searchText.toLowerCase()) > -1 ;            
            }
        }
    }
    
    searchByDescr(content:any , searchText:any){
        if(content.descr) {         
            return  ( content.descr.toLowerCase().indexOf(searchText.toLowerCase()) > -1 ) 
        }
    }
    
    
    
    
    
    
    
    
    
    
    
    
//  transform(categories: any, searchText?: any): any {
//    console.log('searchText value in transform function  :', categories , searchText);
//    
//    if(searchText == null) {
//      return categories;
//    }
//       
//     return categories.filter( category => {
//         let found   = false;
//         found = (category.refSerDescr.toLowerCase().indexOf(searchText.toLowerCase()) > -1 );
//
//         if( found ) return found;
//
//         console.log('searchText value in transform function  : found:', found );
//         category.docContents = category.docContents.filter(
//            content => {
//                return ( ( content.descr.toLowerCase().indexOf(searchText.toLowerCase()) > -1 ) 
//                  || ( content.shDescr.toLowerCase().indexOf(searchText.toLowerCase()) > -1 ) );
//            }
//          );
//         console.log('searchText value in transform function  docContents :', category.docContents);
//          if( !found && category.docContents && category.docContents.length > 0 )
//          {
//            found   = true;
//          }
//           return found;
//        })
//  }

}
