import { Component, OnInit, Input } from '@angular/core';
import { SearchByPipe } from '../shared/pipes/search-by.pipe';

@Component({
  selector: 'content-search',
  templateUrl: './content-search.component.html',
  styleUrls: ['./content-search.component.css'],
  providers: [SearchByPipe]
})
export class ContentSearchComponent implements OnInit {

  @Input() searchValue: any;
  @Input() docContents: any;
  searchResults: any;
    
  constructor(private searchByPipe: SearchByPipe) { }

  ngOnInit() {
  }
  
  ngOnChanges(){
      if(this.searchValue){
          this.searchResults = this.searchByPipe.transform(this.docContents, this.searchValue);
      }
  }

}
