import { Component, OnInit, Output, EventEmitter, ViewChild, ElementRef, ViewEncapsulation, NgZone} from '@angular/core';
import { ContentsSandbox } from '../shared/sandbox/content.sandbox';
import { Router } from '@angular/router';

@Component({
  selector: 'content-manager',
  templateUrl: './content-manager.component.html',
  styleUrls: ['./content-manager.component.css']
})
export class ContentManagerComponent implements OnInit {

  title = 'app';
  selectedPagees: any[] = [];
  content: any ;
  subtitle: any ;
  selectedTranObj: any ;
  fileType: any;
  @ViewChild('pdfMngEl') pdfMngEl: any;
  @ViewChild('htmlMngEl') htmlMngEl: any;
  //pdf_url;
  constructor(public contentSandbox: ContentsSandbox,  private router: Router, public zone:NgZone ) {
    // Added by Pravin K on 09-OCT-18 [for the issue of new added transaction] START
    let that = this;
    setTimeout(function() {
      that.zone.run(() => {
        console.log('.view refreshed constructor..');
      });
    }, 1);
   // Added by Pravin K on 09-OCT-18 [for the issue of new added transaction] END
  }
  ngOnInit() {

    console.log(' this.contentSandbox.getSelectedContent()', this.contentSandbox.getSelectedContent());
    this.content = this.contentSandbox.getSelectedContent();
    this.subtitle = this.content.docName!.trim();
    this.fileType = this.content.fileType!.trim();
    console.log("fileType for pdf and zip[",this.subtitle,"][",this.fileType,"]");
    var currTranId =  this.contentSandbox.getSelectedTranId();
    //this.pdf_url = "http://192.168.0.252:9090/ibase/DocumentViewerServlet?ACTION=GET_DOCUMENT&DOC_ID="+ this.content.docId +"&DOC_TYPE=pdf";
  }

 @Output() onSelectChange : EventEmitter<any> = new EventEmitter();

 onDone()
 {
   //pdfMngEl.done();
   //this.router.navigateByUrl('assocTransactions', { skipLocationChange: true ,queryParams: { "reqFrom": "from pdf-manager" } });
   if(this.fileType  === 'pdf' )
   {
       this.pdfMngEl.done();
   }
   else if(this.fileType  === 'zip' )
   {
       this.htmlMngEl.doneHtml();
   }
   this.router.navigateByUrl('assocTransactions', { skipLocationChange: true });
  }

  close(){
      //this.onClose.emit();
     // this.contentSandbox.onAssocOption.emit(false);
     // this.removeCurrentTransactionObject();
      this.router.navigateByUrl('assocTransactions', { skipLocationChange: true } );
  }
  closePanel() {
      this.contentSandbox.onAssocOption.emit(false);
  }
  removeCurrentTransactionObject()
  {
   // var allSelectedTranObjects = this.contentSandbox.getSelectedAllTranObjects();
    //delete allSelectedTranObjects[this.contentSandbox.getSelectedTranId()];
  }

}
