import { Component, OnInit, OnChanges, Input, Output, EventEmitter } from '@angular/core';
import { MatSnackBar } from '@angular/material/snack-bar';

import { ContentHomeComponent } from '../content-home/content-home.component'
import { Content } from '../shared/models';
import { ContentsSandbox } from '../shared/sandbox';
import { ContentService } from '../shared/services/content.service';
import { OrderbyDatePipe } from '../shared/pipes/orderby-date.pipe';
import { changeThemeColor } from '../../../plugin/utils/theme-selector-util';

@Component( {
    selector: 'content-list',
    templateUrl: './content-list.component.html',
    styleUrls: ['./content-list.component.css'],
    providers : [OrderbyDatePipe ]

})
export class ContentListComponent implements OnInit, OnChanges  {

    @Input() showAll: any;
    @Input() refSerDescr: any;
    @Input() displayLength = 10;
    @Input() contentList: any;
    @Input() isSearchResult: any;
    
    themeColor: any ;
  
    HOST_URL : string | any;
    visibleList: any;
    time: any;
    detailOpts: any;
    sortBy: any;
    userRights: any = [];
    docTypeList: any[] = [];
    fileTypeList: any[] = [];
   // actTypeList = [];
    typeList: any[] = [];

    constructor( private contentComponent: ContentHomeComponent, public contentSandbox: ContentsSandbox, public contentService: ContentService, public snackBar: MatSnackBar , private orderbyDatePipe :OrderbyDatePipe) { }

    ngOnInit() {
        this.themeColor = localStorage.getItem('themeColor');
        if( this.themeColor ){
          changeThemeColor(this.themeColor);
        }
        
       this.HOST_URL = this.contentSandbox.getHostUrl();
       this.contentService.onFilterPin.subscribe( isShowPinned => {
            //console.log( 'isShowPinned changed:[' + isShowPinned );
            if ( isShowPinned ) {
                this.filterList();
                //this.displayLength = this.visibleList.length;
                //this.showAll = true;
            }
            else {
                this.visibleList = this.contentList;
                //this.displayLength = 5;
            }
            this.setPinnedContentStatus();
        });
       
       if(this.contentSandbox.getPluginMetadata()){
           this.detailOpts = this.contentSandbox.getPluginMetadata().detailOpts;
       }
       
       this.contentService.onSortChange.subscribe(
               value => {
                 console.log("value in CONTENT-LIST------------------>" ,value );
                 this.sortBy = value;
                 this.visibleList = this.orderbyDatePipe.transform(this.visibleList, this.sortBy);
               }
       ); 
       
       this.contentService.onSelectContent.subscribe(
            x => {
                this.visibleList = this.orderbyDatePipe.transform(this.visibleList, this.sortBy);
                console.log('onSelectContent emitted',this.visibleList);
            }
        );
       /*add it for obj actions */
       this.userRights= this.contentSandbox.userRights;
       
    }

    ngOnChanges() {
        //console.log( 'OnChanges of Content List called ContentList:', this.contentList );
        this.visibleList = this.contentList;
        this.setPinnedContentStatus();
        this.sortBy = this.contentService.sortBy;
        this.visibleList = this.orderbyDatePipe.transform(this.visibleList, this.sortBy);
    }

    filterList() {
        this.visibleList = this.contentList.filter(
            (content: any) => {
                return content.pinned === 'Y'
            }
        );

    }
 
    onSelect( contentCard: any ) {
        //console.log( '**Selected Content**', contentCard );
        this.contentService.selectContent(contentCard.content);
        //contentCard.openDialog( selContentDetail );
    }

    onChange( content: Content ) {
        //console.log( 'Updated Content', content );
        this.contentSandbox.updateContent( content );

        if ( content.pinned == 'Y' ) {
            this.openSnackBar( 'Content Pinned' );
        }
        else {
            this.openSnackBar( 'Content Unpinned' );
        }
    }

    openSnackBar( message: string ) {
        this.snackBar.open( message, '', {
            duration: 2000,
        });
    }

    dispDateFormat = 'dd MMM yyyy - EEEE';
    
    setPinnedContentStatus(){
        let pinnedList = this.visibleList.filter(
                (content: any) => {
                    return content.pinned === 'Y'
                }
        );
        
        //console.log('pinnedList---',pinnedList);
        
        if(pinnedList.length == 0){
            this.contentService.setPinnedContentStatus(false);
        }else {
            this.contentService.setPinnedContentStatus(true);
        }
    }
    
    manageUserRights(userRights: any)
    {
        if(userRights && userRights.includes('*'))
        {
            this.userRights = [];
            this.userRights.push('R','S','C','V','O');
        }
        else
        {
            this.userRights = userRights.split('');
        }
        console.log("this.userRights " ,this.userRights );
    }



}
